<?php



namespace App\Http\Controllers\Payment;



use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Models\CustomerPackage;

use App\Models\SellerPackage;

use App\Models\CombinedOrder;

use App\Http\Controllers\CustomerPackageController;

use App\Http\Controllers\SellerPackageController;

use App\Http\Controllers\WalletController;

use App\Http\Controllers\CheckoutController;

use Session;

use Auth;



class KonnectController extends Controller

{

    public function pay(){

        if (Auth::user()->phone == null) {

            flash('Priere d\'ajouter votre numero de telephone')->warning();

            return redirect()->route('profile');

        }

        

        if (Auth::user()->email == null) {

            $email = 'customer@xiri.tn';

        }

        else{

            $email = Auth::user()->email;

        }



        if (get_setting('Konnect_sandbox') == 1) {

            $url = 'https://api.preprod.konnect.network/api/v2/payments/init-payment'; 

        }

        else {

            $url = 'https://api.konnect.network/api/v2/payments/init-payment';

        }

        $api_key="63a2ca5d08ec811bcda5a29d:MqpfFQs7TV1cISVXMGm6uUTtN2rtkF";



        $amount = 0;

        if(Session::has('payment_type')){

            if(Session::get('payment_type') == 'cart_payment'){

                $combined_order = CombinedOrder::findOrFail(Session::get('combined_order_id'));

                $amount = round($combined_order->grand_total);

            }

            elseif (Session::get('payment_type') == 'wallet_payment') {

                $amount = round(Session::get('payment_data')['amount']);

            }

            elseif (Session::get('payment_type') == 'customer_package_payment') {

                $customer_package = CustomerPackage::findOrFail(Session::get('payment_data')['customer_package_id']);

                $amount = round($customer_package->amount);

            }

            elseif (Session::get('payment_type') == 'seller_package_payment') {

                $seller_package = SellerPackage::findOrFail(Session::get('payment_data')['seller_package_id']);

                $amount = round($seller_package->amount);

            }

        }



        $fields = array(


            'x-api-key' => "63a2c871bcffd2626b1638c2:VOj7UWv4aL47d4irrGnwGzW",

            'receiverWalletId' => env('KONNECT_CLIENT_ID'),
           
            'token' => "TND",

            'amount' => $amount,

            'type' => 'immediate',

            'description' => env('APP_NAME').' payment',

            'lifespan' => 10,

            'feesIncluded' => true,

            'firstName' => Auth::user()->name,

            'lastName' => Auth::user()->name,

            'phoneNumber' => Auth::user()->phone,

            'email' => $email,

            'orderId' => Session::get('combined_order_id'),

            'webhook' => "https://merchant.tech/api/notification_payment",

            'silentWebhook' => true,

            'successUrl' => "https://dev.konnect.network/gateway/payment-success",

            'failUrl' => "https://dev.konnect.network/gateway/payment-failure",
            
            // 'success_url' => route('Konnect.success'), //your success route

            // 'fail_url' => route('Konnect.fail'), //your fail route
            
            
            'checkoutForm' => true,

            'acceptedPaymentMethods' =>  [
                "wallet",
                "bank_card",
                "e-DINAR"
                ]


          

        );



        $fields_string = http_build_query($fields);
        $headers = array("Authorization: x-api-key " . $api_key);



        $ch = curl_init();

        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        curl_setopt($ch, CURLOPT_VERBOSE, true);

        curl_setopt($ch, CURLOPT_URL, $url);



        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

        $url_forward = str_replace('"', '', stripslashes(curl_exec($ch)));

        curl_close($ch);


// ==========================================================================================================================
        // $headers = array("Authorization: Token " . $api_key);
        // $curl_post_data = array('x-api-key' => "63a2ca5d08ec811bcda5a29d:MqpfFQs7TV1cISVXMGm6uUTtN2rtkF",);
        // $curl_handle=curl_init($url);
        // curl_setopt($curl_handle, CURLOPT_RETURNTRANSFER, 1);
        // curl_setopt($curl_handle, CURLOPT_HTTPHEADER, $headers);
        // curl_setopt($curl_handle, CURLOPT_POST, true);
        // curl_setopt($curl_handle, CURLOPT_POSTFIELDS, $curl_post_data);

        // $url_forward = str_replace('"', '', stripslashes(curl_exec($url)));
        // $query = json_decode(curl_exec($curl_handle), true);
        // curl_close($curl_handle);


        $this->redirect_to_merchant($url_forward);

    }



    function redirect_to_merchant($url) {

        if (get_setting('Konnect_sandbox') == 1) {

            $base_url = 'https://api.preprod.konnect.network/api/v2/payments/init-payment';

        }

        else {

            $base_url = 'https://api.konnect.network/api/v2/payments/init-payment';

        }



        ?>

        <html xmlns="http://www.w3.org/1999/xhtml">

          <head><script type="text/javascript">

            function closethisasap() { document.forms["redirectpost"].submit(); }

          </script></head>

          <body onLoad="closethisasap();">



            <form name="redirectpost" method="post" action="<?php echo $base_url.$url; ?>"></form>



          </body>

        </html>

        <?php

        exit;

    }





    public function success(Request $request){

        $payment_type = $request->opt_a;



        if ($payment_type == 'cart_payment') {

            return (new CheckoutController)->checkout_done($request->opt_b, json_encode($request->all()));

        }



        if ($payment_type == 'wallet_payment') {

            return (new WalletController)->wallet_payment_done(json_decode($request->opt_c), json_encode($request->all()));

        }



        if ($payment_type == 'customer_package_payment') {

            return (new CustomerPackageController)->purchase_payment_done(json_decode($request->opt_c), json_encode($request->all()));

        }

        if($payment_type == 'seller_package_payment') {

            return (new SellerPackageController)->purchase_payment_done(json_decode($request->opt_c), json_encode($request->all()));

        }

    }



    public function fail(Request $request){

        flash(translate('Payment failed'))->error();

    	return redirect()->route('cart');

    }

}

