<!DOCTYPE html>

@if(\App\Models\Language::where('code', Session::get('locale', Config::get('app.locale')))->first()->rtl == 1)

<html dir="rtl" lang="{{ str_replace('_', '-', app()->getLocale()) }}">

@else

<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

@endif

<head>



    <meta name="csrf-token" content="{{ csrf_token() }}">

    <meta name="app-url" content="{{ getBaseURL() }}">

    <meta name="file-base-url" content="{{ getFileBaseURL() }}">



    <title>@yield('meta_title', get_setting('website_name').' | '.get_setting('site_motto'))</title>



    <meta charset="utf-8">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <meta name="robots" content="index, follow">

    <meta name="description" content="@yield('meta_description', get_setting('meta_description') )" />

    <meta name="keywords" content="@yield('meta_keywords', get_setting('meta_keywords') )">



    @yield('meta')



    @if(!isset($detailedProduct) && !isset($customer_product) && !isset($shop) && !isset($page) && !isset($blog))

        <!-- Schema.org markup for Google+ -->

        <meta itemprop="name" content="{{ get_setting('meta_title') }}">

        <meta itemprop="description" content="{{ get_setting('meta_description') }}">

        <meta itemprop="image" content="{{ uploaded_asset(get_setting('meta_image')) }}">



        <!-- Twitter Card data -->

        <meta name="twitter:card" content="product">

        <meta name="twitter:site" content="@publisher_handle">

        <meta name="twitter:title" content="{{ get_setting('meta_title') }}">

        <meta name="twitter:description" content="{{ get_setting('meta_description') }}">

        <meta name="twitter:creator" content="@author_handle">

        <meta name="twitter:image" content="{{ uploaded_asset(get_setting('meta_image')) }}">



        <!-- Open Graph data -->

        <meta property="og:title" content="{{ get_setting('meta_title') }}" />

        <meta property="og:type" content="website" />

        <meta property="og:url" content="{{ route('home') }}" />

        <meta property="og:image" content="{{ uploaded_asset(get_setting('meta_image')) }}" />

        <meta property="og:description" content="{{ get_setting('meta_description') }}" />

        <meta property="og:site_name" content="{{ env('APP_NAME') }}" />

        <meta property="fb:app_id" content="{{ env('FACEBOOK_PIXEL_ID') }}">

    @endif



    <!-- Favicon -->

    <link rel="icon" href="{{ uploaded_asset(get_setting('site_icon')) }}">


    <!-- Lien google search console -->

    <link rel="canonical" href="https://www.xiri.tn">



    <!-- Google Fonts -->

    <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i,800,800i&display=swap" rel="stylesheet">



    <!-- CSS Files -->

    <link rel="stylesheet" href="{{ static_asset('assets/css/vendors.css') }}">

    @if(\App\Models\Language::where('code', Session::get('locale', Config::get('app.locale')))->first()->rtl == 1)

    <link rel="stylesheet" href="{{ static_asset('assets/css/bootstrap-rtl.min.css') }}">

    @endif

    <link rel="stylesheet" href="{{ static_asset('assets/css/aiz-core.css') }}">

    <link rel="stylesheet" href="{{ static_asset('assets/css/custom-style.css') }}">





    <script>

        var AIZ = AIZ || {};

        AIZ.local = {

            nothing_selected: '{!! translate('Nothing selected', null, true) !!}',

            nothing_found: '{!! translate('Nothing found', null, true) !!}',

            choose_file: '{{ translate('Choose file') }}',

            file_selected: '{{ translate('File selected') }}',

            files_selected: '{{ translate('Files selected') }}',

            add_more_files: '{{ translate('Add more files') }}',

            adding_more_files: '{{ translate('Adding more files') }}',

            drop_files_here_paste_or: '{{ translate('Drop files here, paste or') }}',

            browse: '{{ translate('Browse') }}',

            upload_complete: '{{ translate('Upload complete') }}',

            upload_paused: '{{ translate('Upload paused') }}',

            resume_upload: '{{ translate('Resume upload') }}',

            pause_upload: '{{ translate('Pause upload') }}',

            retry_upload: '{{ translate('Retry upload') }}',

            cancel_upload: '{{ translate('Cancel upload') }}',

            uploading: '{{ translate('Uploading') }}',

            processing: '{{ translate('Processing') }}',

            complete: '{{ translate('Complete') }}',

            file: '{{ translate('File') }}',

            files: '{{ translate('Files') }}',

        }

    </script>



    <style>

        body{

            font-family: 'Open Sans', sans-serif;

            font-weight: 400;

        }

        :root{

            --primary: {{ get_setting('base_color', '#e62d04') }};

            --hov-primary: {{ get_setting('base_hov_color', '#c52907') }};

            --soft-primary: {{ hex2rgba(get_setting('base_color','#e62d04'),.15) }};

        }



        #map{

            width: 100%;

            height: 250px;

        }

        #edit_map{

            width: 100%;

            height: 250px;

        }



        .pac-container { z-index: 100000; }

    </style>



@if (get_setting('google_analytics') == 1)

    <!-- Global site tag (gtag.js) - Google Analytics -->

    <script async src="https://www.googletagmanager.com/gtag/js?id={{ env('TRACKING_ID') }}"></script>



    <script>

        window.dataLayer = window.dataLayer || [];

        function gtag(){dataLayer.push(arguments);}

        gtag('js', new Date());

        gtag('config', '{{ env('TRACKING_ID') }}');

    </script>

@endif



@if (get_setting('facebook_pixel') == 1)

    <!-- Facebook Pixel Code -->

    <script>

        !function(f,b,e,v,n,t,s)

        {if(f.fbq)return;n=f.fbq=function(){n.callMethod?

        n.callMethod.apply(n,arguments):n.queue.push(arguments)};

        if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';

        n.queue=[];t=b.createElement(e);t.async=!0;

        t.src=v;s=b.getElementsByTagName(e)[0];

        s.parentNode.insertBefore(t,s)}(window, document,'script',

        'https://connect.facebook.net/en_US/fbevents.js');

        fbq('init', '{{ env('FACEBOOK_PIXEL_ID') }}');

        fbq('track', 'PageView');

    </script>

    <noscript>

        <img height="1" width="1" style="display:none" src="https://www.facebook.com/tr?id={{ env('FACEBOOK_PIXEL_ID') }}&ev=PageView&noscript=1"/>

    </noscript>

    <!-- End Facebook Pixel Code -->

@endif



@php

    echo get_setting('header_script');

@endphp



</head>

<body>

    <!-- aiz-main-wrapper -->

    <div class="aiz-main-wrapper d-flex flex-column">



        <!-- Header -->

        @include('frontend.inc.nav')



        @yield('content')



        @include('frontend.inc.footer')



    </div>



    @if (get_setting('show_cookies_agreement') == 'on')

        <div class="aiz-cookie-alert shadow-xl">

            <div class="p-3 bg-dark rounded">

                <div class="text-white mb-3">

                    @php

                        echo get_setting('cookies_agreement_text');

                    @endphp

                </div>

                <button class="btn btn-primary aiz-cookie-accept">

                    {{ translate('Ok. I Understood') }}

                </button>

            </div>

        </div>

    @endif



    @if (get_setting('show_website_popup') == 'on')

        <div class="modal website-popup removable-session d-none" data-key="website-popup" data-value="removed">

            <div class="absolute-full bg-black opacity-60"></div>

            <div class="modal-dialog modal-dialog-centered modal-dialog-zoom modal-md">

                <div class="modal-content position-relative border-0 rounded-0">

                    <div class="aiz-editor-data">

                        {!! get_setting('website_popup_content') !!}

                    </div>

                    @if (get_setting('show_subscribe_form') == 'on')

                        <div class="pb-5 pt-4 px-5">

                            <form class="" method="POST" action="{{ route('subscribers.store') }}">

                                @csrf

                                <div class="form-group mb-0">

                                    <input type="email" class="form-control" placeholder="{{ translate('Your Email Address') }}" name="email" required>

                                </div>

                                <button type="submit" class="btn btn-primary btn-block mt-3">

                                    {{ translate('Subscribe Now') }}

                                </button>

                            </form>

                        </div>

                    @endif

                    <button class="absolute-top-right bg-white shadow-lg btn btn-circle btn-icon mr-n3 mt-n3 set-session" data-key="website-popup" data-value="removed" data-toggle="remove-parent" data-parent=".website-popup">

                        <i class="la la-close fs-20"></i>

                    </button>

                </div>

            </div>

        </div>

    @endif



    @include('frontend.partials.modal')

    

    @include('frontend.partials.account_delete_modal')



    <div class="modal fade" id="addToCart">

        <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-zoom product-modal" id="modal-size" role="document">

            <div class="modal-content position-relative">

                <div class="c-preloader text-center p-3">

                    <i class="las la-spinner la-spin la-3x"></i>

                </div>

                <button type="button" class="close absolute-top-right btn-icon close z-1" data-dismiss="modal" aria-label="Close">

                    <span aria-hidden="true" class="la-2x">&times;</span>

                </button>

                <div id="addToCart-modal-body">



                </div>

            </div>

        </div>

    </div>



    @yield('modal')



    <!-- SCRIPTS -->

    <script src="{{ static_asset('assets/js/vendors.js') }}"></script>

    <script src="{{ static_asset('assets/js/aiz-core.js') }}"></script>







    @if (get_setting('facebook_chat') == 1)

        <script type="text/javascript">

            window.fbAsyncInit = function() {

                FB.init({

                  xfbml            : true,

                  version          : 'v3.3'

                });

              };



              (function(d, s, id) {

              var js, fjs = d.getElementsByTagName(s)[0];

              if (d.getElementById(id)) return;

              js = d.createElement(s); js.id = id;

              js.src = 'https://connect.facebook.net/en_US/sdk/xfbml.customerchat.js';

              fjs.parentNode.insertBefore(js, fjs);

            }(document, 'script', 'facebook-jssdk'));

        </script>

        <div id="fb-root"></div>

        <!-- Your customer chat code -->

        <div class="fb-customerchat"

          attribution=setup_tool

          page_id="{{ env('FACEBOOK_PAGE_ID') }}">

        </div>

    @endif



    <script>

        @foreach (session('flash_notification', collect())->toArray() as $message)

            AIZ.plugins.notify('{{ $message['level'] }}', '{{ $message['message'] }}');

        @endforeach

    </script>



    <script>



        $(document).ready(function() {

            $('.category-nav-element').each(function(i, el) {

                $(el).on('mouseover', function(){

                    if(!$(el).find('.sub-cat-menu').hasClass('loaded')){

                        $.post('{{ route('category.elements') }}', {_token: AIZ.data.csrf, id:$(el).data('id')}, function(data){

                            $(el).find('.sub-cat-menu').addClass('loaded').html(data);

                        });

                    }

                });

            });

            if ($('#lang-change').length > 0) {

                $('#lang-change .dropdown-menu a').each(function() {

                    $(this).on('click', function(e){

                        e.preventDefault();

                        var $this = $(this);

                        var locale = $this.data('flag');

                        $.post('{{ route('language.change') }}',{_token: AIZ.data.csrf, locale:locale}, function(data){

                            location.reload();

                        });



                    });

                });

            }



            if ($('#currency-change').length > 0) {

                $('#currency-change .dropdown-menu a').each(function() {

                    $(this).on('click', function(e){

                        e.preventDefault();

                        var $this = $(this);

                        var currency_code = $this.data('currency');

                        $.post('{{ route('currency.change') }}',{_token: AIZ.data.csrf, currency_code:currency_code}, function(data){

                            location.reload();

                        });



                    });

                });

            }

        });



        $('#search').on('keyup', function(){

            search();

        });



        $('#search').on('focus', function(){

            search();

        });



        function search(){

            var searchKey = $('#search').val();

            if(searchKey.length > 0){

                $('body').addClass("typed-search-box-shown");



                $('.typed-search-box').removeClass('d-none');

                $('.search-preloader').removeClass('d-none');

                $.post('{{ route('search.ajax') }}', { _token: AIZ.data.csrf, search:searchKey}, function(data){

                    if(data == '0'){

                        // $('.typed-search-box').addClass('d-none');

                        $('#search-content').html(null);

                        $('.typed-search-box .search-nothing').removeClass('d-none').html('{{ translate('Sorry, nothing found for') }} <strong>"'+searchKey+'"</strong>');

                        $('.search-preloader').addClass('d-none');



                    }

                    else{

                        $('.typed-search-box .search-nothing').addClass('d-none').html(null);

                        $('#search-content').html(data);

                        $('.search-preloader').addClass('d-none');

                    }

                });

            }

            else {

                $('.typed-search-box').addClass('d-none');

                $('body').removeClass("typed-search-box-shown");

            }

        }



        function updateNavCart(view,count){

            $('.cart-count').html(count);

            $('#cart_items').html(view);

        }



        function removeFromCart(key){

            $.post('{{ route('cart.removeFromCart') }}', {

                _token  : AIZ.data.csrf,

                id      :  key

            }, function(data){

                updateNavCart(data.nav_cart_view,data.cart_count);

                $('#cart-summary').html(data.cart_view);

                AIZ.plugins.notify('success', "{{ translate('Item has been removed from cart') }}");

                $('#cart_items_sidenav').html(parseInt($('#cart_items_sidenav').html())-1);

            });

        }



        function addToCompare(id){

            $.post('{{ route('compare.addToCompare') }}', {_token: AIZ.data.csrf, id:id}, function(data){

                $('#compare').html(data);

                AIZ.plugins.notify('success', "{{ translate('Item has been added to compare list') }}");

                $('#compare_items_sidenav').html(parseInt($('#compare_items_sidenav').html())+1);

            });

        }



        function addToWishList(id){

            @if (Auth::check() && Auth::user()->user_type == 'customer')

                $.post('{{ route('wishlists.store') }}', {_token: AIZ.data.csrf, id:id}, function(data){

                    if(data != 0){

                        $('#wishlist').html(data);

                        AIZ.plugins.notify('success', "{{ translate('Item has been added to wishlist') }}");

                    }

                    else{

                        AIZ.plugins.notify('warning', "{{ translate('Please login first') }}");

                    }

                });

            @elseif(Auth::check() && Auth::user()->user_type != 'customer')

                AIZ.plugins.notify('warning', "{{ translate('Please Login as a customer to add products to the WishList.') }}");

            @else

                AIZ.plugins.notify('warning', "{{ translate('Please login first') }}");

            @endif

        }



        function showAddToCartModal(id){

            if(!$('#modal-size').hasClass('modal-lg')){

                $('#modal-size').addClass('modal-lg');

            }

            $('#addToCart-modal-body').html(null);

            $('#addToCart').modal();

            $('.c-preloader').show();

            $.post('{{ route('cart.showCartModal') }}', {_token: AIZ.data.csrf, id:id}, function(data){

                $('.c-preloader').hide();

                $('#addToCart-modal-body').html(data);

                AIZ.plugins.slickCarousel();

                AIZ.plugins.zoom();

                AIZ.extra.plusMinus();

                getVariantPrice();

            });

        }



        $('#option-choice-form input').on('change', function(){

            getVariantPrice();

        });



        function getVariantPrice(){

            if($('#option-choice-form input[name=quantity]').val() > 0 && checkAddToCartValidity()){

                $.ajax({

                   type:"POST",

                   url: '{{ route('products.variant_price') }}',

                   data: $('#option-choice-form').serializeArray(),

                   success: function(data){



                        $('.product-gallery-thumb .carousel-box').each(function (i) {

                            if($(this).data('variation') && data.variation == $(this).data('variation')){

                                $('.product-gallery-thumb').slick('slickGoTo', i);

                            }

                        })



                        $('#option-choice-form #chosen_price_div').removeClass('d-none');

                        $('#option-choice-form #chosen_price_div #chosen_price').html(data.price);

                        $('#available-quantity').html(data.quantity);

                        $('.input-number').prop('max', data.max_limit);

                        if(parseInt(data.in_stock) == 0 && data.digital  == 0){

                           $('.buy-now').addClass('d-none');

                           $('.add-to-cart').addClass('d-none');

                           $('.out-of-stock').removeClass('d-none');

                        }

                        else{

                           $('.buy-now').removeClass('d-none');

                           $('.add-to-cart').removeClass('d-none');

                           $('.out-of-stock').addClass('d-none');

                        }



                        AIZ.extra.plusMinus();

                   }

               });

            }

        }



        function checkAddToCartValidity(){

            var names = {};

            $('#option-choice-form input:radio').each(function() { // find unique names

                names[$(this).attr('name')] = true;

            });

            var count = 0;

            $.each(names, function() { // then count them

                count++;

            });



            if($('#option-choice-form input:radio:checked').length == count){

                return true;

            }



            return false;

        }



        function addToCart(){

            @if(Auth::check() && Auth::user()->user_type != 'customer')

                AIZ.plugins.notify('warning', "{{ translate('Please Login as a customer to add products to the Cart.') }}");

                return false;

            @endif



            if(checkAddToCartValidity()) {

                $('#addToCart').modal();

                $('.c-preloader').show();

                $.ajax({

                    type:"POST",

                    url: '{{ route('cart.addToCart') }}',

                    data: $('#option-choice-form').serializeArray(),

                    success: function(data){



                       $('#addToCart-modal-body').html(null);

                       $('.c-preloader').hide();

                       $('#modal-size').removeClass('modal-lg');

                       $('#addToCart-modal-body').html(data.modal_view);

                       AIZ.extra.plusMinus();

                       AIZ.plugins.slickCarousel();

                       updateNavCart(data.nav_cart_view,data.cart_count);

                    }

                });

            }

            else{

                AIZ.plugins.notify('warning', "{{ translate('Please choose all the options') }}");

            }

        }



        function buyNow(){

            @if(Auth::check() && Auth::user()->user_type != 'customer')

                AIZ.plugins.notify('warning', "{{ translate('Please Login as a customer to add products to the Cart.') }}");

                return false;

            @endif

            

            if(checkAddToCartValidity()) {

                $('#addToCart-modal-body').html(null);

                $('#addToCart').modal();

                $('.c-preloader').show();

                $.ajax({

                   type:"POST",

                   url: '{{ route('cart.addToCart') }}',

                   data: $('#option-choice-form').serializeArray(),

                   success: function(data){

                       if(data.status == 1){



                            $('#addToCart-modal-body').html(data.modal_view);

                            updateNavCart(data.nav_cart_view,data.cart_count);



                            window.location.replace("{{ route('cart') }}");

                       }

                       else{

                            $('#addToCart-modal-body').html(null);

                            $('.c-preloader').hide();

                            $('#modal-size').removeClass('modal-lg');

                            $('#addToCart-modal-body').html(data.modal_view);

                       }

                   }

               });

            }

            else{

                AIZ.plugins.notify('warning', "{{ translate('Please choose all the options') }}");

            }

        }



    </script>



    @yield('script')



    @php

        echo get_setting('footer_script');

    @endphp



</body>

</html>

