const mix = require('laravel-mix');

mix.js('resources/js/app.js', '../assets/js')
    .sass('resources/scss/app.scss', '../assets/css')
    .options(
        {
            postCss: [
                require('postcss-discard-comments')({
                    removeAll: true,
                }),
            ],
        },
    )
    .setPublicPath('../')
    .setResourceRoot('../../') // https://github.com/JeffreyWay/laravel-mix/issues/1026
    //.sourceMaps()
    .version();

if (!mix.inProduction()) {
    mix.sourceMaps().webpackConfig({
        devtool: 'source-map',
    });
}
