<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;

class AdminController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Execute an action on the controller.
     *
     * @param string $method
     * @param array $parameters
     * @return \Symfony\Component\HttpFoundation\Response
     * @throws \Illuminate\Auth\Access\AuthorizationException
     */
    public function callAction($method, $parameters)
    {
        $this->licenseCheck();
        return parent::callAction($method, $parameters);
    }

    protected function licenseCheck()
    {
        if (\request()->route()->getPrefix() !== '/admin') {
            return;
        }

        if (\auth()->user()->role !== 'admin') {
            return;
        }

        if ($this->licenseActivate()) {
            if (!\Illuminate\Support\Facades\Gate::allows('super_admin')) {
                exit('The super admin should activate the system first.');
            }

            \redirect()->route('admin.activation')->setStatusCode(307)->send();
            exit();
        }
    }

    /**
     * @return bool
     */
    protected function licenseActivate(): bool
    {
        if (\require_database_upgrade()) {
            return false;
        }

        if (\App\Helpers\Activation::checkLicense() === false &&
            \strpos(\request()->route()->getAction('controller'), 'ActivationController') === false) {
            return true;
        }

        return false;
    }
}
