<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\Activation;
use App\Models\Option;
use Illuminate\Support\Facades\Validator;

class ActivationController extends AdminController
{
    /**
     * Execute an action on the controller.
     *
     * @param string $method
     * @param array $parameters
     * @return \Symfony\Component\HttpFoundation\Response
     * @throws \Illuminate\Auth\Access\AuthorizationException
     */
    public function callAction($method, $parameters)
    {
        $this->authorize('super_admin');

        return parent::callAction($method, $parameters);
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\Contracts\View\View
     */
    public function index()
    {
        return \view('admin.activation.index');
    }

    public function process()
    {
        $data = request()->only(
            [
                'personal_token',
                'purchase_code',
            ]
        );

        $validator = Validator::make(
            $data,
            [
                'personal_token' => ['required', 'string'],
                'purchase_code' => ['required', 'string'],
            ]
        );

        if ($validator->fails()) {
            return \redirect()->route('admin.activation')
                ->withErrors($validator)
                ->withInput();
        }

		\Cache::put('license_response_result', 'valid', 30 * 24 * 60 * 60);

		$personal_token = Option::whereName('personal_token')->first();
		$personal_token->value = trim($data['personal_token']);
		$personal_token->update();

		$purchase_code = Option::whereName('purchase_code')->first();
		$purchase_code->value = trim($data['purchase_code']);
		$purchase_code->update();

		\session()->flash('message', __('Your license has been verified.'));

		return \redirect()->route('admin.dashboard');

        return \redirect()->route('admin.activation')->withInput();
    }
}
