<?php namespace MyFatoorah\Library; use MyFatoorah\Library\MyfatoorahApiV2; use Exception; class  PaymentMyfatoorahApiV2 extends MyfatoorahApiV2{protected $isDirectPayment=false;public static $pmCachedFile=__DIR__.'/mf-methods.json';protected static $paymentMethods;public function getVendorGateways($invoiceValue=0,$displayCurrencyIso='',$isCached=false){$postFields=['InvoiceAmount'=>$invoiceValue,'CurrencyIso'=>$displayCurrencyIso,];$json=$this->callAPI("$this->apiURL/v2/InitiatePayment",$postFields,null,'Initiate Payment');$paymentMethods=isset($json->Data->PaymentMethods)?$json->Data->PaymentMethods:[];if(!empty($paymentMethods)&&$isCached){file_put_contents(self::$pmCachedFile,json_encode($paymentMethods));}return $paymentMethods;}public function getCachedVendorGateways(){if(file_exists(self::$pmCachedFile)){$cache=file_get_contents(self::$pmCachedFile);return($cache)?json_decode($cache):[];}else{return $this->getVendorGateways(0,'',true);}}public function getVendorGatewaysByType($isDirect=false){$gateways=$this->getCachedVendorGateways();$paymentMethods=['cards'=>[],'direct'=>[],];foreach($gateways as $g){if($g->IsDirectPayment){$paymentMethods['direct'][]=$g;}elseif($g->PaymentMethodCode!='ap'){$paymentMethods['cards'][]=$g;}elseif($this->isAppleSystem()){$paymentMethods['cards'][]=$g;}}return($isDirect)?$paymentMethods['direct']:$paymentMethods['cards'];}public function getCachedPaymentMethods($isAppleRegistered=false){$gateways=$this->getCachedVendorGateways();$paymentMethods=['all'=>[],'cards'=>[],'form'=>[],'ap'=>[]];foreach($gateways as $g){$paymentMethods=$this->fillPaymentMethodsArray($g,$paymentMethods,$isAppleRegistered);}$paymentMethods['ap']=(isset($paymentMethods['ap'][0]))?$paymentMethods['ap'][0]:[];return $paymentMethods;}public function getPaymentMethodsForDisplay($invoiceValue,$displayCurrencyIso,$isAppleRegistered=false){if(!empty(self::$paymentMethods)){return self::$paymentMethods;}$gateways=$this->getVendorGateways($invoiceValue,$displayCurrencyIso);$allRates=$this->getCurrencyRates();self::$paymentMethods=['all'=>[],'cards'=>[],'form'=>[],'ap'=>[]];foreach($gateways as $g){$g->GatewayData=$this->calcGatewayData($g->TotalAmount,$g->CurrencyIso,$g->PaymentCurrencyIso,$allRates);self::$paymentMethods=$this->fillPaymentMethodsArray($g,self::$paymentMethods,$isAppleRegistered);}self::$paymentMethods['ap']=$this->getOneApplePayGateway(self::$paymentMethods['ap'],$displayCurrencyIso,$allRates);return self::$paymentMethods;}protected function getOneApplePayGateway($apGateways,$displayCurrency,$allRates){$displayCurrencyIndex=array_search($displayCurrency,array_column($apGateways,'PaymentCurrencyIso'));if($displayCurrencyIndex){return $apGateways[$displayCurrencyIndex];}$defCurKey=array_search('1',array_column($allRates,'Value'));$defaultCurrency=$allRates[$defCurKey]->Text;$defaultCurrencyIndex=array_search($defaultCurrency,array_column($apGateways,'PaymentCurrencyIso'));if($defaultCurrencyIndex){return $apGateways[$defaultCurrencyIndex];}if(isset($apGateways[0])){return $apGateways[0];}return[];}protected function fillPaymentMethodsArray($g,$paymentMethods,$isAppleRegistered=false){if($g->PaymentMethodCode!='ap'){if($g->IsEmbeddedSupported){$paymentMethods['form'][]=$g;$paymentMethods['all'][]=$g;}elseif(!$g->IsDirectPayment){$paymentMethods['cards'][]=$g;$paymentMethods['all'][]=$g;}}elseif($this->isAppleSystem()){if($isAppleRegistered){$paymentMethods['ap'][]=$g;}else{$paymentMethods['cards'][]=$g;}$paymentMethods['all'][]=$g;}return $paymentMethods;}protected static function isAppleSystem(){$userAgent=$_SERVER['HTTP_USER_AGENT'];if((stripos($userAgent,'iPod')||stripos($userAgent,'iPhone')||stripos($userAgent,'iPad')||stripos($userAgent,'Mac'))&&(self::getBrowserName($userAgent)=='Safari')){return true;}return false;}public static function getBrowserName($userAgent){$browsers=['Opera'=>['Opera','OPR/'],'Edge'=>['Edge'],'Chrome'=>['Chrome','CriOS'],'Firefox'=>['Firefox','FxiOS'],'Safari'=>['Safari'],'Internet Explorer'=>['MSIE','Trident/7'],];foreach($browsers as $browser=>$bArr){foreach($bArr as $needle){if(strpos($userAgent,$needle)){return $browser;}}}return 'Other';}public function getPaymentMethod($gateway,$gatewayType='PaymentMethodId',$invoiceValue=0,$displayCurrencyIso=''){$paymentMethods=$this->getVendorGateways($invoiceValue,$displayCurrencyIso);$pm=null;foreach($paymentMethods as $method){if($method->$gatewayType==$gateway){$pm=$method;break;}}if(!isset($pm)){throw new Exception('Please contact Account Manager to enable the used payment method in your account');}if($this->isDirectPayment&&!$pm->IsDirectPayment){throw new Exception($pm->PaymentMethodEn.' Direct Payment Method is not activated. Kindly contact your MyFatoorah account manager or sales representative to activate it.');}return $pm;}public function getInvoiceURL($curlData,$gatewayId=0,$orderId=null,$sessionId=null){$this->log('------------------------------------------------------------');$this->isDirectPayment=false;if(!empty($sessionId)){return $this->embeddedPayment($curlData,$sessionId,$orderId);}elseif($gatewayId=='myfatoorah'||empty($gatewayId)){return $this->sendPayment($curlData,$orderId);}else{return $this->excutePayment($curlData,$gatewayId,$orderId);}}protected function excutePayment($curlData,$gatewayId,$orderId=null){$curlData['PaymentMethodId']=$gatewayId;$json=$this->callAPI("$this->apiURL/v2/ExecutePayment",$curlData,$orderId,'Excute Payment');return['invoiceURL'=>$json->Data->PaymentURL,'invoiceId'=>$json->Data->InvoiceId];}protected function sendPayment($curlData,$orderId=null){$curlData['NotificationOption']='Lnk';$json=$this->callAPI("$this->apiURL/v2/SendPayment",$curlData,$orderId,'Send Payment');return['invoiceURL'=>$json->Data->InvoiceURL,'invoiceId'=>$json->Data->InvoiceId];}public function directPayment($curlData,$gateway,$cardInfo,$orderId=null){$this->log('------------------------------------------------------------');$this->isDirectPayment=true;$data=$this->excutePayment($curlData,$gateway,$orderId);$json=$this->callAPI($data['invoiceURL'],$cardInfo,$orderId,'Direct Payment');return['invoiceURL'=>$json->Data->PaymentURL,'invoiceId'=>$data['invoiceId']];}public function getPaymentStatus($keyId,$KeyType,$orderId=null,$price=null,$currncy=null){$curlData=['Key'=>$keyId,'KeyType'=>$KeyType];$json=$this->callAPI("$this->apiURL/v2/GetPaymentStatus",$curlData,$orderId,'Get Payment Status');$msgLog='Order #'.$json->Data->CustomerReference.' ----- Get Payment Status';if(!$this->checkOrderInformation($json,$orderId,$price,$currncy)){$err='Trying to call data of another order';$this->log("$msgLog - Exception is $err");throw new Exception($err);}if($json->Data->InvoiceStatus=='Paid'||$json->Data->InvoiceStatus=='DuplicatePayment'){$json->Data=$this->getSuccessData($json);$this->log("$msgLog - Status is Paid");}elseif($json->Data->InvoiceStatus!='Paid'){$json->Data=$this->getErrorData($json,$keyId,$KeyType);$this->log("$msgLog - Status is ".$json->Data->InvoiceStatus.'. Error is '.$json->Data->InvoiceError);}return $json->Data;}protected function checkOrderInformation($json,$orderId=null,$price=null,$currncy=null){if($orderId&&$json->Data->CustomerReference!=$orderId){return false;}list($valStr,$mfCurrncy)=explode(' ',$json->Data->InvoiceDisplayValue);$mfPrice=floatval(preg_replace('/[^\d.]/','',$valStr));if($price&&$price!=$mfPrice){return false;}if($currncy&&$currncy!=$mfCurrncy){return false;}return true;}protected function getSuccessData($json){foreach($json->Data->InvoiceTransactions as $transaction){if($transaction->TransactionStatus=='Succss'){$json->Data->InvoiceStatus='Paid';$json->Data->InvoiceError='';$json->Data->focusTransaction=$transaction;return $json->Data;}}return $json->Data;}protected function getErrorData($json,$keyId,$KeyType){$focusTransaction=$this->{"getLastTransactionOf$KeyType"}($json,$keyId);if($focusTransaction&&$focusTransaction->TransactionStatus=='Failed'){$json->Data->InvoiceStatus='Failed';$json->Data->InvoiceError=$focusTransaction->Error.'.';$json->Data->focusTransaction=$focusTransaction;return $json->Data;}$ExpiryDateTime=$json->Data->ExpiryDate.' '.$json->Data->ExpiryTime;$ExpiryDate=new \DateTime($ExpiryDateTime,new \DateTimeZone('Asia/Kuwait'));$currentDate=new \DateTime('now',new \DateTimeZone('Asia/Kuwait'));if($ExpiryDate<$currentDate){$json->Data->InvoiceStatus='Expired';$json->Data->InvoiceError='Invoice is expired since '.$json->Data->ExpiryDate.'.';return $json->Data;}$json->Data->InvoiceStatus='Pending';$json->Data->InvoiceError='Pending Payment.';return $json->Data;}protected function getLastTransactionOfPaymentId($json,$keyId){foreach($json->Data->InvoiceTransactions as $transaction){if($transaction->PaymentId==$keyId&&$transaction->Error){return $transaction;}}}protected function getLastTransactionOfInvoiceId($json){usort($json->Data->InvoiceTransactions,function($a,$b){return strtotime($a->TransactionDate)-strtotime($b->TransactionDate);});return end($json->Data->InvoiceTransactions);}public function refund($paymentId,$amount,$currencyCode,$reason,$orderId=null){$rate=$this->getCurrencyRate($currencyCode);$url="$this->apiURL/v2/MakeRefund";$postFields=['KeyType'=>'PaymentId','Key'=>$paymentId,'RefundChargeOnCustomer'=>false,'ServiceChargeOnCustomer'=>false,'Amount'=>$amount/$rate,'Comment'=>$reason,];return $this->callAPI($url,$postFields,$orderId,'Make Refund');}public function embeddedPayment($curlData,$sessionId,$orderId=null){$curlData['SessionId']=$sessionId;$json=$this->callAPI("$this->apiURL/v2/ExecutePayment",$curlData,$orderId,'Embedded Payment');return['invoiceURL'=>$json->Data->PaymentURL,'invoiceId'=>$json->Data->InvoiceId];}public function getEmbeddedSession($userDefinedField='',$orderId=null){$customerIdentifier=['CustomerIdentifier'=>$userDefinedField];$json=$this->callAPI("$this->apiURL/v2/InitiateSession",$customerIdentifier,$orderId,'Initiate Session');return $json->Data;}public function registerApplePayDomain($url){$domainName=['DomainName'=>parse_url($url,PHP_URL_HOST)];return $this->callAPI("$this->apiURL/v2/RegisterApplePayDomain",$domainName,'','Register Apple Pay Domain');}}