<form action="<?php echo e(route('affiliate_user.payment_store')); ?>" method="POST">
    <?php echo csrf_field(); ?>
    <div class="modal-header">
    	<h5 class="modal-title h6"><?php echo e(translate('Affiliate Payment')); ?></h5>
    	<button type="button" class="close" data-dismiss="modal">
    	</button>
    </div>
    <div class="modal-body">
      <table class="table table-striped table-bordered" >
          <tbody>
            <tr>
                <?php if($affiliate_user->balance >= 0): ?>
                    <td><?php echo e(translate('Due Amount')); ?></td>
                    <td><strong><?php echo e(single_price($affiliate_user->balance)); ?></strong></td>
                <?php endif; ?>
            </tr>
            <tr>
                <td><?php echo e(translate('Paypal Email')); ?></td>
                <td><?php echo e($affiliate_user->paypal_email); ?></td>
            </tr>
            <tr>
                <td><?php echo e(translate('Bank Information')); ?></td>
                <td><?php echo e($affiliate_user->bank_information); ?></td>
            </tr>
          </tbody>
      </table>

      <?php if($affiliate_user->balance > 0): ?>
          <input type="hidden" name="affiliate_user_id" value="<?php echo e($affiliate_user->id); ?>">
          <div class="form-group row">
              <label class="col-sm-3 col-from-label" for="amount"><?php echo e(translate('Amount')); ?></label>
              <div class="col-sm-9">
                  <input type="number" min="0" step="0.01" name="amount" id="amount" value="<?php echo e($affiliate_user->balance); ?>" class="form-control" required>
              </div>
          </div>

          <div class="form-group row">
              <label class="col-sm-3 col-from-label" for="payment_method"><?php echo e(translate('Payment Method')); ?></label>
              <div class="col-sm-9">
                  <select name="payment_method" id="payment_method" class="form-control aiz-selectpicker" required>
                      <option value=""><?php echo e(translate('Select Payment Method')); ?></option>
                      <option value="Paypal"><?php echo e(translate('Paypal')); ?></option>
                      <option value="Bank"><?php echo e(translate('Bank')); ?></option>
                  </select>
              </div>
          </div>
      <?php endif; ?>
    </div>
    <div class="modal-footer">
      <?php if($affiliate_user->balance > 0): ?>
          <button class="btn btn-sm btn-primary" type="submit"><?php echo e(translate('Pay')); ?></button>
      <?php endif; ?>
      <button type="button" class="btn btn-sm btn-light" data-dismiss="modal"><?php echo e(translate('Cancel')); ?></button>
    </div>
</form>
<?php /**PATH /home/smartch/www/resources/views/affiliate/payment_modal.blade.php ENDPATH**/ ?>