@extends('layouts.landing.app-v2')
@section('home','active')
    @php($business_name=\App\Models\BusinessSetting::where(['key' => 'business_name'])->first()->value ?? 'Stackfood')
@section('title', $business_name )
@section('content')

    @php($landing_page_text = \App\Models\BusinessSetting::where(['key' => 'landing_page_text'])->first())
    @php($landing_page_text = isset($landing_page_text->value) ? json_decode($landing_page_text->value, true) : null)
    @php($landing_page_links = \App\Models\BusinessSetting::where(['key' => 'landing_page_links'])->first())
    @php($landing_page_links = isset($landing_page_links->value) ? json_decode($landing_page_links->value, true) : null)
    @php($landing_page_images = \App\Models\BusinessSetting::where(['key' => 'landing_page_images'])->first())
    @php($landing_page_images = isset($landing_page_images->value) ? json_decode($landing_page_images->value, true) : null)

    @php($landing_page_links = \App\Models\BusinessSetting::where(['key' => 'landing_page_links'])->first())
    @php($landing_page_links = isset($landing_page_links->value) ? json_decode($landing_page_links->value, true) : null)
        <!-- ======= Footer Section ======= -->
    <!-- ======= Banner Section ======= -->
    <section class="banner-section"
        {{-- style="background: url('./public/assets/landing/assets_new/img/banner/banner-bg.png') no-repeat center center / cover"> --}}
        style="background: url('./public/assets/landing/image/{{isset($landing_page_images['top_content_image'])?$landing_page_images['top_content_image']:'double_screen_image.png'}}') no-repeat center center / cover">

        <!-- Main Banner Content -->
        <div class="container">
            <div class="banner-wrapper">
                <div class="banner-thumb wow fadeInUp">
                    {{-- <img class="main-img" src="./assets/img/banner/banner.png" alt=""> --}}
                    <img class="main-img"
                    src="{{ asset('public/assets/landing') }}/image/{{ isset($landing_page_images['feature_section_image']) ? $landing_page_images['feature_section_image'] : 'top_content_image.png' }}"

                    alt="">
                    <div class="img-data-1">
                        <img src="{{asset('/public/assets/landing/assets_new/img/banner/icon-1.png')}}" alt="">
                        <span>Review {{\App\Models\Review::count()}} +</span>
                    </div>
                    <div class="img-data-2">
                        <img src="{{asset('/public/assets/landing/assets_new/img/banner/icon-2.png')}}" alt="">
                        <span>Order {{\App\Models\Order::count()}} +</span>
                    </div>
                    <div class="img-data-3">
                        <img src="{{asset('/public/assets/landing/assets_new/img/banner/icon-3.png')}}" alt="">
                        <span>User {{\App\Models\User::count()}} +</span>
                    </div>
                </div>
                <div class="banner-content wow fadeInRight">
                    <h2 class="title"> {{ isset($landing_page_text) ? $landing_page_text['header_title_1'] : '' }}</h2>
                    <h3 class="subtitle">{{ isset($landing_page_text) ? $landing_page_text['header_title_2'] : '' }}</h3>
                    <h1 class="name">{{ $business_name}}</h1>
                     <div class="txt">
                        {{ isset($landing_page_text) ? $landing_page_text['header_title_3'] : '' }}
                    </div>
                    @if (isset($landing_page_links['order_now_url_status']))
                   <a href="{{ $landing_page_links['order_now_url'] }}" class="btn-base btn-sm">
                        <span>{{translate('Order Now')}}</span>
                        <svg width="14" height="15" viewBox="0 0 14 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                d="M0.875 7.50006C0.875 7.38403 0.921094 7.27275 1.00314 7.19071C1.08519 7.10866 1.19647 7.06256 1.3125 7.06256H11.6314L8.87775 4.30981C8.7956 4.22766 8.74945 4.11624 8.74945 4.00006C8.74945 3.88389 8.7956 3.77247 8.87775 3.69031C8.9599 3.60816 9.07132 3.56201 9.1875 3.56201C9.30368 3.56201 9.4151 3.60816 9.49725 3.69031L12.9972 7.19031C13.038 7.23095 13.0703 7.27923 13.0924 7.33239C13.1144 7.38554 13.1258 7.44252 13.1258 7.50006C13.1258 7.55761 13.1144 7.61459 13.0924 7.66774C13.0703 7.7209 13.038 7.76917 12.9972 7.80981L9.49725 11.3098C9.4151 11.392 9.30368 11.4381 9.1875 11.4381C9.07132 11.4381 8.9599 11.392 8.87775 11.3098C8.7956 11.2277 8.74945 11.1162 8.74945 11.0001C8.74945 10.8839 8.7956 10.7725 8.87775 10.6903L11.6314 7.93756H1.3125C1.19647 7.93756 1.08519 7.89147 1.00314 7.80942C0.921094 7.72738 0.875 7.6161 0.875 7.50006Z"
                                fill="white" />
                        </svg>

                    </a>
                    @endif
                </div>
            </div>
        </div>
        <!-- Main Banner Content -->

        <!-- Shape 1 -->
        <div class="shape-1"><img src="{{asset('/public/assets/landing/assets_new/img/banner/1.png')}}" alt=""></div>
        <div class="shape-2"><img src="{{asset('/public/assets/landing/assets_new/img/banner/2.png')}}" alt=""></div>
        <div class="shape-3"><img src="{{asset('/public/assets/landing/assets_new/img/banner/3.png')}}" alt=""></div>
        <!-- Glass 1 -->
        <svg class="glass-1" width="439" height="477" viewBox="0 0 439 477" fill="none"
            xmlns="http://www.w3.org/2000/svg">
            <circle cx="273" cy="204" r="273" fill="url(#paint0_radial_3_2080)" />
            <defs>
                <radialGradient id="paint0_radial_3_2080" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(273 204) rotate(90) scale(273)">
                    <stop stop-color="#FFBD3C" stop-opacity="0.3" />
                    <stop offset="1" stop-color="#D9D9D9" stop-opacity="0" />
                </radialGradient>
            </defs>
        </svg>
        <!-- Glass 2 -->
        <svg class="glass-2" width="311" height="407" viewBox="0 0 311 407" fill="none"
            xmlns="http://www.w3.org/2000/svg">
            <circle cx="239" cy="146" r="146" fill="url(#paint0_radial_0_1)" />
            <circle cx="146" cy="328" r="146" fill="url(#paint1_radial_0_1)" />
            <defs>
                <radialGradient id="paint0_radial_0_1" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(239 146) rotate(90) scale(146)">
                    <stop stop-color="#FFBD3C" stop-opacity="0.3" />
                    <stop offset="1" stop-color="#D9D9D9" stop-opacity="0" />
                </radialGradient>
                <radialGradient id="paint1_radial_0_1" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(146 328) rotate(90) scale(146)">
                    <stop stop-color="#FFBD3C" stop-opacity="0.3" />
                    <stop offset="1" stop-color="#D9D9D9" stop-opacity="0" />
                </radialGradient>
            </defs>
        </svg>
        <!-- Glass 3 -->
        <svg class="glass-3" width="546" height="537" viewBox="0 0 546 537" fill="none"
            xmlns="http://www.w3.org/2000/svg">
            <circle cx="273" cy="273" r="273" fill="url(#paint0_radial_3_2079)" />
            <defs>
                <radialGradient id="paint0_radial_3_2079" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(273 273) rotate(90) scale(273)">
                    <stop stop-color="#FFBD3C" stop-opacity="0.3" />
                    <stop offset="1" stop-color="#D9D9D9" stop-opacity="0" />
                </radialGradient>
            </defs>
        </svg>
    </section>
    <!-- ======= Banner Section ======= -->
    <!-- ======= About Section ======= -->
    <section class="about-section pt-80">
        <div class="container">
            <div class="row g-4 align-items-center">
                <div class="col-lg-7">
                    <div class="about-content wow fadeInDown">
                        <h2 class="title text-base">{{ translate('messages.about_us') }}</h2>
                        <h3 class="subtitle">{{ isset($landing_page_text) ? $landing_page_text['about_title'] : '' }}</h3>
                        <p class="txt">
                            {!! \Illuminate\Support\Str::limit(\App\CentralLogics\Helpers::get_settings('about_us'), 200) !!}
                        </p>
                        <a href="{{ route('about-us') }}" class="btn-base btn-sm">
                            <span>
                                {{ translate('messages.read_more') }}
                            </span>
                            <svg width="14" height="15" viewBox="0 0 14 15" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M0.875 7.50006C0.875 7.38403 0.921094 7.27275 1.00314 7.19071C1.08519 7.10866 1.19647 7.06256 1.3125 7.06256H11.6314L8.87775 4.30981C8.7956 4.22766 8.74945 4.11624 8.74945 4.00006C8.74945 3.88389 8.7956 3.77247 8.87775 3.69031C8.9599 3.60816 9.07132 3.56201 9.1875 3.56201C9.30368 3.56201 9.4151 3.60816 9.49725 3.69031L12.9972 7.19031C13.038 7.23095 13.0703 7.27923 13.0924 7.33239C13.1144 7.38554 13.1258 7.44252 13.1258 7.50006C13.1258 7.55761 13.1144 7.61459 13.0924 7.66774C13.0703 7.7209 13.038 7.76917 12.9972 7.80981L9.49725 11.3098C9.4151 11.392 9.30368 11.4381 9.1875 11.4381C9.07132 11.4381 8.9599 11.392 8.87775 11.3098C8.7956 11.2277 8.74945 11.1162 8.74945 11.0001C8.74945 10.8839 8.7956 10.7725 8.87775 10.6903L11.6314 7.93756H1.3125C1.19647 7.93756 1.08519 7.89147 1.00314 7.80942C0.921094 7.72738 0.875 7.6161 0.875 7.50006Z"
                                    fill="white" />
                            </svg>

                        </a>
                    </div>
                </div>
                <div class="col-lg-5 text-lg-end text-center wow fadeInLeft">
                    <img
                    src="{{ asset('public/assets/landing') }}/image/{{ isset($landing_page_images['about_us_image']) ? $landing_page_images['about_us_image'] : 'about_us_image.png' }}"
                     alt="about" class="about-img">
                </div>
            </div>
        </div>
    </section>
    <!-- ======= About Section ======= -->
    <!-- ======= Feature Section ======= -->
    @php($feature = \App\Models\BusinessSetting::where(['key' => 'feature'])->first())
    @php($feature = isset($feature->value) ? json_decode($feature->value, true) : null)
    @if ($feature && count($feature) > 0)
    <section class="feature-section overflow-hidden pt-80">
        <div class="container">
            <div class="section-header text-center wow fadeInUp">
                <h2 class="title">
                     <span class="text-base">{{ isset($landing_page_text['feature_section_title']) ? $landing_page_text['feature_section_title'] :translate('messages.our_features') }}</span>
                </h2>
                <p>
                    {{ isset($landing_page_text['feature_section_description']) ? $landing_page_text['feature_section_description'] : 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam ex odio,  turpis accumsan congue.' }}
                </p>
            </div>
            <div class="feature-slider owl-theme owl-carousel">
                @foreach ($feature as $feature_data)
                <div class="feature-item wow fadeInUp">
                    <div class="feature-item-icon">
                        <img
                        src="{{ asset('public/assets/landing/') }}/image/{{ $feature_data['img'] }}" alt="">
                    </div>
                    <h4 class="title">{{ $feature_data['title'] }}</h4>
                    <div class="txt">
                        {{ $feature_data['feature_description'] }}
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </section>
    @endif
    <!-- ======= Feature Section ======= -->
    <!-- ======= Platform Section ======= -->
    <section class="platform-section pt-80 overflow-hidden">

        @php($order_platform = \App\Models\BusinessSetting::where(['key' => 'order_platform'])->first())
        @php($order_platform = isset($order_platform->value) ? json_decode($order_platform->value, true) : null)
        @php($delivery_platform = \App\Models\BusinessSetting::where(['key' => 'delivery_platform'])->first())
        @php($delivery_platform = isset($delivery_platform->value) ? json_decode($delivery_platform->value, true) : null)
        @php($restaurant_platform = \App\Models\BusinessSetting::where(['key' => 'restaurant_platform'])->first())
        @php($restaurant_platform = isset($restaurant_platform->value) ? json_decode($restaurant_platform->value, true) : null)
        <div class="container">
            <div class="section-header text-center wow fadeInUp">
                <h2 class="title">
                 <span class="text-base">{{ isset($landing_page_text['our_platform_title']) ? $landing_page_text['our_platform_title'] : '' }}</span>
                </h2>
                <p>
                    {{ isset($landing_page_text['our_platform_article']) ? $landing_page_text['our_platform_article'] : '' }}
                </p>
            </div>

            <!-- Tab Menu Starts-->
            <ul class="nav nav-tabs nav--tabs wow fadeInUp">
               @if(isset($order_platform))
               <li>
                   <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#order-your-food">
                       <img
                       src="{{ asset('storage/app/public/landing') }}/{{ $order_platform['image'] ?? null }}"
                                onerror="this.src='{{asset('public/assets/admin/img/400x400/img2.jpg')}}'"
                       alt="">
                       {{$order_platform['title']}}
                   </button>
               </li>
               @endif
               @if( isset($restaurant_platform) )
                <li>
                    <button class="nav-link" data-bs-toggle="tab" data-bs-target="#manage-restaurant">
                        <img
                        src="{{ asset('storage/app/public/landing') }}/{{ $restaurant_platform['image'] ?? null }}"
                                onerror="this.src='{{asset('public/assets/admin/img/400x400/img2.jpg')}}'"
                       alt="">
                       {{$restaurant_platform['title']}}
                    </button>
                </li>
                @endif
                @if( isset($delivery_platform))
                <li>
                    <button class="nav-link" data-bs-toggle="tab" data-bs-target="#earn-delivery">
                        <img
                        src="{{ asset('storage/app/public/landing') }}/{{ $delivery_platform['image'] ?? null }}"
                        onerror="this.src='{{asset('public/assets/admin/img/400x400/img2.jpg')}}'"
                        alt="">
                        {{$delivery_platform['title']}}
                    </button>
                </li>
                @endif
            </ul>
            <!-- Tab Menu Ends -->

            <!-- Tab Content -->
            <div class="tab-content tab--content">
                @if(isset($order_platform))
                <!-- Tab Pan -->
                <div class="tab-pane fade show active" id="order-your-food">
                    <div class="row gy-5 align-items-center flex-wrap-reverse">
                        <div class="col-lg-7">
                            <div class="platform-content wow fadeInUp">
                                @php($order_platform_datas = \App\Models\BusinessSetting::where(['key'=>'platform_order_data'])->first())
                                @php($order_platform_datas = isset($order_platform_datas->value)?json_decode($order_platform_datas->value, true):[])

                                @foreach($order_platform_datas as  $order_platform_data)
                                <h4 class="subtitle">{{$order_platform_data['title']}}</h4>
                                <p>
                                    {{$order_platform_data['detail']}}
                                </p>
                                @endforeach
                               @if($order_platform['url_status'] ==1 )
                                <a href="{{$order_platform['url']}}" class="btn-base btn-sm">
                                    <span>{{ translate('messages.Download_now') }}</span>
                                    <svg width="14" height="15" viewBox="0 0 14 15" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M0.875 7.50006C0.875 7.38403 0.921094 7.27275 1.00314 7.19071C1.08519 7.10866 1.19647 7.06256 1.3125 7.06256H11.6314L8.87775 4.30981C8.7956 4.22766 8.74945 4.11624 8.74945 4.00006C8.74945 3.88389 8.7956 3.77247 8.87775 3.69031C8.9599 3.60816 9.07132 3.56201 9.1875 3.56201C9.30368 3.56201 9.4151 3.60816 9.49725 3.69031L12.9972 7.19031C13.038 7.23095 13.0703 7.27923 13.0924 7.33239C13.1144 7.38554 13.1258 7.44252 13.1258 7.50006C13.1258 7.55761 13.1144 7.61459 13.0924 7.66774C13.0703 7.7209 13.038 7.76917 12.9972 7.80981L9.49725 11.3098C9.4151 11.392 9.30368 11.4381 9.1875 11.4381C9.07132 11.4381 8.9599 11.392 8.87775 11.3098C8.7956 11.2277 8.74945 11.1162 8.74945 11.0001C8.74945 10.8839 8.7956 10.7725 8.87775 10.6903L11.6314 7.93756H1.3125C1.19647 7.93756 1.08519 7.89147 1.00314 7.80942C0.921094 7.72738 0.875 7.6161 0.875 7.50006Z"
                                            fill="white" />
                                    </svg>
                                </a>
                                @endif
                            </div>
                        </div>
                        <div class="col-lg-5">
                            <div class="platform-img">
                                <svg width="501" height="411" viewBox="0 0 501 411" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0_3_1789)">
                                        <path opacity="0.2"
                                            d="M467.385 127.554C476.458 144.532 479.14 165.077 473.877 183.487C464.122 217.959 432.506 239.406 417.22 270.782C403.318 299.291 404.073 336.781 378.667 358.885C367.092 368.964 351.648 373.534 336.446 375.634C303.473 380.176 270.416 374.284 237.678 370.362C194.086 365.071 148.123 372.107 105.241 363.938C85.5643 360.189 66.125 350.973 54.0918 334.963C28.3927 300.877 42.0864 254.024 62.1494 221.11C77.1967 196.425 96.5174 173.498 106.658 146.112C115.971 120.91 113.566 92.3766 125.975 68.1798C136.074 48.5791 155.334 34.7899 176.312 28.0522C234.032 9.52801 271.877 36.5791 318.914 64.9641C357.861 88.5116 408.658 77.471 446.123 103.43C455.053 109.628 462.242 118.022 467.385 127.554Z"
                                            fill="#EF7822" fill-opacity="0.21" />
                                        <g clip-path="url(#clip1_3_1789)">
                                            <path d="M374.498 230.074L343.673 410.57H348.85L380.161 230.074H374.498Z"
                                                fill="#EBEBEB" />
                                            <path d="M411.548 230.074L449.774 410.57H444.596L405.886 230.074H411.548Z"
                                                fill="#EBEBEB" />
                                            <path d="M396.178 410.571H390.158L389.392 149.422H395.421L396.178 410.571Z"
                                                fill="#EBEBEB" />
                                            <path d="M437.988 101.157H352.946V155.522H437.988V101.157Z"
                                                fill="#E0E0E0" />
                                            <path d="M413.626 229.242H370.939V234.492H413.626V229.242Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M358.6 148.428C358.6 148.428 358.643 148.743 358.66 149.422H358.541C358.456 146.763 358.387 137.953 358.387 127.52C358.413 121.224 358.43 115.524 358.447 111.327C358.473 109.296 358.498 107.631 358.515 106.416C358.532 105.872 358.541 105.43 358.558 105.082C358.575 104.776 358.583 104.615 358.6 104.615C358.617 104.615 358.626 104.776 358.643 105.082C358.651 105.43 358.668 105.872 358.685 106.416C358.703 107.631 358.728 109.296 358.754 111.327C358.771 115.524 358.788 121.224 358.813 127.52C358.813 137.961 358.754 146.763 358.66 149.422H358.541C358.558 148.743 358.575 148.428 358.6 148.428Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M364.927 148.428C364.927 148.428 364.97 148.743 364.987 149.422H364.868C364.782 146.763 364.714 137.953 364.714 127.52C364.74 121.224 364.757 115.524 364.774 111.327C364.8 109.296 364.825 107.631 364.842 106.416C364.859 105.872 364.868 105.43 364.885 105.082C364.902 104.776 364.91 104.615 364.927 104.615C364.944 104.615 364.953 104.776 364.97 105.082C364.978 105.43 364.995 105.872 365.012 106.416C365.029 107.631 365.055 109.296 365.081 111.327C365.098 115.524 365.115 121.224 365.14 127.52C365.14 137.961 365.081 146.763 364.987 149.422H364.868C364.885 148.743 364.902 148.428 364.927 148.428Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M371.254 148.428C371.254 148.428 371.297 148.743 371.314 149.422H371.195C371.109 146.763 371.041 137.953 371.041 127.52C371.067 121.224 371.084 115.524 371.101 111.327C371.126 109.296 371.152 107.631 371.169 106.416C371.186 105.872 371.195 105.43 371.212 105.082C371.229 104.776 371.237 104.615 371.254 104.615C371.271 104.615 371.28 104.776 371.297 105.082C371.305 105.43 371.322 105.872 371.339 106.416C371.356 107.631 371.382 109.296 371.407 111.327C371.424 115.524 371.441 121.224 371.467 127.52C371.467 137.961 371.399 146.763 371.314 149.422H371.195C371.212 148.743 371.229 148.428 371.254 148.428Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M377.589 148.428C377.589 148.428 377.632 148.743 377.649 149.422H377.53C377.445 146.763 377.377 137.953 377.377 127.52C377.402 121.224 377.419 115.524 377.436 111.327C377.462 109.296 377.487 107.631 377.504 106.416C377.521 105.872 377.53 105.43 377.547 105.082C377.564 104.776 377.572 104.615 377.589 104.615C377.606 104.615 377.615 104.776 377.632 105.082C377.641 105.43 377.658 105.872 377.675 106.416C377.692 107.631 377.717 109.296 377.743 111.327C377.76 115.524 377.777 121.224 377.802 127.52C377.802 137.961 377.734 146.763 377.649 149.422H377.53C377.547 148.743 377.564 148.428 377.589 148.428Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M383.916 148.428C383.916 148.428 383.959 148.743 383.976 149.422H383.857C383.772 146.763 383.703 137.953 383.703 127.52C383.729 121.224 383.746 115.524 383.763 111.327C383.789 109.296 383.814 107.631 383.831 106.416C383.848 105.872 383.857 105.43 383.874 105.082C383.891 104.776 383.899 104.615 383.916 104.615C383.933 104.615 383.942 104.776 383.959 105.082C383.967 105.43 383.984 105.872 384.002 106.416C384.019 107.631 384.044 109.296 384.07 111.327C384.087 115.524 384.104 121.224 384.129 127.52C384.129 137.961 384.061 146.763 383.976 149.422H383.857C383.874 148.743 383.891 148.428 383.916 148.428Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M390.243 148.428C390.243 148.428 390.286 148.743 390.303 149.422H390.184C390.098 146.763 390.03 137.953 390.03 127.52C390.056 121.224 390.073 115.524 390.09 111.327C390.115 109.296 390.141 107.631 390.158 106.416C390.175 105.872 390.184 105.43 390.201 105.082C390.218 104.776 390.226 104.615 390.243 104.615C390.26 104.615 390.269 104.776 390.286 105.082C390.294 105.43 390.311 105.872 390.328 106.416C390.345 107.631 390.371 109.296 390.396 111.327C390.413 115.524 390.43 121.224 390.456 127.52C390.456 137.961 390.396 146.763 390.303 149.422H390.184C390.201 148.743 390.218 148.428 390.243 148.428Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M396.579 148.428C396.579 148.428 396.621 148.743 396.638 149.422H396.519C396.434 146.763 396.366 137.953 396.366 127.52C396.391 121.224 396.408 115.524 396.425 111.327C396.451 109.296 396.476 107.631 396.493 106.416C396.51 105.872 396.519 105.43 396.536 105.082C396.553 104.776 396.562 104.615 396.579 104.615C396.596 104.615 396.604 104.776 396.621 105.082C396.63 105.43 396.647 105.872 396.664 106.416C396.681 107.631 396.706 109.296 396.732 111.327C396.749 115.524 396.766 121.224 396.791 127.52C396.791 137.961 396.732 146.763 396.638 149.422H396.519C396.536 148.743 396.553 148.428 396.579 148.428Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M402.905 148.428C402.905 148.428 402.948 148.743 402.965 149.422H402.846C402.761 146.763 402.693 137.953 402.693 127.52C402.718 121.224 402.735 115.524 402.752 111.327C402.778 109.296 402.803 107.631 402.82 106.416C402.837 105.872 402.846 105.43 402.863 105.082C402.88 104.776 402.888 104.615 402.905 104.615C402.922 104.615 402.931 104.776 402.948 105.082C402.956 105.43 402.974 105.872 402.991 106.416C403.008 107.631 403.033 109.296 403.059 111.327C403.076 115.524 403.093 121.224 403.118 127.52C403.118 137.961 403.059 146.763 402.965 149.422H402.846C402.863 148.743 402.88 148.428 402.905 148.428Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M409.232 148.428C409.232 148.428 409.275 148.743 409.292 149.422H409.173C409.088 146.763 409.019 137.953 409.019 127.52C409.045 121.224 409.062 115.524 409.079 111.327C409.105 109.296 409.13 107.631 409.147 106.416C409.164 105.872 409.173 105.43 409.19 105.082C409.207 104.776 409.215 104.615 409.232 104.615C409.249 104.615 409.258 104.776 409.275 105.082C409.283 105.43 409.3 105.872 409.317 106.416C409.334 107.631 409.36 109.296 409.386 111.327C409.403 115.524 409.42 121.224 409.445 127.52C409.445 137.961 409.377 146.763 409.292 149.422H409.173C409.19 148.743 409.207 148.428 409.232 148.428Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M415.568 148.428C415.568 148.428 415.61 148.743 415.627 149.422H415.508C415.423 146.763 415.355 137.953 415.355 127.52C415.38 121.224 415.397 115.524 415.414 111.327C415.44 109.296 415.465 107.631 415.482 106.416C415.499 105.872 415.508 105.43 415.525 105.082C415.542 104.776 415.551 104.615 415.568 104.615C415.585 104.615 415.593 104.776 415.61 105.082C415.619 105.43 415.636 105.872 415.653 106.416C415.67 107.631 415.695 109.296 415.721 111.327C415.738 115.524 415.755 121.224 415.781 127.52C415.781 137.961 415.712 146.763 415.627 149.422H415.508C415.525 148.743 415.542 148.428 415.568 148.428Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M421.895 148.428C421.895 148.428 421.937 148.743 421.954 149.422H421.835C421.75 146.763 421.682 137.953 421.682 127.52C421.707 121.224 421.724 115.524 421.741 111.327C421.767 109.296 421.792 107.631 421.809 106.416C421.826 105.872 421.835 105.43 421.852 105.082C421.869 104.776 421.877 104.615 421.895 104.615C421.912 104.615 421.92 104.776 421.937 105.082C421.946 105.43 421.963 105.872 421.98 106.416C421.997 107.631 422.022 109.296 422.048 111.327C422.065 115.524 422.082 121.224 422.107 127.52C422.107 137.961 422.039 146.763 421.954 149.422H421.835C421.852 148.743 421.869 148.428 421.895 148.428Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M428.221 148.428C428.221 148.428 428.264 148.743 428.281 149.422H428.162C428.077 146.763 428.009 137.953 428.009 127.52C428.034 121.224 428.051 115.524 428.068 111.327C428.094 109.296 428.119 107.631 428.136 106.416C428.153 105.872 428.162 105.43 428.179 105.082C428.196 104.776 428.204 104.615 428.221 104.615C428.238 104.615 428.247 104.776 428.264 105.082C428.273 105.43 428.29 105.872 428.307 106.416C428.324 107.631 428.349 109.296 428.375 111.327C428.392 115.524 428.409 121.224 428.434 127.52C428.434 137.961 428.366 146.763 428.281 149.422H428.162C428.179 148.743 428.196 148.428 428.221 148.428Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M434.557 148.428C434.557 148.428 434.599 148.743 434.616 149.422H434.497C434.412 146.763 434.344 137.953 434.344 127.52C434.369 121.224 434.386 115.524 434.403 111.327C434.429 109.296 434.455 107.631 434.472 106.416C434.489 105.872 434.497 105.43 434.514 105.082C434.531 104.776 434.54 104.615 434.557 104.615C434.574 104.615 434.582 104.776 434.599 105.082C434.608 105.43 434.625 105.872 434.642 106.416C434.659 107.631 434.684 109.296 434.71 111.327C434.727 115.524 434.744 121.224 434.77 127.52C434.77 137.961 434.701 146.763 434.616 149.422H434.497C434.514 148.743 434.531 148.428 434.557 148.428Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M162.985 205.02C165.539 202.471 165.539 198.34 162.985 195.792C160.431 193.244 156.291 193.244 153.737 195.792C151.183 198.34 151.183 202.471 153.737 205.02C156.291 207.568 160.431 207.568 162.985 205.02Z"
                                                fill="#E0E0E0" />
                                            <path
                                                d="M138.94 207.356C142.787 207.356 145.905 204.244 145.905 200.406C145.905 196.568 142.787 193.457 138.94 193.457C135.093 193.457 131.974 196.568 131.974 200.406C131.974 204.244 135.093 207.356 138.94 207.356Z"
                                                fill="#E0E0E0" />
                                            <path
                                                d="M129.441 193.115C132.209 190.121 132.02 185.456 129.02 182.694C126.019 179.933 121.343 180.121 118.575 183.115C115.808 186.108 115.996 190.774 118.997 193.535C121.997 196.297 126.673 196.109 129.441 193.115Z"
                                                fill="#E0E0E0" />
                                            <path
                                                d="M120.981 176.907C125.247 176.907 128.705 173.457 128.705 169.201C128.705 164.945 125.247 161.495 120.981 161.495C116.716 161.495 113.258 164.945 113.258 169.201C113.258 173.457 116.716 176.907 120.981 176.907Z"
                                                fill="#E0E0E0" />
                                            <path
                                                d="M130.442 160.611C134.848 160.611 138.421 157.047 138.421 152.651C138.421 148.254 134.848 144.69 130.442 144.69C126.035 144.69 122.463 148.254 122.463 152.651C122.463 157.047 126.035 160.611 130.442 160.611Z"
                                                fill="#E0E0E0" />
                                            <path
                                                d="M151.975 154.119C156.41 152.272 158.506 147.187 156.655 142.762C154.804 138.336 149.707 136.246 145.272 138.092C140.836 139.939 138.741 145.024 140.592 149.449C142.443 153.875 147.539 155.965 151.975 154.119Z"
                                                fill="#E0E0E0" />
                                            <path
                                                d="M179.025 188.975C179.583 185.538 177.243 182.301 173.798 181.744C170.353 181.188 167.109 183.522 166.551 186.959C165.993 190.396 168.333 193.633 171.778 194.19C175.222 194.747 178.467 192.412 179.025 188.975Z"
                                                fill="#E0E0E0" />
                                            <path
                                                d="M182.027 168.988C182.027 172.217 179.405 174.833 176.169 174.833C172.933 174.833 170.31 172.217 170.31 168.988C170.31 165.76 172.933 163.143 176.169 163.143C179.405 163.143 182.027 165.76 182.027 168.988Z"
                                                fill="#E0E0E0" />
                                            <path
                                                d="M171.775 152.43C171.775 155.378 169.374 157.774 166.419 157.774C163.464 157.774 161.063 155.378 161.063 152.43C161.063 149.482 163.464 147.086 166.419 147.086C169.374 147.086 171.775 149.482 171.775 152.43Z"
                                                fill="#E0E0E0" />
                                            <path d="M358.95 28.3467H317.523V39.281H358.95V28.3467Z" fill="#F5F5F5" />
                                            <path
                                                d="M341.434 50.8016C341.434 50.8016 341.434 50.7336 341.417 50.6062L341.4 50.0454C341.4 49.5272 341.382 48.8135 341.365 47.896C341.348 46.0099 341.323 43.2912 341.297 39.8758L341.425 40.0032C331.965 40.0202 316.918 40.0542 299.998 40.0882C300.092 39.9947 299.785 40.3006 300.203 39.8758V42.671C300.203 43.597 300.203 44.5146 300.203 45.4321C300.203 47.2588 300.203 49.0514 300.203 50.8101L299.998 50.6062C311.792 50.6401 322.121 50.6741 329.521 50.6996C333.208 50.7251 336.171 50.7421 338.232 50.7591C339.237 50.7676 340.029 50.7761 340.591 50.7846C340.846 50.7846 341.05 50.7931 341.204 50.8016C341.34 50.8016 341.417 50.8101 341.425 50.8186C341.425 50.8186 341.365 50.8271 341.229 50.8356L340.642 50.8525C340.088 50.8525 339.313 50.8695 338.334 50.878C336.282 50.895 333.336 50.912 329.665 50.9375C322.223 50.963 311.851 50.997 299.998 51.031H299.794V50.8271C299.794 49.0684 299.794 47.2758 299.794 45.4491C299.794 44.5401 299.794 43.614 299.794 42.6879V39.9098V39.8928C300.22 39.468 299.913 39.7738 300.007 39.6804C316.927 39.7144 331.973 39.7399 341.434 39.7653H341.561V39.8928C341.527 43.3506 341.51 46.0863 341.493 47.9894C341.476 48.8985 341.468 49.6036 341.459 50.1134C341.459 50.3343 341.451 50.5127 341.442 50.6486C341.442 50.7676 341.442 50.8271 341.434 50.8186V50.8016Z"
                                                fill="#E0E0E0" />
                                            <path
                                                d="M152.828 85.5242C152.828 85.5242 152.828 85.4563 152.811 85.3288L152.794 84.7681C152.794 84.2498 152.777 83.5362 152.76 82.6186C152.743 80.7325 152.718 78.0138 152.692 74.5984L152.82 74.7259C143.359 74.7429 128.313 74.7769 111.393 74.8108C111.487 74.7174 111.18 75.0232 111.597 74.5984V77.3936C111.597 78.3197 111.597 79.2372 111.597 80.1548C111.597 81.9814 111.597 83.7741 111.597 85.5327L111.393 85.3288C123.187 85.3628 133.516 85.3968 140.916 85.4223C144.603 85.4478 147.566 85.4648 149.627 85.4817C150.632 85.4902 151.423 85.4987 151.985 85.5072C152.241 85.5072 152.445 85.5157 152.599 85.5242C152.735 85.5242 152.811 85.5327 152.82 85.5412C152.82 85.5412 152.76 85.5497 152.624 85.5582L152.037 85.5752C151.483 85.5752 150.708 85.5922 149.729 85.6007C147.677 85.6177 144.73 85.6347 141.06 85.6602C133.618 85.6856 123.246 85.7196 111.393 85.7536H111.189V85.5497C111.189 83.7911 111.189 81.9984 111.189 80.1718C111.189 79.2627 111.189 78.3367 111.189 77.4106V74.6324V74.6154C111.614 74.1906 111.308 74.4965 111.402 74.403C128.321 74.437 143.368 74.4625 152.828 74.488H152.956V74.6154C152.922 78.0733 152.905 80.809 152.888 82.7121C152.871 83.6211 152.863 84.3263 152.854 84.8361C152.854 85.0569 152.846 85.2354 152.837 85.3713C152.837 85.4902 152.837 85.5497 152.828 85.5412V85.5242Z"
                                                fill="#E0E0E0" />
                                            <path d="M277.024 388.362H271.429V407.775H277.024V388.362Z"
                                                fill="#263238" />
                                            <path d="M127.632 388.362H122.037V407.775H127.632V388.362Z"
                                                fill="#263238" />
                                            <path d="M439.768 407.818H434.165V391.013L439.768 388.379V407.818Z"
                                                fill="#263238" />
                                            <path
                                                d="M305.729 249.029C285.446 246.684 265.162 249.097 244.785 250.345C217.894 251.994 190.994 247.474 164.052 247.355C160.126 247.338 155.851 247.542 152.871 250.099C150.785 251.892 149.695 254.576 149.022 257.236C143.811 277.94 155.366 297.022 153.297 318.143C153.246 318.661 153.322 318.143 153.246 318.661L153.305 335.033L400.623 331.023C400.623 331.023 411.795 257.593 404.685 250.498C397.575 243.404 323.083 251.042 305.729 249.029Z"
                                                fill="#B68C6D" />
                                            <path
                                                d="M406.737 257.516C406.737 257.516 406.516 257.516 406.09 257.49C405.647 257.465 405.017 257.422 404.191 257.371C402.514 257.261 400.053 257.1 396.902 256.887C390.567 256.488 381.396 255.987 370.054 255.621C358.711 255.256 345.197 255.035 330.202 255.128C315.198 255.213 298.712 255.681 281.418 256.488C264.115 257.261 247.621 257.958 232.6 257.898C217.587 257.881 204.065 257.083 192.791 255.681C181.517 254.296 172.524 252.299 166.359 250.83C163.285 250.031 160.927 249.317 159.317 248.875C158.525 248.646 157.912 248.468 157.495 248.349C157.086 248.23 156.873 248.153 156.873 248.153C156.873 248.153 157.086 248.196 157.503 248.306C157.929 248.417 158.542 248.578 159.343 248.791C160.961 249.207 163.328 249.895 166.402 250.668C172.584 252.087 181.568 254.033 192.833 255.383C204.099 256.743 217.604 257.516 232.6 257.507C247.604 257.541 264.089 256.836 281.392 256.063C298.687 255.256 315.189 254.806 330.193 254.738C345.197 254.661 358.72 254.916 370.062 255.324C381.404 255.732 390.575 256.275 396.911 256.726C400.078 256.938 402.531 257.151 404.2 257.286C405.026 257.354 405.656 257.414 406.09 257.456C406.516 257.499 406.737 257.524 406.737 257.524V257.516Z"
                                                fill="#263238" />
                                            <path
                                                d="M156.839 334.107C153.91 334.082 151.389 336.308 150.299 338.865C149.209 341.414 149.252 344.251 149.312 346.995C149.49 355.551 149.678 364.115 149.857 372.67C149.942 376.595 150.052 380.631 151.713 384.233C153.382 387.835 157.018 390.928 161.199 390.894L391.325 389.747C391.325 389.747 405.273 390.979 404.166 376.527C403.059 362.076 403.553 333.844 400.623 331.023C397.686 328.202 156.831 334.107 156.831 334.107H156.839Z"
                                                fill="#B68C6D" />
                                            <path
                                                d="M418.207 343.784C418.207 343.784 418.012 343.912 417.603 344.141C417.186 344.379 416.59 344.71 415.815 345.152C414.214 345.976 411.846 347.225 408.662 348.508C402.326 351.133 392.704 354.013 380.468 355.296C374.362 355.959 367.627 356.239 360.406 356.197C353.185 356.154 345.478 355.78 337.38 355.347C329.282 354.905 320.775 354.531 311.954 354.26C303.132 354.022 293.995 353.869 284.637 353.869C247.178 353.86 213.321 356.358 188.933 358.958C185.885 359.247 182.981 359.705 180.197 359.671C177.421 359.663 174.823 359.434 172.397 359.162C167.543 358.618 163.413 357.811 160.066 357.046C156.72 356.273 154.174 355.474 152.479 354.846C151.628 354.54 150.998 354.268 150.58 354.064C150.155 353.877 149.95 353.767 149.95 353.767C149.95 353.767 150.172 353.843 150.606 354.022C151.032 354.209 151.662 354.463 152.522 354.761C154.225 355.364 156.771 356.129 160.118 356.876C163.464 357.615 167.594 358.397 172.431 358.915C174.849 359.17 177.446 359.391 180.205 359.391C182.956 359.408 185.851 358.941 188.908 358.643C213.296 355.959 247.169 353.41 284.645 353.418C294.012 353.418 303.149 353.571 311.979 353.818C320.801 354.107 329.316 354.48 337.414 354.939C345.512 355.381 353.21 355.772 360.423 355.823C367.635 355.882 374.354 355.619 380.442 354.982C392.653 353.741 402.267 350.912 408.602 348.346C411.795 347.089 414.163 345.866 415.781 345.067C416.564 344.642 417.169 344.319 417.586 344.09C417.995 343.869 418.207 343.767 418.207 343.767V343.784Z"
                                                fill="#263238" />
                                            <path
                                                d="M236.687 363.444C236.568 363.444 236.542 361.6 236.636 359.332C236.73 357.063 236.908 355.237 237.028 355.245C237.147 355.254 237.172 357.089 237.079 359.357C236.985 361.617 236.806 363.452 236.687 363.444Z"
                                                fill="#263238" />
                                            <path
                                                d="M241.762 364.123C241.634 364.106 241.907 361.897 241.898 359.17C241.898 356.443 241.634 354.234 241.762 354.217C241.873 354.192 242.35 356.4 242.341 359.17C242.341 361.94 241.873 364.149 241.762 364.123Z"
                                                fill="#263238" />
                                            <path
                                                d="M232.242 266.564C232.123 266.598 231.408 264.678 230.641 262.265C229.875 259.853 229.347 257.865 229.466 257.831C229.585 257.797 230.301 259.717 231.067 262.138C231.833 264.551 232.361 266.539 232.242 266.573V266.564Z"
                                                fill="#263238" />
                                            <path
                                                d="M237.266 273.684C237.198 273.658 237.462 272.792 237.803 271.364C238.126 269.946 238.492 267.949 238.467 265.732C238.433 263.514 237.981 261.535 237.53 260.15C237.079 258.765 236.696 257.941 236.764 257.907C236.789 257.89 236.909 258.085 237.113 258.451C237.317 258.807 237.564 259.36 237.837 260.048C238.373 261.424 238.893 263.446 238.918 265.723C238.944 268 238.518 270.022 238.118 271.441C237.7 272.86 237.326 273.701 237.283 273.675L237.266 273.684Z"
                                                fill="#263238" />
                                            <path
                                                d="M152.675 360.878C152.42 366.485 154.387 376.799 152.701 382.16C151.015 387.513 150.947 387.793 145.982 390.427C141.605 392.746 136.437 392.959 131.481 393.001C125.886 393.061 120.292 392.976 114.706 392.763C112.517 392.678 110.073 392.466 108.617 390.835C107.399 389.475 107.221 387.504 107.101 385.686C105.415 359.977 103.738 334.218 104.709 308.475C104.853 304.728 105.049 300.948 105.977 297.311C108.174 288.679 120.36 279.529 128.611 276.131C136.854 272.733 145.999 273.795 153.663 278.357L156.396 314.312L153.425 331.023L152.684 360.878H152.675Z"
                                                fill="#B68C6D" />
                                            <path
                                                d="M148.801 286.573C148.801 286.573 148.724 286.632 148.562 286.734C148.383 286.844 148.145 286.997 147.847 287.176C147.217 287.575 146.314 288.187 145.19 289.036C142.951 290.753 139.868 293.446 136.394 297.099C135.517 298.008 134.631 298.985 133.712 300.013C133.26 300.531 132.792 301.058 132.341 301.61C131.889 302.095 131.83 302.851 131.719 303.564C131.412 306.487 131.515 309.673 131.608 312.995C131.915 319.656 132.256 326.979 132.613 334.668C133.303 350.037 133.925 363.954 134.384 374.055C134.589 379.076 134.75 383.146 134.87 385.992C134.912 387.377 134.955 388.464 134.98 389.238C134.98 389.586 134.997 389.866 134.997 390.079C134.997 390.266 134.997 390.367 134.989 390.367C134.989 390.367 134.972 390.274 134.955 390.079C134.938 389.866 134.921 389.586 134.895 389.238C134.853 388.464 134.785 387.377 134.699 385.992C134.546 383.146 134.333 379.076 134.069 374.064C133.584 363.962 132.911 350.054 132.17 334.685C131.821 326.996 131.455 319.673 131.2 313.003C131.114 309.665 131.029 306.487 131.361 303.513C131.404 303.14 131.472 302.774 131.557 302.409C131.617 302.222 131.659 302.044 131.745 301.865C131.838 301.678 131.949 301.508 132.068 301.381C132.528 300.829 132.996 300.302 133.456 299.784C134.376 298.756 135.278 297.787 136.164 296.887C139.681 293.25 142.806 290.583 145.08 288.9C146.229 288.068 147.149 287.473 147.796 287.099C148.102 286.929 148.349 286.793 148.537 286.691C148.707 286.598 148.792 286.556 148.801 286.564V286.573Z"
                                                fill="#263238" />
                                            <path
                                                d="M143.785 312.409C143.802 312.468 143.138 312.689 142.04 312.969C140.941 313.25 139.408 313.581 137.697 313.827C135.985 314.074 134.418 314.193 133.286 314.227C132.153 314.269 131.455 314.235 131.447 314.184C131.447 314.048 134.231 313.878 137.629 313.386C141.026 312.893 143.751 312.273 143.785 312.4V312.409Z"
                                                fill="#263238" />
                                            <path
                                                d="M138.114 320.488C138.08 320.607 136.632 320.301 134.887 319.808C133.141 319.316 131.745 318.814 131.779 318.704C131.813 318.585 133.26 318.891 135.006 319.384C136.752 319.876 138.148 320.378 138.114 320.488Z"
                                                fill="#263238" />
                                            <path
                                                d="M117.89 302.29C117.882 302.154 120.998 301.933 124.83 301.976C126.746 301.984 128.483 302.035 129.744 302.094C131.004 302.154 131.779 302.222 131.779 302.281C131.779 302.341 130.995 302.383 129.744 302.4C128.483 302.417 126.755 302.417 124.83 302.4C122.999 302.383 121.347 302.366 119.925 302.358C118.674 302.341 117.89 302.332 117.89 302.273V302.29Z"
                                                fill="#263238" />
                                            <path
                                                d="M150.623 252.962C150.623 252.962 150.606 253.03 150.546 253.149C150.478 253.294 150.385 253.464 150.282 253.685C150.07 254.16 149.797 254.882 149.559 255.851C149.048 257.771 148.63 260.634 148.349 264.186C148.213 265.961 148.102 267.907 148.043 270.005C147.992 271.05 148.043 272.121 148.094 273.242C148.145 274.355 148.188 275.511 148.239 276.683C148.46 281.39 148.818 286.564 149.857 291.899C150.342 294.576 151.032 297.133 151.619 299.639C152.198 302.145 152.624 304.601 152.846 306.963C153.314 311.678 153.127 315.951 153.058 319.511C152.973 323.079 153.033 325.96 153.178 327.948C153.229 328.942 153.314 329.715 153.356 330.233L153.399 330.828C153.399 330.964 153.399 331.032 153.399 331.032C153.399 331.032 153.373 330.964 153.356 330.836C153.331 330.675 153.305 330.479 153.271 330.241C153.203 329.723 153.084 328.95 153.007 327.956C152.811 325.968 152.701 323.071 152.743 319.503C152.769 315.934 152.922 311.686 152.437 307.005C152.207 304.669 151.773 302.23 151.194 299.741C150.606 297.252 149.908 294.669 149.414 291.984C148.366 286.623 148.017 281.415 147.821 276.709C147.779 275.528 147.736 274.381 147.694 273.259C147.677 272.698 147.66 272.146 147.634 271.602C147.617 271.05 147.651 270.524 147.668 269.997C147.745 267.898 147.864 265.944 148.026 264.16C148.349 260.6 148.809 257.737 149.38 255.809C149.652 254.849 149.95 254.118 150.189 253.651C150.308 253.438 150.41 253.268 150.495 253.132C150.563 253.013 150.606 252.962 150.615 252.962H150.623Z"
                                                fill="#263238" />
                                            <path
                                                d="M153.408 331.023C153.45 331.082 152.548 331.269 151.705 332.51C151.287 333.113 150.921 333.946 150.615 334.948C150.308 335.951 150.07 337.132 149.806 338.44C149.499 339.74 149.329 341.167 149.371 342.722C149.397 344.277 149.593 345.933 149.806 347.683C150.214 351.184 150.666 355.032 151.134 359.068C151.594 363.104 152.028 366.952 152.428 370.461C152.811 373.953 153.254 377.122 153.092 379.815C152.973 382.5 152.284 384.641 151.458 385.898C150.649 387.173 149.95 387.665 149.95 387.665C149.908 387.623 150.563 387.088 151.304 385.813C152.071 384.547 152.701 382.449 152.777 379.807C152.897 377.156 152.42 374.012 152.02 370.512C151.611 367.003 151.16 363.163 150.691 359.128C150.231 355.092 149.797 351.243 149.397 347.743C149.201 345.993 149.014 344.319 149.005 342.739C148.98 341.167 149.175 339.672 149.508 338.38C149.789 337.081 150.053 335.9 150.385 334.88C150.717 333.869 151.125 333.028 151.577 332.416C152.028 331.805 152.505 331.439 152.854 331.252C153.024 331.159 153.178 331.116 153.271 331.074C153.365 331.04 153.416 331.023 153.416 331.031L153.408 331.023Z"
                                                fill="#263238" />
                                            <path
                                                d="M396.723 358.711C396.979 364.319 397.243 369.994 398.929 375.346C400.615 380.699 403.91 385.779 408.875 388.413C413.252 390.733 418.42 390.945 423.376 390.987C428.971 391.047 434.565 390.962 440.151 390.749C442.34 390.665 444.784 390.452 446.24 388.821C447.457 387.462 447.636 385.491 447.755 383.672C449.441 357.964 451.119 332.204 450.148 306.461C450.003 302.715 449.808 298.934 448.879 295.298C446.683 286.666 434.497 277.516 426.246 274.117C417.995 270.719 408.858 271.781 401.194 276.343L398.46 312.298L396.706 358.703L396.723 358.711Z"
                                                fill="#B68C6D" />
                                            <path
                                                d="M406.056 284.576C406.056 284.576 406.15 284.61 406.32 284.703C406.507 284.805 406.754 284.941 407.061 285.111C407.708 285.485 408.628 286.079 409.777 286.912C412.059 288.594 415.185 291.262 418.693 294.898C419.578 295.799 420.481 296.776 421.401 297.795C421.86 298.314 422.329 298.84 422.789 299.393C422.908 299.52 423.019 299.69 423.112 299.877C423.197 300.055 423.24 300.242 423.3 300.421C423.385 300.786 423.453 301.151 423.495 301.525C423.828 304.507 423.734 307.676 423.657 311.015C423.41 317.684 423.036 325.008 422.686 332.697C421.946 348.066 421.273 361.974 420.788 372.075C420.524 377.088 420.311 381.158 420.157 384.004C420.072 385.389 420.013 386.476 419.962 387.249L419.902 388.09C419.885 388.277 419.876 388.379 419.868 388.379C419.859 388.379 419.859 388.277 419.859 388.09C419.859 387.878 419.868 387.597 419.876 387.249C419.902 386.476 419.936 385.389 419.987 384.004C420.106 381.158 420.268 377.088 420.473 372.067C420.924 361.965 421.554 348.049 422.244 332.68C422.601 324.991 422.933 317.667 423.248 311.007C423.342 307.685 423.444 304.499 423.129 301.576C423.027 300.862 422.967 300.106 422.508 299.622C422.056 299.07 421.597 298.543 421.137 298.025C420.226 296.997 419.331 296.02 418.454 295.111C414.98 291.457 411.898 288.764 409.658 287.048C408.534 286.198 407.623 285.587 407.001 285.187L406.286 284.746C406.124 284.644 406.048 284.584 406.048 284.584L406.056 284.576Z"
                                                fill="#263238" />
                                            <path
                                                d="M411.072 310.412C411.106 310.284 413.831 310.905 417.228 311.397C420.626 311.882 423.419 312.06 423.41 312.196C423.41 312.256 422.704 312.281 421.571 312.239C420.438 312.196 418.872 312.077 417.16 311.839C415.448 311.593 413.916 311.262 412.817 310.981C411.719 310.701 411.055 310.471 411.072 310.42V310.412Z"
                                                fill="#263238" />
                                            <path
                                                d="M416.743 318.483C416.709 318.364 418.097 317.871 419.851 317.379C421.597 316.886 423.044 316.58 423.078 316.699C423.112 316.818 421.724 317.311 419.97 317.803C418.224 318.296 416.777 318.602 416.743 318.483Z"
                                                fill="#263238" />
                                            <path
                                                d="M436.967 300.285C436.967 300.344 436.183 300.353 434.931 300.37C433.509 300.378 431.857 300.395 430.027 300.412C428.111 300.421 426.374 300.429 425.113 300.412C423.853 300.395 423.078 300.353 423.078 300.293C423.078 300.234 423.853 300.166 425.113 300.106C426.374 300.047 428.102 299.996 430.027 299.987C433.867 299.945 436.984 300.157 436.967 300.302V300.285Z"
                                                fill="#263238" />
                                            <path
                                                d="M405.256 251.271C405.256 251.271 405.298 251.331 405.366 251.45C405.443 251.594 405.537 251.773 405.656 251.994C405.886 252.478 406.158 253.234 406.388 254.228C406.882 256.216 407.189 259.164 407.282 262.809C407.384 266.462 407.18 270.795 406.933 275.595C406.669 280.404 406.116 285.689 405.06 291.151C404.549 293.887 403.919 296.529 403.425 299.095C402.931 301.661 402.59 304.159 402.335 306.546C401.832 311.321 401.747 315.654 401.603 319.29C401.475 322.926 401.279 325.874 401.058 327.896C400.964 328.907 400.845 329.689 400.768 330.224C400.734 330.471 400.7 330.666 400.674 330.827C400.649 330.963 400.632 331.031 400.632 331.031C400.632 331.031 400.632 330.963 400.632 330.819C400.649 330.658 400.657 330.454 400.683 330.207C400.726 329.672 400.819 328.89 400.887 327.871C401.058 325.849 401.211 322.909 401.296 319.273C401.398 315.637 401.449 311.295 401.935 306.495C402.182 304.099 402.522 301.584 403.008 299.002C403.501 296.419 404.132 293.785 404.634 291.058C405.681 285.612 406.252 280.353 406.533 275.561C406.797 270.761 407.044 266.437 406.976 262.8C406.925 259.173 406.661 256.233 406.226 254.254C406.022 253.26 405.775 252.512 405.579 252.019C405.477 251.798 405.4 251.611 405.332 251.467C405.281 251.339 405.256 251.271 405.264 251.271H405.256Z"
                                                fill="#263238" />
                                            <path
                                                d="M401.449 331.023C401.449 331.023 401.645 331.065 402.003 331.21C402.352 331.363 402.871 331.626 403.399 332.144C403.936 332.654 404.421 333.444 404.77 334.421C405.111 335.407 405.409 336.537 405.639 337.828C406.09 340.428 405.707 343.546 405.324 346.927C404.941 350.334 404.515 354.064 404.063 357.981C403.604 361.897 403.169 365.627 402.769 369.034C402.36 372.432 401.943 375.482 402.079 378.056C402.182 380.622 402.82 382.653 403.578 383.876C404.31 385.108 404.949 385.635 404.898 385.677C404.898 385.677 404.225 385.202 403.425 383.97C402.607 382.755 401.909 380.682 401.764 378.082C401.586 375.474 401.977 372.39 402.36 369C402.752 365.593 403.169 361.863 403.621 357.947C404.08 354.03 404.515 350.3 404.915 346.893C405.332 343.503 405.732 340.436 405.332 337.888C405.128 336.63 404.847 335.483 404.54 334.523C404.217 333.563 403.774 332.799 403.28 332.28C402.267 331.269 401.407 331.108 401.449 331.04V331.023Z"
                                                fill="#263238" />
                                            <path
                                                d="M400.632 331.023C400.632 331.142 345.163 331.244 276.76 331.244C208.357 331.244 152.871 331.142 152.871 331.023C152.871 330.904 208.331 330.802 276.76 330.802C345.189 330.802 400.632 330.904 400.632 331.023Z"
                                                fill="#263238" />
                                            <g opacity="0.3">
                                                <path
                                                    d="M152.505 304.473L149.286 291.186C147.021 292.672 145.803 296.147 145.906 298.857C146.008 301.559 146.885 304.167 147.345 306.835C148.596 314.108 146.706 321.499 145.676 328.814C144.645 336.129 145.522 344.88 149.95 350.793C149.976 348.253 149.175 345.135 149.184 342.102C149.201 337.429 150.359 332.952 153.416 331.032C153.416 331.032 153.084 312.026 152.513 304.482L152.505 304.473Z"
                                                    fill="black" />
                                            </g>
                                            <g opacity="0.3">
                                                <path
                                                    d="M400.811 331.057V331.032C400.683 331.023 400.555 331.015 400.427 331.032L400.811 331.066V331.057Z"
                                                    fill="black" />
                                            </g>
                                            <g opacity="0.3">
                                                <path
                                                    d="M407.742 338.483C407.325 334.549 406.124 330.734 405.801 326.792C405.588 324.269 405.741 321.737 405.733 319.214C405.707 312.893 404.694 306.572 402.727 300.557C402.088 310.718 401.458 320.87 400.819 331.032C401.654 331.117 402.633 331.371 403.152 332.043C403.757 332.816 404.498 333.878 404.77 334.821C406.15 339.587 405.562 344.804 404.804 349.714C407.385 346.715 408.159 342.425 407.742 338.491V338.483Z"
                                                    fill="black" />
                                            </g>
                                            <g opacity="0.3">
                                                <path
                                                    d="M242.324 333.309C235.205 333.733 227.874 334.311 221.53 337.556C214.854 340.98 209.966 346.995 204.244 351.847C198.522 356.698 194.179 361.158 187 358.992L180.673 359.782C186.294 363.495 190.679 365.746 196.827 368.499C199.918 369.884 203.682 371.107 206.543 369.28C210.068 367.029 209.762 361.931 210.945 357.921C212.716 351.906 218.439 347.786 224.416 345.823C230.386 343.86 236.764 343.623 242.963 342.612C251.47 341.227 259.746 338.398 268.347 337.811C285.02 336.673 301.08 344.013 317.718 345.551C332.433 346.91 347.548 343.563 360.312 336.129C321.193 331.516 281.656 330.964 242.341 333.309H242.324Z"
                                                    fill="black" />
                                            </g>
                                            <path
                                                d="M357.127 213.524C359.273 209.964 363.309 207.611 367.473 207.5L367.065 208.63C370.42 206.94 374.992 208.316 376.857 211.57C378.722 214.824 377.589 219.454 374.43 221.485C376.576 223.515 376.414 227.262 374.507 229.513C372.6 231.773 369.398 232.631 366.46 232.309C362.322 231.858 358.49 229.191 356.633 225.461C354.786 221.74 354.973 217.075 357.119 213.516L357.127 213.524Z"
                                                fill="#263238" />
                                            <path
                                                d="M363.59 204.688C362.969 203.006 363.241 201.145 363.011 199.378C362.5 195.47 359.452 192.174 355.773 190.746C352.095 189.319 347.922 189.574 344.167 190.806C341.374 191.723 338.709 193.21 336.818 195.453C334.306 198.427 333.378 202.666 334.425 206.413L354.445 203.762C356.293 205.334 358.192 206.923 360.448 207.815C361.112 208.078 361.828 208.273 362.526 208.172C363.224 208.07 363.922 207.602 364.093 206.914C364.289 206.158 363.846 205.41 363.573 204.688H363.59Z"
                                                fill="#263238" />
                                            <path
                                                d="M361.078 200.211L343.682 196.303C338.13 195.861 334.63 202.76 334.425 208.308C334.195 214.476 334.161 222.012 335.013 226.591C336.725 235.792 343.852 236.786 343.852 236.786C343.852 236.752 344.065 247.899 344.192 251.255C350.485 254.237 356.787 248.986 363.394 246.038L364.084 203.431C364.076 201.74 362.773 200.347 361.087 200.211H361.078Z"
                                                fill="#FFBE9D" />
                                            <path
                                                d="M336.844 215.24C336.844 215.869 337.363 216.387 338.019 216.404C338.675 216.421 339.211 215.929 339.219 215.308C339.219 214.68 338.7 214.161 338.044 214.144C337.389 214.127 336.852 214.62 336.844 215.249V215.24Z"
                                                fill="#263238" />
                                            <path
                                                d="M336.154 212.182C336.307 212.335 337.184 211.647 338.462 211.613C339.739 211.562 340.693 212.199 340.829 212.038C340.897 211.97 340.735 211.689 340.318 211.409C339.909 211.12 339.211 210.857 338.419 210.882C337.627 210.908 336.963 211.213 336.58 211.528C336.197 211.842 336.069 212.122 336.145 212.19L336.154 212.182Z"
                                                fill="#263238" />
                                            <path
                                                d="M348.816 215.181C348.816 215.81 349.336 216.328 349.991 216.345C350.647 216.362 351.184 215.869 351.184 215.249C351.184 214.62 350.664 214.102 350.008 214.085C349.353 214.068 348.816 214.561 348.808 215.189L348.816 215.181Z"
                                                fill="#263238" />
                                            <path
                                                d="M348.723 212.097C348.876 212.25 349.761 211.562 351.039 211.528C352.316 211.477 353.27 212.114 353.406 211.953C353.474 211.885 353.312 211.604 352.895 211.324C352.486 211.035 351.797 210.772 350.996 210.797C350.204 210.823 349.54 211.128 349.157 211.443C348.774 211.757 348.646 212.038 348.723 212.105V212.097Z"
                                                fill="#263238" />
                                            <path
                                                d="M344.337 221.672C344.337 221.596 343.545 221.485 342.251 221.349C341.927 221.324 341.612 221.264 341.553 221.043C341.468 220.814 341.595 220.457 341.749 220.075C342.038 219.276 342.336 218.444 342.651 217.568C343.903 214 344.797 211.078 344.652 211.027C344.508 210.976 343.375 213.83 342.132 217.39C341.834 218.265 341.544 219.106 341.272 219.905C341.161 220.279 340.957 220.703 341.136 221.188C341.229 221.426 341.476 221.596 341.68 221.646C341.893 221.706 342.072 221.706 342.234 221.706C343.528 221.74 344.337 221.723 344.337 221.655V221.672Z"
                                                fill="#263238" />
                                            <path
                                                d="M343.843 236.786C343.843 236.786 350.085 237.024 356.156 233.167C356.156 233.167 353.202 239.641 343.911 239.021L343.835 236.795L343.843 236.786Z"
                                                fill="#EB996E" />
                                            <path
                                                d="M344.95 224.731C345.393 224.11 346.194 223.762 346.994 223.821C347.548 223.864 348.118 224.119 348.467 224.561C348.816 225.002 348.901 225.64 348.612 226.081C348.28 226.574 347.565 226.702 346.951 226.549C346.338 226.387 345.802 226.005 345.291 225.623C345.146 225.512 345.01 225.402 344.916 225.257C344.823 225.104 344.806 224.909 344.908 224.782"
                                                fill="#EB996E" />
                                            <path
                                                d="M348.118 222.462C347.914 222.462 347.948 223.838 346.781 224.849C345.623 225.869 344.141 225.75 344.133 225.945C344.116 226.03 344.465 226.209 345.095 226.209C345.708 226.209 346.594 225.996 347.309 225.376C348.016 224.756 348.305 223.94 348.339 223.371C348.373 222.793 348.212 222.454 348.118 222.462Z"
                                                fill="#263238" />
                                            <path
                                                d="M348.407 208.248C348.544 208.588 349.813 208.393 351.32 208.537C352.827 208.648 354.045 209.055 354.24 208.741C354.326 208.588 354.104 208.265 353.61 207.942C353.116 207.62 352.333 207.322 351.43 207.246C350.528 207.169 349.71 207.331 349.165 207.569C348.62 207.806 348.348 208.087 348.407 208.248Z"
                                                fill="#263238" />
                                            <path
                                                d="M336.384 206.6C336.614 206.88 337.491 206.558 338.547 206.515C339.603 206.439 340.505 206.66 340.701 206.354C340.786 206.201 340.642 205.92 340.241 205.657C339.85 205.394 339.194 205.19 338.47 205.232C337.746 205.275 337.116 205.555 336.759 205.861C336.392 206.167 336.273 206.473 336.384 206.609V206.6Z"
                                                fill="#263238" />
                                            <path
                                                d="M351.677 189.82L342.779 195.232C343.341 198.265 345.717 200.899 348.68 201.774C350.264 202.242 352.171 202.36 353.117 203.711C354.087 205.088 353.542 207.11 354.445 208.529C355.697 210.5 359.077 210.381 360.022 212.513C360.431 213.448 360.227 214.569 360.661 215.487C361.232 216.719 364.382 218.265 365.677 217.849C366.971 217.432 368.529 218.494 368.946 217.339C368.946 217.339 372.216 214.246 371.254 207.959C370.3 201.672 369.483 199.047 365.191 194.816C360.899 190.585 356.386 187.934 351.686 189.812L351.677 189.82Z"
                                                fill="#263238" />
                                            <path
                                                d="M361.853 218.979C361.836 218.291 362.594 216.651 363.267 216.523C365.08 216.192 368.359 216.252 368.512 220.865C368.716 227.16 362.339 226.073 362.322 225.886C362.304 225.742 361.913 221.358 361.853 218.979Z"
                                                fill="#FFBE9D" />
                                            <path
                                                d="M364.178 223.439C364.178 223.439 364.289 223.515 364.476 223.592C364.663 223.668 364.97 223.719 365.302 223.583C365.958 223.32 366.486 222.241 366.477 221.111C366.477 220.533 366.332 219.998 366.119 219.548C365.915 219.098 365.6 218.783 365.268 218.732C364.927 218.664 364.697 218.877 364.629 219.055C364.553 219.234 364.595 219.361 364.561 219.369C364.544 219.386 364.425 219.268 364.467 219.004C364.493 218.877 364.561 218.724 364.706 218.605C364.851 218.477 365.072 218.409 365.31 218.426C365.796 218.443 366.247 218.877 366.494 219.369C366.758 219.862 366.928 220.465 366.937 221.111C366.937 222.386 366.324 223.592 365.421 223.881C364.978 224.008 364.604 223.889 364.408 223.745C364.203 223.592 364.169 223.456 364.195 223.448L364.178 223.439Z"
                                                fill="#EB996E" />
                                            <path
                                                d="M331.019 226.404C331.019 226.404 331.096 226.353 331.241 226.234C331.36 226.107 331.556 225.903 331.701 225.588C331.845 225.274 331.973 224.858 331.956 224.365C331.956 223.872 331.811 223.295 331.428 222.793C331.045 222.267 330.372 222.02 329.878 221.544C329.631 221.315 329.495 220.967 329.606 220.635C329.717 220.312 330.04 220.075 330.389 219.922C330.738 219.769 331.147 219.718 331.564 219.616C331.973 219.514 332.433 219.344 332.714 218.945C333.003 218.554 333.029 218.027 332.927 217.577C332.833 217.118 332.612 216.685 332.356 216.294C332.109 215.903 331.845 215.521 331.675 215.121C331.496 214.722 331.428 214.297 331.505 213.881C331.667 213.048 332.237 212.386 332.629 211.672C333.438 210.262 333.872 208.851 334.093 207.645C334.315 206.439 334.323 205.445 334.281 204.765C334.255 204.425 334.238 204.162 334.204 203.983C334.179 203.805 334.162 203.711 334.153 203.711C334.127 203.711 334.179 204.085 334.187 204.765C334.196 205.445 334.162 206.43 333.923 207.611C333.693 208.792 333.242 210.185 332.441 211.562C332.067 212.258 331.479 212.913 331.283 213.83C331.19 214.28 331.275 214.773 331.462 215.198C331.65 215.623 331.913 216.014 332.16 216.396C332.407 216.778 332.612 217.186 332.697 217.611C332.791 218.027 332.765 218.477 332.527 218.8C332.297 219.132 331.896 219.293 331.496 219.395C331.096 219.497 330.679 219.548 330.287 219.718C329.912 219.888 329.538 220.151 329.401 220.559C329.333 220.763 329.342 220.975 329.401 221.171C329.47 221.366 329.589 221.527 329.725 221.655C330.27 222.165 330.926 222.394 331.283 222.87C331.649 223.337 331.794 223.881 331.811 224.348C331.837 224.824 331.726 225.223 331.598 225.529C331.326 226.149 330.977 226.362 331.002 226.379L331.019 226.404Z"
                                                fill="#263238" />
                                            <path
                                                d="M369.125 221.765C369.125 221.765 369.534 221.332 369.994 220.363C370.445 219.412 370.922 217.874 370.709 215.954C370.505 214.068 369.432 211.833 367.354 210.329C366.324 209.565 365.038 209.157 363.829 208.562C363.224 208.265 362.628 207.908 362.151 207.415C361.674 206.923 361.325 206.302 361.07 205.64C360.559 204.306 360.372 202.879 359.741 201.63C359.435 201.009 358.992 200.449 358.447 200.058C357.894 199.659 357.272 199.421 356.659 199.268C355.424 198.953 354.223 198.894 353.159 198.614C352.086 198.35 351.141 197.9 350.349 197.39C348.757 196.371 347.803 195.122 347.249 194.23C346.977 193.779 346.798 193.414 346.679 193.159L346.551 192.87C346.517 192.802 346.5 192.777 346.5 192.777C346.5 192.777 346.653 193.355 347.181 194.281C347.709 195.19 348.654 196.473 350.264 197.526C351.064 198.053 352.018 198.52 353.108 198.8C354.198 199.089 355.399 199.166 356.608 199.48C357.204 199.633 357.8 199.871 358.319 200.245C358.839 200.619 359.247 201.145 359.546 201.749C360.15 202.955 360.337 204.374 360.857 205.742C361.121 206.421 361.487 207.076 361.989 207.594C362.5 208.112 363.113 208.477 363.727 208.783C364.961 209.378 366.23 209.786 367.235 210.516C369.261 211.969 370.326 214.144 370.547 215.988C370.786 217.865 370.334 219.386 369.917 220.338C369.713 220.822 369.491 221.17 369.355 221.417L369.185 221.68C369.151 221.74 369.125 221.774 369.134 221.774L369.125 221.765Z"
                                                fill="#FAFAFA" />
                                            <path
                                                d="M370.3 218.91C370.3 218.91 370.615 218.477 370.948 217.577C371.28 216.685 371.62 215.291 371.458 213.575C371.297 211.876 370.556 209.82 368.904 208.214C368.495 207.815 368.018 207.458 367.516 207.144C367.013 206.829 366.486 206.532 365.966 206.209C365.455 205.878 364.961 205.495 364.578 205.011C364.186 204.527 363.948 203.941 363.778 203.32C363.607 202.7 363.48 202.063 363.258 201.46C363.037 200.857 362.705 200.287 362.279 199.829C361.445 198.886 360.346 198.291 359.282 197.909C358.2 197.526 357.136 197.348 356.148 197.152C355.16 196.965 354.249 196.762 353.449 196.481C351.839 195.92 350.766 194.969 350.221 194.204C349.668 193.431 349.557 192.896 349.532 192.904C349.532 192.904 349.532 192.938 349.557 192.998C349.574 193.057 349.6 193.151 349.642 193.27C349.736 193.508 349.881 193.847 350.153 194.247C350.69 195.045 351.771 196.022 353.398 196.617C354.206 196.914 355.126 197.127 356.114 197.322C357.102 197.526 358.158 197.713 359.213 198.095C360.261 198.478 361.317 199.055 362.117 199.965C362.517 200.415 362.832 200.95 363.054 201.528C363.267 202.114 363.394 202.743 363.573 203.38C363.744 204.009 364.008 204.637 364.416 205.147C364.825 205.657 365.336 206.048 365.855 206.387C366.903 207.05 367.976 207.568 368.768 208.359C370.386 209.913 371.135 211.918 371.314 213.584C371.493 215.274 371.177 216.651 370.879 217.543C370.735 217.993 370.573 218.333 370.471 218.562C370.36 218.783 370.3 218.91 370.309 218.91H370.3Z"
                                                fill="#B68C6D" />
                                            <path
                                                d="M337.159 195.708C337.159 195.708 337.483 195.394 338.053 194.961C338.615 194.527 339.492 194.026 340.548 193.746C341.604 193.465 342.609 193.465 343.315 193.567C344.022 193.661 344.448 193.814 344.465 193.771C344.465 193.754 344.371 193.712 344.176 193.635C343.988 193.559 343.699 193.474 343.341 193.406C342.983 193.329 342.541 193.296 342.055 193.304C341.57 193.321 341.033 193.389 340.488 193.525C339.943 193.669 339.45 193.882 339.015 194.103C338.59 194.341 338.223 194.587 337.951 194.825C337.67 195.063 337.465 195.275 337.338 195.436C337.21 195.598 337.142 195.683 337.159 195.7V195.708Z"
                                                fill="#B68C6D" />
                                            <path
                                                d="M368.453 228.4C368.453 228.4 368.521 228.468 368.691 228.494C368.853 228.519 369.134 228.485 369.372 228.264C369.491 228.154 369.611 228.01 369.653 227.806C369.704 227.61 369.679 227.381 369.585 227.168C369.406 226.735 368.929 226.37 368.342 226.344C367.763 226.31 367.133 226.514 366.596 226.922C366.332 227.134 366.094 227.398 365.941 227.738C365.787 228.069 365.728 228.468 365.804 228.842C365.949 229.607 366.554 230.286 367.346 230.558C368.138 230.83 369.04 230.737 369.841 230.405C371.467 229.743 372.54 228.264 372.889 226.829C373.076 226.106 373.076 225.376 372.949 224.722C372.829 224.067 372.565 223.498 372.267 223.014C371.671 222.054 370.914 221.485 370.369 221.196C370.232 221.119 370.105 221.06 369.994 221.017C369.883 220.966 369.789 220.932 369.713 220.907C369.56 220.856 369.474 220.831 369.474 220.839C369.466 220.865 369.798 220.958 370.326 221.272C370.854 221.587 371.569 222.156 372.131 223.099C372.693 224.025 373.068 225.376 372.685 226.778C372.336 228.154 371.297 229.573 369.747 230.202C368.981 230.507 368.138 230.601 367.405 230.354C366.681 230.108 366.128 229.488 365.992 228.808C365.838 228.12 366.213 227.457 366.698 227.075C367.192 226.684 367.788 226.48 368.316 226.506C368.853 226.523 369.287 226.846 369.457 227.228C369.543 227.415 369.568 227.619 369.534 227.789C369.5 227.959 369.406 228.103 369.296 228.205C369.083 228.417 368.827 228.46 368.674 228.451C368.512 228.443 368.436 228.392 368.436 228.4H368.453Z"
                                                fill="#B68C6D" />
                                            <path
                                                d="M368.793 239.496C368.793 239.496 368.572 239.666 368.12 239.845C367.678 240.014 366.937 240.167 366.128 239.862C365.336 239.573 364.536 238.715 364.45 237.585C364.408 237.032 364.57 236.429 364.91 235.928C365.242 235.427 365.779 235.01 366.409 234.891C366.715 234.832 367.039 234.866 367.294 235.019C367.541 235.172 367.712 235.444 367.746 235.724C367.78 236.004 367.635 236.268 367.397 236.387C367.158 236.514 366.86 236.523 366.605 236.455C366.077 236.319 365.677 235.902 365.447 235.469C365.208 235.027 365.106 234.56 365.098 234.135C365.081 233.269 365.31 232.581 365.447 232.122C365.591 231.654 365.677 231.4 365.66 231.391C365.66 231.391 365.625 231.451 365.574 231.57C365.523 231.688 365.447 231.867 365.362 232.096C365.2 232.555 364.944 233.243 364.936 234.144C364.936 234.594 365.038 235.087 365.285 235.563C365.532 236.03 365.949 236.497 366.562 236.659C366.86 236.735 367.201 236.735 367.507 236.574C367.814 236.429 368.027 236.055 367.976 235.699C367.933 235.35 367.729 235.027 367.422 234.832C367.107 234.645 366.732 234.611 366.383 234.671C365.677 234.806 365.106 235.265 364.748 235.809C364.382 236.353 364.212 236.998 364.263 237.602C364.374 238.825 365.242 239.717 366.094 240.006C366.962 240.312 367.729 240.116 368.172 239.921C368.401 239.819 368.563 239.709 368.665 239.632C368.768 239.547 368.819 239.505 368.81 239.496H368.793Z"
                                                fill="#263238" />
                                            <path
                                                d="M347.428 221.952C347.428 222.02 348.135 221.995 348.816 222.462C349.515 222.912 349.762 223.575 349.821 223.549C349.847 223.549 349.821 223.362 349.693 223.108C349.566 222.853 349.31 222.53 348.944 222.283C348.578 222.037 348.178 221.927 347.888 221.91C347.599 221.893 347.428 221.935 347.428 221.961V221.952Z"
                                                fill="#EB996E" />
                                            <path
                                                d="M348.178 221.137C348.161 221.205 348.953 221.357 349.651 221.995C350.366 222.615 350.604 223.388 350.673 223.362C350.698 223.362 350.673 223.15 350.553 222.853C350.426 222.555 350.179 222.165 349.804 221.833C349.429 221.502 349.012 221.298 348.697 221.205C348.382 221.111 348.178 221.111 348.178 221.137Z"
                                                fill="#EB996E" />
                                            <path
                                                d="M342.353 203.584C342.336 203.643 343.52 203.958 345.018 204.068C346.517 204.187 347.735 204.068 347.735 204.009C347.735 203.941 346.526 203.966 345.044 203.847C343.562 203.728 342.37 203.516 342.362 203.584H342.353Z"
                                                fill="#EB996E" />
                                            <path
                                                d="M343.017 204.612C343.017 204.671 343.954 204.739 345.121 204.765C346.279 204.79 347.224 204.765 347.224 204.697C347.224 204.637 346.287 204.569 345.121 204.544C343.963 204.518 343.017 204.544 343.017 204.612Z"
                                                fill="#EB996E" />
                                            <path
                                                d="M371.782 214.603C371.782 214.603 371.91 214.229 371.978 213.601C372.055 212.972 372.089 212.105 372.003 211.145C371.918 210.185 371.722 209.336 371.544 208.732C371.356 208.129 371.195 207.772 371.169 207.781C371.101 207.798 371.62 209.268 371.782 211.162C371.961 213.057 371.705 214.595 371.782 214.603Z"
                                                fill="#B68C6D" />
                                            <path
                                                d="M375.231 220.363C375.231 220.363 375.384 220.006 375.341 219.403C375.307 218.809 375.06 217.95 374.413 217.254C373.766 216.566 372.932 216.251 372.336 216.175C371.731 216.09 371.356 216.192 371.365 216.217C371.365 216.26 371.739 216.217 372.31 216.336C372.872 216.447 373.647 216.77 374.251 217.415C374.848 218.061 375.112 218.851 375.18 219.429C375.256 220.006 375.18 220.372 375.222 220.372L375.231 220.363Z"
                                                fill="#B68C6D" />
                                            <path
                                                d="M304.886 255.86C304.886 255.86 303.387 261.187 303.149 264.908C303.03 266.743 302.366 272.792 302.629 278.561C302.97 285.978 305.44 293.148 309.757 299.197C312.218 302.4 317.063 302.366 319.473 299.129L327.162 288.832L321.38 282.146C321.38 282.146 315.181 270.609 314.278 261.824L304.878 255.851L304.886 255.86Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M304.886 255.86C304.886 255.86 303.387 261.187 303.149 264.908C303.03 266.743 302.366 272.792 302.629 278.561C302.97 285.978 305.44 293.148 309.757 299.197C312.218 302.4 317.063 302.366 319.473 299.129L327.162 288.832L321.38 282.146C321.38 282.146 315.181 270.609 314.278 261.824L304.878 255.851L304.886 255.86Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M343.963 242.682C343.963 242.682 315.479 264.559 317.182 275.366C318.289 282.418 320.69 295.094 320.69 295.094L312.354 300.421L366.588 305.586C366.588 305.586 371.246 293.675 375.835 283.412C378.186 278.153 384.546 261.501 382.35 250.159C381.183 244.152 375.708 240.499 369.389 240.176C366.707 240.04 363.974 239.7 363.607 239.93C358.158 243.268 352.708 245.053 348.893 245.341C345.104 245.622 343.971 242.691 343.971 242.691L343.963 242.682Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M343.963 242.682C343.963 242.682 315.479 264.559 317.182 275.366C318.289 282.418 320.69 295.094 320.69 295.094L312.354 300.421L366.588 305.586C366.588 305.586 371.246 293.675 375.835 283.412C378.186 278.153 384.546 261.501 382.35 250.159C381.183 244.152 375.708 240.499 369.389 240.176C366.707 240.04 363.974 239.7 363.607 239.93C358.158 243.268 352.708 245.053 348.893 245.341C345.104 245.622 343.971 242.691 343.971 242.691L343.963 242.682Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M362.688 246.072C362.688 246.072 368.657 239.165 373.502 240.728C377.59 242.045 381.702 244.322 382.503 250.507C383.303 256.692 378.041 273.166 372.889 280.702C369.347 285.884 349.906 303.947 349.906 303.947L315.181 302.893L341.885 284.245L356.088 261.688L362.688 246.072Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M362.688 246.072C362.688 246.072 368.657 239.165 373.502 240.728C377.59 242.045 381.702 244.322 382.503 250.507C383.303 256.692 378.041 273.166 372.889 280.702C369.347 285.884 349.906 303.947 349.906 303.947L315.181 302.893L341.885 284.245L356.088 261.688L362.688 246.072Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M359.026 254.747C359.026 254.747 358.975 254.908 358.856 255.205C358.728 255.52 358.549 255.97 358.319 256.539C357.826 257.729 357.11 259.47 356.182 261.713V261.73C353.074 266.7 348.161 274.551 342.047 284.338L342.03 284.372L341.996 284.389C334.306 289.775 325.195 296.156 315.309 303.072L315.19 302.681C320.478 302.842 325.961 303.004 331.573 303.173C337.9 303.369 344.056 303.556 349.915 303.734L349.762 303.794C356.531 297.456 362.824 291.449 368.223 285.808C374.03 280.438 376.576 273.752 378.637 268.425C380.63 263.013 381.719 258.51 382.205 255.384C382.341 254.602 382.384 253.906 382.469 253.302C382.494 252.699 382.52 252.189 382.545 251.773C382.528 251.374 382.511 251.068 382.503 250.838C382.503 250.626 382.503 250.516 382.503 250.516C382.503 250.516 382.52 250.618 382.545 250.83C382.562 251.059 382.588 251.374 382.622 251.773C382.614 252.198 382.597 252.708 382.588 253.311C382.52 253.914 382.486 254.619 382.358 255.409C381.915 258.553 380.868 263.081 378.901 268.527C377.913 271.246 376.713 274.202 375.129 277.261C374.303 278.773 373.46 280.353 372.293 281.806C371.126 283.242 369.849 284.652 368.504 286.071C363.114 291.746 356.838 297.762 350.06 304.117L349.992 304.176H349.898C344.039 303.998 337.874 303.811 331.556 303.624C325.944 303.454 320.461 303.284 315.173 303.123L314.517 303.105L315.053 302.732C324.948 295.841 334.076 289.478 341.783 284.117L341.732 284.168C347.914 274.423 352.87 266.607 356.012 261.654V261.671C356.966 259.445 357.715 257.72 358.226 256.531C358.473 255.962 358.669 255.528 358.805 255.214C358.941 254.917 359.018 254.772 359.018 254.772L359.026 254.747Z"
                                                fill="#263238" />
                                            <path
                                                d="M377.317 242.733C377.292 242.81 376.304 242.377 374.626 242.088C372.966 241.799 370.556 241.739 368.086 242.529C365.617 243.32 363.693 244.755 362.509 245.953C361.308 247.16 360.763 248.077 360.695 248.035C360.67 248.018 360.78 247.78 361.036 247.364C361.291 246.947 361.7 246.378 362.279 245.741C363.429 244.458 365.396 242.929 367.95 242.113C370.505 241.298 372.991 241.408 374.677 241.782C375.529 241.969 376.193 242.19 376.636 242.385C377.079 242.572 377.317 242.708 377.3 242.733H377.317Z"
                                                fill="#263238" />
                                            <path
                                                d="M310.821 300.285C310.821 300.285 310.796 300.157 310.813 299.919C310.838 299.681 310.923 299.333 311.119 298.917C311.502 298.093 312.303 297.039 313.41 295.884C314.517 294.72 315.922 293.428 317.48 292.009C318.255 291.296 319.072 290.548 319.856 289.724C320.239 289.308 320.631 288.883 320.946 288.407C321.252 287.94 321.448 287.379 321.601 286.81C321.874 285.672 321.959 284.423 321.108 283.683C320.724 283.301 320.282 282.91 319.898 282.486C319.728 282.265 319.549 282.044 319.379 281.823C319.226 281.593 319.081 281.364 318.936 281.135C317.846 279.274 317.395 277.362 317.191 275.765C316.978 274.168 317.088 272.851 317.233 271.968C317.31 271.526 317.386 271.186 317.463 270.957C317.531 270.727 317.574 270.617 317.591 270.617C317.633 270.625 317.497 271.101 317.412 271.985C317.327 272.86 317.267 274.16 317.514 275.723C317.753 277.278 318.238 279.138 319.302 280.922C319.447 281.135 319.592 281.356 319.737 281.576C319.898 281.78 320.069 281.993 320.239 282.205C320.597 282.604 321.005 282.961 321.44 283.386C321.865 283.794 322.215 284.431 322.232 285.06C322.283 285.688 322.198 286.309 322.044 286.92C321.882 287.524 321.678 288.118 321.329 288.645C320.988 289.163 320.588 289.605 320.188 290.021C319.379 290.854 318.553 291.602 317.77 292.307C316.194 293.717 314.772 294.975 313.648 296.105C312.524 297.226 311.707 298.229 311.289 299.002C310.864 299.783 310.889 300.293 310.847 300.285H310.821Z"
                                                fill="#263238" />
                                            <path
                                                d="M341.893 284.329C341.893 284.329 341.664 284.389 341.246 284.389C340.829 284.389 340.224 284.329 339.492 284.168C338.045 283.845 336.018 283.029 334.451 281.288C332.918 279.546 332.195 277.516 331.948 276.054C331.82 275.315 331.794 274.712 331.803 274.296C331.811 273.879 331.854 273.65 331.88 273.65C331.956 273.65 331.931 274.567 332.254 275.995C332.569 277.405 333.31 279.334 334.783 280.999C336.256 282.639 338.181 283.48 339.569 283.862C340.974 284.261 341.902 284.244 341.893 284.321V284.329Z"
                                                fill="#263238" />
                                            <g opacity="0.3">
                                                <path
                                                    d="M331.914 274.78C331.258 277.15 331.616 279.988 333.165 281.908C334.707 283.828 337.866 284.363 340.335 284.236C335.235 283.548 332.62 279.096 331.922 274.78H331.914Z"
                                                    fill="black" />
                                            </g>
                                            <path
                                                d="M350.613 299.18C350.613 299.231 350.077 299.282 349.225 299.104C348.382 298.934 347.241 298.458 346.228 297.608C345.206 296.75 344.55 295.722 344.227 294.924C343.903 294.125 343.869 293.581 343.912 293.573C343.98 293.556 344.124 294.057 344.508 294.788C344.882 295.518 345.546 296.461 346.509 297.268C347.471 298.067 348.518 298.56 349.302 298.798C350.094 299.044 350.613 299.095 350.605 299.172L350.613 299.18Z"
                                                fill="#263238" />
                                            <g opacity="0.3">
                                                <path
                                                    d="M318.902 300.293C328.678 301.483 340.395 302.799 350.23 303.369C340.965 298.925 328.78 297.455 318.902 300.293Z"
                                                    fill="black" />
                                            </g>
                                            <g opacity="0.3">
                                                <path
                                                    d="M321.602 284.788C321.269 283.565 320.401 282.579 319.694 281.534C318.238 279.385 317.404 276.819 317.301 274.228C316.314 275.578 316.135 277.363 316.314 279.028C316.492 280.684 316.995 282.299 317.25 283.947C317.438 285.145 317.48 286.419 316.969 287.515C316.262 289.027 314.679 289.886 313.427 290.99C310.847 293.267 309.995 296.886 310.634 300.259C311.613 297.931 313.461 295.722 315.343 294.04C316.816 292.723 318.519 291.653 319.847 290.191C321.176 288.73 322.113 286.7 321.593 284.788H321.602Z"
                                                    fill="black" />
                                            </g>
                                            <g opacity="0.3">
                                                <path
                                                    d="M351.899 302.298C361.283 298.398 368.282 290.837 372.472 281.585C365.643 288.424 358.813 295.535 351.899 302.298Z"
                                                    fill="black" />
                                            </g>
                                            <path
                                                d="M225.668 339.026L211.942 355.134L209.498 362.262C208.57 364.964 206.552 363.707 203.835 362.781L170.762 351.498C170.762 351.498 170.336 347.649 173.129 347.454C175.922 347.25 197.909 343.384 197.909 343.384L209.591 327.735L225.66 339.034L225.668 339.026Z"
                                                fill="#E0E0E0" />
                                            <path
                                                d="M228.01 338.618L224.357 342.425C223.795 343.011 222.884 343.07 222.254 342.577L207.786 331.337C207.148 330.845 206.986 329.944 207.42 329.264L210.145 324.923C210.639 324.133 211.703 323.946 212.444 324.507L227.84 336.282C228.581 336.851 228.666 337.939 228.019 338.618H228.01Z"
                                                fill="#E0E0E0" />
                                            <path
                                                d="M207.199 330.938C207.199 330.938 207.923 331.754 209.217 332.935C210.511 334.115 212.342 335.713 214.445 337.361C216.557 339.009 218.558 340.385 220.04 341.329C220.781 341.796 221.385 342.17 221.819 342.408C222.245 342.645 222.492 342.773 222.509 342.747C222.543 342.696 221.649 342.085 220.21 341.082C218.78 340.08 216.821 338.669 214.718 337.03C212.614 335.39 210.767 333.835 209.421 332.714C208.076 331.592 207.241 330.896 207.199 330.946V330.938Z"
                                                fill="#263238" />
                                            <path
                                                d="M220.559 340.827C220.585 340.929 222.399 340.105 223.744 338.143C225.106 336.197 225.243 334.218 225.132 334.226C225.004 334.192 224.681 336.053 223.386 337.896C222.118 339.757 220.483 340.708 220.559 340.819V340.827Z"
                                                fill="#263238" />
                                            <path
                                                d="M214.726 337.37C214.811 337.446 216.225 336.053 217.758 334.141C219.29 332.238 220.355 330.556 220.261 330.496C220.159 330.428 218.95 331.983 217.426 333.878C215.901 335.772 214.641 337.293 214.735 337.37H214.726Z"
                                                fill="#263238" />
                                            <path
                                                d="M209.396 332.28C209.515 332.34 210.153 330.479 211.916 328.941C213.645 327.37 215.569 326.953 215.527 326.826C215.518 326.775 215.024 326.809 214.275 327.064C213.526 327.31 212.538 327.82 211.627 328.627C210.724 329.434 210.102 330.36 209.77 331.074C209.438 331.787 209.345 332.272 209.396 332.289V332.28Z"
                                                fill="#263238" />
                                            <path
                                                d="M201.511 361.77C201.579 361.804 201.86 361.192 202.507 360.342C203.145 359.493 204.201 358.431 205.632 357.666C207.062 356.91 208.544 356.63 209.6 356.579C210.664 356.519 211.337 356.63 211.346 356.553C211.354 356.511 210.698 356.29 209.592 356.273C208.493 356.247 206.935 356.485 205.428 357.284C203.92 358.082 202.847 359.238 202.251 360.164C201.647 361.09 201.459 361.753 201.502 361.77H201.511Z"
                                                fill="#263238" />
                                            <path
                                                d="M180.529 354.829C180.529 354.829 180.903 354.472 181.253 353.724C181.593 352.985 181.866 351.821 181.661 350.564C181.457 349.306 180.912 348.287 180.478 347.616C180.026 346.936 179.677 346.579 179.635 346.613C179.584 346.656 179.839 347.072 180.214 347.777C180.571 348.474 181.048 349.468 181.236 350.64C181.431 351.813 181.227 352.883 180.972 353.622C180.716 354.361 180.469 354.795 180.537 354.837L180.529 354.829Z"
                                                fill="#263238" />
                                            <path
                                                d="M211.099 340.836L190.355 345.16L184.046 349.298C181.653 350.87 180.827 348.635 179.26 346.248L160.067 317.107C160.067 317.107 162.093 313.81 164.426 315.357C166.76 316.903 186.506 327.293 186.506 327.293L205.359 322.077L211.107 340.836H211.099Z"
                                                fill="#FAFAFA" />
                                            <path
                                                d="M213.202 341.941L207.973 342.714C207.173 342.833 206.415 342.331 206.211 341.55L201.689 323.827C201.493 323.046 201.919 322.238 202.677 321.967L207.497 320.199C208.365 319.877 209.327 320.378 209.566 321.278L214.488 339.995C214.726 340.904 214.122 341.813 213.193 341.949L213.202 341.941Z"
                                                fill="#E0E0E0" />
                                            <path
                                                d="M201.485 323.147C201.425 323.156 201.561 324.235 201.851 325.96C202.149 327.684 202.609 330.063 203.265 332.654C203.92 335.246 204.653 337.557 205.24 339.213C205.538 340.037 205.794 340.7 205.981 341.15C206.168 341.601 206.287 341.847 206.322 341.839C206.381 341.813 206.049 340.785 205.53 339.12C205.01 337.455 204.329 335.135 203.682 332.552C203.035 329.97 202.524 327.616 202.149 325.909C201.783 324.201 201.544 323.147 201.485 323.156V323.147Z"
                                                fill="#263238" />
                                            <path
                                                d="M205.964 339.128C205.921 339.222 207.863 339.68 210.128 338.958C212.402 338.253 213.721 336.775 213.636 336.715C213.551 336.613 212.163 337.888 210 338.55C207.854 339.247 205.981 339.001 205.972 339.137L205.964 339.128Z"
                                                fill="#263238" />
                                            <path
                                                d="M203.477 332.832C203.494 332.943 205.47 332.705 207.854 332.136C210.239 331.567 212.103 330.895 212.069 330.785C212.035 330.666 210.119 331.159 207.752 331.72C205.385 332.289 203.46 332.714 203.477 332.832Z"
                                                fill="#263238" />
                                            <path
                                                d="M202.396 325.552C202.456 325.67 204.108 324.592 206.432 324.456C208.765 324.277 210.545 325.118 210.588 324.991C210.613 324.948 210.204 324.668 209.455 324.413C208.714 324.15 207.616 323.946 206.407 324.031C205.198 324.116 204.142 324.464 203.435 324.829C202.728 325.186 202.362 325.518 202.396 325.56V325.552Z"
                                                fill="#263238" />
                                            <path
                                                d="M178.042 344.03C178.076 344.09 178.672 343.784 179.711 343.512C180.733 343.232 182.223 343.036 183.824 343.308C185.425 343.589 186.762 344.268 187.631 344.88C188.508 345.483 188.967 345.976 189.027 345.933C189.061 345.908 188.678 345.33 187.818 344.642C186.966 343.954 185.587 343.181 183.901 342.892C182.223 342.603 180.665 342.858 179.626 343.223C178.579 343.589 178.025 343.996 178.051 344.039L178.042 344.03Z"
                                                fill="#263238" />
                                            <path
                                                d="M165.729 325.713C165.746 325.756 166.249 325.662 166.972 325.289C167.696 324.915 168.624 324.159 169.237 323.046C169.851 321.933 170.038 320.794 170.115 319.987C170.174 319.18 170.115 318.679 170.063 318.679C169.995 318.679 169.944 319.171 169.808 319.953C169.663 320.726 169.433 321.805 168.863 322.842C168.292 323.887 167.475 324.609 166.819 325.034C166.163 325.458 165.704 325.654 165.729 325.722V325.713Z"
                                                fill="#263238" />
                                            <path
                                                d="M269.054 304.94C269.76 303.131 264.813 300.225 262.812 298.517C258.699 295.025 248.421 293.768 243.142 295.238C235.793 297.285 223.625 312.009 220.006 315.577C216.387 319.145 205.342 337.131 205.342 337.131L218.277 347.556L258.026 321.134L269.054 304.949V304.94Z"
                                                fill="#263238" />
                                            <path
                                                d="M196.018 324.014C196.018 324.014 200.063 330.505 198.539 344.344C198.539 344.344 202.958 346.919 205.496 343.036C205.359 342.756 245.151 343.036 263.4 329.544C266.661 327.132 269.13 327.726 273.379 325.568C273.379 325.568 292.045 331.422 304.724 333.937C312.184 335.415 330.883 338.1 346.483 338.992C353.44 339.391 361.709 337.148 364.944 330.454C367.209 325.772 367.737 317.642 366.945 311.261L364.851 304.957C364.851 304.957 273.328 294.643 262.412 297.778C253.437 300.352 202.66 320.182 202.66 320.182C202.66 320.182 196.035 317.132 196.035 324.022L196.018 324.014Z"
                                                fill="#263238" />
                                            <path
                                                d="M205.496 343.036C205.41 343.002 205.93 341.745 206.356 339.612C206.79 337.48 207.003 334.455 206.551 331.159C206.126 327.862 205.163 324.982 204.363 322.96C203.537 320.938 202.89 319.749 202.966 319.706C202.992 319.689 203.179 319.978 203.486 320.513C203.801 321.04 204.201 321.839 204.661 322.841C205.547 324.846 206.577 327.752 207.003 331.108C207.454 334.455 207.19 337.539 206.671 339.68C206.56 340.224 206.415 340.7 206.279 341.116C206.16 341.532 206.032 341.889 205.904 342.178C205.674 342.747 205.53 343.053 205.504 343.045L205.496 343.036Z"
                                                fill="#B68C6D" />
                                            <path
                                                d="M260.002 298.305C260.002 298.305 259.806 298.407 259.431 298.551C259.014 298.704 258.461 298.917 257.771 299.172C256.272 299.715 254.195 300.472 251.64 301.406C246.463 303.292 239.318 305.934 231.45 308.908C223.608 311.899 216.514 314.6 211.32 316.571C208.783 317.54 206.705 318.33 205.223 318.899C204.533 319.154 203.98 319.358 203.563 319.519C203.179 319.655 202.975 319.723 202.975 319.706C202.975 319.689 203.162 319.596 203.537 319.435C203.954 319.256 204.491 319.027 205.172 318.738C206.645 318.135 208.697 317.302 211.218 316.274C216.336 314.226 223.429 311.457 231.305 308.483C239.174 305.518 246.335 302.918 251.546 301.109C254.152 300.2 256.264 299.486 257.728 299.01C258.427 298.789 258.989 298.611 259.423 298.467C259.815 298.348 260.019 298.297 260.019 298.305H260.002Z"
                                                fill="#B68C6D" />
                                            <path
                                                d="M279.025 323.572C279.025 323.572 278.787 323.674 278.318 323.827C277.816 323.988 277.135 324.209 276.283 324.481C274.521 325.059 271.957 325.9 268.883 327.165C265.792 328.423 262.259 330.199 258.554 332.662C257.592 333.232 256.562 333.741 255.463 334.158C254.356 334.565 253.241 334.922 252.091 335.313C249.801 336.086 247.425 336.885 244.99 337.7H244.973C244.53 337.811 244.053 337.921 243.576 338.04C233.213 340.462 223.616 341.388 216.71 342.084C213.279 342.39 210.486 342.645 208.51 342.824C207.573 342.9 206.824 342.959 206.279 343.002C206.049 343.019 205.853 343.027 205.7 343.036C205.572 343.036 205.504 343.036 205.504 343.036C205.504 343.036 205.572 343.01 205.7 342.993C205.853 342.976 206.049 342.942 206.279 342.917C206.824 342.858 207.565 342.764 208.502 342.662C210.477 342.45 213.262 342.152 216.685 341.787C223.582 341.014 233.162 340.037 243.482 337.624C243.959 337.514 244.436 337.395 244.879 337.293H244.862C247.297 336.477 249.673 335.687 251.964 334.914C253.105 334.523 254.246 334.166 255.319 333.775C256.392 333.368 257.405 332.875 258.35 332.323C259.295 331.779 260.181 331.142 261.1 330.623C262.003 330.08 262.906 329.604 263.783 329.145C265.537 328.244 267.214 327.505 268.773 326.885C271.881 325.645 274.461 324.846 276.241 324.319C277.135 324.056 277.824 323.861 278.301 323.742C278.778 323.614 279.025 323.563 279.025 323.572Z"
                                                fill="#B68C6D" />
                                            <path
                                                d="M369.968 297.175L350.613 303.411C353.772 308.11 359.852 310.463 365.157 308.458C366.639 307.897 368.163 306.835 368.333 305.263C368.419 304.465 368.018 303.7 367.993 302.893C367.967 302.12 369.33 298.756 369.968 297.175Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M369.968 297.175L350.613 303.411C353.772 308.11 359.852 310.463 365.157 308.458C366.639 307.897 368.163 306.835 368.333 305.263C368.419 304.465 368.018 303.7 367.993 302.893C367.967 302.12 369.33 298.756 369.968 297.175Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M323.73 227.423L311.281 227.177C310.37 227.16 309.638 227.933 309.714 228.842L312.345 258.782L326.183 259.317C327.111 259.351 327.86 258.57 327.775 257.652L325.229 228.825C325.161 228.044 324.514 227.44 323.73 227.423Z"
                                                fill="#263238" />
                                            <path
                                                d="M304.937 258.867V249.164C304.937 249.164 305.55 245.35 307.032 245.596L310.234 238.842L315.002 234.636H319.967C319.967 234.636 320.461 237.363 318.366 237.856L315.002 238.961L314.304 240.677L313.81 245.961L319.473 244.118L326.472 244.61C326.472 244.61 327.843 246.7 325.629 247.686L321.44 248.179L314.994 251.008L320.946 249.53L327.843 249.776C327.843 249.776 328.337 251.934 325.876 252.231C323.415 252.529 321.321 253.336 321.321 253.336L315.777 255.545L320.946 255.001L326.472 255.545C326.472 255.545 325.995 257.023 324.028 257.261C322.061 257.507 319.345 257.754 319.345 257.754L316.407 258.858C316.407 258.858 316.016 260.702 314.048 262.792C314.048 262.792 312.567 264.635 310.728 264.508C308.88 264.389 304.937 262.299 304.937 260.574V258.858V258.867Z"
                                                fill="#FFBE9D" />
                                            <path
                                                d="M310.711 248.451C310.676 248.51 310.378 248.391 309.893 248.374C309.416 248.357 308.718 248.493 308.19 248.978C307.662 249.462 307.466 250.15 307.441 250.626C307.407 251.11 307.509 251.416 307.441 251.441C307.398 251.467 307.177 251.187 307.126 250.626C307.066 250.091 307.236 249.25 307.883 248.646C308.539 248.052 309.391 247.95 309.919 248.06C310.472 248.162 310.736 248.4 310.702 248.442L310.711 248.451Z"
                                                fill="#EB996E" />
                                            <path
                                                d="M311.715 252.172C311.749 252.3 310.975 252.563 310.234 253.175C309.476 253.778 309.067 254.475 308.948 254.424C308.837 254.39 309.11 253.514 309.953 252.835C310.796 252.147 311.707 252.053 311.715 252.172Z"
                                                fill="#EB996E" />
                                            <path
                                                d="M312.022 256.573C312.005 256.7 311.664 256.76 311.272 256.862C310.881 256.964 310.549 257.074 310.481 256.972C310.404 256.879 310.685 256.556 311.162 256.437C311.639 256.309 312.039 256.454 312.022 256.573Z"
                                                fill="#EB996E" />
                                            <path
                                                d="M317.574 231.977C318.119 231.977 318.562 231.536 318.562 230.992C318.562 230.448 318.119 230.006 317.574 230.006C317.028 230.006 316.586 230.448 316.586 230.992C316.586 231.536 317.028 231.977 317.574 231.977Z"
                                                fill="white" />
                                            <path
                                                d="M482.881 407.767C482.881 407.886 396.068 407.988 289.005 407.988C181.942 407.988 95.1034 407.886 95.1034 407.767C95.1034 407.648 181.9 407.546 289.005 407.546C396.11 407.546 482.881 407.648 482.881 407.767Z"
                                                fill="#263238" />
                                            <path
                                                d="M258.146 56.2134H242.367C240.255 56.2049 238.535 57.9891 238.535 60.198V63.0526C238.535 65.2616 236.815 67.0457 234.703 67.0457L203.954 67.0287C201.842 67.0287 200.122 65.2361 200.122 63.0272V60.1725C200.122 57.9636 198.411 56.1794 196.291 56.1709H176.935C170.08 56.1539 164.511 61.7018 164.511 68.541L164.469 267.21C164.469 274.049 170.021 279.597 176.876 279.597L258.086 279.648C264.941 279.648 270.501 274.109 270.51 267.261L270.552 68.592C270.552 61.7528 265 56.2049 258.146 56.2049V56.2134Z"
                                                fill="#F9E6D9" />
                                            <path
                                                d="M258.146 56.2134C258.146 56.2134 258.29 56.2134 258.571 56.2219C258.852 56.2474 259.278 56.2219 259.832 56.3154C260.93 56.4428 262.608 56.7997 264.489 57.9211C265.443 58.4564 266.405 59.2295 267.325 60.215C268.236 61.2006 269.079 62.4325 269.692 63.9108C270.305 65.3806 270.638 67.1052 270.62 68.9404C270.62 70.767 270.62 72.7126 270.62 74.7771C270.629 91.2847 270.646 115.158 270.663 144.665C270.663 174.171 270.672 209.302 270.68 248.307C270.68 253.183 270.68 258.119 270.68 263.115V266.87C270.663 268.128 270.586 269.428 270.203 270.651C269.846 271.874 269.335 273.072 268.619 274.143C267.904 275.213 267.036 276.182 266.031 277.006C264.013 278.62 261.484 279.657 258.861 279.784C256.255 279.861 253.675 279.801 251.061 279.818C245.841 279.818 240.57 279.818 235.248 279.818C224.612 279.818 213.789 279.81 202.805 279.801C197.312 279.801 191.777 279.801 186.208 279.793C183.424 279.793 180.631 279.793 177.829 279.793C175.019 279.937 172.099 279.198 169.748 277.567C167.381 275.952 165.644 273.497 164.827 270.787C164.392 269.436 164.307 267.992 164.307 266.598C164.307 265.205 164.307 263.812 164.307 262.418C164.307 256.862 164.307 251.34 164.307 245.86C164.307 234.9 164.307 224.093 164.316 213.482C164.316 192.25 164.333 171.775 164.341 152.269C164.35 132.762 164.358 114.224 164.367 96.875C164.367 88.2007 164.375 79.8237 164.384 71.7695C164.384 70.767 164.384 69.7645 164.384 68.7619C164.384 68.2607 164.426 67.7594 164.452 67.2582C164.537 66.7654 164.58 66.2641 164.707 65.7799C165.159 63.8428 166.061 62.0247 167.322 60.5294C168.59 59.0426 170.174 57.8616 171.928 57.097C173.674 56.3069 175.598 56.035 177.446 56.052C181.142 56.052 184.752 56.052 188.269 56.0605C190.023 56.0605 191.76 56.0605 193.472 56.0605C194.332 56.0605 195.175 56.0605 196.027 56.0605C196.878 56.018 197.772 56.2559 198.47 56.7402C199.169 57.2329 199.714 57.9381 199.986 58.7282C200.301 59.5269 200.225 60.3849 200.242 61.1751C200.242 61.5744 200.242 61.9822 200.242 62.3815C200.242 62.7808 200.225 63.1801 200.284 63.5624C200.386 64.3271 200.71 65.0662 201.212 65.6354C201.706 66.2132 202.379 66.6295 203.111 66.8079C203.477 66.9013 203.844 66.9268 204.227 66.9183C204.61 66.9183 204.993 66.9183 205.368 66.9183C206.884 66.9183 208.382 66.9183 209.847 66.9183C215.722 66.9268 221.189 66.9353 226.213 66.9438C228.725 66.9438 231.135 66.9438 233.434 66.9523C234.005 66.9438 234.584 66.9778 235.129 66.9353C235.674 66.8758 236.193 66.6889 236.644 66.4001C237.556 65.8308 238.177 64.8963 238.382 63.9023C238.492 63.4095 238.475 62.8997 238.475 62.3985C238.475 61.8972 238.475 61.4045 238.475 60.9202C238.475 60.4359 238.45 59.9516 238.543 59.4759C238.629 59.0001 238.782 58.5498 239.012 58.1505C239.463 57.3349 240.187 56.7232 240.996 56.4003C241.813 56.0435 242.682 56.154 243.465 56.137C246.65 56.137 249.341 56.154 251.521 56.1625C253.692 56.171 255.353 56.1795 256.477 56.1795C257.592 56.1795 258.163 56.1964 258.163 56.1964C258.163 56.1964 257.592 56.2049 256.477 56.2134C255.361 56.2134 253.701 56.2134 251.521 56.2304C249.341 56.2304 246.65 56.2304 243.465 56.2389C242.673 56.2559 241.83 56.154 241.038 56.5023C240.255 56.8082 239.548 57.4114 239.122 58.2015C238.901 58.5923 238.748 59.0341 238.671 59.4929C238.586 59.9516 238.62 60.4274 238.612 60.9202C238.612 61.4045 238.612 61.8972 238.612 62.3985C238.612 62.8912 238.629 63.418 238.518 63.9278C238.305 64.9558 237.666 65.9243 236.721 66.519C236.253 66.8164 235.708 67.0118 235.146 67.0797C234.575 67.1307 234.013 67.0967 233.434 67.1052C231.144 67.1052 228.734 67.1052 226.213 67.1052C221.181 67.1052 215.714 67.1052 209.847 67.1052C208.382 67.1052 206.884 67.1052 205.368 67.1052C204.985 67.1052 204.61 67.1052 204.227 67.1052C203.852 67.1052 203.443 67.0882 203.06 66.9948C202.294 66.8079 201.579 66.3661 201.051 65.7544C200.523 65.1512 200.174 64.378 200.071 63.5709C200.012 63.1631 200.029 62.7638 200.029 62.3645V61.1581C200.02 60.351 200.088 59.5354 199.782 58.7877C199.518 58.0316 199.007 57.3689 198.343 56.9101C197.67 56.4513 196.861 56.2304 196.027 56.2729H193.472C191.76 56.2729 190.023 56.2729 188.269 56.2729C184.752 56.2729 181.142 56.2729 177.446 56.2729C175.607 56.2559 173.742 56.5278 172.03 57.3009C170.319 58.0571 168.761 59.2125 167.526 60.6653C166.3 62.1266 165.414 63.9108 164.971 65.8054C164.844 66.2811 164.81 66.7654 164.724 67.2497C164.699 67.7424 164.665 68.2267 164.656 68.728C164.656 69.722 164.656 70.7245 164.656 71.7355C164.656 79.7897 164.656 88.1667 164.656 96.841C164.656 114.19 164.656 132.728 164.656 152.235C164.656 171.741 164.656 192.216 164.656 213.448C164.656 224.059 164.656 234.866 164.656 245.826C164.656 251.306 164.656 256.828 164.656 262.384C164.656 263.778 164.656 265.163 164.656 266.564C164.656 267.949 164.733 269.334 165.159 270.659C165.951 273.302 167.645 275.681 169.944 277.252C172.243 278.833 175.045 279.555 177.829 279.419C180.631 279.419 183.424 279.419 186.208 279.419C191.777 279.419 197.312 279.419 202.805 279.427C213.789 279.427 224.612 279.444 235.248 279.453C240.57 279.453 245.841 279.453 251.061 279.461C253.667 279.444 256.281 279.504 258.844 279.427C261.398 279.3 263.859 278.297 265.818 276.726C266.789 275.918 267.64 274.984 268.338 273.939C269.037 272.894 269.531 271.73 269.88 270.541C270.254 269.343 270.331 268.094 270.348 266.853C270.348 265.596 270.348 264.347 270.348 263.098C270.348 258.102 270.348 253.166 270.348 248.29C270.374 209.285 270.391 174.146 270.408 144.648C270.433 115.141 270.459 91.2677 270.476 74.7601C270.476 72.6956 270.476 70.75 270.484 68.9234C270.51 67.0967 270.186 65.3975 269.582 63.9362C268.986 62.4664 268.151 61.243 267.248 60.2575C266.346 59.272 265.384 58.5073 264.447 57.9721C262.582 56.8506 260.913 56.4853 259.823 56.3409C259.278 56.2304 258.852 56.2559 258.571 56.2219C258.29 56.2049 258.146 56.1879 258.146 56.1879V56.2134Z"
                                                fill="#263238" />
                                            <path
                                                d="M260.547 76.2723C260.547 76.3232 258.495 76.3827 255.966 76.4082C253.437 76.4252 251.385 76.4082 251.385 76.3487C251.385 76.2977 253.437 76.2383 255.966 76.2128C258.495 76.1958 260.547 76.2128 260.547 76.2723Z"
                                                fill="#263238" />
                                            <path
                                                d="M260.564 78.6087C260.564 78.6597 258.512 78.7191 255.983 78.7446C253.454 78.7616 251.401 78.7446 251.401 78.6851C251.401 78.6342 253.454 78.5747 255.983 78.5492C258.512 78.5322 260.564 78.5492 260.564 78.6087Z"
                                                fill="#263238" />
                                            <path
                                                d="M260.581 80.9534C260.581 81.0044 258.529 81.0639 256 81.0893C253.471 81.1063 251.419 81.0893 251.419 81.0299C251.419 80.9789 253.471 80.9194 256 80.8939C258.529 80.8769 260.581 80.8939 260.581 80.9534Z"
                                                fill="#263238" />
                                            <path
                                                d="M177.182 83.6213C177.182 83.6213 177.25 83.6213 177.37 83.6128C177.523 83.6128 177.693 83.6043 177.898 83.5958C178.4 83.5873 179.056 83.5703 179.856 83.5533L179.805 83.6043C179.805 83.171 179.788 82.6953 179.779 82.1855C179.779 81.9221 179.754 81.6757 179.779 81.3699C179.831 81.064 180.103 80.8007 180.435 80.7667C180.75 80.7667 181.031 80.7497 181.372 80.7667C181.721 80.8092 182.027 81.149 182.01 81.5228C182.01 82.1855 182.027 82.8737 182.036 83.5873L181.942 83.5024C182.734 83.5024 183.56 83.4854 184.412 83.4769L184.318 83.5703C184.31 82.5763 184.301 81.5483 184.293 80.5033V79.7217C184.293 79.4838 184.139 79.3224 183.935 79.144C183.569 78.7871 183.211 78.4303 182.853 78.082C182.496 77.7336 182.155 77.3938 181.815 77.054C181.644 76.884 181.474 76.7226 181.312 76.5527C181.142 76.3828 181.006 76.2129 180.801 76.1704C180.605 76.1194 180.393 76.1619 180.231 76.2808C180.077 76.4083 179.924 76.5867 179.771 76.7311C179.464 77.037 179.175 77.3343 178.885 77.6232C178.332 78.2009 177.744 78.7277 177.327 79.2289C177.148 79.5008 177.216 79.8406 177.199 80.1465C177.199 80.4523 177.199 80.7412 177.199 81.0131C177.199 81.5483 177.199 82.0156 177.191 82.4149C177.191 82.7717 177.191 83.0691 177.182 83.307C177.182 83.5109 177.182 83.6213 177.174 83.6298C177.165 83.6383 177.165 83.5364 177.157 83.3325C177.157 83.0946 177.14 82.8057 177.131 82.4489C177.123 82.0496 177.114 81.5738 177.097 81.0385C177.097 80.7582 177.089 80.4608 177.08 80.155C177.08 79.9935 177.08 79.8321 177.08 79.6707C177.08 79.4923 177.123 79.3139 177.216 79.1524C177.676 78.5917 178.221 78.099 178.783 77.5042C179.064 77.2154 179.362 76.918 179.66 76.6037C179.822 76.4507 179.95 76.2978 180.137 76.1364C180.333 75.9835 180.605 75.9325 180.852 75.992C181.116 76.0514 181.287 76.2638 181.448 76.4168C181.619 76.5782 181.781 76.7481 181.951 76.9095C182.291 77.2409 182.641 77.5807 182.998 77.929C183.356 78.2774 183.713 78.6257 184.08 78.991C184.165 79.0845 184.267 79.1609 184.352 79.2884C184.429 79.4073 184.48 79.5603 184.48 79.7047C184.48 79.9681 184.48 80.2229 184.48 80.4863C184.48 81.5398 184.497 82.5593 184.505 83.5533V83.6468H184.412C183.56 83.6468 182.734 83.6553 181.942 83.6638H181.849V83.5788C181.849 82.8652 181.849 82.177 181.84 81.5143C181.849 81.217 181.619 80.9536 181.338 80.9196C181.057 80.9026 180.716 80.9196 180.444 80.9196C180.18 80.9451 179.958 81.1575 179.907 81.3954C179.882 81.6418 179.907 81.9306 179.899 82.1855C179.899 82.6953 179.899 83.171 179.899 83.6043V83.6638H179.848C179.03 83.6638 178.366 83.6553 177.855 83.6468C177.651 83.6468 177.48 83.6468 177.336 83.6383C177.216 83.6383 177.165 83.6383 177.165 83.6298L177.182 83.6213Z"
                                                fill="#263238" />
                                            <path
                                                d="M258.869 238.052C258.869 238.162 241.626 238.247 220.363 238.247C199.101 238.247 181.857 238.162 181.857 238.052C181.857 237.941 199.092 237.856 220.363 237.856C241.635 237.856 258.869 237.941 258.869 238.052Z"
                                                fill="#263238" />
                                            <path
                                                d="M241.796 242.971C241.796 243.082 230.914 243.167 217.485 243.167C204.056 243.167 193.174 243.082 193.174 242.971C193.174 242.861 204.056 242.776 217.485 242.776C230.914 242.776 241.796 242.861 241.796 242.971Z"
                                                fill="#263238" />
                                            <path
                                                d="M210.417 82.8225C210.417 83.8081 209.677 84.4198 208.493 84.4198H207.599V85.6347H206.577V81.2168H208.493C209.677 81.2168 210.417 81.8285 210.417 82.8225ZM209.379 82.8225C209.379 82.3383 209.063 82.0494 208.433 82.0494H207.599V83.5872H208.433C209.063 83.5872 209.379 83.3068 209.379 82.8225Z"
                                                fill="#263238" />
                                            <path
                                                d="M213.185 82.1938V83.1029C213.1 83.1029 213.04 83.0944 212.964 83.0944C212.419 83.0944 212.061 83.3918 212.061 84.0375V85.6432H211.073V82.2448H212.018V82.6951C212.257 82.3638 212.665 82.1938 213.185 82.1938Z"
                                                fill="#263238" />
                                            <path
                                                d="M213.491 83.944C213.491 82.9245 214.283 82.1938 215.365 82.1938C216.446 82.1938 217.23 82.916 217.23 83.944C217.23 84.972 216.446 85.6942 215.365 85.6942C214.283 85.6942 213.491 84.972 213.491 83.944ZM216.233 83.944C216.233 83.3578 215.859 83.001 215.365 83.001C214.871 83.001 214.488 83.3578 214.488 83.944C214.488 84.5302 214.871 84.8871 215.365 84.8871C215.859 84.8871 216.233 84.5302 216.233 83.944Z"
                                                fill="#263238" />
                                            <path
                                                d="M217.638 83.944C217.638 82.9245 218.43 82.1938 219.537 82.1938C220.253 82.1938 220.815 82.4997 221.062 83.0604L220.295 83.4682C220.108 83.1454 219.835 83.001 219.529 83.001C219.026 83.001 218.635 83.3493 218.635 83.944C218.635 84.5387 219.026 84.8871 219.529 84.8871C219.835 84.8871 220.108 84.7511 220.295 84.4198L221.062 84.8361C220.815 85.3798 220.253 85.6942 219.537 85.6942C218.43 85.6942 217.638 84.972 217.638 83.944Z"
                                                fill="#263238" />
                                            <path
                                                d="M224.902 84.2161H222.33C222.424 84.6409 222.79 84.8958 223.301 84.8958C223.659 84.8958 223.923 84.7853 224.153 84.5644L224.68 85.1336C224.365 85.4905 223.889 85.6859 223.275 85.6859C222.1 85.6859 221.334 84.9467 221.334 83.9357C221.334 82.9247 222.109 82.1855 223.148 82.1855C224.187 82.1855 224.919 82.8567 224.919 83.9442C224.919 84.0207 224.91 84.1311 224.902 84.2076V84.2161ZM222.313 83.6384H223.991C223.923 83.2051 223.599 82.9332 223.156 82.9332C222.713 82.9332 222.381 83.2051 222.313 83.6384Z"
                                                fill="#263238" />
                                            <path
                                                d="M225.251 85.3202L225.583 84.615C225.89 84.8104 226.35 84.9463 226.767 84.9463C227.227 84.9463 227.397 84.8274 227.397 84.6405C227.397 84.0882 225.336 84.649 225.336 83.2981C225.336 82.6524 225.915 82.2021 226.912 82.2021C227.38 82.2021 227.899 82.3126 228.223 82.4995L227.891 83.1962C227.559 83.0093 227.218 82.9413 226.912 82.9413C226.469 82.9413 226.281 83.0772 226.281 83.2556C226.281 83.8334 228.342 83.2726 228.342 84.615C228.342 85.2437 227.755 85.694 226.733 85.694C226.154 85.694 225.575 85.5326 225.26 85.3287L225.251 85.3202Z"
                                                fill="#263238" />
                                            <path
                                                d="M228.615 85.3202L228.947 84.615C229.253 84.8104 229.713 84.9463 230.13 84.9463C230.59 84.9463 230.76 84.8274 230.76 84.6405C230.76 84.0882 228.7 84.649 228.7 83.2981C228.7 82.6524 229.279 82.2021 230.275 82.2021C230.743 82.2021 231.263 82.3126 231.586 82.4995L231.254 83.1962C230.922 83.0093 230.582 82.9413 230.275 82.9413C229.832 82.9413 229.645 83.0772 229.645 83.2556C229.645 83.8334 231.706 83.2726 231.706 84.615C231.706 85.2437 231.118 85.694 230.096 85.694C229.517 85.694 228.938 85.5326 228.623 85.3287L228.615 85.3202Z"
                                                fill="#263238" />
                                            <path
                                                d="M244.291 92.3808C244.291 92.4913 233.579 92.6527 220.372 92.7462C207.156 92.8396 196.444 92.8226 196.444 92.7207C196.444 92.6102 207.148 92.4488 220.363 92.3553C233.571 92.2619 244.283 92.2789 244.283 92.3808H244.291Z"
                                                fill="#E0E0E0" />
                                            <g opacity="0.5">
                                                <path
                                                    d="M230.064 184.551L228.023 212.484C228.023 212.484 235.407 217.545 243.681 215.39L251.706 190.194C251.706 190.194 246.483 182.126 230.064 184.551Z"
                                                    fill="#1A2E35" />
                                                <path
                                                    d="M229.804 183.579L229.594 186.556C229.594 186.556 235.917 192.499 251.445 192.078L252.886 188.761C252.886 188.761 243.621 179.63 229.804 183.579Z"
                                                    fill="#1A2E35" />
                                                <path opacity="0.8"
                                                    d="M229.804 183.579L229.594 186.556C229.594 186.556 235.917 192.499 251.445 192.078L252.886 188.761C252.886 188.761 243.621 179.63 229.804 183.579Z"
                                                    fill="white" />
                                                <path opacity="0.2"
                                                    d="M252.306 188.811C242.911 190.074 234.847 186.516 231.725 184.882H231.715C230.845 184.411 230.365 184.111 230.365 184.111C230.635 184.03 230.905 183.96 231.165 183.9C232.566 183.549 233.906 183.349 235.197 183.249C240.26 182.858 244.452 184.181 247.423 185.624C250.545 187.147 252.306 188.811 252.306 188.811Z"
                                                    fill="black" fill-opacity="0.46" />
                                                <path
                                                    d="M256.458 178.097C256.118 181.234 255.988 185.955 252.296 188.801C248.604 189.302 245.122 189.052 242.071 188.47C239.95 188.07 238.039 187.508 236.398 186.907C234.367 186.185 232.766 185.414 231.725 184.872H231.715C231.665 184.772 231.395 184.371 231.165 183.89C230.805 183.129 230.555 182.186 231.425 182.006C232.906 181.705 232.596 181.545 232.496 180.813C232.396 180.092 232.686 179.33 232.996 180.052C233.296 180.773 233.046 182.397 233.376 182.587C233.696 182.778 235.317 181.826 235.197 183.229C235.147 183.83 235.117 184.441 235.247 184.933C235.267 184.993 235.287 185.063 235.307 185.123C235.307 185.143 235.307 185.153 235.317 185.163C235.527 185.684 235.967 186.045 236.858 186.095C238.639 186.195 239.839 185.093 241.65 184.572C243.461 184.061 245.632 184.181 245.973 186.095C246.313 188.009 247.844 187.318 247.493 185.985C247.463 185.855 247.433 185.724 247.413 185.584C247.193 184.271 247.353 182.647 248.054 183.499C248.824 184.431 247.754 184.692 248.354 185.283C248.954 185.885 249.805 184.882 250.095 183.129C250.395 181.375 251.746 177.546 250.095 175.421C248.444 173.297 248.984 172.866 250.095 173.126C251.195 173.377 250.605 175.291 251.706 175.842C252.816 176.393 253.146 173.587 252.556 172.224C251.966 170.861 251.195 168.566 252.896 168.867C254.597 169.167 254.207 171.422 254.207 172.906C254.207 174.389 254.627 175.371 255.137 174.81C255.328 174.61 255.588 174.569 255.838 174.75C256.278 175.061 256.658 176.043 256.448 178.047L256.458 178.097Z"
                                                    fill="#FB5607" />
                                                <path
                                                    d="M256.458 178.097C256.118 181.234 255.988 185.955 252.296 188.801C248.604 189.302 245.122 189.052 242.071 188.47C239.95 188.07 238.039 187.508 236.398 186.907C234.367 186.185 232.766 185.414 231.725 184.872H231.715C231.665 184.772 231.395 184.371 231.165 183.89C230.805 183.129 230.555 182.186 231.425 182.006C232.906 181.705 232.596 181.545 232.496 180.813C232.396 180.092 232.686 179.33 232.996 180.052C233.296 180.773 233.046 182.397 233.376 182.587C233.696 182.778 235.317 181.826 235.197 183.229C235.147 183.83 235.117 184.441 235.247 184.933C235.267 184.993 235.287 185.063 235.307 185.123C235.307 185.143 235.307 185.153 235.317 185.163C235.527 185.684 235.967 186.045 236.858 186.095C238.639 186.195 239.839 185.093 241.65 184.572C243.461 184.061 245.632 184.181 245.973 186.095C246.313 188.009 247.844 187.318 247.493 185.985C247.463 185.855 247.433 185.724 247.413 185.584C247.193 184.271 247.353 182.647 248.054 183.499C248.824 184.431 247.754 184.692 248.354 185.283C248.954 185.885 249.805 184.882 250.095 183.129C250.395 181.375 251.746 177.546 250.095 175.421C248.444 173.297 248.984 172.866 250.095 173.126C251.195 173.377 250.605 175.291 251.706 175.842C252.816 176.393 253.146 173.587 252.556 172.224C251.966 170.861 251.195 168.566 252.896 168.867C254.597 169.167 254.207 171.422 254.207 172.906C254.207 174.389 254.627 175.371 255.137 174.81C255.328 174.61 255.588 174.569 255.838 174.75C256.278 175.061 256.658 176.043 256.448 178.047L256.458 178.097Z"
                                                    fill="#FB5607" />
                                                <path
                                                    d="M240.13 176.123L242.511 174.078L245.272 176.123V178.839L242.891 179.731L240.13 178.528V176.123Z"
                                                    fill="#FB5607" />
                                                <path
                                                    d="M240.13 176.123L242.511 174.078L245.272 176.123V178.839L242.891 179.731L240.13 178.528V176.123Z"
                                                    fill="#FB5607" />
                                                <path opacity="0.8"
                                                    d="M240.13 176.123L242.511 174.078L245.272 176.123V178.839L242.891 179.731L240.13 178.528V176.123Z"
                                                    fill="white" />
                                                <path opacity="0.5"
                                                    d="M242.511 174.078V177.426L245.272 178.839V176.123L242.511 174.078Z"
                                                    fill="white" />
                                                <path opacity="0.2"
                                                    d="M255.838 174.8C255.238 175.191 254.727 176.103 254.647 177.346C254.507 179.691 253.757 179.601 252.296 178.608C250.835 177.616 251.335 179.791 251.696 184.091C252.056 188.4 248.154 189.062 246.433 188.47C244.712 187.869 246.113 187.378 245.032 186.706C244.092 186.125 244.232 188.14 242.061 188.47C241.73 188.521 241.35 188.521 240.89 188.47C238.769 188.25 237.318 187.759 236.388 186.907C235.877 186.446 235.527 185.865 235.307 185.183C235.517 185.704 235.957 186.065 236.848 186.115C238.629 186.215 239.829 185.113 241.64 184.592C243.451 184.081 245.623 184.201 245.963 186.115C246.303 188.029 247.834 187.338 247.483 186.005C247.453 185.875 247.423 185.744 247.403 185.604C247.183 184.291 247.343 182.667 248.044 183.519C248.814 184.451 247.744 184.712 248.344 185.303C248.944 185.905 249.795 184.902 250.085 183.149C250.385 181.395 251.736 177.566 250.085 175.441C248.434 173.317 248.974 172.886 250.085 173.146C251.185 173.397 250.595 175.311 251.696 175.862C252.806 176.414 253.136 173.607 252.546 172.244C251.956 170.881 251.185 168.586 252.886 168.887C254.587 169.187 254.197 171.442 254.197 172.926C254.197 174.409 254.617 175.391 255.127 174.83C255.318 174.63 255.578 174.589 255.828 174.77L255.838 174.8Z"
                                                    fill="black" fill-opacity="0.46" />
                                                <path
                                                    d="M238.799 186.827L236.668 186.356L236.648 183.97L238.149 182.828L239.639 183.77L240.13 185.804L238.799 186.827Z"
                                                    fill="#FB5607" />
                                                <path
                                                    d="M238.799 186.827L236.668 186.356L236.648 183.97L238.149 182.828L239.639 183.77L240.13 185.804L238.799 186.827Z"
                                                    fill="#FB5607" />
                                                <path opacity="0.8"
                                                    d="M238.799 186.827L236.668 186.356L236.648 183.97L238.149 182.828L239.639 183.77L240.13 185.804L238.799 186.827Z"
                                                    fill="white" />
                                                <path opacity="0.5"
                                                    d="M236.668 186.356L238.519 184.952L238.149 182.828L236.648 183.97L236.668 186.356Z"
                                                    fill="white" />
                                                <path opacity="0.8"
                                                    d="M242.701 195.867C249.074 195.867 248.564 207.974 240.93 207.954C233.296 207.934 235.507 195.867 242.701 195.867Z"
                                                    fill="white" />
                                                <path opacity="0.2"
                                                    d="M242.531 196.819C247.904 196.819 247.474 207.022 241.03 207.012C234.587 206.992 236.458 196.819 242.531 196.819Z"
                                                    fill="black" fill-opacity="0.46" />
                                                <path
                                                    d="M191.074 216.272C191.074 216.272 189.293 219.138 189.293 219.91C189.293 220.682 190.634 224.44 191.524 225.262C192.415 226.094 203.11 228.639 216.157 226.665C229.204 224.691 232.836 218.627 233.476 217.164C234.117 215.701 233.896 210.078 232.496 209.827C231.085 209.577 193.565 214.287 191.084 216.272H191.074Z"
                                                    fill="#FB5607" />
                                                <path
                                                    d="M191.074 216.272C191.074 216.272 189.293 219.138 189.293 219.91C189.293 220.682 190.634 224.44 191.524 225.262C192.415 226.094 203.11 228.639 216.157 226.665C229.204 224.691 232.836 218.627 233.476 217.164C234.117 215.701 233.896 210.078 232.496 209.827C231.085 209.577 193.565 214.287 191.084 216.272H191.074Z"
                                                    fill="#FB5607" />
                                                <g opacity="0.2">
                                                    <path
                                                        d="M233.456 211.331C232.175 213.436 227.813 218.427 215.637 220.181C201.94 222.155 190.714 219.609 189.783 218.777C189.753 218.757 189.733 218.727 189.703 218.707C190.234 217.615 191.064 216.272 191.064 216.272C193.545 214.297 231.075 209.577 232.476 209.827C232.916 209.908 233.236 210.499 233.446 211.321L233.456 211.331Z"
                                                        fill="#FB5607" />
                                                    <path
                                                        d="M233.456 211.331C232.175 213.436 227.813 218.427 215.637 220.181C201.94 222.155 190.714 219.609 189.783 218.777C189.753 218.757 189.733 218.727 189.703 218.707C190.234 217.615 191.064 216.272 191.064 216.272C193.545 214.297 231.075 209.577 232.476 209.827C232.916 209.908 233.236 210.499 233.446 211.321L233.456 211.331Z"
                                                        fill="#FB5607" />
                                                </g>
                                                <path
                                                    d="M190.624 216.182C189.223 216.082 188.523 217.174 189.353 217.876C190.184 218.578 191.704 218.006 191.774 219.409C191.834 220.813 191.905 222.597 192.725 221.644C193.555 220.692 192.785 219.6 195.016 219.991C196.377 220.221 198.148 221.083 199.458 220.211C199.689 220.051 199.889 219.84 200.129 219.7C200.379 219.55 200.669 219.49 200.949 219.389C201.329 219.249 201.67 219.039 202.02 218.838C202.46 218.568 202.96 218.207 202.94 217.686C202.92 217.225 202.46 216.874 202 216.814C201.54 216.753 201.079 216.904 200.639 217.024C200.189 217.144 199.729 217.245 199.268 217.325C198.428 217.465 197.678 217.094 196.847 216.944C195.887 216.774 194.916 216.643 193.946 216.523C192.845 216.393 191.734 216.272 190.624 216.182Z"
                                                    fill="#FB5607" />
                                                <path
                                                    d="M190.624 216.182C189.223 216.082 188.523 217.174 189.353 217.876C190.184 218.578 191.704 218.006 191.774 219.409C191.834 220.813 191.905 222.597 192.725 221.644C193.555 220.692 192.785 219.6 195.016 219.991C196.377 220.221 198.148 221.083 199.458 220.211C199.689 220.051 199.889 219.84 200.129 219.7C200.379 219.55 200.669 219.49 200.949 219.389C201.329 219.249 201.67 219.039 202.02 218.838C202.46 218.568 202.96 218.207 202.94 217.686C202.92 217.225 202.46 216.874 202 216.814C201.54 216.753 201.079 216.904 200.639 217.024C200.189 217.144 199.729 217.245 199.268 217.325C198.428 217.465 197.678 217.094 196.847 216.944C195.887 216.774 194.916 216.643 193.946 216.523C192.845 216.393 191.734 216.272 190.624 216.182Z"
                                                    fill="#FB5607" />
                                                <path
                                                    d="M203.481 217.936C203.481 217.936 206.982 220.742 208.383 220.682C209.784 220.622 210.134 220.492 210.664 221.253C211.185 222.015 213.566 223.609 213.906 222.015C214.246 220.421 215.517 219.59 216.347 219.85C217.178 220.101 218.769 220.502 219.399 219.349C219.699 218.798 219.899 218.627 220.459 218.417C220.88 218.257 221.31 218.086 221.74 217.946C222.26 217.766 222.881 217.856 223.371 217.575C223.931 217.254 224.141 216.573 224.512 216.052C224.902 215.51 225.502 215.13 226.152 214.999C226.703 214.889 227.273 214.969 227.833 214.919C228.394 214.869 228.994 214.659 229.274 214.167C229.514 213.737 229.454 213.185 229.644 212.734C229.914 212.113 230.695 211.782 231.325 212.013C231.515 212.083 231.695 212.193 231.895 212.183C232.356 212.153 232.776 211.492 233.136 211.782C233.416 212.003 233.326 212.524 233.766 212.714C233.806 211.973 233.786 211.231 233.796 210.489C233.796 210.229 233.796 209.948 233.656 209.728C232.866 208.495 232.176 208.044 230.655 207.994C229.194 207.944 227.623 207.924 226.413 208.745C225.222 209.547 224.622 210.98 223.581 211.963C223.001 212.504 222.3 212.905 221.6 213.275C219.819 214.218 217.978 215.07 216.087 215.791C214.376 216.443 212.215 216.433 210.384 216.733C208.083 217.104 205.772 217.505 203.481 217.956V217.936Z"
                                                    fill="#FB5607" />
                                                <path
                                                    d="M203.481 217.936C203.481 217.936 206.982 220.742 208.383 220.682C209.784 220.622 210.134 220.492 210.664 221.253C211.185 222.015 213.566 223.609 213.906 222.015C214.246 220.421 215.517 219.59 216.347 219.85C217.178 220.101 218.769 220.502 219.399 219.349C219.699 218.798 219.899 218.627 220.459 218.417C220.88 218.257 221.31 218.086 221.74 217.946C222.26 217.766 222.881 217.856 223.371 217.575C223.931 217.254 224.141 216.573 224.512 216.052C224.902 215.51 225.502 215.13 226.152 214.999C226.703 214.889 227.273 214.969 227.833 214.919C228.394 214.869 228.994 214.659 229.274 214.167C229.514 213.737 229.454 213.185 229.644 212.734C229.914 212.113 230.695 211.782 231.325 212.013C231.515 212.083 231.695 212.193 231.895 212.183C232.356 212.153 232.776 211.492 233.136 211.782C233.416 212.003 233.326 212.524 233.766 212.714C233.806 211.973 233.786 211.231 233.796 210.489C233.796 210.229 233.796 209.948 233.656 209.728C232.866 208.495 232.176 208.044 230.655 207.994C229.194 207.944 227.623 207.924 226.413 208.745C225.222 209.547 224.622 210.98 223.581 211.963C223.001 212.504 222.3 212.905 221.6 213.275C219.819 214.218 217.978 215.07 216.087 215.791C214.376 216.443 212.215 216.433 210.384 216.733C208.083 217.104 205.772 217.505 203.481 217.956V217.936Z"
                                                    fill="#FB5607" />
                                                <path
                                                    d="M232.656 210.911C232.426 211.823 231.545 212.474 230.815 212.995C230.585 213.156 230.365 213.326 230.134 213.486C229.704 213.787 229.264 214.108 228.774 214.288C228.283 214.468 227.743 214.519 227.223 214.589C225.102 214.889 223.061 215.701 221.32 216.934C220.85 217.265 220.369 217.646 219.809 217.746C219.309 217.836 218.809 217.706 218.298 217.696C217.798 217.686 217.228 217.836 216.998 218.297C216.938 218.437 216.898 218.598 216.787 218.708C216.687 218.808 216.527 218.828 216.387 218.848C214.716 219.059 213.026 219.179 211.345 219.179C209.624 219.179 207.903 219.089 206.192 218.989C205.081 218.928 203.961 218.858 202.86 218.798C202.31 218.768 201.75 218.738 201.199 218.798C200.669 218.868 200.139 219.039 199.619 219.139C198.968 219.259 198.308 219.279 197.647 219.289C196.977 219.309 196.307 219.319 195.636 219.339C193.886 219.389 192.375 218.507 190.764 217.886C190.564 217.806 190.354 217.726 190.214 217.565C189.823 217.104 190.214 216.363 189.994 215.791C189.943 215.651 189.853 215.531 189.843 215.391C189.823 215.19 189.933 215.02 190.004 214.829C190.034 214.769 190.054 214.699 190.064 214.639C190.094 214.358 189.943 214.108 189.843 213.847C189.743 213.576 189.703 213.286 189.693 212.995C189.693 212.835 189.693 212.664 189.703 212.514C189.723 212.394 189.753 212.274 189.813 212.163C190.134 211.512 191.634 211.542 192.275 211.382C196.887 210.199 201.59 209.367 206.282 208.535C211.765 207.553 217.268 206.661 222.791 205.869C224.812 205.589 226.843 205.308 228.874 205.098C229.514 205.037 230.325 204.827 231.015 204.917C231.385 204.967 231.715 205.088 231.975 205.368C232.045 205.438 232.115 205.519 232.145 205.609C232.266 205.869 232.145 206.18 232.065 206.471C231.965 206.912 231.995 207.363 232.035 207.814C232.045 208.044 232.075 208.275 232.195 208.455C232.276 208.575 232.396 208.666 232.456 208.796C232.576 209.096 232.416 209.507 232.476 209.828C232.556 210.249 232.776 210.399 232.646 210.901L232.656 210.911Z"
                                                    fill="#7D5131" />
                                                <path opacity="0.2"
                                                    d="M231.595 207.743C231.365 208.665 230.485 209.317 229.754 209.838C229.524 209.998 229.304 210.159 229.074 210.319C228.644 210.63 228.203 210.94 227.713 211.121C227.213 211.311 226.683 211.351 226.162 211.421C224.041 211.722 222 212.524 220.259 213.767C219.789 214.097 219.319 214.478 218.748 214.578C218.248 214.669 217.748 214.538 217.238 214.528C216.737 214.518 216.167 214.679 215.937 215.13C215.877 215.27 215.837 215.43 215.727 215.541C215.627 215.641 215.467 215.661 215.327 215.681C213.656 215.891 211.975 216.002 210.284 216.012C208.563 216.012 206.842 215.921 205.131 215.821C204.021 215.761 202.91 215.691 201.8 215.631C201.249 215.601 200.689 215.571 200.139 215.641C199.609 215.711 199.088 215.881 198.558 215.972C197.918 216.092 197.247 216.112 196.587 216.122C195.917 216.142 195.246 216.162 194.576 216.182C192.945 216.232 191.504 215.45 190.004 214.839C190.034 214.779 190.054 214.709 190.064 214.649C190.094 214.368 189.943 214.117 189.843 213.857C189.743 213.586 189.703 213.296 189.693 213.005C189.693 212.845 189.693 212.674 189.703 212.524C189.723 212.404 189.753 212.283 189.813 212.173C190.134 211.522 191.634 211.552 192.275 211.391C196.887 210.209 201.59 209.377 206.282 208.545C211.765 207.563 217.268 206.671 222.791 205.879C224.812 205.598 226.843 205.318 228.874 205.107C229.514 205.047 230.325 204.837 231.015 204.927C231.035 205.067 231.075 205.188 231.145 205.298C231.225 205.418 231.345 205.508 231.405 205.649C231.535 205.939 231.375 206.36 231.435 206.671C231.515 207.092 231.735 207.242 231.605 207.743H231.595Z"
                                                    fill="black" fill-opacity="0.46" />
                                                <path
                                                    d="M188.713 211.331C188.443 212.053 193.996 219.399 193.996 219.399C193.996 219.399 201.95 213.085 207.363 212.193C212.775 211.301 230.665 212.253 230.665 212.253C230.665 212.253 231.705 205.999 231.535 204.496C231.365 202.993 191.704 203.263 188.713 211.331Z"
                                                    fill="#FB5607" />
                                                <path
                                                    d="M188.713 211.331C188.443 212.053 193.996 219.399 193.996 219.399C193.996 219.399 201.95 213.085 207.363 212.193C212.775 211.301 230.665 212.253 230.665 212.253C230.665 212.253 231.705 205.999 231.535 204.496C231.365 202.993 191.704 203.263 188.713 211.331Z"
                                                    fill="#FB5607" />
                                                <path opacity="0.7"
                                                    d="M188.713 211.331C188.443 212.053 193.996 219.399 193.996 219.399C193.996 219.399 201.95 213.085 207.363 212.193C212.775 211.301 230.665 212.253 230.665 212.253C230.665 212.253 231.705 205.999 231.535 204.496C231.365 202.993 191.704 203.263 188.713 211.331Z"
                                                    fill="white" />
                                                <path
                                                    d="M193.846 210.86L195.586 214.569C195.586 214.569 199.288 213.246 200.559 214.569C201.83 215.892 201.83 217.164 201.83 217.164C201.83 217.164 202.78 213.015 204.401 214.007C206.032 215 207.433 216.523 207.433 216.523C207.433 216.523 209.724 212.765 211.765 214.007L213.806 215.25C213.806 215.25 215.457 211.492 218.008 211.331C220.549 211.171 221.61 211.552 221.83 210.85C222.05 210.149 227.813 206.14 230.485 206.3L233.156 206.45C233.156 206.45 233.666 202.883 235.197 202.883C235.197 202.883 232.145 201.109 232.205 198.904C232.225 198.062 230.234 200.156 228.834 198.904C227.433 197.651 187.282 205.699 187.282 205.699C187.282 205.699 187.582 205.368 185.681 206.29C183.77 207.212 186.442 206.972 185.681 208.936C184.921 210.9 188.483 208.826 189.503 210.249C190.524 211.672 193.866 210.84 193.866 210.84L193.846 210.86Z"
                                                    fill="#FB5607" />
                                                <path
                                                    d="M193.846 210.86L195.586 214.569C195.586 214.569 199.288 213.246 200.559 214.569C201.83 215.892 201.83 217.164 201.83 217.164C201.83 217.164 202.78 213.015 204.401 214.007C206.032 215 207.433 216.523 207.433 216.523C207.433 216.523 209.724 212.765 211.765 214.007L213.806 215.25C213.806 215.25 215.457 211.492 218.008 211.331C220.549 211.171 221.61 211.552 221.83 210.85C222.05 210.149 227.813 206.14 230.485 206.3L233.156 206.45C233.156 206.45 233.666 202.883 235.197 202.883C235.197 202.883 232.145 201.109 232.205 198.904C232.225 198.062 230.234 200.156 228.834 198.904C227.433 197.651 187.282 205.699 187.282 205.699C187.282 205.699 187.582 205.368 185.681 206.29C183.77 207.212 186.442 206.972 185.681 208.936C184.921 210.9 188.483 208.826 189.503 210.249C190.524 211.672 193.866 210.84 193.866 210.84L193.846 210.86Z"
                                                    fill="#FB5607" />
                                                <path opacity="0.5"
                                                    d="M193.846 210.86L195.586 214.569C195.586 214.569 199.288 213.246 200.559 214.569C201.83 215.892 201.83 217.164 201.83 217.164C201.83 217.164 202.78 213.015 204.401 214.007C206.032 215 207.433 216.523 207.433 216.523C207.433 216.523 209.724 212.765 211.765 214.007L213.806 215.25C213.806 215.25 215.457 211.492 218.008 211.331C220.549 211.171 221.61 211.552 221.83 210.85C222.05 210.149 227.813 206.14 230.485 206.3L233.156 206.45C233.156 206.45 233.666 202.883 235.197 202.883C235.197 202.883 232.145 201.109 232.205 198.904C232.225 198.062 230.234 200.156 228.834 198.904C227.433 197.651 187.282 205.699 187.282 205.699C187.282 205.699 187.582 205.368 185.681 206.29C183.77 207.212 186.442 206.972 185.681 208.936C184.921 210.9 188.483 208.826 189.503 210.249C190.524 211.672 193.866 210.84 193.866 210.84L193.846 210.86Z"
                                                    fill="white" />
                                                <path
                                                    d="M203.951 210.49C201.069 214.95 187.992 216.062 186.992 212.264C186.752 211.331 186.722 210.51 186.832 209.798C187.142 207.613 188.673 206.491 188.673 206.491C194.136 203.644 202.92 205.178 204.231 208.285C204.511 208.956 204.461 209.698 203.951 210.48V210.49Z"
                                                    fill="#FB5607" />
                                                <path
                                                    d="M203.951 210.49C201.069 214.95 187.992 216.062 186.992 212.264C186.752 211.331 186.722 210.51 186.832 209.798C187.142 207.613 188.673 206.491 188.673 206.491C194.136 203.644 202.92 205.178 204.231 208.285C204.511 208.956 204.461 209.698 203.951 210.48V210.49Z"
                                                    fill="#FB5607" />
                                                <path opacity="0.2"
                                                    d="M204.231 208.294C204.161 208.475 204.061 208.655 203.951 208.836C201.069 213.296 187.993 214.408 186.992 210.61C186.912 210.329 186.862 210.058 186.832 209.808C187.142 207.623 188.673 206.5 188.673 206.5C194.136 203.654 202.92 205.187 204.231 208.294Z"
                                                    fill="black" fill-opacity="0.46" />
                                                <path
                                                    d="M231.085 207.843C228.203 212.303 215.127 213.416 214.126 209.617C213.886 208.685 213.856 207.863 213.966 207.152C214.276 204.967 215.807 203.844 215.807 203.844C221.27 200.998 230.054 202.531 231.365 205.638C231.645 206.31 231.595 207.051 231.085 207.833V207.843Z"
                                                    fill="#FB5607" />
                                                <path
                                                    d="M231.085 207.843C228.203 212.303 215.127 213.416 214.126 209.617C213.886 208.685 213.856 207.863 213.966 207.152C214.276 204.967 215.807 203.844 215.807 203.844C221.27 200.998 230.054 202.531 231.365 205.638C231.645 206.31 231.595 207.051 231.085 207.833V207.843Z"
                                                    fill="#FB5607" />
                                                <path opacity="0.2"
                                                    d="M231.365 205.638C231.295 205.819 231.195 205.999 231.085 206.179C228.203 210.639 215.127 211.752 214.126 207.953C214.046 207.673 213.996 207.402 213.966 207.152C214.276 204.967 215.807 203.844 215.807 203.844C221.27 200.998 230.054 202.531 231.365 205.638Z"
                                                    fill="black" fill-opacity="0.46" />
                                                <path
                                                    d="M208.243 186.566C221.95 185.413 233.816 197.39 231.165 203.584C228.524 209.778 191.414 215.029 187.922 207.944C184.431 200.858 193.825 187.779 208.243 186.566Z"
                                                    fill="#FB5607" />
                                                <path
                                                    d="M208.243 186.566C221.95 185.413 233.816 197.39 231.165 203.584C228.524 209.778 191.414 215.029 187.922 207.944C184.431 200.858 193.825 187.779 208.243 186.566Z"
                                                    fill="#FB5607" />
                                                <path opacity="0.2"
                                                    d="M207.242 194.293C207.242 194.293 206.602 195.867 207.242 195.867C207.883 195.867 207.242 194.293 207.242 194.293Z"
                                                    fill="white" />
                                                <path opacity="0.2"
                                                    d="M212.265 192.429C212.265 192.429 213.416 193.963 213.476 193.261C213.536 192.559 212.265 192.429 212.265 192.429Z"
                                                    fill="white" />
                                                <path opacity="0.2"
                                                    d="M204.761 191.858C204.761 191.858 203.04 192.179 203.491 192.62C203.941 193.071 204.761 191.858 204.761 191.858Z"
                                                    fill="white" />
                                                <path opacity="0.2"
                                                    d="M199.288 193.772C199.288 193.772 198.018 193.872 198.208 194.303C198.398 194.734 199.288 193.772 199.288 193.772Z"
                                                    fill="white" />
                                                <path opacity="0.2"
                                                    d="M202.53 188.54C202.53 188.54 201.129 188.35 201.129 188.791C201.129 189.232 202.53 188.54 202.53 188.54Z"
                                                    fill="white" />
                                                <path opacity="0.2"
                                                    d="M207.523 189.302C207.523 189.302 207.302 190.514 207.813 190.384C208.323 190.254 207.523 189.302 207.523 189.302Z"
                                                    fill="white" />
                                                <path opacity="0.2"
                                                    d="M215.537 190.395C215.537 190.395 216.667 190.916 216.667 190.395C216.667 189.874 215.537 190.395 215.537 190.395Z"
                                                    fill="white" />
                                                <path opacity="0.2"
                                                    d="M211.585 187.769C211.585 187.769 212.205 187.067 212.525 187.258C212.845 187.448 211.585 187.769 211.585 187.769Z"
                                                    fill="white" />
                                                <path opacity="0.2"
                                                    d="M205.972 187.769C206.672 187.639 206.292 188.491 206.292 188.491C206.292 188.491 205.271 187.889 205.972 187.769Z"
                                                    fill="white" />
                                                <path opacity="0.2"
                                                    d="M201.83 197.02C201.83 197.02 200.999 197.531 201.129 197.912C201.259 198.292 201.83 197.02 201.83 197.02Z"
                                                    fill="white" />
                                                <path opacity="0.2"
                                                    d="M219.459 194.083C219.459 194.083 220.86 194.614 220.349 195.075C219.839 195.546 219.459 194.083 219.459 194.083Z"
                                                    fill="white" />
                                                <path opacity="0.2"
                                                    d="M211.585 197.982C211.585 197.982 211.975 198.754 211.585 198.904C211.194 199.054 211.585 197.982 211.585 197.982Z"
                                                    fill="white" />
                                                <path opacity="0.2"
                                                    d="M231.165 203.584C228.524 209.778 191.414 215.029 187.922 207.934C187.542 207.162 187.322 206.32 187.232 205.428C187.312 205.638 187.402 205.849 187.492 206.049C190.984 213.145 228.083 207.883 230.735 201.69C231.055 200.958 231.155 200.136 231.085 199.264C231.635 200.838 231.685 202.331 231.155 203.584H231.165Z"
                                                    fill="black" fill-opacity="0.46" />
                                            </g>
                                            <path d="M305.492 107.141H187.213V192.114H305.492V107.141Z"
                                                fill="#FAFAFA" />
                                            <path
                                                d="M305.492 192.114C305.492 192.114 305.478 191.58 305.478 190.561C305.478 189.535 305.47 188.031 305.463 186.055C305.456 182.112 305.442 176.32 305.428 168.919C305.407 154.13 305.386 132.902 305.351 107.141L305.499 107.288C272.415 107.295 231.47 107.309 187.227 107.323H187.22L187.403 107.141C187.403 137.59 187.389 166.473 187.389 192.114L187.22 191.946C222.177 191.981 251.724 192.009 272.542 192.03C282.962 192.051 291.19 192.065 296.819 192.072C299.637 192.079 301.8 192.086 303.265 192.093C303.991 192.093 304.548 192.1 304.928 192.1C305.301 192.1 305.499 192.107 305.499 192.107C305.499 192.107 305.315 192.107 304.949 192.114C304.576 192.114 304.026 192.114 303.308 192.121C301.849 192.121 299.694 192.135 296.897 192.143C291.275 192.15 283.053 192.171 272.655 192.185C251.809 192.206 222.227 192.234 187.227 192.269H187.058V192.1C187.058 166.459 187.044 137.576 187.044 107.127V106.944H187.234C231.477 106.958 272.422 106.972 305.506 106.979H305.654V107.127C305.618 132.93 305.597 154.186 305.576 169.003C305.562 176.391 305.548 182.168 305.541 186.105C305.534 188.066 305.527 189.563 305.527 190.582C305.527 191.594 305.513 192.1 305.513 192.1L305.492 192.114Z"
                                                fill="#263238" />
                                            <path
                                                d="M238.733 169.495H205.65C202.07 169.495 199.168 172.39 199.168 175.962V177.318C199.168 180.89 202.07 183.785 205.65 183.785H238.733C242.313 183.785 245.214 180.89 245.214 177.318V175.962C245.214 172.39 242.313 169.495 238.733 169.495Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M238.733 169.495H205.65C202.07 169.495 199.168 172.39 199.168 175.962V177.318C199.168 180.89 202.07 183.785 205.65 183.785H238.733C242.313 183.785 245.214 180.89 245.214 177.318V175.962C245.214 172.39 242.313 169.495 238.733 169.495Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M290.38 183.792C290.38 183.792 290.479 183.778 290.662 183.757C290.845 183.75 291.127 183.722 291.479 183.651C292.184 183.518 293.247 183.216 294.325 182.351C295.389 181.515 296.46 180.06 296.699 178.12C296.756 177.642 296.756 177.136 296.749 176.608C296.749 176.081 296.756 175.547 296.664 175.006C296.509 173.923 296.023 172.827 295.248 171.892C294.459 170.971 293.374 170.219 292.092 169.868C291.451 169.671 290.782 169.629 290.084 169.636C289.38 169.636 288.661 169.636 287.935 169.636C285.019 169.636 281.905 169.65 278.629 169.65C272.07 169.65 264.863 169.657 257.297 169.664C255.451 169.664 253.668 170.507 252.506 171.871C251.921 172.546 251.492 173.347 251.245 174.19C250.984 175.041 250.977 175.913 250.991 176.805C250.9 178.562 251.477 180.27 252.619 181.508C253.732 182.752 255.324 183.49 256.916 183.574C263.468 183.595 269.365 183.616 274.324 183.63C279.27 183.651 283.279 183.673 286.068 183.687C287.442 183.701 288.513 183.715 289.26 183.722C289.612 183.729 289.887 183.736 290.091 183.743C290.281 183.743 290.373 183.757 290.373 183.764C290.373 183.771 290.274 183.778 290.091 183.785C289.887 183.785 289.612 183.799 289.26 183.806C288.513 183.813 287.435 183.827 286.068 183.841C283.279 183.855 279.27 183.876 274.324 183.897C269.365 183.905 263.468 183.947 256.895 183.919C255.218 183.834 253.535 183.061 252.351 181.747C251.759 181.093 251.294 180.32 250.998 179.469C250.688 178.626 250.611 177.691 250.625 176.805C250.611 175.927 250.618 174.978 250.893 174.085C251.146 173.192 251.604 172.342 252.224 171.625C253.45 170.184 255.338 169.277 257.297 169.291C264.863 169.291 272.07 169.298 278.629 169.305C281.905 169.305 285.019 169.319 287.935 169.319C288.661 169.319 289.38 169.319 290.084 169.319C290.789 169.319 291.507 169.369 292.169 169.572C293.508 169.945 294.642 170.732 295.452 171.702C296.256 172.679 296.749 173.818 296.897 174.943C296.988 175.505 296.967 176.06 296.974 176.58C296.974 177.1 296.974 177.621 296.911 178.113C296.643 180.116 295.523 181.585 294.424 182.428C293.304 183.293 292.212 183.574 291.5 183.687C291.134 183.75 290.859 183.757 290.669 183.757C290.479 183.757 290.387 183.757 290.387 183.757L290.38 183.792Z"
                                                fill="#263238" />
                                            <path
                                                d="M211.842 176.404C211.842 175.09 212.85 174.127 214.209 174.127C214.9 174.127 215.499 174.359 215.907 174.823L215.491 175.223C215.146 174.858 214.724 174.696 214.237 174.696C213.23 174.696 212.483 175.42 212.483 176.404C212.483 177.388 213.23 178.112 214.237 178.112C214.731 178.112 215.146 177.944 215.491 177.578L215.907 177.979C215.499 178.436 214.9 178.682 214.202 178.682C212.85 178.682 211.842 177.719 211.842 176.404Z"
                                                fill="white" />
                                            <path
                                                d="M219.359 176.594V178.633H218.782V178.19C218.577 178.492 218.204 178.675 217.675 178.675C216.908 178.675 216.428 178.267 216.428 177.684C216.428 177.143 216.781 176.7 217.788 176.7H218.753V176.58C218.753 176.067 218.457 175.765 217.852 175.765C217.45 175.765 217.041 175.906 216.781 176.13L216.527 175.674C216.879 175.392 217.38 175.238 217.922 175.238C218.845 175.238 219.366 175.681 219.366 176.608L219.359 176.594ZM218.746 177.6V177.129H217.802C217.196 177.129 217.027 177.361 217.027 177.649C217.027 177.986 217.309 178.197 217.774 178.197C218.239 178.197 218.598 177.986 218.746 177.6Z"
                                                fill="white" />
                                            <path
                                                d="M223.699 176.692V178.632H223.086V176.763C223.086 176.102 222.755 175.778 222.177 175.778C221.529 175.778 221.106 176.165 221.106 176.896V178.632H220.493V175.258H221.078V175.764C221.325 175.42 221.762 175.223 222.297 175.223C223.121 175.223 223.699 175.694 223.699 176.685V176.692Z"
                                                fill="white" />
                                            <path
                                                d="M224.537 176.946C224.537 175.94 225.284 175.23 226.32 175.23C226.925 175.23 227.426 175.476 227.693 175.947L227.228 176.25C227.01 175.919 226.679 175.765 226.313 175.765C225.65 175.765 225.15 176.229 225.15 176.946C225.15 177.663 225.65 178.133 226.313 178.133C226.679 178.133 227.017 177.979 227.228 177.648L227.693 177.944C227.426 178.415 226.925 178.668 226.32 178.668C225.277 178.668 224.537 177.951 224.537 176.946Z"
                                                fill="white" />
                                            <path
                                                d="M231.477 177.149H228.736C228.814 177.74 229.293 178.133 229.962 178.133C230.356 178.133 230.688 178 230.934 177.726L231.272 178.119C230.969 178.478 230.497 178.668 229.941 178.668C228.849 178.668 228.123 177.951 228.123 176.946C228.123 175.94 228.842 175.23 229.821 175.23C230.8 175.23 231.491 175.933 231.491 176.967C231.491 177.016 231.491 177.093 231.477 177.149ZM228.736 176.714H230.906C230.843 176.144 230.413 175.744 229.821 175.744C229.229 175.744 228.799 176.137 228.736 176.714Z"
                                                fill="white" />
                                            <path d="M232.336 173.909H232.949V178.626H232.336V173.909Z" fill="white" />
                                            <path
                                                d="M267.632 175.941C267.632 176.714 267.075 177.178 266.145 177.178H265.265V178.253H264.757V174.704H266.145C267.068 174.704 267.632 175.168 267.632 175.941ZM267.124 175.941C267.124 175.435 266.786 175.146 266.131 175.146H265.265V176.742H266.131C266.779 176.742 267.124 176.454 267.124 175.948V175.941Z"
                                                fill="#263238" />
                                            <path
                                                d="M269.717 175.541V176.011C269.675 176.011 269.64 176.011 269.604 176.011C269.083 176.011 268.752 176.328 268.752 176.918V178.261H268.266V175.569H268.731V176.018C268.907 175.702 269.238 175.541 269.71 175.541H269.717Z"
                                                fill="#263238" />
                                            <path
                                                d="M270.041 176.911C270.041 176.11 270.633 175.541 271.443 175.541C272.253 175.541 272.845 176.11 272.845 176.911C272.845 177.712 272.253 178.289 271.443 178.289C270.633 178.289 270.041 177.712 270.041 176.911ZM272.352 176.911C272.352 176.335 271.964 175.969 271.443 175.969C270.922 175.969 270.534 176.342 270.534 176.911C270.534 177.481 270.929 177.86 271.443 177.86C271.957 177.86 272.352 177.488 272.352 176.911Z"
                                                fill="#263238" />
                                            <path
                                                d="M273.268 176.911C273.268 176.11 273.859 175.541 274.691 175.541C275.177 175.541 275.578 175.737 275.79 176.117L275.416 176.356C275.24 176.089 274.98 175.969 274.684 175.969C274.155 175.969 273.761 176.342 273.761 176.911C273.761 177.481 274.155 177.86 274.684 177.86C274.98 177.86 275.24 177.741 275.416 177.474L275.79 177.705C275.578 178.078 275.177 178.282 274.691 178.282C273.859 178.282 273.268 177.705 273.268 176.904V176.911Z"
                                                fill="#263238" />
                                            <path
                                                d="M278.805 177.073H276.621C276.684 177.544 277.065 177.86 277.6 177.86C277.917 177.86 278.178 177.755 278.375 177.537L278.643 177.853C278.396 178.134 278.03 178.289 277.579 178.289C276.713 178.289 276.128 177.712 276.128 176.911C276.128 176.11 276.706 175.541 277.481 175.541C278.256 175.541 278.812 176.096 278.812 176.925C278.812 176.967 278.812 177.024 278.805 177.073ZM276.621 176.721H278.347C278.298 176.272 277.953 175.948 277.481 175.948C277.009 175.948 276.67 176.265 276.614 176.721H276.621Z"
                                                fill="#263238" />
                                            <path
                                                d="M281.919 177.073H279.735C279.798 177.544 280.179 177.86 280.714 177.86C281.031 177.86 281.292 177.755 281.489 177.537L281.757 177.853C281.51 178.134 281.144 178.289 280.693 178.289C279.827 178.289 279.242 177.712 279.242 176.911C279.242 176.11 279.82 175.541 280.594 175.541C281.369 175.541 281.926 176.096 281.926 176.925C281.926 176.967 281.926 177.024 281.919 177.073ZM279.735 176.721H281.461C281.412 176.272 281.066 175.948 280.594 175.948C280.122 175.948 279.784 176.265 279.728 176.721H279.735Z"
                                                fill="#263238" />
                                            <path
                                                d="M285.146 174.486V178.254H284.681V177.825C284.462 178.127 284.117 178.282 283.722 178.282C282.933 178.282 282.363 177.726 282.363 176.904C282.363 176.082 282.94 175.533 283.722 175.533C284.103 175.533 284.441 175.674 284.659 175.962V174.479H285.146V174.486ZM284.659 176.904C284.659 176.328 284.265 175.962 283.751 175.962C283.236 175.962 282.842 176.335 282.842 176.904C282.842 177.473 283.236 177.853 283.751 177.853C284.265 177.853 284.659 177.48 284.659 176.904Z"
                                                fill="#263238" />
                                            <path
                                                d="M238.627 178.281L241.171 191.721L243.256 187.967L247.737 194.666L249.977 193.162L245.496 186.463L249.611 185.83L238.627 178.281Z"
                                                fill="#263238" />
                                            <path
                                                d="M293.522 125.205C296.841 125.205 299.531 122.521 299.531 119.21C299.531 115.898 296.841 113.214 293.522 113.214C290.203 113.214 287.513 115.898 287.513 119.21C287.513 122.521 290.203 125.205 293.522 125.205Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M290.042 123.132C289.971 123.062 291.472 121.445 293.395 119.526C295.319 117.607 296.939 116.103 297.009 116.18C297.08 116.25 295.579 117.867 293.656 119.786C291.733 121.705 290.112 123.209 290.042 123.132Z"
                                                fill="#263238" />
                                            <path
                                                d="M290.042 116.173C290.112 116.102 291.733 117.6 293.656 119.519C295.579 121.438 297.087 123.054 297.009 123.124C296.939 123.195 295.319 121.698 293.395 119.779C291.472 117.86 289.964 116.243 290.042 116.173Z"
                                                fill="#263238" />
                                            <path
                                                d="M205.61 146.667C204.983 146.667 204.45 146.564 204.01 146.357C203.576 146.144 203.24 145.837 203 145.437C202.76 145.03 202.626 144.537 202.6 143.957C202.593 143.684 202.59 143.39 202.59 143.077C202.59 142.764 202.593 142.464 202.6 142.177C202.626 141.604 202.76 141.117 203 140.717C203.246 140.31 203.59 140 204.03 139.787C204.47 139.574 204.996 139.467 205.61 139.467C206.056 139.467 206.463 139.524 206.83 139.637C207.196 139.75 207.513 139.914 207.78 140.127C208.046 140.34 208.253 140.59 208.4 140.877C208.546 141.164 208.626 141.484 208.64 141.837C208.64 141.897 208.616 141.947 208.57 141.987C208.53 142.027 208.48 142.047 208.42 142.047H207.28C207.2 142.047 207.136 142.027 207.09 141.987C207.043 141.947 207.006 141.88 206.98 141.787C206.88 141.394 206.713 141.124 206.48 140.977C206.246 140.83 205.956 140.757 205.61 140.757C205.196 140.757 204.87 140.87 204.63 141.097C204.39 141.324 204.26 141.7 204.24 142.227C204.22 142.774 204.22 143.334 204.24 143.907C204.26 144.434 204.39 144.81 204.63 145.037C204.87 145.264 205.196 145.377 205.61 145.377C205.956 145.377 206.246 145.304 206.48 145.157C206.72 145.004 206.886 144.734 206.98 144.347C207.006 144.247 207.043 144.18 207.09 144.147C207.136 144.107 207.2 144.087 207.28 144.087H208.42C208.48 144.087 208.53 144.107 208.57 144.147C208.616 144.187 208.64 144.237 208.64 144.297C208.626 144.65 208.546 144.97 208.4 145.257C208.253 145.544 208.046 145.794 207.78 146.007C207.513 146.22 207.196 146.384 206.83 146.497C206.463 146.61 206.056 146.667 205.61 146.667ZM212.033 146.667C211.48 146.667 211.017 146.577 210.643 146.397C210.27 146.21 209.983 145.947 209.783 145.607C209.59 145.267 209.483 144.87 209.463 144.417C209.457 144.284 209.453 144.134 209.453 143.967C209.453 143.794 209.457 143.644 209.463 143.517C209.483 143.057 209.597 142.66 209.803 142.327C210.01 141.987 210.3 141.727 210.673 141.547C211.047 141.36 211.5 141.267 212.033 141.267C212.56 141.267 213.01 141.36 213.383 141.547C213.757 141.727 214.047 141.987 214.253 142.327C214.46 142.66 214.573 143.057 214.593 143.517C214.607 143.644 214.613 143.794 214.613 143.967C214.613 144.134 214.607 144.284 214.593 144.417C214.573 144.87 214.463 145.267 214.263 145.607C214.07 145.947 213.787 146.21 213.413 146.397C213.04 146.577 212.58 146.667 212.033 146.667ZM212.033 145.567C212.36 145.567 212.607 145.467 212.773 145.267C212.94 145.06 213.03 144.76 213.043 144.367C213.05 144.267 213.053 144.134 213.053 143.967C213.053 143.8 213.05 143.667 213.043 143.567C213.03 143.18 212.94 142.884 212.773 142.677C212.607 142.47 212.36 142.367 212.033 142.367C211.707 142.367 211.457 142.47 211.283 142.677C211.117 142.884 211.027 143.18 211.013 143.567C211.007 143.667 211.003 143.8 211.003 143.967C211.003 144.134 211.007 144.267 211.013 144.367C211.027 144.76 211.117 145.06 211.283 145.267C211.457 145.467 211.707 145.567 212.033 145.567ZM215.899 146.567C215.832 146.567 215.776 146.544 215.729 146.497C215.682 146.45 215.659 146.39 215.659 146.317V141.617C215.659 141.544 215.682 141.484 215.729 141.437C215.776 141.39 215.832 141.367 215.899 141.367H216.879C216.952 141.367 217.012 141.39 217.059 141.437C217.106 141.484 217.129 141.544 217.129 141.617V142.007C217.302 141.794 217.526 141.617 217.799 141.477C218.072 141.337 218.406 141.267 218.799 141.267C219.192 141.267 219.536 141.357 219.829 141.537C220.129 141.71 220.362 141.967 220.529 142.307C220.702 142.64 220.789 143.047 220.789 143.527V146.317C220.789 146.39 220.762 146.45 220.709 146.497C220.662 146.544 220.606 146.567 220.539 146.567H219.479C219.406 146.567 219.346 146.544 219.299 146.497C219.252 146.45 219.229 146.39 219.229 146.317V143.587C219.229 143.234 219.142 142.96 218.969 142.767C218.802 142.567 218.556 142.467 218.229 142.467C217.916 142.467 217.666 142.567 217.479 142.767C217.292 142.96 217.199 143.234 217.199 143.587V146.317C217.199 146.39 217.176 146.45 217.129 146.497C217.082 146.544 217.026 146.567 216.959 146.567H215.899ZM222.749 146.567C222.675 146.567 222.615 146.544 222.569 146.497C222.522 146.45 222.499 146.39 222.499 146.317V142.547H221.719C221.645 142.547 221.585 142.524 221.539 142.477C221.492 142.43 221.469 142.37 221.469 142.297V141.617C221.469 141.544 221.492 141.484 221.539 141.437C221.585 141.39 221.645 141.367 221.719 141.367H222.499V141.007C222.499 140.58 222.579 140.23 222.739 139.957C222.899 139.684 223.132 139.484 223.439 139.357C223.745 139.23 224.122 139.167 224.569 139.167H226.869C226.935 139.167 226.992 139.19 227.039 139.237C227.085 139.284 227.109 139.344 227.109 139.417V140.097C227.109 140.17 227.085 140.23 227.039 140.277C226.992 140.324 226.935 140.347 226.869 140.347H224.629C224.382 140.347 224.209 140.407 224.109 140.527C224.015 140.647 223.969 140.824 223.969 141.057V141.367H226.869C226.935 141.367 226.992 141.39 227.039 141.437C227.085 141.484 227.109 141.544 227.109 141.617V146.317C227.109 146.39 227.085 146.45 227.039 146.497C226.992 146.544 226.935 146.567 226.869 146.567H225.889C225.815 146.567 225.755 146.544 225.709 146.497C225.662 146.45 225.639 146.39 225.639 146.317V142.547H223.969V146.317C223.969 146.39 223.945 146.45 223.899 146.497C223.852 146.544 223.795 146.567 223.729 146.567H222.749ZM228.858 146.567C228.791 146.567 228.735 146.544 228.688 146.497C228.641 146.45 228.618 146.39 228.618 146.317V141.617C228.618 141.55 228.641 141.494 228.688 141.447C228.735 141.394 228.791 141.367 228.858 141.367H229.838C229.905 141.367 229.961 141.394 230.008 141.447C230.061 141.494 230.088 141.55 230.088 141.617V142.017C230.255 141.81 230.458 141.65 230.698 141.537C230.945 141.424 231.228 141.367 231.548 141.367H231.978C232.045 141.367 232.101 141.39 232.148 141.437C232.195 141.484 232.218 141.544 232.218 141.617V142.477C232.218 142.55 232.195 142.61 232.148 142.657C232.101 142.704 232.045 142.727 231.978 142.727H231.098C230.805 142.727 230.575 142.81 230.408 142.977C230.241 143.137 230.158 143.367 230.158 143.667V146.317C230.158 146.39 230.135 146.45 230.088 146.497C230.041 146.544 229.981 146.567 229.908 146.567H228.858ZM233.204 146.567C233.137 146.567 233.08 146.544 233.034 146.497C232.987 146.45 232.964 146.39 232.964 146.317V141.617C232.964 141.544 232.987 141.484 233.034 141.437C233.08 141.39 233.137 141.367 233.204 141.367H234.134C234.2 141.367 234.257 141.39 234.304 141.437C234.357 141.484 234.384 141.544 234.384 141.617V141.957C234.517 141.77 234.7 141.61 234.934 141.477C235.174 141.344 235.457 141.274 235.784 141.267C236.557 141.254 237.087 141.547 237.374 142.147C237.527 141.887 237.747 141.677 238.034 141.517C238.327 141.35 238.647 141.267 238.994 141.267C239.34 141.267 239.654 141.347 239.934 141.507C240.214 141.66 240.434 141.9 240.594 142.227C240.76 142.547 240.844 142.96 240.844 143.467V146.317C240.844 146.39 240.82 146.45 240.774 146.497C240.727 146.544 240.67 146.567 240.604 146.567H239.614C239.547 146.567 239.49 146.544 239.444 146.497C239.397 146.45 239.374 146.39 239.374 146.317V143.547C239.374 143.274 239.334 143.06 239.254 142.907C239.174 142.747 239.067 142.634 238.934 142.567C238.807 142.5 238.664 142.467 238.504 142.467C238.364 142.467 238.227 142.5 238.094 142.567C237.967 142.634 237.86 142.747 237.774 142.907C237.694 143.06 237.654 143.274 237.654 143.547V146.317C237.654 146.39 237.63 146.45 237.584 146.497C237.537 146.544 237.477 146.567 237.404 146.567H236.424C236.35 146.567 236.29 146.544 236.244 146.497C236.197 146.45 236.174 146.39 236.174 146.317V143.547C236.174 143.274 236.134 143.06 236.054 142.907C235.974 142.747 235.867 142.634 235.734 142.567C235.607 142.5 235.467 142.467 235.314 142.467C235.174 142.467 235.037 142.504 234.904 142.577C234.77 142.644 234.66 142.754 234.574 142.907C234.494 143.06 234.454 143.27 234.454 143.537V146.317C234.454 146.39 234.43 146.45 234.384 146.497C234.337 146.544 234.28 146.567 234.214 146.567H233.204ZM244.949 148.467C244.896 148.467 244.846 148.447 244.799 148.407C244.759 148.367 244.739 148.317 244.739 148.257C244.739 148.244 244.742 148.224 244.749 148.197C244.756 148.177 244.766 148.15 244.779 148.117L245.559 146.247L243.639 141.717C243.619 141.664 243.609 141.62 243.609 141.587C243.616 141.527 243.639 141.477 243.679 141.437C243.719 141.39 243.769 141.367 243.829 141.367H244.799C244.886 141.367 244.949 141.39 244.989 141.437C245.029 141.477 245.059 141.52 245.079 141.567L246.319 144.667L247.589 141.567C247.616 141.514 247.649 141.467 247.689 141.427C247.729 141.387 247.792 141.367 247.879 141.367H248.829C248.889 141.367 248.939 141.39 248.979 141.437C249.026 141.477 249.049 141.524 249.049 141.577C249.049 141.61 249.036 141.657 249.009 141.717L246.179 148.267C246.159 148.32 246.126 148.367 246.079 148.407C246.039 148.447 245.976 148.467 245.889 148.467H244.949ZM252.033 146.667C251.48 146.667 251.017 146.577 250.643 146.397C250.27 146.21 249.983 145.947 249.783 145.607C249.59 145.267 249.483 144.87 249.463 144.417C249.457 144.284 249.453 144.134 249.453 143.967C249.453 143.794 249.457 143.644 249.463 143.517C249.483 143.057 249.597 142.66 249.803 142.327C250.01 141.987 250.3 141.727 250.673 141.547C251.047 141.36 251.5 141.267 252.033 141.267C252.56 141.267 253.01 141.36 253.383 141.547C253.757 141.727 254.047 141.987 254.253 142.327C254.46 142.66 254.573 143.057 254.593 143.517C254.607 143.644 254.613 143.794 254.613 143.967C254.613 144.134 254.607 144.284 254.593 144.417C254.573 144.87 254.463 145.267 254.263 145.607C254.07 145.947 253.787 146.21 253.413 146.397C253.04 146.577 252.58 146.667 252.033 146.667ZM252.033 145.567C252.36 145.567 252.607 145.467 252.773 145.267C252.94 145.06 253.03 144.76 253.043 144.367C253.05 144.267 253.053 144.134 253.053 143.967C253.053 143.8 253.05 143.667 253.043 143.567C253.03 143.18 252.94 142.884 252.773 142.677C252.607 142.47 252.36 142.367 252.033 142.367C251.707 142.367 251.457 142.47 251.283 142.677C251.117 142.884 251.027 143.18 251.013 143.567C251.007 143.667 251.003 143.8 251.003 143.967C251.003 144.134 251.007 144.267 251.013 144.367C251.027 144.76 251.117 145.06 251.283 145.267C251.457 145.467 251.707 145.567 252.033 145.567ZM257.569 146.667C257.182 146.667 256.839 146.58 256.539 146.407C256.246 146.227 256.016 145.97 255.849 145.637C255.689 145.297 255.609 144.887 255.609 144.407V141.617C255.609 141.544 255.632 141.484 255.679 141.437C255.726 141.39 255.782 141.367 255.849 141.367H256.909C256.982 141.367 257.042 141.39 257.089 141.437C257.136 141.484 257.159 141.544 257.159 141.617V144.347C257.159 145.094 257.486 145.467 258.139 145.467C258.452 145.467 258.699 145.37 258.879 145.177C259.066 144.977 259.159 144.7 259.159 144.347V141.617C259.159 141.544 259.182 141.484 259.229 141.437C259.276 141.39 259.336 141.367 259.409 141.367H260.469C260.536 141.367 260.592 141.39 260.639 141.437C260.686 141.484 260.709 141.544 260.709 141.617V146.317C260.709 146.39 260.686 146.45 260.639 146.497C260.592 146.544 260.536 146.567 260.469 146.567H259.489C259.416 146.567 259.356 146.544 259.309 146.497C259.262 146.45 259.239 146.39 259.239 146.317V145.927C259.066 146.167 258.842 146.35 258.569 146.477C258.296 146.604 257.962 146.667 257.569 146.667ZM262.208 146.567C262.141 146.567 262.084 146.544 262.038 146.497C261.991 146.45 261.968 146.39 261.968 146.317V141.617C261.968 141.55 261.991 141.494 262.038 141.447C262.084 141.394 262.141 141.367 262.208 141.367H263.188C263.254 141.367 263.311 141.394 263.358 141.447C263.411 141.494 263.438 141.55 263.438 141.617V142.017C263.604 141.81 263.808 141.65 264.048 141.537C264.294 141.424 264.578 141.367 264.898 141.367H265.328C265.394 141.367 265.451 141.39 265.498 141.437C265.544 141.484 265.568 141.544 265.568 141.617V142.477C265.568 142.55 265.544 142.61 265.498 142.657C265.451 142.704 265.394 142.727 265.328 142.727H264.448C264.154 142.727 263.924 142.81 263.758 142.977C263.591 143.137 263.508 143.367 263.508 143.667V146.317C263.508 146.39 263.484 146.45 263.438 146.497C263.391 146.544 263.331 146.567 263.258 146.567H262.208ZM268.969 146.567C268.896 146.567 268.836 146.544 268.789 146.497C268.743 146.45 268.719 146.39 268.719 146.317V142.547H267.939C267.866 142.547 267.806 142.524 267.759 142.477C267.713 142.43 267.689 142.37 267.689 142.297V141.617C267.689 141.544 267.713 141.484 267.759 141.437C267.806 141.39 267.866 141.367 267.939 141.367H268.719V141.007C268.719 140.58 268.799 140.23 268.959 139.957C269.119 139.684 269.353 139.484 269.659 139.357C269.966 139.23 270.343 139.167 270.789 139.167H271.519C271.593 139.167 271.653 139.19 271.699 139.237C271.746 139.284 271.769 139.344 271.769 139.417V140.097C271.769 140.17 271.746 140.23 271.699 140.277C271.653 140.324 271.593 140.347 271.519 140.347H270.849C270.603 140.347 270.429 140.407 270.329 140.527C270.236 140.647 270.189 140.824 270.189 141.057V141.367H271.419C271.493 141.367 271.553 141.39 271.599 141.437C271.646 141.484 271.669 141.544 271.669 141.617V142.297C271.669 142.37 271.646 142.43 271.599 142.477C271.553 142.524 271.493 142.547 271.419 142.547H270.189V146.317C270.189 146.39 270.166 146.45 270.119 146.497C270.073 146.544 270.016 146.567 269.949 146.567H268.969ZM274.738 146.667C274.185 146.667 273.722 146.577 273.348 146.397C272.975 146.21 272.688 145.947 272.488 145.607C272.295 145.267 272.188 144.87 272.168 144.417C272.162 144.284 272.158 144.134 272.158 143.967C272.158 143.794 272.162 143.644 272.168 143.517C272.188 143.057 272.302 142.66 272.508 142.327C272.715 141.987 273.005 141.727 273.378 141.547C273.752 141.36 274.205 141.267 274.738 141.267C275.265 141.267 275.715 141.36 276.088 141.547C276.462 141.727 276.752 141.987 276.958 142.327C277.165 142.66 277.278 143.057 277.298 143.517C277.312 143.644 277.318 143.794 277.318 143.967C277.318 144.134 277.312 144.284 277.298 144.417C277.278 144.87 277.168 145.267 276.968 145.607C276.775 145.947 276.492 146.21 276.118 146.397C275.745 146.577 275.285 146.667 274.738 146.667ZM274.738 145.567C275.065 145.567 275.312 145.467 275.478 145.267C275.645 145.06 275.735 144.76 275.748 144.367C275.755 144.267 275.758 144.134 275.758 143.967C275.758 143.8 275.755 143.667 275.748 143.567C275.735 143.18 275.645 142.884 275.478 142.677C275.312 142.47 275.065 142.367 274.738 142.367C274.412 142.367 274.162 142.47 273.988 142.677C273.822 142.884 273.732 143.18 273.718 143.567C273.712 143.667 273.708 143.8 273.708 143.967C273.708 144.134 273.712 144.267 273.718 144.367C273.732 144.76 273.822 145.06 273.988 145.267C274.162 145.467 274.412 145.567 274.738 145.567ZM280.744 146.667C280.191 146.667 279.728 146.577 279.354 146.397C278.981 146.21 278.694 145.947 278.494 145.607C278.301 145.267 278.194 144.87 278.174 144.417C278.168 144.284 278.164 144.134 278.164 143.967C278.164 143.794 278.168 143.644 278.174 143.517C278.194 143.057 278.308 142.66 278.514 142.327C278.721 141.987 279.011 141.727 279.384 141.547C279.758 141.36 280.211 141.267 280.744 141.267C281.271 141.267 281.721 141.36 282.094 141.547C282.468 141.727 282.758 141.987 282.964 142.327C283.171 142.66 283.284 143.057 283.304 143.517C283.318 143.644 283.324 143.794 283.324 143.967C283.324 144.134 283.318 144.284 283.304 144.417C283.284 144.87 283.174 145.267 282.974 145.607C282.781 145.947 282.498 146.21 282.124 146.397C281.751 146.577 281.291 146.667 280.744 146.667ZM280.744 145.567C281.071 145.567 281.318 145.467 281.484 145.267C281.651 145.06 281.741 144.76 281.754 144.367C281.761 144.267 281.764 144.134 281.764 143.967C281.764 143.8 281.761 143.667 281.754 143.567C281.741 143.18 281.651 142.884 281.484 142.677C281.318 142.47 281.071 142.367 280.744 142.367C280.418 142.367 280.168 142.47 279.994 142.677C279.828 142.884 279.738 143.18 279.724 143.567C279.718 143.667 279.714 143.8 279.714 143.967C279.714 144.134 279.718 144.267 279.724 144.367C279.738 144.76 279.828 145.06 279.994 145.267C280.168 145.467 280.418 145.567 280.744 145.567ZM286.3 146.667C285.967 146.667 285.67 146.614 285.41 146.507C285.15 146.394 284.93 146.234 284.75 146.027C284.57 145.814 284.433 145.564 284.34 145.277C284.247 144.984 284.19 144.66 284.17 144.307C284.163 144.18 284.16 144.067 284.16 143.967C284.16 143.86 284.163 143.747 284.17 143.627C284.183 143.28 284.237 142.964 284.33 142.677C284.43 142.39 284.567 142.144 284.74 141.937C284.92 141.724 285.14 141.56 285.4 141.447C285.667 141.327 285.967 141.267 286.3 141.267C286.647 141.267 286.943 141.327 287.19 141.447C287.437 141.56 287.64 141.71 287.8 141.897V139.717C287.8 139.644 287.823 139.584 287.87 139.537C287.917 139.49 287.977 139.467 288.05 139.467H289.08C289.147 139.467 289.203 139.49 289.25 139.537C289.297 139.584 289.32 139.644 289.32 139.717V146.317C289.32 146.39 289.297 146.45 289.25 146.497C289.203 146.544 289.147 146.567 289.08 146.567H288.12C288.053 146.567 287.997 146.544 287.95 146.497C287.903 146.45 287.88 146.39 287.88 146.317V145.977C287.713 146.177 287.503 146.344 287.25 146.477C286.997 146.604 286.68 146.667 286.3 146.667ZM286.76 145.467C287.007 145.467 287.203 145.41 287.35 145.297C287.503 145.184 287.613 145.04 287.68 144.867C287.753 144.694 287.793 144.507 287.8 144.307C287.813 144.18 287.82 144.054 287.82 143.927C287.82 143.8 287.813 143.677 287.8 143.557C287.793 143.37 287.753 143.197 287.68 143.037C287.607 142.87 287.493 142.734 287.34 142.627C287.193 142.52 287 142.467 286.76 142.467C286.507 142.467 286.307 142.524 286.16 142.637C286.013 142.744 285.907 142.887 285.84 143.067C285.78 143.247 285.743 143.444 285.73 143.657C285.71 143.864 285.71 144.07 285.73 144.277C285.743 144.49 285.78 144.687 285.84 144.867C285.907 145.047 286.013 145.194 286.16 145.307C286.307 145.414 286.507 145.467 286.76 145.467Z"
                                                fill="black" fill-opacity="0.53" />
                                        </g>
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_3_1789">
                                            <rect width="501" height="411" fill="white" />
                                        </clipPath>
                                        <clipPath id="clip1_3_1789">
                                            <rect width="389.455" height="382.224" fill="white"
                                                transform="translate(95.1034 28.3467)" />
                                        </clipPath>
                                    </defs>
                                </svg>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Tab Pan -->
                @endif
                @if( isset($restaurant_platform) )
                <!-- Tab Pan -->
                <div class="tab-pane fade show" id="manage-restaurant">
                    <div class="row gy-5 align-items-center flex-wrap-reverse">
                        <div class="col-lg-7">
                            <div class="platform-content">
                                @php($platform_restaurant_datas = \App\Models\BusinessSetting::where(['key'=>'platform_restaurant_data'])->first())
                                @php($platform_restaurant_datas = isset($platform_restaurant_datas->value)?json_decode($platform_restaurant_datas->value, true):[])
                                @foreach($platform_restaurant_datas as  $platform_restaurant_data)
                                <h4 class="subtitle">{{$platform_restaurant_data['title']}}</h4>
                                <p>
                                    {{$platform_restaurant_data['detail']}}
                                </p>
                                @endforeach
                                @if($restaurant_platform['url_status'] == 1)
                                <a href="{{$restaurant_platform['url']}}" class="btn-base btn-sm">
                                    <span>{{ translate('messages.Download_now') }}</span>
                                    <svg width="14" height="15" viewBox="0 0 14 15" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M0.875 7.50006C0.875 7.38403 0.921094 7.27275 1.00314 7.19071C1.08519 7.10866 1.19647 7.06256 1.3125 7.06256H11.6314L8.87775 4.30981C8.7956 4.22766 8.74945 4.11624 8.74945 4.00006C8.74945 3.88389 8.7956 3.77247 8.87775 3.69031C8.9599 3.60816 9.07132 3.56201 9.1875 3.56201C9.30368 3.56201 9.4151 3.60816 9.49725 3.69031L12.9972 7.19031C13.038 7.23095 13.0703 7.27923 13.0924 7.33239C13.1144 7.38554 13.1258 7.44252 13.1258 7.50006C13.1258 7.55761 13.1144 7.61459 13.0924 7.66774C13.0703 7.7209 13.038 7.76917 12.9972 7.80981L9.49725 11.3098C9.4151 11.392 9.30368 11.4381 9.1875 11.4381C9.07132 11.4381 8.9599 11.392 8.87775 11.3098C8.7956 11.2277 8.74945 11.1162 8.74945 11.0001C8.74945 10.8839 8.7956 10.7725 8.87775 10.6903L11.6314 7.93756H1.3125C1.19647 7.93756 1.08519 7.89147 1.00314 7.80942C0.921094 7.72738 0.875 7.6161 0.875 7.50006Z"
                                            fill="white" />
                                    </svg>
                                </a>
                                @endif
                            </div>
                        </div>
                        <div class="col-lg-5">
                            <div class="platform-img">
                                <svg width="501" height="411" viewBox="0 0 501 411" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M435.272 351.539C423.45 361.391 409.907 368.773 395.404 374.223C394.331 374.61 393.259 375.009 392.186 375.383C390.914 375.832 389.63 376.256 388.345 376.692C384.055 378.089 379.678 379.336 375.251 380.421C367.295 382.391 359.152 383.888 350.934 384.985C348.651 385.284 346.357 385.559 344.062 385.796C343.364 385.87 342.678 385.933 341.98 386.008C340.695 386.132 339.423 386.245 338.139 386.357C334.709 386.644 331.292 386.868 327.863 387.043C325.631 387.155 323.374 387.255 321.141 387.305C305.404 387.741 289.878 387.03 275.25 385.671C273.092 385.471 270.947 385.259 268.84 385.01C263.951 384.486 259.188 383.9 254.574 383.264C252.379 382.952 250.221 382.641 248.101 382.329C241.492 381.319 235.244 380.221 229.421 379.111C222.1 377.715 215.478 376.306 209.742 374.959C195.301 371.592 181.708 367.402 168.976 362.413C159.236 358.597 150.008 354.307 141.304 349.556C137.725 347.611 134.233 345.591 130.828 343.483C127.661 341.55 124.581 339.53 121.563 337.46C120.627 336.799 119.68 336.138 118.757 335.477C104.428 325.226 91.9451 313.466 81.4075 300.347C70.5706 286.867 61.7789 271.915 55.157 255.64C46.3777 234.079 41.402 210.173 40.4417 184.234C39.5563 160.216 45.1681 140.475 55.157 124.787C83.1908 80.8034 145.668 68.8192 195.7 84.32C208.345 88.2233 220.192 93.8974 230.493 101.255C296.076 148.107 292.472 153.669 385.751 170.853C487.461 189.596 507.539 291.306 435.272 351.539Z"
                                        fill="#F5E8E8" />
                                    <path d="M257.342 24H256.095V56.2488H257.342V24Z" fill="#F5E8E8" />
                                    <path d="M256.719 51.8843L222.724 75.8277H290.713L256.719 51.8843Z"
                                        fill="#D3CDC6" />
                                    <path
                                        d="M290.713 75.8275C290.713 76.5633 275.487 77.1619 256.719 77.1619C237.95 77.1619 222.724 76.5633 222.724 75.8275C222.724 75.0918 237.95 74.4932 256.719 74.4932C275.487 74.4932 290.713 75.0918 290.713 75.8275Z"
                                        fill="#DBB088" />
                                    <path
                                        d="M83.8144 208.477C96.073 245.065 89.5509 282.627 83.8643 283.387C78.1154 284.647 76.382 251.101 65.7945 216.994C55.5561 182.65 42.1503 160.739 46.4776 157.21C50.1938 153.818 71.8427 171.714 83.8144 208.477Z"
                                        fill="#E0E0E0" />
                                    <path
                                        d="M71.4935 223.466C82.6047 244.454 82.5549 268.261 76.3321 271.241C70.0718 274.409 61.4173 256.626 51.9521 236.635C42.5868 216.495 35.6531 201.381 40.3545 197.266C44.8564 193.263 60.4945 202.366 71.481 223.466H71.4935Z"
                                        fill="#E0E0E0" />
                                    <path
                                        d="M66.5551 243.469C53.062 221.721 30.8644 208.826 24.7164 213.004C18.3689 217.106 20.2645 235.301 51.2164 264.669C68.5878 281.143 83.2657 302.243 83.2657 302.243C89.4386 300.223 80.7466 261.739 66.5427 243.482L66.5551 243.469Z"
                                        fill="#E0E0E0" />
                                    <path
                                        d="M59.6963 234.291C59.609 234.291 59.5092 234.253 59.4469 234.166C59.2972 233.966 43.9959 214.4 27.0983 212.305C26.9237 212.28 26.8115 212.13 26.8239 211.956C26.8489 211.781 26.9985 211.656 27.1731 211.681C44.3326 213.801 59.7836 233.58 59.9333 233.779C60.033 233.916 60.0081 234.116 59.8834 234.216C59.821 234.266 59.7587 234.278 59.6963 234.278V234.291Z"
                                        fill="#340000" />
                                    <path
                                        d="M79.0756 244.853C78.926 244.853 78.8013 244.754 78.7763 244.604L78.7265 244.367C77.629 238.306 72.6907 217.406 55.0823 202.616C54.9451 202.503 54.9326 202.304 55.0449 202.179C55.1571 202.042 55.3566 202.029 55.4813 202.142C73.2519 217.069 78.2276 238.157 79.3375 244.255L79.3749 244.467C79.4123 244.629 79.3001 244.803 79.138 244.841C79.113 244.841 79.0881 244.841 79.0756 244.841V244.853Z"
                                        fill="#340000" />
                                    <path
                                        d="M473.856 295.085C464.777 339.867 415.419 369.671 398.097 362.014C380.227 355.617 404.108 329.865 419.846 297.168C436.257 264.133 438.003 238.98 450 234.366C460.5 229.028 483.321 250.889 473.856 295.097V295.085Z"
                                        fill="#E0E0E0" />
                                    <path
                                        d="M425.657 280.781C417.227 317.045 382.921 343.87 377.209 341.188C370.936 339.742 395.478 315.599 405.704 284.485C416.479 253.358 411.042 233.094 415.805 230.3C419.372 227.008 434.387 244.816 425.645 280.781H425.657Z"
                                        fill="#E0E0E0" />
                                    <path
                                        d="M467.533 313.953C467.533 313.953 467.446 313.953 467.409 313.928C467.246 313.866 467.184 313.678 467.246 313.516C483.57 276.292 472.073 252.573 471.96 252.348C471.885 252.199 471.948 252.012 472.097 251.924C472.247 251.849 472.434 251.912 472.521 252.061C472.646 252.298 484.269 276.267 467.82 313.766C467.77 313.878 467.658 313.953 467.533 313.953Z"
                                        fill="#340000" />
                                    <path
                                        d="M407.662 319.864H407.65C407.475 319.864 407.338 319.714 407.35 319.539C407.375 319.04 408.074 317.868 409.807 315.062C415.506 305.784 428.85 284.061 428.002 261.738C428.002 261.564 428.126 261.427 428.301 261.414C428.488 261.414 428.613 261.539 428.625 261.713C429.473 284.223 416.067 306.059 410.331 315.387C409.071 317.432 407.986 319.203 407.974 319.564C407.974 319.726 407.824 319.864 407.662 319.864Z"
                                        fill="#340000" />
                                    <path
                                        d="M204.442 169.856C204.517 169.793 204.592 169.706 204.654 169.619C204.617 169.669 204.567 169.718 204.529 169.768C204.504 169.806 204.467 169.831 204.442 169.856Z"
                                        fill="#162847" />
                                    <path
                                        d="M204.654 169.618C204.654 169.618 204.728 169.519 204.766 169.457C204.741 169.494 204.716 169.543 204.679 169.581C204.679 169.581 204.666 169.605 204.654 169.618Z"
                                        fill="#162847" />
                                    <path
                                        d="M204.766 169.468C204.766 169.468 204.841 169.356 204.878 169.294C204.853 169.344 204.828 169.381 204.803 169.418C204.803 169.431 204.779 169.456 204.766 169.468Z"
                                        fill="#162847" />
                                    <path
                                        d="M205.228 167.411C205.215 167.337 205.203 167.262 205.178 167.187C205.19 167.237 205.203 167.274 205.215 167.312C205.215 167.349 205.215 167.374 205.228 167.411Z"
                                        fill="#162847" />
                                    <path
                                        d="M205.09 168.833C205.09 168.833 205.115 168.758 205.14 168.708C205.14 168.733 205.128 168.746 205.115 168.771C205.115 168.795 205.103 168.808 205.09 168.833Z"
                                        fill="#162847" />
                                    <path
                                        d="M205.228 168.334C205.228 168.272 205.253 168.21 205.253 168.135V168.222C205.253 168.222 205.228 168.284 205.228 168.322V168.334Z"
                                        fill="#162847" />
                                    <path
                                        d="M221.015 161.175C221.015 161.175 220.978 161.088 220.965 161.039C220.99 161.088 221.003 161.125 221.027 161.175H221.015Z"
                                        fill="#340000" />
                                    <path
                                        d="M221.24 162.66V162.747H221.227C221.227 162.747 221.227 162.685 221.24 162.66Z"
                                        fill="#280000" />
                                    <path
                                        d="M221.24 162.76C221.24 162.76 221.24 162.822 221.215 162.859C221.215 162.822 221.215 162.797 221.227 162.76H221.24Z"
                                        fill="#260000" />
                                    <path
                                        d="M221.127 163.246C221.127 163.246 221.115 163.283 221.103 163.308C221.103 163.308 221.115 163.271 221.127 163.246Z"
                                        fill="#220000" />
                                    <path
                                        d="M221.103 163.309C221.103 163.309 221.09 163.346 221.078 163.371L221.103 163.309Z"
                                        fill="#210000" />
                                    <path
                                        d="M220.978 163.595C220.978 163.595 220.978 163.62 220.953 163.632V163.595H220.978Z"
                                        fill="#1F0000" />
                                    <path
                                        d="M171.807 318.305L168.976 362.413C159.236 358.597 150.008 354.307 141.304 349.556C137.725 347.611 134.233 345.591 130.828 343.483C130.816 334.666 130.779 326.037 130.766 322.657C130.766 322.657 119.156 248.869 119.518 247.285L155.158 239.566L171.807 318.305Z"
                                        fill="#8C3E0D" />
                                    <path
                                        d="M209.418 177.176C209.231 177.4 209.031 177.6 208.832 177.824C208.757 177.899 208.682 177.986 208.607 178.061C208.071 178.622 207.547 179.171 207.011 179.707C206.238 180.493 205.427 181.254 204.629 182.027C203.37 183.199 202.098 184.346 200.801 185.469C196.523 189.16 191.984 192.602 187.158 195.769C182.294 198.924 177.331 202.242 171.42 204.511C165.808 206.669 159.523 207.866 153.475 207.579C150.507 207.429 148.225 204.848 148.349 201.88L149.197 180.206C148.861 179.134 150.145 178.323 151.579 177.213C153.063 176.128 154.847 174.956 156.73 173.771C160.508 171.352 164.773 169.008 169.076 166.513C173.403 164.019 177.83 161.5 182.369 159.031C184.626 157.821 186.896 156.612 189.24 155.477C189.265 155.465 189.278 155.452 189.303 155.44C190.039 155.065 190.774 154.704 191.523 154.342C193.68 153.669 196.099 153.893 198.469 154.866L208.582 167.848C209.243 169.818 209.667 171.639 209.842 173.173C210.041 174.944 209.904 176.34 209.43 177.188L209.418 177.176Z"
                                        fill="white" />
                                    <path
                                        d="M124.73 211.994L121.563 337.46C120.628 336.799 119.68 336.138 118.757 335.477C104.428 325.226 91.9453 313.467 81.4076 300.348L77.0928 262.45C75.0726 236.386 84.438 215.947 102.707 212.268L124.73 211.994Z"
                                        fill="#8C3E0D" />
                                    <path
                                        d="M209.829 173.161C209.717 174.969 209.306 176.627 208.595 178.061C207.822 179.595 206.699 180.855 205.228 181.703L204.629 182.027C202.31 183.112 199.591 183.05 196.935 182.015C193.53 180.73 190.226 177.887 187.944 173.934C185.986 170.567 185.125 166.95 185.25 163.745C185.4 160.241 186.759 157.223 189.228 155.477C189.428 155.328 189.64 155.178 189.852 155.066C190.388 154.754 190.936 154.517 191.51 154.342C192.159 154.155 192.807 154.018 193.493 153.981C195.102 153.856 196.785 154.18 198.456 154.866C201.736 156.201 204.916 158.994 207.161 162.847C208.782 165.641 209.667 168.596 209.829 171.352C209.867 171.976 209.867 172.587 209.842 173.185L209.829 173.161Z"
                                        fill="#340000" />
                                    <path
                                        d="M141.291 106.48C141.291 106.48 132.2 108.001 123.309 104.26C121.276 103.4 121.014 101.741 121.45 100.145C122.872 94.8324 126.476 92.9868 129.506 81.252C130.18 78.6706 139.845 83.8958 139.845 83.8958L141.291 106.48Z"
                                        fill="#713027" />
                                    <path
                                        d="M142.8 207.442C147.701 209.475 153.325 207.13 155.345 202.229L177.942 147.558C183.043 135.213 175.336 123.727 162.541 118.914L157.303 117.317L132.05 182.501C128.284 192.353 133.048 203.427 142.8 207.455V207.442Z"
                                        fill="#FFDBD4" />
                                    <path
                                        d="M178.852 146.349C175.124 158.021 171.37 169.968 167.629 182.114C163.676 194.859 159.748 207.804 155.807 220.848C146.89 226.572 126.726 234.341 112.197 231.086C103.069 229.041 88.6155 222.806 88.2539 220.312C88.2539 220.312 91.8828 167.312 88.3536 137.046C87.0318 125.66 94.6637 115.497 104.977 113.14C106.436 112.803 107.97 112.628 109.541 112.628C112.222 112.628 114.903 112.666 117.597 112.766C119.904 112.828 122.199 112.94 124.518 113.09C133.335 113.614 142.164 114.586 150.981 115.995C153.375 116.382 155.782 116.781 158.176 117.243C159.822 117.554 161.456 117.866 163.102 118.203C166.519 118.901 169.549 120.41 172.068 122.518C178.653 127.98 181.721 137.382 178.852 146.349Z"
                                        fill="white" />
                                    <path
                                        d="M157.952 213.764C164.711 191.442 171.931 169.357 173.727 145.95L112.085 142.396V212.006C111.96 211.981 114.617 212.542 112.085 212.006C108.369 238.456 109.18 275.581 113.781 301.931C140.306 300.622 166.831 299.312 193.381 298.003C177.356 270.094 164.698 241.636 157.952 213.777V213.764Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M157.952 213.764C164.711 191.442 171.931 169.357 173.727 145.95L112.085 142.396V212.006C111.96 211.981 114.617 212.542 112.085 212.006C108.369 238.456 109.18 275.581 113.781 301.931C140.306 300.622 166.831 299.312 193.381 298.003C177.356 270.094 164.698 241.636 157.952 213.777V213.764Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M124.132 153.631L112.11 152.846C113.095 137.744 107.708 120.709 104.964 113.152C106.423 112.815 107.957 112.641 109.529 112.641C112.21 112.641 112.21 112.591 114.891 112.678C117.946 117.317 125.117 138.492 124.132 153.631Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M124.132 153.631L112.11 152.846C113.095 137.744 107.708 120.709 104.964 113.152C106.423 112.815 107.957 112.641 109.529 112.641C112.21 112.641 112.21 112.591 114.891 112.678C117.946 117.317 125.117 138.492 124.132 153.631Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M172.854 154.38L160.645 153.245C163.601 137.856 160.695 124.749 158.189 117.242C159.835 117.554 164.885 118.564 166.532 118.901C166.532 118.901 177.481 138.355 172.867 154.38H172.854Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M172.854 154.38L160.645 153.245C163.601 137.856 160.695 124.749 158.189 117.242C159.835 117.554 164.885 118.564 166.532 118.901C166.532 118.901 177.481 138.355 172.867 154.38H172.854Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M113.781 205.696L108.007 205.783C95.4245 205.983 85.0615 195.931 84.862 183.349L84.1387 137.382C83.6274 122.068 93.9031 113.389 105.65 113.015C105.65 113.015 111.137 130.785 111.661 142.844C112.335 158.557 113.781 205.696 113.781 205.696Z"
                                        fill="white" />
                                    <path
                                        d="M150.395 89.5451L148.711 107.266L148.225 112.466L147.614 118.913L127.299 115.671L133.796 86.9014L150.395 89.5451Z"
                                        fill="#F29C8A" />
                                    <path
                                        d="M152.964 120.435C152.452 124.812 145.132 127.555 136.627 126.57C128.11 125.585 121.625 121.233 122.136 116.855C122.311 115.396 123.234 114.112 124.705 113.089C133.522 113.613 142.351 114.586 151.168 115.995C152.477 117.379 153.151 118.913 152.976 120.435H152.964Z"
                                        fill="#F29C8A" />
                                    <path
                                        d="M169.662 71.9118C169.662 72.2984 169.612 72.6725 169.487 73.0466C168.652 75.7777 164.848 77.8478 160.284 77.8478C159.311 77.8478 158.376 77.748 157.49 77.5859C157.166 77.536 156.867 77.4487 156.555 77.3739L153.338 90.5927L128.696 84.6193L131.514 72.9593C133.023 66.6991 139.346 62.8457 145.606 64.3671L151.904 65.8885C153.986 66.3873 156.131 66.3873 158.264 66.088C158.912 65.9883 159.573 65.9384 160.271 65.9384C165.447 65.9384 169.649 68.6071 169.649 71.8993L169.662 71.9118Z"
                                        fill="#713027" />
                                    <path
                                        d="M169.487 73.0465C168.651 75.7775 164.848 77.8476 160.284 77.8476C159.311 77.8476 158.376 77.7479 157.49 77.5858L155.944 75.9771L155.62 71.1011C155.62 71.1011 158.85 71.762 162.691 71.6872C165.434 71.6373 168.764 71.5251 169.499 73.034L169.487 73.0465Z"
                                        fill="#340000" />
                                    <path
                                        d="M158.363 99.4216L136.365 96.4661L138.785 80.9527C139.72 74.9544 144.583 70.3528 150.619 69.7417C157.615 69.7417 161.456 76.4509 160.596 82.8233L158.363 99.4216Z"
                                        fill="#F29C8A" />
                                    <path
                                        d="M138.56 83.5096C139.52 85.7917 139.084 88.1611 137.575 88.7847C136.066 89.4207 134.071 88.0863 133.11 85.8042C132.15 83.5221 132.587 81.1527 134.096 80.5292C135.605 79.8932 137.6 81.2275 138.56 83.5096Z"
                                        fill="#F29C8A" />
                                    <path
                                        d="M136.552 64.0178C138.248 66.4246 138.061 69.4674 136.141 70.8142C134.22 72.161 131.29 71.313 129.606 68.9062C127.923 66.4994 128.097 63.4566 130.018 62.1098C131.938 60.763 134.869 61.611 136.552 64.0178Z"
                                        fill="#713027" />
                                    <path
                                        d="M148.711 107.266L148.225 112.454C140.718 110.683 136.814 106.256 136.69 106.106L148.711 107.254V107.266Z"
                                        fill="#340000" />
                                    <path
                                        d="M156.73 95.032C155.37 94.2962 154.585 92.4631 150.095 93.7974C148.574 94.2463 146.541 94.1965 144.434 93.7226C140.88 92.9369 138.785 89.0835 138.149 85.3299C138.149 85.2675 140.106 66.6615 153.799 70.253L147.09 67.2227L139.346 69.1306L135.829 71.9116C135.829 71.9116 135.081 75.3659 135.829 76.1142C138.672 78.9325 135.829 91.5776 135.829 91.5776L135.929 91.3033C135.654 92.6376 135.467 93.9969 135.38 95.3687L135.006 100.893C134.744 104.796 137.55 108.238 141.441 108.762L149.621 109.872C153.512 110.396 157.129 107.814 157.902 103.961L159.211 93.9346C158.825 95.3063 157.777 95.6056 156.73 95.0445V95.032Z"
                                        fill="#713027" />
                                    <path
                                        d="M164.287 179.969C164.075 180.181 163.875 180.356 163.663 180.555C163.04 181.129 162.404 181.703 161.755 182.251C159.673 184.059 157.503 185.755 155.296 187.402C150.881 190.669 146.217 193.687 141.304 196.418C136.365 199.124 131.29 201.992 125.379 203.775C119.767 205.459 113.582 206.17 107.72 205.459C104.84 205.097 102.82 202.416 103.144 199.535L105.526 178.548C105.276 177.488 106.598 176.789 108.057 175.804C109.579 174.869 111.399 173.846 113.307 172.848C117.148 170.766 121.475 168.796 125.828 166.7C130.205 164.593 134.694 162.448 139.283 160.39C141.59 159.368 143.898 158.345 146.267 157.397C147.439 156.911 148.624 156.45 149.834 155.988C151.006 155.539 152.253 155.078 153.375 154.741V154.766L164.1 170.853C165.16 175.043 165.235 178.51 164.237 179.982L164.287 179.969Z"
                                        fill="white" />
                                    <path
                                        d="M209.767 166.326C212.286 166.8 214.755 167.361 217.224 167.885C219.681 168.421 222.188 168.933 224.607 169.369C225.804 169.569 226.914 169.693 228.036 169.731C229.146 169.743 230.244 169.644 231.291 169.432C233.399 168.995 235.344 167.96 237.003 166.351L237.04 166.314C237.664 165.703 238.674 165.715 239.285 166.351C239.796 166.875 239.871 167.661 239.509 168.259C238.025 170.778 235.494 172.861 232.613 173.846C229.745 174.906 226.627 174.943 223.871 174.594C221.153 174.27 218.571 173.721 215.99 173.036C213.421 172.325 210.889 171.489 208.47 170.367C207.398 169.868 206.936 168.608 207.423 167.536C207.847 166.626 208.819 166.152 209.755 166.326H209.767Z"
                                        fill="#F29C8A" />
                                    <path
                                        d="M211.762 161.55C214.281 162.024 216.751 162.585 219.22 163.109C221.676 163.645 224.183 164.156 226.602 164.593C227.799 164.792 228.909 164.917 230.032 164.954C231.142 164.967 232.239 164.867 233.287 164.655C235.394 164.219 237.339 163.184 238.998 161.575L239.035 161.538C239.659 160.926 240.669 160.939 241.28 161.575C241.791 162.099 241.866 162.884 241.505 163.483C240.021 166.002 237.489 168.085 234.608 169.07C231.74 170.13 228.623 170.167 225.867 169.818C223.148 169.494 220.567 168.945 217.985 168.259C215.416 167.548 212.885 166.713 210.465 165.59C209.393 165.092 208.932 163.832 209.418 162.76C209.842 161.849 210.815 161.375 211.75 161.55H211.762Z"
                                        fill="#F29C8A" />
                                    <path
                                        d="M213.072 156.799C215.591 157.272 218.06 157.834 220.529 158.357C222.986 158.894 225.492 159.405 227.912 159.841C229.109 160.041 230.219 160.166 231.341 160.203C232.451 160.215 233.548 160.116 234.596 159.904C236.703 159.467 238.649 158.432 240.307 156.823L240.345 156.786C240.968 156.175 241.978 156.187 242.589 156.823C243.101 157.347 243.176 158.133 242.814 158.731C241.33 161.25 238.798 163.333 235.918 164.318C233.049 165.378 229.932 165.416 227.176 165.066C224.457 164.742 221.876 164.194 219.294 163.508C216.726 162.797 214.194 161.961 211.775 160.839C210.702 160.34 210.241 159.081 210.727 158.008C211.151 157.098 212.124 156.624 213.059 156.799H213.072Z"
                                        fill="#F29C8A" />
                                    <path
                                        d="M215.778 153.07C218.21 153.905 220.592 154.753 222.998 155.501C225.38 156.25 227.849 156.948 230.169 157.397C232.513 157.833 234.783 157.946 236.928 157.509C239.073 157.073 241.056 156.038 242.727 154.404L242.764 154.367C243.388 153.756 243.313 154.566 243.924 155.19C244.435 155.713 245.595 155.701 245.233 156.3C243.724 158.856 241.155 160.951 238.212 161.936C235.294 162.971 232.164 163.009 229.333 162.61C226.478 162.198 223.859 161.437 221.265 160.49C218.696 159.517 216.214 158.345 213.92 156.873C212.922 156.237 212.635 154.915 213.271 153.93C213.808 153.082 214.843 152.746 215.753 153.057H215.778V153.07Z"
                                        fill="#F29C8A" />
                                    <path
                                        d="M194.254 154.255C195.388 151.91 197.159 149.952 198.955 148.344C200.751 146.71 202.584 145.388 204.28 144.041C205.976 142.707 207.572 141.385 209.081 139.951C210.602 138.517 212.037 136.983 213.583 135.387L213.633 135.324C214.369 134.576 215.566 134.551 216.326 135.287C216.875 135.811 217.025 136.596 216.8 137.27C216.015 139.577 214.805 141.759 213.309 143.717C211.812 145.688 210.016 147.433 208.158 148.917C206.288 150.414 204.405 151.698 202.659 152.92C200.913 154.155 199.367 155.365 197.895 156.774L197.82 156.849C196.922 157.709 195.513 157.672 194.653 156.786C193.992 156.088 193.855 155.078 194.254 154.255Z"
                                        fill="#F29C8A" />
                                    <path
                                        d="M228.46 158.095C226.39 163.583 224.295 168.995 222.2 174.32C218.097 173.646 213.957 172.661 209.817 171.327C208.807 171.002 207.809 170.653 206.812 170.292L196.935 182.002C193.53 180.717 190.226 177.874 187.944 173.921C185.986 170.554 185.125 166.937 185.25 163.732L193.493 153.968L195.563 151.511C198.668 147.845 203.943 146.922 208.133 149.279C214.942 153.132 221.789 156.075 228.46 158.108V158.095Z"
                                        fill="#F29C8A" />
                                    <path
                                        d="M226.802 170.516C222.874 170.516 218.821 168.521 218.609 168.421C218.459 168.346 218.397 168.159 218.471 167.997C218.546 167.848 218.733 167.773 218.883 167.86C218.945 167.897 225.592 171.152 229.87 169.332C231.229 168.758 232.438 168.147 233.511 167.598C236.042 166.326 237.863 165.403 239.397 166.039C239.559 166.102 239.634 166.289 239.559 166.451C239.497 166.613 239.31 166.688 239.148 166.613C237.888 166.089 236.167 166.95 233.785 168.159C232.7 168.708 231.478 169.319 230.106 169.905C229.071 170.342 227.937 170.516 226.789 170.516H226.802Z"
                                        fill="#340000" />
                                    <path
                                        d="M229.832 167.037C229.383 167.037 228.909 167 228.41 166.925C223.846 166.227 220.342 164.668 220.305 164.643C220.142 164.568 220.08 164.381 220.155 164.231C220.23 164.069 220.417 164.007 220.566 164.082C220.604 164.094 224.033 165.628 228.498 166.314C231.952 166.838 233.86 165.291 235.88 163.658C236.441 163.209 237.015 162.747 237.626 162.323C240.345 160.44 241.342 161.451 241.455 161.575C241.567 161.7 241.554 161.899 241.43 162.012C241.305 162.124 241.105 162.111 240.993 161.987C240.968 161.962 240.208 161.301 237.988 162.835C237.389 163.246 236.828 163.708 236.279 164.144C234.521 165.566 232.7 167.037 229.82 167.037H229.832Z"
                                        fill="#340000" />
                                    <path
                                        d="M230.032 162.872C226.752 162.872 222.911 161.101 222.712 161.001C222.562 160.926 222.487 160.739 222.562 160.59C222.637 160.44 222.824 160.365 222.973 160.44C223.036 160.465 228.984 163.221 232.152 161.886C233.474 161.325 235.12 160.29 236.704 159.28C239.223 157.684 241.392 156.3 242.639 156.499C243.226 156.586 243.65 156.823 243.874 157.185C244.161 157.622 244.036 158.07 244.024 158.12C243.974 158.282 243.799 158.382 243.637 158.332C243.475 158.282 243.375 158.108 243.425 157.946C243.425 157.946 243.487 157.709 243.35 157.509C243.226 157.31 242.939 157.173 242.54 157.11C241.542 156.948 239.248 158.407 237.028 159.804C235.419 160.826 233.76 161.874 232.389 162.46C231.69 162.759 230.88 162.872 230.032 162.872Z"
                                        fill="#340000" />
                                    <path
                                        d="M164.274 179.807C164.112 180.069 163.888 180.281 163.626 180.393C163.588 180.418 163.526 180.443 163.476 180.455C161.868 181.054 159.348 178.797 157.016 174.981C156.019 173.31 155.021 171.339 154.161 169.182C152.228 164.368 151.43 159.842 151.841 157.173C152.028 156.001 152.44 155.19 153.113 154.866C153.151 154.828 153.188 154.803 153.25 154.791C153.936 154.542 154.772 154.803 155.695 155.477C157.902 157.098 160.583 161.076 162.566 166.077C163.214 167.698 163.726 169.294 164.112 170.778C164.237 171.265 164.349 171.726 164.449 172.187C165.197 175.679 165.16 178.522 164.262 179.807H164.274Z"
                                        fill="#340000" />
                                    <path
                                        d="M172.206 160.952C174.725 159.505 177.431 158.495 180.174 157.684C182.918 156.911 185.686 156.337 188.392 155.926C191.111 155.489 193.755 155.14 196.349 154.754C198.943 154.367 201.474 153.918 204.055 153.382H204.093C205.365 153.108 206.612 153.931 206.861 155.203C207.061 156.175 206.624 157.136 205.839 157.647C203.382 159.231 200.663 160.39 197.957 161.313C195.239 162.236 192.52 162.909 189.864 163.52C187.22 164.156 184.614 164.668 182.07 165.229C179.501 165.753 176.982 166.326 174.376 166.788H174.313C172.592 167.099 170.959 165.94 170.659 164.231C170.422 162.884 171.083 161.6 172.206 160.952Z"
                                        fill="#F29C8A" />
                                    <path
                                        d="M167.28 156.375C170.298 154.741 173.49 153.756 176.645 152.946C179.813 152.185 182.98 151.611 186.11 151.2C189.24 150.751 192.333 150.389 195.339 149.99C198.332 149.579 201.262 149.092 203.681 148.219L203.993 148.107C205.19 147.671 206.525 148.294 206.949 149.504C207.285 150.451 206.961 151.487 206.225 152.085C203.22 154.504 199.94 155.602 196.81 156.587C193.655 157.535 190.525 158.208 187.432 158.832C184.352 159.48 181.297 160.004 178.304 160.565C175.298 161.089 172.368 161.663 169.462 162.224H169.375C167.666 162.573 166.02 161.451 165.684 159.755C165.422 158.37 166.095 157.023 167.28 156.387V156.375Z"
                                        fill="#F29C8A" />
                                    <path
                                        d="M195.688 162.174L182.668 167.997C180.661 169.07 178.528 169.88 176.321 170.404L157.016 174.981C156.019 173.31 155.021 171.34 154.161 169.182C152.228 164.368 151.43 159.842 151.841 157.173L155.695 155.477L176.209 146.423L195.663 162.161L195.688 162.174Z"
                                        fill="#F29C8A" />
                                    <path
                                        d="M182.668 168.322C182.544 168.322 182.432 168.247 182.382 168.122C182.319 167.96 182.394 167.785 182.556 167.723L201.05 160.44C201.212 160.378 201.387 160.453 201.449 160.615C201.511 160.777 201.437 160.952 201.275 161.014L182.781 168.297C182.781 168.297 182.706 168.322 182.668 168.322Z"
                                        fill="#340000" />
                                    <path
                                        d="M101.784 180.543C101.697 180.543 101.61 180.506 101.547 180.431C101.435 180.294 101.46 180.107 101.585 179.994C101.672 179.92 110.177 173.011 127.262 165.441C127.424 165.366 127.598 165.441 127.673 165.603C127.748 165.765 127.673 165.94 127.511 166.015C110.514 173.547 102.071 180.418 101.984 180.481C101.922 180.531 101.859 180.556 101.784 180.556V180.543Z"
                                        fill="#340000" />
                                    <path
                                        d="M110.826 206.357C108.095 206.357 105.314 206.07 102.558 205.384C91.0348 202.516 87.3684 195.533 86.1962 191.629C86.1713 191.53 86.1463 191.467 86.1339 191.43C86.0715 191.268 86.1339 191.093 86.3085 191.018C86.4706 190.956 86.6452 191.018 86.72 191.193C86.7325 191.23 86.7699 191.318 86.8073 191.442C87.9296 195.221 91.4962 201.98 102.72 204.761C118.694 208.739 135.866 198.999 136.041 198.9C136.191 198.812 136.378 198.862 136.465 199.012C136.552 199.161 136.502 199.349 136.353 199.436C136.203 199.523 124.194 206.332 110.838 206.332L110.826 206.357Z"
                                        fill="#340000" />
                                    <path
                                        d="M131.277 73.8445C131.277 73.8445 131.24 73.8445 131.227 73.8445C131.053 73.8196 130.941 73.6574 130.966 73.4828C130.978 73.3956 132.35 65.1775 140.493 63.9678C140.655 63.9429 140.817 64.0551 140.842 64.2297C140.867 64.4043 140.755 64.5539 140.58 64.5789C132.886 65.7262 131.589 73.4953 131.589 73.5701C131.564 73.7198 131.427 73.832 131.277 73.832V73.8445Z"
                                        fill="#340000" />
                                    <path
                                        d="M141.728 75.2414C141.728 75.2414 141.615 75.2289 141.566 75.1915C141.416 75.1042 141.379 74.9047 141.466 74.7675C144.309 70.116 148.05 69.2181 150.694 69.3054C151.804 69.3428 152.951 69.5922 154.236 70.091C155.383 70.54 158.426 71.5376 161.805 71.2633C165.21 70.9889 168.963 71.2757 169.687 72.5477C169.824 72.7971 169.924 73.2087 169.562 73.72C169.462 73.8571 169.263 73.8945 169.126 73.7948C168.988 73.695 168.951 73.4955 169.051 73.3583C169.238 73.0964 169.2 72.9593 169.138 72.8595C168.726 72.1237 165.883 71.5626 161.855 71.8868C158.338 72.1736 155.208 71.1261 154.011 70.6771C152.802 70.2157 151.717 69.9663 150.682 69.9414C148.212 69.8666 144.683 70.7021 142.002 75.1042C141.94 75.204 141.84 75.2538 141.74 75.2538L141.728 75.2414Z"
                                        fill="#340000" />
                                    <path
                                        d="M153.113 92.2138C153.001 92.2138 152.889 92.2014 152.777 92.164L150.744 91.5404C150.582 91.4906 150.482 91.316 150.544 91.1538C150.594 90.9917 150.769 90.892 150.931 90.9419L152.964 91.5654C153.113 91.6153 153.275 91.5903 153.4 91.4906C153.525 91.4033 153.6 91.2536 153.587 91.104C153.587 89.4953 153.55 85.6045 153.587 84.3948C153.587 84.2202 153.749 84.083 153.911 84.0955C154.086 84.0955 154.223 84.2452 154.211 84.4198C154.161 85.6169 154.186 89.4953 154.211 91.104C154.211 91.4656 154.049 91.7898 153.762 92.0018C153.562 92.1515 153.338 92.2263 153.101 92.2263L153.113 92.2138Z"
                                        fill="#713027" />
                                    <path
                                        d="M147.527 84.8812C147.527 85.6918 146.891 86.3527 146.105 86.3527C145.319 86.3527 144.683 85.6918 144.683 84.8812C144.683 84.0706 145.319 83.4097 146.105 83.4097C146.891 83.4097 147.527 84.0706 147.527 84.8812Z"
                                        fill="#340000" />
                                    <path
                                        d="M149.173 84.8937C149.023 84.8937 148.886 84.7815 148.861 84.6193C148.861 84.6193 148.699 83.921 147.065 83.709C145.182 83.472 142.962 83.709 142.937 83.709C142.763 83.7215 142.613 83.6092 142.588 83.4346C142.563 83.26 142.688 83.1104 142.862 83.0855C142.962 83.0855 145.182 82.836 147.14 83.0855C149.26 83.3598 149.459 84.4073 149.484 84.532C149.509 84.7066 149.385 84.8563 149.222 84.8812C149.21 84.8812 149.197 84.8812 149.185 84.8812L149.173 84.8937Z"
                                        fill="#340000" />
                                    <path
                                        d="M159.374 86.1654C159.374 86.976 158.738 87.6369 157.952 87.6369C157.166 87.6369 156.53 86.976 156.53 86.1654C156.53 85.3548 157.166 84.6938 157.952 84.6938C158.738 84.6938 159.374 85.3548 159.374 86.1654Z"
                                        fill="#340000" />
                                    <path
                                        d="M161.02 86.1779C160.87 86.1779 160.733 86.0656 160.708 85.9035C160.708 85.9035 160.546 85.2052 158.912 84.9932C157.029 84.7562 154.809 84.9932 154.784 84.9932C154.622 85.0056 154.46 84.8934 154.435 84.7188C154.41 84.5442 154.535 84.3946 154.709 84.3696C154.809 84.3696 157.029 84.1202 158.987 84.3696C161.107 84.644 161.306 85.6915 161.331 85.8162C161.356 85.9908 161.232 86.1405 161.069 86.1654C161.057 86.1654 161.045 86.1654 161.032 86.1654L161.02 86.1779Z"
                                        fill="#340000" />
                                    <path
                                        d="M152.016 97.8005C150.819 97.8005 149.659 97.3017 148.998 97.0148C148.811 96.9275 148.599 96.8403 148.537 96.8278C148.362 96.8527 148.237 96.728 148.212 96.5534C148.187 96.3788 148.337 96.2292 148.499 96.2043C148.661 96.1918 148.848 96.2666 149.247 96.4287C150.42 96.94 152.876 97.9875 154.273 96.0047C154.373 95.8675 154.572 95.8301 154.709 95.9299C154.847 96.0297 154.884 96.2292 154.784 96.3664C154.011 97.4513 153.001 97.8005 152.016 97.8005Z"
                                        fill="#F29C8A" />
                                    <path
                                        d="M141.478 80.2924C141.266 80.1552 141.304 80.2176 141.304 80.1677C141.329 80.1303 141.341 80.1053 141.378 80.0679L141.578 79.8434C141.728 79.6938 141.877 79.5317 142.052 79.3945C142.389 79.1077 142.775 78.8707 143.199 78.6837C144.035 78.2971 144.995 78.1599 145.905 78.1973C146.828 78.2223 147.701 78.4467 148.474 78.7086L149.522 79.0952C149.833 79.2199 150.07 79.2449 150.021 79.3446C150.557 79.1326 151.155 79.3945 151.367 79.9307C151.579 80.467 151.317 81.0656 150.781 81.2651C149.983 81.6143 149.397 81.4771 148.961 81.4272C148.499 81.3524 148.125 81.2526 147.751 81.1653C147.015 80.9783 146.354 80.8037 145.706 80.7164C145.057 80.6166 144.421 80.6291 143.748 80.654C143.411 80.6665 143.062 80.7039 142.688 80.7538L142.102 80.8286L141.777 80.866H141.578C141.491 80.866 141.416 80.9533 141.117 80.7912C140.979 80.6914 140.954 80.4919 141.054 80.3547C141.154 80.2176 141.353 80.1926 141.491 80.2924H141.478Z"
                                        fill="#340000" />
                                    <path
                                        d="M161.755 84.5196C161.194 84.1705 160.82 83.8587 160.409 83.6467C160.009 83.4347 159.685 83.2476 159.286 83.1105C158.9 82.9733 158.476 82.8486 157.977 82.7239C157.727 82.649 157.478 82.5992 157.166 82.4869C156.854 82.3622 156.555 82.3248 156.019 81.9008C155.545 81.5766 155.42 80.9406 155.745 80.4667C156.069 79.9928 156.705 79.8681 157.179 80.1924C157.116 80.0801 157.403 80.1175 157.628 80.1175C157.877 80.1175 158.176 80.1549 158.476 80.1924C159.087 80.2921 159.748 80.4667 160.371 80.8159C160.995 81.1651 161.581 81.6514 161.93 82.2749C162.292 82.8985 162.429 83.5968 162.316 84.2702C162.292 84.4698 162.105 84.6069 161.905 84.5695C161.855 84.5695 161.818 84.5446 161.78 84.5196L161.743 84.4947L161.755 84.5196Z"
                                        fill="#340000" />
                                    <path
                                        d="M137.625 216.819C135.231 216.819 132.649 216.732 129.868 216.508C129.694 216.495 129.569 216.345 129.581 216.171C129.594 215.996 129.768 215.859 129.918 215.884C147.801 217.268 157.74 213.502 157.84 213.465C158.002 213.402 158.176 213.477 158.239 213.639C158.301 213.801 158.226 213.976 158.064 214.038C157.977 214.076 150.769 216.807 137.625 216.807V216.819Z"
                                        fill="#8C3E0D" />
                                    <path
                                        d="M110.651 227.32H110.626C110.451 227.32 110.327 227.158 110.339 226.983C110.938 218.366 118.433 209.549 118.507 209.462C118.62 209.337 118.819 209.312 118.944 209.425C119.069 209.537 119.094 209.736 118.981 209.861C118.906 209.948 111.549 218.603 110.963 227.021C110.963 227.183 110.813 227.307 110.651 227.307V227.32Z"
                                        fill="#8C3E0D" />
                                    <path
                                        d="M125.728 143.493H125.715C120.914 143.219 119.966 141.66 119.218 139.664C119.156 139.502 119.243 139.328 119.405 139.265C119.567 139.203 119.742 139.29 119.804 139.452C120.378 140.999 120.964 142.595 125.753 142.882C125.927 142.882 126.052 143.044 126.052 143.206C126.052 143.368 125.902 143.505 125.74 143.505L125.728 143.493Z"
                                        fill="#8C3E0D" />
                                    <path
                                        d="M161.718 145.127C161.381 145.127 161.02 145.102 160.633 145.039C160.458 145.014 160.346 144.852 160.371 144.678C160.396 144.503 160.558 144.391 160.733 144.416C164.91 145.089 165.733 141.448 165.771 141.286C165.808 141.124 165.97 141.011 166.145 141.049C166.307 141.086 166.419 141.248 166.382 141.423C166.382 141.46 165.559 145.127 161.718 145.127Z"
                                        fill="#8C3E0D" />
                                    <path
                                        d="M113.345 173.16C113.27 173.16 113.195 173.135 113.133 173.073C108.12 168.334 101.859 168.272 101.797 168.272C101.622 168.272 101.485 168.135 101.485 167.96C101.485 167.786 101.622 167.648 101.797 167.648C102.059 167.648 108.381 167.723 113.569 172.624C113.694 172.736 113.694 172.936 113.569 173.061C113.507 173.123 113.42 173.16 113.345 173.16Z"
                                        fill="#340000" />
                                    <path
                                        d="M167.492 206.37C167.417 206.37 167.33 206.345 167.267 206.282C167.143 206.158 167.143 205.958 167.267 205.846C173.116 200.047 175.76 189.272 175.785 189.16C175.822 188.998 175.984 188.886 176.159 188.936C176.321 188.973 176.433 189.148 176.383 189.31C176.358 189.422 173.665 200.371 167.691 206.295C167.629 206.357 167.554 206.382 167.467 206.382L167.492 206.37Z"
                                        fill="#340000" />
                                    <path
                                        d="M112.123 153.158C111.998 153.158 111.886 153.083 111.836 152.958C107.583 142.495 99.5148 139.789 96.472 138.766C95.7487 138.53 95.4494 138.417 95.2873 138.28C95.1626 138.168 95.1376 137.968 95.2623 137.844C95.3746 137.719 95.5741 137.706 95.6988 137.806C95.7861 137.881 96.2351 138.031 96.6715 138.168C99.7892 139.215 108.057 141.984 112.422 152.709C112.484 152.871 112.422 153.045 112.247 153.12C112.21 153.133 112.172 153.145 112.135 153.145L112.123 153.158Z"
                                        fill="#340000" />
                                    <path
                                        d="M130.766 337.772C130.591 337.772 130.454 337.634 130.454 337.46C130.379 322.395 133.659 317.021 133.796 316.796C133.884 316.646 134.083 316.609 134.22 316.696C134.37 316.784 134.407 316.983 134.32 317.12C134.283 317.17 131.003 322.595 131.065 337.447C131.065 337.622 130.928 337.759 130.753 337.759L130.766 337.772Z"
                                        fill="#340000" />
                                    <path
                                        d="M392.174 294.91V375.37C390.902 375.819 389.617 376.256 388.333 376.68V294.898H392.174V294.91Z"
                                        fill="#340000" />
                                    <path
                                        d="M341.98 294.91V386.008C340.695 386.145 339.423 386.244 338.139 386.357V294.923H341.98V294.91Z"
                                        fill="#340000" />
                                    <path
                                        d="M394.83 288.575H327.252C325.048 288.575 323.261 290.362 323.261 292.566V293.139C323.261 295.343 325.048 297.13 327.252 297.13H394.83C397.034 297.13 398.821 295.343 398.821 293.139V292.566C398.821 290.362 397.034 288.575 394.83 288.575Z"
                                        fill="#DFBA9C" />
                                    <path
                                        d="M390.253 225.561V293.139C390.253 295.343 392.04 297.13 394.244 297.13H394.817C397.021 297.13 398.808 295.343 398.808 293.139V225.561C398.808 223.357 397.021 221.571 394.817 221.571H394.244C392.04 221.571 390.253 223.357 390.253 225.561Z"
                                        fill="#DFBA9C" />
                                    <path
                                        d="M396.538 181.465C394.069 168.658 388.956 157.909 383.195 152.072C380.501 149.341 379.154 145.55 379.716 141.747L381.773 127.854C382.609 121.756 378.606 116.032 372.595 114.723L362.207 112.466L357.044 148.181L368.118 149.703C361.82 155.464 359.339 170.878 362.631 187.987C366.584 208.576 377.384 223.803 386.749 222.007C396.114 220.211 400.492 202.054 396.538 181.465Z"
                                        fill="#340000" />
                                    <path
                                        d="M348.053 112.054C351.807 113.052 354.263 116.057 353.54 118.764C352.817 121.47 349.188 122.841 345.434 121.844C341.68 120.846 339.224 117.841 339.947 115.135C340.67 112.429 344.299 111.057 348.053 112.054Z"
                                        fill="#340000" />
                                    <path
                                        d="M368.579 113.85C368.143 116.744 359.488 124.189 351.245 121.021C342.965 117.853 341.207 110.471 344.2 108.052C347.205 105.42 351.807 107.565 357.568 110.309C363.292 113.214 368.579 113.863 368.579 113.863V113.85Z"
                                        fill="#340000" />
                                    <path
                                        d="M362.232 288.288L326.853 281.791L341.506 227.906L382.783 225.998L391.189 256.813C396.077 274.77 380.526 291.668 362.232 288.301V288.288Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M362.232 288.288L326.853 281.791L341.506 227.906L382.783 225.998L391.189 256.813C396.077 274.77 380.526 291.668 362.232 288.301V288.288Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M383.469 166.95C383.245 187.402 382.995 207.928 382.771 228.555C369.153 230.188 355.76 228.891 342.154 230.937C341.182 225.649 340.171 220.536 339.186 215.548C338.999 214.588 338.8 213.615 338.613 212.667C338.463 211.944 338.313 211.221 338.176 210.51C335.919 199.286 333.612 188.474 331.392 177.313C330.582 173.235 329.759 169.108 328.973 164.892C346.818 160.702 365.649 161.376 383.482 166.938L383.469 166.95Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M383.469 166.95C383.245 187.402 382.995 207.928 382.771 228.555C369.153 230.188 355.76 228.891 342.154 230.937C341.182 225.649 340.171 220.536 339.186 215.548C338.999 214.588 338.8 213.615 338.613 212.667C338.463 211.944 338.313 211.221 338.176 210.51C335.919 199.286 333.612 188.474 331.392 177.313C330.582 173.235 329.759 169.108 328.973 164.892C346.818 160.702 365.649 161.376 383.482 166.938L383.469 166.95Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M354.351 217.58C361.871 217.58 367.968 211.986 367.968 205.085C367.968 198.184 361.871 192.589 354.351 192.589C346.83 192.589 340.733 198.184 340.733 205.085C340.733 211.986 346.83 217.58 354.351 217.58Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M354.351 217.58C361.871 217.58 367.968 211.986 367.968 205.085C367.968 198.184 361.871 192.589 354.351 192.589C346.83 192.589 340.733 198.184 340.733 205.085C340.733 211.986 346.83 217.58 354.351 217.58Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M331.542 165.503C326.978 164.606 322.538 167.436 321.366 171.876C321.366 171.876 321.353 171.876 321.353 171.888C321.316 171.926 321.304 171.963 321.279 172.026C321.279 172.026 321.266 172.038 321.266 172.051L321.067 172.3C320.942 172.475 320.817 172.649 320.593 172.861C319.907 173.672 318.809 174.619 317.712 175.505C317.463 175.692 317.213 175.879 316.951 176.066C314.794 177.662 312.35 179.171 309.743 180.568C306.813 182.102 303.77 183.573 300.602 184.883C297.447 186.217 294.18 187.414 290.9 188.574L290.763 188.611C286.436 190.145 284.129 194.872 285.588 199.236C287.072 203.651 291.848 206.033 296.263 204.549C299.867 203.339 303.471 202.092 307.05 200.645C310.654 199.224 314.208 197.59 317.762 195.794C320.057 194.622 322.314 193.338 324.571 191.879H324.583C325.781 191.093 326.965 190.27 328.162 189.385C328.212 189.347 328.262 189.322 328.312 189.272C329.01 188.724 329.709 188.175 330.395 187.589C331.255 186.878 332.091 186.105 332.939 185.232C333.138 185.032 333.325 184.82 333.525 184.608C333.949 184.172 334.398 183.648 334.822 183.087L335.47 182.276C335.695 181.965 335.907 181.615 336.131 181.291L336.78 180.294C336.992 179.87 337.204 179.446 337.403 179.009C337.79 178.273 338.201 176.951 338.476 175.829C339.411 171.065 336.306 166.451 331.554 165.528L331.542 165.503ZM321.241 172.387C321.241 172.275 321.279 172.163 321.316 172.051H321.329C321.291 172.163 321.266 172.263 321.229 172.387H321.241Z"
                                        fill="#F79E7E" />
                                    <path
                                        d="M349.263 135.013C349.263 135.013 346.669 143.929 340.359 151.337C334.772 157.896 324.159 156.986 324.159 156.986C318.386 156.774 313.447 159.231 312.063 163.533C310.28 169.132 315.193 175.704 323.062 178.211C328.1 179.82 333.101 179.371 336.53 177.363L340.147 179.57H348.365L351.158 172.412L359.426 155.016L349.25 135L349.263 135.013Z"
                                        fill="#340000" />
                                    <path
                                        d="M368.143 140.5L361.209 171.464L344.274 167.673L347.641 152.659L348.502 148.793L351.208 136.696L368.143 140.5Z"
                                        fill="#F79E7E" />
                                    <path
                                        d="M356.221 149.292C356.221 149.292 351.769 152.334 347.641 152.646L348.514 148.78L349.724 148.855L356.234 149.279L356.221 149.292Z"
                                        fill="#340000" />
                                    <path
                                        d="M353.378 134.24L353.478 128.217L348.652 120.46C348.652 120.46 347.454 124.089 345.222 128.217C343.825 130.798 340.234 132.232 337.69 132.943C336.742 133.068 335.832 133.28 334.971 133.554H334.934C330.482 134.963 327.389 138.081 327.389 141.71C327.389 146.648 333.113 150.651 340.172 150.651C347.23 150.651 352.954 146.648 352.954 141.71C352.954 140.612 352.655 139.565 352.143 138.592L352.493 138.318L353.39 134.24H353.378Z"
                                        fill="#340000" />
                                    <path
                                        d="M334.073 149.042C333.986 149.042 333.911 149.005 333.849 148.942C333.812 148.892 329.671 144.316 333.824 138.854C335.62 136.497 338.288 135.549 340.87 134.626C344.249 133.429 347.754 132.182 349.537 127.742C349.599 127.58 349.786 127.505 349.948 127.568C350.111 127.63 350.185 127.817 350.123 127.979C348.24 132.681 344.599 133.965 341.082 135.212C338.476 136.135 336.006 137.02 334.323 139.228C330.482 144.278 334.148 148.344 334.298 148.518C334.41 148.643 334.41 148.843 334.285 148.955C334.223 149.005 334.148 149.042 334.073 149.042Z"
                                        fill="#8C3E0D" />
                                    <path
                                        d="M335.582 155.252C335.458 155.252 335.345 155.178 335.295 155.065C335.233 154.903 335.295 154.729 335.458 154.654C339.91 152.733 342.628 148.032 343.775 146.024C344.299 145.101 344.399 144.914 344.686 144.927C344.86 144.927 344.998 145.076 344.985 145.251C344.985 145.363 344.91 145.463 344.81 145.513C344.723 145.625 344.511 145.987 344.312 146.336C343.127 148.394 340.334 153.232 335.695 155.228C335.657 155.24 335.607 155.252 335.57 155.252H335.582Z"
                                        fill="#8C3E0D" />
                                    <path
                                        d="M322.675 172.038C322.675 172.038 322.638 172.038 322.613 172.038C316.839 170.94 315.056 167.81 314.582 165.378C313.946 162.136 315.318 158.919 315.767 158.632C315.916 158.545 316.103 158.582 316.203 158.719C316.29 158.856 316.253 159.043 316.128 159.143C315.854 159.43 314.395 162.747 315.38 165.977C316.253 168.833 318.722 170.654 322.738 171.427C322.912 171.464 323.024 171.626 322.987 171.788C322.962 171.938 322.825 172.038 322.675 172.038Z"
                                        fill="#8C3E0D" />
                                    <path
                                        d="M283.194 350.816L268.827 385.01C263.939 384.486 259.175 383.9 254.561 383.251C252.366 382.94 250.209 382.64 248.101 382.316L257.18 344.942L283.194 350.803V350.816Z"
                                        fill="#F79E7E" />
                                    <path
                                        d="M344.05 385.796C343.351 385.871 342.666 385.945 341.98 386.008C340.695 386.145 339.423 386.245 338.139 386.357C334.709 386.656 331.28 386.881 327.863 387.055C325.631 387.168 323.374 387.255 321.141 387.305L304.643 355.667L331.829 349.132L344.062 385.796H344.05Z"
                                        fill="#F79E7E" />
                                    <path
                                        d="M349.68 116.014L372.888 122.202L367.998 140.542C366.012 147.989 358.35 152.425 350.904 150.439L347.518 149.536C344.023 148.604 341.938 145.002 342.87 141.508L349.665 116.023L349.68 116.014Z"
                                        fill="#F79E7E" />
                                    <path
                                        d="M365.013 185.007C364.876 184.92 359.7 196.119 364.576 201.256C369.452 206.394 369.365 197.303 369.365 197.303L365.013 185.007Z"
                                        fill="#340000" />
                                    <path
                                        d="M367.22 135.125C365.449 136.759 364.901 139.053 365.998 140.238C367.095 141.423 369.427 141.073 371.198 139.44C372.969 137.806 373.518 135.512 372.42 134.327C371.323 133.13 368.991 133.491 367.22 135.125Z"
                                        fill="#F79E7E" />
                                    <path
                                        d="M376.735 122.206L373.53 119.686L369.702 118.726L368.567 118.439H368.442L361.583 116.906L353.004 114.212L350.472 114.511L348.826 114.86L346.357 119.088L347.991 122.218C347.991 122.218 350.235 118.851 355.984 120.148C358.416 120.697 360.274 122.393 361.421 124.575C363.167 127.905 362.506 137.507 368.555 136.397C374.528 135.3 377.259 128.042 377.259 128.042L376.71 122.218L376.735 122.206Z"
                                        fill="#340000" />
                                    <path
                                        d="M348.864 200.334C348.864 205.247 346.12 209.487 342.129 211.52C341.045 212.081 339.86 212.48 338.6 212.667C338.014 212.767 337.403 212.817 336.792 212.817C336.181 212.817 335.62 212.779 335.034 212.68C329.185 211.794 324.696 206.606 324.696 200.321C324.696 197.777 325.431 195.42 326.691 193.45C327.564 191.679 329.671 186.866 329.858 181.341C329.908 179.707 330.482 178.386 331.355 177.313C334.148 173.809 339.922 173.011 339.922 173.011L339.71 188.2C344.96 189.547 348.851 194.448 348.851 200.309L348.864 200.334Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M348.864 200.334C348.864 205.247 346.12 209.487 342.129 211.52C341.045 212.081 339.86 212.48 338.6 212.667C338.014 212.767 337.403 212.817 336.792 212.817C336.181 212.817 335.62 212.779 335.034 212.68C329.185 211.794 324.696 206.606 324.696 200.321C324.696 197.777 325.431 195.42 326.691 193.45C327.564 191.679 329.671 186.866 329.858 181.341C329.908 179.707 330.482 178.386 331.355 177.313C334.148 173.809 339.922 173.011 339.922 173.011L339.71 188.2C344.96 189.547 348.851 194.448 348.851 200.309L348.864 200.334Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M341.743 166.089C341.631 166.152 339.523 168.621 339.324 169.307C337.939 173.908 333.949 190.17 334.073 189.397C334.073 189.397 347.953 198.001 362.619 196.567L368.542 168.272C368.542 168.272 345.097 162.56 344.1 162.51C343.102 162.46 341.743 166.089 341.743 166.089Z"
                                        fill="#F79E7E" />
                                    <path
                                        d="M332.178 169.781C332.739 169.668 343.626 175.33 346.17 158.881L324.72 162.199L332.178 169.781Z"
                                        fill="#340000" />
                                    <path
                                        d="M385.938 234.653C386.088 239.292 382.447 243.195 377.783 243.357C373.169 243.507 369.303 239.915 369.078 235.326V235.301C368.704 227.133 368.143 219.002 367.407 210.847L366.197 198.576L365.586 192.502V192.303C365.449 190.944 365.325 189.597 365.237 188.113C365.187 187.24 365.137 186.329 365.125 185.344C365.063 180.493 368.929 176.515 373.767 176.428C378.618 176.353 382.596 180.219 382.684 185.057V185.344C382.671 186.791 382.821 188.836 382.983 190.806V190.856L383.419 195.994L383.494 196.917L384.542 209.412C385.19 217.805 385.652 226.223 385.926 234.653H385.938Z"
                                        fill="#F79E7E" />
                                    <path
                                        d="M373.929 191.791C380.169 191.791 385.228 186.861 385.228 180.78C385.228 174.698 380.169 169.768 373.929 169.768C367.689 169.768 362.631 174.698 362.631 180.78C362.631 186.861 367.689 191.791 373.929 191.791Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M373.929 191.791C380.169 191.791 385.228 186.861 385.228 180.78C385.228 174.698 380.169 169.768 373.929 169.768C367.689 169.768 362.631 174.698 362.631 180.78C362.631 186.861 367.689 191.791 373.929 191.791Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M340.059 172.2C339.61 177.251 335.046 181.254 329.397 181.254C323.748 181.254 319.171 176.989 319.171 171.726C319.171 166.464 323.748 162.199 329.397 162.199C335.046 162.199 340.521 166.962 340.059 172.2Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M340.059 172.2C339.61 177.251 335.046 181.254 329.397 181.254C323.748 181.254 319.171 176.989 319.171 171.726C319.171 166.464 323.748 162.199 329.397 162.199C335.046 162.199 340.521 166.962 340.059 172.2Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M332.926 185.244C331.392 186.841 329.846 188.088 328.3 189.285C328.25 189.322 328.2 189.347 328.15 189.397C327.975 188.998 327.801 188.599 327.614 188.187C324.172 180.83 319.533 176.627 316.951 176.079C317.213 175.891 317.463 175.704 317.712 175.517C318.809 174.619 319.907 173.684 320.593 172.874C320.805 172.662 320.942 172.487 321.067 172.312L321.266 172.063L321.279 172.038C321.291 172.038 321.304 172.051 321.316 172.063H321.328C325.506 174.096 329.846 178.635 332.889 185.17C332.901 185.195 332.914 185.232 332.926 185.269V185.244Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M332.926 185.244C331.392 186.841 329.846 188.088 328.3 189.285C328.25 189.322 328.2 189.347 328.15 189.397C327.975 188.998 327.801 188.599 327.614 188.187C324.172 180.83 319.533 176.627 316.951 176.079C317.213 175.891 317.463 175.704 317.712 175.517C318.809 174.619 319.907 173.684 320.593 172.874C320.805 172.662 320.942 172.487 321.067 172.312L321.266 172.063L321.279 172.038C321.291 172.038 321.304 172.051 321.316 172.063H321.328C325.506 174.096 329.846 178.635 332.889 185.17C332.901 185.195 332.914 185.232 332.926 185.269V185.244Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M383.444 195.994C381.449 194.859 378.855 193.812 375.762 193.088C371.697 192.141 368.155 192.078 365.599 192.502V192.303C365.462 190.944 365.337 189.597 365.25 188.113C368.504 187.601 372.495 187.801 376.748 188.799C379.017 189.335 381.125 190.033 382.995 190.856L383.432 195.994H383.444Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M383.444 195.994C381.449 194.859 378.855 193.812 375.762 193.088C371.697 192.141 368.155 192.078 365.599 192.502V192.303C365.462 190.944 365.337 189.597 365.25 188.113C368.504 187.601 372.495 187.801 376.748 188.799C379.017 189.335 381.125 190.033 382.995 190.856L383.432 195.994H383.444Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M368.554 225.936C368.392 225.936 368.255 225.811 368.243 225.649L365.162 191.081C365.15 190.906 365.275 190.757 365.449 190.744C365.611 190.744 365.773 190.856 365.786 191.031L368.866 225.587C368.879 225.761 368.754 225.911 368.579 225.924H368.554V225.936Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M368.554 225.936C368.392 225.936 368.255 225.811 368.243 225.649L365.162 191.081C365.15 190.906 365.275 190.757 365.449 190.744C365.611 190.744 365.773 190.856 365.786 191.031L368.866 225.587C368.879 225.761 368.754 225.911 368.579 225.924H368.554V225.936Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M395.778 199.685H395.79L393.795 190.245L390.39 175.181L386.986 163.708L383.981 162.86C384.367 161.7 384.579 160.465 384.579 159.193C384.579 151.936 377.907 146.049 369.652 145.962L368.056 140.912C367.021 144.777 361.234 148.095 361.234 148.095C357.094 150.464 354.35 154.542 354.35 159.193C354.35 164.768 358.291 169.519 363.853 171.477H363.866C368.879 173.572 374.041 170.966 375.962 176.727C377.346 180.867 370.487 188.113 366.272 195.358C365.075 197.129 364.165 199.137 363.616 201.306C363.566 201.506 363.504 201.693 363.466 201.893C363.466 201.942 363.466 201.992 363.442 202.042C363.167 203.352 363.005 204.723 363.005 206.12C363.005 216.221 370.587 224.402 379.94 224.402C389.293 224.402 396.875 216.209 396.875 206.12C396.875 203.85 396.476 201.681 395.778 199.673V199.685Z"
                                        fill="#340000" />
                                    <path
                                        d="M249.735 160.74C253.264 163.446 257.03 166.177 260.759 168.783C264.5 171.389 268.304 173.921 272.145 176.29C275.973 178.672 279.851 180.954 283.742 182.912C287.608 184.87 291.561 186.653 295.128 187.664C299.767 188.973 302.473 193.799 301.164 198.438C299.854 203.077 295.028 205.783 290.389 204.474C290.177 204.411 289.965 204.349 289.753 204.262H289.716C284.403 202.291 280.001 199.81 275.699 197.241C271.421 194.672 267.418 191.904 263.515 189.06C259.599 186.229 255.821 183.286 252.104 180.281C248.376 177.251 244.784 174.233 241.118 170.978C238.362 168.521 238.112 164.281 240.582 161.525C242.926 158.894 246.879 158.545 249.635 160.652L249.735 160.727V160.74Z"
                                        fill="#F79E7E" />
                                    <path
                                        d="M327.19 293.614C324.808 296.881 324.321 301.719 325.145 305.61C325.145 305.61 325.743 308.466 326.641 312.756C329.447 326.162 335.258 353.784 335.258 353.784H335.196C335.395 354.146 335.52 354.507 335.508 354.869C335.308 358.46 327.227 362.713 312.275 360.069C302.847 358.411 295.652 351.664 288.406 355.293C283.131 358.211 279.215 359.084 272.668 359.084C262.118 359.084 253.589 355.181 253.589 350.367C253.589 349.706 253.751 349.083 254.037 348.472L269.95 286.954C270.1 286.331 270.249 285.695 270.436 285.084L270.748 283.874H270.81C274.751 271.915 284.316 262.5 296.574 258.908L358.653 240.776C358.653 240.776 365.574 288.675 365.574 288.688C365.524 288.339 338.712 288.75 335.458 288.812H335.133C332.016 289.461 329.222 290.833 327.202 293.614H327.19Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M327.19 293.614C324.808 296.881 324.321 301.719 325.145 305.61C325.145 305.61 325.743 308.466 326.641 312.756C329.447 326.162 335.258 353.784 335.258 353.784H335.196C335.395 354.146 335.52 354.507 335.508 354.869C335.308 358.46 327.227 362.713 312.275 360.069C302.847 358.411 295.652 351.664 288.406 355.293C283.131 358.211 279.215 359.084 272.668 359.084C262.118 359.084 253.589 355.181 253.589 350.367C253.589 349.706 253.751 349.083 254.037 348.472L269.95 286.954C270.1 286.331 270.249 285.695 270.436 285.084L270.748 283.874H270.81C274.751 271.915 284.316 262.5 296.574 258.908L358.653 240.776C358.653 240.776 365.574 288.675 365.574 288.688C365.524 288.339 338.712 288.75 335.458 288.812H335.133C332.016 289.461 329.222 290.833 327.202 293.614H327.19Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M319.308 252.585C319.171 252.585 319.046 252.498 319.009 252.361C318.959 252.199 319.059 252.024 319.221 251.974L352.63 242.21C358.266 240.564 358.915 235.738 358.94 235.538C358.965 235.363 359.127 235.251 359.289 235.264C359.463 235.289 359.576 235.438 359.563 235.613C359.563 235.663 358.865 241.038 352.817 242.808L319.408 252.573C319.408 252.573 319.346 252.573 319.321 252.573L319.308 252.585Z"
                                        fill="#340000" />
                                    <path
                                        d="M376.585 226.285H376.473C371.809 225.998 366.609 225.324 361.509 224.589C356.383 223.84 351.22 223.03 346.058 222.157C336.343 220.511 326.579 218.74 316.889 216.882L295.402 209.599L289.229 215.523L293.32 221.533C300.49 229.066 305.541 229.577 309.556 226.671C312.649 225.998 332.652 234.827 343.002 237.271C348.178 238.493 353.378 239.666 358.628 240.776C363.915 241.873 369.116 242.933 374.952 243.669C375.139 243.694 375.338 243.706 375.526 243.719C380.339 244.005 384.479 240.339 384.766 235.525C385.053 230.712 381.387 226.572 376.573 226.285H376.585Z"
                                        fill="#F79E7E" />
                                    <path
                                        d="M249.685 160.465L241.118 170.978C234.82 165.054 233.773 166.75 231.603 165.029C230.693 164.306 230.044 163.308 229.657 162.223L226.914 154.716L238.537 148.718L249.698 160.453L249.685 160.465Z"
                                        fill="#F79E7E" />
                                    <path
                                        d="M233.698 137.744C234.172 139.153 234.721 140.6 235.307 141.984C235.88 143.381 236.504 144.752 237.19 146.074C237.863 147.396 238.586 148.681 239.372 149.815C240.158 150.95 241.031 152.01 241.854 152.634C243.338 153.756 243.625 155.876 242.502 157.36C241.38 158.844 239.26 159.131 237.776 158.009C237.564 157.846 237.389 157.672 237.227 157.485L237.09 157.323C235.768 155.714 234.995 154.105 234.309 152.522C233.636 150.938 233.137 149.366 232.7 147.795C232.264 146.224 231.902 144.665 231.603 143.094C231.304 141.523 231.042 139.976 230.83 138.355C230.73 137.544 231.304 136.796 232.114 136.696C232.825 136.609 233.486 137.033 233.698 137.694V137.731V137.744Z"
                                        fill="#F79E7E" />
                                    <path
                                        d="M212.785 143.817C215.217 143.667 217.673 143.231 220.167 142.794L222.05 142.47L222.998 142.308C223.297 142.258 223.759 142.196 224.133 142.183C225.717 142.096 227.338 142.47 228.747 143.243C229.458 143.63 230.106 144.116 230.692 144.677L231.116 145.114L231.441 145.463L232.089 146.161L234.658 148.98L239.796 154.616C240.694 155.602 240.632 157.136 239.634 158.046C238.649 158.944 237.115 158.881 236.217 157.884C236.18 157.846 236.142 157.796 236.105 157.747L231.378 151.761L229.021 148.768L228.435 148.02L227.924 147.384C227.625 147.034 227.263 146.735 226.876 146.486C226.091 145.974 225.168 145.675 224.208 145.65C223.946 145.65 223.771 145.65 223.447 145.675L222.512 145.762L220.629 145.962C218.11 146.224 215.503 146.511 212.86 146.486C212.124 146.486 211.525 145.875 211.538 145.139C211.538 144.428 212.099 143.854 212.797 143.817H212.785Z"
                                        fill="#F79E7E" />
                                    <path
                                        d="M213.496 148.132C213.496 148.132 213.87 148.082 214.119 148.032L214.967 147.857C215.541 147.72 216.127 147.57 216.701 147.421C217.873 147.109 219.033 146.76 220.192 146.398L221.926 145.837L222.138 145.762L222.437 145.675C222.637 145.613 222.836 145.575 223.036 145.538C223.447 145.475 223.859 145.425 224.27 145.438C225.929 145.438 227.587 146.086 228.847 147.221C228.997 147.358 229.159 147.521 229.283 147.658L229.608 147.994L230.244 148.668L231.516 150.002L234.072 152.683L239.173 158.046C240.095 159.018 240.058 160.552 239.085 161.475C238.113 162.398 236.579 162.361 235.656 161.388C235.618 161.35 235.569 161.301 235.544 161.251L226.241 149.94C225.717 149.366 224.956 148.992 224.145 148.917C223.946 148.892 223.746 148.905 223.534 148.917C223.435 148.93 223.335 148.942 223.235 148.967L223.085 148.992L222.861 149.054L221.028 149.503C219.806 149.79 218.584 150.052 217.349 150.289C216.738 150.414 216.114 150.526 215.478 150.626L214.493 150.763C214.132 150.788 213.845 150.85 213.284 150.813C212.56 150.775 211.999 150.152 212.049 149.416C212.086 148.78 212.56 148.281 213.171 148.194L213.496 148.144V148.132Z"
                                        fill="#F79E7E" />
                                    <path
                                        d="M214.144 152.347C215.241 151.586 216.227 151.175 217.249 150.726C218.272 150.289 219.282 149.903 220.305 149.529L221.838 148.992C222.437 148.768 223.285 148.631 224.033 148.668C225.567 148.743 227.064 149.479 228.086 150.676L227.999 150.576L235.893 158.208C236.853 159.143 236.878 160.677 235.955 161.638C235.02 162.598 233.486 162.623 232.526 161.7C232.463 161.638 232.413 161.575 232.351 161.513L225.28 153.12L225.193 153.02C224.869 152.559 224.345 152.222 223.759 152.123C223.435 152.085 223.21 152.073 222.799 152.185L221.277 152.584C220.267 152.858 219.269 153.145 218.297 153.469C217.349 153.794 216.339 154.155 215.653 154.567L215.578 154.604C214.942 154.978 214.119 154.766 213.757 154.118C213.408 153.507 213.583 152.746 214.157 152.347H214.144Z"
                                        fill="#F79E7E" />
                                    <path
                                        d="M215.054 155.552C216.152 154.791 217.137 154.38 218.16 153.931C219.182 153.494 220.192 153.108 221.215 152.734L222.749 152.198C223.347 151.973 224.195 151.836 224.944 151.873C226.477 151.948 227.974 152.684 228.997 153.881L229.121 154.056L234.321 161.176C235.107 162.261 234.87 163.783 233.798 164.568C232.713 165.354 231.191 165.117 230.406 164.045C230.343 163.97 230.281 163.87 230.244 163.783L225.991 156.063L226.116 156.238C225.792 155.777 225.268 155.44 224.682 155.34C224.357 155.303 224.133 155.29 223.721 155.402L222.2 155.802C221.19 156.076 220.192 156.363 219.22 156.687C218.272 157.011 217.262 157.373 216.576 157.784L216.501 157.822C215.865 158.196 215.042 157.984 214.68 157.335C214.331 156.724 214.506 155.964 215.079 155.565L215.054 155.552Z"
                                        fill="#F79E7E" />
                                    <path
                                        d="M277.619 220.287C279.041 219.376 279.889 217.817 281.236 215.972C281.922 215.074 282.77 214.139 283.83 213.415C284.902 212.667 286.137 212.168 287.434 211.931C288.73 211.694 290.09 211.744 291.387 212.056C292.035 212.231 292.671 212.443 293.27 212.742C293.557 212.879 293.906 213.079 294.118 213.203L294.791 213.59L300.141 216.683C301.388 217.406 301.812 218.99 301.089 220.237C300.365 221.484 298.782 221.908 297.535 221.184C297.472 221.147 297.398 221.097 297.335 221.06L292.285 217.493L291.175 216.72C290.863 216.533 290.539 216.383 290.202 216.259C289.516 216.022 288.768 215.922 288.032 215.984C286.536 216.096 285.201 216.87 283.942 218.216C283.306 218.89 282.67 219.713 281.884 220.548C281.123 221.384 280.138 222.195 279.066 222.756C278.367 223.13 277.494 222.856 277.12 222.157C276.771 221.496 276.996 220.686 277.607 220.287H277.619Z"
                                        fill="#F79E7E" />
                                    <path
                                        d="M281.398 220.561C282.52 219.152 283.406 217.256 284.453 215.373C284.989 214.426 285.551 213.453 286.286 212.493C286.648 212.019 287.084 211.545 287.571 211.084C288.144 210.61 288.556 210.298 289.067 209.949C289.591 209.612 290.177 209.25 290.975 209.001C291.773 208.739 292.796 208.714 293.594 208.914C294.405 209.101 295.041 209.388 295.602 209.674C295.889 209.812 296.138 209.961 296.4 210.098L297.086 210.497L302.548 213.665C303.795 214.388 304.219 215.972 303.496 217.219C302.772 218.466 301.189 218.89 299.942 218.167C299.879 218.129 299.804 218.08 299.742 218.042L294.579 214.401L293.382 213.565C293.033 213.328 292.709 213.154 292.509 213.066C292.297 212.992 292.235 212.954 292.01 212.967C291.798 212.992 291.437 213.116 291.05 213.316C290.152 213.777 289.678 214.114 289.042 214.812C288.444 215.473 287.87 216.271 287.309 217.119C286.162 218.815 285.139 220.698 283.493 222.482C282.957 223.068 282.046 223.093 281.473 222.556C280.924 222.045 280.862 221.197 281.323 220.611L281.373 220.549L281.398 220.561Z"
                                        fill="#F79E7E" />
                                    <path
                                        d="M274.576 221.347C276.347 221.159 278.068 220.212 279.727 219.015C280.562 218.416 281.398 217.755 282.271 217.069C282.67 216.757 283.231 216.321 283.854 215.997C284.466 215.672 285.101 215.398 285.775 215.211C287.109 214.837 288.543 214.762 289.928 214.999C290.626 215.124 291.299 215.323 291.96 215.585C292.609 215.847 293.282 216.259 293.694 216.495L299.343 219.775C300.59 220.499 301.014 222.082 300.291 223.329C299.567 224.576 297.984 225 296.737 224.277C296.674 224.24 296.599 224.19 296.537 224.152L291.2 220.386C290.701 220.037 290.451 219.85 290.102 219.663C289.765 219.488 289.404 219.339 289.042 219.239C288.294 219.039 287.496 218.99 286.723 219.127C286.336 219.189 285.962 219.314 285.588 219.463C285.226 219.613 284.902 219.813 284.416 220.124C283.518 220.698 282.582 221.309 281.597 221.895C279.639 223.043 277.332 224.152 274.714 224.202C273.915 224.215 273.267 223.591 273.254 222.793C273.242 222.045 273.803 221.421 274.526 221.347H274.564H274.576Z"
                                        fill="#F79E7E" />
                                    <path
                                        d="M233.848 160.054C233.511 160.091 233.062 159.892 232.837 159.592C232.613 159.293 232.713 158.994 233.049 158.944H233.074C233.424 158.907 233.873 159.106 234.109 159.405C234.346 159.717 234.247 160.004 233.897 160.054H233.86H233.848Z"
                                        fill="#162847" />
                                    <path
                                        d="M240.607 159.293L223.472 136.796C222.861 135.998 221.676 135.462 220.741 135.562C220.716 135.562 220.679 135.562 220.654 135.562L208.682 137.395C208.595 137.407 208.532 137.432 208.458 137.457L207.772 136.584V138.268C207.772 138.542 207.871 138.829 208.108 139.141L225.517 161.999C226.128 162.797 227.325 163.334 228.248 163.234C228.273 163.234 228.311 163.234 228.336 163.234L240.307 161.401C240.844 161.313 241.143 161.014 241.193 160.628H241.205V158.932C241.205 158.932 240.844 159.144 240.582 159.293H240.607Z"
                                        fill="#241E2C" />
                                    <path
                                        d="M220.753 133.89C220.753 133.89 220.691 133.89 220.666 133.89L208.694 135.724C207.759 135.873 207.51 136.634 208.121 137.457L225.53 160.315C226.141 161.114 227.338 161.65 228.261 161.55C228.286 161.55 228.323 161.55 228.348 161.55L240.32 159.717C241.255 159.567 241.492 158.794 240.881 157.983L223.472 135.125C222.861 134.327 221.676 133.791 220.741 133.89H220.753Z"
                                        fill="#6C949F" />
                                    <path
                                        d="M222.175 134.838L208.769 136.871L225.842 159.28L239.235 157.235L222.175 134.838Z"
                                        fill="white" />
                                    <path
                                        d="M233.074 158.931H233.049C232.713 158.993 232.613 159.28 232.837 159.58C233.062 159.879 233.511 160.078 233.848 160.041H233.885C234.234 159.979 234.334 159.692 234.097 159.38C233.873 159.081 233.411 158.881 233.062 158.919L233.074 158.931Z"
                                        fill="white" />
                                    <path
                                        d="M277.594 220.611C277.519 220.611 277.445 220.586 277.382 220.523C277.258 220.411 277.258 220.212 277.382 220.087C277.582 219.875 282.395 214.874 286.935 214.562C291.449 214.251 295.951 216.982 296.138 217.094C296.288 217.181 296.325 217.381 296.238 217.518C296.15 217.668 295.951 217.717 295.814 217.618C295.764 217.593 291.287 214.887 286.985 215.173C282.682 215.473 277.881 220.448 277.844 220.511C277.781 220.573 277.694 220.611 277.619 220.611H277.594Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M277.594 220.611C277.519 220.611 277.445 220.586 277.382 220.523C277.258 220.411 277.258 220.212 277.382 220.087C277.582 219.875 282.395 214.874 286.935 214.562C291.449 214.251 295.951 216.982 296.138 217.094C296.288 217.181 296.325 217.381 296.238 217.518C296.15 217.668 295.951 217.717 295.814 217.618C295.764 217.593 291.287 214.887 286.985 215.173C282.682 215.473 277.881 220.448 277.844 220.511C277.781 220.573 277.694 220.611 277.619 220.611H277.594Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M281.186 222.457C281.111 222.457 281.024 222.432 280.961 222.369C280.837 222.245 280.837 222.045 280.961 221.933C281.111 221.783 284.69 218.266 288.356 218.803C288.531 218.828 288.643 218.99 288.618 219.152C288.593 219.326 288.431 219.439 288.269 219.414C284.927 218.94 281.435 222.332 281.398 222.369C281.335 222.432 281.261 222.457 281.173 222.457H281.186Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M281.186 222.457C281.111 222.457 281.024 222.432 280.961 222.369C280.837 222.245 280.837 222.045 280.961 221.933C281.111 221.783 284.69 218.266 288.356 218.803C288.531 218.828 288.643 218.99 288.618 219.152C288.593 219.326 288.431 219.439 288.269 219.414C284.927 218.94 281.435 222.332 281.398 222.369C281.335 222.432 281.261 222.457 281.173 222.457H281.186Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M297.884 214.762C297.809 214.762 297.747 214.737 297.684 214.687C297.672 214.675 295.889 213.253 292.197 212.393C289.965 211.869 287.833 211.931 286.199 212.58L286.099 212.617C285.937 212.667 285.763 212.58 285.7 212.418C285.65 212.255 285.738 212.081 285.9 212.019L285.962 211.994C287.745 211.295 289.953 211.22 292.335 211.782C296.175 212.692 297.996 214.139 298.071 214.201C298.208 214.313 298.221 214.5 298.121 214.637C298.058 214.712 297.971 214.75 297.884 214.75V214.762Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M297.884 214.762C297.809 214.762 297.747 214.737 297.684 214.687C297.672 214.675 295.889 213.253 292.197 212.393C289.965 211.869 287.833 211.931 286.199 212.58L286.099 212.617C285.937 212.667 285.763 212.58 285.7 212.418C285.65 212.255 285.738 212.081 285.9 212.019L285.962 211.994C287.745 211.295 289.953 211.22 292.335 211.782C296.175 212.692 297.996 214.139 298.071 214.201C298.208 214.313 298.221 214.5 298.121 214.637C298.058 214.712 297.971 214.75 297.884 214.75V214.762Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M376.511 231.248C376.398 231.248 376.286 231.186 376.224 231.074C375.077 228.642 371.647 225.599 361.908 224.938C361.671 224.926 361.521 224.913 361.446 224.901C361.272 224.876 361.159 224.714 361.184 224.552C361.209 224.377 361.371 224.252 361.534 224.29C361.596 224.29 361.733 224.302 361.945 224.327C371.984 225.013 375.551 228.243 376.773 230.824C376.847 230.974 376.773 231.161 376.623 231.236C376.586 231.261 376.536 231.261 376.486 231.261L376.511 231.248Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M376.511 231.248C376.398 231.248 376.286 231.186 376.224 231.074C375.077 228.642 371.647 225.599 361.908 224.938C361.671 224.926 361.521 224.913 361.446 224.901C361.272 224.876 361.159 224.714 361.184 224.552C361.209 224.377 361.371 224.252 361.534 224.29C361.596 224.29 361.733 224.302 361.945 224.327C371.984 225.013 375.551 228.243 376.773 230.824C376.847 230.974 376.773 231.161 376.623 231.236C376.586 231.261 376.536 231.261 376.486 231.261L376.511 231.248Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M354.251 217.742C350.273 217.742 345.933 216.632 343.102 213.415C342.479 212.704 341.955 211.906 341.518 211.033C340.783 209.512 340.359 207.941 340.259 206.332C340.196 205.185 340.296 204.025 340.571 202.877C340.608 202.715 340.77 202.603 340.945 202.641C341.107 202.678 341.219 202.853 341.182 203.015C340.92 204.1 340.82 205.197 340.882 206.282C340.982 207.803 341.381 209.3 342.079 210.746C342.491 211.569 342.99 212.33 343.576 212.991C348.614 218.74 359.476 217.443 362.531 215.099C362.668 214.986 362.868 215.024 362.968 215.161C363.067 215.298 363.042 215.498 362.905 215.597C361.409 216.745 357.992 217.73 354.251 217.73V217.742Z"
                                        fill="#340000" />
                                    <path
                                        d="M337.191 213.128C335.769 213.128 334.148 212.904 332.44 212.255C332.278 212.193 332.203 212.018 332.253 211.856C332.315 211.694 332.49 211.607 332.652 211.669C337.752 213.602 342.117 211.52 342.154 211.495C342.304 211.42 342.491 211.495 342.566 211.644C342.641 211.794 342.566 211.981 342.429 212.056C342.304 212.118 340.196 213.128 337.179 213.128H337.191Z"
                                        fill="#340000" />
                                    <path
                                        d="M328.387 182.364C328.275 182.364 328.175 182.301 328.113 182.202C324.671 175.904 319.271 174.47 319.221 174.458C319.059 174.42 318.959 174.246 318.997 174.083C319.034 173.921 319.209 173.822 319.371 173.859C319.608 173.921 325.082 175.355 328.661 181.902C328.749 182.052 328.686 182.239 328.537 182.326C328.487 182.351 328.437 182.364 328.387 182.364Z"
                                        fill="#340000" />
                                    <path
                                        d="M326.529 194.073C326.529 194.073 326.429 194.073 326.379 194.036C326.229 193.949 326.18 193.762 326.254 193.612C326.915 192.427 327.576 190.844 328.187 189.048C328.886 187.015 329.397 185.045 329.709 183.76C329.796 183.411 329.858 183.112 329.908 182.912C329.946 182.763 329.958 182.663 329.983 182.6C330.033 182.438 330.195 182.339 330.37 182.376C330.532 182.426 330.632 182.588 330.594 182.763C330.582 182.812 330.557 182.912 330.532 183.049C330.482 183.261 330.42 183.548 330.332 183.91C330.021 185.207 329.509 187.19 328.798 189.247C328.175 191.08 327.489 192.689 326.828 193.911C326.766 194.011 326.666 194.073 326.554 194.073H326.529Z"
                                        fill="#340000" />
                                    <path
                                        d="M375.551 188.524C375.551 188.524 375.526 188.524 375.513 188.524C369.228 187.738 365.35 188.412 365.312 188.424C365.138 188.449 364.975 188.337 364.951 188.175C364.926 188 365.038 187.838 365.2 187.813C365.362 187.788 369.203 187.115 375.588 187.913C375.763 187.938 375.875 188.087 375.862 188.262C375.837 188.424 375.713 188.536 375.551 188.536V188.524Z"
                                        fill="#340000" />
                                    <path
                                        d="M342.142 211.52C342.142 211.794 342.304 211.794 342.304 211.794C341.219 212.343 339.86 212.492 338.6 212.679C338.014 212.779 337.403 212.829 336.792 212.829C336.181 212.829 335.62 212.792 335.034 212.692C336.355 212.118 337.378 211.345 338.151 210.522C339.623 208.988 340.271 207.267 340.558 206.319C340.658 207.753 341.007 209.287 341.793 210.896C341.905 211.108 342.005 211.32 342.129 211.52H342.142Z"
                                        fill="#340000" />
                                    <path
                                        d="M301.488 313.092C301.488 313.092 301.413 313.092 301.376 313.067C301.214 313.005 301.139 312.818 301.201 312.668L304.281 304.799C306.326 299.549 310.142 295.097 315.018 292.267C318.523 290.209 322.513 289.037 326.554 288.862L338.126 288.363C338.313 288.363 338.438 288.488 338.451 288.663C338.451 288.837 338.326 288.974 338.151 288.987L326.579 289.486C322.638 289.648 318.747 290.795 315.33 292.803C310.579 295.571 306.863 299.911 304.867 305.024L301.787 312.893C301.737 313.018 301.625 313.092 301.5 313.092H301.488Z"
                                        fill="#340000" />
                                    <path
                                        d="M326.554 289.174L335.121 288.812C332.003 289.461 329.21 290.833 327.19 293.614C324.808 296.881 324.322 301.72 325.145 305.61C325.145 305.61 325.743 308.466 326.641 312.756C324.621 306.982 321.628 306.396 317.326 300.722C314.532 297.043 314.557 294.262 315.168 292.529C318.573 290.533 322.463 289.349 326.554 289.174Z"
                                        fill="#340000" />
                                    <path
                                        d="M330.008 183.822C329.709 185.057 329.197 187.065 328.487 189.135C328.424 189.185 328.362 189.234 328.3 189.284C328.25 189.322 328.2 189.347 328.15 189.397C326.953 190.282 325.768 191.093 324.571 191.878L330.008 183.835V183.822Z"
                                        fill="#340000" />
                                    <path
                                        d="M375.264 181.553C375.264 181.553 375.151 181.54 375.101 181.503C374.952 181.416 374.914 181.216 375.002 181.079C379.055 174.532 376.099 166.326 375.351 164.98C375.264 164.83 375.326 164.643 375.476 164.556C375.625 164.468 375.812 164.531 375.9 164.68C375.949 164.768 380.264 173.796 375.538 181.416C375.476 181.515 375.376 181.565 375.276 181.565L375.264 181.553Z"
                                        fill="#8C3E0D" />
                                    <path
                                        d="M349.001 118.153C349.001 118.153 348.913 118.153 348.876 118.128C341.83 114.935 342.491 110.421 342.516 110.234C342.541 110.06 342.703 109.947 342.878 109.972C343.052 109.997 343.164 110.159 343.14 110.334C343.115 110.508 342.553 114.574 349.138 117.567C349.3 117.642 349.362 117.816 349.288 117.978C349.238 118.091 349.125 118.165 349.001 118.165V118.153Z"
                                        fill="#8C3E0D" />
                                    <path
                                        d="M374.441 223.741C374.316 223.741 374.191 223.654 374.141 223.529C370.824 213.403 379.03 205.434 388.395 198.326C390.752 196.53 392.56 194.198 393.77 191.392C396.85 184.222 395.017 176.203 394.992 176.129C394.955 175.966 395.054 175.792 395.229 175.754C395.404 175.717 395.566 175.817 395.603 175.991C395.628 176.079 397.499 184.272 394.344 191.642C393.084 194.548 391.214 196.967 388.769 198.825C379.591 205.783 371.535 213.578 374.727 223.33C374.777 223.492 374.69 223.666 374.528 223.729C374.49 223.729 374.466 223.741 374.428 223.741H374.441Z"
                                        fill="#8C3E0D" />
                                    <path
                                        d="M357.082 133.304C357.082 134.077 356.62 134.713 356.046 134.713C355.473 134.713 355.011 134.077 355.011 133.304C355.011 132.531 355.473 131.895 356.046 131.895C356.62 131.895 357.082 132.531 357.082 133.304Z"
                                        fill="#340000" />
                                    <path
                                        d="M349.362 131.347C349.362 132.12 348.901 132.756 348.327 132.756C347.754 132.756 347.292 132.12 347.292 131.347C347.292 130.574 347.754 129.938 348.327 129.938C348.901 129.938 349.362 130.574 349.362 131.347Z"
                                        fill="#340000" />
                                    <path
                                        d="M357.817 134.115C357.693 134.115 357.568 134.04 357.53 133.915C357.53 133.915 357.156 132.918 356.408 132.357C355.61 131.758 354.849 131.746 354.837 131.746C354.662 131.746 354.525 131.608 354.525 131.434C354.525 131.259 354.662 131.122 354.837 131.122C354.874 131.122 355.81 131.122 356.77 131.858C357.668 132.531 358.092 133.654 358.104 133.703C358.167 133.866 358.079 134.04 357.917 134.103C357.88 134.115 357.842 134.127 357.805 134.127L357.817 134.115Z"
                                        fill="#340000" />
                                    <path
                                        d="M350.023 132.519C349.886 132.519 349.761 132.432 349.724 132.294C349.724 132.294 349.375 131.197 348.402 130.399C347.641 129.775 346.768 129.775 346.743 129.775C346.581 129.75 346.432 129.638 346.432 129.464C346.432 129.289 346.569 129.152 346.743 129.152C346.818 129.152 347.866 129.152 348.801 129.925C349.923 130.848 350.31 132.07 350.323 132.12C350.372 132.282 350.285 132.457 350.111 132.506C350.086 132.506 350.048 132.519 350.023 132.519Z"
                                        fill="#340000" />
                                    <path
                                        d="M351.482 138.941C348.34 138.941 348.14 138.592 348.053 138.455C347.878 138.168 348.016 137.744 349.687 134.564C350.136 133.716 350.547 132.918 350.722 132.506C350.796 132.344 350.971 132.269 351.133 132.344C351.295 132.406 351.37 132.593 351.295 132.756C351.108 133.192 350.684 134.003 350.235 134.851C349.637 135.985 348.764 137.657 348.627 138.155C348.938 138.243 350.31 138.317 351.47 138.317C351.644 138.317 351.782 138.455 351.782 138.629C351.782 138.804 351.644 138.941 351.47 138.941H351.482Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M351.482 138.941C348.34 138.941 348.14 138.592 348.053 138.455C347.878 138.168 348.016 137.744 349.687 134.564C350.136 133.716 350.547 132.918 350.722 132.506C350.796 132.344 350.971 132.269 351.133 132.344C351.295 132.406 351.37 132.593 351.295 132.756C351.108 133.192 350.684 134.003 350.235 134.851C349.637 135.985 348.764 137.657 348.627 138.155C348.938 138.243 350.31 138.317 351.47 138.317C351.644 138.317 351.782 138.455 351.782 138.629C351.782 138.804 351.644 138.941 351.47 138.941H351.482Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M350.123 142.657C349.674 142.657 349.375 142.632 349.325 142.632C349.15 142.62 349.026 142.47 349.038 142.296C349.051 142.121 349.2 142.009 349.375 142.009C349.412 142.009 353.827 142.383 354.924 140.101C354.999 139.951 355.186 139.876 355.336 139.951C355.485 140.026 355.56 140.213 355.485 140.363C354.5 142.395 351.545 142.657 350.111 142.657H350.123Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M350.123 142.657C349.674 142.657 349.375 142.632 349.325 142.632C349.15 142.62 349.026 142.47 349.038 142.296C349.051 142.121 349.2 142.009 349.375 142.009C349.412 142.009 353.827 142.383 354.924 140.101C354.999 139.951 355.186 139.876 355.336 139.951C355.485 140.026 355.56 140.213 355.485 140.363C354.5 142.395 351.545 142.657 350.111 142.657H350.123Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M354.662 126.932C354.563 126.845 354.725 126.882 354.775 126.857L355.036 126.832C355.211 126.82 355.398 126.82 355.585 126.82C355.959 126.82 356.346 126.882 356.72 126.969C357.468 127.157 358.192 127.506 358.815 128.029C359.451 128.528 359.913 129.164 360.249 129.838C360.561 130.524 360.773 131.234 360.748 132.033C360.748 132.22 360.586 132.357 360.399 132.357C360.312 132.357 360.237 132.319 360.174 132.257L360.149 132.232C359.152 131.234 358.441 130.199 357.618 129.414C357.194 129.027 356.72 128.678 356.184 128.379C355.922 128.229 355.635 128.092 355.336 127.955L354.874 127.743L354.625 127.63C354.513 127.568 354.5 127.593 354.251 127.418C354.114 127.306 354.101 127.107 354.213 126.982C354.326 126.845 354.525 126.832 354.65 126.945L354.662 126.932Z"
                                        fill="#340000" />
                                    <path
                                        d="M351.694 126.795C351.183 126.919 350.697 126.969 350.223 127.006C349.749 127.044 349.312 127.056 348.888 127.069C348.464 127.106 348.178 127.106 347.779 127.169C347.392 127.206 346.968 127.293 346.457 127.343H346.357C346.17 127.368 346.008 127.231 345.983 127.044C345.983 127.006 345.983 126.957 345.983 126.919C346.17 126.283 346.581 125.847 347.105 125.523C347.616 125.223 348.315 125.061 348.863 125.111C349.425 125.111 349.948 125.236 350.447 125.41C350.946 125.597 351.407 125.834 351.844 126.208C351.994 126.333 352.006 126.558 351.881 126.695C351.831 126.745 351.769 126.782 351.707 126.807H351.682L351.694 126.795Z"
                                        fill="#340000" />
                                    <path
                                        d="M279.964 358.809C279.964 358.809 279.901 358.809 279.876 358.797C279.714 358.747 279.614 358.572 279.677 358.41C282.832 348.272 285.588 344.58 288.032 341.326C290.214 338.407 292.098 335.888 293.831 329.404C293.881 329.242 294.043 329.142 294.218 329.179C294.38 329.229 294.479 329.391 294.442 329.566C292.684 336.163 290.763 338.732 288.543 341.7C286.137 344.917 283.406 348.571 280.288 358.597C280.251 358.734 280.126 358.822 279.989 358.822L279.964 358.809Z"
                                        fill="#340000" />
                                    <path
                                        d="M321.977 175.655C321.802 175.655 321.665 175.505 321.678 175.33C321.79 170.941 324.733 168.384 324.758 168.372C324.895 168.272 325.095 168.297 325.194 168.434C325.294 168.571 325.269 168.758 325.132 168.871C325.07 168.92 322.401 171.34 322.301 175.355C322.301 175.53 322.164 175.655 321.989 175.655H321.977Z"
                                        fill="#340000" />
                                    <path
                                        d="M326.529 179.57C326.392 179.57 326.254 179.471 326.229 179.333C326.192 179.171 326.292 178.997 326.454 178.959C328.474 178.473 330.407 176.49 331.554 175.305C332.29 174.545 332.602 174.245 332.889 174.208C333.051 174.196 333.213 174.308 333.238 174.482C333.263 174.644 333.151 174.794 332.988 174.819C332.839 174.881 332.402 175.33 332.016 175.729C330.819 176.964 328.811 179.022 326.616 179.558C326.591 179.558 326.566 179.558 326.541 179.558L326.529 179.57Z"
                                        fill="#340000" />
                                    <path
                                        d="M368.554 188.324C368.38 188.324 368.243 188.187 368.243 188.013C368.293 181.927 366.035 179.034 366.01 178.996C365.898 178.859 365.923 178.672 366.06 178.56C366.197 178.448 366.397 178.473 366.497 178.61C366.597 178.735 368.916 181.69 368.866 188.013C368.866 188.187 368.729 188.324 368.554 188.324Z"
                                        fill="#340000" />
                                    <path
                                        d="M370.986 188.524C370.824 188.524 370.675 188.387 370.675 188.225C370.562 184.77 372.558 180.742 372.645 180.568C372.72 180.418 372.907 180.356 373.069 180.431C373.219 180.505 373.281 180.693 373.206 180.855C373.181 180.892 371.198 184.92 371.311 188.212C371.311 188.387 371.186 188.524 371.011 188.536L370.986 188.524Z"
                                        fill="#340000" />
                                    <path
                                        d="M282.508 275.531C277.819 275.531 276.472 272.912 276.422 272.787C276.347 272.638 276.422 272.451 276.559 272.376C276.709 272.301 276.896 272.376 276.971 272.513C277.021 272.625 278.343 275.144 283.169 274.882C283.356 274.882 283.493 275.007 283.493 275.182C283.493 275.356 283.368 275.493 283.194 275.506C282.957 275.506 282.72 275.518 282.495 275.518L282.508 275.531Z"
                                        fill="#340000" />
                                    <path
                                        d="M229.421 222.157V379.111C222.1 377.714 215.478 376.305 209.742 374.958C206.126 374.11 202.559 373.213 199.042 372.265C177.805 366.541 158.513 358.934 141.291 349.556V227.257C141.291 224.439 143.573 222.157 146.392 222.157H229.408H229.421Z"
                                        fill="#DFBA9C" />
                                    <path
                                        d="M229.421 222.157V379.111C222.1 377.715 215.479 376.305 209.742 374.959C206.126 374.111 202.559 373.213 199.042 372.265V222.145H229.408L229.421 222.157Z"
                                        fill="#CDCDCD" />
                                    <path
                                        d="M145.818 222.157H298.807C301.301 222.157 303.321 224.177 303.321 226.671V227.332C303.321 229.826 301.301 231.846 298.807 231.846H141.291V226.671C141.291 224.177 143.311 222.157 145.805 222.157H145.818Z"
                                        fill="#162847" />
                                    <path
                                        d="M241.006 191.517L240.819 194.023L240.47 198.687L239.422 212.816L238.736 222.082H225.418L224.744 212.816L223.697 198.687L223.16 191.517H241.006Z"
                                        fill="white" />
                                    <path d="M240.47 198.688L239.422 212.817H224.744L223.697 198.688H240.47Z"
                                        fill="#BED9E0" />
                                    <path
                                        d="M241.006 191.517L240.819 194.023C234.87 193.262 223.16 191.517 223.16 191.517H241.006Z"
                                        fill="#340000" />
                                    <path d="M241.854 192.465H222.312L222.911 190.582H241.255L241.854 192.465Z"
                                        fill="#7A4422" />
                                    <path
                                        d="M248.139 206.881C249.757 206.881 251.069 205.569 251.069 203.95C251.069 202.332 249.757 201.02 248.139 201.02C246.52 201.02 245.208 202.332 245.208 203.95C245.208 205.569 246.52 206.881 248.139 206.881Z"
                                        fill="#FB5607" />
                                    <path
                                        d="M248.139 206.881C249.757 206.881 251.069 205.569 251.069 203.95C251.069 202.332 249.757 201.02 248.139 201.02C246.52 201.02 245.208 202.332 245.208 203.95C245.208 205.569 246.52 206.881 248.139 206.881Z"
                                        fill="#FB5607" />
                                    <path d="M267.755 219.875H237.601L235.793 205.384H269.576L267.755 219.875Z"
                                        fill="#994F12" />
                                    <path d="M270.262 208.128H235.107V214.363H270.262V208.128Z" fill="#F2745A" />
                                    <path d="M270.262 216.059H235.107V217.306H270.262V216.059Z" fill="white" />
                                    <path d="M270.262 206.993H235.107V208.24H270.262V206.993Z" fill="white" />
                                    <path
                                        d="M239.921 203.95C239.721 203.988 241.766 222.693 241.766 222.693L232.314 218.99L232.214 205.372L232.7 201.942L239.908 203.95H239.921Z"
                                        fill="#994F12" />
                                    <path d="M268.778 222.157H237.265L230.181 218.503H275.861L268.778 222.157Z"
                                        fill="#BED9E0" />
                                    <path
                                        d="M401.913 369.235C397.025 378.612 370.849 385.372 346.881 372.901C322.912 360.43 307.436 342.71 312.325 333.332C317.213 323.954 340.596 326.448 364.564 338.931C388.532 351.402 406.802 359.869 401.913 369.247V369.235Z"
                                        fill="#C6C4C2" />
                                    <path
                                        d="M400.629 314.002C377.458 332.733 380.539 362.151 380.539 379.373C380.539 379.373 414.72 375.046 437.891 356.315C461.061 337.584 473.008 317.731 462.183 304.338C451.359 290.944 423.799 295.272 400.616 313.99L400.629 314.002Z"
                                        fill="#C6C4C2" />
                                    <path
                                        d="M395.404 374.223C394.331 374.61 393.259 375.009 392.186 375.383C390.914 375.832 389.63 376.256 388.345 376.692C387.884 376.842 387.435 376.992 386.974 377.129C381.137 378.974 375.176 374.647 375.102 368.524C375.002 360.518 374.815 351.552 373.979 342.436C371.722 313.242 365.375 292.466 371.286 288.875C376.586 285.258 394.369 303.415 398.16 337.086C399.793 350.679 398.259 363.66 395.404 374.223Z"
                                        fill="#C6C4C2" />
                                    <path
                                        d="M385.165 335.664C385.165 335.664 385.078 335.664 385.041 335.639C384.879 335.577 384.804 335.39 384.879 335.228C384.916 335.128 389.143 325.226 398.995 315.574C408.086 306.658 423.961 296.145 447.98 296.594C448.154 296.594 448.291 296.744 448.291 296.906C448.291 297.08 448.117 297.205 447.98 297.218C447.468 297.218 446.957 297.205 446.458 297.205C402.05 297.205 385.627 335.078 385.465 335.465C385.415 335.589 385.303 335.652 385.178 335.652L385.165 335.664Z"
                                        fill="#340000" />
                                    <path
                                        d="M385.951 351.464C385.889 351.464 385.826 351.439 385.764 351.402C385.502 351.215 359.85 332.459 327.9 328.095C327.726 328.07 327.614 327.907 327.639 327.745C327.664 327.571 327.826 327.458 327.988 327.483C360.099 331.873 385.889 350.716 386.138 350.916C386.275 351.015 386.3 351.215 386.2 351.352C386.138 351.439 386.051 351.477 385.951 351.477V351.464Z"
                                        fill="#340000" />
                                    <path
                                        d="M217.848 145.052L218.234 145.576L218.858 145.401L218.496 144.89L217.848 145.052Z"
                                        fill="#340000" />
                                    <path
                                        d="M224.968 143.48L225.343 143.992L225.941 143.829L225.58 143.331L224.968 143.48Z"
                                        fill="#340000" />
                                    <path
                                        d="M228.934 148.756L229.321 149.279L229.919 149.105L229.533 148.581L228.934 148.756Z"
                                        fill="#340000" />
                                    <path
                                        d="M230.705 149.367L229.159 149.828L228.149 148.494L229.695 148.045L230.705 149.367ZM226.016 149.928L225.405 150.102L224.969 149.491L225.567 149.317L226.028 149.928H226.016ZM225.355 149.017L224.757 149.192L224.332 148.618L224.931 148.456L225.355 149.017ZM227.488 149.179L225.916 147.072L227.039 146.76L228.049 148.095L227.475 148.257L228.236 149.279L226.378 149.815L225.929 149.217L226.627 149.017L226.877 149.367L227.488 149.179ZM226.814 146.461L225.679 146.773L225.555 146.611L226.677 146.299L226.802 146.473L226.814 146.461ZM222.001 148.818L221.377 147.97L222.911 147.558L224.894 150.277L222.749 150.9L222.312 150.277L223.597 149.903L223.148 149.292L221.863 149.666L221.377 148.992L222.001 148.818ZM223.659 147.334L223.16 146.66L222.686 146.785L222.337 146.336L223.185 146.112L224.557 147.957L223.958 148.132L223.422 147.396L223.659 147.334ZM222.886 145.688L222.05 145.912L221.726 145.463L222.574 145.239L222.898 145.675L222.886 145.688ZM220.579 146.162L220.329 145.837L221.427 145.551L222.4 146.872L220.891 147.284L220.142 146.274L220.566 146.162H220.579ZM226.714 144.104L225.168 144.516L224.208 143.231L225.754 142.832L226.714 144.104ZM221.24 144.902L219.918 145.251L219.656 144.902L220.99 144.553L221.24 144.902ZM219.656 145.588L218.022 146.024L217.062 144.69L218.696 144.266L219.656 145.588ZM216.102 144.279L217.848 146.548L219.033 146.261L220.055 147.608L219.319 147.795L219.693 148.282L220.429 148.095L220.504 148.169L221.128 148.992L221.439 149.416L220.716 149.616L221.015 150.015L221.751 149.815L222.624 150.975L222.1 151.137L222.649 151.848L224.37 151.349L224.794 151.923L225.38 151.748L224.944 151.187L228.922 150.015L229.171 150.364L231.403 149.703L229.944 147.683L228.66 148.032L227.662 146.66L227.824 146.623L227.587 146.311L228.323 146.124L228.074 145.775L227.188 146L226.265 144.752L225.804 144.852L226.652 146L225.517 146.274L224.993 145.551L224.382 145.7L225.904 147.758L225.368 147.895L225.48 148.057L226.004 147.908L226.615 148.731L225.929 148.918L222.973 144.952L223.46 144.84L223.684 145.139L224.133 145.039L223.909 144.74L224.308 144.64L224.831 145.339L225.056 145.289L224.545 144.603L224.881 144.528L225.118 144.865L227.475 144.316L225.966 142.233L223.559 142.745L224.42 143.917L223.447 144.129L222.724 143.144L222.262 143.244L222.998 144.241L221.776 144.528L220.953 143.418L220.367 143.543L220.691 143.967L219.269 144.279L218.87 143.755L216.127 144.328L216.102 144.279Z"
                                        fill="#340000" />
                                    <path
                                        d="M226.39 150.925L226.627 151.262L227.463 151.025L227.213 150.688L226.39 150.925Z"
                                        fill="#340000" />
                                    <path
                                        d="M222.237 148.307L222.612 148.805L223.198 148.643L222.849 148.145L222.237 148.307Z"
                                        fill="#340000" />
                                    <path
                                        d="M220.99 146.324L221.34 146.81L221.689 146.71L221.34 146.236L220.99 146.324Z"
                                        fill="#340000" />
                                    <path
                                        d="M218.234 147.184L218.721 147.87L219.02 147.795L218.534 147.109L218.234 147.184Z"
                                        fill="#340000" />
                                    <path
                                        d="M228.66 146.698L229.109 147.284L229.62 147.147L229.159 146.561L228.66 146.698Z"
                                        fill="#340000" />
                                    <path
                                        d="M226.827 144.989L227.226 145.525L227.874 145.351L227.45 144.827L226.827 144.989Z"
                                        fill="#340000" />
                                    <path
                                        d="M220.903 150.925L221.701 152.035L222.013 151.961L221.202 150.826L220.903 150.925Z"
                                        fill="#340000" />
                                    <path
                                        d="M221.24 162.573C221.215 162.997 221.115 163.421 220.891 163.782C220.891 163.795 220.891 163.807 220.866 163.82C220.841 163.87 220.816 163.907 220.791 163.957C220.791 163.969 220.779 163.982 220.766 163.994C220.741 164.044 220.704 164.082 220.679 164.119C220.679 164.119 220.679 164.131 220.654 164.144C220.616 164.194 220.579 164.244 220.529 164.294C220.33 164.506 220.105 164.655 219.856 164.743C215.416 166.239 208.308 168.708 203.868 170.217C204.754 169.843 205.278 168.833 205.265 167.86C205.265 166.663 204.592 165.678 203.893 164.767C203.819 164.668 203.731 164.555 203.644 164.456C203.619 164.418 203.582 164.381 203.557 164.356C201.05 161.313 198.544 158.258 196.037 155.215C192.545 150.975 189.066 146.723 185.574 142.483C184.863 141.61 184.177 140.637 183.18 140.076C182.556 139.727 181.808 139.577 181.097 139.739C181.097 139.739 191.884 136.01 195.925 134.651C197.483 134.127 198.805 134.053 200.152 135.349C202.484 137.594 204.43 140.487 206.487 142.994C208.732 145.725 210.989 148.468 213.234 151.2C215.341 153.756 217.449 156.325 219.556 158.881C219.581 158.919 219.606 158.944 219.644 158.981C219.731 159.081 219.818 159.193 219.893 159.293C220.379 159.929 220.853 160.627 221.103 161.4C221.215 161.762 221.277 162.161 221.252 162.548L221.24 162.573Z"
                                        fill="#241E2C" />
                                    <path
                                        d="M183.678 140.4C183.978 140.624 184.427 141.098 184.701 141.435L203.544 164.356C204.978 166.089 205.789 167.623 204.866 169.294C204.093 170.691 202.696 170.529 201.374 169.519C201.05 169.269 200.726 168.97 200.414 168.633L187.744 155.315C185.936 156.811 183.354 156.799 180.935 154.965C179.351 153.768 178.042 151.997 177.767 149.665C177.431 146.747 178.391 144.241 179.102 141.859C179.788 139.577 181.87 139.016 183.666 140.387L183.678 140.4Z"
                                        fill="#162847" />
                                    <path
                                        d="M205.639 163.907L218.746 159.605L202.384 139.889L188.941 144.216L205.639 163.907Z"
                                        fill="white" />
                                    <path
                                        d="M198.406 149.491L197.82 149.703L198.232 150.276L198.805 150.064L198.406 149.491Z"
                                        fill="#340000" />
                                    <path
                                        d="M204.854 147.159L204.28 147.371L204.679 147.919L205.253 147.707L204.854 147.159Z"
                                        fill="#340000" />
                                    <path
                                        d="M209.031 152.982L208.458 153.194L208.857 153.756L209.443 153.544L209.031 152.982Z"
                                        fill="#340000" />
                                    <path
                                        d="M205.14 154.766L204.679 154.117L205.24 153.905L205.702 154.554L205.14 154.766ZM208.72 154.367L207.684 152.92L209.181 152.371L210.216 153.818L208.72 154.367ZM204.455 153.793L204.018 153.195L204.579 152.983L205.016 153.581L204.455 153.793ZM206.5 153.905L207.073 153.693L205.44 151.411L206.512 151.012L207.56 152.484L207.011 152.683L207.797 153.793L206.051 154.442L205.577 153.793L206.225 153.556L206.487 153.918L206.5 153.905ZM201.761 154.367L201.25 153.656L201.823 153.456L201.162 152.546L202.572 152.035L204.654 154.953L202.684 155.676L202.222 155.028L203.395 154.591L202.933 153.943L201.748 154.379L201.761 154.367ZM205.203 151.075L205.078 150.887L206.151 150.488L206.275 150.675L205.203 151.075ZM202.322 151.199L201.96 150.7L202.746 150.414L204.193 152.434L203.619 152.633L203.07 151.848L203.282 151.76L202.759 151.025L202.31 151.187L202.322 151.199ZM200.651 151.798L199.878 150.713L200.264 150.576L200.015 150.214L201.025 149.84L202.073 151.287L200.664 151.798H200.651ZM201.636 150.239L201.287 149.74L202.073 149.453L202.422 149.94L201.636 150.227V150.239ZM199.554 149.566L199.279 149.179L200.514 148.73L200.788 149.117L199.554 149.566ZM198.107 150.875L197.072 149.428L198.568 148.892L199.604 150.339L198.107 150.887V150.875ZM204.554 148.531L203.519 147.084L205.016 146.548L206.051 147.994L204.554 148.531ZM205.128 146.024L202.858 146.847L203.719 148.044L202.821 148.368L202.098 147.358L201.674 147.508L202.409 148.518L201.287 148.93L200.489 147.807L199.99 147.994L200.289 148.418L199.055 148.867L198.693 148.343L196.399 149.167L197.97 151.374L198.98 151.012L199.94 152.359L199.304 152.583L199.653 153.082L200.277 152.845L200.339 152.933L200.925 153.756L201.237 154.18L200.589 154.417L200.876 154.816L201.524 154.579L202.372 155.751L201.911 155.926L202.434 156.661L203.981 156.1L204.405 156.699L204.941 156.499L204.517 155.901L208.333 154.491L208.595 154.866L210.864 154.03L209.281 151.823L207.996 152.284L206.936 150.813L207.098 150.763L206.861 150.439L207.585 150.177L207.323 149.815L206.45 150.127L205.49 148.805L205.053 148.955L205.914 150.164L204.841 150.563L204.305 149.815L203.731 150.027L205.265 152.172L204.766 152.359L204.879 152.521L205.377 152.334L206.001 153.195L205.352 153.444L202.397 149.316L202.833 149.154L203.058 149.466L203.469 149.316L203.257 149.004L203.619 148.867L204.13 149.591L204.342 149.503L203.831 148.78L204.155 148.668L204.405 149.029L206.674 148.194L205.091 145.999L205.128 146.024Z"
                                        fill="#340000" />
                                    <path
                                        d="M206.899 155.339L206.126 155.639L206.375 156L207.148 155.701L206.899 155.339Z"
                                        fill="#340000" />
                                    <path
                                        d="M202.559 152.696L202.01 152.895L202.397 153.432L202.946 153.232L202.559 152.696Z"
                                        fill="#340000" />
                                    <path
                                        d="M200.975 150.638L200.664 150.738L201.025 151.274L201.349 151.149L200.975 150.638Z"
                                        fill="#340000" />
                                    <path
                                        d="M198.431 151.698L198.157 151.798L198.668 152.521L198.943 152.422L198.431 151.698Z"
                                        fill="#340000" />
                                    <path
                                        d="M208.582 150.713L208.096 150.9L208.557 151.548L209.056 151.374L208.582 150.713Z"
                                        fill="#340000" />
                                    <path
                                        d="M206.811 148.805L206.2 149.029L206.624 149.628L207.248 149.403L206.811 148.805Z"
                                        fill="#340000" />
                                    <path
                                        d="M201.25 155.651L200.975 155.739L201.811 156.911L202.073 156.824L201.25 155.651Z"
                                        fill="#340000" />
                                    <path
                                        d="M163.264 152.522C165.235 151.798 167.467 150.938 169.512 150.003C171.582 149.055 173.64 148.07 175.623 146.935C177.593 145.8 179.576 144.653 181.471 143.343C182.456 142.745 183.379 142.046 184.364 141.398C185.35 140.749 186.26 140.026 187.295 139.403L187.445 139.315C188.343 138.779 189.502 139.078 190.039 139.976C190.425 140.625 190.375 141.41 189.989 141.997C188.567 144.129 186.883 146.112 184.963 147.808C183.068 149.566 180.935 151.038 178.703 152.347C176.458 153.644 174.076 154.704 171.607 155.502C169.1 156.288 166.656 156.849 163.825 156.899C162.603 156.924 161.593 155.939 161.568 154.716C161.556 153.744 162.154 152.908 163.027 152.597L163.277 152.509L163.264 152.522Z"
                                        fill="#F29C8A" />
                                </svg>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Tab Pan -->
                @endif
                @if( isset($delivery_platform))
                <!-- Tab Pan -->
                <div class="tab-pane fade show" id="earn-delivery">
                    <div class="row gy-5 align-items-center flex-wrap-reverse">
                        <div class="col-lg-7">
                            <div class="platform-content">
                                @php($platform_delivery_datas = \App\Models\BusinessSetting::where(['key'=>'platform_delivery_data'])->first())
                                @php($platform_delivery_datas = isset($platform_delivery_datas->value)?json_decode($platform_delivery_datas->value, true):[])
                                @foreach($platform_delivery_datas as  $platform_delivery_data)
                                <h4 class="subtitle">{{$platform_delivery_data['title']}}</h4>
                                <p>
                                    {{$platform_delivery_data['detail']}}
                                </p>
                                @endforeach
                                @if($delivery_platform['url_status'] ==1 )
                                <a href="{{$delivery_platform['url']}}" class="btn-base btn-sm">
                                    <span>{{ translate('messages.Download_now') }}</span>
                                    <svg width="14" height="15" viewBox="0 0 14 15" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M0.875 7.50006C0.875 7.38403 0.921094 7.27275 1.00314 7.19071C1.08519 7.10866 1.19647 7.06256 1.3125 7.06256H11.6314L8.87775 4.30981C8.7956 4.22766 8.74945 4.11624 8.74945 4.00006C8.74945 3.88389 8.7956 3.77247 8.87775 3.69031C8.9599 3.60816 9.07132 3.56201 9.1875 3.56201C9.30368 3.56201 9.4151 3.60816 9.49725 3.69031L12.9972 7.19031C13.038 7.23095 13.0703 7.27923 13.0924 7.33239C13.1144 7.38554 13.1258 7.44252 13.1258 7.50006C13.1258 7.55761 13.1144 7.61459 13.0924 7.66774C13.0703 7.7209 13.038 7.76917 12.9972 7.80981L9.49725 11.3098C9.4151 11.392 9.30368 11.4381 9.1875 11.4381C9.07132 11.4381 8.9599 11.392 8.87775 11.3098C8.7956 11.2277 8.74945 11.1162 8.74945 11.0001C8.74945 10.8839 8.7956 10.7725 8.87775 10.6903L11.6314 7.93756H1.3125C1.19647 7.93756 1.08519 7.89147 1.00314 7.80942C0.921094 7.72738 0.875 7.6161 0.875 7.50006Z"
                                            fill="white" />
                                    </svg>
                                </a>
                                @endif
                            </div>
                        </div>
                        <div class="col-lg-5">
                            <div class="platform-img">
                                <svg width="501" height="411" viewBox="0 0 501 411" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0_3_4027)">
                                        <g clip-path="url(#clip1_3_4027)">
                                            <path d="M42.7558 256.805H117.439V199.139H42.7558V256.805Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M61.4714 256.396C61.5717 256.396 61.6578 243.539 61.6578 227.688C61.6578 211.838 61.5717 198.98 61.4714 198.98C61.371 198.98 61.2849 211.83 61.2849 227.688C61.2849 243.546 61.371 256.396 61.4714 256.396Z"
                                                fill="#EBEBEB" />
                                            <path d="M49.0947 250.165H54.8169V243.682H49.0947V250.165Z"
                                                fill="#FAFAFA" />
                                            <path d="M94.6574 199.282H86.1744V211.586H94.6574V199.282Z"
                                                fill="#EBEBEB" />
                                            <path d="M94.6574 244.329H86.1744V256.633H94.6574V244.329Z"
                                                fill="#EBEBEB" />
                                            <path d="M145.906 257.617H22.6132V352.814H145.906V257.617Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M115.015 352.146C114.879 352.146 114.771 330.926 114.771 304.759C114.771 278.593 114.879 257.365 115.015 257.365C115.151 257.365 115.259 278.578 115.259 304.759C115.259 330.94 115.151 352.146 115.015 352.146Z"
                                                fill="#E0E0E0" />
                                            <path d="M135.444 331.148H125.993V341.844H135.444V331.148Z"
                                                fill="#FAFAFA" />
                                            <path d="M74.2279 257.86H60.2235V278.176H74.2279V257.86Z" fill="#E0E0E0" />
                                            <path d="M74.2279 332.218H60.2235V352.534H74.2279V332.218Z"
                                                fill="#E0E0E0" />
                                            <path
                                                d="M242.231 89.9215C242.231 90.022 241.427 90.1082 240.438 90.1082C239.448 90.1082 238.645 90.022 238.645 89.9215C238.645 89.821 239.448 89.7349 240.438 89.7349C241.427 89.7349 242.231 89.821 242.231 89.9215Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M249.401 89.9215C249.401 90.022 248.598 90.1082 247.609 90.1082C246.619 90.1082 245.816 90.022 245.816 89.9215C245.816 89.821 246.619 89.7349 247.609 89.7349C248.598 89.7349 249.401 89.821 249.401 89.9215Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M256.572 89.9215C256.572 90.022 255.769 90.1082 254.779 90.1082C253.79 90.1082 252.987 90.022 252.987 89.9215C252.987 89.821 253.79 89.7349 254.779 89.7349C255.769 89.7349 256.572 89.821 256.572 89.9215Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M263.743 89.9215C263.743 90.022 262.94 90.1082 261.95 90.1082C260.961 90.1082 260.157 90.022 260.157 89.9215C260.157 89.821 260.961 89.7349 261.95 89.7349C262.94 89.7349 263.743 89.821 263.743 89.9215Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M270.913 89.9215C270.913 90.022 270.11 90.1082 269.121 90.1082C268.131 90.1082 267.328 90.022 267.328 89.9215C267.328 89.821 268.131 89.7349 269.121 89.7349C270.11 89.7349 270.913 89.821 270.913 89.9215Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M278.084 89.9215C278.084 90.022 277.281 90.1082 276.291 90.1082C275.302 90.1082 274.499 90.022 274.499 89.9215C274.499 89.821 275.302 89.7349 276.291 89.7349C277.281 89.7349 278.084 89.821 278.084 89.9215Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M285.255 89.9215C285.255 90.022 284.452 90.1082 283.462 90.1082C282.473 90.1082 281.669 90.022 281.669 89.9215C281.669 89.821 282.473 89.7349 283.462 89.7349C284.452 89.7349 285.255 89.821 285.255 89.9215Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M292.426 89.9215C292.426 90.022 291.623 90.1082 290.633 90.1082C289.643 90.1082 288.84 90.022 288.84 89.9215C288.84 89.821 289.643 89.7349 290.633 89.7349C291.623 89.7349 292.426 89.821 292.426 89.9215Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M299.596 89.9215C299.596 90.022 298.793 90.1082 297.804 90.1082C296.814 90.1082 296.011 90.022 296.011 89.9215C296.011 89.821 296.814 89.7349 297.804 89.7349C298.793 89.7349 299.596 89.821 299.596 89.9215Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M306.767 89.9215C306.767 90.022 305.964 90.1082 304.974 90.1082C303.985 90.1082 303.182 90.022 303.182 89.9215C303.182 89.821 303.985 89.7349 304.974 89.7349C305.964 89.7349 306.767 89.821 306.767 89.9215Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M313.938 89.9215C313.938 90.022 313.135 90.1082 312.145 90.1082C311.155 90.1082 310.352 90.022 310.352 89.9215C310.352 89.821 311.155 89.7349 312.145 89.7349C313.135 89.7349 313.938 89.821 313.938 89.9215Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M321.109 89.9215C321.109 90.022 320.305 90.1082 319.316 90.1082C318.326 90.1082 317.523 90.022 317.523 89.9215C317.523 89.821 318.326 89.7349 319.316 89.7349C320.305 89.7349 321.109 89.821 321.109 89.9215Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M328.279 89.9215C328.279 90.022 327.476 90.1082 326.487 90.1082C325.497 90.1082 324.694 90.022 324.694 89.9215C324.694 89.821 325.497 89.7349 326.487 89.7349C327.476 89.7349 328.279 89.821 328.279 89.9215Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M335.45 89.9215C335.45 90.022 334.647 90.1082 333.657 90.1082C332.668 90.1082 331.865 90.022 331.865 89.9215C331.865 89.821 332.668 89.7349 333.657 89.7349C334.647 89.7349 335.45 89.821 335.45 89.9215Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M342.621 89.9215C342.621 90.022 341.817 90.1082 340.828 90.1082C339.838 90.1082 339.035 90.022 339.035 89.9215C339.035 89.821 339.838 89.7349 340.828 89.7349C341.817 89.7349 342.621 89.821 342.621 89.9215Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M349.791 89.9215C349.791 90.022 348.988 90.1082 347.999 90.1082C347.009 90.1082 346.206 90.022 346.206 89.9215C346.206 89.821 347.009 89.7349 347.999 89.7349C348.988 89.7349 349.791 89.821 349.791 89.9215Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M356.962 89.9215C356.962 90.022 356.159 90.1082 355.169 90.1082C354.18 90.1082 353.377 90.022 353.377 89.9215C353.377 89.821 354.18 89.7349 355.169 89.7349C356.159 89.7349 356.962 89.821 356.962 89.9215Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M364.133 89.9215C364.133 90.022 363.33 90.1082 362.34 90.1082C361.35 90.1082 360.547 90.022 360.547 89.9215C360.547 89.821 361.35 89.7349 362.34 89.7349C363.33 89.7349 364.133 89.821 364.133 89.9215Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M371.303 89.9215C371.303 90.022 370.5 90.1082 369.511 90.1082C368.521 90.1082 367.718 90.022 367.718 89.9215C367.718 89.821 368.521 89.7349 369.511 89.7349C370.5 89.7349 371.303 89.821 371.303 89.9215Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M378.474 89.9215C378.474 90.022 377.671 90.1082 376.681 90.1082C375.692 90.1082 374.889 90.022 374.889 89.9215C374.889 89.821 375.692 89.7349 376.681 89.7349C377.671 89.7349 378.474 89.821 378.474 89.9215Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M385.645 89.9215C385.645 90.022 384.842 90.1082 383.852 90.1082C382.863 90.1082 382.06 90.022 382.06 89.9215C382.06 89.821 382.863 89.7349 383.852 89.7349C384.842 89.7349 385.645 89.821 385.645 89.9215Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M392.816 89.9215C392.816 90.022 392.012 90.1082 391.023 90.1082C390.033 90.1082 389.23 90.022 389.23 89.9215C389.23 89.821 390.033 89.7349 391.023 89.7349C392.012 89.7349 392.816 89.821 392.816 89.9215Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M399.986 89.9215C399.986 90.022 399.183 90.1082 398.194 90.1082C397.204 90.1082 396.401 90.022 396.401 89.9215C396.401 89.821 397.204 89.7349 398.194 89.7349C399.183 89.7349 399.986 89.821 399.986 89.9215Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M401.822 95.2554C401.722 95.2554 401.635 94.4514 401.635 93.4607C401.635 92.47 401.722 91.666 401.822 91.666C401.922 91.666 402.008 92.47 402.008 93.4607C402.008 94.4514 401.922 95.2554 401.822 95.2554Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M401.822 102.434C401.722 102.434 401.635 101.63 401.635 100.639C401.635 99.6487 401.722 98.8447 401.822 98.8447C401.922 98.8447 402.008 99.6487 402.008 100.639C402.008 101.63 401.922 102.434 401.822 102.434Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M401.822 109.613C401.722 109.613 401.635 108.809 401.635 107.818C401.635 106.827 401.722 106.023 401.822 106.023C401.922 106.023 402.008 106.827 402.008 107.818C402.008 108.809 401.922 109.613 401.822 109.613Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M401.822 116.792C401.722 116.792 401.635 115.987 401.635 114.997C401.635 114.006 401.722 113.202 401.822 113.202C401.922 113.202 402.008 114.006 402.008 114.997C402.008 115.987 401.922 116.792 401.822 116.792Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M401.822 123.97C401.722 123.97 401.635 123.166 401.635 122.176C401.635 121.185 401.722 120.381 401.822 120.381C401.922 120.381 402.008 121.185 402.008 122.176C402.008 123.166 401.922 123.97 401.822 123.97Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M403.22 129.749C403.22 129.835 402.625 129.914 401.822 129.929H401.643V129.749C401.643 129.613 401.643 129.483 401.643 129.354C401.643 128.364 401.729 127.56 401.829 127.56C401.929 127.56 402.015 128.364 402.015 129.354C402.015 129.483 402.015 129.613 402.015 129.749L401.836 129.57C402.639 129.591 403.234 129.663 403.234 129.749H403.22Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M410.391 129.749C410.391 129.85 409.588 129.936 408.598 129.936C407.609 129.936 406.806 129.85 406.806 129.749C406.806 129.649 407.609 129.562 408.598 129.562C409.588 129.562 410.391 129.649 410.391 129.749Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M417.562 129.749C417.562 129.85 416.759 129.936 415.769 129.936C414.779 129.936 413.976 129.85 413.976 129.749C413.976 129.649 414.779 129.562 415.769 129.562C416.759 129.562 417.562 129.649 417.562 129.749Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M424.732 129.749C424.732 129.85 423.929 129.936 422.94 129.936C421.95 129.936 421.147 129.85 421.147 129.749C421.147 129.649 421.95 129.562 422.94 129.562C423.929 129.562 424.732 129.649 424.732 129.749Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M431.903 129.749C431.903 129.85 431.1 129.936 430.111 129.936C429.121 129.936 428.318 129.85 428.318 129.749C428.318 129.649 429.121 129.562 430.111 129.562C431.1 129.562 431.903 129.649 431.903 129.749Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M439.074 129.749C439.074 129.85 438.271 129.936 437.281 129.936C436.292 129.936 435.489 129.85 435.489 129.749C435.489 129.649 436.292 129.562 437.281 129.562C438.271 129.562 439.074 129.649 439.074 129.749Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M446.245 129.749C446.245 129.85 445.441 129.936 444.452 129.936C443.462 129.936 442.659 129.85 442.659 129.749C442.659 129.649 443.462 129.562 444.452 129.562C445.441 129.562 446.245 129.649 446.245 129.749Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M453.415 129.749C453.415 129.85 452.612 129.936 451.623 129.936C450.633 129.936 449.83 129.85 449.83 129.749C449.83 129.649 450.633 129.562 451.623 129.562C452.612 129.562 453.415 129.649 453.415 129.749Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M460.586 129.749C460.586 129.85 459.783 129.936 458.793 129.936C457.804 129.936 457 129.85 457 129.749C457 129.649 457.804 129.562 458.793 129.562C459.783 129.562 460.586 129.649 460.586 129.749Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M463.375 134.143C463.275 134.143 463.189 133.339 463.189 132.348C463.189 131.357 463.275 130.553 463.375 130.553C463.476 130.553 463.562 131.357 463.562 132.348C463.562 133.339 463.476 134.143 463.375 134.143Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M463.375 141.321C463.275 141.321 463.189 140.517 463.189 139.527C463.189 138.536 463.275 137.732 463.375 137.732C463.476 137.732 463.562 138.536 463.562 139.527C463.562 140.517 463.476 141.321 463.375 141.321Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M463.375 148.5C463.275 148.5 463.189 147.696 463.189 146.705C463.189 145.715 463.275 144.911 463.375 144.911C463.476 144.911 463.562 145.715 463.562 146.705C463.562 147.696 463.476 148.5 463.375 148.5Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M463.375 155.679C463.275 155.679 463.189 154.875 463.189 153.884C463.189 152.893 463.275 152.089 463.375 152.089C463.476 152.089 463.562 152.893 463.562 153.884C463.562 154.875 463.476 155.679 463.375 155.679Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M463.375 162.857C463.275 162.857 463.189 162.053 463.189 161.063C463.189 160.072 463.275 159.268 463.375 159.268C463.476 159.268 463.562 160.072 463.562 161.063C463.562 162.053 463.476 162.857 463.375 162.857Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M463.375 170.036C463.275 170.036 463.189 169.232 463.189 168.241C463.189 167.251 463.275 166.447 463.375 166.447C463.476 166.447 463.562 167.251 463.562 168.241C463.562 169.232 463.476 170.036 463.375 170.036Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M463.375 177.215C463.275 177.215 463.189 176.411 463.189 175.42C463.189 174.43 463.275 173.625 463.375 173.625C463.476 173.625 463.562 174.43 463.562 175.42C463.562 176.411 463.476 177.215 463.375 177.215Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M463.375 184.394C463.275 184.394 463.189 183.59 463.189 182.599C463.189 181.608 463.275 180.804 463.375 180.804C463.476 180.804 463.562 181.608 463.562 182.599C463.562 183.59 463.476 184.394 463.375 184.394Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M463.375 191.572C463.275 191.572 463.189 190.768 463.189 189.778C463.189 188.787 463.275 187.983 463.375 187.983C463.476 187.983 463.562 188.787 463.562 189.778C463.562 190.768 463.476 191.572 463.375 191.572Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M463.375 198.751C463.275 198.751 463.189 197.947 463.189 196.956C463.189 195.966 463.275 195.162 463.375 195.162C463.476 195.162 463.562 195.966 463.562 196.956C463.562 197.947 463.476 198.751 463.375 198.751Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M463.375 205.93C463.275 205.93 463.189 205.126 463.189 204.135C463.189 203.144 463.275 202.34 463.375 202.34C463.476 202.34 463.562 203.144 463.562 204.135C463.562 205.126 463.476 205.93 463.375 205.93Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M279.855 102.169C279.855 102.169 274.291 99.0817 268.834 112.262C263.377 125.442 261.505 132.937 261.505 132.937C261.505 132.937 260.007 135.722 258.049 134.135C256.092 132.542 253.209 127.818 250.183 128.945C247.042 130.115 246.268 133.791 247.293 139.01C248.318 144.236 250.147 155.758 250.312 156.806C250.47 157.832 250.004 159.39 248.491 158.522C246.985 157.653 238.036 149.125 234.25 153.618C230.463 158.112 235.712 172.19 236.257 173.74C236.802 175.291 236.544 175.995 235.827 176.44C235.11 176.892 232.371 173.74 229.725 171.422C227.079 169.103 223.608 166.878 221.643 169.649C219.679 172.427 219.829 183.288 231.482 200.036L237.39 207.444L246.813 206.174C266.819 202.226 274.463 194.516 274.972 191.149C275.481 187.782 271.437 186.971 267.93 186.806C264.417 186.641 260.265 186.999 260.057 186.174C259.849 185.348 260.15 184.666 261.62 183.927C263.09 183.188 276.628 176.705 277.023 170.84C277.417 164.975 265.062 164.889 263.377 164.465C261.692 164.042 262.438 162.592 263.262 161.967C264.101 161.328 273.416 154.308 277.776 151.264C282.136 148.22 284.129 145.04 282.681 142.01C281.289 139.096 275.933 140.489 273.423 140.273C270.913 140.058 271.767 137.014 271.767 137.014C271.767 137.014 275.625 130.316 280.838 117.043C286.051 103.769 279.748 102.111 279.748 102.111"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M237.713 205.485C241.578 195.75 247.035 182.348 253.108 167.56C259.182 152.779 264.668 139.39 268.59 129.677C270.54 124.832 272.125 120.905 273.222 118.17C273.767 116.82 274.19 115.772 274.484 115.04C274.628 114.695 274.742 114.423 274.821 114.229C274.9 114.049 274.943 113.956 274.943 113.956C274.943 113.956 274.915 114.057 274.85 114.243C274.778 114.444 274.678 114.717 274.542 115.069C274.262 115.801 273.853 116.863 273.337 118.22C272.283 120.955 270.734 124.896 268.798 129.764C264.933 139.498 259.476 152.901 253.402 167.682C247.329 182.47 241.836 195.858 237.921 205.571"
                                                fill="#E0E0E0" />
                                            <path
                                                d="M253.955 135.722C253.955 135.722 254.077 135.937 254.249 136.339C254.421 136.749 254.65 137.337 254.923 138.077C255.468 139.555 256.178 141.609 256.909 143.899C257.619 146.153 258.264 148.184 258.759 149.756C258.981 150.453 259.175 151.041 259.326 151.53C259.462 151.946 259.526 152.183 259.505 152.19C259.483 152.197 259.376 151.975 259.204 151.573C259.032 151.163 258.802 150.568 258.537 149.828C257.999 148.349 257.325 146.282 256.594 143.992C255.869 141.745 255.21 139.721 254.7 138.148C254.471 137.452 254.277 136.863 254.12 136.375C253.983 135.959 253.926 135.722 253.948 135.715L253.955 135.722Z"
                                                fill="#E0E0E0" />
                                            <path
                                                d="M260.394 152.297C260.365 152.211 264.539 150.567 269.716 148.629C274.9 146.684 279.124 145.183 279.153 145.262C279.181 145.348 275.008 146.992 269.831 148.931C264.653 150.876 260.423 152.376 260.394 152.297Z"
                                                fill="#E0E0E0" />
                                            <path
                                                d="M250.04 174.58C250.04 174.58 250.283 174.523 250.735 174.487C251.251 174.444 251.882 174.401 252.628 174.343C254.227 174.221 256.436 174.035 258.86 173.755C261.29 173.475 263.477 173.144 265.062 172.893C265.801 172.778 266.425 172.678 266.941 172.599C267.386 172.534 267.629 172.506 267.636 172.527C267.636 172.549 267.4 172.62 266.962 172.721C266.525 172.821 265.887 172.965 265.098 173.116C263.52 173.424 261.326 173.791 258.895 174.071C256.457 174.358 254.242 174.501 252.635 174.566C251.832 174.595 251.18 174.616 250.735 174.609C250.283 174.609 250.04 174.595 250.04 174.573V174.58Z"
                                                fill="#E0E0E0" />
                                            <path
                                                d="M240.918 160.869C240.918 160.869 241.083 161.034 241.334 161.364C241.585 161.695 241.937 162.183 242.367 162.786C243.227 163.992 244.403 165.679 245.68 167.545C246.956 169.412 248.103 171.12 248.914 172.362C249.322 172.98 249.645 173.489 249.86 173.841C250.075 174.193 250.19 174.394 250.169 174.408C250.147 174.423 250.004 174.243 249.753 173.913C249.502 173.583 249.15 173.094 248.72 172.491C247.86 171.285 246.684 169.598 245.407 167.732C244.131 165.866 242.984 164.164 242.173 162.922C241.764 162.305 241.442 161.795 241.227 161.443C241.012 161.092 240.897 160.891 240.918 160.876V160.869Z"
                                                fill="#E0E0E0" />
                                            <path
                                                d="M229.287 179.375C229.287 179.375 229.488 179.591 229.811 180.014C230.162 180.495 230.607 181.106 231.145 181.831C232.256 183.374 233.776 185.52 235.44 187.897C237.103 190.28 238.588 192.441 239.656 194.02C240.158 194.774 240.574 195.398 240.904 195.894C241.191 196.339 241.341 196.597 241.327 196.604C241.305 196.619 241.126 196.389 240.803 195.966C240.452 195.485 240.008 194.874 239.47 194.149C238.358 192.606 236.838 190.459 235.174 188.083C233.511 185.707 232.027 183.539 230.958 181.96C230.456 181.206 230.04 180.582 229.71 180.086C229.424 179.641 229.273 179.383 229.287 179.375Z"
                                                fill="#E0E0E0" />
                                            <path
                                                d="M241.148 196.124C241.148 196.124 241.456 196.052 242.023 195.987C242.646 195.916 243.457 195.822 244.418 195.715C246.44 195.485 249.229 195.155 252.305 194.71C255.382 194.265 258.15 193.798 260.15 193.439C261.104 193.274 261.9 193.13 262.524 193.023C263.083 192.929 263.399 192.886 263.406 192.908C263.406 192.929 263.105 193.015 262.552 193.145C262 193.281 261.197 193.461 260.193 193.662C258.2 194.071 255.425 194.58 252.348 195.026C249.272 195.471 246.468 195.765 244.439 195.937C243.421 196.023 242.603 196.081 242.03 196.109C241.463 196.138 241.148 196.145 241.141 196.124H241.148Z"
                                                fill="#E0E0E0" />
                                            <path
                                                d="M488.566 223.496C488.566 207.968 474.547 195.714 458.485 198.729C448.381 200.624 440.336 208.887 438.565 219.024C437.46 225.362 438.765 231.321 441.648 236.238H441.634L441.705 236.331C442.673 237.961 443.885 239.124 445.104 240.84L459.733 260.237C461.554 262.649 465.175 262.649 466.996 260.237L481.381 241.156C481.381 241.156 484.063 237.947 485.038 236.303L485.088 236.231H485.081C487.275 232.491 488.559 228.141 488.559 223.489L488.566 223.496ZM463.368 234.479C457.244 234.479 452.282 229.512 452.282 223.381C452.282 217.25 457.244 212.283 463.368 212.283C469.492 212.283 474.454 217.25 474.454 223.381C474.454 229.512 469.492 234.479 463.368 234.479Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M369.611 111.343V141.005C369.611 141.644 370.127 142.161 370.766 142.161H432.893C433.538 142.161 434.054 141.637 434.047 140.991L433.904 130.129C433.904 129.885 433.818 129.649 433.674 129.455L424.761 117.531C424.546 117.244 424.209 117.071 423.843 117.064L413.575 116.985C412.944 116.985 412.427 116.461 412.427 115.829V111.343C412.427 110.704 411.911 110.187 411.273 110.187H370.758C370.12 110.187 369.604 110.704 369.604 111.343H369.611Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M415.324 119.569V129.088C415.324 129.462 415.626 129.756 415.999 129.749L429.716 129.505C430.24 129.498 430.548 128.909 430.254 128.471L423.843 119.002C423.714 118.816 423.506 118.708 423.277 118.715L415.977 118.909C415.618 118.916 415.332 119.211 415.332 119.569H415.324Z"
                                                fill="#EBEBEB" />
                                            <path d="M435.28 143.065H368.356V145.133H435.28V143.065Z" fill="#F5F5F5" />
                                            <path
                                                d="M388.552 148.539C391.137 145.951 391.137 141.756 388.552 139.168C385.968 136.581 381.777 136.581 379.192 139.168C376.608 141.756 376.608 145.951 379.192 148.539C381.777 151.126 385.968 151.126 388.552 148.539Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M387.767 143.855C387.767 146.009 386.025 147.753 383.874 147.753C381.722 147.753 379.98 146.009 379.98 143.855C379.98 141.701 381.722 139.957 383.874 139.957C386.025 139.957 387.767 141.701 387.767 143.855Z"
                                                fill="#FAFAFA" />
                                            <path
                                                d="M412.384 142.161C412.219 142.161 412.083 135.004 412.083 126.174C412.083 117.344 412.219 110.187 412.384 110.187C412.549 110.187 412.686 117.344 412.686 126.174C412.686 135.004 412.549 142.161 412.384 142.161Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M424.619 148.541C427.204 145.953 427.204 141.758 424.619 139.17C422.034 136.583 417.844 136.583 415.259 139.17C412.674 141.758 412.674 145.953 415.259 148.541C417.844 151.128 422.035 151.128 424.619 148.541Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M423.843 143.856C423.843 146.009 422.101 147.754 419.949 147.754C417.798 147.754 416.056 146.009 416.056 143.856C416.056 141.702 417.798 139.958 419.949 139.958C422.101 139.958 423.843 141.702 423.843 143.856Z"
                                                fill="#FAFAFA" />
                                            <path
                                                d="M419.964 131.63C419.964 131.795 419.017 131.931 417.849 131.931C416.68 131.931 415.733 131.795 415.733 131.63C415.733 131.465 416.68 131.328 417.849 131.328C419.017 131.328 419.964 131.465 419.964 131.63Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M501 352.814C501 352.914 388.613 353 250.011 353C111.408 353 -1 352.914 -1 352.814C-1 352.713 111.365 352.627 250.011 352.627C388.656 352.627 501 352.713 501 352.814Z"
                                                fill="#263238" />
                                            <path
                                                d="M99.2466 349.655C108.906 342.95 111.136 330.444 110.799 319.195C110.741 317.314 110.956 315.34 110.067 313.689C109.178 312.038 107.106 310.904 105.421 311.694C104.022 312.347 103.413 313.962 102.631 315.304C101.591 317.085 100.035 318.556 98.2212 319.497C97.0237 320.114 95.5465 320.487 94.3705 319.834C92.7571 318.937 92.5707 316.697 92.5922 314.831C92.628 311.349 92.6567 307.867 92.6926 304.393C92.7141 302.526 92.7212 300.617 92.1476 298.844C91.5739 297.071 90.2975 295.419 88.5264 294.917C86.7552 294.414 84.5538 295.427 84.1738 297.257C84.016 298.018 84.1738 298.808 84.1092 299.583C84.0519 300.358 83.6933 301.213 82.9547 301.428C82.209 301.643 81.4632 301.112 80.9111 300.567C78.9893 298.671 77.6914 296.238 76.4796 293.819C75.2677 291.399 74.0917 288.923 72.3493 286.862C70.6068 284.802 68.1974 283.158 65.5299 283C62.8552 282.842 60.0085 284.479 59.3201 287.106C58.6317 289.734 60.159 292.412 61.8227 294.551C64.2894 297.724 67.2079 300.531 70.4634 302.857C71.0514 303.273 71.6824 303.732 71.9047 304.422C72.3062 305.671 71.1231 306.898 69.8969 307.307C68.5058 307.767 66.9999 307.616 65.5443 307.781C64.0886 307.946 62.511 308.585 61.9589 309.956C61.1916 311.866 62.7764 313.869 64.3396 315.182C67.4732 317.817 71.0514 319.906 74.8733 321.32C76.243 321.83 77.6843 322.275 78.7886 323.244C79.8928 324.213 80.5526 325.893 79.8785 327.207C79.2045 328.52 77.4907 328.937 76.0493 328.664C74.6152 328.391 73.3316 327.609 71.962 327.085C69.4021 326.108 66.0892 326.274 64.44 328.485C63.3572 329.942 63.2568 331.966 63.7946 333.711C64.3324 335.448 65.4367 336.948 66.6055 338.334C70.7 343.172 75.9418 347.077 81.8863 349.159C87.8237 351.241 93.3308 351.823 99.2538 349.676"
                                                fill="#FB5607" />
                                            <path
                                                d="M99.2466 349.655C108.906 342.95 111.136 330.444 110.799 319.195C110.741 317.314 110.956 315.34 110.067 313.689C109.178 312.038 107.106 310.904 105.421 311.694C104.022 312.347 103.413 313.962 102.631 315.304C101.591 317.085 100.035 318.556 98.2212 319.497C97.0237 320.114 95.5465 320.487 94.3705 319.834C92.7571 318.937 92.5707 316.697 92.5922 314.831C92.628 311.349 92.6567 307.867 92.6926 304.393C92.7141 302.526 92.7212 300.617 92.1476 298.844C91.5739 297.071 90.2975 295.419 88.5264 294.917C86.7552 294.414 84.5538 295.427 84.1738 297.257C84.016 298.018 84.1738 298.808 84.1092 299.583C84.0519 300.358 83.6933 301.213 82.9547 301.428C82.209 301.643 81.4632 301.112 80.9111 300.567C78.9893 298.671 77.6914 296.238 76.4796 293.819C75.2677 291.399 74.0917 288.923 72.3493 286.862C70.6068 284.802 68.1974 283.158 65.5299 283C62.8552 282.842 60.0085 284.479 59.3201 287.106C58.6317 289.734 60.159 292.412 61.8227 294.551C64.2894 297.724 67.2079 300.531 70.4634 302.857C71.0514 303.273 71.6824 303.732 71.9047 304.422C72.3062 305.671 71.1231 306.898 69.8969 307.307C68.5058 307.767 66.9999 307.616 65.5443 307.781C64.0886 307.946 62.511 308.585 61.9589 309.956C61.1916 311.866 62.7764 313.869 64.3396 315.182C67.4732 317.817 71.0514 319.906 74.8733 321.32C76.243 321.83 77.6843 322.275 78.7886 323.244C79.8928 324.213 80.5526 325.893 79.8785 327.207C79.2045 328.52 77.4907 328.937 76.0493 328.664C74.6152 328.391 73.3316 327.609 71.962 327.085C69.4021 326.108 66.0892 326.274 64.44 328.485C63.3572 329.942 63.2568 331.966 63.7946 333.711C64.3324 335.448 65.4367 336.948 66.6055 338.334C70.7 343.172 75.9418 347.077 81.8863 349.159C87.8237 351.241 93.3308 351.823 99.2538 349.676"
                                                fill="#FB5607" />
                                            <path
                                                d="M98.6084 352.821C98.214 348.363 98.0132 348.269 96.3711 342.591C94.7362 336.905 92.4273 330.832 89.8028 324.551C89.1359 322.986 88.4834 321.435 87.838 319.913C87.1926 318.391 86.5473 316.884 85.823 315.448C84.3961 312.57 82.8042 309.906 81.2123 307.43C79.6204 304.953 78.0213 302.656 76.5154 300.524C75.0024 298.392 73.5468 296.432 72.1485 294.702C69.3591 291.227 66.792 288.7 64.9491 287.035C64.0312 286.202 63.2998 285.578 62.7979 285.154C62.5541 284.953 62.3676 284.802 62.2242 284.68C62.0951 284.573 62.0234 284.522 62.0234 284.529C62.0234 284.529 62.0808 284.594 62.2027 284.709C62.3389 284.831 62.5254 284.996 62.7549 285.204C63.2425 285.635 63.9595 286.281 64.863 287.128C66.6701 288.822 69.2085 291.371 71.962 294.852C73.346 296.59 74.7801 298.549 76.2788 300.689C77.7775 302.828 79.3694 305.125 80.9469 307.602C82.5245 310.079 84.1021 312.735 85.5219 315.599C86.2389 317.028 86.8699 318.528 87.5225 320.05C88.1678 321.572 88.8204 323.122 89.4873 324.687C92.1189 330.961 94.4279 337.02 96.07 342.677C97.7264 348.334 97.9487 348.399 98.3646 352.835"
                                                fill="#263238" />
                                            <path
                                                d="M85.7226 315.434C85.7226 315.434 85.8087 315.154 85.9091 314.637C86.0095 314.12 86.1314 313.374 86.2604 312.44C86.5329 310.581 86.8198 308.004 87.1209 305.161C87.4221 302.311 87.7448 299.748 88.046 297.896C88.1894 296.97 88.3184 296.224 88.4117 295.707C88.5049 295.19 88.5407 294.903 88.5192 294.896C88.4977 294.896 88.4117 295.168 88.2826 295.678C88.1463 296.188 87.9886 296.927 87.8093 297.853C87.4508 299.698 87.0851 302.275 86.7839 305.118C86.4899 307.925 86.2246 310.466 86.0238 312.404C85.9234 313.28 85.8445 314.02 85.78 314.608C85.7226 315.132 85.7011 315.419 85.7298 315.427L85.7226 315.434Z"
                                                fill="#263238" />
                                            <path
                                                d="M61.7581 310.861C61.7581 310.861 62.0952 310.925 62.7118 310.976C63.3285 311.033 64.2177 311.112 65.3148 311.241C67.5091 311.485 70.5351 311.93 73.8408 312.569C77.1537 313.215 80.1223 313.919 82.2592 314.5C83.3276 314.78 84.1881 315.032 84.7833 315.197C85.3785 315.369 85.7083 315.455 85.7155 315.426C85.7227 315.405 85.4072 315.276 84.8192 315.067C84.2383 314.859 83.385 314.572 82.3166 314.263C80.194 313.625 77.2182 312.878 73.8982 312.232C70.5781 311.593 67.5377 311.184 65.3292 311.004C64.2249 310.904 63.3285 310.861 62.7118 310.846C62.0952 310.832 61.751 310.839 61.751 310.861H61.7581Z"
                                                fill="#263238" />
                                            <path
                                                d="M96.0772 342.153C96.0772 342.153 96.1417 342.06 96.2421 341.859C96.3568 341.622 96.4931 341.334 96.658 340.99C97.0165 340.236 97.497 339.131 98.085 337.759C99.2538 335.01 100.745 331.169 102.33 326.905C103.922 322.641 105.378 318.786 106.482 316.022C107.027 314.68 107.471 313.574 107.801 312.749C107.945 312.39 108.059 312.096 108.153 311.859C108.232 311.65 108.267 311.543 108.253 311.536C108.239 311.536 108.188 311.629 108.088 311.83C107.973 312.067 107.837 312.347 107.672 312.699C107.314 313.452 106.833 314.558 106.245 315.929C105.076 318.678 103.585 322.519 101.993 326.783C100.401 331.047 98.9454 334.902 97.8412 337.666C97.2962 339.009 96.8516 340.114 96.5217 340.94C96.3783 341.299 96.2636 341.593 96.1704 341.83C96.0915 342.038 96.0556 342.146 96.07 342.153H96.0772Z"
                                                fill="#263238" />
                                            <path
                                                d="M64.2463 331.758C64.2463 331.758 64.3539 331.816 64.5618 331.887C64.8128 331.974 65.114 332.074 65.4868 332.203C66.3402 332.483 67.4946 332.864 68.8929 333.323C71.7684 334.271 75.7338 335.62 80.1079 337.121C84.4821 338.621 88.4618 339.935 91.3588 340.825C92.8072 341.27 93.9832 341.615 94.8007 341.837C95.1808 341.938 95.4891 342.024 95.7401 342.088C95.9552 342.139 96.0699 342.167 96.0771 342.153C96.0771 342.139 95.9695 342.096 95.7616 342.024C95.5106 341.938 95.2094 341.837 94.8366 341.708C93.9832 341.428 92.8288 341.047 91.4305 340.588C88.555 339.64 84.5896 338.291 80.2155 336.791C75.8413 335.29 71.8688 333.976 68.9646 333.086C67.5161 332.641 66.3401 332.297 65.5227 332.074C65.1426 331.974 64.8343 331.887 64.5762 331.823C64.361 331.765 64.2463 331.744 64.2391 331.758H64.2463Z"
                                                fill="#263238" />
                                            <path
                                                d="M215.685 352.813H115.89C103.829 352.756 93.6391 342.461 93.6893 330.394L94.7505 78.7728C94.8007 66.691 104.625 56.9423 116.693 56.9998L216.947 57.4664C229.008 57.5238 238.738 67.3515 238.681 79.4189L237.62 331.04C237.57 343.115 227.746 352.863 215.677 352.813H215.685Z"
                                                fill="#263238" />
                                            <path
                                                d="M216.803 67.0286L197.363 66.9424C194.76 66.9281 192.631 69.1319 192.624 71.8598L192.609 75.3918C192.602 78.1197 190.472 80.3236 187.869 80.3092L149.979 80.1369C147.376 80.1226 145.268 77.9043 145.282 75.1764L145.297 71.6445C145.311 68.9166 143.203 66.6912 140.6 66.684L133.766 66.6553L116.75 66.5763C108.303 66.5404 101.419 73.3674 101.383 81.8239L100.344 327.429C100.308 335.886 107.12 342.77 115.567 342.806L215.62 343.266C224.067 343.301 230.951 336.475 230.987 328.018L232.027 82.4126C232.062 73.956 225.25 67.0788 216.803 67.0358V67.0286Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M174.338 296.841C174.223 299.806 174.116 302.591 174.023 304.902H188.393L186.636 296.065L174.338 296.848V296.841Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M115.933 300.538L116.055 304.895H172.596C172.689 302.447 172.797 299.726 172.904 296.927L115.933 300.538Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M187.36 296.015L189.131 304.902H215.627L215.312 294.249L187.36 296.015Z"
                                                fill="#F5F5F5" />
                                            <path d="M175.78 171.83L180.785 142.749L167.662 141.773V171.83H175.78Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M114.75 284.393L100.509 289.978L100.466 300.078L115.173 299.145L114.75 284.393Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M114.685 282.124L113.903 255.039H113.896V245.484L100.688 246.884L100.516 287.666L114.678 282.11L114.685 282.124Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M113.896 224.163L100.788 222.433L100.695 244.723L113.896 243.323V224.163Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M211.547 245.886L210.995 253.654L195.521 255.319L196.718 261.464L214.286 260.136L214.021 251.328L215.426 245.499L211.547 245.886Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M183.66 262.447L196.001 261.521L193.312 247.731L182.542 248.822L183.66 262.447Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M183.775 263.883L184.721 275.376L186.392 291.14L187.081 294.593L215.269 292.813L214.329 261.571L183.775 263.883Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M135.265 209.605L136.348 211.464L114.613 224.156V254.263L137.552 252.641L181.767 248.176L180.146 228.442L137.904 222.914L138.183 220.782L179.967 226.245L177.228 192.842L135.875 196.827L135.738 195.398L177.113 191.414L175.686 173.984H135.903L100.968 180.351L100.795 220.265L114.025 222.009L135.265 209.612V209.605ZM116.836 251.392C116.836 251.392 117.001 226.568 116.836 225.635L134.577 216.188L136.878 250.121L116.843 251.392H116.836Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M210.099 246.037L194.029 247.659L195.248 253.905L209.654 252.354L210.099 246.037Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M174.546 291.521C174.496 292.828 174.446 294.12 174.396 295.397L186.356 294.637L185.74 291.55L174.539 291.521H174.546Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M148.782 171.83L150.89 162.268H166.945V141.723L116.736 137.997V157.286L101.054 160.84L100.975 178.155L135.71 171.83H148.782Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M182.283 114.666L181.853 112.908L201.028 105.312L188.558 80.2516C188.335 80.2875 188.106 80.309 187.869 80.309L166.68 80.2085L167.254 115.284L182.283 114.666Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M211.346 101.221L211.325 66.9997L197.371 66.9351C194.768 66.9208 192.638 69.1246 192.631 71.8525L192.616 75.3845C192.616 77.0715 191.799 78.5503 190.566 79.4333L203.043 104.516L211.346 101.228V101.221Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M139.266 102.692L137.653 66.6622L133.766 66.6406L118.6 66.5688L112.14 98.7941L139.266 102.692ZM135.81 70.309L136.326 99.6555L116.169 96.7051L120.587 70.3161H135.81V70.309Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M139.998 102.8V103.108C140.034 105.922 140.091 110.983 140.134 116.396L166.544 115.319L165.97 80.2083L149.987 80.1365C147.384 80.1222 145.275 77.9039 145.29 75.176L145.304 71.6441C145.318 68.9162 143.21 66.698 140.607 66.6836H138.37L139.991 102.807H139.998V102.8Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M110.003 98.4856L116.399 66.5762C108.11 66.7269 101.419 73.4677 101.384 81.8094L101.319 97.7174L101.384 97.2508L110.003 98.4927V98.4856Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M114.585 137.839L101.154 136.841L101.061 158.629L114.585 155.563V137.839Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M109.859 99.189L101.319 97.9614L101.168 133.245L103.004 133.381L109.859 99.189Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M136.993 281.715L137.216 253.388L114.621 254.989L115.417 282.734L136.993 281.715Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M141.145 275.175L173.148 290.523C173.528 280.495 173.872 271.119 173.836 270.516L174.532 270.48L174.869 269.806C175.17 269.959 175.242 272.313 175.084 276.87C174.948 280.681 174.761 285.757 174.568 290.839H185.632L183.997 275.448L181.817 248.894L140.005 253.115L141.138 275.175H141.145Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M219.586 228.169L219.227 224.429L180.871 228.427L182.484 248.104L215.599 244.759L219.586 228.169Z"
                                                fill="#F5F5F5" />
                                            <path d="M166.945 164.422H152.618L150.983 171.83H166.945V164.422Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M213.662 166.92L177.773 164.437L176.31 172.922L177.823 191.342L215.67 187.696L213.662 166.913V166.92ZM179.1 172.907L181.029 167.552L212.2 169.526L214.007 184.853L180.161 188.873L179.107 172.915L179.1 172.907Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M217.384 205.419L215.814 189.131L177.945 192.77L179.365 210.114L217.384 205.419Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M115.216 300.588L100.523 301.514L100.458 300.559L100.444 304.902H115.338L115.216 300.588Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M231.769 93.13L231.984 93.6756L232.034 82.3979C232.07 73.9413 225.258 67.0641 216.811 67.021L212.042 66.9995L212.064 100.933L231.769 93.13Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M173.119 291.306L140.457 275.642L139.302 253.194L137.933 253.33L137.703 282.397L115.438 283.452L115.459 284.098V284.113L115.89 299.102L172.961 295.491C173.012 294.098 173.069 292.698 173.119 291.306ZM116.836 285.304L148 283.115L168.272 292.533L116.836 295.319V285.304Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M222.483 130.826L223.816 122.893C212.099 118.708 211.289 106.483 211.325 102.778L203.681 105.808L215.197 128.945L222.483 130.833V130.826Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M180.692 226.281L196.618 224.623L193.477 210.538L179.544 212.261L180.692 226.281Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M213.72 142.986H183.976L181.509 142.8L178.146 162.304L213.454 164.745L212.637 156.267L216.108 143.747L213.72 142.986Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M212.996 139.397L213.368 130.086L201.68 106.59L183.553 113.769L189.784 139.39H212.996V139.397ZM200.97 109.455L211.683 129.857L210.134 136.217L191.806 135.528L187.224 116.231L200.97 109.462V109.455Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M217.621 251.701L218.166 269.985L231.059 269.26L231.094 269.978L218.187 270.703L218.847 292.583L231.03 291.808L231.123 293.244L218.89 294.019L219.213 304.902H231.087L231.345 243.89L219.205 245.118L217.621 251.701Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M139.288 103.417L111.996 99.4976L105.17 133.539L139.403 136.08C139.539 130.84 139.417 114.76 139.281 103.424L139.288 103.417Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M184.176 139.397H188.3L182.456 115.377L167.268 116.002L167.634 138.177L184.176 139.397Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M100.372 322.375L100.351 327.414C100.351 327.572 100.365 327.723 100.372 327.874V322.375Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M140.105 136.131L166.917 138.119L166.551 116.03L140.134 117.114C140.191 124.587 140.213 132.556 140.098 136.138L140.105 136.131Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M217.592 207.566L194.194 210.452L197.335 224.544L219.019 222.289L217.592 207.566Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M223.938 122.168L225.437 113.267L231.897 113.769L231.976 94.5947L212.049 102.491C211.64 115.987 220.109 120.732 223.938 122.175V122.168Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M216.265 156.59L217.083 164.996L231.675 166.009L231.747 148.686L219.528 144.824L216.265 156.59Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M223.214 228.42L219.377 244.378L231.345 243.172L231.417 226.439C227.746 225.469 224.54 224.68 222.812 224.35L223.207 228.427L223.214 228.42Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M215.132 139.67L231.768 144.932L231.804 135.463L215.469 131.235L215.132 139.67Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M222.604 222.153C223.945 222.354 226.484 222.893 231.424 224.199L231.582 187.609L219.377 188.787L222.604 222.153Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M219.241 187.358L231.589 186.166L231.668 168.169L217.291 167.171L219.241 187.358Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M225.315 122.628C227.652 123.338 229.832 123.891 231.847 124.293L231.883 115.212L226.627 114.803L225.308 122.628H225.315Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M223.874 131.185L231.812 133.238L231.847 125.025C229.797 124.616 227.581 124.056 225.193 123.331L223.874 131.177V131.185Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M115.216 300.588L115.338 304.902H116.055L115.933 300.545L172.904 296.934C172.797 299.734 172.689 302.454 172.596 304.902H174.03C174.123 302.591 174.231 299.805 174.345 296.841L186.643 296.058L188.4 304.895H189.131L187.36 296.008L215.305 294.235L215.627 304.888H219.213L218.883 294.005L231.116 293.23L231.023 291.794L218.84 292.562L218.187 270.681L231.094 269.956L231.051 269.238L218.166 269.963L217.621 251.679L219.205 245.089L231.353 243.862V243.137L219.385 244.343L223.221 228.384L222.827 224.307C224.548 224.637 227.753 225.427 231.432 226.396V224.156C226.498 222.857 223.96 222.318 222.619 222.11L219.392 188.743L231.596 187.566V186.123L219.256 187.315L217.305 167.128L231.682 168.126V165.965L217.097 164.953L216.287 156.54L219.55 144.781L231.769 148.643L231.783 144.881L215.154 139.627L215.491 131.192L231.826 135.42V133.202L223.895 131.149L225.214 123.302C227.595 124.027 229.811 124.587 231.869 124.996V124.257C229.854 123.855 227.674 123.302 225.336 122.592L226.656 114.767L231.912 115.176V113.733L225.458 113.231L223.96 122.132C220.138 120.689 211.669 115.944 212.071 102.448L231.998 94.5515V93.6398L231.783 93.0942L212.078 100.897L212.056 66.9637H211.339L211.361 101.185L203.057 104.472L190.58 79.39C189.992 79.8136 189.318 80.0936 188.579 80.2012L201.049 105.262L181.875 112.857L182.305 114.616L167.275 115.233L166.701 80.1582H165.984L166.558 115.269L140.148 116.346C140.105 110.933 140.048 105.872 140.012 103.058V102.75H139.998L138.377 66.6119H137.66L139.273 102.642L112.147 98.7439L118.608 66.5186H116.757C116.643 66.5114 116.528 66.5186 116.406 66.5258L110.01 98.4352L101.391 97.1933L101.326 97.6599V97.9039L109.874 99.1315L103.018 133.317L101.176 133.18L101.161 136.777L114.592 137.775V155.506L101.068 158.571V160.782L116.743 157.229V137.94L166.952 141.665V162.211H150.897L148.789 171.773H135.717L100.989 178.097V180.287L135.918 173.919H175.701L177.128 191.349L135.753 195.333L135.889 196.762L177.242 192.778L179.982 226.18L138.198 220.717L137.918 222.85L180.161 228.377L181.781 248.111L137.567 252.577L114.628 254.199V224.091L136.362 211.399L135.279 209.54L114.04 221.938L100.81 220.193V222.361L113.904 224.091V243.251L100.709 244.651V246.819L113.904 245.419V254.974H113.911L114.692 282.06V282.045L100.523 287.602V289.92L114.757 284.335L115.18 299.087L100.473 300.021V300.502L100.53 301.456L115.223 300.523L115.216 300.588ZM174.403 295.405C174.453 294.127 174.503 292.828 174.553 291.528L185.754 291.557L186.371 294.644L174.41 295.405H174.403ZM187.088 294.601L186.399 291.148L184.729 275.383L183.789 263.89L214.344 261.586L215.283 292.82L187.095 294.608L187.088 294.601ZM194.036 247.666L210.106 246.044L209.654 252.361L195.248 253.919L194.029 247.673L194.036 247.666ZM193.319 247.738L196.008 261.521L183.667 262.454L182.549 248.822L193.319 247.731V247.738ZM214.293 260.143L196.725 261.471L195.528 255.326L211.002 253.653L211.554 245.893L215.426 245.498L214.028 251.335L214.293 260.143ZM193.484 210.545L196.625 224.623L180.699 226.281L179.551 212.261L193.491 210.538L193.484 210.545ZM197.342 224.551L194.201 210.459L217.599 207.573L219.026 222.297L197.342 224.558V224.551ZM213.462 164.752L178.153 162.304L181.516 142.807L183.983 142.993H213.727L216.115 143.754L212.637 156.281L213.455 164.759L213.462 164.752ZM211.339 102.778C211.303 106.483 212.114 118.708 223.831 122.893L222.497 130.826L215.211 128.938L203.695 105.801L211.339 102.771V102.778ZM201.687 106.605L213.376 130.1L213.003 139.411H189.791L183.56 113.79L201.687 106.612V106.605ZM182.47 115.384L188.314 139.404H184.184L167.648 138.177L167.282 116.001L182.47 115.377V115.384ZM166.565 116.037L166.931 138.126L140.12 136.138C140.234 132.556 140.206 124.587 140.156 117.114L166.572 116.03L166.565 116.037ZM112.003 99.5048L139.295 103.424C139.431 114.767 139.553 130.84 139.417 136.08L105.184 133.539L112.01 99.4976L112.003 99.5048ZM180.792 142.757L175.78 171.838H167.67V141.78L180.792 142.757ZM152.625 164.429H166.952V171.838H150.99L152.625 164.429ZM176.325 172.936L177.787 164.451L213.677 166.934L215.685 187.717L177.838 191.364L176.325 172.943V172.936ZM215.821 189.145L217.398 205.441L179.379 210.129L177.959 192.792L215.828 189.145H215.821ZM180.878 228.442L219.234 224.45L219.593 228.183L215.606 244.773L182.484 248.119L180.871 228.442H180.878ZM184.012 275.462L185.646 290.853H174.582C174.776 285.778 174.962 280.703 175.098 276.884C175.256 272.328 175.184 269.973 174.883 269.82L174.546 270.495L173.851 270.531C173.879 271.126 173.542 280.509 173.162 290.538L141.159 275.19L140.026 253.129L181.839 248.908L184.019 275.462H184.012ZM137.223 253.402L137 281.729L115.431 282.756L114.635 255.01L137.23 253.409L137.223 253.402ZM115.467 284.134V284.12L115.445 283.474L137.71 282.418L137.94 253.352L139.309 253.215L140.464 275.663L173.126 291.327C173.076 292.72 173.019 294.12 172.969 295.512L115.897 299.123L115.467 284.134Z"
                                                fill="white" />
                                            <path d="M148 283.115L116.836 285.304V295.319L168.272 292.526L148 283.115Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M212.192 169.526L181.021 167.552L179.1 172.907L180.154 188.865L213.999 184.845L212.192 169.526Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M115.574 342.791L215.627 343.251C224.074 343.287 230.958 336.46 230.994 328.003L231.095 304.895H100.444L100.372 322.368V327.867C100.58 336.108 107.285 342.748 115.574 342.784V342.791Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M136.326 99.6557L135.803 70.3091H120.579L116.162 96.7052L136.326 99.6557Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M210.135 136.217L211.683 129.856L200.97 109.455L187.217 116.231L191.806 135.528L210.135 136.217Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M116.836 225.642C117.001 226.568 116.836 251.399 116.836 251.399L136.871 250.129L134.57 216.195L116.829 225.642H116.836Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M183.66 245.8L182.606 230.416L216.968 225.994V228.65L212.816 242.799L183.66 245.8Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M158.24 118.212C158.24 120.524 156.368 122.405 154.052 122.405C151.736 122.405 149.865 120.531 149.865 118.212C149.865 115.894 151.736 114.02 154.052 114.02C156.368 114.02 158.24 115.894 158.24 118.212Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M158.24 118.212C158.24 120.524 156.368 122.405 154.052 122.405C151.736 122.405 149.865 120.531 149.865 118.212C149.865 115.894 151.736 114.02 154.052 114.02C156.368 114.02 158.24 115.894 158.24 118.212Z"
                                                fill="#FB5607" />
                                            <g opacity="0.6">
                                                <path
                                                    d="M158.24 118.033C158.34 120.344 156.548 122.297 154.239 122.397C151.93 122.498 149.979 120.703 149.879 118.392C149.779 116.08 151.571 114.127 153.88 114.027C156.189 113.926 158.14 115.721 158.24 118.033Z"
                                                    fill="white" />
                                            </g>
                                            <path
                                                d="M154.06 120.854C155.596 120.854 156.842 119.607 156.842 118.069C156.842 116.531 155.596 115.284 154.06 115.284C152.523 115.284 151.277 116.531 151.277 118.069C151.277 119.607 152.523 120.854 154.06 120.854Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M154.06 120.854C155.596 120.854 156.842 119.607 156.842 118.069C156.842 116.531 155.596 115.284 154.06 115.284C152.523 115.284 151.277 116.531 151.277 118.069C151.277 119.607 152.523 120.854 154.06 120.854Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M218.754 285.584C218.754 286.575 217.951 287.372 216.968 287.372C215.986 287.372 215.183 286.568 215.183 285.584C215.183 284.601 215.986 283.797 216.968 283.797C217.951 283.797 218.754 284.601 218.754 285.584Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M218.754 285.584C218.754 286.575 217.951 287.372 216.968 287.372C215.986 287.372 215.183 286.568 215.183 285.584C215.183 284.601 215.986 283.797 216.968 283.797C217.951 283.797 218.754 284.601 218.754 285.584Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M215.893 285.003L215.462 274.967L185.252 276.439C184.463 276.482 183.675 276.309 182.972 275.95L140.127 254.285C139.137 253.783 138.485 252.785 138.427 251.672L132.598 138.435C132.569 137.889 132.777 137.365 133.164 136.985C133.551 136.604 134.089 136.411 134.627 136.446L152.991 137.81V117.71H155.142V138.083C155.142 138.607 154.92 139.117 154.54 139.469C154.153 139.828 153.636 140.007 153.113 139.971L134.763 138.607L140.579 251.55C140.593 251.887 140.794 252.196 141.102 252.354L183.947 274.019C184.32 274.206 184.736 274.299 185.159 274.278L215.62 272.792C216.136 272.77 216.617 272.943 216.997 273.287C217.377 273.632 217.592 274.098 217.614 274.615L218.058 284.902L215.907 284.996L215.893 285.003Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M215.893 285.003L215.462 274.967L185.252 276.439C184.463 276.482 183.675 276.309 182.972 275.95L140.127 254.285C139.137 253.783 138.485 252.785 138.427 251.672L132.598 138.435C132.569 137.889 132.777 137.365 133.164 136.985C133.551 136.604 134.089 136.411 134.627 136.446L152.991 137.81V117.71H155.142V138.083C155.142 138.607 154.92 139.117 154.54 139.469C154.153 139.828 153.636 140.007 153.113 139.971L134.763 138.607L140.579 251.55C140.593 251.887 140.794 252.196 141.102 252.354L183.947 274.019C184.32 274.206 184.736 274.299 185.159 274.278L215.62 272.792C216.136 272.77 216.617 272.943 216.997 273.287C217.377 273.632 217.592 274.098 217.614 274.615L218.058 284.902L215.907 284.996L215.893 285.003Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M136.097 193.029C139.091 193.029 141.518 190.599 141.518 187.602C141.518 184.605 139.091 182.175 136.097 182.175C133.103 182.175 130.676 184.605 130.676 187.602C130.676 190.599 133.103 193.029 136.097 193.029Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M136.097 193.029C139.091 193.029 141.518 190.599 141.518 187.602C141.518 184.605 139.091 182.175 136.097 182.175C133.103 182.175 130.676 184.605 130.676 187.602C130.676 190.599 133.103 193.029 136.097 193.029Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M136.097 191.371C138.176 191.371 139.861 189.683 139.861 187.602C139.861 185.52 138.176 183.833 136.097 183.833C134.018 183.833 132.332 185.52 132.332 187.602C132.332 189.683 134.018 191.371 136.097 191.371Z"
                                                fill="#FAFAFA" />
                                            <path
                                                d="M136.097 191.643C133.874 191.643 132.06 189.834 132.06 187.602C132.06 185.369 133.867 183.56 136.097 183.56C138.327 183.56 140.134 185.369 140.134 187.602C140.134 189.834 138.327 191.643 136.097 191.643ZM136.097 184.106C134.168 184.106 132.597 185.678 132.597 187.609C132.597 189.54 134.168 191.112 136.097 191.112C138.026 191.112 139.596 189.54 139.596 187.609C139.596 185.678 138.026 184.106 136.097 184.106Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M136.097 191.643C133.874 191.643 132.06 189.834 132.06 187.602C132.06 185.369 133.867 183.56 136.097 183.56C138.327 183.56 140.134 185.369 140.134 187.602C140.134 189.834 138.327 191.643 136.097 191.643ZM136.097 184.106C134.168 184.106 132.597 185.678 132.597 187.609C132.597 189.54 134.168 191.112 136.097 191.112C138.026 191.112 139.596 189.54 139.596 187.609C139.596 185.678 138.026 184.106 136.097 184.106Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M168.035 164.838H142.221C140.966 164.838 139.948 165.858 139.948 167.114V176.475C139.948 177.731 140.966 178.751 142.221 178.751H142.522V180.983L145.103 178.751H168.035C169.29 178.751 170.308 177.731 170.308 176.475V167.114C170.308 165.858 169.29 164.838 168.035 164.838Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M168.035 164.838H142.221C140.966 164.838 139.948 165.858 139.948 167.114V176.475C139.948 177.731 140.966 178.751 142.221 178.751H142.522V180.983L145.103 178.751H168.035C169.29 178.751 170.308 177.731 170.308 176.475V167.114C170.308 165.858 169.29 164.838 168.035 164.838Z"
                                                fill="#FB5607" />
                                            <g opacity="0.4">
                                                <path
                                                    d="M168.035 164.838H142.221C140.966 164.838 139.948 165.858 139.948 167.114V176.475C139.948 177.731 140.966 178.751 142.221 178.751H142.522V180.983L145.103 178.751H168.035C169.29 178.751 170.308 177.731 170.308 176.475V167.114C170.308 165.858 169.29 164.838 168.035 164.838Z"
                                                    fill="white" />
                                            </g>
                                            <path
                                                d="M145.749 171.644C145.749 170.789 146.408 170.15 147.305 170.15C148.201 170.15 148.854 170.782 148.854 171.644C148.854 172.505 148.194 173.137 147.305 173.137C146.416 173.137 145.749 172.498 145.749 171.644ZM148.431 171.644C148.431 170.997 147.95 170.524 147.298 170.524C146.645 170.524 146.157 170.997 146.157 171.644C146.157 172.29 146.638 172.763 147.298 172.763C147.957 172.763 148.431 172.29 148.431 171.644Z"
                                                fill="white" />
                                            <path
                                                d="M151.722 172.003C151.722 172.678 151.249 173.137 150.603 173.137C150.281 173.137 149.994 173.015 149.814 172.764V173.116H149.427V170.021H149.829V171.242C150.015 171.005 150.288 170.89 150.603 170.89C151.249 170.89 151.722 171.342 151.722 172.017V172.003ZM151.32 172.003C151.32 171.529 150.998 171.228 150.575 171.228C150.151 171.228 149.836 171.529 149.836 172.003C149.836 172.477 150.159 172.785 150.575 172.785C150.99 172.785 151.32 172.477 151.32 172.003Z"
                                                fill="white" />
                                            <path
                                                d="M151.514 173.805L151.643 173.496C151.722 173.56 151.837 173.604 151.966 173.604C152.181 173.604 152.296 173.467 152.296 173.216V170.897H152.697V173.209C152.697 173.661 152.446 173.941 151.994 173.941C151.808 173.941 151.629 173.898 151.514 173.805ZM152.224 170.208C152.224 170.064 152.339 169.942 152.496 169.942C152.654 169.942 152.769 170.057 152.769 170.194C152.769 170.344 152.654 170.459 152.496 170.459C152.339 170.459 152.224 170.344 152.224 170.201V170.208Z"
                                                fill="white" />
                                            <path
                                                d="M155.451 172.132H153.658C153.708 172.52 154.024 172.778 154.461 172.778C154.719 172.778 154.934 172.692 155.099 172.513L155.322 172.771C155.121 173.008 154.82 173.13 154.447 173.13C153.737 173.13 153.256 172.656 153.256 171.996C153.256 171.335 153.73 170.869 154.368 170.869C155.006 170.869 155.458 171.328 155.458 172.01C155.458 172.046 155.458 172.096 155.451 172.132ZM153.658 171.845H155.078C155.035 171.472 154.755 171.213 154.368 171.213C153.981 171.213 153.701 171.472 153.658 171.845Z"
                                                fill="white" />
                                            <path
                                                d="M155.809 172.003C155.809 171.342 156.297 170.875 156.978 170.875C157.372 170.875 157.702 171.041 157.882 171.349L157.58 171.543C157.437 171.328 157.222 171.227 156.978 171.227C156.548 171.227 156.218 171.529 156.218 172.003C156.218 172.476 156.541 172.785 156.978 172.785C157.222 172.785 157.437 172.685 157.58 172.469L157.882 172.663C157.709 172.972 157.38 173.137 156.978 173.137C156.297 173.137 155.809 172.663 155.809 172.003Z"
                                                fill="white" />
                                            <path
                                                d="M159.66 172.979C159.538 173.086 159.359 173.13 159.179 173.13C158.735 173.13 158.477 172.885 158.477 172.44V171.227H158.104V170.897H158.477V170.416H158.878V170.897H159.509V171.227H158.878V172.426C158.878 172.663 159 172.799 159.222 172.799C159.337 172.799 159.452 172.763 159.538 172.692L159.66 172.979Z"
                                                fill="white" />
                                            <path
                                                d="M160.076 170.208C160.076 170.064 160.191 169.942 160.348 169.942C160.506 169.942 160.621 170.057 160.621 170.194C160.621 170.344 160.506 170.459 160.348 170.459C160.191 170.459 160.076 170.344 160.076 170.201V170.208ZM160.148 170.89H160.549V173.101H160.148V170.89Z"
                                                fill="white" />
                                            <path
                                                d="M163.267 170.897L162.299 173.108H161.89L160.922 170.897H161.338L162.098 172.67L162.872 170.897H163.267Z"
                                                fill="white" />
                                            <path
                                                d="M165.569 172.132H163.776C163.826 172.52 164.142 172.778 164.579 172.778C164.837 172.778 165.052 172.692 165.217 172.513L165.439 172.771C165.239 173.008 164.937 173.13 164.565 173.13C163.855 173.13 163.374 172.656 163.374 171.996C163.374 171.335 163.848 170.869 164.486 170.869C165.124 170.869 165.576 171.328 165.576 172.01C165.576 172.046 165.576 172.096 165.569 172.132ZM163.776 171.845H165.196C165.153 171.472 164.873 171.213 164.486 171.213C164.099 171.213 163.819 171.472 163.776 171.845Z"
                                                fill="white" />
                                            <path
                                                d="M159.509 104.135C159.509 100.826 156.526 98.2197 153.106 98.8586C150.955 99.2607 149.241 101.019 148.861 103.18C148.624 104.53 148.904 105.8 149.52 106.849L149.535 106.87C149.743 107.215 150.001 107.466 150.259 107.832L153.378 111.967C153.765 112.484 154.54 112.484 154.927 111.967L157.989 107.904C157.989 107.904 158.563 107.222 158.771 106.87L158.785 106.856C159.251 106.059 159.524 105.133 159.524 104.142L159.509 104.135ZM154.146 106.475C152.84 106.475 151.786 105.42 151.786 104.113C151.786 102.807 152.84 101.752 154.146 101.752C155.451 101.752 156.505 102.807 156.505 104.113C156.505 105.42 155.451 106.475 154.146 106.475Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M159.509 104.135C159.509 100.826 156.526 98.2197 153.106 98.8586C150.955 99.2607 149.241 101.019 148.861 103.18C148.624 104.53 148.904 105.8 149.52 106.849L149.535 106.87C149.743 107.215 150.001 107.466 150.259 107.832L153.378 111.967C153.765 112.484 154.54 112.484 154.927 111.967L157.989 107.904C157.989 107.904 158.563 107.222 158.771 106.87L158.785 106.856C159.251 106.059 159.524 105.133 159.524 104.142L159.509 104.135ZM154.146 106.475C152.84 106.475 151.786 105.42 151.786 104.113C151.786 102.807 152.84 101.752 154.146 101.752C155.451 101.752 156.505 102.807 156.505 104.113C156.505 105.42 155.451 106.475 154.146 106.475Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M124.76 315.814H123.763V315.448H126.18V315.814H125.183V318.369H124.767V315.814H124.76Z"
                                                fill="#263238" />
                                            <path
                                                d="M126.137 317.264C126.137 316.604 126.624 316.137 127.284 316.137C127.944 316.137 128.431 316.604 128.431 317.264C128.431 317.925 127.951 318.398 127.284 318.398C126.617 318.398 126.137 317.925 126.137 317.264ZM128.03 317.264C128.03 316.79 127.714 316.489 127.291 316.489C126.868 316.489 126.545 316.79 126.545 317.264C126.545 317.738 126.868 318.047 127.291 318.047C127.714 318.047 128.03 317.738 128.03 317.264Z"
                                                fill="#263238" />
                                            <path
                                                d="M130.231 318.241C130.109 318.348 129.93 318.398 129.751 318.398C129.306 318.398 129.048 318.154 129.048 317.702V316.489H128.675V316.159H129.048V315.678H129.45V316.159H130.081V316.489H129.45V317.688C129.45 317.925 129.572 318.061 129.794 318.061C129.909 318.061 130.023 318.025 130.109 317.953L130.231 318.241Z"
                                                fill="#263238" />
                                            <path
                                                d="M132.461 317.034V318.37H132.081V318.075C131.945 318.276 131.701 318.391 131.357 318.391C130.855 318.391 130.54 318.126 130.54 317.738C130.54 317.386 130.769 317.092 131.429 317.092H132.06V317.013C132.06 316.675 131.866 316.482 131.465 316.482C131.199 316.482 130.934 316.575 130.762 316.719L130.597 316.417C130.826 316.23 131.156 316.13 131.508 316.13C132.11 316.13 132.454 316.424 132.454 317.027L132.461 317.034ZM132.06 317.695V317.386H131.443C131.049 317.386 130.934 317.537 130.934 317.731C130.934 317.953 131.12 318.09 131.422 318.09C131.723 318.09 131.959 317.953 132.06 317.695Z"
                                                fill="#263238" />
                                            <path d="M133.207 315.275H133.609V318.369H133.207V315.275Z"
                                                fill="#263238" />
                                            <path
                                                d="M137.574 315.276V318.37H137.187V318.018C137.007 318.269 136.728 318.391 136.398 318.391C135.753 318.391 135.279 317.939 135.279 317.257C135.279 316.575 135.753 316.13 136.398 316.13C136.713 316.13 136.986 316.245 137.172 316.482V315.261H137.574V315.276ZM137.18 317.264C137.18 316.79 136.857 316.489 136.441 316.489C136.025 316.489 135.695 316.79 135.695 317.264C135.695 317.738 136.018 318.047 136.441 318.047C136.864 318.047 137.18 317.738 137.18 317.264Z"
                                                fill="#263238" />
                                            <path
                                                d="M138.262 315.477C138.262 315.333 138.377 315.211 138.535 315.211C138.693 315.211 138.807 315.326 138.807 315.469C138.807 315.62 138.693 315.735 138.535 315.735C138.377 315.735 138.262 315.62 138.262 315.477ZM138.334 316.159H138.736V318.37H138.334V316.159Z"
                                                fill="#263238" />
                                            <path
                                                d="M139.216 318.14L139.381 317.824C139.567 317.96 139.869 318.054 140.155 318.054C140.528 318.054 140.679 317.939 140.679 317.752C140.679 317.257 139.281 317.687 139.281 316.804C139.281 316.41 139.632 316.144 140.199 316.144C140.485 316.144 140.808 316.216 141.002 316.345L140.83 316.661C140.629 316.532 140.406 316.489 140.191 316.489C139.84 316.489 139.668 316.618 139.668 316.79C139.668 317.314 141.066 316.883 141.066 317.745C141.066 318.147 140.7 318.398 140.112 318.398C139.747 318.398 139.381 318.283 139.202 318.14H139.216Z"
                                                fill="#263238" />
                                            <path
                                                d="M142.83 318.241C142.708 318.348 142.529 318.398 142.35 318.398C141.905 318.398 141.647 318.154 141.647 317.702V316.489H141.274V316.159H141.647V315.678H142.048V316.159H142.68V316.489H142.048V317.688C142.048 317.925 142.17 318.061 142.393 318.061C142.507 318.061 142.622 318.025 142.708 317.953L142.83 318.241Z"
                                                fill="#263238" />
                                            <path
                                                d="M145.06 317.034V318.37H144.68V318.075C144.544 318.276 144.3 318.391 143.956 318.391C143.454 318.391 143.138 318.126 143.138 317.738C143.138 317.386 143.368 317.092 144.028 317.092H144.659V317.013C144.659 316.675 144.465 316.482 144.063 316.482C143.798 316.482 143.533 316.575 143.361 316.719L143.196 316.417C143.425 316.23 143.755 316.13 144.106 316.13C144.709 316.13 145.053 316.424 145.053 317.027L145.06 317.034ZM144.659 317.695V317.386H144.042C143.648 317.386 143.533 317.537 143.533 317.731C143.533 317.953 143.719 318.09 144.02 318.09C144.322 318.09 144.558 317.953 144.659 317.695Z"
                                                fill="#263238" />
                                            <path
                                                d="M147.9 317.099V318.37H147.498V317.142C147.498 316.711 147.283 316.496 146.903 316.496C146.48 316.496 146.2 316.747 146.2 317.228V318.37H145.799V316.159H146.186V316.489C146.351 316.266 146.631 316.137 146.982 316.137C147.52 316.137 147.9 316.446 147.9 317.099Z"
                                                fill="#263238" />
                                            <path
                                                d="M148.452 317.264C148.452 316.604 148.94 316.137 149.621 316.137C150.015 316.137 150.345 316.302 150.524 316.611L150.223 316.805C150.08 316.589 149.865 316.489 149.621 316.489C149.19 316.489 148.861 316.79 148.861 317.264C148.861 317.738 149.183 318.047 149.621 318.047C149.865 318.047 150.08 317.946 150.223 317.731L150.524 317.925C150.352 318.233 150.022 318.398 149.621 318.398C148.94 318.398 148.452 317.925 148.452 317.264Z"
                                                fill="#263238" />
                                            <path
                                                d="M152.991 317.401H151.198C151.249 317.788 151.564 318.047 152.001 318.047C152.26 318.047 152.475 317.961 152.64 317.781L152.862 318.04C152.661 318.276 152.36 318.398 151.987 318.398C151.277 318.398 150.797 317.925 150.797 317.264C150.797 316.604 151.27 316.137 151.908 316.137C152.546 316.137 152.998 316.597 152.998 317.279C152.998 317.315 152.998 317.365 152.991 317.401ZM151.198 317.114H152.618C152.575 316.74 152.295 316.482 151.908 316.482C151.521 316.482 151.241 316.74 151.198 317.114Z"
                                                fill="#263238" />
                                            <path d="M127.377 321.65V328.621H125.764V322.943H124.373V321.65H127.377Z"
                                                fill="#263238" />
                                            <path
                                                d="M130.475 327.723C130.475 327.982 130.432 328.169 130.21 328.721L129.643 330.157H128.661L129.098 328.578C128.768 328.449 128.56 328.14 128.56 327.731C128.56 327.156 128.976 326.776 129.528 326.776C130.081 326.776 130.482 327.164 130.482 327.731L130.475 327.723Z"
                                                fill="#263238" />
                                            <path d="M133.723 321.65V328.621H132.11V322.943H130.719V321.65H133.723Z"
                                                fill="#263238" />
                                            <path
                                                d="M134.935 325.132C134.935 322.835 136.212 321.528 137.918 321.528C139.625 321.528 140.901 322.835 140.901 325.132C140.901 327.429 139.639 328.736 137.918 328.736C136.197 328.736 134.935 327.429 134.935 325.132ZM139.281 325.132C139.281 323.546 138.721 322.892 137.918 322.892C137.115 322.892 136.563 323.553 136.563 325.132C136.563 326.711 137.122 327.372 137.918 327.372C138.714 327.372 139.281 326.711 139.281 325.132Z"
                                                fill="#263238" />
                                            <path
                                                d="M141.69 325.132C141.69 322.835 142.966 321.528 144.673 321.528C146.38 321.528 147.656 322.835 147.656 325.132C147.656 327.429 146.394 328.736 144.673 328.736C142.952 328.736 141.69 327.429 141.69 325.132ZM146.035 325.132C146.035 323.546 145.476 322.892 144.673 322.892C143.87 322.892 143.318 323.553 143.318 325.132C143.318 326.711 143.877 327.372 144.673 327.372C145.469 327.372 146.035 326.711 146.035 325.132Z"
                                                fill="#263238" />
                                            <path
                                                d="M160.628 325.548V328.614H159.079V325.785C159.079 324.917 158.692 324.522 158.068 324.522C157.372 324.522 156.885 324.967 156.885 325.929V328.621H155.336V325.793C155.336 324.924 154.97 324.529 154.325 324.529C153.636 324.529 153.149 324.974 153.149 325.936V328.628H151.6V323.273H153.084V323.89C153.479 323.431 154.081 323.194 154.762 323.194C155.508 323.194 156.146 323.481 156.519 324.07C156.949 323.524 157.645 323.194 158.448 323.194C159.724 323.194 160.635 323.933 160.635 325.563L160.628 325.548Z"
                                                fill="#263238" />
                                            <path
                                                d="M120.099 322.461C120.858 319.231 118.857 315.996 115.63 315.237C112.404 314.477 109.173 316.481 108.414 319.711C107.656 322.941 109.656 326.176 112.883 326.935C116.11 327.695 119.341 325.692 120.099 322.461Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M120.099 322.461C120.858 319.231 118.857 315.996 115.63 315.237C112.404 314.477 109.173 316.481 108.414 319.711C107.656 322.941 109.656 326.176 112.883 326.935C116.11 327.695 119.341 325.692 120.099 322.461Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M111.838 322.196C111.838 322.196 112.398 322.132 113.38 322.103C114.362 322.074 115.761 322.053 117.439 322.038L117.317 322.304C116.843 321.758 116.327 321.155 115.782 320.531L115.689 320.416L115.782 320.301C116.263 319.698 116.772 319.066 117.295 318.406L117.439 318.707C117.223 318.707 116.987 318.707 116.757 318.707C114.986 318.707 113.315 318.693 111.838 318.686L112.003 318.521C111.989 320.344 111.967 321.88 111.939 322.957C111.91 324.034 111.874 324.658 111.838 324.658C111.802 324.658 111.767 324.034 111.738 322.957C111.709 321.88 111.688 320.344 111.673 318.521V318.356H111.838C113.315 318.356 114.986 318.341 116.757 318.334C116.994 318.334 117.223 318.334 117.439 318.334H117.826L117.582 318.635C117.051 319.289 116.542 319.92 116.055 320.516V320.287C116.585 320.918 117.094 321.529 117.56 322.081L117.79 322.354H117.439C115.761 322.333 114.355 322.311 113.38 322.282C112.398 322.254 111.838 322.225 111.838 322.189V322.196Z"
                                                fill="#FAFAFA" />
                                            <path
                                                d="M211.368 310.846H193.219C191.304 310.846 189.748 312.404 189.748 314.321V328.621C189.748 330.537 191.304 332.095 193.219 332.095H193.678V335.505L197.629 332.095H211.368C213.282 332.095 214.838 330.537 214.838 328.621V314.321C214.838 312.404 213.282 310.846 211.368 310.846Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M211.368 310.846H193.219C191.304 310.846 189.748 312.404 189.748 314.321V328.621C189.748 330.537 191.304 332.095 193.219 332.095H193.678V335.505L197.629 332.095H211.368C213.282 332.095 214.838 330.537 214.838 328.621V314.321C214.838 312.404 213.282 310.846 211.368 310.846Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M194.947 317.408V324.745C194.947 324.902 195.076 325.032 195.234 325.032H210.593C210.751 325.032 210.88 324.902 210.88 324.745L210.844 322.06C210.844 322.002 210.823 321.938 210.787 321.895L208.585 318.944C208.535 318.872 208.449 318.829 208.356 318.829L205.818 318.808C205.66 318.808 205.538 318.679 205.538 318.521V317.415C205.538 317.257 205.409 317.128 205.251 317.128H195.234C195.076 317.128 194.947 317.257 194.947 317.415V317.408Z"
                                                fill="#FAFAFA" />
                                            <path
                                                d="M206.248 319.446V321.801C206.248 321.894 206.32 321.966 206.413 321.966L209.805 321.909C209.934 321.909 210.013 321.758 209.934 321.65L208.349 319.31C208.32 319.267 208.263 319.238 208.205 319.238L206.398 319.289C206.312 319.289 206.241 319.36 206.241 319.454L206.248 319.446Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M206.248 319.446V321.801C206.248 321.894 206.32 321.966 206.413 321.966L209.805 321.909C209.934 321.909 210.013 321.758 209.934 321.65L208.349 319.31C208.32 319.267 208.263 319.238 208.205 319.238L206.398 319.289C206.312 319.289 206.241 319.36 206.241 319.454L206.248 319.446Z"
                                                fill="#FB5607" />
                                            <path d="M211.181 325.254H194.638V325.764H211.181V325.254Z"
                                                fill="#FAFAFA" />
                                            <path
                                                d="M200.11 325.448C200.11 326.352 199.378 327.085 198.475 327.085C197.571 327.085 196.84 326.352 196.84 325.448C196.84 324.543 197.571 323.811 198.475 323.811C199.378 323.811 200.11 324.543 200.11 325.448Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M200.11 325.448C200.11 326.352 199.378 327.085 198.475 327.085C197.571 327.085 196.84 326.352 196.84 325.448C196.84 324.543 197.571 323.811 198.475 323.811C199.378 323.811 200.11 324.543 200.11 325.448Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M199.443 325.448C199.443 325.979 199.013 326.41 198.482 326.41C197.951 326.41 197.521 325.979 197.521 325.448C197.521 324.917 197.951 324.486 198.482 324.486C199.013 324.486 199.443 324.917 199.443 325.448Z"
                                                fill="#FAFAFA" />
                                            <path
                                                d="M205.524 325.032C205.481 325.032 205.452 323.258 205.452 321.076C205.452 318.894 205.488 317.121 205.524 317.121C205.559 317.121 205.595 318.887 205.595 321.076C205.595 323.266 205.559 325.032 205.524 325.032Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M205.524 325.032C205.481 325.032 205.452 323.258 205.452 321.076C205.452 318.894 205.488 317.121 205.524 317.121C205.559 317.121 205.595 318.887 205.595 321.076C205.595 323.266 205.559 325.032 205.524 325.032Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M209.03 325.448C209.03 326.352 208.299 327.085 207.395 327.085C206.492 327.085 205.76 326.352 205.76 325.448C205.76 324.543 206.492 323.811 207.395 323.811C208.299 323.811 209.03 324.543 209.03 325.448Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M209.03 325.448C209.03 326.352 208.299 327.085 207.395 327.085C206.492 327.085 205.76 326.352 205.76 325.448C205.76 324.543 206.492 323.811 207.395 323.811C208.299 323.811 209.03 324.543 209.03 325.448Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M208.356 325.448C208.356 325.979 207.926 326.41 207.395 326.41C206.865 326.41 206.434 325.979 206.434 325.448C206.434 324.917 206.865 324.486 207.395 324.486C207.926 324.486 208.356 324.917 208.356 325.448Z"
                                                fill="#FAFAFA" />
                                            <path
                                                d="M207.395 322.426C207.395 322.469 207.158 322.498 206.872 322.498C206.585 322.498 206.348 322.462 206.348 322.426C206.348 322.39 206.585 322.354 206.872 322.354C207.158 322.354 207.395 322.39 207.395 322.426Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M207.395 322.426C207.395 322.469 207.158 322.498 206.872 322.498C206.585 322.498 206.348 322.462 206.348 322.426C206.348 322.39 206.585 322.354 206.872 322.354C207.158 322.354 207.395 322.39 207.395 322.426Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M378.524 202.017C378.524 202.017 390.091 203.977 391.023 204.221C391.955 204.473 395.619 206.21 395.806 207.33C395.992 208.45 395.806 211.745 395.806 211.745C395.806 211.745 395.146 212.283 394.73 211.206C394.314 210.129 394.379 207.997 394.379 207.997L392.328 207.208L393.447 209.196L393.633 213.855C393.633 213.855 392.199 213.726 391.926 212.606C391.647 211.493 391.654 210.244 391.654 210.244L390.162 208.974L391.281 210.488L391.661 213.848C391.661 213.848 390.571 214.2 390.227 213.453C389.883 212.707 389.854 210.488 389.854 210.488L385.638 209.017L382.848 210.574L377.635 207.624L378.539 202.01L378.524 202.017Z"
                                                fill="#FFBE9D" />
                                            <path
                                                d="M338.031 173.396C338.081 173.626 351.971 192.764 351.971 192.764L379.865 201.45L378.596 211.939L344.406 205.047L332.273 191.106L338.031 173.396Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M338.031 173.396C338.081 173.626 351.971 192.764 351.971 192.764L379.865 201.45L378.596 211.939L344.406 205.047L332.273 191.106L338.031 173.396Z"
                                                fill="#FB5607" />
                                            <g opacity="0.2">
                                                <path
                                                    d="M338.031 173.396C338.081 173.626 351.971 192.764 351.971 192.764L379.865 201.45L378.596 211.939L344.406 205.047L332.273 191.106L338.031 173.396Z"
                                                    fill="black" />
                                            </g>
                                            <path
                                                d="M289.442 199.735H232.45C231.242 199.735 230.262 200.715 230.262 201.924V208.665C230.262 209.874 231.242 210.855 232.45 210.855H289.442C290.65 210.855 291.629 209.874 291.629 208.665V201.924C291.629 200.715 290.65 199.735 289.442 199.735Z"
                                                fill="#F5F5F5" />
                                            <path
                                                d="M289.442 210.855C289.442 210.855 289.564 210.855 289.801 210.805C290.03 210.754 290.389 210.661 290.755 210.367C291.113 210.087 291.486 209.591 291.558 208.916C291.586 208.242 291.558 207.438 291.558 206.548C291.558 205.65 291.551 204.66 291.543 203.568C291.543 203.023 291.543 202.456 291.536 201.867C291.522 201.3 291.264 200.726 290.798 200.331C290.568 200.13 290.288 199.986 289.987 199.907C289.686 199.821 289.363 199.835 289.019 199.835C288.338 199.835 287.642 199.835 286.925 199.835C285.484 199.835 283.964 199.843 282.372 199.85C269.587 199.864 251.94 199.886 232.457 199.907C231.897 199.907 231.345 200.151 230.98 200.56C230.599 200.977 230.42 201.522 230.456 202.104C230.456 203.31 230.456 204.509 230.456 205.693C230.456 206.289 230.456 206.878 230.456 207.466V208.349C230.456 208.651 230.456 208.909 230.528 209.175C230.664 209.692 231.023 210.144 231.489 210.402C231.718 210.532 231.976 210.611 232.242 210.639C232.493 210.661 232.801 210.647 233.088 210.654C237.684 210.654 242.116 210.661 246.339 210.668C254.779 210.682 262.387 210.697 268.784 210.711C275.158 210.733 280.321 210.754 283.914 210.769C285.685 210.783 287.069 210.797 288.03 210.805L289.098 210.826C289.342 210.826 289.464 210.848 289.464 210.848C289.464 210.848 289.342 210.862 289.098 210.869L288.03 210.891C287.076 210.898 285.692 210.912 283.914 210.927C280.328 210.941 275.158 210.962 268.784 210.984C262.394 210.998 254.786 211.006 246.339 211.027C242.116 211.027 237.684 211.027 233.088 211.041C232.794 211.041 232.528 211.056 232.206 211.027C231.897 210.991 231.589 210.898 231.317 210.747C230.764 210.446 230.341 209.907 230.176 209.297C230.09 208.995 230.09 208.658 230.09 208.378V207.495C230.09 206.906 230.09 206.311 230.09 205.722C230.09 204.53 230.09 203.339 230.09 202.133C230.047 201.515 230.262 200.812 230.707 200.338C231.144 199.85 231.804 199.555 232.464 199.563C251.947 199.584 269.594 199.606 282.379 199.62C283.978 199.62 285.498 199.627 286.933 199.634C287.65 199.634 288.352 199.634 289.026 199.634C289.356 199.634 289.715 199.62 290.045 199.721C290.375 199.814 290.683 199.972 290.934 200.194C291.443 200.632 291.723 201.264 291.73 201.881C291.73 202.47 291.73 203.037 291.73 203.583C291.73 204.667 291.715 205.665 291.715 206.562C291.701 207.459 291.715 208.242 291.68 208.945C291.586 209.656 291.192 210.158 290.812 210.446C290.425 210.74 290.059 210.819 289.822 210.862C289.579 210.898 289.457 210.876 289.457 210.876L289.442 210.855Z"
                                                fill="#263238" />
                                            <path
                                                d="M444.2 352.944C460.375 352.167 472.858 338.409 472.081 322.216C471.304 306.023 457.562 293.527 441.387 294.305C425.212 295.082 412.729 308.84 413.506 325.033C414.283 341.226 428.025 353.722 444.2 352.944Z"
                                                fill="#263238" />
                                            <path
                                                d="M413.474 323.13C413.474 323.13 413.474 323.18 413.474 323.209C413.238 339.418 426.174 352.749 442.365 352.979C458.557 353.216 471.873 340.265 472.102 324.056C472.102 324.027 472.102 324.006 472.102 323.977L413.474 323.13Z"
                                                fill="#263238" />
                                            <path
                                                d="M422.208 323.331C422.043 334.709 431.129 344.07 442.494 344.235C453.86 344.4 463.21 335.305 463.375 323.927C463.54 312.548 454.455 303.187 443.089 303.022C431.724 302.857 422.373 311.953 422.208 323.331Z"
                                                fill="#FAFAFA" />
                                            <path
                                                d="M443.082 303.022C431.716 302.857 422.366 311.953 422.201 323.331L463.368 323.927C463.533 312.548 454.448 303.187 443.082 303.022Z"
                                                fill="#E0E0E0" />
                                            <path
                                                d="M430.254 323.453C430.153 330.387 435.689 336.087 442.609 336.188C449.536 336.288 455.229 330.746 455.33 323.819C455.43 316.884 449.894 311.184 442.975 311.084C436.048 310.983 430.354 316.525 430.254 323.453Z"
                                                fill="#263238" />
                                            <path
                                                d="M428.87 280.589C428.87 280.589 458.886 271.5 471.306 304.149L408.491 323.625L428.877 280.589H428.87Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M428.87 280.589C428.87 280.589 458.886 271.5 471.306 304.149L408.491 323.625L428.877 280.589H428.87Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M263.291 352.948C279.466 352.17 291.948 338.413 291.171 322.22C290.394 306.027 276.652 293.53 260.477 294.308C244.302 295.086 231.82 308.843 232.597 325.036C233.374 341.229 247.116 353.726 263.291 352.948Z"
                                                fill="#263238" />
                                            <path
                                                d="M232.572 323.13C232.572 323.13 232.572 323.18 232.572 323.209C232.335 339.418 245.271 352.749 261.462 352.979C277.654 353.216 290.97 340.265 291.199 324.056C291.199 324.027 291.199 324.006 291.199 323.977L232.572 323.13Z"
                                                fill="#263238" />
                                            <path
                                                d="M241.298 323.331C241.133 334.709 250.219 344.07 261.584 344.235C272.95 344.4 282.3 335.305 282.465 323.927C282.63 312.548 273.545 303.187 262.179 303.022C250.814 302.857 241.463 311.953 241.298 323.331Z"
                                                fill="#FAFAFA" />
                                            <path
                                                d="M262.179 303.022C250.814 302.857 241.463 311.953 241.298 323.331L282.465 323.927C282.63 312.548 273.545 303.187 262.179 303.022Z"
                                                fill="#E0E0E0" />
                                            <path
                                                d="M249.344 323.453C249.243 330.387 254.779 336.087 261.699 336.188C268.626 336.288 274.319 330.746 274.42 323.819C274.52 316.884 268.984 311.184 262.065 311.084C255.138 310.983 249.444 316.525 249.344 323.453Z"
                                                fill="#263238" />
                                            <path
                                                d="M303.583 311.845C303.418 311.931 288.152 309.483 288.152 309.483C286.481 311.665 283.928 313 281.189 313.13C274.592 313.446 268.146 313.74 262.56 313.984C257.354 314.214 253.317 318.629 253.532 323.84C253.74 328.779 257.691 332.72 262.617 332.914L295.086 334.192C300.428 334.4 307.52 331.155 310.854 326.97L303.576 311.83L303.583 311.845Z"
                                                fill="#455A64" />
                                            <path
                                                d="M223.816 298.859C223.816 298.859 222.418 270.251 249.272 264.293V260.625H343.345V269.368C343.345 269.368 329.534 286.016 334.044 299.835C338.555 313.661 339.96 315.068 339.96 315.068H393.497C393.497 315.068 399.979 306.884 400.259 294.76C400.538 282.628 395.505 261.888 391.747 248.629C388.327 236.576 386.168 226.49 386.168 226.49L402.231 221.127C402.231 221.127 431.953 260.029 433.165 262.218C434.377 264.408 438.507 269.512 437.532 280.689C436.557 291.867 409.853 326.389 402.811 330.273C395.77 334.164 389.46 334.408 383.142 335.377C377.664 336.224 337.128 335.664 326.529 335.499C322.844 335.441 319.208 334.501 316.06 332.591C312.891 330.667 310.503 327.48 307.871 322.254L302.285 311.314L223.795 298.851L223.816 298.859Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M223.816 298.859C223.816 298.859 222.418 270.251 249.272 264.293V260.625H343.345V269.368C343.345 269.368 329.534 286.016 334.044 299.835C338.555 313.661 339.96 315.068 339.96 315.068H393.497C393.497 315.068 399.979 306.884 400.259 294.76C400.538 282.628 395.505 261.888 391.747 248.629C388.327 236.576 386.168 226.49 386.168 226.49L402.231 221.127C402.231 221.127 431.953 260.029 433.165 262.218C434.377 264.408 438.507 269.512 437.532 280.689C436.557 291.867 409.853 326.389 402.811 330.273C395.77 334.164 389.46 334.408 383.142 335.377C377.664 336.224 337.128 335.664 326.529 335.499C322.844 335.441 319.208 334.501 316.06 332.591C312.891 330.667 310.503 327.48 307.871 322.254L302.285 311.314L223.795 298.851L223.816 298.859Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M231.016 296.87L219.162 315.449C217.642 317.825 220.102 320.818 222.683 319.698C223.938 319.153 225.286 318.306 226.656 316.999C232.077 311.838 241.736 298.241 241.736 298.241L231.008 296.87H231.016Z"
                                                fill="#455A64" />
                                            <path
                                                d="M315.981 300.215C315.981 300.215 315.996 300.122 316.053 299.943C316.11 299.749 316.189 299.49 316.29 299.16C316.491 298.471 316.734 297.444 316.914 296.095C317.215 293.417 317.079 289.332 315.078 284.882C314.103 282.663 312.661 280.395 310.711 278.313C308.753 276.246 306.337 274.336 303.512 272.814C300.701 271.285 297.517 270.079 294.118 269.311C290.712 268.543 287.091 268.198 283.383 268.198C279.676 268.198 276.062 268.529 272.591 268.988C269.121 269.455 265.794 270.029 262.653 270.747C256.378 272.161 250.922 274.25 246.698 276.655C242.46 279.045 239.456 281.658 237.577 283.618C236.63 284.595 235.949 285.406 235.497 285.966C235.282 286.231 235.117 286.447 234.988 286.605C234.873 286.748 234.809 286.82 234.802 286.813C234.802 286.813 235.605 285.521 237.469 283.518C239.319 281.515 242.317 278.859 246.562 276.425C250.792 273.97 256.278 271.845 262.574 270.409C265.722 269.684 269.056 269.096 272.541 268.622C276.019 268.155 279.655 267.818 283.383 267.818C287.112 267.818 290.762 268.17 294.197 268.945C297.632 269.72 300.837 270.941 303.676 272.498C306.523 274.042 308.968 275.987 310.94 278.091C312.905 280.208 314.354 282.513 315.322 284.767C317.308 289.282 317.408 293.417 317.057 296.102C316.856 297.459 316.591 298.493 316.361 299.174C316.247 299.498 316.153 299.756 316.089 299.943C316.024 300.115 315.989 300.201 315.981 300.201V300.215Z"
                                                fill="#263238" />
                                            <path
                                                d="M310.56 293.79C310.517 293.776 310.718 293.338 310.911 292.52C311.134 291.701 311.227 290.459 311.019 288.966C310.811 287.466 310.237 285.736 309.269 283.977C308.796 283.094 308.215 282.218 307.534 281.364C306.867 280.502 306.086 279.684 305.204 278.945C303.432 277.459 301.468 276.41 299.61 275.671C297.739 274.946 295.975 274.515 294.476 274.264C292.978 274.013 291.744 273.905 290.898 273.855C290.045 273.805 289.579 273.783 289.579 273.754C289.579 273.74 289.693 273.733 289.923 273.718C290.145 273.718 290.482 273.697 290.905 273.704C291.758 273.704 292.999 273.776 294.519 273.998C296.039 274.214 297.832 274.623 299.739 275.341C301.633 276.08 303.64 277.136 305.447 278.65C306.351 279.411 307.147 280.244 307.828 281.127C308.516 281.996 309.104 282.9 309.578 283.805C310.546 285.599 311.105 287.38 311.284 288.923C311.464 290.459 311.327 291.73 311.055 292.548C310.969 292.972 310.79 293.266 310.711 293.481C310.617 293.69 310.567 293.797 310.553 293.79H310.56Z"
                                                fill="#F5F5F5" />
                                            <g opacity="0.4">
                                                <path
                                                    d="M292.139 268.729C297.395 269.735 301.991 271.623 306.301 274.501C310.611 277.38 313.916 281.465 315.788 286.303C317.659 291.141 317.387 297.552 315.408 301.558L322.055 302.111C324.292 294.637 321.854 285.47 316.476 279.62C310.166 272.757 301.489 268.729 292.132 268.729"
                                                    fill="black" />
                                            </g>
                                            <path
                                                d="M290.016 210.294H231.869C228.471 210.294 225.716 213.052 225.716 216.454V254.465C225.716 257.867 228.471 260.624 231.869 260.624H290.016C293.414 260.624 296.169 257.867 296.169 254.465V216.454C296.169 213.052 293.414 210.294 290.016 210.294Z"
                                                fill="#455A64" />
                                            <path
                                                d="M296.176 221.522C296.176 221.623 280.336 221.709 260.803 221.709C241.27 221.709 225.422 221.623 225.422 221.522C225.422 221.422 241.262 221.335 260.803 221.335C280.343 221.335 296.176 221.422 296.176 221.522Z"
                                                fill="#263238" />
                                            <path
                                                d="M343.302 263.956C343.302 264.056 322.163 264.142 296.083 264.142C270.003 264.142 248.864 264.056 248.864 263.956C248.864 263.855 270.003 263.769 296.083 263.769C322.163 263.769 343.302 263.855 343.302 263.956Z"
                                                fill="#263238" />
                                            <path
                                                d="M343.345 260.625C343.345 260.625 344.894 258.772 345.044 256.403C345.195 254.034 344.112 251.084 341.574 251.084H309.09C303.827 251.084 299.56 255.355 299.56 260.625H343.345Z"
                                                fill="#455A64" />
                                            <path
                                                d="M386.175 226.49L380.525 214.695C378.983 211.343 380.209 207.359 383.379 205.471L400.273 195.385C401.155 194.861 402.166 194.581 403.191 194.581H406.841L408.304 218.421L402.675 220.575L406.239 226.375L386.175 226.49Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M386.175 226.49L380.525 214.695C378.983 211.343 380.209 207.359 383.379 205.471L400.273 195.385C401.155 194.861 402.166 194.581 403.191 194.581H406.841L408.304 218.421L402.675 220.575L406.239 226.375L386.175 226.49Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M406.899 195.442C406.899 195.442 412.678 196.77 413.403 205.686C414.127 214.609 408.304 217.38 408.304 217.38L406.892 195.435L406.899 195.442Z"
                                                fill="#EBEBEB" />
                                            <path
                                                d="M388.147 210.072C388.147 210.072 376.466 215.614 375.039 216.526C374.05 217.158 373.204 218.263 373.978 220.209C375.305 223.525 380.762 220.402 380.762 220.402L391.632 214.961C391.632 214.961 395.813 212.987 394.271 210.51C392.543 207.739 388.147 210.072 388.147 210.072Z"
                                                fill="#263238" />
                                            <path
                                                d="M371.612 208.055C371.612 208.055 382.583 209.936 383.515 210.187C384.447 210.438 388.111 212.176 388.298 213.295C388.484 214.415 388.298 217.71 388.298 217.71C388.298 217.71 387.638 218.249 387.222 217.172C386.806 216.095 386.871 213.963 386.871 213.963L384.82 213.173L385.939 215.162L386.125 219.821C386.125 219.821 384.691 219.692 384.418 218.572C384.139 217.459 384.146 216.21 384.146 216.21L382.655 214.939L383.773 216.454L384.153 219.814C384.153 219.814 383.063 220.166 382.719 219.419C382.375 218.672 382.346 216.454 382.346 216.454L378.13 214.982L375.34 216.54L370.952 214.135L371.626 208.048L371.612 208.055Z"
                                                fill="#FFBE9D" />
                                            <path
                                                d="M388.707 192.75C388.707 197.201 386.663 200.804 384.146 200.804C381.629 200.804 379.585 197.201 379.585 192.75C379.585 188.299 381.629 184.695 384.146 184.695C386.663 184.695 388.707 188.299 388.707 192.75Z"
                                                fill="#263238" />
                                            <path
                                                d="M384.892 198.285L387.395 206.978C388.513 206.411 388.75 205.291 388.563 204.408C387.932 201.429 387.581 199.311 386.885 196.698C386.799 196.432 384.885 198.277 384.885 198.277"
                                                fill="#263238" />
                                            <g opacity="0.4">
                                                <path
                                                    d="M335.285 303.553C335.034 302.835 334.783 302.103 334.546 301.349C334.324 300.646 334.059 299.921 333.872 299.225C333.528 297.975 333.327 296.69 333.248 295.951C329.018 313.194 335.479 325.334 346.564 326.188C362.763 327.437 382.518 328.341 390.507 326.245C405.07 322.419 410.412 310.265 411.689 308.255C412.965 306.252 424.546 285.054 417.447 264.645C410.348 244.236 397.971 222.563 397.971 222.563L386.175 226.497C386.175 226.497 388.334 236.576 391.754 248.636C395.512 261.895 400.546 282.634 400.266 294.767C399.986 306.899 393.504 315.075 393.504 315.075H339.967C339.967 315.075 338.82 313.927 335.285 303.553Z"
                                                    fill="black" />
                                            </g>
                                            <path
                                                d="M221.679 294.372L222.059 290.28L319.782 301.55C325.296 302.196 329.132 307.358 328.164 312.835L327.727 315.312L226.584 300.596C223.558 300.158 221.399 297.415 221.679 294.364V294.372Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M221.679 294.372L222.059 290.28L319.782 301.55C325.296 302.196 329.132 307.358 328.164 312.835L327.727 315.312L226.584 300.596C223.558 300.158 221.399 297.415 221.679 294.364V294.372Z"
                                                fill="#FB5607" />
                                            <g opacity="0.6">
                                                <path
                                                    d="M221.679 294.372L222.059 290.28L319.782 301.55C325.296 302.196 329.132 307.358 328.164 312.835L327.727 315.312L226.584 300.596C223.558 300.158 221.399 297.415 221.679 294.364V294.372Z"
                                                    fill="black" />
                                            </g>
                                            <g opacity="0.3">
                                                <path
                                                    d="M411.682 321.737C411.682 321.737 433.194 298.047 437.632 279.426C439.124 279.411 442.595 279.562 444.294 279.921C444.294 279.921 431.573 314.544 411.682 321.737Z"
                                                    fill="black" />
                                            </g>
                                            <path
                                                d="M437.324 271.084C437.324 271.084 437.374 271.285 437.439 271.68C437.496 272.075 437.611 272.656 437.683 273.41C437.819 274.917 437.912 277.143 437.518 279.842C437.13 282.541 436.205 285.685 434.678 288.945C433.187 292.218 431.121 295.599 428.985 299.138C424.675 306.238 419.878 312.039 416.393 316.188C414.643 318.255 413.195 319.906 412.191 321.048C411.703 321.593 411.316 322.024 411.029 322.347C410.757 322.642 410.613 322.792 410.606 322.785C410.599 322.778 410.721 322.613 410.972 322.297C411.244 321.967 411.617 321.514 412.083 320.947C413.08 319.756 414.471 318.076 416.192 316.016C419.627 311.83 424.374 306.008 428.669 298.945C430.813 295.405 432.871 292.046 434.37 288.801C435.904 285.571 436.844 282.469 437.26 279.806C437.69 277.136 437.64 274.939 437.539 273.431C437.489 272.678 437.396 272.096 437.367 271.694C437.324 271.299 437.31 271.084 437.324 271.084Z"
                                                fill="#263238" />
                                            <path
                                                d="M400.13 321.565C400.058 321.637 398.516 320.244 396.688 318.449C394.859 316.655 393.432 315.14 393.504 315.068C393.576 314.996 395.117 316.389 396.953 318.184C398.781 319.978 400.208 321.493 400.137 321.565H400.13Z"
                                                fill="#263238" />
                                            <path
                                                d="M336.289 320.84C336.203 320.797 336.791 319.354 337.866 317.774C338.935 316.188 340.061 315.104 340.125 315.176C340.204 315.248 339.222 316.425 338.175 317.99C337.113 319.548 336.382 320.89 336.289 320.847V320.84Z"
                                                fill="#263238" />
                                            <path
                                                d="M294.957 334.515C294.871 334.443 296.499 333.402 297.89 330.782C298.585 329.49 299.152 327.803 299.324 325.865C299.503 323.941 299.223 321.758 298.277 319.734C297.294 317.724 295.781 316.138 294.175 315.061C292.562 313.977 290.898 313.359 289.457 313.087C286.546 312.519 284.717 313.137 284.717 313.022C284.717 313.008 284.825 312.979 285.04 312.929C285.255 312.886 285.563 312.785 285.979 312.749C286.804 312.62 288.03 312.584 289.507 312.835C290.984 313.079 292.705 313.69 294.369 314.781C296.032 315.865 297.603 317.494 298.614 319.576C299.589 321.672 299.862 323.919 299.661 325.901C299.467 327.882 298.851 329.605 298.112 330.911C297.381 332.218 296.577 333.151 295.954 333.711C295.66 334.013 295.387 334.185 295.215 334.328C295.043 334.465 294.95 334.529 294.935 334.515H294.957Z"
                                                fill="#263238" />
                                            <path
                                                d="M259.268 327.014C259.168 327.014 259.01 325.47 258.917 323.561C258.823 321.651 258.838 320.1 258.938 320.093C259.039 320.093 259.196 321.63 259.29 323.546C259.383 325.456 259.368 327.006 259.268 327.014Z"
                                                fill="#263238" />
                                            <path
                                                d="M261.864 327.02C261.763 327.035 261.484 325.491 261.24 323.582C260.996 321.665 260.881 320.107 260.982 320.093C261.082 320.079 261.362 321.622 261.606 323.539C261.85 325.455 261.964 327.013 261.864 327.028V327.02Z"
                                                fill="#263238" />
                                            <path
                                                d="M302.163 260.625C302.163 260.725 290.281 260.811 275.632 260.811C260.982 260.811 249.093 260.725 249.093 260.625C249.093 260.524 260.975 260.438 275.632 260.438C290.289 260.438 302.163 260.524 302.163 260.625Z"
                                                fill="#263238" />
                                            <path
                                                d="M263.685 260.589C263.585 260.589 263.499 246.964 263.499 230.165C263.499 213.367 263.585 199.735 263.685 199.735C263.786 199.735 263.872 213.353 263.872 230.165C263.872 246.978 263.786 260.589 263.685 260.589Z"
                                                fill="#263238" />
                                            <path
                                                d="M256.414 260.539C256.314 260.539 256.823 246.921 257.547 230.13C258.279 213.339 258.953 199.728 259.053 199.735C259.153 199.735 258.644 213.353 257.92 230.144C257.189 246.935 256.515 260.539 256.414 260.539Z"
                                                fill="#263238" />
                                            <path
                                                d="M239.957 343.56C239.957 343.56 239.843 343.46 239.642 343.244C239.448 343.022 239.147 342.713 238.803 342.275C238.093 341.421 237.146 340.114 236.157 338.384C234.178 334.96 232.213 329.605 232.235 323.481C232.263 317.351 234.271 312.017 236.279 308.607C237.283 306.884 238.244 305.585 238.954 304.738C239.298 304.3 239.606 303.998 239.8 303.776C240 303.56 240.108 303.453 240.115 303.46C240.122 303.467 240.036 303.596 239.857 303.826C239.685 304.063 239.391 304.379 239.068 304.824C238.394 305.7 237.469 307.013 236.508 308.736C234.572 312.153 232.629 317.43 232.607 323.481C232.586 329.526 234.479 334.824 236.386 338.255C237.333 339.985 238.244 341.306 238.918 342.189C239.24 342.641 239.527 342.964 239.699 343.194C239.879 343.424 239.965 343.553 239.957 343.56Z"
                                                fill="#455A64" />
                                            <path
                                                d="M342.685 288.865L342.463 289.289L338.146 297.422L332.094 303.259L344.191 319.382L354.273 317.709C354.273 317.709 353.14 315.405 348.084 314.96L346.148 305.326L353.255 294.3"
                                                fill="#455A64" />
                                            <path
                                                d="M332.094 303.251L344.184 319.375L354.266 317.702L352.882 316.374L344.607 317.278L333.377 302.009L332.094 303.251Z"
                                                fill="#E0E0E0" />
                                            <path
                                                d="M347.274 310.523C347.217 310.638 346.579 310.408 345.804 310.559C345.023 310.688 344.514 311.133 344.413 311.04C344.306 310.983 344.772 310.279 345.718 310.114C346.665 309.935 347.346 310.43 347.267 310.523H347.274Z"
                                                fill="#263238" />
                                            <path
                                                d="M346.715 308.147C346.629 308.234 346.077 307.717 345.252 307.695C344.42 307.666 343.839 308.147 343.761 308.054C343.718 308.011 343.804 307.824 344.062 307.623C344.313 307.422 344.75 307.229 345.266 307.243C345.783 307.257 346.206 307.48 346.442 307.702C346.686 307.918 346.758 308.112 346.715 308.155V308.147Z"
                                                fill="#263238" />
                                            <path
                                                d="M346.263 305.053C346.163 305.125 345.718 304.601 344.98 304.472C344.241 304.335 343.646 304.68 343.574 304.572C343.538 304.529 343.646 304.364 343.904 304.213C344.162 304.063 344.585 303.94 345.058 304.027C345.525 304.113 345.883 304.364 346.077 304.594C346.27 304.823 346.313 305.01 346.263 305.046V305.053Z"
                                                fill="#263238" />
                                            <path
                                                d="M348.565 302.21C348.45 302.275 348.07 301.744 347.382 301.442C346.701 301.119 346.055 301.184 346.027 301.062C345.976 300.954 346.722 300.645 347.568 301.033C348.414 301.414 348.687 302.174 348.565 302.21Z"
                                                fill="#263238" />
                                            <path
                                                d="M349.533 299.921C349.49 299.964 349.088 299.612 348.479 299.009C348.135 298.657 347.783 298.298 347.425 297.939C347.238 297.724 347.002 297.552 346.822 297.2C346.736 297.02 346.708 296.798 346.779 296.575C346.844 296.346 347.109 296.159 347.332 296.159C347.783 296.152 348.063 296.338 348.357 296.489C348.637 296.661 348.88 296.87 349.088 297.085C349.497 297.53 349.734 298.025 349.856 298.456C350.099 299.332 349.899 299.892 349.856 299.87C349.777 299.87 349.856 299.325 349.554 298.557C349.404 298.176 349.16 297.753 348.787 297.372C348.601 297.185 348.378 297.013 348.135 296.87C347.898 296.733 347.59 296.59 347.375 296.604C347.274 296.618 347.231 296.654 347.202 296.726C347.174 296.805 347.181 296.92 347.224 297.013C347.317 297.221 347.547 297.437 347.733 297.652C348.07 298.04 348.393 298.413 348.716 298.786C349.268 299.44 349.583 299.87 349.54 299.913L349.533 299.921Z"
                                                fill="#263238" />
                                            <path
                                                d="M349.949 300.157C349.899 300.157 349.848 299.626 350.293 298.93C350.73 298.269 351.792 297.458 353.19 297.896C353.297 297.961 353.391 298.09 353.405 298.233C353.419 298.377 353.384 298.485 353.333 298.571C353.24 298.75 353.118 298.844 353.025 298.951C352.817 299.152 352.602 299.332 352.38 299.475C351.942 299.77 351.498 299.956 351.118 300.064C350.35 300.279 349.848 300.208 349.856 300.157C349.856 300.086 350.329 300.042 351.017 299.763C351.361 299.626 351.756 299.425 352.143 299.131C352.337 298.987 352.53 298.822 352.717 298.635C352.81 298.535 352.903 298.442 352.939 298.363C352.975 298.269 352.968 298.291 352.939 298.269C352.903 298.241 352.76 298.219 352.631 298.212C352.502 298.205 352.372 298.205 352.251 298.212C352 298.233 351.763 298.298 351.541 298.384C351.103 298.556 350.773 298.836 350.544 299.116C350.085 299.684 350.013 300.172 349.942 300.157H349.949Z"
                                                fill="#263238" />
                                            <path
                                                d="M340.082 301.608C340.19 302.268 339.745 302.893 339.085 303.007C338.426 303.115 337.802 302.67 337.687 302.01C337.579 301.349 338.024 300.725 338.684 300.61C339.343 300.502 339.967 300.947 340.082 301.608Z"
                                                fill="#E0E0E0" />
                                            <path
                                                d="M379.399 296.619L382.633 317.638L408.777 313.747C408.254 311.27 393.977 308.262 393.977 308.262L392.457 294.709L379.392 296.619H379.399Z"
                                                fill="#455A64" />
                                            <path
                                                d="M385.731 308.334C385.243 308.55 384.978 309.167 385.171 309.662C385.365 310.158 385.996 310.431 386.484 310.23C386.971 310.021 387.315 309.289 387.064 308.815C386.813 308.342 386.061 308.062 385.637 308.377"
                                                fill="#E0E0E0" />
                                            <path
                                                d="M382.633 317.638L382.389 315.506L407.551 312.57C407.551 312.57 408.792 312.9 408.785 313.747L382.64 317.638H382.633Z"
                                                fill="#E0E0E0" />
                                            <path
                                                d="M394.386 308.068C394.4 308.198 393.769 308.348 393.203 308.858C392.622 309.346 392.378 309.949 392.256 309.913C392.134 309.906 392.213 309.117 392.909 308.514C393.597 307.911 394.393 307.946 394.386 308.068Z"
                                                fill="#263238" />
                                            <path
                                                d="M397.297 308.794C397.347 308.916 396.824 309.21 396.472 309.82C396.1 310.416 396.078 311.019 395.949 311.026C395.834 311.062 395.633 310.33 396.085 309.583C396.53 308.837 397.276 308.672 397.297 308.794Z"
                                                fill="#263238" />
                                            <path
                                                d="M399.341 311.845C399.226 311.888 398.953 311.277 399.183 310.531C399.398 309.777 399.965 309.411 400.029 309.511C400.115 309.605 399.785 310.036 399.613 310.66C399.427 311.27 399.47 311.816 399.341 311.852V311.845Z"
                                                fill="#263238" />
                                            <path
                                                d="M393.697 305.018C393.661 305.14 393.052 305.054 392.335 305.211C391.618 305.355 391.094 305.678 391.008 305.578C390.922 305.499 391.396 304.939 392.242 304.766C393.081 304.587 393.74 304.903 393.697 305.018Z"
                                                fill="#263238" />
                                            <path
                                                d="M392.615 302.002C392.622 302.053 392.134 302.211 391.302 302.189C390.894 302.182 390.399 302.117 389.868 301.974C389.603 301.902 389.33 301.809 389.058 301.687C388.929 301.629 388.771 301.572 388.613 301.435C388.456 301.32 388.319 300.997 388.456 300.768C388.563 300.545 388.785 300.423 388.972 300.394C389.165 300.359 389.323 300.373 389.474 300.394C389.775 300.423 390.062 300.481 390.327 300.552C390.858 300.703 391.31 300.933 391.654 301.163C392.342 301.636 392.622 302.081 392.579 302.11C392.529 302.16 392.17 301.801 391.489 301.435C391.145 301.249 390.714 301.069 390.22 300.947C389.969 300.89 389.71 300.847 389.431 300.825C389.144 300.796 388.907 300.825 388.857 300.962C388.836 301.012 388.836 301.033 388.907 301.105C388.979 301.17 389.101 301.227 389.23 301.285C389.481 301.399 389.739 301.5 389.983 301.579C390.471 301.737 390.929 301.83 391.324 301.873C392.105 301.974 392.6 301.931 392.607 302.002H392.615Z"
                                                fill="#263238" />
                                            <path
                                                d="M392.471 302.211C392.428 302.24 392.105 301.816 391.94 300.998C391.854 300.589 391.826 300.086 391.905 299.533C391.948 299.261 392.012 298.973 392.12 298.686C392.234 298.406 392.371 298.033 392.858 297.897C393.117 297.846 393.36 298.019 393.461 298.184C393.575 298.349 393.611 298.5 393.669 298.643C393.762 298.945 393.798 299.239 393.798 299.526C393.798 300.093 393.64 300.596 393.439 300.962C393.03 301.716 392.521 301.945 392.5 301.909C392.45 301.852 392.858 301.536 393.152 300.825C393.296 300.474 393.403 300.029 393.382 299.533C393.375 299.289 393.332 299.031 393.246 298.78C393.167 298.507 393.023 298.299 392.923 298.342C392.794 298.356 392.6 298.6 392.528 298.837C392.428 299.088 392.356 299.347 392.306 299.598C392.213 300.093 392.206 300.56 392.249 300.94C392.328 301.716 392.536 302.175 392.471 302.204V302.211Z"
                                                fill="#263238" />
                                            <path d="M358.826 247.243L336.396 296.159L351.211 305.06L382.21 246.202"
                                                fill="#263238" />
                                            <path
                                                d="M395.798 306.173L379.707 308.757L370.077 251.227L322.499 254.68C321.237 254.759 319.968 254.651 318.749 254.314C305.383 250.646 307.197 233.596 308.481 230.861L374.315 228.966C381.457 228.758 387.609 233.962 388.599 241.048L395.791 306.166L395.798 306.173Z"
                                                fill="#263238" />
                                            <path
                                                d="M307.835 233.568L308.072 209.246C308.072 209.246 304.938 193.432 304.006 187.215C302.565 177.559 300.593 172.979 316.383 166.116L319.832 164.781L325.174 164.853C331.549 165.334 338.261 171.099 338.411 174.925L344.556 229.734L307.821 233.575L307.835 233.568Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M307.835 233.568L308.072 209.246C308.072 209.246 304.938 193.432 304.006 187.215C302.565 177.559 300.593 172.979 316.383 166.116L319.832 164.781L325.174 164.853C331.549 165.334 338.261 171.099 338.411 174.925L344.556 229.734L307.821 233.575L307.835 233.568Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M308.825 171.773C308.825 171.773 304.372 181.379 305.261 190.129L321.875 206.095C325.604 210.244 330.258 212.01 336.217 212.369L370.593 216.131L371.547 207.129L338.841 197.854C337.543 197.617 336.891 196.253 335.894 195.384L308.825 171.781"
                                                fill="#FB5607" />
                                            <path
                                                d="M308.825 171.773C308.825 171.773 304.372 181.379 305.261 190.129L321.875 206.095C325.604 210.244 330.258 212.01 336.217 212.369L370.593 216.131L371.547 207.129L338.841 197.854C337.543 197.617 336.891 196.253 335.894 195.384L308.825 171.781"
                                                fill="#FB5607" />
                                            <path
                                                d="M306.143 174.544C306.143 174.544 306.329 174.336 306.803 174.099C307.276 173.869 308.022 173.633 309.026 173.475C310.022 173.331 311.284 173.223 312.74 173.482C313.098 173.568 313.479 173.654 313.83 173.855C314.174 174.056 314.504 174.293 314.841 174.544C315.508 175.061 316.175 175.65 316.849 176.303C318.226 177.588 319.531 179.218 321.058 180.869C322.578 182.527 324.256 184.293 326.077 186.152C327.892 188.012 329.849 189.957 331.95 191.967C333.004 192.965 334.087 193.984 335.234 194.982C335.815 195.463 336.389 196.023 336.941 196.547C337.5 197.064 338.139 197.545 338.87 197.681H338.884C348.608 200.438 359.765 203.597 371.59 206.942L371.741 206.985L371.726 207.143C371.662 207.782 371.583 208.471 371.511 209.16C371.26 211.551 371.009 213.92 370.773 216.145L370.751 216.332L370.565 216.31C365.567 215.757 360.698 215.226 356.015 214.709C353.67 214.451 351.376 214.2 349.131 213.948C346.88 213.719 344.685 213.496 342.541 213.281C340.397 213.044 338.318 212.8 336.303 212.505C334.288 212.211 332.33 211.838 330.53 211.163C328.723 210.502 327.11 209.555 325.662 208.55C324.206 207.538 322.887 206.482 321.646 205.441C316.734 201.242 313.127 197.495 310.625 194.939C309.384 193.654 308.43 192.642 307.792 191.953C307.484 191.615 307.247 191.35 307.075 191.163C306.917 190.984 306.838 190.883 306.838 190.883C306.838 190.883 306.932 190.962 307.097 191.134C307.276 191.314 307.52 191.572 307.842 191.902C308.509 192.584 309.477 193.575 310.718 194.846C313.249 197.373 316.885 201.091 321.804 205.255C323.044 206.281 324.371 207.329 325.819 208.327C327.261 209.325 328.853 210.251 330.631 210.89C332.409 211.551 334.338 211.909 336.353 212.197C338.361 212.484 340.44 212.728 342.584 212.958C344.729 213.173 346.923 213.388 349.174 213.611C351.419 213.855 353.721 214.106 356.058 214.357C360.741 214.867 365.61 215.398 370.615 215.944L370.407 216.109C370.643 213.884 370.894 211.515 371.145 209.124C371.217 208.435 371.289 207.746 371.361 207.107L371.497 207.308C359.672 203.948 348.522 200.775 338.798 198.011H338.813C337.967 197.854 337.292 197.322 336.719 196.798C336.138 196.246 335.615 195.729 335.019 195.233C333.872 194.228 332.782 193.202 331.728 192.197C329.634 190.18 327.684 188.22 325.87 186.353C324.063 184.487 322.392 182.714 320.872 181.041C319.344 179.376 318.061 177.746 316.705 176.461C316.038 175.808 315.379 175.219 314.726 174.702C314.396 174.451 314.074 174.207 313.744 174.013C313.421 173.819 313.048 173.733 312.704 173.647C311.284 173.374 310.022 173.467 309.033 173.59C308.036 173.726 307.29 173.941 306.817 174.157C306.344 174.372 306.15 174.566 306.136 174.551L306.143 174.544Z"
                                                fill="#263238" />
                                            <path
                                                d="M314.719 143.69L316.39 167.366C316.663 171.228 319.875 174.229 323.747 174.229C328.007 174.229 331.384 170.618 331.104 166.361C330.954 164.107 330.825 162.262 330.825 162.262C330.825 162.262 336.547 161.371 336.619 155.643C336.662 152.333 336.088 144.824 335.6 139.067C335.271 135.176 332.015 132.19 328.114 132.19H324.658C318.699 132.542 314.21 137.739 314.719 143.69Z"
                                                fill="#FFBE9D" />
                                            <path
                                                d="M330.832 162.183C330.832 162.183 327.211 162.477 323.367 160.058C323.367 160.058 325.131 164.185 330.846 163.669L330.832 162.183Z"
                                                fill="#EB996E" />
                                            <path
                                                d="M334.31 146.432C334.324 146.863 333.973 147.236 333.521 147.258C333.069 147.279 332.696 146.949 332.675 146.518C332.66 146.088 333.012 145.714 333.464 145.693C333.915 145.671 334.295 146.002 334.31 146.432Z"
                                                fill="#263238" />
                                            <path
                                                d="M334.611 144.817C334.51 144.925 333.894 144.465 333.012 144.465C332.13 144.458 331.484 144.91 331.391 144.803C331.341 144.752 331.448 144.566 331.728 144.358C332.008 144.157 332.474 143.956 333.026 143.956C333.571 143.956 334.037 144.164 334.302 144.365C334.575 144.573 334.668 144.767 334.618 144.81L334.611 144.817Z"
                                                fill="#263238" />
                                            <path
                                                d="M326.049 146.432C326.063 146.863 325.712 147.236 325.26 147.258C324.808 147.279 324.436 146.949 324.414 146.518C324.4 146.088 324.751 145.714 325.203 145.693C325.655 145.671 326.027 146.002 326.049 146.432Z"
                                                fill="#263238" />
                                            <path
                                                d="M325.963 144.982C325.862 145.09 325.239 144.63 324.364 144.63C323.482 144.623 322.836 145.075 322.743 144.968C322.7 144.917 322.801 144.731 323.08 144.523C323.36 144.322 323.826 144.121 324.378 144.121C324.923 144.121 325.389 144.329 325.655 144.53C325.927 144.738 326.013 144.932 325.97 144.975L325.963 144.982Z"
                                                fill="#263238" />
                                            <path
                                                d="M329.154 151.515C329.154 151.464 329.699 151.371 330.581 151.256C330.803 151.235 331.018 151.192 331.054 151.034C331.104 150.869 331.011 150.632 330.903 150.366C330.696 149.821 330.473 149.253 330.237 148.65C329.312 146.21 328.645 144.207 328.745 144.171C328.845 144.135 329.67 146.08 330.595 148.521C330.817 149.124 331.033 149.699 331.233 150.244C331.319 150.503 331.463 150.79 331.348 151.127C331.291 151.292 331.126 151.414 330.982 151.457C330.839 151.5 330.71 151.5 330.602 151.508C329.713 151.558 329.154 151.558 329.154 151.508V151.515Z"
                                                fill="#263238" />
                                            <path
                                                d="M326.565 152.125C326.709 152.118 326.709 153.073 327.526 153.755C328.344 154.437 329.362 154.329 329.369 154.458C329.383 154.516 329.14 154.645 328.709 154.659C328.286 154.674 327.67 154.537 327.175 154.121C326.673 153.704 326.465 153.152 326.429 152.757C326.393 152.355 326.501 152.118 326.565 152.125Z"
                                                fill="#263238" />
                                            <path
                                                d="M326.192 141.529C326.106 141.766 325.224 141.658 324.199 141.78C323.166 141.881 322.334 142.19 322.198 141.974C322.134 141.874 322.284 141.644 322.621 141.414C322.951 141.185 323.489 140.962 324.106 140.89C324.722 140.826 325.296 140.919 325.669 141.077C326.049 141.228 326.235 141.414 326.199 141.529H326.192Z"
                                                fill="#263238" />
                                            <path
                                                d="M334.288 142.269C334.13 142.47 333.528 142.262 332.796 142.254C332.065 142.218 331.448 142.391 331.312 142.183C331.248 142.082 331.348 141.881 331.613 141.694C331.879 141.508 332.323 141.35 332.825 141.364C333.327 141.379 333.757 141.558 334.016 141.766C334.274 141.974 334.36 142.175 334.288 142.276V142.269Z"
                                                fill="#263238" />
                                            <path
                                                d="M316.648 147.998C316.548 147.955 312.719 146.835 312.84 150.754C312.962 154.674 316.87 153.741 316.87 153.626C316.87 153.511 316.648 147.998 316.648 147.998Z"
                                                fill="#FFBE9D" />
                                            <path
                                                d="M315.63 152.176C315.63 152.176 315.565 152.226 315.451 152.284C315.343 152.341 315.149 152.377 314.941 152.312C314.525 152.176 314.153 151.53 314.11 150.819C314.088 150.46 314.153 150.123 314.267 149.836C314.375 149.548 314.554 149.34 314.762 149.297C314.97 149.24 315.121 149.362 315.171 149.469C315.228 149.577 315.207 149.656 315.228 149.663C315.243 149.67 315.307 149.592 315.271 149.434C315.25 149.355 315.207 149.268 315.106 149.19C315.013 149.118 314.87 149.082 314.726 149.103C314.425 149.132 314.16 149.419 314.031 149.735C313.887 150.051 313.808 150.431 313.83 150.833C313.88 151.623 314.31 152.348 314.877 152.492C315.157 152.556 315.379 152.463 315.494 152.37C315.608 152.269 315.63 152.183 315.615 152.176H315.63Z"
                                                fill="#EB996E" />
                                            <path
                                                d="M314.475 147.861C315.071 147.718 316.103 148.27 316.361 148.83C316.619 149.39 316.67 150.022 316.928 150.582C317.179 151.142 317.752 151.644 318.355 151.508C318.763 151.407 319.065 151.027 319.172 150.611C319.28 150.201 319.237 149.771 319.187 149.347C318.957 147.517 318.57 145.7 318.498 143.863C318.426 142.018 318.685 140.108 319.653 138.536C320.621 136.964 322.392 135.808 324.228 135.959C325.447 136.059 326.558 136.691 327.77 136.863C329.204 137.064 330.717 136.555 331.742 135.535C331.872 135.406 332.488 135.004 332.488 135.004C332.488 134.911 332.402 134.092 332.08 133.791C329.684 131.573 325.361 130.955 322.198 131.752C319.029 132.549 316.06 134.789 314.698 137.761C313.335 140.733 313.737 144.86 314.49 147.868"
                                                fill="#263238" />
                                            <path
                                                d="M335.665 138.184C335.665 138.184 320.649 133.346 314.153 146.354C314.153 146.354 313.185 143.102 313.185 141.357C313.185 140.194 313.88 133.253 321.015 131.07C321.015 131.07 331.764 126.964 335.672 138.192L335.665 138.184Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M335.665 138.184C335.665 138.184 320.649 133.346 314.153 146.354C314.153 146.354 313.185 143.102 313.185 141.357C313.185 140.194 313.88 133.253 321.015 131.07C321.015 131.07 331.764 126.964 335.672 138.192L335.665 138.184Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M322.758 138.515C323.288 139.376 324.235 139.957 325.239 140.051C326.242 140.144 327.282 139.735 327.956 138.988C328.25 139.728 329.046 140.237 329.842 140.194C330.638 140.151 331.377 139.563 331.592 138.795C332.029 139.218 332.481 139.656 333.055 139.864C333.628 140.072 334.345 139.993 334.725 139.512C335.105 139.024 334.998 138.285 334.625 137.789C334.252 137.294 333.671 137 333.105 136.763C331.319 136.016 329.355 135.643 327.44 135.901C325.525 136.16 323.668 137.093 322.471 138.608"
                                                fill="#263238" />
                                            <g opacity="0.4">
                                                <path
                                                    d="M335.665 138.184C335.665 138.184 333.958 136.146 330.889 136.017C326.458 135.823 318.168 138.314 314.153 146.361C314.153 146.361 313.185 143.109 313.185 141.365C313.185 140.202 313.88 133.26 321.015 131.078C321.015 131.078 331.764 126.971 335.672 138.199L335.665 138.184Z"
                                                    fill="black" />
                                            </g>
                                            <path
                                                d="M314.777 144.832C317.007 141.422 320.076 138.601 323.525 136.44C326.974 134.279 332.682 132.147 336.619 131.099C337.802 130.783 339.028 130.51 340.233 130.718C341.437 130.927 342.613 131.731 342.914 132.915C343.287 134.401 340.656 136.691 339.422 137.588C338.189 138.493 335.665 139.814 335.665 139.814C335.665 139.814 335.701 137.057 331.298 136.49C325.31 135.715 314.784 144.825 314.784 144.825L314.777 144.832Z"
                                                fill="#FB5607" />
                                            <path
                                                d="M314.777 144.832C317.007 141.422 320.076 138.601 323.525 136.44C326.974 134.279 332.682 132.147 336.619 131.099C337.802 130.783 339.028 130.51 340.233 130.718C341.437 130.927 342.613 131.731 342.914 132.915C343.287 134.401 340.656 136.691 339.422 137.588C338.189 138.493 335.665 139.814 335.665 139.814C335.665 139.814 335.701 137.057 331.298 136.49C325.31 135.715 314.784 144.825 314.784 144.825L314.777 144.832Z"
                                                fill="#FB5607" />
                                            <g opacity="0.3">
                                                <path
                                                    d="M309.492 193.683C311.041 197.423 312.604 202.039 314.848 205.406C317.093 208.773 320.09 211.759 323.826 213.324C328.508 215.284 334.051 215.607 338.712 213.59C339.092 213.425 339.838 213.216 339.766 212.807C339.766 212.807 338.225 212.635 337.744 212.556C328.322 210.962 327.304 209.799 322.793 206.232C319.982 204.006 313.751 197.28 309.492 193.683Z"
                                                    fill="black" />
                                            </g>
                                            <path
                                                d="M339.429 220.919C339.429 220.919 339.329 221.249 339.035 221.795C338.748 222.34 338.253 223.094 337.515 223.92C336.052 225.585 333.456 227.387 330.222 228.385C326.988 229.383 323.919 229.562 321.732 229.656C320.635 229.699 319.746 229.706 319.136 229.706C318.52 229.706 318.183 229.691 318.183 229.663C318.183 229.634 318.52 229.605 319.129 229.562C319.818 229.519 320.685 229.462 321.718 229.397C323.89 229.239 326.931 229.009 330.115 228.033C333.291 227.05 335.851 225.327 337.328 223.74C338.834 222.161 339.365 220.876 339.437 220.919H339.429Z"
                                                fill="#263238" />
                                            <path
                                                d="M380.001 310.473C380.001 310.473 379.973 310.402 379.944 310.251C379.908 310.078 379.865 309.863 379.815 309.59C379.707 308.987 379.549 308.133 379.356 307.042C378.969 304.802 378.409 301.608 377.728 297.666C376.387 289.727 374.537 278.794 372.493 266.719C371.583 261.256 370.715 256.023 369.919 251.249L370.106 251.392C361.752 252.003 354.603 252.527 349.519 252.9C347.009 253.072 345.008 253.209 343.61 253.302C342.943 253.338 342.42 253.374 342.032 253.395C341.867 253.395 341.731 253.41 341.624 253.41C341.53 253.41 341.487 253.41 341.487 253.41C341.487 253.41 341.53 253.395 341.624 253.381C341.731 253.367 341.867 253.352 342.025 253.338C342.405 253.302 342.929 253.252 343.595 253.187C344.994 253.065 346.994 252.9 349.497 252.685C354.574 252.283 361.716 251.708 370.07 251.041L370.228 251.026L370.256 251.184C371.059 255.951 371.941 261.184 372.859 266.647C374.86 278.729 376.674 289.669 377.986 297.616C378.624 301.565 379.141 304.766 379.499 307.006C379.664 308.097 379.8 308.951 379.894 309.562C379.929 309.842 379.965 310.057 379.987 310.229C380.008 310.38 380.016 310.459 380.008 310.459L380.001 310.473Z"
                                                fill="#455A64" />
                                            <path
                                                d="M374.91 246.102C374.975 246.188 373.727 247.265 372.3 248.715C370.873 250.158 369.819 251.436 369.733 251.364C369.654 251.306 370.586 249.914 372.035 248.449C373.476 246.978 374.853 246.023 374.91 246.095V246.102Z"
                                                fill="#455A64" />
                                            <path
                                                d="M330.961 166.871C330.961 166.871 331.004 166.95 331.047 167.108C331.097 167.266 331.14 167.502 331.183 167.811C331.255 168.428 331.219 169.362 330.832 170.424C330.445 171.472 329.692 172.65 328.473 173.533C327.261 174.416 325.583 174.875 323.869 174.76C322.148 174.645 320.571 173.999 319.402 173.087C318.219 172.183 317.408 171.092 316.863 170.123C316.325 169.139 316.039 168.285 315.895 167.682C315.823 167.38 315.773 167.144 315.752 166.986C315.73 166.828 315.723 166.741 315.737 166.734C315.816 166.706 315.996 168.105 317.1 169.993C317.659 170.92 318.469 171.96 319.617 172.815C320.75 173.676 322.263 174.279 323.905 174.394C325.54 174.502 327.125 174.071 328.286 173.253C329.455 172.441 330.194 171.329 330.602 170.331C330.997 169.326 331.083 168.429 331.054 167.825C331.033 167.215 330.939 166.885 330.975 166.878L330.961 166.871Z"
                                                fill="#263238" />
                                            <path
                                                d="M341.072 198.22C341.072 198.22 340.993 197.954 340.921 197.473C340.842 196.906 340.742 196.224 340.634 195.42C340.398 193.59 340.089 191.235 339.752 188.636C339.43 185.98 339.171 183.575 339.014 181.831C338.935 180.955 338.877 180.252 338.849 179.763C338.82 179.275 338.813 179.002 338.841 179.002C338.87 179.002 338.92 179.268 338.992 179.749C339.071 180.316 339.164 180.998 339.272 181.802C339.501 183.633 339.795 185.987 340.118 188.593C340.441 191.242 340.72 193.647 340.892 195.391C340.978 196.267 341.036 196.971 341.064 197.459C341.093 197.947 341.1 198.22 341.072 198.22Z"
                                                fill="#263238" />
                                        </g>
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_3_4027">
                                            <rect width="501" height="411" fill="white" />
                                        </clipPath>
                                        <clipPath id="clip1_3_4027">
                                            <rect width="502" height="296" fill="white" transform="translate(-1 57)" />
                                        </clipPath>
                                    </defs>
                                </svg>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Tab Pan -->
                @endif


            </div>
            <!-- Tab Content -->

        </div>
    </section>
    <!-- ======= Platform Section ======= -->

    <!-- ======= Choose Section ======= -->
    @php($speciality = \App\Models\BusinessSetting::where(['key' => 'speciality'])->first())
    @php($speciality = isset($speciality->value) ? json_decode($speciality->value, true) : null)
    @if (isset($speciality) && count($speciality) > 0)
    <section class="choose-section overflow-hidden pt-80">
        <div class="container">
            <div class="section-header text-center wow fadeInUp">
                <h2 class=" title">
                    <span class="text-base">  {{ isset($landing_page_text) ? $landing_page_text['why_choose_us'] : '' }}
                    </span>
                </h2>
                <p>
                    {{ isset($landing_page_text) ? $landing_page_text['why_choose_us_title'] : '' }}
                </p>
            </div>
            <div class="choose-wrapper">
                @foreach ($speciality as $sp)
                <div class="choose-item wow animate__dropIn">
                    <img
                    src="{{ asset('public/assets/landing') }}/image/{{ $sp['img'] }}"
                    alt="Image">
                    <div class="choose-item-content">
                        <div class="cont">
                            <h4 class="title">
                                {{ $sp['title'] }}
                            </h4>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </section>
    @endif
    <!-- ======= Choose Section ======= -->
    @if ($toggle_dm_registration || $toggle_restaurant_registration)
    <!-- ======= Lets Start Section ======= -->
    <section class="lets-start-section pt-80 pb-80">
        <div class="container">
            <div class="section-header text-center wow fadeInUp">
                <h2 class="title mb-lg-5">
                    <span class="text-base">  {{ isset($landing_page_text['join_us_title']) ? $landing_page_text['join_us_title'] : '' }}
                    </span>
                    </h2>
                <p>
                    {{ isset($landing_page_text['join_us_article']) ? $landing_page_text['join_us_article'] : '' }}
                </p>
            </div>
        </div>
        <!-- Lets Start SVG Start -->
        <div class="wow fadeInUp">
            <svg style="width:100%" viewBox="0 0 1440 228" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path
                    d="M621.642 59.3262H565.661C565.661 59.3262 568.673 52.302 578.736 54.4849C578.736 54.4849 580.857 46.5003 588.538 47.6063C588.538 47.6063 594.891 40.7083 604.16 43.386C613.429 46.0638 612.635 54.4849 612.635 54.4849C612.635 54.4849 619.521 52.6901 621.642 59.3262Z"
                    fill="#FAFAFA" />
                <path
                    d="M471.802 16.5605H527.782C527.782 16.5605 524.77 9.53641 514.707 11.7193C514.707 11.7193 512.586 3.73471 504.906 4.84072C504.906 4.84072 498.552 -2.05728 489.283 0.620425C480.015 3.29813 480.809 11.7193 480.809 11.7193C480.809 11.7193 473.923 9.92449 471.802 16.5605Z"
                    fill="#FAFAFA" />
                <path
                    d="M430.523 14.7368H387.695C387.695 14.7368 389.332 8.82836 395.53 10.759C395.53 10.759 394.252 2.83262 398.814 1.92065C403.366 1.00868 404.828 7.03352 404.828 7.03352C404.828 7.03352 408.112 3.01696 413.39 4.48194C418.678 5.94691 419.589 10.759 419.589 10.759C419.589 10.759 427.24 6.36409 430.523 14.7368Z"
                    fill="#FAFAFA" />
                <path d="M597.749 195.725H662.701V66.8188H597.749V195.725Z" fill="#E7E7E7" />
                <path d="M609.558 195.725H662.701V66.8188H609.558V195.725Z" fill="#F0F0F0" />
                <path d="M597 68.9233L664.114 68.9233V66.8187L597 66.8187V68.9233Z" fill="#E1E1E1" />
                <path d="M597 64.7139L664.114 64.7139V62.6092L597 62.6092V64.7139Z" fill="#E1E1E1" />
                <path d="M598.413 66.8184L662.713 66.8184V64.7137L598.413 64.7137V66.8184Z" fill="#F0F0F0" />
                <path d="M647.679 84.5635H657.666V74.415H647.679V84.5635Z" fill="#E7E7E7" />
                <path d="M647.68 84.5635H656.784V74.415H647.68V84.5635Z" fill="#F5F5F5" />
                <path d="M632.561 84.5635H642.547V74.415H632.561V84.5635Z" fill="#E7E7E7" />
                <path d="M632.573 84.5635H641.678V74.415H632.573V84.5635Z" fill="#F5F5F5" />
                <path d="M617.443 84.5635H627.429V74.415H617.443V84.5635Z" fill="#E7E7E7" />
                <path d="M617.443 84.5635H626.548V74.415H617.443V84.5635Z" fill="#F5F5F5" />
                <path d="M647.679 99.5015H657.666V89.353H647.679V99.5015Z" fill="#E7E7E7" />
                <path d="M647.68 99.5015H656.784V89.353H647.68V99.5015Z" fill="#F5F5F5" />
                <path d="M632.561 99.5015H642.547V89.353H632.561V99.5015Z" fill="#E7E7E7" />
                <path d="M632.573 99.5015H641.678V89.353H632.573V99.5015Z" fill="#F5F5F5" />
                <path d="M617.443 99.5015H627.429V89.353H617.443V99.5015Z" fill="#E7E7E7" />
                <path d="M617.443 99.5015H626.548V89.353H617.443V99.5015Z" fill="#F5F5F5" />
                <path d="M647.679 126.875H657.666V116.726H647.679V126.875Z" fill="#E7E7E7" />
                <path d="M647.68 126.875H656.784V116.726H647.68V126.875Z" fill="#F5F5F5" />
                <path d="M632.561 126.875H642.547V116.726H632.561V126.875Z" fill="#E7E7E7" />
                <path d="M632.573 126.875H641.678V116.726H632.573V126.875Z" fill="#F5F5F5" />
                <path d="M617.443 126.875H627.429V116.726H617.443V126.875Z" fill="#E7E7E7" />
                <path d="M617.443 126.875H626.548V116.726H617.443V126.875Z" fill="#F5F5F5" />
                <path d="M647.679 141.825H657.666V131.677H647.679V141.825Z" fill="#E7E7E7" />
                <path d="M647.68 141.825H656.784V131.677H647.68V141.825Z" fill="#F5F5F5" />
                <path d="M632.561 141.825H642.547V131.677H632.561V141.825Z" fill="#E7E7E7" />
                <path d="M632.573 141.825H641.678V131.677H632.573V141.825Z" fill="#F5F5F5" />
                <path d="M617.443 141.825H627.429V131.677H617.443V141.825Z" fill="#E7E7E7" />
                <path d="M617.443 141.825H626.548V131.677H617.443V141.825Z" fill="#F5F5F5" />
                <path d="M647.679 172.246H657.666V162.098H647.679V172.246Z" fill="#E7E7E7" />
                <path d="M647.68 172.246H656.784V162.098H647.68V172.246Z" fill="#F5F5F5" />
                <path d="M632.561 172.246H642.547V162.098H632.561V172.246Z" fill="#E7E7E7" />
                <path d="M632.573 172.246H641.678V162.098H632.573V172.246Z" fill="#F5F5F5" />
                <path d="M617.443 172.246H627.429V162.098H617.443V172.246Z" fill="#E7E7E7" />
                <path d="M617.443 172.246H626.548V162.098H617.443V172.246Z" fill="#F5F5F5" />
                <path d="M647.679 187.186H657.666V177.037H647.679V187.186Z" fill="#E7E7E7" />
                <path d="M647.68 187.186H656.784V177.037H647.68V187.186Z" fill="#F5F5F5" />
                <path d="M632.561 187.186H642.547V177.037H632.561V187.186Z" fill="#E7E7E7" />
                <path d="M632.573 187.186H641.678V177.037H632.573V187.186Z" fill="#F5F5F5" />
                <path d="M617.443 187.186H627.429V177.037H617.443V187.186Z" fill="#E7E7E7" />
                <path d="M617.443 187.186H626.548V177.037H617.443V187.186Z" fill="#F5F5F5" />
                <path d="M597.749 107.582L662.701 107.582V106.639L597.749 106.639V107.582Z" fill="#E1E1E1" />
                <path d="M597.749 154.369H662.701V153.426H597.749V154.369Z" fill="#E1E1E1" />
                <path d="M283 196.452H356.44V17.4584H283V196.452Z" fill="#E1E1E1" />
                <path d="M303.92 196.452H356.44V17.4584H303.92V196.452Z" fill="#F0F0F0" />
                <path d="M331.499 41.6943H351.037V32.1855H331.499V41.6943Z" fill="#E7E7E7" />
                <path d="M331.499 41.6943H349.738V32.1855H331.499V41.6943Z" fill="#F5F5F5" />
                <path d="M308.894 41.6943H328.432V32.1855H308.894V41.6943Z" fill="#E7E7E7" />
                <path d="M308.88 41.6943H327.119V32.1855H308.88V41.6943Z" fill="#F5F5F5" />
                <path d="M331.499 59.5771H351.037V50.0683H331.499V59.5771Z" fill="#E7E7E7" />
                <path d="M331.499 59.5771H349.738V50.0683H331.499V59.5771Z" fill="#F5F5F5" />
                <path d="M308.894 59.5771H328.432V50.0683H308.894V59.5771Z" fill="#E7E7E7" />
                <path d="M308.88 59.5771H327.119V50.0683H308.88V59.5771Z" fill="#F5F5F5" />
                <path d="M331.499 82.4282H351.037V72.9193H331.499V82.4282Z" fill="#E7E7E7" />
                <path d="M331.499 82.4282H349.738V72.9193H331.499V82.4282Z" fill="#F5F5F5" />
                <path d="M308.894 82.4282H328.432V72.9193H308.894V82.4282Z" fill="#E7E7E7" />
                <path d="M308.88 82.4282H327.119V72.9193H308.88V82.4282Z" fill="#F5F5F5" />
                <path d="M331.499 95.5776H351.037V86.0688H331.499V95.5776Z" fill="#E7E7E7" />
                <path d="M331.499 95.5776H349.738V86.0688H331.499V95.5776Z" fill="#F5F5F5" />
                <path d="M308.894 95.5776H328.432V86.0688H308.894V95.5776Z" fill="#E7E7E7" />
                <path d="M308.88 95.5776H327.119V86.0688H308.88V95.5776Z" fill="#F5F5F5" />
                <path d="M331.499 117.156H351.037V107.647H331.499V117.156Z" fill="#E7E7E7" />
                <path d="M331.499 117.156H349.738V107.647H331.499V117.156Z" fill="#F5F5F5" />
                <path d="M308.894 117.156H328.432V107.647H308.894V117.156Z" fill="#E7E7E7" />
                <path d="M308.88 117.156H327.119V107.647H308.88V117.156Z" fill="#F5F5F5" />
                <path d="M331.499 130.305H351.037V120.796H331.499V130.305Z" fill="#E7E7E7" />
                <path d="M331.499 130.305H349.738V120.796H331.499V130.305Z" fill="#F5F5F5" />
                <path d="M308.894 130.305H328.432V120.796H308.894V130.305Z" fill="#E7E7E7" />
                <path d="M308.88 130.305H327.119V120.796H308.88V130.305Z" fill="#F5F5F5" />
                <path d="M331.499 153.793H351.037V144.285H331.499V153.793Z" fill="#E7E7E7" />
                <path d="M331.499 153.793H349.738V144.285H331.499V153.793Z" fill="#F5F5F5" />
                <path d="M308.894 153.793H328.432V144.285H308.894V153.793Z" fill="#E7E7E7" />
                <path d="M308.88 153.793H327.119V144.285H308.88V153.793Z" fill="#F5F5F5" />
                <path d="M331.499 171.123H351.037V161.614H331.499V171.123Z" fill="#E7E7E7" />
                <path d="M331.499 171.123H349.738V161.614H331.499V171.123Z" fill="#F5F5F5" />
                <path d="M308.894 171.123H328.432V161.614H308.894V171.123Z" fill="#E7E7E7" />
                <path d="M308.88 171.123H327.119V161.614H308.88V171.123Z" fill="#F5F5F5" />
                <path opacity="0.05" d="M283 67.0791L356.44 67.0791V65.4458L283 65.4458V67.0791Z" fill="black"
                    fill-opacity="0.46" />
                <path opacity="0.05" d="M283 102.43L356.44 102.43V100.796L283 100.796V102.43Z" fill="black"
                    fill-opacity="0.46" />
                <path opacity="0.05" d="M283 138.112H356.44V136.479H283V138.112Z" fill="black" fill-opacity="0.46" />
                <path d="M283.014 17.8872L359.908 17.8872V12.1708L283.014 12.1708V17.8872Z" fill="#E1E1E1" />
                <path opacity="0.05" d="M283 17.8872L300.576 17.8872V12.1708L283 12.1708V17.8872Z" fill="black"
                    fill-opacity="0.46" />
                <path d="M513.7 42.833H455.511V194.327H513.7V42.833Z" fill="#E7E7E7" />
                <path d="M477.051 194.327H535.24V42.833H477.051V194.327Z" fill="#F0F0F0" />
                <path d="M482.126 60.8296L530.165 60.8296V53.1166L482.126 53.1166V60.8296Z" fill="#E7E7E7" />
                <path d="M482.126 60.8296L528.295 60.8296V53.1166L482.126 53.1166V60.8296Z" fill="#F5F5F5" />
                <path d="M482.126 73.8203H530.165V66.1073H482.126V73.8203Z" fill="#E7E7E7" />
                <path d="M482.126 73.8203H528.295V66.1073H482.126V73.8203Z" fill="#F5F5F5" />
                <path d="M482.126 87.3154H530.165V79.6025H482.126V87.3154Z" fill="#E7E7E7" />
                <path d="M482.126 87.3154H528.295V79.6025H482.126V87.3154Z" fill="#F5F5F5" />
                <path d="M482.126 100.821H530.165V93.1078H482.126V100.821Z" fill="#E7E7E7" />
                <path d="M482.126 100.821H528.295V93.1078H482.126V100.821Z" fill="#F5F5F5" />
                <path d="M482.126 114.316H530.165V106.603H482.126V114.316Z" fill="#E7E7E7" />
                <path d="M482.126 114.316H528.295V106.603H482.126V114.316Z" fill="#F5F5F5" />
                <path d="M482.126 127.811H530.165V120.098H482.126V127.811Z" fill="#E7E7E7" />
                <path d="M482.126 127.811H528.295V120.098H482.126V127.811Z" fill="#F5F5F5" />
                <path d="M482.126 142.684H530.165V134.971H482.126V142.684Z" fill="#E7E7E7" />
                <path d="M482.126 142.684H528.295V134.971H482.126V142.684Z" fill="#F5F5F5" />
                <path d="M482.126 157.566H530.165V149.853H482.126V157.566Z" fill="#E7E7E7" />
                <path d="M482.126 157.566H528.295V149.853H482.126V157.566Z" fill="#F5F5F5" />
                <path d="M482.126 172.449H530.165V164.736H482.126V172.449Z" fill="#E7E7E7" />
                <path d="M482.126 172.449H528.295V164.736H482.126V172.449Z" fill="#F5F5F5" />
                <path d="M482.126 187.322H530.165V179.609H482.126V187.322Z" fill="#E7E7E7" />
                <path d="M482.126 187.322H528.295V179.609H482.126V187.322Z" fill="#F5F5F5" />
                <path d="M454 45.0059L536.886 45.0059V41.3095L454 41.3095V45.0059Z" fill="#F5F5F5" />
                <path d="M454 38.3311L536.886 38.3311V34.6347L454 34.6347V38.3311Z" fill="#F5F5F5" />
                <path d="M456.751 41.3096L535.24 41.3096V37.6132L456.751 37.6132V41.3096Z" fill="#F0F0F0" />
                <path d="M471.724 53.1069H455.511V60.8296H471.724V53.1069Z" fill="#E1E1E1" />
                <path d="M471.724 65.8164H455.511V73.5391H471.724V65.8164Z" fill="#E1E1E1" />
                <path d="M471.724 78.5161H455.511V86.2388H471.724V78.5161Z" fill="#E1E1E1" />
                <path d="M471.724 93.0981H455.511V100.821H471.724V93.0981Z" fill="#E1E1E1" />
                <path d="M471.724 106.593H455.511V114.316H471.724V106.593Z" fill="#E1E1E1" />
                <path d="M471.724 120.098H455.511V127.821H471.724V120.098Z" fill="#E1E1E1" />
                <path d="M471.724 134.972H455.511V142.694H471.724V134.972Z" fill="#E1E1E1" />
                <path d="M471.724 149.854H455.511V157.577H471.724V149.854Z" fill="#E1E1E1" />
                <path d="M471.724 164.727H455.511V172.449H471.724V164.727Z" fill="#E1E1E1" />
                <path d="M471.724 179.61H455.511V187.333H471.724V179.61Z" fill="#E1E1E1" />
                <path d="M360.402 95.7656H354V105.797H360.402V95.7656Z" fill="#E1E1E1" />
                <path d="M360.402 112.191H354V122.223H360.402V112.191Z" fill="#E1E1E1" />
                <path d="M360.402 128.141H354V138.172H360.402V128.141Z" fill="#E1E1E1" />
                <path d="M360.402 145.022H354V155.054H360.402V145.022Z" fill="#E1E1E1" />
                <path d="M360.402 161.438H354V171.47H360.402V161.438Z" fill="#E1E1E1" />
                <path d="M421.351 85.686H354V188.302H421.351V85.686Z" fill="#E7E7E7" />
                <path d="M365.37 188.302H421.341V85.6854H365.37V188.302Z" fill="#F0F0F0" />
                <path d="M370.794 105.807H416.315V95.7754H370.794V105.807Z" fill="#ECECEC" />
                <path d="M370.794 122.223H416.315V112.191H370.794V122.223Z" fill="#ECECEC" />
                <path d="M370.794 138.628H416.315V128.597H370.794V138.628Z" fill="#ECECEC" />
                <path d="M370.794 155.044H416.315V145.012H370.794V155.044Z" fill="#ECECEC" />
                <path d="M370.794 171.459H416.315V161.428H370.794V171.459Z" fill="#ECECEC" />
                <path d="M370.794 105.808H414.639V95.7764H370.794V105.808Z" fill="#F5F5F5" />
                <path d="M370.794 122.224H414.639V112.192H370.794V122.224Z" fill="#F5F5F5" />
                <path d="M370.794 138.629H414.639V128.598H370.794V138.629Z" fill="#F5F5F5" />
                <path d="M370.794 155.045H414.639V145.013H370.794V155.045Z" fill="#F5F5F5" />
                <path d="M370.794 171.46H414.639V161.429H370.794V171.46Z" fill="#F5F5F5" />
                <path
                    d="M505.932 225.082C575.025 225.082 631.036 221.807 631.036 217.767C631.036 213.727 575.025 210.452 505.932 210.452C436.839 210.452 380.828 213.727 380.828 217.767C380.828 221.807 436.839 225.082 505.932 225.082Z"
                    fill="#F4F4F4" />
                <path d="M577.08 217.767H580.954" stroke="#FB5607" stroke-linecap="round" stroke-linejoin="round" />
                <path d="M577.08 217.767H580.954" stroke="#FB5607" stroke-linecap="round" stroke-linejoin="round" />
                <path d="M588.809 217.767H647.675" stroke="#FB5607" stroke-linecap="round" stroke-linejoin="round" />
                <path d="M588.809 217.767H647.675" stroke="#FB5607" stroke-linecap="round" stroke-linejoin="round" />
                <path d="M651.598 217.767H655.472" stroke="#FB5607" stroke-linecap="round" stroke-linejoin="round" />
                <path d="M651.598 217.767H655.472" stroke="#FB5607" stroke-linecap="round" stroke-linejoin="round" />
                <path d="M469.227 150.846L514.03 151.59L514.566 119.192L469.764 118.447L469.227 150.846Z"
                    fill="#FB5607" />
                <path d="M469.227 150.846L514.03 151.59L514.566 119.192L469.764 118.447L469.227 150.846Z"
                    fill="#FB5607" />
                <path opacity="0.3"
                    d="M486.983 151.142L514.069 151.592L514.606 119.194L487.519 118.744L486.983 151.142Z"
                    fill="white" />
                <path opacity="0.3" d="M483.67 123.551L491.467 123.681L491.503 121.503L483.706 121.374L483.67 123.551Z"
                    fill="white" />
                <path opacity="0.3" d="M483.182 148.3L490.979 148.429L491.015 146.252L483.218 146.122L483.182 148.3Z"
                    fill="white" />
                <path
                    d="M478.005 139.196C480.535 139.196 482.586 136.873 482.586 134.006C482.586 131.14 480.535 128.816 478.005 128.816C475.475 128.816 473.424 131.14 473.424 134.006C473.424 136.873 475.475 139.196 478.005 139.196Z"
                    stroke="white" stroke-miterlimit="10" />
                <path d="M477.818 129.604V130.48" stroke="white" stroke-linecap="round" stroke-linejoin="round" />
                <path d="M477.62 137.585V138.461" stroke="white" stroke-linecap="round" stroke-linejoin="round" />
                <path d="M481.863 133.831H480.995" stroke="white" stroke-linecap="round" stroke-linejoin="round" />
                <path d="M474.851 133.837H473.983" stroke="white" stroke-linecap="round" stroke-linejoin="round" />
                <path d="M477.818 133.837V131.151" stroke="white" stroke-width="0.5" stroke-linecap="round"
                    stroke-linejoin="round" />
                <path d="M477.649 134.006L475.755 135.91" stroke="white" stroke-width="0.5" stroke-linecap="round"
                    stroke-linejoin="round" />
                <path
                    d="M477.398 133.836C477.398 134.07 477.591 134.263 477.824 134.257C478.057 134.251 478.249 134.064 478.243 133.831C478.243 133.597 478.051 133.404 477.818 133.41C477.585 133.416 477.392 133.603 477.398 133.836Z"
                    fill="white" />
                <path opacity="0.3"
                    d="M478.005 140.568C481.352 140.568 484.066 137.63 484.066 134.006C484.066 130.382 481.352 127.444 478.005 127.444C474.657 127.444 471.943 130.382 471.943 134.006C471.943 137.63 474.657 140.568 478.005 140.568Z"
                    fill="white" />
                <path
                    d="M528.344 190.906C527.668 191.425 514.105 189.96 517.614 165.854C517.614 165.854 511.18 167.494 510.486 167.383C510.486 167.383 501.044 181.88 507.916 189.061C514.793 196.242 525.033 196.662 525.033 196.662L528.338 190.9L528.344 190.906Z"
                    fill="#FB5607" />
                <path
                    d="M528.344 190.906C527.668 191.425 514.105 189.96 517.614 165.854C517.614 165.854 511.18 167.494 510.486 167.383C510.486 167.383 501.044 181.88 507.916 189.061C514.793 196.242 525.033 196.662 525.033 196.662L528.338 190.9L528.344 190.906Z"
                    fill="#FB5607" />
                <path opacity="0.3"
                    d="M528.344 190.906C527.668 191.425 514.105 189.96 517.614 165.854C517.614 165.854 511.18 167.494 510.486 167.383C510.486 167.383 501.044 181.88 507.916 189.061C514.793 196.242 525.033 196.662 525.033 196.662L528.338 190.9L528.344 190.906Z"
                    fill="black" fill-opacity="0.46" />
                <path
                    d="M513.312 169.589C513.277 169.601 517.101 169.665 518.383 168.066C519.665 166.466 520.516 163.628 518.197 161.667C515.877 159.705 502.192 151.321 495.746 150.662C489.3 150.002 482.411 154.176 482.411 154.176L490.844 160.423L509.005 164.825L513.312 169.589Z"
                    fill="#1A2E35" />
                <path d="M525.68 187.11L525.33 190.595L521.146 190.245L521.775 186.66L525.68 187.11Z" fill="#FFBF9D" />
                <path
                    d="M526.49 190.344L520.429 190.263L519.998 193.328C519.998 193.328 525.674 193.41 528.006 193.094C530.337 192.779 529.976 191.565 529.976 191.565C529.976 191.565 527.242 191.629 526.49 190.344Z"
                    fill="#1A2E35" />
                <path
                    d="M488.87 213.895C496.399 213.128 501.768 205.284 500.863 196.376C499.959 187.468 493.122 180.869 485.593 181.636C478.064 182.403 472.694 190.247 473.599 199.155C474.504 208.063 481.341 214.663 488.87 213.895Z"
                    fill="#1A2E35" />
                <path
                    d="M496.754 148.174C496.754 148.174 496.125 162.63 504.524 163.045C512.922 163.453 521.939 162.537 521.939 162.537L519.293 188.5L527.167 188.984C527.167 188.984 532.814 166.945 533.706 161.404C534.592 155.863 533.823 151.952 527.988 149.494C522.148 147.036 496.76 148.174 496.76 148.174H496.754Z"
                    fill="#FB5607" />
                <path
                    d="M496.754 148.174C496.754 148.174 496.125 162.63 504.524 163.045C512.922 163.453 521.939 162.537 521.939 162.537L519.293 188.5L527.167 188.984C527.167 188.984 532.814 166.945 533.706 161.404C534.592 155.863 533.823 151.952 527.988 149.494C522.148 147.036 496.76 148.174 496.76 148.174H496.754Z"
                    fill="#FB5607" />
                <path
                    d="M543.736 194.046L533.275 163.623L519.281 148.163C519.281 148.163 531.479 148.21 537.343 151.584C543.206 154.959 543.457 159.022 544.512 163.845C545.567 168.673 549.903 191.518 549.903 191.518L543.731 194.046H543.736Z"
                    fill="#FB5607" />
                <path
                    d="M543.736 194.046L533.275 163.623L519.281 148.163C519.281 148.163 531.479 148.21 537.343 151.584C543.206 154.959 543.457 159.022 544.512 163.845C545.567 168.673 549.903 191.518 549.903 191.518L543.731 194.046H543.736Z"
                    fill="#FB5607" />
                <path opacity="0.7"
                    d="M496.754 148.174C496.754 148.174 509.751 147.596 519.281 148.163C519.281 148.163 531.479 148.209 537.343 151.584C543.206 154.959 543.457 159.022 544.512 163.845C545.567 168.673 549.903 191.518 549.903 191.518L543.731 194.046L533.269 163.623C531.509 172.053 527.155 188.984 527.155 188.984L519.281 188.5L521.927 162.537C521.927 162.537 512.91 163.453 504.512 163.045C496.113 162.636 496.743 148.174 496.743 148.174H496.754Z"
                    fill="black" fill-opacity="0.46" />
                <path
                    d="M518.191 124.728L523.017 125.317C523.017 125.317 523.856 134.203 524.637 135.931C524.637 135.931 539.482 137.975 545.561 137.8L548.65 139.901L548.755 143.556L545.73 143.644L544.756 141.326C544.756 141.326 542.716 141.238 542.244 140.088C542.244 140.088 526.473 143.906 520.662 139.551C520.662 139.551 517.159 134.396 518.191 124.733V124.728Z"
                    fill="#FFBF9D" />
                <path
                    d="M504.372 100.925C504.372 100.925 502.857 102.863 503.434 104.556C504.011 106.249 505.567 106.512 505.567 106.512C505.567 106.512 505.846 109.209 507.438 109.285C509.023 109.361 508.487 103.348 508.487 103.348L504.378 100.919L504.372 100.925Z"
                    fill="#1A2E35" />
                <path
                    d="M516.6 148.244L517.66 130.869L524.235 126.49C524.235 126.49 522.096 118.877 517.969 117.604C513.843 116.331 504.873 113.366 499.429 114.831C493.986 116.296 494.609 122.736 495.53 127.5L496.579 127.751C496.579 127.751 496.743 146.556 496.748 148.174L516.594 148.238L516.6 148.244Z"
                    fill="#FB5607" />
                <path
                    d="M516.6 148.244L517.66 130.869L524.235 126.49C524.235 126.49 522.096 118.877 517.969 117.604C513.843 116.331 504.873 113.366 499.429 114.831C493.986 116.296 494.609 122.736 495.53 127.5L496.579 127.751C496.579 127.751 496.743 146.556 496.748 148.174L516.594 148.238L516.6 148.244Z"
                    fill="#FB5607" />
                <path
                    d="M504.762 115.907C506.919 117.997 511.313 119.24 512.543 118.207C513.773 117.168 512.223 116.216 511.086 115.037C510.468 114.394 510.486 113.18 510.631 112.217C510.76 111.417 510.964 110.781 510.964 110.781C514.997 110.559 516.675 108.667 516.839 105.351C517.008 102.035 515.475 98.1348 515.475 98.1348L512.625 95.6943C512.625 95.6943 508.761 96.2782 505.619 98.4208C503.772 99.6819 504.319 102.163 505.089 103.991C505.625 105.275 506.266 106.238 506.266 106.238C506.715 110.798 504.762 115.907 504.762 115.907Z"
                    fill="#FFBF9D" />
                <path d="M514.583 106.249C514.583 106.249 513.033 106.319 512.351 105.355" stroke="#1A2E35"
                    stroke-linecap="round" stroke-linejoin="round" />
                <path
                    d="M512.106 102.314C512.112 102.605 512.287 102.845 512.491 102.839C512.695 102.833 512.852 102.588 512.84 102.296C512.835 102.004 512.66 101.765 512.456 101.771C512.252 101.776 512.094 102.022 512.106 102.314Z"
                    fill="#1A2E35" />
                <path
                    d="M515.644 102.408C515.65 102.7 515.825 102.94 516.029 102.934C516.233 102.928 516.39 102.683 516.378 102.391C516.367 102.099 516.198 101.86 515.994 101.865C515.79 101.871 515.632 102.116 515.644 102.408Z"
                    fill="#1A2E35" />
                <path
                    d="M514.414 104.825L514.571 102.443L515.708 104.709C515.708 104.709 515.125 105.234 514.408 104.831L514.414 104.825Z"
                    fill="#FF847F" />
                <path d="M512.293 100.447C512.293 100.447 511.244 100.143 510.766 101.159" stroke="#1A2E35"
                    stroke-linecap="round" stroke-linejoin="round" />
                <path d="M516.745 100.89C516.745 100.89 516.029 100.113 515.195 100.312" stroke="#1A2E35"
                    stroke-linecap="round" stroke-linejoin="round" />
                <path
                    d="M505.083 103.991C509.524 104.154 510.078 99.1039 510.078 99.1039C512.275 100.266 515.469 98.1348 515.469 98.1348L512.619 95.6943C512.619 95.6943 508.755 96.284 505.613 98.4208C503.766 99.6819 504.314 102.157 505.077 103.991H505.083Z"
                    fill="#1A2E35" />
                <path
                    d="M527.913 145.594C528.594 146.306 537.384 144.484 538.916 145.296C539.563 145.64 539.849 146.866 540.496 148.186C541.388 149.996 542.967 151.981 547.111 152.115C554.286 152.343 553.423 145.051 553.988 142.68C553.988 142.68 560.784 141.443 561.14 140.252C561.501 139.061 561.064 138.874 561.064 138.874C561.064 138.874 552.677 140.421 551.057 138.307C551.057 138.307 550.736 137.94 549.973 137.578C549.973 137.578 549.973 137.578 549.967 137.578C549.32 137.274 548.364 136.976 547.018 136.912C544.063 136.76 540.455 137.589 539.453 139.463C537.401 143.288 528.612 142.429 527.796 143.434C526.98 144.438 527.236 144.887 527.918 145.6L527.913 145.594Z"
                    fill="#FB5607" />
                <path
                    d="M527.913 145.594C528.594 146.306 537.384 144.484 538.916 145.296C539.563 145.64 539.849 146.866 540.496 148.186C541.388 149.996 542.967 151.981 547.111 152.115C554.286 152.343 553.423 145.051 553.988 142.68C553.988 142.68 560.784 141.443 561.14 140.252C561.501 139.061 561.064 138.874 561.064 138.874C561.064 138.874 552.677 140.421 551.057 138.307C551.057 138.307 550.736 137.94 549.973 137.578C549.973 137.578 549.973 137.578 549.967 137.578C549.32 137.274 548.364 136.976 547.018 136.912C544.063 136.76 540.455 137.589 539.453 139.463C537.401 143.288 528.612 142.429 527.796 143.434C526.98 144.438 527.236 144.887 527.918 145.6L527.913 145.594Z"
                    fill="#FB5607" />
                <path d="M550.153 150.579C550.153 150.579 561.944 166.921 552.234 192.066" stroke="#1A2E35"
                    stroke-linecap="round" stroke-linejoin="round" />
                <path
                    d="M534.598 159.068C534.598 159.068 534.598 159.103 534.603 159.161C534.603 159.202 534.609 159.255 534.615 159.325V159.366C534.743 160.907 535.029 162.501 535.402 164.042C535.938 166.308 536.649 168.468 537.232 170.202C539.721 177.576 539.429 185.516 539.429 185.516C540.251 184.494 541.772 183.758 543.643 183.245C550.503 181.359 562.142 182.369 562.142 182.369C564.427 174.347 563.605 161.789 561.338 154.748C559.071 147.707 552.765 149.289 552.765 149.289C552.765 149.289 546.12 149.481 545.281 149.394C543.486 149.207 541.97 149.254 540.688 149.487C535.524 150.439 534.289 154.502 534.592 159.062L534.598 159.068Z"
                    fill="#FB5607" />
                <path
                    d="M534.598 159.068C534.598 159.068 534.598 159.103 534.603 159.161C534.603 159.202 534.609 159.255 534.615 159.325V159.366C534.743 160.907 535.029 162.501 535.402 164.042C535.938 166.308 536.649 168.468 537.232 170.202C539.721 177.576 539.429 185.516 539.429 185.516C540.251 184.494 541.772 183.758 543.643 183.245C550.503 181.359 562.142 182.369 562.142 182.369C564.427 174.347 563.605 161.789 561.338 154.748C559.071 147.707 552.765 149.289 552.765 149.289C552.765 149.289 546.12 149.481 545.281 149.394C543.486 149.207 541.97 149.254 540.688 149.487C535.524 150.439 534.289 154.502 534.592 159.062L534.598 159.068Z"
                    fill="#FB5607" />
                <path
                    d="M483.419 189.673C495.082 200.205 517.55 201.309 534.271 200.141L543.643 183.251L547.438 176.408L535.239 159.938L534.598 159.068C534.598 159.068 534.598 159.103 534.604 159.162C534.604 159.203 534.609 159.255 534.615 159.325V159.366C534.784 162.303 535.862 185.872 527.254 191.64C527.231 191.658 527.207 191.675 527.184 191.687C526.053 192.429 524.754 192.866 523.262 192.907C507.438 193.369 507.881 172.666 511.902 168.258L484.445 162.729C484.445 162.729 479.019 176.397 483.419 189.673Z"
                    fill="#FB5607" />
                <path
                    d="M483.419 189.673C495.082 200.205 517.55 201.309 534.271 200.141L543.643 183.251L547.438 176.408L535.239 159.938L534.598 159.068C534.598 159.068 534.598 159.103 534.604 159.162C534.604 159.203 534.609 159.255 534.615 159.325V159.366C534.784 162.303 535.862 185.872 527.254 191.64C527.231 191.658 527.207 191.675 527.184 191.687C526.053 192.429 524.754 192.866 523.262 192.907C507.438 193.369 507.881 172.666 511.902 168.258L484.445 162.729C484.445 162.729 479.019 176.397 483.419 189.673Z"
                    fill="#FB5607" />
                <path
                    d="M513.954 163.768C513.954 163.768 516.53 165.905 515.201 168.778C513.872 171.644 501.073 166.075 496.032 165.059C490.99 164.043 485.138 163.05 482.65 162.536C480.161 162.017 480.353 154.812 482.405 154.17C484.457 153.528 504.541 157.089 507.875 159.039C511.209 160.989 513.954 163.768 513.954 163.768Z"
                    fill="#1A2E35" />
                <path
                    d="M507.507 105.771C508.02 105.245 508.061 104.411 507.659 103.792C507.041 102.858 505.782 101.375 504.582 102.484C502.897 104.031 505.776 106.868 506.971 106.185C507.193 106.057 507.373 105.917 507.513 105.771H507.507Z"
                    fill="#FFBF9D" />
                <path d="M515.807 98.9463C515.807 98.9463 518.144 99.3375 516.53 101.848L515.807 98.9463Z"
                    fill="#1A2E35" />
                <path
                    d="M513.575 97.416C513.575 97.416 517.089 96.1782 518.068 96.8788C519.047 97.5794 518.022 98.9164 516.903 99.617L516.005 99.7338L515.481 98.1399L514.111 97.9706L513.581 97.4218L513.575 97.416Z"
                    fill="#1A2E35" />
                <path
                    d="M516.897 99.6117C516.897 99.6117 519.199 98.0762 518.179 96.9728C517.159 95.8694 510.958 97.9712 506.319 100.54C506.319 100.54 516.949 93.4231 519.835 95.6709C522.224 97.5333 516.926 100.12 517.084 100.114L516.897 99.6059V99.6117Z"
                    fill="#FB5607" />
                <path
                    d="M516.897 99.6117C516.897 99.6117 519.199 98.0762 518.179 96.9728C517.159 95.8694 510.958 97.9712 506.319 100.54C506.319 100.54 516.949 93.4231 519.835 95.6709C522.224 97.5333 516.926 100.12 517.084 100.114L516.897 99.6059V99.6117Z"
                    fill="#FB5607" />
                <path
                    d="M503.935 99.092C503.952 100.464 504.384 101.445 504.384 101.445L514.822 96.3889C514.822 96.3889 514.309 95.7292 513.289 95.1512C512.759 94.8476 512.1 94.5673 511.302 94.4155C510.643 94.2871 509.897 94.2404 509.058 94.3338C505.24 94.7658 503.912 97.7142 503.935 99.0862V99.092Z"
                    fill="#FB5607" />
                <path
                    d="M503.935 99.092C503.952 100.464 504.384 101.445 504.384 101.445L514.822 96.3889C514.822 96.3889 514.309 95.7292 513.289 95.1512C512.759 94.8476 512.1 94.5673 511.302 94.4155C510.643 94.2871 509.897 94.2404 509.058 94.3338C505.24 94.7658 503.912 97.7142 503.935 99.0862V99.092Z"
                    fill="#FB5607" />
                <path opacity="0.2"
                    d="M516.579 99.6645C516.579 99.6645 518.881 98.129 517.861 97.0255C517.412 96.5351 516.066 96.6519 514.242 97.1598C513.222 97.4459 512.033 97.8137 510.809 98.3508C509.212 99.0456 507.51 99.9389 506 100.593C506 100.593 516.631 93.4758 519.516 95.7236C521.906 97.586 516.94 100.003 516.765 100.161L516.678 99.8513L516.573 99.6586L516.579 99.6645Z"
                    fill="black" fill-opacity="0.46" />
                <path opacity="0.3"
                    d="M508.784 95.5132L509.629 96.7626L513.289 95.157C512.759 94.8534 512.1 94.5732 511.302 94.4214L508.79 95.5132H508.784Z"
                    fill="white" />
                <path opacity="0.1"
                    d="M509.606 110.436C509.606 110.436 509.95 111.434 510.632 112.216C510.76 111.416 510.964 110.78 510.964 110.78C510.964 110.78 510.078 110.716 509.606 110.436Z"
                    fill="black" fill-opacity="0.46" />
                <path
                    d="M544.412 144.642C544.564 147.339 545.73 149.541 547.163 150.072C547.414 150.165 547.665 150.206 547.927 150.189C549.687 150.089 550.969 147.439 550.794 144.274C550.614 141.116 549.04 138.629 547.28 138.728C546.563 138.769 545.928 139.23 545.438 139.977C544.721 141.063 544.313 142.756 544.418 144.636L544.412 144.642Z"
                    fill="#F5F5F5" />
                <path
                    d="M544.413 144.642C544.564 147.34 545.73 149.541 547.164 150.072C548.79 149.979 549.979 147.532 549.81 144.613C549.641 141.688 548.189 139.4 546.557 139.493C546.149 139.516 545.765 139.692 545.427 139.983C544.71 141.069 544.302 142.762 544.407 144.642H544.413Z"
                    fill="white" />
                <path
                    d="M481.478 182.848C484.48 180.735 496.096 178.662 496.096 178.662C503.154 178.65 509.344 185.02 510.2 193.462C510.9 200.334 507.863 206.569 502.985 209.413C502.985 209.413 502.577 209.582 501.895 209.85C499.313 210.872 492.75 213.359 488.869 213.896"
                    fill="#1A2E35" />
                <path opacity="0.3"
                    d="M488.87 213.895C496.399 213.128 501.768 205.284 500.863 196.376C499.959 187.468 493.122 180.869 485.593 181.636C478.064 182.403 472.694 190.247 473.599 199.155C474.504 208.063 481.341 214.663 488.87 213.895Z"
                    fill="black" fill-opacity="0.46" />
                <path
                    d="M549.233 213.382C556.762 212.614 562.132 204.771 561.227 195.863C560.322 186.954 553.485 180.355 545.956 181.122C538.427 181.89 533.058 189.733 533.963 198.641C534.868 207.55 541.704 214.149 549.233 213.382Z"
                    fill="#1A2E35" />
                <path
                    d="M539.219 184.098L546.173 213.295C547.169 213.459 548.195 213.494 549.233 213.389C549.262 213.389 549.285 213.389 549.314 213.377C550.649 213.033 550.049 213.406 551.389 212.962C554.787 211.842 559.724 209.845 559.724 209.845C564.952 207.299 567.907 201.099 567.19 194.023C566.321 185.446 560.178 179.042 552.945 179.567C552.945 179.567 549.512 180.204 545.98 181.126C544.447 181.529 542.891 181.984 541.597 182.463H541.592C540.747 182.913 539.96 183.461 539.225 184.098H539.219Z"
                    fill="#1A2E35" />
                <path opacity="0.3"
                    d="M533.962 198.647C534.743 206.324 539.93 212.291 546.167 213.295C547.163 213.459 548.189 213.494 549.227 213.389C549.256 213.389 549.279 213.389 549.308 213.377C550.759 213.219 552.129 212.799 553.388 212.157C558.634 209.494 561.956 203.02 561.227 195.862C560.324 186.958 553.499 180.367 545.974 181.12H545.957C544.395 181.278 542.926 181.745 541.591 182.457H541.586C540.741 182.907 539.954 183.455 539.219 184.092C535.513 187.315 533.362 192.744 533.962 198.641V198.647Z"
                    fill="black" fill-opacity="0.46" />
                <path
                    d="M535.851 188.4C535.996 188.068 536.393 187.676 536.614 187.379C538.345 185.002 542.32 184.115 544.914 184.325C546.913 184.489 548.801 185.236 550.474 186.322C552.368 187.554 553.726 189.428 555.603 190.73C559.17 193.194 564.578 193.124 568.157 190.584C568.361 190.438 568.553 190.286 568.734 190.111C569.119 189.755 569.323 189.241 569.433 188.727C569.579 188.068 569.509 187.414 569.288 186.789C568.518 184.605 565.919 182.685 564.287 181.511C560.988 179.152 557.077 177.821 553.044 177.541C541.487 176.741 536.573 186.614 535.851 188.395V188.4Z"
                    fill="#FB5607" />
                <path
                    d="M535.851 188.4C535.996 188.068 536.393 187.676 536.614 187.379C538.345 185.002 542.32 184.115 544.914 184.325C546.913 184.489 548.801 185.236 550.474 186.322C552.368 187.554 553.726 189.428 555.603 190.73C559.17 193.194 564.578 193.124 568.157 190.584C568.361 190.438 568.553 190.286 568.734 190.111C569.119 189.755 569.323 189.241 569.433 188.727C569.579 188.068 569.509 187.414 569.288 186.789C568.518 184.605 565.919 182.685 564.287 181.511C560.988 179.152 557.077 177.821 553.044 177.541C541.487 176.741 536.573 186.614 535.851 188.395V188.4Z"
                    fill="#FB5607" />
                <path opacity="0.3"
                    d="M536.649 188.71C539.132 185.125 542.314 184.121 544.914 184.325C546.913 184.489 548.801 185.236 550.474 186.322C552.368 187.554 553.726 189.428 555.603 190.73C559.17 193.194 564.579 193.124 568.157 190.584C568.361 190.438 568.553 190.286 568.734 190.111C569.119 189.755 569.323 189.241 569.434 188.727C569.579 188.068 569.509 187.414 569.288 186.789C568.087 188.179 564.596 191.524 559.863 189.889C553.959 187.846 552.52 181.78 546.208 181.832C541.201 181.873 538.112 185.791 536.649 188.698V188.71Z"
                    fill="black" fill-opacity="0.46" />
                <g opacity="0.3">
                    <path
                        d="M562.615 180.437C558.436 177.979 553.4 177.25 548.679 178.172C547.968 178.359 547.181 178.54 546.476 178.738C546.01 178.908 544.786 179.351 544.331 179.515L543.643 179.842C542.279 180.437 540.892 181.284 539.604 182.025C540.793 181.138 542.14 180.175 543.486 179.509L544.168 179.135L544.885 178.838L546.324 178.248C547.035 178.026 547.846 177.81 548.568 177.612C553.359 176.602 558.651 177.471 562.62 180.426L562.615 180.437Z"
                        fill="black" fill-opacity="0.46" />
                </g>
                <g opacity="0.3">
                    <path
                        d="M550.031 177.658C551.127 171.009 550.322 164.23 550.06 157.534C550.218 158.363 550.34 159.198 550.48 160.033C550.806 162.473 551.074 165.159 551.115 167.605C551.15 170.968 551.098 174.441 550.031 177.658Z"
                        fill="black" fill-opacity="0.46" />
                </g>
                <path opacity="0.3"
                    d="M527.254 191.641C535.361 186.416 535.682 172.941 535.402 164.049C535.355 162.519 535.291 161.13 535.245 159.939C535.18 158.316 535.151 157.061 535.245 156.348C536.084 150.23 540.712 149.494 540.712 149.494C540.706 149.494 540.7 149.494 540.694 149.494C535.53 150.446 534.295 154.509 534.598 159.069C534.598 159.069 534.598 159.104 534.603 159.162C534.603 159.203 534.609 159.256 534.615 159.326V159.367C534.784 162.303 535.862 185.873 527.254 191.641Z"
                    fill="black" fill-opacity="0.46" />
                <path opacity="0.2"
                    d="M527.912 145.594C528.594 146.306 537.384 144.484 538.916 145.296C539.563 145.64 539.849 146.866 540.496 148.186C540.496 148.186 540.496 148.198 540.502 148.198C542.332 151.117 544.908 151.572 545.071 151.601C541.994 149.278 541.137 143.65 542.664 140.1C544.185 136.579 549.652 137.467 549.961 137.578C549.314 137.274 548.358 136.976 547.012 136.912C544.057 136.76 540.449 137.589 539.447 139.463C537.395 143.288 528.606 142.429 527.79 143.434C526.974 144.438 527.231 144.887 527.912 145.6V145.594Z"
                    fill="black" fill-opacity="0.46" />
                <path
                    d="M534.79 142.201C534.79 142.201 535.612 143.509 535.402 145.436L527.959 146.276C527.959 146.276 526.776 145.103 527.015 143.03C527.015 143.03 534.388 142.289 534.796 142.201H534.79Z"
                    fill="#1A2E35" />
                <path
                    d="M557.392 141.921C557.392 141.921 558.132 140.345 557.247 139.347C559.234 139.166 560.464 138.967 561.746 138.769C561.933 139.347 562.032 139.907 561.361 140.789C560.691 141.67 557.392 141.921 557.392 141.921Z"
                    fill="#1A2E35" />
                <path d="M561.53 151.812C562.818 153.919 563.92 157.282 564.019 162.659" stroke="#FB5607"
                    stroke-linecap="round" stroke-linejoin="round" />
                <path d="M561.53 151.812C562.818 153.919 563.92 157.282 564.019 162.659" stroke="#FB5607"
                    stroke-linecap="round" stroke-linejoin="round" />
                <path d="M557.281 148.338C557.281 148.338 558.43 148.501 559.776 149.687" stroke="#FB5607"
                    stroke-linecap="round" stroke-linejoin="round" />
                <path d="M557.281 148.338C557.281 148.338 558.43 148.501 559.776 149.687" stroke="#FB5607"
                    stroke-linecap="round" stroke-linejoin="round" />
                <path
                    d="M499.383 128.061L504.284 128.657C504.284 128.657 505.141 137.677 505.928 139.429C505.928 139.429 521 141.507 527.172 141.326L530.308 143.457L530.419 147.164L527.347 147.252L526.356 144.899C526.356 144.899 524.281 144.812 523.804 143.638C523.804 143.638 507.787 147.515 501.889 143.089C501.889 143.089 498.334 137.858 499.383 128.044V128.061Z"
                    fill="#FFBF9D" />
                <path opacity="0.2"
                    d="M539.278 197.479C539.418 202.372 542.617 206.248 546.423 206.137C546.942 206.12 547.449 206.032 547.933 205.881C550.987 204.906 553.184 201.303 553.062 197.082C552.945 193.001 550.695 189.627 547.74 188.687C547.152 188.5 546.54 188.406 545.91 188.424C542.104 188.535 539.138 192.593 539.278 197.485V197.479Z"
                    fill="#FAFAFA" />
                <path
                    d="M542.786 197.467C542.909 201.642 545.106 205.075 547.933 205.875C550.987 204.9 553.184 201.297 553.062 197.076C552.945 192.995 550.696 189.621 547.741 188.681C544.803 189.475 542.658 193.141 542.786 197.467Z"
                    fill="#1A2E35" />
                <path opacity="0.2"
                    d="M479.45 197.859C479.59 202.751 482.789 206.628 486.595 206.517C487.114 206.499 487.621 206.412 488.105 206.26C491.159 205.285 493.356 201.683 493.234 197.462C493.117 193.381 490.868 190.006 487.913 189.066C487.324 188.879 486.712 188.786 486.082 188.803C482.277 188.914 479.31 192.972 479.45 197.864V197.859Z"
                    fill="#FAFAFA" />
                <path
                    d="M482.959 197.847C483.081 202.021 485.278 205.454 488.105 206.254C491.159 205.279 493.356 201.677 493.234 197.456C493.117 193.375 490.868 190 487.913 189.06C484.975 189.854 482.83 193.521 482.959 197.847Z"
                    fill="#1A2E35" />
                <path
                    d="M473.447 184.961C473.383 189.772 480.691 192.959 492.925 194.962C496.935 195.622 500.251 195.511 502.909 195.079C508.358 194.18 510.999 191.879 510.999 191.879C510.999 191.879 509.617 175.246 495.938 173.144C486.63 171.714 479.607 175.468 476.046 179.531C474.373 181.44 473.464 183.414 473.447 184.955V184.961Z"
                    fill="#FB5607" />
                <path
                    d="M473.447 184.961C473.383 189.772 480.691 192.959 492.925 194.962C496.935 195.622 500.251 195.511 502.909 195.079C508.358 194.18 510.999 191.879 510.999 191.879C510.999 191.879 509.617 175.246 495.938 173.144C486.63 171.714 479.607 175.468 476.046 179.531C474.373 181.44 473.464 183.414 473.447 184.955V184.961Z"
                    fill="#FB5607" />
                <path opacity="0.3"
                    d="M473.447 184.961C473.383 189.772 480.691 192.96 492.925 194.962C496.935 195.622 500.251 195.511 502.909 195.079C502.32 190.566 499.686 178.72 488.245 177.488C483.052 176.934 479.042 177.979 476.046 179.532C474.373 181.441 473.464 183.414 473.447 184.956V184.961Z"
                    fill="black" fill-opacity="0.46" />
                <g opacity="0.3">
                    <path
                        d="M510.206 191.956C508.726 184.407 504.646 176.356 496.993 173.665C495.944 173.244 494.837 173.017 493.724 172.771C503.451 173.361 509.425 182.971 510.206 191.956Z"
                        fill="black" fill-opacity="0.46" />
                </g>
                <path d="M528.565 186.462L527.761 189.212L519.287 188.5L519.176 184.658L528.565 186.462Z"
                    fill="#FB5607" />
                <path d="M528.565 186.462L527.761 189.212L519.287 188.5L519.176 184.658L528.565 186.462Z"
                    fill="#FB5607" />
                <path d="M465.267 160.693L438.444 159.601" stroke="#FB5607" stroke-linecap="round"
                    stroke-linejoin="round" />
                <path d="M465.267 160.693L438.444 159.601" stroke="#FB5607" stroke-linecap="round"
                    stroke-linejoin="round" />
                <path d="M429.584 154.709L425.591 154.541" stroke="#FB5607" stroke-linecap="round"
                    stroke-linejoin="round" />
                <path d="M429.584 154.709L425.591 154.541" stroke="#FB5607" stroke-linecap="round"
                    stroke-linejoin="round" />
                <path d="M452.414 155.633L432.639 154.835" stroke="#FB5607" stroke-linecap="round"
                    stroke-linejoin="round" />
                <path d="M452.414 155.633L432.639 154.835" stroke="#FB5607" stroke-linecap="round"
                    stroke-linejoin="round" />
                <path d="M438.579 169.551L422 168.871" stroke="#FB5607" stroke-linecap="round"
                    stroke-linejoin="round" />
                <path d="M438.579 169.551L422 168.871" stroke="#FB5607" stroke-linecap="round"
                    stroke-linejoin="round" />
                <path d="M448.823 169.963L441.599 169.669" stroke="#FB5607" stroke-linecap="round"
                    stroke-linejoin="round" />
                <path d="M448.823 169.963L441.599 169.669" stroke="#FB5607" stroke-linecap="round"
                    stroke-linejoin="round" />
                <path d="M315.521 197.829H-10V197.994H315.521V197.829Z" fill="#ECECEC" />
                <path d="M282.901 208.327H261.341V208.492H282.901V208.327Z" fill="#ECECEC" />
                <path d="M205.632 210.103H199.976V210.267H205.632V210.103Z" fill="#ECECEC" />
                <path d="M260.683 202.272H248.189V202.437H260.683V202.272Z" fill="#ECECEC" />
                <path d="M52.2664 203.369H24.1501V203.534H52.2664V203.369Z" fill="#ECECEC" />
                <path d="M62.1938 203.369H58.0679V203.534H62.1938V203.369Z" fill="#ECECEC" />
                <path d="M136.576 206.124H75.5884V206.289H136.576V206.124Z" fill="#ECECEC" />
                <path
                    d="M57.8254 51.933C57.8254 51.933 57.0603 46.8977 60.731 43.667C64.4017 40.4363 64.0724 38.5153 63.0264 38.2631C61.9804 38.0108 61.0119 41.2416 59.3945 42.1341C59.3945 42.1341 59.346 37.5258 60.9828 35.8376C62.6196 34.1398 63.4816 29.774 61.9223 29.6964C60.363 29.6188 60.1983 32.2868 59.8787 34.1883C59.5591 36.0899 57.8158 38.7482 57.8158 38.7482C57.8158 38.7482 57.4768 34.6249 56.4211 32.9368C55.3654 31.239 58.1838 27.3679 57.0991 25.6701C56.0143 23.9723 54.0773 27.203 54.2322 30.8412C54.3969 34.4794 56.8085 38.3504 56.2468 42.1535C56.2468 42.1535 55.1814 39.4855 54.2225 39.243C53.2637 39.0004 52.2952 37.2347 51.656 36.5847C51.007 35.9347 50.2032 38.1952 51.656 40.2908C53.1087 42.3864 56.8182 48.0134 56.2564 52.5539L57.8254 51.9524V51.933Z"
                    fill="#E7E7E7" />
                <path
                    d="M60.0241 49.6338L61.2251 57.1818C61.5932 59.5103 59.8014 61.6253 57.4382 61.6253H56.1597C53.8062 61.6253 52.0048 59.5103 52.3728 57.1818L53.5738 49.6338H60.0241Z"
                    fill="#E7E7E7" />
                <path d="M41.845 63.2163L126.765 63.2163V58.8505L41.845 58.8505V63.2163Z" fill="#E1E1E1" />
                <path d="M119.123 58.8506H122.862V42.7358H119.123V58.8506Z" fill="#ECECEC" />
                <path d="M101.032 58.8506H104.77V42.7358H101.032V58.8506Z" fill="#ECECEC" />
                <path d="M77.7631 58.2145L81.4473 58.8506L84.1799 42.97L80.4958 42.3339L77.7631 58.2145Z"
                    fill="#ECECEC" />
                <path d="M114.484 58.8506H118.223V44.8605H114.484V58.8506Z" fill="#ECECEC" />
                <path d="M105.893 58.8506H109.632V44.8605H105.893V58.8506Z" fill="#ECECEC" />
                <path d="M84.1887 58.8506H87.9272V44.8605H84.1887V58.8506Z" fill="#ECECEC" />
                <path d="M93.0947 58.0274L96.7441 58.8398L99.7741 45.183L96.1246 44.3705L93.0947 58.0274Z"
                    fill="#ECECEC" />
                <path d="M111.249 58.8408H113.119V41.9305H111.249V58.8408Z" fill="#ECECEC" />
                <path d="M88.9926 58.8408H90.8618V41.9305H88.9926V58.8408Z" fill="#ECECEC" />
                <path d="M126.775 91.4775H41.8545V95.8434H126.775V91.4775Z" fill="#E1E1E1" />
                <path d="M49.4963 75.3623H45.7578V91.4771H49.4963V75.3623Z" fill="#ECECEC" />
                <path d="M67.5881 75.3623H63.8496V91.4771H67.5881V75.3623Z" fill="#ECECEC" />
                <path d="M88.1226 74.9547L84.4385 75.5908L87.1711 91.4714L90.8553 90.8352L88.1226 74.9547Z"
                    fill="#ECECEC" />
                <path d="M54.1355 77.4878H50.397V91.4778H54.1355V77.4878Z" fill="#ECECEC" />
                <path d="M62.7358 77.4878H58.9973V91.4778H62.7358V77.4878Z" fill="#ECECEC" />
                <path d="M84.4404 77.4878H80.7019V91.4778H84.4404V77.4878Z" fill="#ECECEC" />
                <path d="M72.4996 77.0015L68.8501 77.814L71.8801 91.4708L75.5295 90.6583L72.4996 77.0015Z"
                    fill="#ECECEC" />
                <path d="M57.3702 74.5674H55.501V91.4777H57.3702V74.5674Z" fill="#ECECEC" />
                <path d="M79.6271 74.5674H77.7578V91.4777H79.6271V74.5674Z" fill="#ECECEC" />
                <path d="M118.62 78.7197H100.392V91.3224H118.62V78.7197Z" fill="#ECECEC" />
                <path
                    d="M265.303 32.7617H162.92C161.786 32.7617 160.867 33.6826 160.867 34.8185V34.9543C160.867 36.0903 161.786 37.0111 162.92 37.0111H265.303C266.437 37.0111 267.356 36.0903 267.356 34.9543V34.8185C267.356 33.6826 266.437 32.7617 265.303 32.7617Z"
                    fill="#E1E1E1" />
                <path d="M261.022 36.1382H167.191V119.545H261.022V36.1382Z" fill="#E7E7E7" />
                <path d="M258.562 38.4277H169.545V117.304H258.562V38.4277Z" fill="#F0F0F0" />
                <path d="M190.436 38.4277L169.545 117.139V80.1456L180.566 38.4277H190.436Z" fill="white" />
                <path d="M197.835 38.4277L176.76 117.304H173.39L194.465 38.4277H197.835Z" fill="white" />
                <path d="M255.317 38.4277L234.242 117.304H230.881L251.956 38.4277H255.317Z" fill="white" />
                <path d="M258.552 88.1982V100.801L254.29 117.304H250.93L258.552 88.1982Z" fill="white" />
                <path d="M200.586 37.0112H199.085V119.069H200.586V37.0112Z" fill="#E7E7E7" />
                <path d="M229.651 37.0112H228.15V119.069H229.651V37.0112Z" fill="#E7E7E7" />
                <path
                    d="M245.729 34.1201C245.729 34.1201 247.889 62.3428 260.305 76.7209C260.305 76.7209 251.259 113.035 251.269 125.696L268.073 122.591L262.019 76.9343L264.915 34.1201H245.729Z"
                    fill="#E1E1E1" />
                <path
                    d="M182.484 34.1201C182.484 34.1201 180.324 62.3428 167.908 76.7209C167.908 76.7209 176.954 113.035 176.944 125.696L160.14 122.591L166.194 76.9343L163.298 34.1201H182.484Z"
                    fill="#E1E1E1" />
                <path
                    d="M152.76 227.284C222.474 227.284 278.988 223.978 278.988 219.901C278.988 215.823 222.474 212.518 152.76 212.518C83.0467 212.518 26.5327 215.823 26.5327 219.901C26.5327 223.978 83.0467 227.284 152.76 227.284Z"
                    fill="#F5F5F5" />
                <path
                    d="M226.455 17.957H147.637C142.914 17.957 139.085 21.7925 139.085 26.5238V182.209C139.085 186.94 142.914 190.776 147.637 190.776H226.455C231.178 190.776 235.007 186.94 235.007 182.209V26.5238C235.007 21.7925 231.178 17.957 226.455 17.957Z"
                    fill="#1A2E35" />
                <path
                    d="M231.763 23.7489V184.673C231.763 185.993 230.697 187.021 229.38 187.021H144.45C143.24 187.021 142.32 186.08 142.32 184.867V23.5549C142.32 22.4974 143.094 21.5757 144.14 21.5757H165.37C165.971 21.5757 166.513 21.9638 166.736 22.5362L167.617 24.7094C167.84 25.2721 168.383 25.6602 168.983 25.6602H205.128C205.729 25.6602 206.271 25.2915 206.494 24.7288L207.375 22.5459C207.598 21.9832 208.14 21.5854 208.741 21.5854H229.671C230.833 21.5854 231.753 22.5944 231.753 23.7586L231.763 23.7489Z"
                    fill="#FB5607" />
                <path
                    d="M231.763 23.7489V184.673C231.763 185.993 230.697 187.021 229.38 187.021H144.45C143.24 187.021 142.32 186.08 142.32 184.867V23.5549C142.32 22.4974 143.094 21.5757 144.14 21.5757H165.37C165.971 21.5757 166.513 21.9638 166.736 22.5362L167.617 24.7094C167.84 25.2721 168.383 25.6602 168.983 25.6602H205.128C205.729 25.6602 206.271 25.2915 206.494 24.7288L207.375 22.5459C207.598 21.9832 208.14 21.5854 208.741 21.5854H229.671C230.833 21.5854 231.753 22.5944 231.753 23.7586L231.763 23.7489Z"
                    fill="#FB5607" />
                <path opacity="0.6" d="M231.763 31.6367H142.32V177.979H231.763V31.6367Z" fill="white" />
                <path opacity="0.6" d="M152.179 28.0654H153.283V26.5908H152.179V28.0654Z" fill="white" />
                <path opacity="0.6" d="M150.378 28.0654H151.482V26.096H150.378V28.0654Z" fill="white" />
                <path opacity="0.6" d="M148.576 28.0654H149.68V25.6012H148.576V28.0654Z" fill="white" />
                <path opacity="0.6" d="M146.775 28.0654H147.879V25.1161H146.775V28.0654Z" fill="white" />
                <path opacity="0.6" d="M221.642 26.0493H220.983V27.524H221.642V26.0493Z" fill="white" />
                <path opacity="0.6" d="M222.087 28.0674H227.308V25.5158H222.087V28.0674Z" fill="white" />
                <path opacity="0.6" d="M230.63 102.518H143.443V120.195H230.63V102.518Z" fill="white" />
                <path opacity="0.6"
                    d="M185.797 23.0209C186.476 23.0209 187.027 22.4693 187.027 21.7888C187.027 21.1083 186.476 20.5566 185.797 20.5566C185.117 20.5566 184.567 21.1083 184.567 21.7888C184.567 22.4693 185.117 23.0209 185.797 23.0209Z"
                    fill="white" />
                <path opacity="0.6"
                    d="M189.516 21.7888C189.516 22.2254 189.167 22.5746 188.731 22.5746C188.295 22.5746 187.947 22.2254 187.947 21.7888C187.947 21.3522 188.295 21.0029 188.731 21.0029C189.167 21.0029 189.516 21.3522 189.516 21.7888Z"
                    fill="white" />
                <path opacity="0.6" d="M230.63 147.835H143.443V158.119H230.63V147.835Z" fill="white" />
                <path d="M187.511 151.007V155.121H186.93V151.522H186V151.007H187.511Z" fill="#1A2E35" />
                <path
                    d="M210.242 114.044V114.878H209.767V114.044C209.041 114.005 208.353 113.753 207.976 113.403L208.247 112.821C208.595 113.141 209.167 113.374 209.767 113.413V111.696C208.954 111.492 208.101 111.24 208.101 110.231C208.101 109.494 208.625 108.863 209.767 108.766V107.922H210.242V108.756C210.794 108.776 211.346 108.941 211.743 109.212L211.501 109.804C211.104 109.552 210.658 109.416 210.242 109.387V111.114C211.065 111.318 211.956 111.57 211.956 112.579C211.956 113.316 211.414 113.947 210.242 114.044ZM209.767 110.997V109.397C209.109 109.474 208.818 109.814 208.818 110.202C208.818 110.658 209.235 110.852 209.767 110.997ZM211.23 112.627C211.23 112.152 210.784 111.968 210.242 111.822V113.413C210.93 113.345 211.23 113.025 211.23 112.627Z"
                    fill="#1A2E35" />
                <path d="M214.155 108.805V113.985H213.419V109.445H212.247V108.805H214.145H214.155Z" fill="#1A2E35" />
                <path
                    d="M215.269 113.529C215.269 113.229 215.501 113.025 215.772 113.025C216.043 113.025 216.256 113.229 216.256 113.529C216.256 113.83 216.034 114.044 215.772 114.044C215.511 114.044 215.269 113.83 215.269 113.529Z"
                    fill="#1A2E35" />
                <path
                    d="M220.809 111.337C220.809 113.103 219.811 114.054 218.358 114.054C217.874 114.054 217.409 113.957 217.07 113.753L217.351 113.18C217.622 113.355 217.971 113.423 218.349 113.423C219.395 113.423 220.063 112.763 220.063 111.473V111.289C219.763 111.745 219.211 111.968 218.571 111.968C217.545 111.968 216.809 111.356 216.809 110.396C216.809 109.435 217.603 108.756 218.629 108.756C220.014 108.756 220.799 109.688 220.799 111.337H220.809ZM219.898 110.357C219.898 109.824 219.472 109.358 218.668 109.358C218 109.358 217.525 109.746 217.525 110.367C217.525 110.988 217.981 111.366 218.697 111.366C219.414 111.366 219.898 110.93 219.898 110.357Z"
                    fill="#1A2E35" />
                <path
                    d="M225.38 111.337C225.38 113.103 224.382 114.054 222.93 114.054C222.445 114.054 221.98 113.957 221.641 113.753L221.922 113.18C222.193 113.355 222.542 113.423 222.92 113.423C223.966 113.423 224.634 112.763 224.634 111.473V111.289C224.334 111.745 223.782 111.968 223.143 111.968C222.116 111.968 221.38 111.356 221.38 110.396C221.38 109.435 222.174 108.756 223.201 108.756C224.586 108.756 225.37 109.688 225.37 111.337H225.38ZM224.469 110.357C224.469 109.824 224.043 109.358 223.239 109.358C222.571 109.358 222.097 109.746 222.097 110.367C222.097 110.988 222.552 111.366 223.269 111.366C223.985 111.366 224.469 110.93 224.469 110.357Z"
                    fill="#1A2E35" />
                <path
                    d="M150.194 116.188V116.489H148.479V116.256L149.448 115.315C149.7 115.073 149.748 114.917 149.748 114.772C149.748 114.529 149.574 114.374 149.244 114.374C148.993 114.374 148.78 114.452 148.634 114.636L148.402 114.432C148.586 114.199 148.905 114.073 149.274 114.073C149.767 114.073 150.087 114.325 150.087 114.743C150.087 114.976 150.019 115.179 149.7 115.49L148.973 116.188H150.194Z"
                    fill="#1A2E35" />
                <path
                    d="M150.455 115.286C150.455 114.51 150.872 114.063 151.433 114.063C151.995 114.063 152.402 114.51 152.402 115.286C152.402 116.062 151.985 116.508 151.433 116.508C150.881 116.508 150.455 116.062 150.455 115.286ZM152.063 115.286C152.063 114.675 151.801 114.364 151.433 114.364C151.065 114.364 150.804 114.675 150.804 115.286C150.804 115.897 151.065 116.208 151.433 116.208C151.801 116.208 152.063 115.897 152.063 115.286Z"
                    fill="#1A2E35" />
                <path
                    d="M152.692 114.723C152.692 114.335 152.915 114.073 153.244 114.073C153.574 114.073 153.796 114.335 153.796 114.723C153.796 115.111 153.574 115.373 153.244 115.373C152.915 115.373 152.692 115.111 152.692 114.723ZM153.583 114.723C153.583 114.432 153.458 114.267 153.254 114.267C153.051 114.267 152.925 114.442 152.925 114.723C152.925 115.005 153.051 115.179 153.254 115.179C153.458 115.179 153.583 115.005 153.583 114.723ZM154.688 114.093H154.949L153.322 116.479H153.06L154.688 114.093ZM154.203 115.849C154.203 115.461 154.426 115.199 154.755 115.199C155.085 115.199 155.307 115.461 155.307 115.849C155.307 116.237 155.085 116.499 154.755 116.499C154.426 116.499 154.203 116.237 154.203 115.849ZM155.085 115.849C155.085 115.567 154.959 115.393 154.755 115.393C154.552 115.393 154.426 115.567 154.426 115.849C154.426 116.13 154.552 116.305 154.755 116.305C154.959 116.305 155.085 116.13 155.085 115.849Z"
                    fill="#1A2E35" />
                <path
                    d="M155.656 115.577C155.656 115.034 156.053 114.655 156.595 114.655C157.138 114.655 157.535 115.034 157.535 115.577C157.535 116.12 157.138 116.499 156.595 116.499C156.053 116.499 155.656 116.111 155.656 115.577ZM157.206 115.577C157.206 115.189 156.944 114.946 156.595 114.946C156.247 114.946 155.985 115.199 155.985 115.577C155.985 115.955 156.247 116.217 156.595 116.217C156.944 116.217 157.206 115.965 157.206 115.577Z"
                    fill="#1A2E35" />
                <path
                    d="M158.349 114.52V114.675H158.872V114.946H158.358V116.489H158.029V114.946H157.719V114.675H158.029V114.51C158.029 114.161 158.242 113.928 158.629 113.928C158.765 113.928 158.901 113.967 158.997 114.034L158.901 114.287C158.833 114.238 158.746 114.199 158.649 114.199C158.455 114.199 158.358 114.306 158.358 114.52H158.349Z"
                    fill="#1A2E35" />
                <path
                    d="M159.549 114.52V114.675H160.072V114.946H159.559V116.489H159.23V114.946H158.92V114.675H159.23V114.51C159.23 114.161 159.443 113.928 159.83 113.928C159.966 113.928 160.102 113.967 160.198 114.034L160.102 114.287C160.034 114.238 159.947 114.199 159.85 114.199C159.656 114.199 159.559 114.306 159.559 114.52H159.549Z"
                    fill="#1A2E35" />
                <path
                    d="M148.634 108.844C148.634 107.631 149.564 106.738 150.804 106.738C151.433 106.738 151.985 106.952 152.363 107.379L151.985 107.747C151.666 107.408 151.278 107.262 150.833 107.262C149.903 107.262 149.225 107.932 149.225 108.844C149.225 109.756 149.913 110.425 150.833 110.425C151.288 110.425 151.675 110.27 151.985 109.93L152.363 110.299C151.985 110.726 151.433 110.949 150.794 110.949C149.554 110.949 148.625 110.066 148.625 108.844H148.634Z"
                    fill="#1A2E35" />
                <path
                    d="M152.702 109.348C152.702 108.417 153.39 107.767 154.32 107.767C155.249 107.767 155.927 108.426 155.927 109.348C155.927 110.27 155.249 110.939 154.32 110.939C153.39 110.939 152.702 110.279 152.702 109.348ZM155.366 109.348C155.366 108.688 154.92 108.252 154.32 108.252C153.719 108.252 153.274 108.679 153.274 109.348C153.274 110.017 153.729 110.444 154.32 110.444C154.91 110.444 155.366 110.008 155.366 109.348Z"
                    fill="#1A2E35" />
                <path
                    d="M161.874 109.115V110.91H161.312V109.183C161.312 108.572 161.022 108.271 160.508 108.271C159.947 108.271 159.579 108.63 159.579 109.299V110.9H159.017V109.173C159.017 108.562 158.726 108.261 158.213 108.261C157.651 108.261 157.283 108.62 157.283 109.29V110.89H156.721V107.776H157.264V108.242C157.487 107.922 157.864 107.747 158.339 107.747C158.813 107.747 159.211 107.931 159.414 108.319C159.646 107.97 160.082 107.747 160.605 107.747C161.361 107.747 161.874 108.184 161.874 109.096V109.115Z"
                    fill="#1A2E35" />
                <path
                    d="M166.126 109.348C166.126 110.299 165.467 110.939 164.557 110.939C164.101 110.939 163.704 110.764 163.453 110.415V110.91H162.91V106.554H163.472V108.271C163.733 107.931 164.121 107.776 164.557 107.776C165.467 107.776 166.126 108.407 166.126 109.358V109.348ZM165.554 109.348C165.554 108.688 165.099 108.252 164.508 108.252C163.917 108.252 163.462 108.678 163.462 109.348C163.462 110.017 163.917 110.444 164.508 110.444C165.099 110.444 165.554 110.008 165.554 109.348Z"
                    fill="#1A2E35" />
                <path
                    d="M166.62 109.348C166.62 108.417 167.307 107.767 168.237 107.767C169.167 107.767 169.845 108.426 169.845 109.348C169.845 110.27 169.167 110.939 168.237 110.939C167.307 110.939 166.62 110.279 166.62 109.348ZM169.283 109.348C169.283 108.688 168.838 108.252 168.237 108.252C167.637 108.252 167.191 108.679 167.191 109.348C167.191 110.017 167.646 110.444 168.237 110.444C168.828 110.444 169.283 110.008 169.283 109.348Z"
                    fill="#1A2E35" />
                <path
                    d="M174.833 110.396V110.91H171.889V110.512L173.554 108.901C173.99 108.475 174.068 108.222 174.068 107.96C174.068 107.533 173.767 107.281 173.196 107.281C172.76 107.281 172.402 107.427 172.15 107.728L171.753 107.378C172.073 106.99 172.615 106.757 173.254 106.757C174.106 106.757 174.658 107.194 174.658 107.902C174.658 108.3 174.542 108.659 173.981 109.192L172.721 110.405H174.823L174.833 110.396Z"
                    fill="#1A2E35" />
                <path opacity="0.6" d="M230.63 121.446H143.443V146.584H230.63V121.446Z" fill="white" />
                <path opacity="0.2"
                    d="M178.349 128.577H148.363C147.976 128.577 147.666 128.266 147.666 127.878C147.666 127.49 147.976 127.18 148.363 127.18H178.349C178.736 127.18 179.046 127.49 179.046 127.878C179.046 128.266 178.736 128.577 178.349 128.577Z"
                    fill="black" fill-opacity="0.46" />
                <path opacity="0.2"
                    d="M225.729 132.458H148.354C147.966 132.458 147.656 132.148 147.656 131.76C147.656 131.371 147.966 131.061 148.354 131.061H225.729C226.116 131.061 226.426 131.371 226.426 131.76C226.426 132.148 226.116 132.458 225.729 132.458Z"
                    fill="black" fill-opacity="0.46" />
                <path opacity="0.2"
                    d="M225.729 136.338H148.354C147.966 136.338 147.656 136.028 147.656 135.639C147.656 135.251 147.966 134.941 148.354 134.941H225.729C226.116 134.941 226.426 135.251 226.426 135.639C226.426 136.028 226.116 136.338 225.729 136.338Z"
                    fill="black" fill-opacity="0.46" />
                <path opacity="0.2"
                    d="M225.729 140.209H148.354C147.966 140.209 147.656 139.899 147.656 139.511C147.656 139.122 147.966 138.812 148.354 138.812H225.729C226.116 138.812 226.426 139.122 226.426 139.511C226.426 139.899 226.116 140.209 225.729 140.209Z"
                    fill="black" fill-opacity="0.46" />
                <path opacity="0.2"
                    d="M204.141 150.377H199.879C199.633 150.377 199.434 150.577 199.434 150.824V155.093C199.434 155.339 199.633 155.539 199.879 155.539H204.141C204.387 155.539 204.586 155.339 204.586 155.093V150.824C204.586 150.577 204.387 150.377 204.141 150.377Z"
                    fill="black" fill-opacity="0.46" />
                <path d="M202 151.669V154.23" stroke="white" stroke-miterlimit="10" />
                <path d="M203.279 152.95H200.722" stroke="white" stroke-miterlimit="10" />
                <path opacity="0.2"
                    d="M174.213 150.378H169.952C169.706 150.378 169.506 150.578 169.506 150.824V155.093C169.506 155.339 169.706 155.539 169.952 155.539H174.213C174.459 155.539 174.659 155.339 174.659 155.093V150.824C174.659 150.578 174.459 150.378 174.213 150.378Z"
                    fill="black" fill-opacity="0.46" />
                <path d="M172.083 151.669V154.23" stroke="white" stroke-miterlimit="10" />
                <path d="M173.361 152.95H170.804" stroke="white" stroke-miterlimit="10" />
                <path
                    d="M224.509 161.757H149.584C147.706 161.757 146.184 163.282 146.184 165.163V170.741C146.184 172.622 147.706 174.147 149.584 174.147H224.509C226.386 174.147 227.908 172.622 227.908 170.741V165.163C227.908 163.282 226.386 161.757 224.509 161.757Z"
                    fill="#FB5607" />
                <path
                    d="M224.509 161.757H149.584C147.706 161.757 146.184 163.282 146.184 165.163V170.741C146.184 172.622 147.706 174.147 149.584 174.147H224.509C226.386 174.147 227.908 172.622 227.908 170.741V165.163C227.908 163.282 226.386 161.757 224.509 161.757Z"
                    fill="#FB5607" />
                <path
                    d="M173.235 167.977C173.235 166.444 174.416 165.299 176.024 165.299C177.632 165.299 178.804 166.434 178.804 167.977C178.804 169.519 177.622 170.654 176.024 170.654C174.426 170.654 173.235 169.509 173.235 167.977ZM178.048 167.977C178.048 166.812 177.177 165.959 176.024 165.959C174.872 165.959 173.981 166.812 173.981 167.977C173.981 169.141 174.852 169.995 176.024 169.995C177.196 169.995 178.048 169.141 178.048 167.977Z"
                    fill="white" />
                <path
                    d="M183.443 170.606L182.31 168.995C182.203 168.995 182.097 169.015 181.981 169.015H180.683V170.615H179.937V165.367H181.981C183.346 165.367 184.169 166.056 184.169 167.191C184.169 167.996 183.753 168.588 183.017 168.85L184.257 170.615H183.443V170.606ZM183.424 167.191C183.424 166.444 182.92 166.017 181.961 166.017H180.692V168.374H181.961C182.92 168.374 183.424 167.938 183.424 167.191Z"
                    fill="white" />
                <path
                    d="M185.371 165.357H187.579C189.264 165.357 190.407 166.424 190.407 167.976C190.407 169.529 189.264 170.596 187.579 170.596H185.371V165.347V165.357ZM187.53 169.946C188.828 169.946 189.651 169.15 189.651 167.976C189.651 166.802 188.819 166.007 187.53 166.007H186.116V169.946H187.53Z"
                    fill="white" />
                <path
                    d="M195.346 169.956V170.606H191.55V165.357H195.249V166.007H192.305V167.617H194.93V168.258H192.305V169.956H195.356H195.346Z"
                    fill="white" />
                <path
                    d="M200.063 170.606L198.93 168.995C198.823 168.995 198.717 169.015 198.6 169.015H197.303V170.615H196.557V165.367H198.6C199.966 165.367 200.789 166.056 200.789 167.191C200.789 167.996 200.373 168.588 199.637 168.85L200.876 170.615H200.063V170.606ZM200.044 167.191C200.044 166.444 199.54 166.017 198.581 166.017H197.312V168.374H198.581C199.54 168.374 200.044 167.938 200.044 167.191Z"
                    fill="white" />
                <path opacity="0.2"
                    d="M225.68 66.6701C226.184 69.862 225.477 73.2673 223.627 75.8965C220.179 80.825 213.981 82.484 209.826 86.617C206.048 90.3716 204.102 96.3577 198.852 98.463C196.46 99.4235 193.758 99.2973 191.23 98.7928C185.748 97.6965 180.828 94.9412 175.85 92.5157C169.225 89.2753 161.545 87.8589 155.191 84.2013C152.276 82.5229 149.7 79.9907 148.673 76.7891C146.474 69.9687 151.23 63.2938 156.227 59.1802C159.976 56.0951 164.305 53.5241 167.424 49.7403C170.29 46.2574 171.482 41.6005 174.784 38.4474C177.467 35.8958 181.283 34.7704 184.983 34.8577C195.162 35.1003 199.675 41.4744 205.574 48.5664C210.455 54.4457 219.123 55.4935 223.637 61.6736C224.712 63.1483 225.39 64.8752 225.68 66.6701Z"
                    fill="white" />
                <path
                    d="M193.302 53.6399L191.327 80.6789C191.327 80.6789 198.474 85.5783 206.484 83.4924L214.252 59.102C214.252 59.102 209.196 51.292 193.302 53.6399Z"
                    fill="#1A2E35" />
                <path
                    d="M193.051 52.6988L192.847 55.5802C192.847 55.5802 198.968 61.3334 214 60.9259L215.394 57.7146C215.394 57.7146 206.426 48.8763 193.051 52.6988Z"
                    fill="#1A2E35" />
                <path opacity="0.8"
                    d="M193.051 52.6988L192.847 55.5802C192.847 55.5802 198.968 61.3334 214 60.9259L215.394 57.7146C215.394 57.7146 206.426 48.8763 193.051 52.6988Z"
                    fill="white" />
                <path opacity="0.2"
                    d="M214.833 57.7633C205.738 58.9857 197.932 55.5415 194.91 53.9601H194.901C194.058 53.5042 193.593 53.2131 193.593 53.2131C193.855 53.1355 194.116 53.0676 194.368 53.0094C195.724 52.6698 197.022 52.4758 198.271 52.3787C203.172 52.0004 207.23 53.281 210.106 54.6781C213.128 56.1528 214.833 57.7633 214.833 57.7633Z"
                    fill="black" fill-opacity="0.46" />
                <path
                    d="M218.852 47.392C218.523 50.4287 218.397 54.9983 214.823 57.7536C211.249 58.2387 207.879 57.9961 204.925 57.4334C202.871 57.0454 201.021 56.5021 199.433 55.92C197.467 55.2214 195.917 54.4744 194.91 53.9505H194.9C194.852 53.8535 194.59 53.4654 194.368 52.9997C194.019 52.2624 193.777 51.3504 194.62 51.1758C196.053 50.8847 195.753 50.7295 195.656 50.0212C195.559 49.3227 195.84 48.5854 196.14 49.2839C196.431 49.9824 196.189 51.5541 196.508 51.7385C196.818 51.9228 198.387 51.0011 198.271 52.3594C198.222 52.9415 198.193 53.5333 198.319 54.0087C198.339 54.0669 198.358 54.1348 198.377 54.193C198.377 54.2124 198.377 54.2221 198.387 54.2318C198.59 54.7363 199.017 55.0856 199.879 55.1341C201.603 55.2311 202.765 54.1639 204.518 53.6594C206.271 53.1646 208.373 53.2811 208.702 55.1341C209.031 56.9872 210.513 56.3177 210.174 55.0274C210.145 54.9013 210.116 54.7751 210.097 54.6393C209.883 53.3684 210.038 51.7967 210.716 52.6213C211.462 53.5236 210.426 53.7759 211.007 54.3483C211.588 54.9304 212.411 53.9602 212.692 52.2624C212.983 50.5645 214.29 46.8584 212.692 44.8017C211.094 42.7449 211.617 42.3277 212.692 42.5799C213.758 42.8225 213.186 44.6755 214.251 45.2091C215.327 45.7427 215.646 43.0262 215.075 41.7068C214.503 40.3873 213.758 38.1656 215.404 38.4567C217.051 38.7477 216.673 40.9306 216.673 42.3665C216.673 43.8024 217.08 44.7531 217.574 44.2098C217.758 44.0158 218.009 43.977 218.251 44.1516C218.678 44.4524 219.046 45.4032 218.842 47.3435L218.852 47.392Z"
                    fill="#FB5607" />
                <path
                    d="M218.852 47.392C218.523 50.4287 218.397 54.9983 214.823 57.7536C211.249 58.2387 207.879 57.9961 204.925 57.4334C202.871 57.0454 201.021 56.5021 199.433 55.92C197.467 55.2214 195.917 54.4744 194.91 53.9505H194.9C194.852 53.8535 194.59 53.4654 194.368 52.9997C194.019 52.2624 193.777 51.3504 194.62 51.1758C196.053 50.8847 195.753 50.7295 195.656 50.0212C195.559 49.3227 195.84 48.5854 196.14 49.2839C196.431 49.9824 196.189 51.5541 196.508 51.7385C196.818 51.9228 198.387 51.0011 198.271 52.3594C198.222 52.9415 198.193 53.5333 198.319 54.0087C198.339 54.0669 198.358 54.1348 198.377 54.193C198.377 54.2124 198.377 54.2221 198.387 54.2318C198.59 54.7363 199.017 55.0856 199.879 55.1341C201.603 55.2311 202.765 54.1639 204.518 53.6594C206.271 53.1646 208.373 53.2811 208.702 55.1341C209.031 56.9872 210.513 56.3177 210.174 55.0274C210.145 54.9013 210.116 54.7751 210.097 54.6393C209.883 53.3684 210.038 51.7967 210.716 52.6213C211.462 53.5236 210.426 53.7759 211.007 54.3483C211.588 54.9304 212.411 53.9602 212.692 52.2624C212.983 50.5645 214.29 46.8584 212.692 44.8017C211.094 42.7449 211.617 42.3277 212.692 42.5799C213.758 42.8225 213.186 44.6755 214.251 45.2091C215.327 45.7427 215.646 43.0262 215.075 41.7068C214.503 40.3873 213.758 38.1656 215.404 38.4567C217.051 38.7477 216.673 40.9306 216.673 42.3665C216.673 43.8024 217.08 44.7531 217.574 44.2098C217.758 44.0158 218.009 43.977 218.251 44.1516C218.678 44.4524 219.046 45.4032 218.842 47.3435L218.852 47.392Z"
                    fill="#FB5607" />
                <path
                    d="M203.046 45.4806L205.351 43.5015L208.024 45.4806V48.1098L205.719 48.9733L203.046 47.8091V45.4806Z"
                    fill="#FB5607" />
                <path
                    d="M203.046 45.4806L205.351 43.5015L208.024 45.4806V48.1098L205.719 48.9733L203.046 47.8091V45.4806Z"
                    fill="#FB5607" />
                <path opacity="0.8"
                    d="M203.046 45.4806L205.351 43.5015L208.024 45.4806V48.1098L205.719 48.9733L203.046 47.8091V45.4806Z"
                    fill="white" />
                <path opacity="0.5" d="M205.351 43.5015V46.7419L208.024 48.1098V45.4806L205.351 43.5015Z"
                    fill="white" />
                <path opacity="0.2"
                    d="M218.252 44.2003C217.67 44.5786 217.176 45.4615 217.099 46.6645C216.963 48.9348 216.237 48.8474 214.823 47.887C213.409 46.9265 213.893 49.0318 214.242 53.1939C214.591 57.3657 210.813 58.006 209.147 57.4336C207.482 56.8515 208.837 56.3761 207.791 55.726C206.881 55.1633 207.017 57.1134 204.915 57.4336C204.595 57.4821 204.227 57.4821 203.782 57.4336C201.729 57.2201 200.324 56.7447 199.423 55.9201C198.93 55.4738 198.591 54.9111 198.377 54.2514C198.581 54.7559 199.007 55.1051 199.869 55.1536C201.593 55.2507 202.755 54.1835 204.508 53.679C206.261 53.1842 208.363 53.3006 208.692 55.1536C209.022 57.0067 210.503 56.3373 210.164 55.0469C210.135 54.9208 210.106 54.7947 210.087 54.6588C209.874 53.3879 210.029 51.8162 210.707 52.6409C211.453 53.5431 210.416 53.7954 210.997 54.3678C211.578 54.9499 212.402 53.9797 212.683 52.2819C212.973 50.5841 214.281 46.878 212.683 44.8212C211.084 42.7644 211.607 42.3472 212.683 42.5995C213.748 42.842 213.176 44.6951 214.242 45.2287C215.317 45.7623 215.637 43.0457 215.065 41.7263C214.494 40.4068 213.748 38.1851 215.394 38.4762C217.041 38.7672 216.663 40.9502 216.663 42.386C216.663 43.8219 217.07 44.7727 217.564 44.2294C217.748 44.0353 218 43.9965 218.242 44.1712L218.252 44.2003Z"
                    fill="black" fill-opacity="0.46" />
                <path
                    d="M201.758 55.8427L199.695 55.3867L199.675 53.0777L201.128 51.9717L202.571 52.8837L203.046 54.8531L201.758 55.8427Z"
                    fill="#FB5607" />
                <path
                    d="M201.758 55.8427L199.695 55.3867L199.675 53.0777L201.128 51.9717L202.571 52.8837L203.046 54.8531L201.758 55.8427Z"
                    fill="#FB5607" />
                <path opacity="0.8"
                    d="M201.758 55.8427L199.695 55.3867L199.675 53.0777L201.128 51.9717L202.571 52.8837L203.046 54.8531L201.758 55.8427Z"
                    fill="white" />
                <path opacity="0.5"
                    d="M199.695 55.3867L201.486 54.0285L201.128 51.9717L199.675 53.0777L199.695 55.3867Z"
                    fill="white" />
                <path opacity="0.8"
                    d="M205.535 64.5933C211.704 64.5933 211.21 76.3131 203.821 76.2937C196.431 76.2743 198.571 64.5933 205.535 64.5933Z"
                    fill="white" />
                <path opacity="0.2"
                    d="M205.37 65.5151C210.571 65.5151 210.155 75.3916 203.917 75.3819C197.68 75.3625 199.491 65.5151 205.37 65.5151Z"
                    fill="black" fill-opacity="0.46" />
                <path
                    d="M155.559 84.3467C155.559 84.3467 153.835 87.1214 153.835 87.8685C153.835 88.6155 155.133 92.2537 155.995 93.0493C156.857 93.8545 167.21 96.3188 179.84 94.4075C192.47 92.4962 195.985 86.6266 196.605 85.2102C197.225 83.7937 197.012 78.351 195.656 78.1084C194.29 77.8659 157.971 82.4257 155.569 84.3467H155.559Z"
                    fill="#FB5607" />
                <path
                    d="M155.559 84.3467C155.559 84.3467 153.835 87.1214 153.835 87.8685C153.835 88.6155 155.133 92.2537 155.995 93.0493C156.857 93.8545 167.21 96.3188 179.84 94.4075C192.47 92.4962 195.985 86.6266 196.605 85.2102C197.225 83.7937 197.012 78.351 195.656 78.1084C194.29 77.8659 157.971 82.4257 155.569 84.3467H155.559Z"
                    fill="#FB5607" />
                <path opacity="0.2"
                    d="M196.586 79.5632C195.346 81.6006 191.123 86.4321 179.337 88.1299C166.077 90.0412 155.211 87.5769 154.31 86.7717C154.281 86.7523 154.261 86.7232 154.232 86.7038C154.746 85.6463 155.55 84.3462 155.55 84.3462C157.952 82.4349 194.281 77.8654 195.637 78.1079C196.063 78.1855 196.373 78.7579 196.576 79.5535L196.586 79.5632Z"
                    fill="#D96D1F" />
                <path
                    d="M155.123 84.2592C153.767 84.1621 153.089 85.2196 153.893 85.8988C154.697 86.5779 156.169 86.0249 156.237 87.3832C156.295 88.7414 156.363 90.4683 157.157 89.5467C157.961 88.625 157.215 87.5675 159.375 87.9459C160.692 88.169 162.407 89.0034 163.675 88.1593C163.898 88.0041 164.092 87.8003 164.324 87.6645C164.566 87.519 164.847 87.4608 165.118 87.3638C165.487 87.2279 165.816 87.0242 166.155 86.8302C166.581 86.5682 167.065 86.2189 167.046 85.7144C167.026 85.2682 166.581 84.9286 166.135 84.8704C165.69 84.8122 165.244 84.9577 164.818 85.0741C164.382 85.1905 163.937 85.2876 163.491 85.3652C162.678 85.501 161.951 85.142 161.148 84.9965C160.218 84.8316 159.278 84.7055 158.339 84.589C157.273 84.4629 156.198 84.3465 155.123 84.2592Z"
                    fill="#FB5607" />
                <path
                    d="M155.123 84.2592C153.767 84.1621 153.089 85.2196 153.893 85.8988C154.697 86.5779 156.169 86.0249 156.237 87.3832C156.295 88.7414 156.363 90.4683 157.157 89.5467C157.961 88.625 157.215 87.5675 159.375 87.9459C160.692 88.169 162.407 89.0034 163.675 88.1593C163.898 88.0041 164.092 87.8003 164.324 87.6645C164.566 87.519 164.847 87.4608 165.118 87.3638C165.487 87.2279 165.816 87.0242 166.155 86.8302C166.581 86.5682 167.065 86.2189 167.046 85.7144C167.026 85.2682 166.581 84.9286 166.135 84.8704C165.69 84.8122 165.244 84.9577 164.818 85.0741C164.382 85.1905 163.937 85.2876 163.491 85.3652C162.678 85.501 161.951 85.142 161.148 84.9965C160.218 84.8316 159.278 84.7055 158.339 84.589C157.273 84.4629 156.198 84.3465 155.123 84.2592Z"
                    fill="#FB5607" />
                <path
                    d="M167.569 85.9571C167.569 85.9571 170.959 88.6737 172.315 88.6154C173.671 88.5572 174.01 88.4311 174.523 89.1684C175.026 89.9058 177.332 91.4484 177.661 89.9058C177.99 88.3632 179.22 87.5579 180.024 87.8102C180.828 88.0527 182.368 88.4408 182.978 87.3251C183.269 86.7915 183.462 86.6266 184.005 86.4228C184.411 86.2676 184.828 86.1027 185.244 85.9668C185.748 85.7922 186.349 85.8795 186.823 85.6079C187.365 85.2974 187.569 84.6377 187.927 84.1332C188.305 83.6093 188.886 83.2406 189.516 83.1145C190.048 83.0078 190.6 83.0854 191.143 83.0369C191.685 82.9884 192.266 82.7846 192.537 82.3092C192.77 81.8921 192.712 81.3585 192.896 80.9219C193.157 80.3204 193.913 80.0002 194.523 80.2234C194.707 80.2913 194.881 80.398 195.075 80.3883C195.52 80.3592 195.927 79.7189 196.276 80.0002C196.547 80.2137 196.46 80.7181 196.886 80.9025C196.925 80.1845 196.905 79.4666 196.915 78.7487C196.915 78.4964 196.915 78.2248 196.78 78.0113C196.014 76.818 195.346 76.3814 193.874 76.3329C192.46 76.2844 190.939 76.265 189.767 77.0606C188.615 77.8367 188.034 79.2241 187.026 80.1748C186.465 80.6987 185.787 81.0868 185.109 81.4458C183.385 82.3578 181.603 83.1824 179.772 83.8809C178.116 84.5116 176.024 84.5019 174.252 84.7929C172.024 85.1519 169.787 85.54 167.569 85.9765V85.9571Z"
                    fill="#FB5607" />
                <path
                    d="M167.569 85.9571C167.569 85.9571 170.959 88.6737 172.315 88.6154C173.671 88.5572 174.01 88.4311 174.523 89.1684C175.026 89.9058 177.332 91.4484 177.661 89.9058C177.99 88.3632 179.22 87.5579 180.024 87.8102C180.828 88.0527 182.368 88.4408 182.978 87.3251C183.269 86.7915 183.462 86.6266 184.005 86.4228C184.411 86.2676 184.828 86.1027 185.244 85.9668C185.748 85.7922 186.349 85.8795 186.823 85.6079C187.365 85.2974 187.569 84.6377 187.927 84.1332C188.305 83.6093 188.886 83.2406 189.516 83.1145C190.048 83.0078 190.6 83.0854 191.143 83.0369C191.685 82.9884 192.266 82.7846 192.537 82.3092C192.77 81.8921 192.712 81.3585 192.896 80.9219C193.157 80.3204 193.913 80.0002 194.523 80.2234C194.707 80.2913 194.881 80.398 195.075 80.3883C195.52 80.3592 195.927 79.7189 196.276 80.0002C196.547 80.2137 196.46 80.7181 196.886 80.9025C196.925 80.1845 196.905 79.4666 196.915 78.7487C196.915 78.4964 196.915 78.2248 196.78 78.0113C196.014 76.818 195.346 76.3814 193.874 76.3329C192.46 76.2844 190.939 76.265 189.767 77.0606C188.615 77.8367 188.034 79.2241 187.026 80.1748C186.465 80.6987 185.787 81.0868 185.109 81.4458C183.385 82.3578 181.603 83.1824 179.772 83.8809C178.116 84.5116 176.024 84.5019 174.252 84.7929C172.024 85.1519 169.787 85.54 167.569 85.9765V85.9571Z"
                    fill="#FB5607" />
                <path
                    d="M195.811 79.1561C195.588 80.039 194.736 80.6696 194.029 81.1741C193.806 81.3294 193.593 81.4943 193.37 81.6495C192.954 81.9406 192.528 82.251 192.053 82.4257C191.579 82.6003 191.056 82.6488 190.552 82.7167C188.499 83.0078 186.523 83.7936 184.838 84.987C184.382 85.3071 183.918 85.6758 183.375 85.7728C182.891 85.8601 182.407 85.734 181.913 85.7243C181.428 85.7146 180.876 85.8601 180.654 86.3064C180.596 86.4422 180.557 86.5975 180.45 86.7042C180.353 86.8012 180.198 86.8206 180.063 86.84C178.445 87.0437 176.809 87.1602 175.181 87.1602C173.516 87.1602 171.85 87.0729 170.194 86.9758C169.119 86.9176 168.034 86.8497 166.968 86.7915C166.436 86.7624 165.893 86.7333 165.361 86.7915C164.847 86.8594 164.334 87.0243 163.83 87.1214C163.201 87.2378 162.562 87.2572 161.922 87.2669C161.274 87.2863 160.625 87.296 159.976 87.3154C158.281 87.3639 156.818 86.5101 155.259 85.9086C155.065 85.831 154.862 85.7534 154.726 85.5982C154.349 85.1519 154.726 84.4339 154.513 83.8809C154.465 83.7451 154.378 83.6287 154.368 83.4929C154.349 83.2988 154.455 83.1339 154.523 82.9496C154.552 82.8914 154.571 82.8234 154.581 82.7652C154.61 82.4936 154.465 82.251 154.368 81.9988C154.271 81.7368 154.232 81.4555 154.223 81.1741C154.223 81.0189 154.223 80.854 154.232 80.7084C154.252 80.592 154.281 80.4756 154.339 80.3689C154.649 79.7383 156.102 79.7674 156.721 79.6121C161.186 78.4673 165.738 77.6621 170.281 76.8568C175.588 75.906 180.915 75.0426 186.261 74.2761C188.218 74.0045 190.184 73.7328 192.15 73.5291C192.77 73.4709 193.554 73.2671 194.223 73.3545C194.581 73.403 194.901 73.5194 195.152 73.791C195.22 73.8589 195.288 73.9366 195.317 74.0239C195.433 74.2761 195.317 74.5769 195.24 74.8582C195.143 75.2851 195.172 75.7217 195.211 76.1583C195.22 76.3814 195.249 76.6046 195.366 76.7792C195.443 76.8956 195.559 76.9829 195.617 77.1091C195.734 77.4001 195.579 77.7979 195.637 78.1084C195.714 78.5158 195.927 78.6614 195.801 79.1465L195.811 79.1561Z"
                    fill="#7D5131" />
                <path opacity="0.2"
                    d="M194.784 76.0904C194.562 76.983 193.709 77.6136 193.002 78.1181C192.78 78.2733 192.566 78.4286 192.344 78.5838C191.927 78.8846 191.501 79.1853 191.027 79.36C190.542 79.5443 190.029 79.5831 189.525 79.651C187.472 79.9421 185.496 80.7182 183.811 81.9212C183.356 82.2414 182.901 82.6101 182.349 82.7071C181.864 82.7944 181.38 82.6683 180.886 82.6586C180.402 82.6489 179.85 82.8041 179.627 83.2407C179.569 83.3765 179.53 83.5317 179.424 83.6385C179.327 83.7355 179.172 83.7549 179.036 83.7743C177.419 83.978 175.792 84.0847 174.155 84.0944C172.489 84.0944 170.823 84.0071 169.167 83.9101C168.092 83.8519 167.017 83.784 165.942 83.7258C165.409 83.6967 164.867 83.6676 164.334 83.7355C163.821 83.8034 163.317 83.9683 162.804 84.0556C162.184 84.1721 161.535 84.1915 160.896 84.2012C160.247 84.2206 159.598 84.24 158.949 84.2594C157.37 84.3079 155.976 83.5511 154.523 82.9593C154.552 82.9011 154.571 82.8332 154.581 82.775C154.61 82.5033 154.465 82.2608 154.368 82.0086C154.271 81.7466 154.232 81.4652 154.223 81.1839C154.223 81.0287 154.223 80.8637 154.232 80.7182C154.252 80.6018 154.281 80.4854 154.339 80.3786C154.649 79.748 156.102 79.7771 156.721 79.6219C161.186 78.4771 165.738 77.6718 170.281 76.8666C175.588 75.9158 180.915 75.0523 186.261 74.2859C188.218 74.0142 190.184 73.7426 192.15 73.5389C192.77 73.4806 193.554 73.2769 194.223 73.3642C194.242 73.5 194.281 73.6165 194.349 73.7232C194.426 73.8396 194.542 73.9269 194.6 74.0627C194.726 74.3441 194.571 74.7516 194.629 75.0523C194.707 75.4598 194.92 75.6053 194.794 76.0904H194.784Z"
                    fill="black" fill-opacity="0.46" />
                <path
                    d="M153.273 79.5634C153.012 80.2619 158.387 87.3733 158.387 87.3733C158.387 87.3733 166.087 81.2612 171.327 80.3977C176.566 79.5342 193.884 80.4559 193.884 80.4559C193.884 80.4559 194.891 74.402 194.726 72.9467C194.562 71.4914 156.169 71.7534 153.273 79.5634Z"
                    fill="#FB5607" />
                <path
                    d="M153.273 79.5634C153.012 80.2619 158.387 87.3733 158.387 87.3733C158.387 87.3733 166.087 81.2612 171.327 80.3977C176.566 79.5342 193.884 80.4559 193.884 80.4559C193.884 80.4559 194.891 74.402 194.726 72.9467C194.562 71.4914 156.169 71.7534 153.273 79.5634Z"
                    fill="#FB5607" />
                <path opacity="0.7"
                    d="M153.273 79.5634C153.012 80.2619 158.387 87.3733 158.387 87.3733C158.387 87.3733 166.087 81.2612 171.327 80.3977C176.566 79.5342 193.884 80.4559 193.884 80.4559C193.884 80.4559 194.891 74.402 194.726 72.9467C194.562 71.4914 156.169 71.7534 153.273 79.5634Z"
                    fill="white" />
                <path
                    d="M158.242 79.1076L159.927 82.6973C159.927 82.6973 163.511 81.4166 164.741 82.6973C165.971 83.9779 165.971 85.21 165.971 85.21C165.971 85.21 166.891 81.1935 168.46 82.154C170.039 83.1144 171.395 84.5891 171.395 84.5891C171.395 84.5891 173.612 80.9509 175.588 82.154L177.564 83.357C177.564 83.357 179.162 79.7188 181.632 79.5636C184.092 79.4083 185.118 79.777 185.332 79.0979C185.545 78.4187 191.123 74.538 193.709 74.6932L196.295 74.8388C196.295 74.8388 196.789 71.3849 198.271 71.3849C198.271 71.3849 195.317 69.6677 195.375 67.5333C195.395 66.7183 193.467 68.746 192.111 67.5333C190.755 66.3206 151.888 74.1111 151.888 74.1111C151.888 74.1111 152.179 73.791 150.339 74.6835C148.489 75.5761 151.075 75.3433 150.339 77.2448C149.603 79.1464 153.051 77.1381 154.039 78.5158C155.026 79.8934 158.261 79.0882 158.261 79.0882L158.242 79.1076Z"
                    fill="#FB5607" />
                <path
                    d="M158.242 79.1076L159.927 82.6973C159.927 82.6973 163.511 81.4166 164.741 82.6973C165.971 83.9779 165.971 85.21 165.971 85.21C165.971 85.21 166.891 81.1935 168.46 82.154C170.039 83.1144 171.395 84.5891 171.395 84.5891C171.395 84.5891 173.612 80.9509 175.588 82.154L177.564 83.357C177.564 83.357 179.162 79.7188 181.632 79.5636C184.092 79.4083 185.118 79.777 185.332 79.0979C185.545 78.4187 191.123 74.538 193.709 74.6932L196.295 74.8388C196.295 74.8388 196.789 71.3849 198.271 71.3849C198.271 71.3849 195.317 69.6677 195.375 67.5333C195.395 66.7183 193.467 68.746 192.111 67.5333C190.755 66.3206 151.888 74.1111 151.888 74.1111C151.888 74.1111 152.179 73.791 150.339 74.6835C148.489 75.5761 151.075 75.3433 150.339 77.2448C149.603 79.1464 153.051 77.1381 154.039 78.5158C155.026 79.8934 158.261 79.0882 158.261 79.0882L158.242 79.1076Z"
                    fill="#FB5607" />
                <path opacity="0.5"
                    d="M158.242 79.1076L159.927 82.6973C159.927 82.6973 163.511 81.4166 164.741 82.6973C165.971 83.9779 165.971 85.21 165.971 85.21C165.971 85.21 166.891 81.1935 168.46 82.154C170.039 83.1144 171.395 84.5891 171.395 84.5891C171.395 84.5891 173.612 80.9509 175.588 82.154L177.564 83.357C177.564 83.357 179.162 79.7188 181.632 79.5636C184.092 79.4083 185.118 79.777 185.332 79.0979C185.545 78.4187 191.123 74.538 193.709 74.6932L196.295 74.8388C196.295 74.8388 196.789 71.3849 198.271 71.3849C198.271 71.3849 195.317 69.6677 195.375 67.5333C195.395 66.7183 193.467 68.746 192.111 67.5333C190.755 66.3206 151.888 74.1111 151.888 74.1111C151.888 74.1111 152.179 73.791 150.339 74.6835C148.489 75.5761 151.075 75.3433 150.339 77.2448C149.603 79.1464 153.051 77.1381 154.039 78.5158C155.026 79.8934 158.261 79.0882 158.261 79.0882L158.242 79.1076Z"
                    fill="white" />
                <path
                    d="M168.024 78.7487C165.235 83.066 152.576 84.1429 151.608 80.4659C151.375 79.5636 151.346 78.7681 151.453 78.0792C151.753 75.9642 153.235 74.8776 153.235 74.8776C158.523 72.1223 167.027 73.6067 168.295 76.6143C168.567 77.2643 168.518 77.9822 168.024 78.739V78.7487Z"
                    fill="#FB5607" />
                <path
                    d="M168.024 78.7487C165.235 83.066 152.576 84.1429 151.608 80.4659C151.375 79.5636 151.346 78.7681 151.453 78.0792C151.753 75.9642 153.235 74.8776 153.235 74.8776C158.523 72.1223 167.027 73.6067 168.295 76.6143C168.567 77.2643 168.518 77.9822 168.024 78.739V78.7487Z"
                    fill="#FB5607" />
                <path opacity="0.2"
                    d="M168.295 76.624C168.227 76.7987 168.131 76.9733 168.024 77.1479C165.235 81.4652 152.576 82.5421 151.608 78.8652C151.53 78.5935 151.482 78.3316 151.453 78.089C151.753 75.974 153.235 74.8874 153.235 74.8874C158.523 72.1321 167.026 73.6165 168.295 76.624Z"
                    fill="black" fill-opacity="0.46" />
                <path
                    d="M194.29 76.1871C191.501 80.5045 178.842 81.5814 177.874 77.9044C177.641 77.0021 177.612 76.2065 177.719 75.5177C178.019 73.4027 179.501 72.3161 179.501 72.3161C184.789 69.5608 193.293 71.0452 194.561 74.0527C194.833 74.7028 194.784 75.4207 194.29 76.1774V76.1871Z"
                    fill="#FB5607" />
                <path
                    d="M194.29 76.1871C191.501 80.5045 178.842 81.5814 177.874 77.9044C177.641 77.0021 177.612 76.2065 177.719 75.5177C178.019 73.4027 179.501 72.3161 179.501 72.3161C184.789 69.5608 193.293 71.0452 194.561 74.0527C194.833 74.7028 194.784 75.4207 194.29 76.1774V76.1871Z"
                    fill="#FB5607" />
                <path opacity="0.2"
                    d="M194.562 74.0527C194.494 74.2274 194.397 74.402 194.29 74.5766C191.501 78.894 178.842 79.9709 177.874 76.2939C177.796 76.0222 177.748 75.7603 177.719 75.5177C178.019 73.4027 179.501 72.3161 179.501 72.3161C184.789 69.5608 193.293 71.0452 194.562 74.0527Z"
                    fill="black" fill-opacity="0.46" />
                <path
                    d="M172.179 55.5902C185.448 54.4745 196.935 66.0682 194.368 72.0639C191.811 78.0597 155.889 83.1434 152.508 76.2842C149.128 69.425 158.223 56.7641 172.179 55.5902Z"
                    fill="#FB5607" />
                <path
                    d="M172.179 55.5902C185.448 54.4745 196.935 66.0682 194.368 72.0639C191.811 78.0597 155.889 83.1434 152.508 76.2842C149.128 69.425 158.223 56.7641 172.179 55.5902Z"
                    fill="#FB5607" />
                <path opacity="0.2"
                    d="M171.211 63.0708C171.211 63.0708 170.591 64.594 171.211 64.594C171.83 64.594 171.211 63.0708 171.211 63.0708Z"
                    fill="white" />
                <path opacity="0.2"
                    d="M176.073 61.2666C176.073 61.2666 177.186 62.751 177.244 62.0718C177.303 61.3927 176.073 61.2666 176.073 61.2666Z"
                    fill="white" />
                <path opacity="0.2"
                    d="M168.809 60.7134C168.809 60.7134 167.143 61.0238 167.579 61.4507C168.014 61.8873 168.809 60.7134 168.809 60.7134Z"
                    fill="white" />
                <path opacity="0.2"
                    d="M163.511 62.5659C163.511 62.5659 162.281 62.6629 162.465 63.0801C162.649 63.4973 163.511 62.5659 163.511 62.5659Z"
                    fill="white" />
                <path opacity="0.2"
                    d="M166.649 57.502C166.649 57.502 165.293 57.3177 165.293 57.7445C165.293 58.1714 166.649 57.502 166.649 57.502Z"
                    fill="white" />
                <path opacity="0.2"
                    d="M171.482 58.2388C171.482 58.2388 171.269 59.4127 171.763 59.2866C172.257 59.1604 171.482 58.2388 171.482 58.2388Z"
                    fill="white" />
                <path opacity="0.2"
                    d="M179.24 59.297C179.24 59.297 180.334 59.8015 180.334 59.297C180.334 58.7925 179.24 59.297 179.24 59.297Z"
                    fill="white" />
                <path opacity="0.2"
                    d="M175.414 56.755C175.414 56.755 176.015 56.0759 176.324 56.2602C176.634 56.4446 175.414 56.755 175.414 56.755Z"
                    fill="white" />
                <path opacity="0.2"
                    d="M169.981 56.7548C170.659 56.6287 170.291 57.4534 170.291 57.4534C170.291 57.4534 169.303 56.8712 169.981 56.7548Z"
                    fill="white" />
                <path opacity="0.2"
                    d="M165.971 65.71C165.971 65.71 165.167 66.2048 165.293 66.5734C165.419 66.9421 165.971 65.71 165.971 65.71Z"
                    fill="white" />
                <path opacity="0.2"
                    d="M183.036 62.8667C183.036 62.8667 184.392 63.3809 183.898 63.8272C183.404 64.2832 183.036 62.8667 183.036 62.8667Z"
                    fill="white" />
                <path opacity="0.2"
                    d="M175.414 66.6411C175.414 66.6411 175.792 67.3882 175.414 67.5337C175.036 67.6792 175.414 66.6411 175.414 66.6411Z"
                    fill="white" />
                <path opacity="0.2"
                    d="M194.368 72.0638C191.811 78.0595 155.889 83.1433 152.508 76.2744C152.14 75.5274 151.927 74.7124 151.84 73.849C151.918 74.0527 152.005 74.2564 152.092 74.4505C155.472 81.3194 191.385 76.2259 193.951 70.2302C194.261 69.5219 194.358 68.7264 194.29 67.8823C194.823 69.4055 194.872 70.8511 194.358 72.0638H194.368Z"
                    fill="black" fill-opacity="0.46" />
                <path
                    d="M244.276 203.359C244.276 203.359 240.596 195.317 244.799 187.4C249.002 179.473 250.223 177.611 247.54 175.99C244.857 174.37 243.637 182.326 243.637 182.326C243.637 182.326 241.38 176.844 243.24 171.11C245.109 165.377 246.271 156.043 243.724 155.035C241.177 154.035 243.24 166.686 241.031 170.994C241.031 170.994 239.172 166.192 238.872 161.593C238.562 156.985 239.046 149.64 237.031 147.748C235.017 145.866 233.729 147.166 235.705 157.324C237.68 167.482 237.671 175.748 237.671 175.748C237.671 175.748 233.303 162.418 230.378 162.03C227.453 161.641 227.453 165.959 229.961 169.704C232.47 173.449 237.303 180.153 238.097 183.606C238.097 183.606 233.303 173.575 228.993 176.65C224.683 179.726 232.741 185.78 236.334 187.972C239.927 190.165 242.416 203.883 242.416 203.883L244.266 203.35L244.276 203.359Z"
                    fill="#FB5607" />
                <path
                    d="M244.276 203.359C244.276 203.359 240.596 195.317 244.799 187.4C249.002 179.473 250.223 177.611 247.54 175.99C244.857 174.37 243.637 182.326 243.637 182.326C243.637 182.326 241.38 176.844 243.24 171.11C245.109 165.377 246.271 156.043 243.724 155.035C241.177 154.035 243.24 166.686 241.031 170.994C241.031 170.994 239.172 166.192 238.872 161.593C238.562 156.985 239.046 149.64 237.031 147.748C235.017 145.866 233.729 147.166 235.705 157.324C237.68 167.482 237.671 175.748 237.671 175.748C237.671 175.748 233.303 162.418 230.378 162.03C227.453 161.641 227.453 165.959 229.961 169.704C232.47 173.449 237.303 180.153 238.097 183.606C238.097 183.606 233.303 173.575 228.993 176.65C224.683 179.726 232.741 185.78 236.334 187.972C239.927 190.165 242.416 203.883 242.416 203.883L244.266 203.35L244.276 203.359Z"
                    fill="#FB5607" />
                <path opacity="0.2"
                    d="M244.276 203.359C244.276 203.359 240.596 195.317 244.799 187.4C249.002 179.473 250.223 177.611 247.54 175.99C244.857 174.37 243.637 182.326 243.637 182.326C243.637 182.326 241.38 176.844 243.24 171.11C245.109 165.377 246.271 156.043 243.724 155.035C241.177 154.035 243.24 166.686 241.031 170.994C241.031 170.994 239.172 166.192 238.872 161.593C238.562 156.985 239.046 149.64 237.031 147.748C235.017 145.866 233.729 147.166 235.705 157.324C237.68 167.482 237.671 175.748 237.671 175.748C237.671 175.748 233.303 162.418 230.378 162.03C227.453 161.641 227.453 165.959 229.961 169.704C232.47 173.449 237.303 180.153 238.097 183.606C238.097 183.606 233.303 173.575 228.993 176.65C224.683 179.726 232.741 185.78 236.334 187.972C239.927 190.165 242.416 203.883 242.416 203.883L244.266 203.35L244.276 203.359Z"
                    fill="black" fill-opacity="0.46" />
                <path
                    d="M241.37 206.658C241.37 206.658 244.954 198.567 240.654 190.708C236.354 182.85 235.114 180.997 237.777 179.338C240.441 177.679 241.758 185.615 241.758 185.615C241.758 185.615 243.947 180.104 242.019 174.399C240.082 168.695 238.804 159.371 241.341 158.333C243.879 157.295 241.971 169.975 244.228 174.254C244.228 174.254 246.029 169.422 246.271 164.814C246.523 160.206 245.952 152.861 247.947 150.94C249.932 149.029 251.24 150.31 249.38 160.497C247.53 170.684 247.637 178.949 247.637 178.949C247.637 178.949 251.84 165.551 254.765 165.124C257.69 164.688 257.738 169.005 255.278 172.789C252.818 176.573 248.063 183.344 247.308 186.808C247.308 186.808 251.976 176.708 256.324 179.716C260.673 182.724 252.683 188.904 249.119 191.145C245.554 193.386 243.22 207.143 243.22 207.143L241.361 206.639L241.37 206.658Z"
                    fill="#FB5607" />
                <path
                    d="M241.37 206.658C241.37 206.658 244.954 198.567 240.654 190.708C236.354 182.85 235.114 180.997 237.777 179.338C240.441 177.679 241.758 185.615 241.758 185.615C241.758 185.615 243.947 180.104 242.019 174.399C240.082 168.695 238.804 159.371 241.341 158.333C243.879 157.295 241.971 169.975 244.228 174.254C244.228 174.254 246.029 169.422 246.271 164.814C246.523 160.206 245.952 152.861 247.947 150.94C249.932 149.029 251.24 150.31 249.38 160.497C247.53 170.684 247.637 178.949 247.637 178.949C247.637 178.949 251.84 165.551 254.765 165.124C257.69 164.688 257.738 169.005 255.278 172.789C252.818 176.573 248.063 183.344 247.308 186.808C247.308 186.808 251.976 176.708 256.324 179.716C260.673 182.724 252.683 188.904 249.119 191.145C245.554 193.386 243.22 207.143 243.22 207.143L241.361 206.639L241.37 206.658Z"
                    fill="#FB5607" />
                <path d="M257.893 200.885H228.305L230.697 222.093H255.491L257.893 200.885Z" fill="#1A2E35" />
                <path
                    d="M132.819 211.78H159.831C165.11 211.78 169.39 207.493 169.39 202.205V182.277C169.39 176.988 165.11 172.701 159.831 172.701H132.819C127.539 172.701 123.259 176.988 123.259 182.277V202.205C123.259 207.493 127.539 211.78 132.819 211.78Z"
                    fill="#1A2E35" />
                <path opacity="0.1"
                    d="M132.819 211.78H159.831C165.11 211.78 169.39 207.493 169.39 202.205V182.277C169.39 176.988 165.11 172.701 159.831 172.701H132.819C127.539 172.701 123.259 176.988 123.259 182.277V202.205C123.259 207.493 127.539 211.78 132.819 211.78Z"
                    fill="white" />
                <path opacity="0.2"
                    d="M162.969 211.779C166.513 211.779 169.39 208.898 169.39 205.347V179.133C169.39 175.582 166.513 172.7 162.969 172.7C159.424 172.7 156.547 175.582 156.547 179.133V205.347C156.547 208.898 159.424 211.779 162.969 211.779Z"
                    fill="white" />
                <path
                    d="M123.375 185.673H55.4238L45.0703 132.109C43.9371 126.249 48.4117 120.816 54.3681 120.816H103.017C107.559 120.816 111.453 124.037 112.315 128.5L123.366 185.673H123.375Z"
                    fill="#1A2E35" />
                <g opacity="0.1">
                    <path
                        d="M123.375 185.673H55.4238L45.0703 132.109C43.9371 126.249 48.4117 120.816 54.3681 120.816H103.017C107.559 120.816 111.453 124.037 112.315 128.5L123.366 185.673H123.375Z"
                        fill="white" />
                </g>
                <path opacity="0.2"
                    d="M123.375 185.566H74.7168L63.666 128.442C63.2301 126.211 62.0389 124.319 60.3924 122.951C58.7459 121.592 56.6345 120.807 54.3682 120.807H103.027C107.559 120.807 111.463 123.979 112.325 128.442L123.385 185.566H123.375Z"
                    fill="white" />
                <path
                    d="M121.787 147.797C121.274 146.196 120.605 144.877 119.869 143.615C119.124 142.344 118.32 141.209 117.371 140.065C116.838 139.424 115.986 139.094 115.114 139.269C113.864 139.531 113.061 140.763 113.322 142.015L113.351 142.16C113.564 143.169 113.797 144.217 114.01 145.226C113.245 144.411 112.479 143.567 111.714 142.694C110.048 140.792 108.354 138.784 106.736 136.873L106.678 136.814C105.68 135.65 104.208 135.097 102.775 135.233C102.542 135.252 102.31 135.291 102.087 135.349C101.506 135.495 100.925 135.757 100.421 136.155C98.4165 137.697 98.0291 140.569 99.5691 142.587C100.46 143.751 101.371 144.867 102.3 145.954C103.162 146.953 104.053 147.933 104.973 148.903C105.942 149.912 106.94 150.902 107.995 151.881C108.315 152.172 108.654 152.464 108.983 152.764C109.758 153.434 110.581 154.103 111.53 154.773C112.237 155.248 112.964 155.723 114.097 156.208C114.242 156.267 114.387 156.325 114.562 156.393C114.726 156.451 114.91 156.509 115.114 156.558C115.298 156.606 115.55 156.664 115.772 156.703C115.898 156.723 116.044 156.742 116.179 156.752C116.315 156.761 116.45 156.781 116.625 156.781C116.799 156.781 116.935 156.781 117.119 156.771C117.303 156.761 117.496 156.732 117.69 156.703C118 156.645 118.194 156.587 118.484 156.49C118.998 156.325 119.588 156.024 120.092 155.636C121.157 154.85 121.777 153.696 122.019 152.842C122.291 151.959 122.31 151.28 122.3 150.678C122.262 149.495 122.039 148.622 121.777 147.807L121.787 147.797Z"
                    fill="#FFBF9D" />
                <path opacity="0.1"
                    d="M121.787 147.797C121.274 146.196 120.605 144.877 119.869 143.615C119.124 142.344 118.32 141.209 117.371 140.065C116.838 139.424 115.986 139.094 115.114 139.269C113.864 139.531 113.061 140.763 113.322 142.015L113.351 142.16C113.564 143.169 113.797 144.217 114.01 145.226C113.245 144.411 112.479 143.567 111.714 142.694C110.048 140.792 108.354 138.784 106.736 136.873L106.678 136.814C105.68 135.65 104.208 135.097 102.775 135.233C102.542 135.252 102.31 135.291 102.087 135.349C101.506 135.495 100.925 135.757 100.421 136.155C98.4165 137.697 98.0291 140.569 99.5691 142.587C100.237 143.46 100.915 144.304 101.603 145.129C101.835 145.401 102.068 145.682 102.291 145.944C103.153 146.943 104.044 147.923 104.964 148.893C105.932 149.902 106.93 150.892 107.986 151.872C108.276 152.143 108.586 152.405 108.886 152.677C108.915 152.706 108.944 152.725 108.973 152.755C109.748 153.424 110.572 154.093 111.521 154.763C112.228 155.238 112.954 155.714 114.087 156.199C114.233 156.257 114.378 156.315 114.552 156.383C114.717 156.441 114.901 156.499 115.104 156.548C115.288 156.596 115.54 156.655 115.763 156.694C115.889 156.713 116.034 156.732 116.17 156.742C116.305 156.752 116.441 156.771 116.615 156.771C116.789 156.771 116.925 156.771 117.109 156.761C117.293 156.752 117.487 156.723 117.68 156.694C117.99 156.635 118.184 156.577 118.475 156.48C118.988 156.315 119.579 156.014 120.082 155.626C121.148 154.84 121.768 153.686 122.01 152.832C122.281 151.949 122.3 151.27 122.291 150.669C122.252 149.485 122.029 148.612 121.768 147.797H121.787Z"
                    fill="black" fill-opacity="0.46" />
                <path
                    d="M112.702 141.51L112.324 139.599C112.189 138.9 112.237 138.182 112.46 137.513L112.886 136.252C113.167 135.417 114.01 134.894 114.881 135.02L116.199 135.214C117.206 135.359 117.903 136.31 117.748 137.319L117.574 138.435C117.574 138.435 117.458 141.598 115.86 143.548L115.172 143.402C114.048 143.159 113.138 142.471 112.702 141.51Z"
                    fill="#FFBF9D" />
                <path opacity="0.1"
                    d="M112.702 141.51L112.324 139.599C112.189 138.9 112.237 138.182 112.46 137.513L112.886 136.252C113.167 135.417 114.01 134.894 114.881 135.02L116.199 135.214C117.206 135.359 117.903 136.31 117.748 137.319L117.574 138.435C117.574 138.435 117.458 141.598 115.86 143.548L115.172 143.402C114.048 143.159 113.138 142.471 112.702 141.51Z"
                    fill="black" fill-opacity="0.46" />
                <path opacity="0.2"
                    d="M108.906 152.686C108.596 152.415 108.296 152.153 108.005 151.881C106.949 150.901 105.952 149.912 104.983 148.903C104.063 147.933 103.172 146.953 102.31 145.953C102.078 145.682 101.845 145.41 101.622 145.138C101.361 142.15 101.39 139.56 101.855 138.24C101.903 138.105 101.952 137.998 102 137.891C102 137.891 102.203 137.959 102.542 138.124C104.315 138.968 109.167 141.694 108.925 152.686H108.906Z"
                    fill="black" fill-opacity="0.46" />
                <path
                    d="M105.671 138.066C106.029 140.239 110.455 144.518 106.862 148.282C108.015 149.873 111.143 161.632 110 164.086C108.044 166.269 95.4432 168.549 84.7701 169.345C83.4335 165.134 83.9469 155.733 78.1648 142.441C76.8282 139.356 79.5788 134.826 85.7483 132.487C87.7435 131.731 91.0268 131.294 94.281 131.934C97.3028 132.526 105.032 134.166 105.661 138.066H105.671Z"
                    fill="#FB5607" />
                <path
                    d="M105.671 138.066C106.029 140.239 110.455 144.518 106.862 148.282C108.015 149.873 111.143 161.632 110 164.086C108.044 166.269 95.4432 168.549 84.7701 169.345C83.4335 165.134 83.9469 155.733 78.1648 142.441C76.8282 139.356 79.5788 134.826 85.7483 132.487C87.7435 131.731 91.0268 131.294 94.281 131.934C97.3028 132.526 105.032 134.166 105.661 138.066H105.671Z"
                    fill="#FB5607" />
                <g opacity="0.7">
                    <path
                        d="M110.01 164.086C108.044 166.269 95.4531 168.559 84.7799 169.345C84.1117 167.22 83.8986 163.776 83.1335 159.187C82.5136 155.52 81.5257 151.125 79.6468 146.07C79.2109 144.896 78.7267 143.683 78.1843 142.442C76.8477 139.366 79.5983 134.826 85.7678 132.497C87.763 131.74 91.0366 131.304 94.3005 131.944C97.332 132.526 105.051 134.176 105.69 138.076C106.049 140.249 110.475 144.527 106.882 148.282C108.034 149.873 111.172 161.632 110.02 164.086H110.01Z"
                        fill="#FB5607" />
                    <path
                        d="M110.01 164.086C108.044 166.269 95.4531 168.559 84.7799 169.345C84.1117 167.22 83.8986 163.776 83.1335 159.187C82.5136 155.52 81.5257 151.125 79.6468 146.07C79.2109 144.896 78.7267 143.683 78.1843 142.442C76.8477 139.366 79.5983 134.826 85.7678 132.497C87.763 131.74 91.0366 131.304 94.3005 131.944C97.332 132.526 105.051 134.176 105.69 138.076C106.049 140.249 110.475 144.527 106.882 148.282C108.034 149.873 111.172 161.632 110.02 164.086H110.01Z"
                        fill="#FB5607" />
                </g>
                <path
                    d="M102.581 111.405C102.581 111.405 105.157 108.33 98.3874 105.817C91.6174 103.304 83.0847 106.496 82.3583 115.703C81.632 124.91 77.322 126.501 81.1768 129.635C85.0412 132.769 91.2494 129.315 97.0993 130.013C102.949 130.712 103.85 133.361 104.722 128.219C105.593 123.077 104.964 116.557 104.964 116.557C104.964 116.557 106.107 111.706 102.571 111.405H102.581Z"
                    fill="#1A2E35" />
                <path
                    d="M88.2374 121.737C88.2277 125.104 87.695 130.479 85.7483 132.914C85.7483 132.914 88.7798 135.087 95.9856 139.598C98.6103 134.98 95.6369 134.049 95.6369 134.049C93.3028 132.836 93.9711 131.187 94.5618 128.829L88.2277 121.737H88.2374Z"
                    fill="#FFBF9D" />
                <path opacity="0.2"
                    d="M94.4746 128.8L88.954 124.279C88.7119 124.793 88.7603 125.608 89.0315 126.355C89.8257 128.49 92.092 130.459 94.1453 131.653C94.0872 130.682 94.2615 129.683 94.4843 128.8H94.4746Z"
                    fill="black" fill-opacity="0.46" />
                <path opacity="0.2"
                    d="M79.2397 145.042C80.4795 148.204 81.3608 151.125 82.0194 153.783C83.7143 149.96 85.1865 143.373 84.4504 140.598L79.2494 145.042H79.2397Z"
                    fill="black" fill-opacity="0.46" />
                <path
                    d="M87.6272 115.315C87.2495 120.778 86.9783 123.077 89.3027 126.201C92.7894 130.906 99.4335 130.14 101.4 124.901C103.162 120.186 103.482 112.046 98.5715 109.223C93.7289 106.438 88.0049 109.853 87.6369 115.315H87.6272Z"
                    fill="#FFBF9D" />
                <path
                    d="M95.3366 119.662C95.2881 120.06 95.4528 120.409 95.7143 120.448C95.9758 120.486 96.2276 120.186 96.276 119.788C96.3245 119.39 96.1598 119.041 95.8983 119.002C95.6368 118.973 95.385 119.264 95.3366 119.662Z"
                    fill="#1A2E35" />
                <path
                    d="M100.247 120.36C100.199 120.758 100.363 121.107 100.625 121.146C100.886 121.175 101.138 120.884 101.187 120.486C101.235 120.089 101.07 119.739 100.809 119.701C100.547 119.662 100.296 119.963 100.247 120.36Z"
                    fill="#1A2E35" />
                <path d="M100.693 119.71L101.69 119.555C101.69 119.555 101.099 120.244 100.693 119.71Z"
                    fill="#1A2E35" />
                <path
                    d="M99.017 120.322C99.017 120.322 99.4722 122.136 100.111 123.058C99.5206 123.485 98.6489 123.145 98.6489 123.145L99.017 120.322Z"
                    fill="#D54C38" />
                <path
                    d="M85.7775 119.924C85.9324 121.069 86.5523 121.951 87.2593 122.407C88.315 123.096 89.2835 122 89.361 120.613C89.4288 119.361 88.9639 117.498 87.7242 117.382C86.5039 117.275 85.6031 118.624 85.7775 119.924Z"
                    fill="#FFBF9D" />
                <path
                    d="M94.6781 117.091C94.7362 117.091 94.804 117.071 94.8524 117.013C95.5788 116.247 96.4408 116.402 96.4505 116.402C96.5764 116.421 96.7023 116.344 96.7314 116.218C96.7604 116.092 96.6733 115.965 96.5474 115.936C96.4989 115.936 95.4239 115.733 94.5231 116.683C94.436 116.78 94.436 116.926 94.5231 117.023C94.5716 117.062 94.6297 117.091 94.6878 117.091H94.6781Z"
                    fill="#1A2E35" />
                <path
                    d="M102.31 118.44C102.368 118.44 102.426 118.44 102.484 118.401C102.591 118.323 102.62 118.178 102.543 118.071C101.787 117.004 100.693 117.033 100.644 117.033C100.518 117.033 100.412 117.149 100.422 117.275C100.422 117.401 100.538 117.508 100.664 117.498C100.702 117.498 101.555 117.489 102.155 118.333C102.194 118.391 102.252 118.42 102.31 118.43V118.44Z"
                    fill="#1A2E35" />
                <path d="M95.792 119.002L96.7896 118.847C96.7896 118.847 96.1988 119.536 95.792 119.002Z"
                    fill="#1A2E35" />
                <path
                    d="M100.48 109.63C99.1333 114.559 89.7968 118.536 87.1624 118.963C84.528 119.39 84.2762 114.5 86.9687 111.386C89.6612 108.272 95.4626 105.623 100.489 109.63H100.48Z"
                    fill="#1A2E35" />
                <path
                    d="M99.7338 109.941C99.1624 113.298 96.6926 115.238 96.6926 115.238C96.6926 115.238 100.024 114.384 101.69 112.075L99.7338 109.931V109.941Z"
                    fill="#1A2E35" />
                <path
                    d="M97.448 125.095C96.8476 125.492 95.9468 126.366 95.9468 126.366C95.85 126.298 95.7628 126.23 95.6659 126.162C94.4166 125.221 94.1454 124.367 94.2229 123.707C94.2713 123.348 94.4262 123.048 94.5812 122.815C94.7555 122.553 94.9492 122.407 94.9492 122.407C95.3173 123.309 96.4117 124.28 97.0219 124.774C97.2737 124.988 97.448 125.104 97.448 125.104V125.095Z"
                    fill="#1A2E35" />
                <path
                    d="M97.0217 124.765L96.5665 125.124C95.3849 124.231 94.6779 123.445 94.5811 122.805C94.7554 122.543 94.9491 122.397 94.9491 122.397C95.3171 123.3 96.4116 124.27 97.0217 124.765Z"
                    fill="white" />
                <path
                    d="M95.6659 126.162C94.4166 125.221 94.1454 124.367 94.2229 123.707C94.6393 124.047 95.1042 124.503 95.4045 125.036C95.6369 125.444 95.6853 125.832 95.6659 126.171V126.162Z"
                    fill="#B84D3C" />
                <path
                    d="M108.334 140.783C108.266 141.035 108.421 141.268 108.683 141.297L113.245 141.937C113.496 141.976 113.758 141.801 113.826 141.549L116.102 132.682C116.17 132.429 116.015 132.138 115.763 132.1L111.201 131.459C110.949 131.42 110.678 131.663 110.61 131.905L108.334 140.773V140.783Z"
                    fill="#1A2E35" />
                <path opacity="0.5"
                    d="M111.124 131.925L108.819 140.88C108.751 141.132 108.867 141.326 109.119 141.365L112.983 141.908C113.245 141.947 113.739 141.869 113.807 141.617L116.112 132.633C116.179 132.381 115.763 132.109 115.501 132.08L111.637 131.537C111.385 131.498 111.191 131.682 111.124 131.935V131.925Z"
                    fill="white" />
                <path
                    d="M104.577 141.917L106.136 138.57L111.017 142.15C111.017 142.15 108.877 145.08 106.155 145.895L105.623 145.313C104.751 144.362 104.363 143.111 104.586 141.917H104.577Z"
                    fill="#FFBF9D" />
                <path
                    d="M110.058 137.522L111.589 138.987C112.286 139.657 112.315 140.753 111.656 141.461L111.017 142.15L106.136 138.57L107.85 137.367C108.538 136.882 109.467 136.96 110.068 137.532L110.058 137.522Z"
                    fill="#FFBF9D" />
                <path opacity="0.2"
                    d="M89.8644 160.118C87.8305 161.583 85.1671 160.506 83.1332 159.196C82.5133 155.529 81.5254 151.134 79.6465 146.08C79.7627 145.818 79.9177 145.604 80.092 145.459C82.1453 143.703 93.6513 157.392 89.8741 160.118H89.8644Z"
                    fill="black" fill-opacity="0.46" />
                <path
                    d="M85.8548 140.385C85.9129 140.656 86.0001 141.093 86.0873 141.462L86.3585 142.626C86.5522 143.402 86.7556 144.178 86.9783 144.935C87.4142 146.458 87.9372 147.933 88.5183 149.291C89.0994 150.64 89.787 151.872 90.4844 152.764C90.833 153.211 91.1914 153.541 91.482 153.783C91.7822 154.026 92.0243 154.152 92.2858 154.239C92.2858 154.239 92.4602 154.268 92.189 154.249C92.0921 154.249 92.0146 154.249 91.9565 154.249C91.8984 154.249 91.8112 154.268 91.7822 154.278C91.5691 154.326 91.5304 154.355 91.511 154.375C91.511 154.404 91.695 154.336 91.9178 154.22C92.373 153.987 92.9735 153.56 93.5546 153.085C94.7265 152.124 95.9565 150.989 97.1284 149.786C99.5207 147.409 101.874 144.809 104.247 142.286L104.286 142.238C105.148 141.316 106.601 141.277 107.521 142.141C108.266 142.849 108.431 143.936 108.005 144.819C106.388 148.117 104.547 151.193 102.417 154.229C101.322 155.733 100.208 157.237 98.804 158.692C98.097 159.43 97.3512 160.157 96.3439 160.895C95.8306 161.263 95.2495 161.642 94.4263 161.991C93.9904 162.165 93.5352 162.33 92.8766 162.427C92.7313 162.457 92.5376 162.466 92.373 162.486C92.2083 162.495 92.0146 162.505 91.8113 162.486C91.3173 162.466 91.2786 162.447 91.0558 162.418C89.574 162.243 88.1405 161.709 86.959 161.011C85.7677 160.312 84.7895 159.449 83.9759 158.576C82.3294 156.82 81.235 154.967 80.3149 153.123C79.4045 151.28 78.7168 149.427 78.1454 147.574C77.8645 146.643 77.603 145.711 77.3899 144.77C77.2834 144.295 77.1769 143.829 77.08 143.344C76.9832 142.849 76.9057 142.422 76.8185 141.821C76.4408 139.318 78.1551 136.979 80.6539 136.601C83.0752 136.232 85.3415 137.833 85.8258 140.21L85.8548 140.365V140.385Z"
                    fill="#FFBF9D" />
                <path
                    d="M196.296 192.367C192.596 195.191 188.15 194.899 186.146 192.154C185.041 190.64 180.499 194.482 180.499 194.482C185.041 198.169 184.712 199.566 185.409 200.944C186.116 202.321 187.279 203.486 188.218 202.69C189.342 201.739 189.661 201.07 191.075 199.896C192.731 198.528 194.514 197.053 197.351 194.521C198.484 193.512 197.942 191.116 196.296 192.367Z"
                    fill="#1A2E35" />
                <path
                    d="M187.56 192.231L182.998 196.976C176.112 194.269 170.397 191.756 165.632 189.457C143.502 178.765 141.923 172.605 138.833 172.275C138.456 172.236 137.845 172.411 137.041 172.76C129.797 175.845 106.669 192.6 94.7364 189.049C81.4773 185.11 84.7606 169.335 84.7606 169.335C120.334 157.509 142.572 155.762 151.705 161.535C160.828 167.298 187.55 192.222 187.55 192.222L187.56 192.231Z"
                    fill="#FB5607" />
                <path
                    d="M187.56 192.231L182.998 196.976C176.112 194.269 170.397 191.756 165.632 189.457C143.502 178.765 141.923 172.605 138.833 172.275C138.456 172.236 137.845 172.411 137.041 172.76C129.797 175.845 106.669 192.6 94.7364 189.049C81.4773 185.11 84.7606 169.335 84.7606 169.335C120.334 157.509 142.572 155.762 151.705 161.535C160.828 167.298 187.55 192.222 187.55 192.222L187.56 192.231Z"
                    fill="#FB5607" />
                <path opacity="0.2"
                    d="M187.56 192.231L182.998 196.976C176.112 194.269 170.397 191.756 165.632 189.457C143.502 178.765 141.923 172.605 138.833 172.275C138.456 172.236 137.845 172.411 137.041 172.76C129.797 175.845 106.669 192.6 94.7364 189.049C81.4773 185.11 84.7606 169.335 84.7606 169.335C120.334 157.509 142.572 155.762 151.705 161.535C160.828 167.298 187.55 192.222 187.55 192.222L187.56 192.231Z"
                    fill="black" fill-opacity="0.46" />
                <path opacity="0.2"
                    d="M165.632 189.466C143.501 178.775 141.923 172.614 138.833 172.284C138.455 172.246 137.845 172.42 137.041 172.77L137.128 172.478C137.128 172.478 146.688 169.937 153.138 172.158C157.806 173.769 163.075 183.965 165.632 189.457V189.466Z"
                    fill="black" fill-opacity="0.46" />
                <path d="M147.065 210.238L148.993 222.094H144.857L141.051 210.782L147.065 210.238Z" fill="#1A2E35" />
                <path d="M94.9105 210.238L92.9832 222.094H97.1284L100.935 210.782L94.9105 210.238Z" fill="#1A2E35" />
                <path opacity="0.1" d="M147.065 210.238L148.993 222.094H144.857L141.051 210.782L147.065 210.238Z"
                    fill="white" />
                <path opacity="0.1" d="M94.9105 210.238L92.9832 222.094H97.1284L100.935 210.782L94.9105 210.238Z"
                    fill="white" />
                <path d="M117.274 210.238L119.201 222.094H115.065L111.259 210.782L117.274 210.238Z" fill="#1A2E35" />
                <path d="M60.7022 210.238L58.7651 222.094H62.9104L66.7167 210.782L60.7022 210.238Z" fill="#1A2E35" />
                <path
                    d="M150.571 185.565H57.3996C54.7625 185.565 52.6248 187.707 52.6248 190.348V208.452C52.6248 211.094 54.7625 213.235 57.3996 213.235H150.571C153.209 213.235 155.346 211.094 155.346 208.452V190.348C155.346 187.707 153.209 185.565 150.571 185.565Z"
                    fill="#1A2E35" />
                <path opacity="0.1"
                    d="M150.571 185.565H57.3996C54.7625 185.565 52.6248 187.707 52.6248 190.348V208.452C52.6248 211.094 54.7625 213.235 57.3996 213.235H150.571C153.209 213.235 155.346 211.094 155.346 208.452V190.348C155.346 187.707 153.209 185.565 150.571 185.565Z"
                    fill="white" />
                <path opacity="0.2"
                    d="M150.572 185.565H93.2738C90.6368 185.565 88.499 187.707 88.499 190.348V208.452C88.499 211.094 90.6368 213.235 93.2738 213.235H150.572C153.209 213.235 155.346 211.094 155.346 208.452V190.348C155.346 187.707 153.209 185.565 150.572 185.565Z"
                    fill="white" />
                <path
                    d="M50.9977 211.78H78.0098C83.2892 211.78 87.5691 207.493 87.5691 202.205V182.277C87.5691 176.988 83.2892 172.701 78.0098 172.701H50.9977C45.7182 172.701 41.4383 176.988 41.4383 182.277L41.4383 202.205C41.4383 207.493 45.7182 211.78 50.9977 211.78Z"
                    fill="#1A2E35" />
                <path opacity="0.1"
                    d="M50.9977 211.78H78.0098C83.2892 211.78 87.5691 207.493 87.5691 202.205V182.277C87.5691 176.988 83.2892 172.701 78.0098 172.701H50.9977C45.7182 172.701 41.4383 176.988 41.4383 182.277L41.4383 202.205C41.4383 207.493 45.7182 211.78 50.9977 211.78Z"
                    fill="white" />
                <path opacity="0.2"
                    d="M81.1476 211.78C84.6924 211.78 87.5689 208.899 87.5689 205.348V179.133C87.5689 175.583 84.6924 172.701 81.1476 172.701C77.6028 172.701 74.7263 175.583 74.7263 179.133V205.348C74.7263 208.899 77.6028 211.78 81.1476 211.78Z"
                    fill="white" />
                <path
                    d="M160.198 218.115C160.131 216.592 160.305 214.321 159.346 210.732C159.346 210.732 164.179 208.17 164.421 210.004C164.857 213.342 167.966 218.222 171.83 218.881C174.029 219.26 172.586 220.938 170.998 221.355C168.479 222.015 168.257 221.617 166.058 220.948C164.169 220.375 163.433 220.152 161.893 220.56C160.615 220.899 160.266 219.648 160.198 218.115Z"
                    fill="#1A2E35" />
                <path
                    d="M165.128 210.237L159.269 213.002C159.269 213.002 144.876 191.609 142.833 185.953C142.833 185.953 133.012 186.157 119.743 185.74C117.341 185.672 115.908 185.72 113.312 185.565C113.312 185.565 125.835 174.253 137.128 172.477C137.7 172.38 138.271 172.322 138.833 172.283C138.833 172.283 148.876 171.488 151.714 173.923C154.562 176.358 165.128 210.227 165.128 210.227V210.237Z"
                    fill="#FB5607" />
                <path
                    d="M165.128 210.237L159.269 213.002C159.269 213.002 144.876 191.609 142.833 185.953C142.833 185.953 133.012 186.157 119.743 185.74C117.341 185.672 115.908 185.72 113.312 185.565C113.312 185.565 125.835 174.253 137.128 172.477C137.7 172.38 138.271 172.322 138.833 172.283C138.833 172.283 148.876 171.488 151.714 173.923C154.562 176.358 165.128 210.227 165.128 210.227V210.237Z"
                    fill="#FB5607" />
                <path opacity="0.2"
                    d="M165.128 210.237L159.269 213.002C159.269 213.002 144.876 191.609 142.833 185.953C142.833 185.953 133.012 186.157 119.743 185.74C117.341 185.672 115.908 185.72 113.312 185.565C113.312 185.565 125.835 174.253 137.128 172.477C137.7 172.38 138.271 172.322 138.833 172.283C138.833 172.283 148.876 171.488 151.714 173.923C154.562 176.358 165.128 210.227 165.128 210.227V210.237Z"
                    fill="black" fill-opacity="0.46" />
                <path opacity="0.2"
                    d="M137.128 172.478C132.721 177.765 125.496 182.432 119.743 185.74C117.341 185.672 115.908 185.721 113.312 185.565C113.312 185.565 125.835 174.253 137.128 172.478Z"
                    fill="black" fill-opacity="0.46" />
                <path d="M1012.41 189.883H698.649V190.038H1012.41V189.883Z" fill="#ECECEC" />
                <path d="M980.964 200.002H960.179V200.157H980.964V200.002Z" fill="#ECECEC" />
                <path d="M906.494 201.709H901.041V201.865H906.494V201.709Z" fill="#ECECEC" />
                <path d="M959.559 194.161H947.511V194.316H959.559V194.161Z" fill="#ECECEC" />
                <path d="M758.678 195.219H731.569V195.374H758.678V195.219Z" fill="#ECECEC" />
                <path d="M768.228 195.219H764.257V195.374H768.228V195.219Z" fill="#ECECEC" />
                <path d="M839.927 197.877H781.148V198.032H839.927V197.877Z" fill="#ECECEC" />
                <path
                    d="M747.049 173.247L749.205 178.22C750.037 180.14 751.933 181.384 754.027 181.384H763.07C764.271 181.384 765.423 180.905 766.269 180.058H783.163C784.486 180.058 785.728 179.423 786.505 178.343L788.742 175.235L747.056 173.247H747.049Z"
                    fill="#E1E1E1" />
                <path
                    d="M760.813 153.522C760.813 155.907 770.307 172.85 771.255 173.527C772.203 174.203 784.596 173.445 784.596 173.445L783.675 176.963H749.634L735.502 149.471L744.846 135.957L761.884 136.428C761.884 136.428 760.813 151.145 760.813 153.529V153.522Z"
                    fill="#E7E7E7" />
                <path
                    d="M760.813 153.522C760.813 155.907 770.307 172.85 771.255 173.527C772.203 174.203 784.596 173.445 784.596 173.445L783.675 176.963H749.634L735.502 149.471L744.846 135.957L761.884 136.428C761.884 136.428 760.813 151.145 760.813 153.529V153.522Z"
                    fill="#F0F0F0" />
                <path
                    d="M733.17 190.047C740.835 190.047 747.05 182.538 747.05 173.274C747.05 164.011 740.835 156.501 733.17 156.501C725.505 156.501 719.291 164.011 719.291 173.274C719.291 182.538 725.505 190.047 733.17 190.047Z"
                    fill="#E1E1E1" />
                <path
                    d="M730.844 183.857C735.677 183.857 739.595 179.119 739.595 173.274C739.595 167.43 735.677 162.691 730.844 162.691C726.011 162.691 722.094 167.43 722.094 173.274C722.094 179.119 726.011 183.857 730.844 183.857Z"
                    fill="#ECECEC" />
                <path
                    d="M728.839 168.731C726.827 168.731 725.19 170.705 725.19 173.138C725.19 175.57 726.82 177.544 728.839 177.544C730.858 177.544 732.488 175.57 732.488 173.138C732.488 170.705 730.858 168.731 728.839 168.731Z"
                    fill="#E7E7E7" />
                <path
                    d="M728.839 168.731C726.827 168.731 725.19 170.705 725.19 173.138C725.19 175.57 726.82 177.544 728.839 177.544C730.858 177.544 732.488 175.57 732.488 173.138C732.488 170.705 730.858 168.731 728.839 168.731Z"
                    fill="#E1E1E1" />
                <path
                    d="M810.493 147.94C810.493 147.94 797.964 157.567 793.183 177.4H773.124L792.132 146.43L802.158 142.256L810.5 147.94H810.493Z"
                    fill="#E7E7E7" />
                <path
                    d="M811.802 146.963C811.802 146.963 800.085 155.941 794.492 172.823C793.592 175.549 791.075 177.407 788.204 177.407H773.117L792.125 146.437L802.151 142.263L811.802 146.97V146.963Z"
                    fill="#E1E1E1" />
                <path
                    d="M810.581 147.742H802.84C801.367 147.742 799.928 148.132 798.707 148.952C794.11 152.012 783.245 160.559 782.106 174.094C781.949 175.938 780.428 177.394 778.58 177.394H744.942C739.288 177.394 733.743 175.891 728.859 173.042L719.243 167.426C717.115 166.182 716.01 163.716 716.514 161.311C717.66 155.784 720.886 146.294 730.121 142.584C730.264 142.516 730.046 142.461 730.489 142.407V136.668H754.6C754.6 136.668 749.764 148.214 749.764 152.983C749.764 157.492 754.518 174.736 760.67 176.512H769.086C771.337 176.512 773.41 175.16 774.515 173.192C778.607 165.875 787.699 146.902 784.862 128.975C784.534 126.877 786.144 124.725 788.265 124.725H799.089C799.089 124.725 808.829 136.019 811.966 145.57C812.273 146.499 811.577 147.742 810.595 147.742H810.581Z"
                    fill="#E7E7E7" />
                <path
                    d="M793.217 121.132H790.134C789.322 121.132 788.531 120.852 787.904 120.339L781.547 115.181C781.295 114.976 780.981 114.867 780.66 114.867H768.445C767.954 114.867 767.558 114.47 767.558 113.979C767.558 113.487 767.954 113.09 768.445 113.09H780.66C781.383 113.09 782.099 113.343 782.659 113.801L789.015 118.959C789.329 119.219 789.731 119.355 790.134 119.355H793.217C794.097 119.355 794.86 118.693 794.983 117.818L795.263 115.83C795.481 114.265 796.838 113.09 798.414 113.09H800.74C801.231 113.09 801.626 113.487 801.626 113.979C801.626 114.47 801.231 114.867 800.74 114.867H798.414C797.711 114.867 797.111 115.393 797.016 116.083L796.736 118.071C796.49 119.813 794.976 121.125 793.223 121.125L793.217 121.132Z"
                    fill="#E1E1E1" />
                <path
                    d="M787.767 117.374C787.767 117.374 787.801 119.465 785.851 119.328L785.21 121.596C785.025 122.238 785.128 122.935 785.482 123.502L786.867 125.723H799.696L800.706 123.824C801.033 123.202 800.924 122.437 800.433 121.931L796.62 118.023C796.218 117.606 795.658 117.374 795.079 117.374H787.767Z"
                    fill="#E7E7E7" />
                <path
                    d="M787.767 117.374C787.767 117.374 787.801 119.465 785.851 119.328L785.21 121.596C785.025 122.238 785.128 122.935 785.482 123.502L786.867 125.723H799.696L800.706 123.824C801.033 123.202 800.924 122.437 800.433 121.931L796.62 118.023C796.218 117.606 795.658 117.374 795.079 117.374H787.767Z"
                    fill="#E1E1E1" />
                <path
                    d="M809.777 190.047C817.442 190.047 823.656 182.538 823.656 173.274C823.656 164.011 817.442 156.501 809.777 156.501C802.111 156.501 795.897 164.011 795.897 173.274C795.897 182.538 802.111 190.047 809.777 190.047Z"
                    fill="#E1E1E1" />
                <path
                    d="M807.451 183.857C812.284 183.857 816.202 179.119 816.202 173.274C816.202 167.43 812.284 162.691 807.451 162.691C802.618 162.691 798.7 167.43 798.7 173.274C798.7 179.119 802.618 183.857 807.451 183.857Z"
                    fill="#ECECEC" />
                <path
                    d="M823.431 162.459C821.965 159.965 818.057 154.575 811.032 153.003C808.958 152.539 807.13 152.559 805.534 152.846L805.5 152.771L805.534 152.703C805.534 152.703 805.5 152.709 805.48 152.716L804.272 149.956H802.895C801.776 149.956 800.692 150.318 799.805 150.988L797.391 152.805L798.523 156.747C798.086 157.212 797.786 157.608 797.602 157.868C795.331 160.703 793.967 164.092 793.564 166.585C793.476 167.152 793.912 167.658 794.485 167.658H795.208C795.59 167.658 795.938 167.426 796.074 167.064C796.45 166.087 797.363 164.105 799.075 162.548L803.099 173.042L806.339 171.675L805.207 158.592C805.207 158.592 812.655 156.494 817.531 162.527C818.111 163.244 818.97 163.668 819.891 163.668H822.722C823.342 163.668 823.738 162.992 823.424 162.452L823.431 162.459Z"
                    fill="#E7E7E7" />
                <path
                    d="M823.431 162.459C821.965 159.965 818.057 154.575 811.032 153.003C808.958 152.539 807.13 152.559 805.534 152.846L805.5 152.771L805.534 152.703C805.534 152.703 805.5 152.709 805.48 152.716L804.272 149.956H802.895C801.776 149.956 800.692 150.318 799.805 150.988L797.391 152.805L798.523 156.747C798.086 157.212 797.786 157.608 797.602 157.868C795.331 160.703 793.967 164.092 793.564 166.585C793.476 167.152 793.912 167.658 794.485 167.658H795.208C795.59 167.658 795.938 167.426 796.074 167.064C796.45 166.087 797.363 164.105 799.075 162.548L803.099 173.042L806.339 171.675L805.207 158.592C805.207 158.592 812.655 156.494 817.531 162.527C818.111 163.244 818.97 163.668 819.891 163.668H822.722C823.342 163.668 823.738 162.992 823.424 162.452L823.431 162.459Z"
                    fill="#F0F0F0" />
                <path
                    d="M805.446 168.731C803.434 168.731 801.797 170.705 801.797 173.138C801.797 175.57 803.427 177.544 805.446 177.544C807.465 177.544 809.095 175.57 809.095 173.138C809.095 170.705 807.465 168.731 805.446 168.731Z"
                    fill="#E7E7E7" />
                <path
                    d="M805.446 168.731C803.434 168.731 801.797 170.705 801.797 173.138C801.797 175.57 803.427 177.544 805.446 177.544C807.465 177.544 809.095 175.57 809.095 173.138C809.095 170.705 807.465 168.731 805.446 168.731Z"
                    fill="#E1E1E1" />
                <path
                    d="M792.316 126.215C792.316 126.215 794.608 140.678 802.186 140.781C809.286 140.876 809.947 127.294 803.174 125.21C797.705 123.523 792.316 126.221 792.316 126.221V126.215Z"
                    fill="#E7E7E7" />
                <path
                    d="M792.316 126.215C792.316 126.215 794.608 140.678 802.186 140.781C809.286 140.876 809.947 127.294 803.174 125.21C797.705 123.523 792.316 126.221 792.316 126.221V126.215Z"
                    fill="#F0F0F0" />
                <path
                    d="M802.982 139.465C805.847 139.12 807.813 135.876 807.374 132.22C806.935 128.563 804.257 125.879 801.392 126.225C798.527 126.57 796.561 129.814 797 133.47C797.439 137.126 800.117 139.811 802.982 139.465Z"
                    fill="#F5F5F5" />
                <path d="M800.221 123.379H793.64L794.165 122.532H800.221V123.379Z" fill="#E7E7E7" />
                <path
                    d="M764.06 136.066V137.727C764.06 139.237 762.825 140.214 761.318 140.214H731.431C729.917 140.214 728.703 139.237 728.703 137.727V136.066C728.703 134.557 729.917 133.58 731.431 133.58H761.318C762.825 133.58 764.06 134.557 764.06 136.066Z"
                    fill="#E1E1E1" />
                <path
                    d="M754.341 136.066V137.727C754.341 139.237 753.311 140.214 751.797 140.214H731.438C729.924 140.214 728.709 139.237 728.709 137.727V136.066C728.709 134.557 729.924 133.58 731.438 133.58H751.797C753.311 133.58 754.341 134.557 754.341 136.066Z"
                    fill="#F0F0F0" />
                <path
                    d="M750.576 166.722V177.401H744.935C739.281 177.401 733.736 175.898 728.853 173.049L719.236 167.433C717.108 166.189 716.003 163.723 716.508 161.318C717.654 155.791 720.941 146.301 730.176 142.591L730.606 142.612H734.336C738.735 142.612 742.732 145.16 744.594 149.157L748.577 157.704C749.894 160.526 750.576 163.607 750.576 166.722Z"
                    fill="#F0F0F0" />
                <path d="M775.51 107.08L774.805 107.62L779.595 113.893L780.3 113.353L775.51 107.08Z" fill="#E1E1E1" />
                <path
                    d="M772.653 106.354H774.911C775.388 106.354 775.818 106.641 776.009 107.078L776.309 107.782C776.65 108.574 776.07 109.449 775.211 109.449H772.756C772.162 109.449 771.657 109.012 771.576 108.424L771.473 107.72C771.371 106.996 771.93 106.354 772.653 106.354Z"
                    fill="#E7E7E7" />
                <path d="M798.004 108.103L796.825 113.712L797.692 113.895L798.871 108.286L798.004 108.103Z"
                    fill="#E1E1E1" />
                <path
                    d="M801.101 106.354H798.673C798.182 106.354 797.766 106.716 797.698 107.201L797.541 108.322C797.459 108.916 797.916 109.449 798.516 109.449H800.944C801.435 109.449 801.851 109.087 801.919 108.602L802.076 107.481C802.158 106.887 801.701 106.354 801.101 106.354Z"
                    fill="#E7E7E7" />
                <path
                    d="M737.774 133.573V139.626L738.831 140.214V143.555C733.129 144.504 729.801 156.276 729.801 156.276H710.26C708.46 156.276 707 154.814 707 153.01V95.2516C707 93.4479 708.46 91.9858 710.26 91.9858H748.543C749.075 91.9858 749.58 92.1156 750.016 92.3411C751.073 92.874 751.79 93.9808 751.79 95.2448V133.573H737.767H737.774Z"
                    fill="#E7E7E7" />
                <path
                    d="M737.774 133.573V139.626L738.831 140.214V143.555C733.129 144.504 729.801 156.276 729.801 156.276H725.79V95.2245C725.79 93.6326 727.079 92.3481 728.662 92.3481H750.016C751.074 92.881 751.79 93.9878 751.79 95.2518V133.58H737.767L737.774 133.573Z"
                    fill="#ECECEC" />
                <path d="M1019.8 6.58545H930V189.203H1019.8V6.58545Z" fill="#ECECEC" />
                <path d="M999.124 27.3867H977.584V48.9636H999.124V27.3867Z" fill="#F5F5F5" />
                <path d="M972.528 27.3867H950.988V48.9636H972.528V27.3867Z" fill="#F5F5F5" />
                <path d="M972.528 54.0376H950.988V75.6145H972.528V54.0376Z" fill="#F5F5F5" />
                <path d="M999.124 54.0376H977.584V75.6145H999.124V54.0376Z" fill="#F5F5F5" />
                <path
                    d="M941.952 102.401C941.952 104.341 940.383 105.922 938.436 105.922C936.489 105.922 934.92 104.351 934.92 102.401C934.92 100.451 936.489 98.8789 938.436 98.8789C940.383 98.8789 941.952 100.451 941.952 102.401Z"
                    fill="#E1E1E1" />
                <path
                    d="M772.46 24.7667C772.46 22.8166 770.881 21.2255 768.925 21.2255C768.576 21.2255 768.228 21.2837 767.908 21.371C767.956 21.0121 767.985 20.6531 767.985 20.2844C767.985 16.1417 764.634 12.7946 760.509 12.7946C760.034 12.7946 759.579 12.8431 759.133 12.9207C757.981 11.0386 755.918 9.77734 753.555 9.77734C749.971 9.77734 747.065 12.6588 747.017 16.2388C746.978 16.2388 746.949 16.2388 746.91 16.2388C743.579 16.2388 740.886 18.9456 740.886 22.2733C740.886 25.601 743.588 28.3079 746.91 28.3079H769.041C770.949 28.2496 772.47 26.6876 772.47 24.7667H772.46Z"
                    fill="#F5F5F5" />
                <path
                    d="M886.341 22.4699C886.341 21.2765 885.373 20.3064 884.182 20.3064C883.969 20.3064 883.755 20.3355 883.562 20.3937C883.591 20.1802 883.61 19.9571 883.61 19.7242C883.61 17.1921 881.557 15.1353 879.029 15.1353C878.738 15.1353 878.458 15.1644 878.186 15.2129C877.479 14.0584 876.22 13.2822 874.768 13.2822C872.569 13.2822 870.797 15.048 870.758 17.2406C870.739 17.2406 870.709 17.2406 870.69 17.2406C868.646 17.2406 867 18.8996 867 20.937C867 22.9744 868.656 24.6334 870.69 24.6334H884.24C885.402 24.5946 886.341 23.6438 886.341 22.4699Z"
                    fill="#F5F5F5" />
                <path
                    d="M855.53 218.28C922.725 218.28 977.196 215.092 977.196 211.159C977.196 207.226 922.725 204.038 855.53 204.038C788.336 204.038 733.865 207.226 733.865 211.159C733.865 215.092 788.336 218.28 855.53 218.28Z"
                    fill="#F5F5F5" />
                <path
                    d="M689.564 196.112C689.564 196.112 692.683 189.291 689.119 182.558C685.555 175.835 684.518 174.244 686.794 172.866C689.07 171.488 690.107 178.251 690.107 178.251C690.107 178.251 692.024 173.603 690.436 168.733C688.857 163.863 687.86 155.946 690.019 155.092C692.179 154.239 690.436 164.979 692.305 168.636C692.305 168.636 693.884 164.561 694.136 160.652C694.387 156.742 693.99 150.503 695.695 148.903C697.4 147.302 698.494 148.408 696.818 157.033C695.143 165.658 695.153 172.672 695.153 172.672C695.153 172.672 698.852 161.36 701.341 161.03C703.831 160.7 703.821 164.367 701.7 167.54C699.569 170.722 695.472 176.407 694.794 179.337C694.794 179.337 698.862 170.819 702.523 173.429C706.184 176.039 699.337 181.181 696.286 183.043C693.235 184.906 691.124 196.548 691.124 196.548L689.555 196.102L689.564 196.112Z"
                    fill="#FB5607" />
                <path
                    d="M689.564 196.112C689.564 196.112 692.683 189.291 689.119 182.558C685.555 175.835 684.518 174.244 686.794 172.866C689.07 171.488 690.107 178.251 690.107 178.251C690.107 178.251 692.024 173.603 690.436 168.733C688.857 163.863 687.86 155.946 690.019 155.092C692.179 154.239 690.436 164.979 692.305 168.636C692.305 168.636 693.884 164.561 694.136 160.652C694.387 156.742 693.99 150.503 695.695 148.903C697.4 147.302 698.494 148.408 696.818 157.033C695.143 165.658 695.153 172.672 695.153 172.672C695.153 172.672 698.852 161.36 701.341 161.03C703.831 160.7 703.821 164.367 701.7 167.54C699.569 170.722 695.472 176.407 694.794 179.337C694.794 179.337 698.862 170.819 702.523 173.429C706.184 176.039 699.337 181.181 696.286 183.043C693.235 184.906 691.124 196.548 691.124 196.548L689.555 196.102L689.564 196.112Z"
                    fill="#FB5607" />
                <path opacity="0.6"
                    d="M689.564 196.112C689.564 196.112 692.683 189.291 689.119 182.558C685.555 175.835 684.518 174.244 686.794 172.866C689.07 171.488 690.107 178.251 690.107 178.251C690.107 178.251 692.024 173.603 690.436 168.733C688.857 163.863 687.86 155.946 690.019 155.092C692.179 154.239 690.436 164.979 692.305 168.636C692.305 168.636 693.884 164.561 694.136 160.652C694.387 156.742 693.99 150.503 695.695 148.903C697.4 147.302 698.494 148.408 696.818 157.033C695.143 165.658 695.153 172.672 695.153 172.672C695.153 172.672 698.852 161.36 701.341 161.03C703.831 160.7 703.821 164.367 701.7 167.54C699.569 170.722 695.472 176.407 694.794 179.337C694.794 179.337 698.862 170.819 702.523 173.429C706.184 176.039 699.337 181.181 696.286 183.043C693.235 184.906 691.124 196.548 691.124 196.548L689.555 196.102L689.564 196.112Z"
                    fill="white" />
                <path
                    d="M692.024 198.906C692.024 198.906 688.983 192.037 692.634 185.362C696.286 178.687 697.332 177.125 695.075 175.709C692.819 174.292 691.695 181.035 691.695 181.035C691.695 181.035 689.835 176.359 691.472 171.518C693.109 166.676 694.203 158.769 692.053 157.886C689.903 157.004 691.521 167.763 689.603 171.401C689.603 171.401 688.073 167.307 687.86 163.387C687.647 159.478 688.131 153.239 686.436 151.619C684.751 149.989 683.647 151.085 685.216 159.73C686.785 168.384 686.697 175.389 686.697 175.389C686.697 175.389 683.133 164.018 680.644 163.649C678.155 163.281 678.126 166.948 680.208 170.159C682.3 173.371 686.329 179.124 686.969 182.063C686.969 182.063 683.007 173.487 679.317 176.048C675.627 178.61 682.407 183.849 685.438 185.75C688.47 187.652 690.446 199.333 690.446 199.333L692.024 198.906Z"
                    fill="#FB5607" />
                <path
                    d="M692.024 198.906C692.024 198.906 688.983 192.037 692.634 185.362C696.286 178.687 697.332 177.125 695.075 175.709C692.819 174.292 691.695 181.035 691.695 181.035C691.695 181.035 689.835 176.359 691.472 171.518C693.109 166.676 694.203 158.769 692.053 157.886C689.903 157.004 691.521 167.763 689.603 171.401C689.603 171.401 688.073 167.307 687.86 163.387C687.647 159.478 688.131 153.239 686.436 151.619C684.751 149.989 683.647 151.085 685.216 159.73C686.785 168.384 686.697 175.389 686.697 175.389C686.697 175.389 683.133 164.018 680.644 163.649C678.155 163.281 678.126 166.948 680.208 170.159C682.3 173.371 686.329 179.124 686.969 182.063C686.969 182.063 683.007 173.487 679.317 176.048C675.627 178.61 682.407 183.849 685.438 185.75C688.47 187.652 690.446 199.333 690.446 199.333L692.024 198.906Z"
                    fill="#FB5607" />
                <path opacity="0.7"
                    d="M692.024 198.906C692.024 198.906 688.983 192.037 692.634 185.362C696.286 178.687 697.332 177.125 695.075 175.709C692.819 174.292 691.695 181.035 691.695 181.035C691.695 181.035 689.835 176.359 691.472 171.518C693.109 166.676 694.203 158.769 692.053 157.886C689.903 157.004 691.521 167.763 689.603 171.401C689.603 171.401 688.073 167.307 687.86 163.387C687.647 159.478 688.131 153.239 686.436 151.619C684.751 149.989 683.647 151.085 685.216 159.73C686.785 168.384 686.697 175.389 686.697 175.389C686.697 175.389 683.133 164.018 680.644 163.649C678.155 163.281 678.126 166.948 680.208 170.159C682.3 173.371 686.329 179.124 686.969 182.063C686.969 182.063 683.007 173.487 679.317 176.048C675.627 178.61 682.407 183.849 685.438 185.75C688.47 187.652 690.446 199.333 690.446 199.333L692.024 198.906Z"
                    fill="white" />
                <path d="M678 194.006H703.114L701.08 212.013H680.034L678 194.006Z" fill="#FB5607" />
                <path d="M678 194.006H703.114L701.08 212.013H680.034L678 194.006Z" fill="#FB5607" />
                <path
                    d="M951.634 196.62C950.729 196.62 950.055 196.448 949.996 196.434C949.421 196.282 949.084 195.7 949.236 195.124C949.388 194.555 949.969 194.211 950.537 194.356C950.564 194.363 952.803 194.912 953.9 193.602C954.303 193.119 954.937 192.126 954.68 190.875C954.389 189.439 952.988 188.05 950.63 186.852C946.137 184.569 946.937 182.008 947.287 181.28C948.02 179.744 949.976 178.871 951.304 179.48C951.839 179.724 952.077 180.36 951.832 180.896C951.588 181.432 950.954 181.67 950.412 181.425C950.2 181.366 949.408 181.683 949.183 182.272C948.892 183.013 949.817 184.039 951.594 184.939C954.594 186.461 956.338 188.314 956.774 190.445C957.091 192.007 956.642 193.661 955.538 194.978C954.415 196.322 952.823 196.62 951.634 196.62Z"
                    fill="#1A2E35" />
                <g opacity="0.2">
                    <path
                        d="M951.634 196.62C950.729 196.62 950.055 196.448 949.996 196.434C949.421 196.282 949.084 195.7 949.236 195.124C949.388 194.555 949.969 194.211 950.537 194.356C950.564 194.363 952.803 194.912 953.9 193.602C954.303 193.119 954.937 192.126 954.68 190.875C954.389 189.439 952.988 188.05 950.63 186.852C946.137 184.569 946.937 182.008 947.287 181.28C948.02 179.744 949.976 178.871 951.304 179.48C951.839 179.724 952.077 180.36 951.832 180.896C951.588 181.432 950.954 181.67 950.412 181.425C950.2 181.366 949.408 181.683 949.183 182.272C948.892 183.013 949.817 184.039 951.594 184.939C954.594 186.461 956.338 188.314 956.774 190.445C957.091 192.007 956.642 193.661 955.538 194.978C954.415 196.322 952.823 196.62 951.634 196.62Z"
                        fill="white" />
                </g>
                <path
                    d="M938.395 198.188C938.302 197.983 938.21 197.771 938.111 197.559C937.133 197.42 936.155 197.242 935.177 197.089C936.393 203.886 937.972 208.346 937.972 208.346C937.972 208.346 936.367 208.287 936.908 209.326H939.425C939.716 208.975 936.902 202.84 938.395 198.195V198.188Z"
                    fill="#1A2E35" />
                <path
                    d="M943.541 198.274C943.541 198.274 944.71 201.821 947.003 204.138L945.272 208.234C945.272 208.234 943.878 208.552 944.162 209.319H946.104C946.104 209.319 948.793 204.819 948.906 204.336C949.018 203.853 949.527 198.876 949.527 198.876L943.541 198.268V198.274Z"
                    fill="#1A2E35" />
                <path opacity="0.2"
                    d="M938.395 198.188C938.302 197.983 938.21 197.771 938.111 197.559C937.133 197.42 936.155 197.242 935.177 197.089C936.393 203.886 937.972 208.346 937.972 208.346C937.972 208.346 936.367 208.287 936.908 209.326H939.425C939.716 208.975 936.902 202.84 938.395 198.195V198.188Z"
                    fill="white" />
                <path opacity="0.2"
                    d="M943.541 198.274C943.541 198.274 944.71 201.821 947.003 204.138L945.272 208.234C945.272 208.234 943.878 208.552 944.162 209.319H946.104C946.104 209.319 948.793 204.819 948.906 204.336C949.018 203.853 949.527 198.876 949.527 198.876L943.541 198.268V198.274Z"
                    fill="white" />
                <path
                    d="M951.859 195.177C950.432 193.165 947.987 194.079 940.945 191.663C933.896 189.248 936.71 181.71 936.71 181.71L934.358 183.603L931.861 182.16C931.861 182.16 930.507 183.517 931.015 185.72C931.524 187.924 933.162 191.372 933.334 193.926L932.006 198.499C932.006 198.499 927.52 199.439 927.124 200.392C926.728 201.345 927.408 202.874 927.408 202.874L928.65 202.774L927.996 201.074C930.057 200.379 933.559 200.313 934.292 199.968C935.415 199.446 936.307 198.559 936.902 197.844C937.364 198.235 940.178 200.306 947.439 200.26C947.439 200.26 949.877 203.529 952.407 204.356L952.81 208.314C952.81 208.314 951.277 208.38 951.337 209.326H954.045L954.316 203.727C952.698 199.525 953.259 197.136 951.872 195.177H951.859Z"
                    fill="#1A2E35" />
                <path opacity="0.4"
                    d="M951.859 195.177C950.432 193.165 947.987 194.079 940.945 191.663C933.896 189.248 936.71 181.71 936.71 181.71L934.358 183.603L931.861 182.16C931.861 182.16 930.507 183.517 931.015 185.72C931.524 187.924 933.162 191.372 933.334 193.926L932.006 198.499C932.006 198.499 927.52 199.439 927.124 200.392C926.728 201.345 927.408 202.874 927.408 202.874L928.65 202.774L927.996 201.074C930.057 200.379 933.559 200.313 934.292 199.968C935.415 199.446 936.307 198.559 936.902 197.844C937.364 198.235 940.178 200.306 947.439 200.26C947.439 200.26 949.877 203.529 952.407 204.356L952.81 208.314C952.81 208.314 951.277 208.38 951.337 209.326H954.045L954.316 203.727C952.698 199.525 953.259 197.136 951.872 195.177H951.859Z"
                    fill="white" />
                <path
                    d="M933.585 184.516C933.486 184.708 933.328 184.827 933.228 184.781C933.129 184.728 933.136 184.536 933.228 184.337C933.328 184.145 933.486 184.026 933.585 184.072C933.684 184.119 933.678 184.317 933.585 184.516Z"
                    fill="#1A2E35" />
                <path
                    d="M932.125 182.279C932.125 182.279 931.887 182.067 931.801 182.067C931.716 182.067 931.61 182.477 931.61 182.477L932.125 182.279Z"
                    fill="#B84D3C" />
                <path opacity="0.2"
                    d="M934.352 183.602C934.352 183.602 934.854 184.013 935.151 184.423L936.082 182.471L934.352 183.602Z"
                    fill="black" fill-opacity="0.46" />
                <path
                    d="M931.939 76.8041C931.939 76.8041 932.09 75.0188 931.628 74.4125C931.165 73.8062 925.625 70.2524 925.356 70.6398C925.087 71.0272 923.936 73.9409 924.003 74.7662C924.07 75.5831 928.29 79.3389 928.921 78.8842C929.56 78.4294 931.939 76.8126 931.939 76.8126V76.8041Z"
                    fill="#FFBF9D" />
                <path
                    d="M957.992 68.8457C953.797 69.2752 946.575 82.1176 944.532 82.0165C942.481 81.9071 930.745 75.4311 930.745 75.4311L928.694 78.5638C928.694 78.5638 941.733 87.8946 945.289 87.6756C948.845 87.4567 958.975 75.0016 958.975 75.0016L958 68.8457H957.992Z"
                    fill="#FFBF9D" />
                <path
                    d="M963.296 171.846C966.768 176.225 969.896 180.192 972.62 183.089C975.343 186.028 976.747 187.838 976.747 187.838L979.446 186.289C979.446 186.289 976.958 182.347 973.578 176.907C970.711 172.293 967.189 166.591 964.003 161.32C959.875 154.498 956.285 148.385 955.344 146.195C954.671 144.637 956.495 138.666 958.521 133.033C960.573 127.298 962.826 121.917 962.826 121.917L955.478 109.453C955.478 109.453 952.485 117.748 949.829 126.506C948.08 132.233 946.491 138.17 945.953 142.102C945.205 147.601 954.679 160.974 963.305 171.846H963.296Z"
                    fill="#FFBF9D" />
                <path opacity="0.2"
                    d="M963.271 171.846C966.743 176.225 970.089 180.191 972.569 183.088C972.922 181.311 973.284 179.206 973.569 176.907C970.703 172.292 967.189 166.591 963.994 161.319C964.019 164.115 963.918 168.242 963.271 171.846Z"
                    fill="black" fill-opacity="0.46" />
                <path opacity="0.2"
                    d="M949.82 126.498L958.504 133.033C960.556 127.298 962.817 121.917 962.817 121.917L955.47 109.453C955.47 109.453 952.477 117.748 949.82 126.506V126.498Z"
                    fill="black" fill-opacity="0.46" />
                <path
                    d="M964.995 194.204L968.13 194.617C968.13 194.617 972.628 172.46 972.485 154.178C972.485 154.178 974.923 145.723 976.386 135.777C977.487 128.291 978.034 119.954 976.571 113.73L965.676 118.64L965.449 135.011L965.264 148.653L964.995 194.212V194.204Z"
                    fill="#FFBF9D" />
                <path opacity="0.2"
                    d="M965.448 135.003L976.377 135.769C977.479 128.283 978.025 119.946 976.562 113.723L965.667 118.632L965.44 135.003H965.448Z"
                    fill="black" fill-opacity="0.46" />
                <path
                    d="M979.261 184.57C978.941 184.335 976.226 188.41 976.226 188.41C976.226 188.41 976.831 192.655 975.604 195.392C974.377 198.129 976.756 197.893 978.731 195.299C980.707 192.705 982.22 190.726 983.624 188.891C985.028 187.046 982.582 187.004 979.261 184.579V184.57Z"
                    fill="#1A2E35" />
                <path
                    d="M975.217 191.484C975.108 191.484 974.965 191.433 974.822 191.248C974.73 191.139 974.696 190.996 974.721 190.844C974.763 190.549 975.007 190.204 975.293 189.901C974.881 190.086 974.469 190.204 974.259 190.061C974.124 189.968 974.074 189.8 974.124 189.556C974.175 189.328 974.293 189.16 974.494 189.042C975.116 188.68 976.26 189.042 976.319 189.067C976.335 189.067 976.352 189.084 976.361 189.092C976.361 189.092 976.377 189.118 976.386 189.126C976.386 189.126 976.394 189.151 976.403 189.168C976.403 189.168 976.403 189.202 976.403 189.219C976.327 189.572 975.932 191.332 975.31 191.476C975.285 191.476 975.251 191.484 975.226 191.484H975.217ZM976.058 189.522C975.629 189.884 975.024 190.473 974.974 190.878C974.965 190.962 974.974 191.038 975.024 191.088C975.15 191.248 975.226 191.223 975.251 191.223C975.537 191.156 975.873 190.28 976.066 189.522H976.058ZM975.2 189.143C974.982 189.143 974.772 189.177 974.612 189.269C974.478 189.345 974.402 189.463 974.368 189.614C974.351 189.69 974.335 189.817 974.393 189.85C974.578 189.977 975.301 189.648 975.957 189.244C975.755 189.202 975.478 189.151 975.209 189.151L975.2 189.143Z"
                    fill="#FFBF9D" />
                <path
                    d="M969.24 192.613C969.232 192.217 964.356 192.529 964.356 192.529C964.356 192.529 961.354 195.586 958.446 196.268C955.528 196.958 957.159 198.701 960.413 198.701H968.467C970.778 198.701 969.332 196.731 969.24 192.604V192.613Z"
                    fill="#1A2E35" />
                <path
                    d="M961.783 193.775C961.607 193.775 961.455 193.741 961.354 193.657C961.262 193.581 961.161 193.43 961.237 193.135C961.27 192.992 961.363 192.882 961.497 192.806C961.758 192.655 962.178 192.646 962.59 192.689C962.195 192.478 961.85 192.217 961.834 191.964C961.825 191.796 961.935 191.661 962.153 191.552C962.363 191.451 962.573 191.451 962.784 191.535C963.439 191.813 963.851 192.941 963.868 193C963.868 193.017 963.876 193.034 963.868 193.051C963.868 193.051 963.868 193.076 963.86 193.093C963.86 193.093 963.843 193.118 963.834 193.126C963.834 193.126 963.809 193.152 963.792 193.16C963.54 193.286 962.456 193.775 961.775 193.775H961.783ZM962.195 192.924C961.96 192.924 961.758 192.95 961.623 193.034C961.548 193.076 961.506 193.135 961.481 193.202C961.43 193.396 961.489 193.446 961.514 193.463C961.741 193.657 962.641 193.388 963.355 193.076C963.019 193 962.573 192.924 962.195 192.924ZM962.481 191.729C962.405 191.729 962.33 191.745 962.254 191.779C962.187 191.813 962.077 191.872 962.077 191.939C962.094 192.158 962.784 192.537 963.507 192.815C963.355 192.478 963.053 191.922 962.674 191.762C962.607 191.737 962.54 191.72 962.481 191.72V191.729Z"
                    fill="#FFBF9D" />
                <path
                    d="M960.615 129.959L948.837 123.778C952.544 112.502 955.882 106.102 955.882 106.102C967.458 108.089 966.407 117.26 966.407 117.26C966.407 117.26 963.456 123.382 960.615 129.967V129.959Z"
                    fill="#1A2E35" />
                <path opacity="0.1"
                    d="M961.371 128.216C961.119 128.788 960.867 129.369 960.615 129.959L948.837 123.778C952.544 112.502 955.882 106.102 955.882 106.102C963.027 107.331 965.364 111.289 966.104 114.144C966.558 115.912 966.407 117.251 966.407 117.251C966.407 117.251 963.961 122.338 961.371 128.216Z"
                    fill="white" />
                <path opacity="0.2"
                    d="M961.371 128.215C963.961 122.337 966.407 117.251 966.407 117.251C966.407 117.251 966.558 115.904 966.104 114.144C965.423 113.723 964.894 113.63 964.894 113.63C964.894 113.63 961.75 118.582 961.371 128.215Z"
                    fill="black" fill-opacity="0.46" />
                <path
                    d="M964.263 132.502L964.667 113.63L955.327 110.902C955.327 110.902 956.058 102.245 957.151 97.9753C957.151 97.9753 972.317 94.1941 974.629 99.3395C974.637 99.3564 974.646 99.4237 974.662 99.449L974.696 99.4995C974.696 99.4995 979.051 107.18 977.756 132.502H964.255H964.263Z"
                    fill="#1A2E35" />
                <path opacity="0.1"
                    d="M964.263 132.502L964.667 113.63L955.327 110.902C955.327 110.902 956.058 102.245 957.151 97.9753C957.151 97.9753 972.317 94.1941 974.629 99.3395C974.637 99.3564 974.646 99.4237 974.662 99.449L974.696 99.4995C974.696 99.4995 979.051 107.18 977.756 132.502H964.255H964.263Z"
                    fill="white" />
                <path d="M974.797 96.7282V99.3051L957.37 97.9577V94.9092L974.797 96.7282Z" fill="#1A2E35" />
                <path d="M968.678 100.018L969.551 100.062L969.778 95.6219L968.905 95.5771L968.678 100.018Z"
                    fill="#1A2E35" />
                <path d="M961.025 98.4217L964.869 98.7666L965.13 95.8477L961.286 95.5028L961.025 98.4217Z"
                    fill="white" />
                <path d="M957.939 98.9349L958.812 98.9795L959.038 94.5388L958.165 94.4942L957.939 98.9349Z"
                    fill="#1A2E35" />
                <path opacity="0.1"
                    d="M968.962 95.6609L968.735 100.102L969.609 100.146L969.836 95.7057L968.962 95.6609Z"
                    fill="white" />
                <path opacity="0.1" d="M958.139 94.4617L957.913 98.9023L958.787 98.947L959.013 94.5063L958.139 94.4617Z"
                    fill="white" />
                <path
                    d="M957.151 95.2127L974.713 96.7369C975.133 90.1936 975.545 85.9745 979.412 74.3195C979.749 73.3006 980.11 72.2142 980.505 71.0773C978.118 70.311 975.688 69.7299 973.216 69.3173C970.61 68.8541 967.971 68.5762 965.331 68.4836C961.909 68.4583 957.992 68.8457 957.992 68.8457C957.992 68.8457 957.428 68.9805 957.084 72.6016C956.756 76.0122 956.445 82.825 957.151 95.2127Z"
                    fill="#FFBF9D" />
                <path opacity="0.6"
                    d="M980.514 71.0773C980.118 72.2142 979.749 73.3006 979.421 74.328C979.059 75.4227 978.723 76.4501 978.42 77.4186C977.697 79.7091 977.134 81.6881 976.68 83.4397C975.293 88.8714 975.007 92.2568 974.721 96.7369L957.159 95.2127C956.453 82.825 956.764 76.0038 957.092 72.5932C957.445 68.972 958 68.8373 958 68.8373C958 68.8373 959.043 68.7362 960.522 68.6436C961.909 68.551 963.683 68.4668 965.339 68.4836C967.987 68.5762 970.619 68.8541 973.225 69.3173C974.73 69.5699 976.234 69.8815 977.706 70.2689C978.647 70.5131 979.589 70.791 980.514 71.0858V71.0773Z"
                    fill="#E1E1E1" />
                <path d="M978.883 131.736L963.498 131.593L963.767 133.917L978.202 133.774L978.883 131.736Z"
                    fill="#FFBF9D" />
                <path d="M961.59 129.824L948.786 122.868L948.105 124.915L960.497 131.054L961.59 129.824Z"
                    fill="#FFBF9D" />
                <path
                    d="M966.785 72.3742C971.115 71.8184 972.418 69.9657 972.418 69.9657C970.644 68.2983 970.972 65.8309 971.417 64.2898C971.661 63.4392 971.947 62.875 971.947 62.875L966.735 63.8519C966.869 64.7108 966.928 65.4435 966.937 66.0498C966.945 66.7235 966.886 67.2541 966.794 67.6667C966.44 69.2246 965.549 69.2499 965.549 69.2499C964.633 70.9594 966.777 72.3826 966.777 72.3826L966.785 72.3742Z"
                    fill="#FFBF9D" />
                <path opacity="0.2"
                    d="M966.945 66.0414C966.953 66.7151 966.894 67.2456 966.802 67.6583C968.87 67.3888 970.442 65.7298 971.426 64.2898C971.67 63.4392 971.955 62.875 971.955 62.875L966.743 63.8519C966.878 64.7108 966.937 65.4435 966.945 66.0498V66.0414Z"
                    fill="black" fill-opacity="0.46" />
                <path
                    d="M974.528 50.3193C974.528 50.3193 977.529 47.6582 980.514 49.0224C983.498 50.3867 983.784 52.5509 982.632 54.9257C981.48 57.3005 980.556 59.3806 981.808 60.248C983.061 61.1153 982.699 63.0522 981.48 63.6333C980.261 64.2059 979.471 64.9386 980.833 65.5449C980.833 65.5449 980.615 65.6712 979.471 64.9386C978.319 64.2059 979.253 63.4143 979.614 62.8754C979.976 62.3364 979.328 63.0017 978.252 61.4522C977.176 59.8943 977.891 58.1932 978.471 56.3826C979.042 54.572 975.066 54.8331 975.066 54.8331L974.528 50.3361V50.3193Z"
                    fill="#1A2E35" />
                <path
                    d="M972.334 48.0455C972.334 48.0455 969.114 45.9233 965.802 46.3359C962.489 46.7486 959.362 50.6308 960.32 53.3677C961.27 56.1046 962.279 57.4015 961.346 58.4036C960.413 59.4141 960.018 61.25 961.27 62.0416C961.27 62.0416 960.48 61.2079 961.27 60.231C962.061 59.2626 965.02 59.7594 965.802 57.5699C966.583 55.3804 970.392 54.8077 970.392 54.8077L972.662 62.0668C972.662 62.0668 976.209 61.0815 976.571 55.9277C976.932 50.7739 975.285 47.5402 972.334 48.037V48.0455Z"
                    fill="#1A2E35" />
                <path
                    d="M967.802 49.3844C963.271 49.5528 961.901 52.0371 961.741 56.7277C961.539 62.5889 962.994 66.6985 968.609 65.2416C976.243 63.2626 975.327 49.1065 967.802 49.3844Z"
                    fill="#FFBF9D" />
                <path
                    d="M964.667 56.3657C964.667 56.3657 964.087 57.5784 963.414 58.2942C963.414 58.2942 963.826 58.9005 964.625 58.7658L964.658 56.3657H964.667Z"
                    fill="#B84D3C" />
                <path
                    d="M967.424 55.894C967.424 56.2646 967.634 56.5677 967.887 56.5677C968.139 56.5677 968.332 56.2561 968.324 55.8856C968.315 55.5151 968.113 55.2119 967.861 55.2119C967.609 55.2119 967.416 55.5235 967.424 55.894Z"
                    fill="#1A2E35" />
                <path d="M967.971 55.2289L967.155 54.9258C967.155 54.9258 967.567 55.5995 967.971 55.2289Z"
                    fill="#1A2E35" />
                <path
                    d="M962.792 55.8765C962.792 56.247 963.002 56.5502 963.254 56.5502C963.507 56.5502 963.7 56.2386 963.691 55.868C963.691 55.4975 963.481 55.1943 963.229 55.1943C962.977 55.1943 962.783 55.5059 962.792 55.8765Z"
                    fill="#1A2E35" />
                <path d="M963.338 55.2114L962.523 54.9082C962.523 54.9082 962.935 55.5819 963.338 55.2114Z"
                    fill="#1A2E35" />
                <path d="M967.357 52.7613C967.357 52.7613 968.626 52.5508 969.349 53.3761" stroke="#1A2E35"
                    stroke-width="0.71" stroke-linecap="round" stroke-linejoin="round" />
                <path d="M964.053 52.6856C964.053 52.6856 963.238 52.4162 962.262 53.1236" stroke="#1A2E35"
                    stroke-width="0.71" stroke-linecap="round" stroke-linejoin="round" />
                <path
                    d="M965.356 60.5349C965.642 61.0738 965.945 62.0928 965.945 62.0928C966.045 62.0844 966.138 62.0675 966.239 62.0507C967.55 61.8654 968.105 61.3517 968.315 60.8296C968.433 60.5433 968.441 60.2569 968.416 60.0212C968.391 59.7517 968.315 59.5664 968.315 59.5664C967.676 60.0801 966.466 60.3412 965.81 60.4591C965.541 60.5096 965.364 60.5264 965.364 60.5264L965.356 60.5349Z"
                    fill="#1A2E35" />
                <path
                    d="M965.802 60.4678L965.987 60.9226C967.222 60.7457 968.072 60.4594 968.408 60.0299C968.383 59.7605 968.307 59.5752 968.307 59.5752C967.668 60.0889 966.457 60.3499 965.802 60.4678Z"
                    fill="white" />
                <path
                    d="M966.23 62.0507C967.542 61.8654 968.097 61.3517 968.307 60.8296C967.861 60.9054 967.332 61.057 966.886 61.318C966.541 61.5201 966.348 61.7896 966.23 62.0507Z"
                    fill="#FD5652" />
                <path
                    d="M973.04 56.854C973.04 56.854 970.778 53.1992 970.997 50.3107C970.997 50.3107 961.876 46.9674 961.775 56.1213C961.775 56.1213 960.598 48.0453 968.383 47.5738C976.159 47.1022 976.554 58.5214 972.662 62.0751C972.662 62.0751 974.444 59.1446 973.04 56.854Z"
                    fill="#1A2E35" />
                <path
                    d="M972.334 57.8397C972.334 57.107 973.048 55.8438 974.41 55.9365C975.823 56.0375 976.596 58.9007 973.132 59.726C972.636 59.8439 972.334 59.3639 972.342 57.8397H972.334Z"
                    fill="#FFBF9D" />
                <path
                    d="M970.997 50.311C970.997 50.311 970.316 51.4563 970.316 52.8795C970.316 54.3027 972.3 57.0312 972.334 57.8396C972.367 58.6396 971.77 59.9954 972.418 60.8291C972.418 60.8291 972.048 59.5323 973.124 58.7912C974.2 58.0501 975.184 55.7848 973.973 54.1848C972.762 52.5847 973.914 50.5131 973.914 50.5131C973.914 50.5131 972.25 48.6268 970.997 50.3194V50.311Z"
                    fill="#1A2E35" />
                <path
                    d="M980.514 71.077C985.928 75.6919 973.082 88.7616 966.886 91.8101C960.69 94.8586 939.253 98.5556 939.253 98.5556L938.824 94.9092C938.824 94.9092 961.144 89.7132 964.036 86.8669C966.928 84.0121 979.438 70.1675 980.505 71.077H980.514Z"
                    fill="#FFBF9D" />
                <path
                    d="M938.824 94.9091C938.824 94.9091 937.319 93.9406 936.563 94.0754C935.806 94.2101 930.098 97.4775 930.316 97.8902C930.535 98.3112 932.578 100.678 933.334 101.006C934.091 101.326 939.371 99.3302 939.261 98.5555C939.152 97.7807 938.832 94.9091 938.832 94.9091H938.824Z"
                    fill="#FFBF9D" />
                <path
                    d="M977.706 70.2689C975.907 72.1384 971.955 74.7659 966.079 74.3111C960.875 73.9069 960.438 70.1342 960.514 68.6436C961.901 68.551 963.675 68.4668 965.331 68.4836C967.979 68.5762 970.61 68.8541 973.216 69.3173C974.721 69.5699 976.226 69.8815 977.697 70.2689H977.706Z"
                    fill="#FFBF9D" />
                <path d="M821.37 206.881L826.62 207.434L827.608 196.092L822.358 195.539L821.37 206.881Z"
                    fill="#FCB373" />
                <path d="M795.172 206.492H800.257L800.673 194.685H795.588L795.172 206.492Z" fill="#FCB373" />
                <path
                    d="M800.964 205.91H794.785C794.571 205.91 794.397 206.056 794.349 206.259L793.341 210.8C793.254 211.207 793.516 211.605 793.923 211.692C793.981 211.702 794.029 211.712 794.087 211.712C796.082 211.683 797.545 211.557 800.053 211.557C801.603 211.557 806.271 211.722 808.402 211.722C810.533 211.722 810.814 209.607 809.942 209.413C806.019 208.559 803.065 207.365 801.816 206.24C801.584 206.027 801.274 205.91 800.964 205.92V205.91Z"
                    fill="#1A2E35" />
                <path
                    d="M801.312 206.609C801.264 206.599 801.225 206.55 801.225 206.502C801.225 206.453 801.244 206.405 801.283 206.385C801.467 206.269 803.104 205.26 803.675 205.551C803.801 205.609 803.889 205.745 803.879 205.891C803.918 206.133 803.821 206.385 803.627 206.541C803.336 206.735 802.997 206.832 802.649 206.803C802.203 206.793 801.748 206.725 801.312 206.618V206.609ZM801.661 206.444C802.252 206.647 802.901 206.609 803.472 206.356C803.598 206.25 803.656 206.085 803.637 205.92C803.637 205.823 803.588 205.774 803.559 205.774C803.511 205.745 803.462 205.735 803.404 205.745C802.784 205.861 802.194 206.104 801.661 206.444Z"
                    fill="#FB5607" />
                <path
                    d="M801.312 206.609C801.264 206.599 801.225 206.55 801.225 206.502C801.225 206.453 801.244 206.405 801.283 206.385C801.467 206.269 803.104 205.26 803.675 205.551C803.801 205.609 803.889 205.745 803.879 205.891C803.918 206.133 803.821 206.385 803.627 206.541C803.336 206.735 802.997 206.832 802.649 206.803C802.203 206.793 801.748 206.725 801.312 206.618V206.609ZM801.661 206.444C802.252 206.647 802.901 206.609 803.472 206.356C803.598 206.25 803.656 206.085 803.637 205.92C803.637 205.823 803.588 205.774 803.559 205.774C803.511 205.745 803.462 205.735 803.404 205.745C802.784 205.861 802.194 206.104 801.661 206.444Z"
                    fill="#FB5607" />
                <path
                    d="M801.283 206.638C801.283 206.638 801.225 206.57 801.225 206.531C801.225 206.463 801.351 204.998 801.942 204.513C802.077 204.387 802.271 204.329 802.455 204.358C802.639 204.358 802.804 204.494 802.843 204.678C802.949 205.212 801.932 206.337 801.409 206.618H801.351C801.351 206.618 801.312 206.638 801.283 206.638ZM802.097 204.659C801.738 205.115 801.525 205.677 801.496 206.25C802.019 205.852 802.668 205.008 802.6 204.678C802.6 204.649 802.581 204.552 802.426 204.552H802.368C802.271 204.552 802.174 204.591 802.097 204.659Z"
                    fill="#FB5607" />
                <path
                    d="M801.283 206.638C801.283 206.638 801.225 206.57 801.225 206.531C801.225 206.463 801.351 204.998 801.942 204.513C802.077 204.387 802.271 204.329 802.455 204.358C802.639 204.358 802.804 204.494 802.843 204.678C802.949 205.212 801.932 206.337 801.409 206.618H801.351C801.351 206.618 801.312 206.638 801.283 206.638ZM802.097 204.659C801.738 205.115 801.525 205.677 801.496 206.25C802.019 205.852 802.668 205.008 802.6 204.678C802.6 204.649 802.581 204.552 802.426 204.552H802.368C802.271 204.552 802.174 204.591 802.097 204.659Z"
                    fill="#FB5607" />
                <path
                    d="M827.172 205.745H820.993C820.779 205.745 820.605 205.891 820.557 206.094L819.549 210.635C819.462 211.042 819.724 211.44 820.131 211.527C820.189 211.537 820.237 211.547 820.295 211.547C822.29 211.518 823.753 211.392 826.261 211.392C827.811 211.392 832.479 211.557 834.61 211.557C836.741 211.557 837.022 209.442 836.15 209.247C832.227 208.394 829.273 207.2 828.024 206.075C827.792 205.862 827.482 205.745 827.172 205.755V205.745Z"
                    fill="#1A2E35" />
                <path
                    d="M827.53 206.454C827.482 206.444 827.443 206.396 827.443 206.347C827.443 206.299 827.462 206.25 827.501 206.231C827.685 206.114 829.322 205.105 829.893 205.396C830.019 205.454 830.107 205.59 830.097 205.736C830.136 205.978 830.039 206.231 829.845 206.386C829.554 206.58 829.215 206.677 828.867 206.648C828.421 206.638 827.966 206.57 827.53 206.463V206.454ZM827.879 206.289C828.47 206.493 829.119 206.454 829.69 206.201C829.816 206.095 829.874 205.93 829.855 205.765C829.855 205.668 829.806 205.619 829.777 205.619C829.729 205.59 829.68 205.581 829.622 205.59C829.002 205.707 828.412 205.949 827.879 206.289Z"
                    fill="#FB5607" />
                <path
                    d="M827.53 206.454C827.482 206.444 827.443 206.396 827.443 206.347C827.443 206.299 827.462 206.25 827.501 206.231C827.685 206.114 829.322 205.105 829.893 205.396C830.019 205.454 830.107 205.59 830.097 205.736C830.136 205.978 830.039 206.231 829.845 206.386C829.554 206.58 829.215 206.677 828.867 206.648C828.421 206.638 827.966 206.57 827.53 206.463V206.454ZM827.879 206.289C828.47 206.493 829.119 206.454 829.69 206.201C829.816 206.095 829.874 205.93 829.855 205.765C829.855 205.668 829.806 205.619 829.777 205.619C829.729 205.59 829.68 205.581 829.622 205.59C829.002 205.707 828.412 205.949 827.879 206.289Z"
                    fill="#FB5607" />
                <path
                    d="M827.491 206.473C827.491 206.473 827.433 206.405 827.433 206.366C827.433 206.298 827.559 204.833 828.15 204.348C828.286 204.222 828.479 204.164 828.663 204.193C828.847 204.193 829.012 204.329 829.051 204.513C829.157 205.047 828.14 206.172 827.617 206.453H827.559C827.559 206.453 827.521 206.473 827.491 206.473ZM828.305 204.494C827.947 204.95 827.734 205.512 827.705 206.085C828.228 205.687 828.876 204.843 828.809 204.513C828.809 204.484 828.789 204.387 828.634 204.387H828.576C828.479 204.387 828.383 204.426 828.305 204.494Z"
                    fill="#FB5607" />
                <path
                    d="M827.491 206.473C827.491 206.473 827.433 206.405 827.433 206.366C827.433 206.298 827.559 204.833 828.15 204.348C828.286 204.222 828.479 204.164 828.663 204.193C828.847 204.193 829.012 204.329 829.051 204.513C829.157 205.047 828.14 206.172 827.617 206.453H827.559C827.559 206.453 827.521 206.473 827.491 206.473ZM828.305 204.494C827.947 204.95 827.734 205.512 827.705 206.085C828.228 205.687 828.876 204.843 828.809 204.513C828.809 204.484 828.789 204.387 828.634 204.387H828.576C828.479 204.387 828.383 204.426 828.305 204.494Z"
                    fill="#FB5607" />
                <path opacity="0.2"
                    d="M822.358 195.539L827.608 196.092L827.094 201.942L821.845 201.389L822.358 195.539Z" fill="black"
                    fill-opacity="0.46" />
                <path opacity="0.2" d="M795.588 194.695H800.673L800.46 200.788H795.366L795.588 194.695Z" fill="black"
                    fill-opacity="0.46" />
                <path
                    d="M797.68 91.1279H824.683C827.249 105.176 835.288 154.879 829.525 199.158L820.383 198.023C820.383 198.023 821.225 139.23 813.157 117.497C812.228 129.13 811.124 141.509 810.165 148.087C807.811 164.299 802.785 199.721 802.785 199.721H793.477C793.477 199.721 795.375 165.813 796.257 149.882C797.216 132.584 797.632 94.669 797.671 91.1182L797.68 91.1279Z"
                    fill="#1A2E35" />
                <path opacity="0.2"
                    d="M797.68 91.1279H824.683C827.249 105.176 835.288 154.879 829.525 199.158L820.383 198.023C820.383 198.023 821.225 139.23 813.157 117.497C812.228 129.13 811.124 141.509 810.165 148.087C807.811 164.299 802.785 199.721 802.785 199.721H793.477C793.477 199.721 795.375 165.813 796.257 149.882C797.216 132.584 797.632 94.669 797.671 91.1182L797.68 91.1279Z"
                    fill="white" />
                <path
                    d="M825.845 47.9741C825.845 47.9741 842.136 63.3903 849.68 65.971C857.225 68.5517 876.567 78.0983 876.567 78.0983L879.54 75.7505C879.55 75.6147 881.709 77.2931 881.729 78.4573C881.748 79.3013 879.598 86.3643 879.153 86.3546C877.08 86.3352 874.785 81.6007 874.785 81.6007C874.785 81.6007 850 75.1296 845.555 73.1795C841.109 71.2294 822.804 56.9289 822.804 56.9289L825.835 47.9741H825.845Z"
                    fill="#FCB373" />
                <path d="M832.47 76.4398L834.62 91.2545H863.85L886.194 89.4403V75.5182L854.93 75.46L832.47 76.4398Z"
                    fill="#FB5607" />
                <path d="M832.47 76.4398L834.62 91.2545H863.85L886.194 89.4403V75.5182L854.93 75.46L832.47 76.4398Z"
                    fill="#FB5607" />
                <path opacity="0.6"
                    d="M832.47 76.4398L834.62 91.2545H863.85L886.194 89.4403V75.5182L854.93 75.46L832.47 76.4398Z"
                    fill="white" />
                <path opacity="0.2" d="M832.47 76.4399L862.116 76.7795L863.85 91.2546H834.62L832.47 76.4399Z"
                    fill="white" />
                <path opacity="0.4" d="M862.116 76.7794L886.194 75.5182L854.93 75.46L832.47 76.4398L862.116 76.7794Z"
                    fill="white" />
                <path opacity="0.2"
                    d="M843.55 76.5661L847.346 76.3721L852.063 76.44L847.801 76.6146V77.4296L843.743 77.3325L843.55 76.5661Z"
                    fill="black" fill-opacity="0.46" />
                <path opacity="0.2" d="M865.923 75.4795L864.683 75.5668H868.896L870.426 75.4892L865.923 75.4795Z"
                    fill="black" fill-opacity="0.46" />
                <path opacity="0.2" d="M863.85 77.9824L864.179 79.4086L872.208 78.9429V77.5361L863.85 77.9824Z"
                    fill="black" fill-opacity="0.46" />
                <path opacity="0.2" d="M876.431 88.0531V89.7897L885.206 89.0912V87.5098L876.431 88.0531Z" fill="black"
                    fill-opacity="0.46" />
                <path opacity="0.2"
                    d="M854.01 87.5098C854.01 87.5098 854.833 88.3829 856.412 88.6449V90.1487L855.211 90.5658H859.337L857.148 90.0905L857.061 88.6449C857.061 88.6449 858.949 88.3635 859.327 87.5098H857.061L856.663 87.9658L857.39 87.9949L856.663 88.4994V88.2374H856.073L856.663 87.5098H854H854.01Z"
                    fill="black" fill-opacity="0.46" />
                <path opacity="0.2"
                    d="M813.167 117.507C814.358 120.709 815.346 124.706 816.179 129.207C816.935 118.856 813.913 107.883 813.913 107.883L813.157 117.507H813.167Z"
                    fill="black" fill-opacity="0.46" />
                <path
                    d="M822.223 44.2682C822.223 44.2682 805.041 43.4338 792.247 46.6645C792.247 46.6645 796.15 81.659 796.392 99.297C796.412 100.878 797.739 102.13 799.317 102.081L825.099 101.179C826.668 101.121 827.889 99.8112 827.831 98.2395C827.453 88.7996 825.971 58.3067 822.233 44.2585L822.223 44.2682Z"
                    fill="#FB5607" />
                <path
                    d="M822.223 44.2682C822.223 44.2682 805.041 43.4338 792.247 46.6645C792.247 46.6645 796.15 81.659 796.392 99.297C796.412 100.878 797.739 102.13 799.317 102.081L825.099 101.179C826.668 101.121 827.889 99.8112 827.831 98.2395C827.453 88.7996 825.971 58.3067 822.233 44.2585L822.223 44.2682Z"
                    fill="#FB5607" />
                <path d="M797.109 101.14V104.09L827.385 102.615L827.152 100.189L797.109 101.14Z" fill="#1A2E35" />
                <path d="M811.366 51.3696C811.366 51.3696 817.138 77.3511 816.296 101.499" stroke="#1A2E35"
                    stroke-miterlimit="10" />
                <path
                    d="M791.772 60.868C791.772 60.868 797.138 75.6924 798.726 78.8066C800.315 81.9209 831.559 84.9867 831.559 84.9867C831.559 84.9867 838.484 89.469 839.695 89.2555C840.896 89.0421 843.831 83.1822 842.571 82.5516C841.312 81.9209 837.496 77.5939 835.433 77.6618C833.37 77.7297 831.559 80.0388 831.559 80.0388C831.559 80.0388 805.816 72.646 804.441 72.1027C803.453 71.7049 799.385 57.3462 799.385 57.3462L791.763 60.868H791.772Z"
                    fill="#FCB373" />
                <path
                    d="M802.01 44.2681C802.01 44.2681 810.562 52.2139 812.005 51.3698C813.448 50.5258 813.884 44.7823 813.884 44.7823L802.019 44.2778L802.01 44.2681Z"
                    fill="white" />
                <path
                    d="M802.019 44.9374C804.499 47.1979 810.571 46.3636 810.571 46.3636C810.571 46.3636 814.358 45.3255 813.564 44.1418C811.327 43.7732 810.252 42.7254 809.806 41.3962C809.545 40.6201 809.506 39.7469 809.583 38.8446C809.613 38.3692 809.69 37.8939 809.767 37.4185L802.261 31.8496C803.249 35.5266 804.45 42.2888 802.019 44.9568V44.9374Z"
                    fill="#FCB373" />
                <path opacity="0.2"
                    d="M803.995 35.3716C804.295 39.8829 807.995 41.1248 809.806 41.377C809.545 40.6009 809.506 39.7277 809.584 38.8254L803.995 35.3716Z"
                    fill="black" fill-opacity="0.46" />
                <path
                    d="M816.993 21.4502C816.993 21.4502 818.126 26.6116 817.216 30.308C816.305 34.0044 815.22 34.3924 814.049 34.6447C812.867 34.8969 812.944 21.8965 812.944 21.8965L816.993 21.4502Z"
                    fill="#FB5607" />
                <path
                    d="M816.993 21.4502C816.993 21.4502 818.126 26.6116 817.216 30.308C816.305 34.0044 815.22 34.3924 814.049 34.6447C812.867 34.8969 812.944 21.8965 812.944 21.8965L816.993 21.4502Z"
                    fill="#FB5607" />
                <path opacity="0.5"
                    d="M815.937 22.1777C815.937 22.1777 817.671 27.2712 816.77 30.9676C815.86 34.664 814.775 35.0521 813.603 35.3043C812.421 35.5566 812.499 22.5561 812.499 22.5561L815.937 22.1777Z"
                    fill="black" fill-opacity="0.46" />
                <path
                    d="M815.317 19.7524C815.317 19.7524 817.516 26.5049 814.291 29.7841C811.065 33.0634 808.925 20.1599 808.925 20.1599L815.317 19.7524Z"
                    fill="#1A2E35" />
                <path
                    d="M804.547 37.0701C806.755 39.3403 809.767 39.5247 812.16 38.3022C813.7 37.5164 814.968 36.1484 815.608 34.3827C815.695 34.1498 815.763 33.9073 815.83 33.6648C816.935 29.134 816.276 21.6248 811.346 19.5971C807.84 18.1224 803.801 19.7814 802.329 23.2935C801.903 24.2928 801.729 25.3794 801.806 26.466C802.077 31.5109 802 34.4894 804.547 37.0701Z"
                    fill="#FCB373" />
                <path
                    d="M809.458 27.9116C809.429 28.3191 809.671 28.6586 809.942 28.6586C810.213 28.6586 810.426 28.3288 810.436 27.9116C810.436 27.5041 810.223 27.1646 809.952 27.1646C809.69 27.1646 809.467 27.4944 809.458 27.9116Z"
                    fill="#1A2E35" />
                <path
                    d="M814.097 27.9311C814.068 28.3386 814.31 28.6782 814.581 28.6782C814.852 28.6782 815.065 28.3483 815.075 27.9311C815.075 27.5236 814.862 27.1841 814.591 27.1841C814.32 27.1841 814.107 27.5333 814.097 27.9311Z"
                    fill="#1A2E35" />
                <path
                    d="M812.615 28.1249C813.099 29.3862 813.748 30.5698 814.562 31.6467C813.99 32.0542 813.264 32.1803 812.586 32.0057L812.615 28.1152V28.1249Z"
                    fill="#EC873E" />
                <path
                    d="M808.024 26.3983C808.111 26.408 808.199 26.3789 808.257 26.3013C808.615 25.8065 809.186 25.5057 809.806 25.496C809.942 25.5057 810.048 25.4087 810.068 25.2729C810.077 25.1371 809.981 25.0303 809.845 25.0109C809.07 25.0012 808.334 25.3699 807.879 26.0005C807.792 26.1072 807.811 26.2528 807.918 26.3401C807.918 26.3401 807.985 26.3789 808.024 26.3886V26.3983Z"
                    fill="#1A2E35" />
                <path
                    d="M816.092 26.3303C816.092 26.3303 816.189 26.3497 816.237 26.34C816.353 26.2818 816.412 26.146 816.353 26.0199C816.034 25.3019 815.385 24.7974 814.62 24.6519C814.484 24.6325 814.368 24.7295 814.349 24.8556C814.339 24.9915 814.426 25.1079 814.552 25.1273C815.153 25.2631 815.656 25.6706 815.908 26.2333C815.947 26.2915 816.014 26.3303 816.092 26.3303Z"
                    fill="#1A2E35" />
                <path
                    d="M805.535 20.1792L805.903 22.3912C805.196 22.8084 804.789 23.6525 805.157 24.5159C805.951 26.3593 805.022 29.2989 803.637 30.5214C803.637 30.5214 803.559 29.7161 802.881 29.9392C802.203 30.1624 802.581 34.373 803.995 36.3231C803.995 36.3231 801.903 34.5864 800.576 30.2109C799.346 26.1652 799.065 22.7502 799.84 21.13L805.525 20.1792H805.535Z"
                    fill="#1A2E35" />
                <path
                    d="M799.588 30.5891C800.14 31.7339 801.128 32.6071 802.329 33.034C803.918 33.5773 804.809 32.1705 804.45 30.6182C804.121 29.2406 802.891 27.2517 801.254 27.3972C799.617 27.5427 798.93 29.1823 799.588 30.5988V30.5891Z"
                    fill="#FCB373" />
                <path opacity="0.5"
                    d="M816.567 22.5852C816.567 22.5852 806.785 22.1292 806.194 24.1569C805.613 26.1942 806.155 30.366 806.3 33.2669C806.397 35.2558 804.78 36.2259 803.211 36.3133C803.869 36.2065 804.557 35.6632 804.625 34.4214C804.693 32.84 803.637 25.9032 804.615 24.574C805.584 23.2352 808.935 22.1874 812.373 21.9351C815.802 21.6829 816.567 22.5852 816.567 22.5852Z"
                    fill="black" fill-opacity="0.46" />
                <path
                    d="M804.673 23.0604C804.712 23.2836 804.557 23.4873 804.344 23.5261C804.121 23.5649 803.918 23.4097 803.879 23.1963C803.84 22.9731 803.995 22.7694 804.208 22.7306C804.421 22.6918 804.634 22.847 804.673 23.0604Z"
                    fill="#FB5607" />
                <path
                    d="M804.673 23.0604C804.712 23.2836 804.557 23.4873 804.344 23.5261C804.121 23.5649 803.918 23.4097 803.879 23.1963C803.84 22.9731 803.995 22.7694 804.208 22.7306C804.421 22.6918 804.634 22.847 804.673 23.0604Z"
                    fill="#FB5607" />
                <path
                    d="M812.828 32.9664C812.557 33.6261 812.305 34.8582 812.305 34.8582C812.189 34.8582 812.073 34.8582 811.957 34.8485C810.397 34.7806 809.69 34.2276 809.39 33.6358C809.225 33.3157 809.187 32.9761 809.187 32.7044C809.187 32.3843 809.254 32.1611 809.254 32.1611C810.058 32.6947 811.511 32.8791 812.296 32.9373C812.625 32.9664 812.828 32.9664 812.828 32.9664Z"
                    fill="#1A2E35" />
                <path
                    d="M812.305 32.9275L812.141 33.4805C810.668 33.4126 809.642 33.1604 809.196 32.6947C809.196 32.3745 809.264 32.1514 809.264 32.1514C810.068 32.685 811.521 32.8693 812.305 32.9275Z"
                    fill="white" />
                <path
                    d="M811.966 34.8485C810.407 34.7806 809.7 34.2276 809.4 33.6357C809.932 33.6843 810.572 33.791 811.124 34.0626C811.55 34.2664 811.802 34.5574 811.976 34.8485H811.966Z"
                    fill="#FD5652" />
                <path
                    d="M800.421 45.1608L801.245 42.2891C801.245 42.2891 809.942 45.5198 811.366 51.37C811.366 51.37 810.756 44.2779 812.886 42.2891L814.368 44.1712C814.368 44.1712 814.552 51.2439 811.995 52.1073C809.438 52.9805 800.421 45.1511 800.421 45.1511V45.1608Z"
                    fill="#FB5607" />
                <path
                    d="M800.421 45.1608L801.245 42.2891C801.245 42.2891 809.942 45.5198 811.366 51.37C811.366 51.37 810.756 44.2779 812.886 42.2891L814.368 44.1712C814.368 44.1712 814.552 51.2439 811.995 52.1073C809.438 52.9805 800.421 45.1511 800.421 45.1511V45.1608Z"
                    fill="#FB5607" />
                <path opacity="0.2"
                    d="M800.421 45.1608L801.245 42.2891C801.245 42.2891 809.942 45.5198 811.366 51.37C811.366 51.37 810.756 44.2779 812.886 42.2891L814.368 44.1712C814.368 44.1712 814.552 51.2439 811.995 52.1073C809.438 52.9805 800.421 45.1511 800.421 45.1511V45.1608Z"
                    fill="black" fill-opacity="0.46" />
                <path d="M830.571 201.302L819.259 199.614L819.608 196.471L831.375 198.023L830.571 201.302Z"
                    fill="#FB5607" />
                <path d="M830.571 201.302L819.259 199.614L819.608 196.471L831.375 198.023L830.571 201.302Z"
                    fill="#FB5607" />
                <path opacity="0.6"
                    d="M830.571 201.302L819.259 199.614L819.608 196.471L831.375 198.023L830.571 201.302Z"
                    fill="white" />
                <path d="M803.918 199.808H792.935V196.519L804.324 196.306L803.918 199.808Z" fill="#FB5607" />
                <path d="M803.918 199.808H792.935V196.519L804.324 196.306L803.918 199.808Z" fill="#FB5607" />
                <path opacity="0.6" d="M803.918 199.808H792.935V196.519L804.324 196.306L803.918 199.808Z"
                    fill="white" />
                <path
                    d="M1113.81 178.162C1113.87 172.574 1112.71 171.691 1112.06 170.692C1111.42 169.692 1110.94 169.13 1110.89 167.917C1110.85 166.714 1110.47 161.446 1110.4 159.758C1110.31 158.069 1109.69 155.566 1109.87 154.703C1109.88 154.645 1109.89 154.596 1109.9 154.538C1109.26 154.121 1108.53 153.966 1107.75 154.082C1107.59 154.111 1107.45 154.15 1107.32 154.189C1107.01 154.276 1106.68 154.373 1106.2 154.266C1106.03 154.228 1105.86 154.179 1105.71 154.14C1105.35 154.033 1105.01 153.946 1104.67 153.985C1104.43 154.014 1104.23 154.072 1104.04 154.16C1104.06 154.305 1104.1 154.489 1104.15 154.703C1104.33 155.566 1103.72 158.069 1103.65 159.758C1103.57 161.446 1103.22 166.714 1103.18 167.917C1103.14 169.12 1102.66 169.683 1102.02 170.692C1101.38 171.701 1100.22 172.583 1100.31 178.172C1100.39 183.76 1100.5 196.178 1100.5 196.178C1100.48 196.751 1100.5 197.381 1100.53 197.973C1100.61 199.118 1100.83 200.476 1101.61 201.378C1102.16 202.009 1103 202.184 1103.8 202.193C1104.64 202.203 1105.86 202.203 1107.09 202.203C1108.32 202.203 1109.55 202.203 1110.38 202.184C1111.1 202.174 1111.9 202.028 1112.44 201.495C1113.82 200.146 1113.65 197.895 1113.66 196.149C1113.66 196.149 1113.72 183.731 1113.79 178.143L1113.81 178.162Z"
                    fill="white" />
                <path
                    d="M1106.17 202.455C1105.28 202.455 1104.45 202.455 1103.82 202.446C1102.76 202.426 1101.97 202.125 1101.47 201.553C1100.59 200.534 1100.4 199.04 1100.33 198.012C1100.3 197.41 1100.29 196.78 1100.3 196.188C1100.3 196.071 1100.19 183.711 1100.1 178.191C1100.02 173.185 1100.94 171.885 1101.61 170.934C1101.7 170.818 1101.78 170.701 1101.85 170.585C1101.93 170.449 1102.01 170.332 1102.09 170.206C1102.6 169.421 1102.94 168.906 1102.97 167.917C1102.99 167.257 1103.1 165.404 1103.21 163.599C1103.31 162.057 1103.39 160.524 1103.43 159.748C1103.46 159.01 1103.6 158.147 1103.72 157.303C1103.88 156.275 1104.04 155.198 1103.94 154.751C1103.89 154.528 1103.85 154.344 1103.83 154.189L1103.8 154.024L1103.96 153.946C1104.16 153.849 1104.38 153.781 1104.65 153.752C1105.03 153.704 1105.4 153.801 1105.78 153.917C1105.93 153.965 1106.1 154.004 1106.25 154.043C1106.67 154.13 1106.96 154.043 1107.26 153.965C1107.41 153.927 1107.56 153.878 1107.72 153.849C1108.55 153.723 1109.34 153.888 1110.03 154.334L1110.16 154.421L1110.1 154.713C1109.99 155.188 1110.16 156.255 1110.32 157.293C1110.45 158.128 1110.58 159.001 1110.62 159.728C1110.66 160.505 1110.76 162.037 1110.86 163.58C1110.98 165.375 1111.09 167.238 1111.12 167.888C1111.16 168.868 1111.5 169.391 1112.01 170.168C1112.09 170.284 1112.18 170.41 1112.26 170.546C1112.33 170.662 1112.41 170.769 1112.5 170.895C1113.18 171.846 1114.1 173.136 1114.04 178.142C1113.97 183.731 1113.91 196.062 1113.91 196.149C1113.91 196.324 1113.91 196.508 1113.91 196.692C1113.91 198.332 1113.93 200.379 1112.62 201.66C1112.13 202.145 1111.4 202.397 1110.41 202.407C1109.56 202.426 1108.35 202.426 1107.11 202.426C1106.79 202.426 1106.47 202.426 1106.16 202.426L1106.17 202.455ZM1104.32 154.315C1104.33 154.421 1104.35 154.538 1104.38 154.674C1104.5 155.207 1104.34 156.226 1104.17 157.39C1104.04 158.215 1103.92 159.078 1103.89 159.787C1103.85 160.563 1103.76 162.096 1103.67 163.638C1103.56 165.433 1103.44 167.296 1103.42 167.936C1103.39 169.052 1102.99 169.673 1102.47 170.459C1102.4 170.575 1102.32 170.701 1102.23 170.827C1102.16 170.944 1102.07 171.07 1101.98 171.196C1101.34 172.098 1100.48 173.321 1100.56 178.181C1100.64 183.702 1100.75 196.062 1100.75 196.188C1100.73 196.77 1100.75 197.381 1100.78 197.973C1100.88 199.486 1101.22 200.563 1101.81 201.252C1102.22 201.737 1102.88 201.98 1103.82 201.99C1104.65 201.999 1105.87 201.999 1107.1 201.999C1108.33 201.999 1109.55 201.999 1110.39 201.98C1111.26 201.96 1111.89 201.757 1112.3 201.359C1113.47 200.214 1113.46 198.361 1113.45 196.721C1113.45 196.537 1113.45 196.353 1113.45 196.168C1113.43 195.179 1113.53 181.393 1113.56 178.162C1113.62 173.301 1112.75 172.079 1112.11 171.177C1112.02 171.05 1111.94 170.934 1111.86 170.808C1111.77 170.682 1111.7 170.556 1111.62 170.439C1111.1 169.653 1110.7 169.042 1110.66 167.926C1110.64 167.276 1110.51 165.423 1110.4 163.629C1110.3 162.076 1110.19 160.543 1110.16 159.767C1110.12 159.059 1109.99 158.205 1109.86 157.371C1109.68 156.197 1109.53 155.188 1109.64 154.654C1109.08 154.324 1108.44 154.198 1107.78 154.305C1107.64 154.324 1107.5 154.363 1107.38 154.402C1107.05 154.499 1106.68 154.606 1106.15 154.489C1105.97 154.451 1105.81 154.402 1105.64 154.354C1105.3 154.257 1104.99 154.169 1104.69 154.208C1104.54 154.227 1104.41 154.257 1104.29 154.295L1104.32 154.315Z"
                    fill="#E1E1E1" />
                <path
                    d="M1105.81 154.199C1105.97 154.248 1106.14 154.287 1106.3 154.316C1106.64 154.384 1106.85 154.316 1107.15 154.248C1107.32 154.209 1107.5 154.161 1107.72 154.122C1108.62 153.986 1109.53 154.131 1110.31 154.519C1110.32 154.384 1110.31 154.325 1110.31 154.325C1110.31 154.325 1110.66 152.802 1108.99 152.802C1108.99 152.802 1107.03 152.802 1107.02 152.802H1105.05C1103.73 152.802 1103.68 153.763 1103.71 154.16C1103.92 154.093 1104.13 154.044 1104.38 154.015C1104.91 153.957 1105.37 154.073 1105.82 154.19L1105.81 154.199Z"
                    fill="#E1E1E1" />
                <path
                    d="M1111.05 171.323C1110.97 171.197 1110.89 171.08 1110.81 170.964C1110.26 170.13 1109.75 169.344 1109.7 167.966C1109.68 167.336 1109.55 165.502 1109.45 163.736V163.697C1109.35 162.184 1109.24 160.622 1109.21 159.826C1109.2 159.564 1109.17 159.273 1109.13 158.963H1104.86C1104.82 159.273 1104.79 159.574 1104.78 159.836C1104.74 160.632 1104.64 162.194 1104.56 163.707V163.746C1104.45 165.521 1104.33 167.355 1104.32 167.986C1104.28 169.363 1103.75 170.149 1103.21 170.983C1103.13 171.1 1103.06 171.216 1102.98 171.342C1102.89 171.478 1102.8 171.604 1102.71 171.75C1102.15 172.545 1101.38 173.632 1101.45 178.182C1101.48 180.191 1101.52 182.199 1101.54 184.217C1101.57 187.758 1101.63 191.299 1101.63 194.84C1101.63 196.276 1101.57 197.664 1102.4 198.925C1103.14 200.06 1104.93 199.992 1106.1 200.002C1107.39 200.002 1108.7 200.021 1109.99 199.866C1110.64 199.788 1111.34 199.594 1111.82 199.148C1112.68 198.362 1112.48 196.266 1112.49 195.228C1112.51 192.589 1112.52 189.941 1112.53 187.302C1112.55 184.256 1112.57 181.219 1112.61 178.173C1112.66 173.622 1111.89 172.536 1111.33 171.74C1111.23 171.604 1111.13 171.469 1111.05 171.342V171.323Z"
                    fill="#ECECEC" />
                <path
                    d="M1100.34 178.919H1105.22C1108.29 178.919 1110.78 181.423 1110.78 184.498V185.895C1110.78 188.971 1108.29 191.474 1105.22 191.474H1100.34V178.929V178.919Z"
                    fill="#E1E1E1" />
                <path
                    d="M1131.21 202.988C1131.28 197.4 1130.12 196.517 1129.47 195.518C1128.83 194.518 1128.34 193.956 1128.3 192.743C1128.26 191.54 1127.88 186.272 1127.8 184.584C1127.71 182.896 1127.09 180.393 1127.28 179.529C1127.29 179.471 1127.3 179.422 1127.31 179.364C1126.67 178.947 1125.93 178.792 1125.16 178.908C1124.99 178.937 1124.86 178.976 1124.72 179.015C1124.41 179.102 1124.08 179.199 1123.61 179.093C1123.43 179.054 1123.27 179.005 1123.11 178.966C1122.76 178.86 1122.42 178.772 1122.08 178.811C1121.84 178.84 1121.63 178.898 1121.45 178.986C1121.47 179.131 1121.51 179.316 1121.55 179.529C1121.74 180.393 1121.13 182.896 1121.05 184.584C1120.97 186.272 1120.62 191.54 1120.59 192.743C1120.55 193.946 1120.06 194.509 1119.42 195.518C1118.78 196.527 1117.62 197.41 1117.71 202.998C1117.8 208.586 1117.9 221.004 1117.9 221.004C1117.88 221.577 1117.9 222.207 1117.93 222.799C1118.01 223.944 1118.23 225.302 1119.02 226.205C1119.56 226.835 1120.4 227.01 1121.21 227.02C1122.05 227.029 1123.26 227.029 1124.5 227.029C1125.73 227.029 1126.95 227.029 1127.78 227.01C1128.51 227 1129.3 226.855 1129.85 226.321C1131.22 224.972 1131.06 222.722 1131.07 220.975C1131.07 220.975 1131.12 208.557 1131.19 202.969L1131.21 202.988Z"
                    fill="white" />
                <path
                    d="M1123.57 227.281C1122.68 227.281 1121.85 227.281 1121.22 227.272C1120.15 227.252 1119.37 226.952 1118.86 226.379C1117.98 225.36 1117.8 223.866 1117.73 222.838C1117.69 222.236 1117.68 221.606 1117.69 221.014C1117.69 220.898 1117.58 208.537 1117.5 203.017C1117.42 198.011 1118.34 196.711 1119.01 195.76C1119.09 195.644 1119.17 195.527 1119.24 195.411C1119.33 195.275 1119.4 195.159 1119.48 195.033C1120 194.247 1120.33 193.732 1120.36 192.743C1120.38 192.083 1120.5 190.23 1120.61 188.426C1120.7 186.883 1120.79 185.35 1120.83 184.574C1120.86 183.837 1120.99 182.973 1121.12 182.129C1121.27 181.101 1121.44 180.024 1121.33 179.578C1121.28 179.354 1121.24 179.17 1121.23 179.015L1121.2 178.85L1121.35 178.772C1121.55 178.675 1121.78 178.607 1122.05 178.578C1122.43 178.53 1122.79 178.627 1123.17 178.743C1123.33 178.792 1123.49 178.83 1123.65 178.869C1124.06 178.957 1124.35 178.869 1124.65 178.792C1124.81 178.753 1124.95 178.704 1125.12 178.675C1125.94 178.549 1126.74 178.714 1127.42 179.16L1127.55 179.248L1127.49 179.539C1127.39 180.014 1127.56 181.081 1127.71 182.119C1127.84 182.954 1127.98 183.827 1128.01 184.555C1128.05 185.331 1128.15 186.864 1128.26 188.406C1128.37 190.201 1128.49 192.064 1128.52 192.714C1128.56 193.694 1128.9 194.218 1129.41 194.994C1129.49 195.11 1129.57 195.236 1129.65 195.372C1129.73 195.489 1129.81 195.595 1129.89 195.721C1130.57 196.672 1131.49 197.962 1131.43 202.969C1131.37 208.557 1131.31 220.888 1131.31 220.975C1131.31 221.15 1131.31 221.334 1131.31 221.519C1131.31 223.158 1131.33 225.205 1130.02 226.486C1129.53 226.971 1128.8 227.223 1127.8 227.233C1126.96 227.252 1125.75 227.252 1124.51 227.252C1124.19 227.252 1123.87 227.252 1123.56 227.252L1123.57 227.281ZM1121.71 179.141C1121.73 179.248 1121.75 179.364 1121.78 179.5C1121.89 180.034 1121.74 181.052 1121.56 182.216C1121.44 183.041 1121.31 183.905 1121.28 184.613C1121.24 185.389 1121.16 186.922 1121.06 188.464C1120.95 190.259 1120.84 192.122 1120.82 192.762C1120.78 193.878 1120.38 194.499 1119.87 195.285C1119.79 195.401 1119.71 195.527 1119.63 195.653C1119.55 195.77 1119.46 195.896 1119.38 196.022C1118.74 196.924 1117.87 198.147 1117.95 203.007C1118.04 208.528 1118.15 220.888 1118.15 221.014C1118.13 221.596 1118.15 222.207 1118.17 222.799C1118.27 224.313 1118.61 225.39 1119.2 226.078C1119.62 226.563 1120.28 226.806 1121.22 226.816C1122.05 226.825 1123.27 226.825 1124.5 226.825C1125.73 226.825 1126.95 226.825 1127.78 226.806C1128.65 226.787 1129.28 226.583 1129.69 226.185C1130.86 225.04 1130.85 223.187 1130.84 221.548C1130.84 221.363 1130.84 221.179 1130.84 220.995C1130.82 220.005 1130.92 206.219 1130.96 202.988C1131.02 198.127 1130.15 196.905 1129.51 196.003C1129.42 195.877 1129.33 195.76 1129.25 195.634C1129.17 195.508 1129.09 195.382 1129.01 195.265C1128.5 194.48 1128.09 193.868 1128.05 192.753C1128.03 192.103 1127.91 190.25 1127.79 188.455C1127.7 186.902 1127.59 185.37 1127.55 184.593C1127.51 183.885 1127.39 183.031 1127.26 182.197C1127.08 181.023 1126.92 180.014 1127.04 179.48C1126.47 179.151 1125.84 179.025 1125.18 179.131C1125.03 179.151 1124.9 179.189 1124.77 179.228C1124.44 179.325 1124.07 179.432 1123.54 179.316C1123.37 179.277 1123.2 179.228 1123.04 179.18C1122.7 179.083 1122.39 178.995 1122.09 179.034C1121.93 179.054 1121.81 179.083 1121.68 179.122L1121.71 179.141Z"
                    fill="#E1E1E1" />
                <path
                    d="M1123.2 179.025C1123.37 179.073 1123.53 179.112 1123.7 179.141C1124.03 179.209 1124.25 179.141 1124.55 179.073C1124.71 179.034 1124.9 178.986 1125.12 178.947C1126.02 178.811 1126.92 178.957 1127.7 179.345C1127.71 179.209 1127.7 179.151 1127.7 179.151C1127.7 179.151 1128.05 177.627 1126.39 177.627C1126.39 177.627 1124.42 177.627 1124.41 177.627H1122.45C1121.13 177.627 1121.07 178.588 1121.11 178.986C1121.31 178.918 1121.53 178.869 1121.78 178.84C1122.3 178.782 1122.77 178.898 1123.21 179.015L1123.2 179.025Z"
                    fill="#E1E1E1" />
                <path
                    d="M1128.44 196.148C1128.36 196.022 1128.29 195.906 1128.21 195.789C1127.66 194.955 1127.14 194.169 1127.09 192.791C1127.08 192.161 1126.95 190.327 1126.84 188.561V188.523C1126.75 187.009 1126.64 185.447 1126.6 184.652C1126.59 184.39 1126.56 184.099 1126.52 183.788H1122.25C1122.21 184.099 1122.18 184.399 1122.17 184.661C1122.14 185.457 1122.04 187.019 1121.95 188.532V188.571C1121.85 190.347 1121.73 192.18 1121.71 192.811C1121.67 194.188 1121.15 194.974 1120.61 195.809C1120.53 195.925 1120.45 196.041 1120.37 196.168C1120.29 196.303 1120.2 196.43 1120.1 196.575C1119.54 197.371 1118.78 198.457 1118.84 203.007C1118.87 205.016 1118.91 207.024 1118.93 209.042C1118.97 212.583 1119.03 216.124 1119.03 219.665C1119.03 221.101 1118.97 222.489 1119.79 223.75C1120.54 224.885 1122.33 224.817 1123.49 224.827C1124.78 224.827 1126.1 224.846 1127.39 224.691C1128.03 224.613 1128.73 224.419 1129.22 223.973C1130.08 223.187 1129.87 221.092 1129.88 220.054C1129.9 217.415 1129.91 214.766 1129.92 212.127C1129.94 209.081 1129.96 206.044 1130 202.998C1130.06 198.448 1129.28 197.361 1128.72 196.565C1128.62 196.43 1128.53 196.294 1128.44 196.168V196.148Z"
                    fill="#ECECEC" />
                <path
                    d="M1117.74 203.746H1122.61C1125.68 203.746 1128.18 206.249 1128.18 209.325V210.722C1128.18 213.797 1125.68 216.3 1122.61 216.3H1117.74V203.756V203.746Z"
                    fill="#E1E1E1" />
                <path d="M1413.45 152.938L1417.38 178.812H1440.22L1445.52 153.316L1413.45 152.938Z" fill="#ECECEC" />
                <path
                    d="M1442.32 169.52C1442.32 169.597 1436.47 169.655 1429.25 169.655C1422.04 169.655 1416.19 169.597 1416.19 169.52C1416.19 169.442 1422.04 169.384 1429.25 169.384C1436.47 169.384 1442.32 169.442 1442.32 169.52Z"
                    fill="#FAFAFA" />
                <path
                    d="M1442.41 168.249C1442.41 168.326 1436.52 168.384 1429.25 168.384C1421.99 168.384 1416.1 168.326 1416.1 168.249C1416.1 168.171 1421.99 168.113 1429.25 168.113C1436.52 168.113 1442.41 168.171 1442.41 168.249Z"
                    fill="#FAFAFA" />
                <path
                    d="M1442.37 166.813C1442.37 166.89 1436.48 166.948 1429.22 166.948C1421.95 166.948 1416.06 166.89 1416.06 166.813C1416.06 166.735 1421.95 166.677 1429.22 166.677C1436.48 166.677 1442.37 166.735 1442.37 166.813Z"
                    fill="#FAFAFA" />
                <path
                    d="M1420.01 177.339C1419.93 177.349 1419.62 175.894 1419.31 174.079C1419 172.265 1418.79 170.79 1418.87 170.771C1418.95 170.761 1419.26 172.217 1419.57 174.031C1419.88 175.845 1420.08 177.32 1420.01 177.329V177.339Z"
                    fill="#FAFAFA" />
                <path
                    d="M1421.55 177.067C1421.48 177.067 1421.39 175.641 1421.27 173.885C1421.16 172.129 1421.05 170.703 1421.13 170.693C1421.2 170.693 1421.43 172.1 1421.55 173.866C1421.66 175.632 1421.63 177.058 1421.56 177.058L1421.55 177.067Z"
                    fill="#FAFAFA" />
                <path
                    d="M1424.38 177.058C1424.32 177.068 1424 175.622 1423.79 173.798C1423.58 171.984 1423.55 170.49 1423.62 170.49C1423.7 170.49 1423.84 171.955 1424.05 173.769C1424.27 175.583 1424.46 177.048 1424.38 177.058Z"
                    fill="#FAFAFA" />
                <path
                    d="M1426.38 177.194C1426.31 177.194 1426.12 175.719 1426.06 173.885C1426 172.052 1426.09 170.558 1426.16 170.558C1426.23 170.558 1426.26 172.042 1426.32 173.876C1426.38 175.709 1426.45 177.194 1426.37 177.194H1426.38Z"
                    fill="#FAFAFA" />
                <path
                    d="M1429.89 177.067C1429.82 177.067 1429.71 175.661 1429.65 173.924C1429.59 172.187 1429.6 170.771 1429.68 170.771C1429.76 170.771 1429.86 172.178 1429.92 173.914C1429.98 175.651 1429.97 177.067 1429.89 177.067Z"
                    fill="#FAFAFA" />
                <path
                    d="M1432.46 177.203C1432.38 177.203 1432.33 175.748 1432.35 173.953C1432.37 172.158 1432.44 170.703 1432.52 170.703C1432.6 170.703 1432.64 172.158 1432.62 173.953C1432.61 175.748 1432.54 177.203 1432.46 177.203Z"
                    fill="#FAFAFA" />
                <path
                    d="M1434.87 176.854C1434.79 176.854 1434.88 175.321 1435.07 173.458C1435.25 171.586 1435.45 170.082 1435.53 170.082C1435.61 170.082 1435.52 171.615 1435.34 173.478C1435.15 175.35 1434.95 176.854 1434.87 176.854Z"
                    fill="#FAFAFA" />
                <path
                    d="M1437.98 176.514C1437.91 176.514 1438.02 175.205 1438.37 173.623C1438.71 172.052 1439.15 170.81 1439.22 170.839C1439.3 170.858 1438.97 172.12 1438.63 173.682C1438.29 175.244 1438.06 176.524 1437.98 176.514Z"
                    fill="#FAFAFA" />
                <path
                    d="M1435.78 101.888C1435.78 101.888 1435.78 101.936 1435.75 102.014L1435.65 102.382C1435.54 102.722 1435.4 103.188 1435.21 103.779C1435.02 104.381 1434.78 105.128 1434.54 105.992C1434.3 106.855 1433.99 107.835 1433.72 108.941C1433.43 110.037 1433.12 111.24 1432.83 112.54C1432.51 113.84 1432.25 115.237 1431.95 116.702C1431.4 119.652 1430.9 122.912 1430.55 126.356C1430.21 129.8 1430.07 133.098 1430.02 136.096C1430.02 137.6 1430.01 139.026 1430.06 140.355C1430.08 141.694 1430.16 142.926 1430.22 144.062C1430.27 145.197 1430.38 146.215 1430.45 147.118C1430.51 148.02 1430.59 148.786 1430.67 149.417C1430.74 150.028 1430.78 150.513 1430.82 150.872C1430.83 151.027 1430.84 151.154 1430.85 151.251C1430.85 151.338 1430.85 151.377 1430.85 151.377C1430.85 151.377 1430.84 151.338 1430.82 151.251C1430.8 151.154 1430.78 151.027 1430.77 150.872C1430.72 150.523 1430.65 150.038 1430.56 149.427C1430.47 148.796 1430.38 148.03 1430.3 147.127C1430.21 146.225 1430.1 145.206 1430.04 144.071C1429.96 142.936 1429.87 141.694 1429.85 140.355C1429.78 139.017 1429.79 137.59 1429.78 136.087C1429.81 133.079 1429.95 129.771 1430.29 126.317C1430.64 122.863 1431.15 119.593 1431.71 116.644C1432.01 115.169 1432.3 113.772 1432.62 112.472C1432.93 111.172 1433.24 109.969 1433.55 108.873C1433.83 107.777 1434.15 106.797 1434.41 105.933C1434.66 105.07 1434.91 104.332 1435.12 103.731C1435.33 103.149 1435.49 102.683 1435.61 102.353L1435.74 101.994C1435.77 101.917 1435.79 101.878 1435.8 101.878L1435.78 101.888Z"
                    fill="#ECECEC" />
                <path
                    d="M1431.66 117.915C1432.28 116.062 1433.55 114.452 1435.21 113.423C1435.77 113.074 1436.49 112.793 1437.09 113.074C1437.88 113.462 1437.95 114.578 1437.71 115.431C1437.31 116.867 1436.37 118.148 1435.12 118.963C1433.87 119.778 1432.72 120.156 1431.25 119.943"
                    fill="#ECECEC" />
                <path
                    d="M1430.27 128.733C1430.86 126.501 1432.63 123.329 1434.48 121.941C1434.78 121.718 1435.09 121.515 1435.44 121.427C1435.8 121.34 1436.21 121.398 1436.47 121.65C1436.85 122.009 1436.81 122.621 1436.7 123.135C1436 126.395 1433.28 129.121 1430.04 129.848"
                    fill="#ECECEC" />
                <path
                    d="M1429.89 138.25C1430.8 136.125 1432.29 134.262 1434.15 132.894C1434.58 132.574 1435.09 132.264 1435.63 132.361C1436.43 132.506 1436.8 133.496 1436.73 134.311C1436.59 135.999 1435.3 137.348 1433.97 138.395C1432.55 139.521 1430.04 140.423 1430.04 140.423"
                    fill="#ECECEC" />
                <path
                    d="M1430.11 145.099C1431.04 143.508 1432.2 142.014 1433.73 140.976C1434.06 140.753 1434.42 140.54 1434.81 140.491C1435.21 140.433 1435.66 140.569 1435.88 140.899C1436.24 141.432 1435.9 142.15 1435.51 142.664C1434.16 144.44 1432.47 145.788 1430.35 146.458"
                    fill="#ECECEC" />
                <path
                    d="M1429.92 142.315C1428.36 140.404 1426.63 138.629 1424.75 137.037C1424.46 136.785 1424.08 136.523 1423.72 136.649C1423.44 136.746 1423.27 137.047 1423.25 137.348C1423.23 137.649 1423.34 137.94 1423.44 138.211C1424.58 140.947 1427.24 143.091 1430.11 143.829"
                    fill="#ECECEC" />
                <path
                    d="M1430.09 133.409C1428.73 131.75 1427.38 130.101 1426.02 128.442C1425.63 127.966 1425.24 127.491 1424.7 127.19C1424.17 126.889 1423.46 126.821 1422.97 127.171C1422.47 127.52 1422.3 128.209 1422.42 128.81C1422.52 129.412 1422.86 129.936 1423.21 130.44C1424.03 131.634 1424.98 132.769 1426.17 133.593C1427.37 134.418 1428.45 134.952 1429.88 134.738"
                    fill="#ECECEC" />
                <path
                    d="M1430.66 123.377C1429.87 121.01 1428.44 118.866 1426.57 117.226C1426.26 116.955 1425.91 116.683 1425.51 116.605C1424.69 116.45 1423.91 117.129 1423.64 117.915C1423.34 118.798 1423.54 119.797 1424.01 120.612C1424.47 121.417 1425.18 122.067 1425.91 122.64C1427.28 123.688 1428.81 124.512 1430.44 125.085"
                    fill="#ECECEC" />
                <path
                    d="M1432.28 114.432C1431.88 111.55 1430.39 109.164 1428.65 106.835C1428.29 106.34 1427.78 105.826 1427.17 105.914C1426.78 105.972 1426.47 106.282 1426.32 106.641C1426.16 107 1426.15 107.398 1426.16 107.796C1426.24 111.269 1428.64 114.577 1431.92 115.732"
                    fill="#ECECEC" />
                <path
                    d="M1433.42 109.872C1433.27 108.397 1433.14 106.903 1433.27 105.419C1433.41 103.935 1433.85 102.45 1434.75 101.276C1435.13 100.772 1435.63 100.316 1436.22 100.102C1436.82 99.8793 1437.54 99.9375 1438.03 100.345C1438.48 100.723 1438.67 101.354 1438.65 101.946C1438.63 102.538 1438.42 103.1 1438.19 103.653C1437.11 106.263 1435.31 109.154 1433.42 109.882"
                    fill="#ECECEC" />
                <path
                    d="M1415.71 113.297C1415.71 113.297 1415.73 113.423 1415.73 113.666V114.713C1415.74 115.169 1415.74 115.722 1415.77 116.363C1415.79 117.003 1415.8 117.74 1415.85 118.546C1415.92 120.166 1416.07 122.087 1416.32 124.211C1416.59 126.336 1416.95 128.665 1417.45 131.08C1417.96 133.496 1418.56 135.776 1419.17 137.823C1419.8 139.87 1420.43 141.694 1421.01 143.208C1421.28 143.974 1421.57 144.644 1421.82 145.235C1422.05 145.837 1422.27 146.341 1422.46 146.759C1422.62 147.156 1422.76 147.476 1422.86 147.719C1422.95 147.942 1423 148.059 1422.99 148.059C1422.99 148.059 1422.92 147.952 1422.81 147.738L1422.36 146.797C1422.17 146.39 1421.92 145.885 1421.68 145.294C1421.43 144.702 1421.13 144.032 1420.84 143.276C1420.23 141.772 1419.58 139.948 1418.94 137.901C1418.31 135.844 1417.7 133.564 1417.19 131.139C1416.68 128.713 1416.32 126.375 1416.08 124.241C1415.85 122.106 1415.71 120.175 1415.67 118.555C1415.63 117.74 1415.64 117.013 1415.63 116.363C1415.62 115.722 1415.63 115.16 1415.65 114.713C1415.67 114.277 1415.68 113.937 1415.69 113.666C1415.7 113.423 1415.71 113.307 1415.71 113.307V113.297Z"
                    fill="#E1E1E1" />
                <path
                    d="M1416.34 125.094C1416.36 123.707 1416.89 122.329 1417.8 121.272C1418.11 120.913 1418.53 120.564 1419 120.632C1419.63 120.719 1419.91 121.476 1419.93 122.106C1419.97 123.173 1419.6 124.241 1418.93 125.065C1418.25 125.89 1417.55 126.394 1416.5 126.569"
                    fill="#E1E1E1" />
                <path
                    d="M1417.73 132.759C1417.65 131.11 1418.17 128.568 1419.14 127.229C1419.3 127.016 1419.46 126.812 1419.69 126.676C1419.91 126.54 1420.2 126.492 1420.43 126.608C1420.77 126.773 1420.87 127.2 1420.91 127.569C1421.13 129.936 1419.87 132.381 1417.82 133.574"
                    fill="#E1E1E1" />
                <path
                    d="M1419.51 139.327C1419.68 137.687 1420.29 136.096 1421.25 134.767C1421.49 134.457 1421.77 134.136 1422.16 134.088C1422.74 134.01 1423.2 134.602 1423.33 135.175C1423.59 136.348 1423.01 137.551 1422.33 138.551C1421.6 139.628 1420.08 140.782 1420.08 140.782"
                    fill="#E1E1E1" />
                <path
                    d="M1421.13 143.936C1421.42 142.655 1421.89 141.384 1422.71 140.346C1422.88 140.123 1423.09 139.9 1423.35 139.783C1423.61 139.667 1423.94 139.657 1424.16 139.832C1424.52 140.113 1424.44 140.685 1424.29 141.112C1423.75 142.616 1422.89 143.897 1421.58 144.809"
                    fill="#E1E1E1" />
                <path
                    d="M1420.41 142.082C1418.94 141.112 1417.38 140.288 1415.75 139.609C1415.5 139.502 1415.19 139.405 1414.97 139.56C1414.79 139.686 1414.75 139.929 1414.79 140.132C1414.84 140.336 1414.98 140.52 1415.11 140.676C1416.47 142.296 1418.75 143.179 1420.86 143.062"
                    fill="#E1E1E1" />
                <path
                    d="M1418.61 135.98C1417.33 135.145 1416.05 134.311 1414.78 133.477C1414.41 133.234 1414.04 132.992 1413.61 132.904C1413.19 132.817 1412.69 132.914 1412.43 133.263C1412.17 133.612 1412.2 134.117 1412.4 134.495C1412.61 134.874 1412.94 135.165 1413.29 135.436C1414.12 136.067 1415 136.639 1415.99 136.94C1416.97 137.241 1417.83 137.377 1418.76 136.921"
                    fill="#E1E1E1" />
                <path
                    d="M1416.84 129.033C1415.79 127.598 1414.36 126.443 1412.73 125.725C1412.46 125.609 1412.17 125.492 1411.87 125.531C1411.28 125.599 1410.89 126.23 1410.88 126.821C1410.87 127.491 1411.22 128.121 1411.71 128.577C1412.21 129.033 1412.82 129.315 1413.45 129.548C1414.6 129.965 1415.82 130.198 1417.05 130.236"
                    fill="#E1E1E1" />
                <path
                    d="M1416.02 122.591C1415.14 120.718 1413.6 119.408 1411.93 118.196C1411.57 117.943 1411.11 117.691 1410.73 117.885C1410.47 118.011 1410.33 118.293 1410.31 118.564C1410.28 118.846 1410.36 119.117 1410.45 119.379C1411.26 121.727 1413.59 123.454 1416.07 123.541"
                    fill="#E1E1E1" />
                <path
                    d="M1415.82 119.244C1415.4 118.264 1414.99 117.284 1414.77 116.246C1414.54 115.208 1414.51 114.102 1414.88 113.103C1415.04 112.676 1415.27 112.259 1415.64 111.987C1416 111.706 1416.5 111.589 1416.93 111.764C1417.31 111.929 1417.57 112.307 1417.69 112.715C1417.81 113.122 1417.78 113.549 1417.75 113.976C1417.57 115.984 1416.96 118.342 1415.84 119.244"
                    fill="#E1E1E1" />
                <path
                    d="M1444.58 113.043C1444.58 113.043 1444.6 113.17 1444.61 113.402C1444.62 113.664 1444.62 114.014 1444.64 114.45C1444.66 114.906 1444.67 115.459 1444.66 116.099C1444.66 116.74 1444.66 117.477 1444.62 118.292C1444.58 119.912 1444.44 121.843 1444.21 123.977C1443.96 126.112 1443.6 128.45 1443.1 130.875C1442.59 133.301 1441.98 135.581 1441.35 137.638C1440.71 139.685 1440.06 141.509 1439.45 143.012C1439.16 143.769 1438.86 144.439 1438.61 145.03C1438.36 145.622 1438.13 146.127 1437.93 146.534C1437.75 146.922 1437.59 147.233 1437.48 147.475C1437.37 147.689 1437.31 147.795 1437.3 147.795C1437.3 147.795 1437.34 147.669 1437.43 147.456C1437.54 147.213 1437.67 146.893 1437.84 146.495C1438.02 146.078 1438.24 145.574 1438.47 144.972C1438.72 144.371 1439.01 143.701 1439.28 142.944C1439.86 141.431 1440.49 139.607 1441.12 137.56C1441.73 135.513 1442.33 133.233 1442.84 130.817C1443.35 128.401 1443.7 126.073 1443.97 123.948C1444.21 121.824 1444.36 119.903 1444.44 118.282C1444.5 117.477 1444.5 116.74 1444.52 116.099C1444.54 115.459 1444.55 114.906 1444.55 114.45C1444.55 114.014 1444.55 113.674 1444.56 113.402C1444.56 113.16 1444.57 113.034 1444.58 113.034V113.043Z"
                    fill="#ECECEC" />
                <path
                    d="M1442.56 132.507C1442.64 130.857 1442.12 128.315 1441.15 126.977C1440.99 126.763 1440.83 126.559 1440.61 126.424C1440.38 126.288 1440.09 126.239 1439.86 126.356C1439.52 126.521 1439.42 126.947 1439.39 127.316C1439.16 129.683 1440.42 132.128 1442.47 133.322"
                    fill="#ECECEC" />
                <path
                    d="M1440.78 139.075C1440.62 137.435 1440.01 135.844 1439.04 134.515C1438.8 134.205 1438.52 133.885 1438.14 133.836C1437.55 133.758 1437.09 134.35 1436.96 134.923C1436.7 136.097 1437.28 137.3 1437.96 138.299C1438.69 139.376 1440.21 140.53 1440.21 140.53"
                    fill="#ECECEC" />
                <path
                    d="M1439.16 143.683C1438.87 142.402 1438.4 141.131 1437.58 140.093C1437.41 139.87 1437.21 139.647 1436.95 139.531C1436.69 139.405 1436.36 139.405 1436.14 139.579C1435.78 139.861 1435.86 140.433 1436.01 140.86C1436.55 142.364 1437.41 143.644 1438.72 144.556"
                    fill="#ECECEC" />
                <path
                    d="M1439.88 141.83C1441.35 140.86 1442.91 140.035 1444.54 139.356C1444.79 139.249 1445.1 139.152 1445.32 139.308C1445.5 139.434 1445.55 139.676 1445.5 139.88C1445.45 140.084 1445.31 140.268 1445.18 140.423C1443.82 142.043 1441.55 142.926 1439.43 142.81"
                    fill="#ECECEC" />
                <path
                    d="M1410.83 147.815V152.656C1410.83 153.704 1411.69 154.558 1412.73 154.558H1445.8C1446.84 154.558 1447.7 153.704 1447.7 152.656V147.815H1410.82H1410.83Z"
                    fill="#ECECEC" />
                <path d="M1413.7 154.567L1413.97 156.11L1444.48 158.283L1445.25 154.567H1413.7Z" fill="#E1E1E1" />
                <path d="M1259.43 8.34277H1195.23V101.558H1259.43V8.34277Z" fill="#E1E1E1" />
                <path d="M1256.21 8.34277H1192.01V101.558H1256.21V8.34277Z" fill="#F5F5F5" />
                <path d="M1248.23 18.4424H1199.99V91.4681H1248.23V18.4424Z" fill="white" />
                <path
                    d="M1248.23 91.4682C1248.23 91.4682 1248.23 91.342 1248.23 91.1092V90.0711C1248.22 89.1494 1248.21 87.8106 1248.2 86.0643C1248.19 82.5619 1248.17 77.4684 1248.16 71.0264C1248.15 58.1521 1248.12 39.9126 1248.09 18.4425L1248.25 18.6074C1233.51 18.6074 1217.18 18.6074 1200.01 18.6171L1200.18 18.4425C1200.17 45.986 1200.16 71.3854 1200.15 91.4682L1200.01 91.3324C1214.7 91.3615 1226.75 91.3906 1235.13 91.41C1239.32 91.4294 1242.6 91.4391 1244.83 91.4488C1245.95 91.4488 1246.8 91.4585 1247.38 91.4682C1247.96 91.4682 1248.26 91.4876 1248.26 91.4876C1248.26 91.4876 1247.98 91.4973 1247.41 91.507C1246.83 91.507 1245.99 91.507 1244.89 91.5264C1242.66 91.5264 1239.4 91.5458 1235.22 91.5652C1226.82 91.5846 1214.74 91.604 1200.01 91.6428H1199.87V91.507C1199.86 71.4339 1199.85 46.0345 1199.84 18.4813V18.3066H1200.02C1217.19 18.3066 1233.52 18.3163 1248.26 18.3163H1248.43V18.4813C1248.4 39.9999 1248.37 58.2685 1248.35 71.1719C1248.33 77.5946 1248.32 82.688 1248.31 86.1807C1248.31 87.9076 1248.29 89.2465 1248.29 90.1584C1248.29 90.6047 1248.29 90.9346 1248.29 91.1771C1248.29 91.4003 1248.29 91.5167 1248.29 91.5167L1248.23 91.4682Z"
                    fill="#E1E1E1" />
                <path
                    d="M1256.4 8.34277C1256.4 8.34277 1256 9.0122 1255.25 10.0115C1254.51 11.0108 1253.45 12.369 1252.24 13.834C1251.03 15.299 1249.91 16.6087 1249.07 17.5304C1248.23 18.4521 1247.69 19.0051 1247.65 18.976C1247.61 18.9469 1248.09 18.3357 1248.88 17.3752C1249.74 16.3274 1250.8 15.0467 1251.97 13.6206C1253.14 12.1944 1254.2 10.9138 1255.06 9.86596C1255.85 8.90548 1256.36 8.32337 1256.4 8.35248V8.34277Z"
                    fill="#E1E1E1" />
                <path d="M1248.48 91.2354C1250.88 95.0482 1253.71 98.599 1256.9 101.781L1248.48 91.2354Z"
                    fill="white" />
                <path
                    d="M1256.9 101.771C1256.9 101.771 1256.3 101.306 1255.44 100.433C1254.58 99.5595 1253.43 98.3079 1252.26 96.843C1251.09 95.378 1250.12 93.9906 1249.46 92.9525C1248.8 91.9144 1248.45 91.245 1248.48 91.2256C1248.52 91.1965 1248.96 91.8174 1249.67 92.8167C1250.37 93.816 1251.37 95.1742 1252.53 96.6295C1253.7 98.0848 1254.8 99.3557 1255.61 100.268C1256.43 101.18 1256.94 101.742 1256.9 101.771Z"
                    fill="#E1E1E1" />
                <path d="M1192 101.49C1194.8 98.0267 1197.61 94.5632 1200.41 91.0996L1192 101.49Z" fill="white" />
                <path
                    d="M1200.42 91.0996C1200.49 91.1578 1198.67 93.5348 1196.35 96.4065C1194.02 99.2783 1192.09 101.558 1192.01 101.49C1191.93 101.432 1193.75 99.0551 1196.08 96.1834C1198.4 93.3116 1200.34 91.0317 1200.42 91.0996Z"
                    fill="#E1E1E1" />
                <path
                    d="M1192.01 8.34293C1192.09 8.28472 1193.92 10.4676 1196.09 13.2327C1198.27 15.988 1199.97 18.2776 1199.89 18.3358C1199.82 18.394 1198 16.2111 1195.82 13.4461C1193.64 10.6908 1191.93 8.40115 1192.01 8.34293Z"
                    fill="#E1E1E1" />
                <path d="M1233.2 33.2671H1217.05V79.215H1233.2V33.2671Z" fill="#E1E1E1" />
                <path d="M1120.96 15.4443V43.1569H1081.23L1079.8 15.6374L1120.96 15.4443Z" fill="#E1E1E1" />
                <path d="M1079.8 15.6371V43.0957H1119.53V15.6371L1079.8 15.6371Z" fill="white" />
                <path
                    d="M1119.72 43.2837H1079.62V15.4492H1119.72V43.2837ZM1079.99 42.9078H1119.35V15.8252H1079.99V42.9027V42.9078Z"
                    fill="#E1E1E1" />
                <path d="M1115.23 19.0513H1084.11V39.6871H1115.23V19.0513Z" fill="white" />
                <path
                    d="M1115.23 19.0511C1115.23 19.0511 1115.18 19.0511 1115.08 19.0562H1114.64C1114.24 19.0664 1113.67 19.0664 1112.93 19.0714C1111.43 19.0765 1109.26 19.0867 1106.51 19.0968C1101.03 19.107 1093.26 19.1222 1084.11 19.1426L1084.2 19.0511C1084.2 25.3557 1084.21 32.341 1084.21 39.6819L1084.11 39.5854C1095.85 39.5904 1106.68 39.6006 1115.24 39.6057L1115.16 39.6819C1115.18 33.4027 1115.19 28.2514 1115.2 24.6698C1115.21 22.8765 1115.22 21.4795 1115.22 20.5193C1115.22 20.0468 1115.23 19.6811 1115.23 19.4271C1115.23 19.1781 1115.24 19.046 1115.24 19.046C1115.24 19.046 1115.25 19.168 1115.25 19.4067C1115.25 19.6557 1115.25 20.0164 1115.26 20.4837C1115.26 21.4388 1115.27 22.8359 1115.28 24.619C1115.29 28.2158 1115.31 33.3824 1115.32 39.6819V39.7581H1115.25C1106.69 39.7632 1095.86 39.7682 1084.12 39.7784H1084.03V39.6819C1084.03 32.3359 1084.03 25.3506 1084.04 19.046V18.9546H1084.13C1093.3 18.9749 1101.09 18.9902 1106.59 19.0003C1109.33 19.0105 1111.5 19.0206 1112.99 19.0257C1113.72 19.0257 1114.29 19.0359 1114.68 19.0359H1115.11C1115.2 19.041 1115.25 19.046 1115.25 19.046L1115.23 19.0511Z"
                    fill="#E1E1E1" />
                <path
                    d="M1079.8 15.5612C1079.8 15.5612 1080.08 15.7086 1080.49 16.0032C1080.89 16.2979 1081.45 16.7144 1082.04 17.192C1082.64 17.6695 1083.17 18.1267 1083.54 18.462C1083.91 18.8024 1084.12 19.0259 1084.1 19.0463C1084.07 19.0869 1083.11 18.2995 1081.92 17.3444C1080.73 16.3893 1079.77 15.6019 1079.8 15.5562L1079.8 15.5612Z"
                    fill="#E1E1E1" />
                <path
                    d="M1119.53 15.6374C1119.57 15.678 1118.63 16.4807 1117.44 17.4205C1116.26 18.3604 1115.26 19.0919 1115.23 19.0513C1115.2 19.0106 1116.14 18.213 1117.32 17.2681C1118.51 16.3283 1119.5 15.5967 1119.53 15.6374Z"
                    fill="#E1E1E1" />
                <path d="M1119.5 43.1012C1118.03 41.9023 1116.55 40.7033 1115.08 39.5044L1119.5 43.1012Z"
                    fill="white" />
                <path
                    d="M1115.07 39.5045C1115.11 39.4638 1116.13 40.2309 1117.35 41.2267C1118.57 42.2224 1119.53 43.0606 1119.5 43.1013C1119.47 43.1419 1118.45 42.3748 1117.23 41.3791C1116 40.3884 1115.04 39.5451 1115.07 39.5045Z"
                    fill="#E1E1E1" />
                <path
                    d="M1079.8 43.0961C1079.77 43.0555 1080.7 42.2629 1081.87 41.3333C1083.05 40.4036 1084.03 39.6822 1084.06 39.7228C1084.1 39.7635 1083.17 40.556 1081.99 41.4857C1080.82 42.4153 1079.84 43.1367 1079.8 43.0961Z"
                    fill="#E1E1E1" />
                <path d="M1090.43 25.483V32.3921H1110.01V25.483H1090.43Z" fill="#E1E1E1" />
                <path d="M1432.06 20.2861H1391.3V62.8481H1432.06V20.2861Z" fill="#E1E1E1" />
                <path d="M1429.3 20.2861H1388.54V62.8481H1429.3V20.2861Z" fill="#FAFAFA" />
                <path
                    d="M1429.31 62.8674H1388.53V20.2764H1429.31V62.8674ZM1388.55 62.8383H1429.28V20.2958H1388.55V62.8383Z"
                    fill="#E1E1E1" />
                <path d="M1423.82 26.0098H1394.02V57.1333H1423.82V26.0098Z" fill="white" />
                <path
                    d="M1394.02 57.3369C1394.02 57.3369 1393.76 57.6862 1393.28 58.1907C1392.81 58.6951 1392.14 59.3743 1391.39 60.1116C1390.64 60.849 1389.94 61.5087 1389.44 61.9744C1388.94 62.4401 1388.61 62.7214 1388.58 62.6923C1388.55 62.6632 1388.83 62.343 1389.31 61.8385C1389.79 61.334 1390.46 60.6549 1391.21 59.9079C1391.97 59.1705 1392.65 58.5011 1393.16 58.0354C1393.66 57.5697 1393.99 57.2884 1394.02 57.3175V57.3369Z"
                    fill="#E1E1E1" />
                <path
                    d="M1423.82 57.2598C1423.82 57.2598 1424.17 57.5217 1424.67 57.9971C1425.18 58.4725 1425.86 59.1419 1426.59 59.8987C1427.33 60.6457 1427.99 61.3442 1428.45 61.8487C1428.92 62.3532 1429.2 62.6831 1429.17 62.7122C1429.14 62.7413 1428.82 62.4599 1428.32 61.9749C1427.81 61.4995 1427.13 60.83 1426.39 60.0733C1425.65 59.3166 1424.98 58.6277 1424.52 58.1232C1424.05 57.6187 1423.77 57.2889 1423.8 57.2598H1423.82Z"
                    fill="#E1E1E1" />
                <path
                    d="M1423.74 26.0879C1423.74 26.0879 1424.01 25.7387 1424.48 25.2342C1424.95 24.7297 1425.62 24.0506 1426.38 23.3132C1427.12 22.5759 1427.82 21.9162 1428.32 21.4505C1428.83 20.9848 1429.16 20.7034 1429.19 20.7325C1429.22 20.7616 1428.93 21.0818 1428.45 21.5863C1427.98 22.0908 1427.31 22.7699 1426.55 23.517C1425.8 24.2543 1425.11 24.9237 1424.61 25.3894C1424.1 25.8551 1423.77 26.1365 1423.74 26.1073V26.0879Z"
                    fill="#E1E1E1" />
                <path
                    d="M1393.93 26.1654C1393.93 26.1654 1393.58 25.9035 1393.08 25.4281C1392.58 24.9527 1391.9 24.2833 1391.16 23.5265C1390.43 22.7795 1389.77 22.081 1389.3 21.5765C1388.84 21.072 1388.56 20.7421 1388.59 20.713C1388.62 20.6839 1388.93 20.9652 1389.44 21.4503C1389.94 21.9257 1390.62 22.5952 1391.37 23.3519C1392.1 24.1086 1392.77 24.7975 1393.24 25.302C1393.7 25.8065 1393.98 26.1363 1393.95 26.1654H1393.93Z"
                    fill="#E1E1E1" />
                <path
                    d="M1423.74 57.1223C1423.74 57.1223 1423.74 57.0738 1423.74 56.9671C1423.74 56.8604 1423.74 56.7149 1423.74 56.5305C1423.74 56.1425 1423.74 55.5797 1423.73 54.8521C1423.73 53.3774 1423.71 51.2333 1423.7 48.5071C1423.7 43.0547 1423.67 35.2932 1423.65 25.9989L1423.76 26.1153C1415.09 26.1153 1404.9 26.125 1394.05 26.1347L1394.18 25.9989C1394.18 37.4179 1394.17 48.1093 1394.16 57.1223L1394.05 57.0059C1402.96 57.0253 1410.37 57.0544 1415.57 57.0641C1418.16 57.0738 1420.21 57.0835 1421.61 57.0932C1422.31 57.0932 1422.84 57.1029 1423.21 57.1029C1423.39 57.1029 1423.52 57.1029 1423.63 57.1029C1423.72 57.1029 1423.77 57.1029 1423.77 57.1029C1423.77 57.1029 1423.73 57.1029 1423.64 57.1029C1423.54 57.1029 1423.4 57.1029 1423.24 57.1029C1422.87 57.1029 1422.35 57.1029 1421.66 57.1126C1420.27 57.1126 1418.23 57.132 1415.65 57.1417C1410.43 57.1514 1402.99 57.1805 1394.06 57.2H1393.94V57.0835C1393.94 48.0705 1393.93 37.3888 1393.92 25.96V25.8242H1394.06C1404.92 25.8242 1415.1 25.8339 1423.77 25.8436H1423.89V25.96C1423.86 35.2835 1423.84 43.0741 1423.83 48.5459C1423.82 51.2624 1423.81 53.3968 1423.8 54.8618C1423.8 55.5797 1423.79 56.1327 1423.79 56.5208C1423.79 56.7052 1423.79 56.841 1423.79 56.938C1423.79 57.035 1423.79 57.0738 1423.79 57.0738L1423.74 57.1223Z"
                    fill="#E1E1E1" />
                <path d="M1413.89 36.5835H1403.95V46.5473H1413.89V36.5835Z" fill="#ECECEC" />
                <path
                    d="M1347.77 69.5228L1342.9 60.927C1345.05 57.4246 1346.3 53.3013 1346.3 48.887C1346.3 36.1873 1336.02 25.9033 1323.36 25.9033C1310.69 25.9033 1300.41 36.197 1300.41 48.887C1300.41 61.577 1310.69 71.8706 1323.36 71.8706C1328.64 71.8706 1333.52 70.0758 1337.4 67.0585L1347.78 69.5131L1347.77 69.5228Z"
                    fill="#FAFAFA" />
                <path
                    d="M1347.77 69.5228C1347.31 69.416 1344.01 68.6593 1337.37 67.1361C1337.33 67.1361 1337.31 67.0973 1337.32 67.0585C1337.32 67.0585 1337.32 67.0391 1337.33 67.0294L1337.43 67.107C1336.12 68.1257 1334.55 69.125 1332.71 69.9593C1330.86 70.7743 1328.75 71.4437 1326.42 71.7542C1325.25 71.8997 1324.03 71.9967 1322.78 71.9385C1322.16 71.8997 1321.53 71.89 1320.88 71.8318C1320.24 71.7348 1319.59 71.6378 1318.94 71.5407C1316.34 71.0265 1313.68 70.037 1311.21 68.4944C1308.73 66.9615 1306.45 64.8756 1304.61 62.3143C1302.78 59.7627 1301.38 56.726 1300.73 53.4371C1300.08 50.1482 1300.14 46.6264 1301 43.2114C1301.87 39.8157 1303.49 36.488 1305.92 33.7618L1306.86 32.7334C1307.17 32.3841 1307.54 32.1028 1307.87 31.7826C1308.22 31.4819 1308.54 31.1423 1308.91 30.8707L1310.01 30.046C1310.37 29.7549 1310.76 29.5221 1311.15 29.2893C1311.54 29.0564 1311.93 28.8139 1312.32 28.581C1312.72 28.387 1313.13 28.1832 1313.54 27.9892C1313.94 27.8049 1314.34 27.5817 1314.77 27.4459C1318.1 26.1168 1321.65 25.6123 1325.05 25.8645C1328.45 26.1071 1331.7 27.0869 1334.49 28.6586C1337.29 30.2206 1339.66 32.3065 1341.48 34.635C1343.31 36.9634 1344.6 39.5344 1345.39 42.086C1346.18 44.657 1346.4 47.2085 1346.39 49.5661C1346.32 51.9333 1345.89 54.1065 1345.26 56.0178C1344.63 57.9291 1343.81 59.5784 1342.96 60.9657V60.8978C1346.04 66.4182 1347.55 69.125 1347.77 69.5228C1347.55 69.1347 1346 66.4376 1342.85 60.956C1342.84 60.9366 1342.84 60.9075 1342.85 60.8881C1343.69 59.5008 1344.5 57.8612 1345.11 55.9596C1345.72 54.058 1346.14 51.8945 1346.19 49.5467C1346.19 47.2085 1345.97 44.6764 1345.18 42.1345C1344.38 39.6023 1343.09 37.0604 1341.28 34.7611C1339.47 32.4618 1337.14 30.405 1334.36 28.8624C1331.6 27.3101 1328.37 26.3496 1325.01 26.1071C1321.65 25.8645 1318.14 26.369 1314.84 27.6788C1314.42 27.8146 1314.03 28.0377 1313.62 28.2221L1312.42 28.8042L1311.27 29.5027C1310.88 29.7355 1310.49 29.9684 1310.15 30.2497C1309.79 30.5214 1309.42 30.793 1309.06 31.0647C1308.69 31.3266 1308.38 31.6662 1308.03 31.967C1307.7 32.2774 1307.34 32.5685 1307.04 32.908L1306.11 33.9267C1303.7 36.6238 1302.11 39.9128 1301.24 43.2696C1300.39 46.6458 1300.33 50.1288 1300.97 53.3789C1301.61 56.6387 1302.99 59.6366 1304.8 62.1688C1306.61 64.701 1308.88 66.7771 1311.33 68.3003C1313.78 69.8332 1316.4 70.8131 1318.98 71.3273C1319.63 71.4243 1320.27 71.531 1320.9 71.6281C1321.54 71.6863 1322.16 71.696 1322.78 71.7348C1324.02 71.8027 1325.24 71.7057 1326.39 71.5602C1328.7 71.2594 1330.8 70.5997 1332.64 69.7944C1334.47 68.9795 1336.04 67.9899 1337.35 66.9906C1337.38 66.9712 1337.42 66.9712 1337.45 67.0003C1337.47 67.0197 1337.47 67.0585 1337.45 67.0779L1337.41 66.9809C1344.02 68.5817 1347.32 69.3869 1347.77 69.4937V69.5228Z"
                    fill="#1A2E35" />
                <path
                    d="M1333.09 47.7322C1333.02 46.5292 1332.5 45.3843 1331.75 44.4433C1331.02 43.5216 1330.03 42.7745 1328.9 42.4641C1327.69 42.1342 1326.35 42.3186 1325.28 42.9686C1324.64 43.3567 1324.11 43.9097 1323.73 44.5403C1323.42 43.9388 1322.99 43.4052 1322.46 42.988C1321.47 42.2215 1320.15 41.8917 1318.92 42.0857C1317.76 42.2701 1316.69 42.9104 1315.87 43.7447C1315.02 44.5985 1314.38 45.6851 1314.18 46.8687C1313.93 48.3531 1314.14 50.0121 1314.83 51.3413C1315.58 52.748 1316.84 53.922 1318.16 54.8145C1320.36 56.3183 1323.28 58.2102 1323.28 58.2102C1323.28 58.2102 1325.92 56.4444 1328.29 55.1929C1329.69 54.4459 1331.08 53.4175 1331.97 52.098C1332.81 50.8465 1333.19 49.2263 1333.1 47.7225L1333.09 47.7322Z"
                    fill="#FB5607" />
                <path
                    d="M1333.09 47.7322C1333.02 46.5292 1332.5 45.3843 1331.75 44.4433C1331.02 43.5216 1330.03 42.7745 1328.9 42.4641C1327.69 42.1342 1326.35 42.3186 1325.28 42.9686C1324.64 43.3567 1324.11 43.9097 1323.73 44.5403C1323.42 43.9388 1322.99 43.4052 1322.46 42.988C1321.47 42.2215 1320.15 41.8917 1318.92 42.0857C1317.76 42.2701 1316.69 42.9104 1315.87 43.7447C1315.02 44.5985 1314.38 45.6851 1314.18 46.8687C1313.93 48.3531 1314.14 50.0121 1314.83 51.3413C1315.58 52.748 1316.84 53.922 1318.16 54.8145C1320.36 56.3183 1323.28 58.2102 1323.28 58.2102C1323.28 58.2102 1325.92 56.4444 1328.29 55.1929C1329.69 54.4459 1331.08 53.4175 1331.97 52.098C1332.81 50.8465 1333.19 49.2263 1333.1 47.7225L1333.09 47.7322Z"
                    fill="#FB5607" />
                <path
                    d="M1238.47 183.655L1229.86 186.905L1208.67 213.469L1213.21 219.018L1323.64 218.233L1305.86 186.071L1238.47 183.655Z"
                    fill="#1A2E35" />
                <path
                    d="M1215.6 208.997C1215.64 209.055 1214.12 210.112 1212.21 211.345C1210.29 212.577 1208.71 213.527 1208.67 213.469C1208.63 213.411 1210.16 212.354 1212.06 211.121C1213.98 209.889 1215.56 208.938 1215.6 208.997Z"
                    fill="#FB5607" />
                <path
                    d="M1215.6 208.997C1215.64 209.055 1214.12 210.112 1212.21 211.345C1210.29 212.577 1208.71 213.527 1208.67 213.469C1208.63 213.411 1210.16 212.354 1212.06 211.121C1213.98 209.889 1215.56 208.938 1215.6 208.997Z"
                    fill="#FB5607" />
                <path
                    d="M1218.27 214.779C1218.32 214.827 1217.37 216.001 1215.99 217.233C1214.6 218.475 1213.32 219.281 1213.28 219.222C1213.24 219.154 1214.44 218.262 1215.81 217.03C1217.19 215.807 1218.21 214.721 1218.27 214.769V214.779Z"
                    fill="#FB5607" />
                <path
                    d="M1218.27 214.779C1218.32 214.827 1217.37 216.001 1215.99 217.233C1214.6 218.475 1213.32 219.281 1213.28 219.222C1213.24 219.154 1214.44 218.262 1215.81 217.03C1217.19 215.807 1218.21 214.721 1218.27 214.769V214.779Z"
                    fill="#FB5607" />
                <path d="M1238.7 183.878L1215.83 209.443H1330.06L1308.74 183.878H1238.7Z" fill="#FB5607" />
                <path d="M1238.7 183.878L1215.83 209.443H1330.06L1308.74 183.878H1238.7Z" fill="#FB5607" />
                <path
                    d="M1272.71 200.265L1241.04 203.535C1239.65 202.399 1239.52 201.371 1239.52 200.265C1239.52 194.269 1254.5 189.331 1272.71 189.331C1290.92 189.331 1305.9 194.269 1305.9 200.265H1272.71Z"
                    fill="#FB5607" />
                <path
                    d="M1272.71 200.265L1241.04 203.535C1239.65 202.399 1239.52 201.371 1239.52 200.265C1239.52 194.269 1254.5 189.331 1272.71 189.331C1290.92 189.331 1305.9 194.269 1305.9 200.265H1272.71Z"
                    fill="#FB5607" />
                <path d="M1215.6 209.22L1218.17 216.38L1328.96 214.837L1329.83 209.22H1215.6Z" fill="#FB5607" />
                <path d="M1215.6 209.22L1218.17 216.38L1328.96 214.837L1329.83 209.22H1215.6Z" fill="#FB5607" />
                <path d="M1237.81 182.908L1238.97 186.711L1218.17 216.38L1215.6 209.22L1237.81 182.908Z"
                    fill="#FB5607" />
                <path d="M1237.81 182.908L1238.97 186.711L1218.17 216.38L1215.6 209.22L1237.81 182.908Z"
                    fill="#FB5607" />
                <path d="M1308.52 182.763V186.546L1238.97 186.711L1237.63 182.908L1308.52 182.763Z" fill="#FB5607" />
                <path d="M1308.52 182.763V186.546L1238.97 186.711L1237.63 182.908L1308.52 182.763Z" fill="#FB5607" />
                <path d="M1308.52 186.546L1328.96 214.837L1329.83 209.22L1308.52 182.763V186.546Z" fill="#FB5607" />
                <path d="M1308.52 186.546L1328.96 214.837L1329.83 209.22L1308.52 182.763V186.546Z" fill="#FB5607" />
                <path
                    d="M1329.83 209.22C1329.83 209.22 1329.73 209.22 1329.54 209.229H1328.67C1327.9 209.229 1326.78 209.239 1325.34 209.239C1322.45 209.239 1318.26 209.229 1313.1 209.22C1302.76 209.2 1288.48 209.171 1272.71 209.142C1256.93 209.123 1242.66 209.132 1232.32 209.171C1227.16 209.19 1222.99 209.21 1220.08 209.229C1218.65 209.229 1217.53 209.229 1216.75 209.239C1216.37 209.239 1216.09 209.239 1215.89 209.239C1215.7 209.239 1215.6 209.229 1215.6 209.229C1215.6 209.229 1215.7 209.22 1215.89 209.21L1216.75 209.19C1217.53 209.181 1218.64 209.152 1220.08 209.132C1222.98 209.103 1227.16 209.055 1232.32 208.996C1242.66 208.909 1256.94 208.87 1272.71 208.89C1288.48 208.909 1302.76 208.977 1313.1 209.045C1318.26 209.093 1322.44 209.123 1325.34 209.152C1326.78 209.171 1327.9 209.181 1328.67 209.2C1329.05 209.2 1329.33 209.21 1329.54 209.22C1329.73 209.22 1329.83 209.239 1329.83 209.239V209.22Z"
                    fill="#1A2E35" />
                <path
                    d="M1223.2 209.365C1223.2 209.365 1223.25 209.268 1223.37 209.093C1223.5 208.899 1223.68 208.647 1223.89 208.327C1224.37 207.648 1225.05 206.707 1225.86 205.552C1227.57 203.204 1229.9 200.003 1232.47 196.462C1234.94 193.105 1237.19 190.058 1238.87 187.779L1238.85 187.866C1238.47 186.362 1238.15 185.13 1237.92 184.247C1237.83 183.84 1237.75 183.51 1237.68 183.257C1237.63 183.034 1237.6 182.908 1237.61 182.908C1237.62 182.908 1237.66 183.025 1237.73 183.248C1237.81 183.5 1237.9 183.82 1238.02 184.218C1238.27 185.101 1238.61 186.323 1239.04 187.817V187.866L1239.02 187.905C1237.35 190.194 1235.12 193.26 1232.67 196.627C1230.08 200.148 1227.72 203.331 1226 205.669C1225.15 206.794 1224.46 207.726 1223.96 208.395L1223.39 209.123C1223.25 209.288 1223.18 209.375 1223.17 209.365H1223.2Z"
                    fill="#1A2E35" />
                <path
                    d="M1308.52 182.763C1308.52 182.763 1308.53 182.84 1308.54 183.005L1308.56 183.723C1308.56 184.373 1308.58 185.314 1308.59 186.537V186.595H1308.53C1302.71 186.75 1290.17 187.012 1275.68 187.284C1265.56 187.458 1256.41 187.614 1249.78 187.73C1246.47 187.779 1243.8 187.808 1241.93 187.837C1241.02 187.837 1240.31 187.846 1239.8 187.856C1239.57 187.856 1239.39 187.856 1239.25 187.856C1239.12 187.856 1239.06 187.856 1239.06 187.846C1239.06 187.846 1239.12 187.837 1239.24 187.827C1239.38 187.827 1239.56 187.817 1239.79 187.808C1240.3 187.788 1241.01 187.769 1241.92 187.74C1243.79 187.691 1246.47 187.633 1249.77 187.555C1256.41 187.42 1265.55 187.235 1275.67 187.031C1290.16 186.76 1302.71 186.556 1308.52 186.488L1308.46 186.546C1308.47 185.324 1308.48 184.393 1308.49 183.733L1308.51 183.015C1308.51 182.85 1308.52 182.772 1308.53 182.772L1308.52 182.763Z"
                    fill="#1A2E35" />
                <path
                    d="M1325.55 209.219C1325.5 209.268 1321.63 204.223 1316.93 197.965C1312.22 191.698 1308.45 186.595 1308.51 186.546C1308.57 186.498 1312.43 191.543 1317.14 197.8C1321.85 204.058 1325.61 209.171 1325.55 209.219Z"
                    fill="#1A2E35" />
                <g opacity="0.3">
                    <path
                        d="M1300.51 198.732C1300.84 197.907 1300.23 196.956 1299.42 196.578C1298.62 196.2 1297.7 196.238 1296.82 196.238C1295.94 196.238 1295 196.19 1294.27 195.666C1293.37 195.016 1292.95 193.726 1291.89 193.376C1290.52 192.93 1289.12 194.376 1287.72 194.046C1286.77 193.823 1286.17 192.853 1285.28 192.445C1283.6 191.679 1281.71 193.182 1279.86 193.066C1278.01 192.95 1276.51 191.232 1274.66 191.3C1273.39 191.339 1272.25 192.241 1270.97 192.212C1269.67 192.183 1268.53 191.193 1267.23 191.203C1265.3 191.223 1263.78 193.396 1261.87 193.095C1260.51 192.882 1259.43 191.407 1258.07 191.649C1256.86 191.863 1256.24 193.328 1255.07 193.716C1254.11 194.026 1253.01 193.541 1252.07 193.91C1250.55 194.512 1250.27 197.034 1248.64 197.228C1247.67 197.344 1246.58 196.51 1245.79 197.083C1245.26 197.461 1245.24 198.227 1245.4 198.858C1245.55 199.479 1245.84 200.1 1245.75 200.74C1245.66 201.38 1243.25 201.662 1245.23 201.565L1272.7 198.79L1300.5 198.722L1300.51 198.732Z"
                        fill="black" fill-opacity="0.46" />
                </g>
                <path
                    d="M1240.06 202.642C1239.21 202.273 1238.72 201.352 1238.59 200.43C1238.47 199.508 1238.67 198.587 1238.85 197.684C1239.12 196.423 1239.46 195.045 1240.49 194.269C1241.53 193.483 1242.97 193.542 1244.18 193.086C1245.83 192.455 1247.01 190.893 1248.67 190.33C1250.29 189.777 1252.08 190.253 1253.77 189.962C1255.67 189.632 1257.29 188.361 1259.18 187.953C1261.32 187.497 1263.51 188.215 1265.68 188.516C1268.51 188.914 1271.39 188.603 1274.24 188.516C1278.74 188.38 1283.24 188.807 1287.63 189.768C1287.63 189.768 1290.81 189.011 1292.84 190.03C1294.86 191.048 1295.6 191.553 1297.62 192.222C1299.65 192.901 1304.48 194.327 1305.22 196.433C1305.95 198.538 1305.6 198.8 1305.6 198.8L1295.37 194.143L1286.77 191.892L1273.07 190.709L1259.43 190.874L1251.06 193.299L1245.94 196.142L1242.9 199.217L1243.07 201.924L1240.05 202.642H1240.06Z"
                    fill="#FB5607" />
                <path
                    d="M1240.06 202.642C1239.21 202.273 1238.72 201.352 1238.59 200.43C1238.47 199.508 1238.67 198.587 1238.85 197.684C1239.12 196.423 1239.46 195.045 1240.49 194.269C1241.53 193.483 1242.97 193.542 1244.18 193.086C1245.83 192.455 1247.01 190.893 1248.67 190.33C1250.29 189.777 1252.08 190.253 1253.77 189.962C1255.67 189.632 1257.29 188.361 1259.18 187.953C1261.32 187.497 1263.51 188.215 1265.68 188.516C1268.51 188.914 1271.39 188.603 1274.24 188.516C1278.74 188.38 1283.24 188.807 1287.63 189.768C1287.63 189.768 1290.81 189.011 1292.84 190.03C1294.86 191.048 1295.6 191.553 1297.62 192.222C1299.65 192.901 1304.48 194.327 1305.22 196.433C1305.95 198.538 1305.6 198.8 1305.6 198.8L1295.37 194.143L1286.77 191.892L1273.07 190.709L1259.43 190.874L1251.06 193.299L1245.94 196.142L1242.9 199.217L1243.07 201.924L1240.05 202.642H1240.06Z"
                    fill="#FB5607" />
                <path
                    d="M1272.71 198.8C1272.71 198.8 1272.6 198.829 1272.36 198.858C1272.11 198.887 1271.77 198.936 1271.37 198.984C1270.47 199.081 1269.22 199.227 1267.69 199.401C1264.55 199.731 1260.27 200.178 1255.53 200.663C1251.22 201.08 1247.29 201.468 1244.3 201.759H1244.23L1244.2 201.71C1243.77 200.925 1242.95 200.517 1242.25 200.478C1241.54 200.43 1240.94 200.75 1240.58 201.089C1240.2 201.429 1240.01 201.798 1239.92 202.05C1239.82 202.302 1239.8 202.448 1239.79 202.448C1239.79 202.448 1239.79 202.409 1239.79 202.341C1239.79 202.273 1239.82 202.166 1239.86 202.031C1239.94 201.769 1240.11 201.381 1240.5 201.012C1240.87 200.643 1241.49 200.284 1242.26 200.323C1243.02 200.352 1243.9 200.76 1244.38 201.613L1244.29 201.565C1247.28 201.254 1251.21 200.847 1255.51 200.401C1260.25 199.935 1264.54 199.518 1267.68 199.217C1269.21 199.081 1270.47 198.965 1271.37 198.887C1271.78 198.858 1272.11 198.829 1272.37 198.81C1272.61 198.8 1272.72 198.79 1272.72 198.81L1272.71 198.8Z"
                    fill="#1A2E35" />
                <path
                    d="M1249.07 195.327C1249.07 195.327 1248.9 195.734 1248.3 196.044C1248.01 196.2 1247.63 196.326 1247.22 196.433C1246.81 196.549 1246.36 196.656 1245.94 196.869C1245.08 197.277 1244.8 198.208 1244.35 198.693C1243.93 199.217 1243.46 199.295 1243.46 199.256C1243.44 199.217 1243.84 199.091 1244.2 198.577C1244.38 198.324 1244.56 197.995 1244.78 197.616C1244.99 197.247 1245.35 196.85 1245.82 196.627C1246.27 196.394 1246.75 196.297 1247.15 196.19C1247.56 196.093 1247.93 195.986 1248.21 195.87C1248.79 195.627 1249.03 195.297 1249.06 195.327H1249.07Z"
                    fill="#1A2E35" />
                <path
                    d="M1290.9 195.957C1290.62 195.656 1290.22 195.511 1289.85 195.375C1288.35 194.88 1286.77 194.667 1285.2 194.725C1283.96 194.773 1282.72 194.987 1281.48 194.88C1280.53 194.793 1279.61 194.512 1278.68 194.279C1277.3 193.929 1275.9 193.677 1274.49 193.425C1273.19 193.192 1271.85 192.959 1270.54 193.192C1269.67 193.347 1268.83 193.716 1267.94 193.726C1267.23 193.726 1266.54 193.512 1265.85 193.444C1264.83 193.338 1263.81 193.551 1262.78 193.609C1261.77 193.667 1260.48 193.648 1259.7 192.998C1259.08 192.464 1258.11 192.843 1257.55 193.425C1256.98 194.007 1256.59 194.773 1255.89 195.181C1254.78 195.831 1253.16 195.394 1252.25 196.316C1251.37 197.209 1251.88 198.868 1252.94 199.508C1254.02 200.158 1255.38 200.051 1256.61 199.789C1258.59 199.353 1260.57 198.528 1262.58 198.839C1263.78 199.023 1264.99 199.605 1266.16 199.265C1267.37 198.916 1268.2 197.636 1269.45 197.48C1270.46 197.354 1271.39 198.014 1272.39 198.198C1273.58 198.412 1274.78 197.946 1275.98 197.839C1277.87 197.665 1279.74 198.373 1281.63 198.615C1284.5 198.984 1287.38 198.276 1290.17 197.568C1290.52 197.48 1290.9 197.374 1291.09 197.073C1291.32 196.733 1291.19 196.248 1290.91 195.957H1290.9Z"
                    fill="#FB5607" />
                <path
                    d="M1290.9 195.957C1290.62 195.656 1290.22 195.511 1289.85 195.375C1288.35 194.88 1286.77 194.667 1285.2 194.725C1283.96 194.773 1282.72 194.987 1281.48 194.88C1280.53 194.793 1279.61 194.512 1278.68 194.279C1277.3 193.929 1275.9 193.677 1274.49 193.425C1273.19 193.192 1271.85 192.959 1270.54 193.192C1269.67 193.347 1268.83 193.716 1267.94 193.726C1267.23 193.726 1266.54 193.512 1265.85 193.444C1264.83 193.338 1263.81 193.551 1262.78 193.609C1261.77 193.667 1260.48 193.648 1259.7 192.998C1259.08 192.464 1258.11 192.843 1257.55 193.425C1256.98 194.007 1256.59 194.773 1255.89 195.181C1254.78 195.831 1253.16 195.394 1252.25 196.316C1251.37 197.209 1251.88 198.868 1252.94 199.508C1254.02 200.158 1255.38 200.051 1256.61 199.789C1258.59 199.353 1260.57 198.528 1262.58 198.839C1263.78 199.023 1264.99 199.605 1266.16 199.265C1267.37 198.916 1268.2 197.636 1269.45 197.48C1270.46 197.354 1271.39 198.014 1272.39 198.198C1273.58 198.412 1274.78 197.946 1275.98 197.839C1277.87 197.665 1279.74 198.373 1281.63 198.615C1284.5 198.984 1287.38 198.276 1290.17 197.568C1290.52 197.48 1290.9 197.374 1291.09 197.073C1291.32 196.733 1291.19 196.248 1290.91 195.957H1290.9Z"
                    fill="#FB5607" />
                <g opacity="0.4">
                    <path
                        d="M1290.9 195.957C1290.62 195.656 1290.22 195.511 1289.85 195.375C1288.35 194.88 1286.77 194.667 1285.2 194.725C1283.96 194.773 1282.72 194.987 1281.48 194.88C1280.53 194.793 1279.61 194.512 1278.68 194.279C1277.3 193.929 1275.9 193.677 1274.49 193.425C1273.19 193.192 1271.85 192.959 1270.54 193.192C1269.67 193.347 1268.83 193.716 1267.94 193.726C1267.23 193.726 1266.54 193.512 1265.85 193.444C1264.83 193.338 1263.81 193.551 1262.78 193.609C1261.77 193.667 1260.48 193.648 1259.7 192.998C1259.08 192.464 1258.11 192.843 1257.55 193.425C1256.98 194.007 1256.59 194.773 1255.89 195.181C1254.78 195.831 1253.16 195.394 1252.25 196.316C1251.37 197.209 1251.88 198.868 1252.94 199.508C1254.02 200.158 1255.38 200.051 1256.61 199.789C1258.59 199.353 1260.57 198.528 1262.58 198.839C1263.78 199.023 1264.99 199.605 1266.16 199.265C1267.37 198.916 1268.2 197.636 1269.45 197.48C1270.46 197.354 1271.39 198.014 1272.39 198.198C1273.58 198.412 1274.78 197.946 1275.98 197.839C1277.87 197.665 1279.74 198.373 1281.63 198.615C1284.5 198.984 1287.38 198.276 1290.17 197.568C1290.52 197.48 1290.9 197.374 1291.09 197.073C1291.32 196.733 1291.19 196.248 1290.91 195.957H1290.9Z"
                        fill="white" />
                </g>
                <path
                    d="M1253.78 189.961C1253.78 189.961 1254.08 190.058 1254.59 190.291C1255.15 190.544 1255.89 190.873 1256.78 191.271C1258.62 192.106 1261.16 193.279 1263.96 194.579C1267.76 196.355 1271.07 197.927 1272.74 198.751L1272.78 198.771V198.809L1272.75 199.896C1272.74 200.139 1272.73 200.274 1272.72 200.274C1272.71 200.274 1272.7 200.148 1272.69 199.896L1272.66 198.809L1272.7 198.868C1270.99 198.111 1267.67 196.588 1263.86 194.812C1261.06 193.503 1258.53 192.309 1256.71 191.436C1255.83 191.009 1255.1 190.65 1254.56 190.388C1254.06 190.136 1253.78 189.991 1253.79 189.971L1253.78 189.961Z"
                    fill="#1A2E35" />
                <path
                    d="M1284.64 189.117C1284.69 189.175 1282.11 191.417 1278.88 194.123C1275.65 196.83 1272.99 198.984 1272.94 198.935C1272.9 198.877 1275.48 196.636 1278.71 193.929C1281.94 191.222 1284.6 189.069 1284.64 189.127V189.117Z"
                    fill="#1A2E35" />
                <path
                    d="M1267.84 190.631C1267.88 190.679 1266.68 191.378 1265 191.562C1263.34 191.756 1262.01 191.358 1262.03 191.3C1262.04 191.223 1263.36 191.494 1264.97 191.3C1266.59 191.126 1267.8 190.553 1267.84 190.631Z"
                    fill="#1A2E35" />
                <path
                    d="M1276.35 191.252C1276.32 191.32 1275.78 191.174 1275.09 191.087C1274.42 191 1273.85 191 1273.84 190.922C1273.83 190.854 1274.41 190.728 1275.12 190.825C1275.84 190.922 1276.37 191.184 1276.34 191.252H1276.35Z"
                    fill="#1A2E35" />
                <path
                    d="M1293.68 193.745C1293.62 193.794 1293.12 193.066 1292.14 192.785C1291.16 192.474 1290.35 192.814 1290.32 192.736C1290.31 192.707 1290.48 192.581 1290.83 192.484C1291.17 192.387 1291.69 192.368 1292.21 192.523C1292.73 192.678 1293.15 192.979 1293.38 193.25C1293.62 193.512 1293.7 193.726 1293.67 193.745H1293.68Z"
                    fill="#1A2E35" />
                <path
                    d="M1305.25 198.451C1305.25 198.451 1305.2 198.295 1305.04 198.014C1304.89 197.742 1304.61 197.364 1304.1 197.054C1303.62 196.753 1302.87 196.53 1302.09 196.801C1301.32 197.044 1300.55 197.772 1300.39 198.771L1300.37 198.858H1300.29C1297.43 198.829 1293.8 198.79 1289.86 198.781C1285.09 198.771 1280.77 198.8 1277.65 198.829C1276.11 198.839 1274.85 198.848 1273.95 198.858H1272.94C1272.71 198.858 1272.6 198.848 1272.6 198.839C1272.6 198.839 1272.71 198.819 1272.94 198.8L1273.95 198.751C1274.85 198.722 1276.11 198.684 1277.65 198.645C1280.78 198.577 1285.1 198.509 1289.87 198.519C1293.81 198.519 1297.44 198.577 1300.3 198.645L1300.19 198.732C1300.38 197.636 1301.23 196.879 1302.04 196.627C1302.88 196.355 1303.68 196.617 1304.17 196.947C1304.68 197.277 1304.95 197.694 1305.1 197.975C1305.24 198.266 1305.25 198.441 1305.25 198.441V198.451Z"
                    fill="#1A2E35" />
                <path
                    d="M1255.32 198.421C1255.32 199.372 1254.08 200.139 1252.56 200.139C1251.04 200.139 1249.8 199.372 1249.8 198.421C1249.8 197.471 1251.04 196.704 1252.56 196.704C1254.08 196.704 1255.32 197.471 1255.32 198.421Z"
                    fill="#FB5607" />
                <path
                    d="M1255.32 198.421C1255.32 199.372 1254.08 200.139 1252.56 200.139C1251.04 200.139 1249.8 199.372 1249.8 198.421C1249.8 197.471 1251.04 196.704 1252.56 196.704C1254.08 196.704 1255.32 197.471 1255.32 198.421Z"
                    fill="#FB5607" />
                <path
                    d="M1253.46 199.333C1253.49 199.401 1253.44 199.489 1253.34 199.527C1253.24 199.566 1253.15 199.547 1253.12 199.479C1253.09 199.411 1253.14 199.324 1253.24 199.285C1253.33 199.246 1253.43 199.266 1253.46 199.333Z"
                    fill="#E1E1E1" />
                <path
                    d="M1253.63 198.547C1253.67 198.606 1253.64 198.693 1253.57 198.741C1253.51 198.78 1253.42 198.77 1253.38 198.703C1253.34 198.644 1253.37 198.557 1253.44 198.509C1253.51 198.47 1253.59 198.479 1253.63 198.547Z"
                    fill="#E1E1E1" />
                <path
                    d="M1254.53 198.577C1254.59 198.625 1254.59 198.713 1254.53 198.771C1254.48 198.829 1254.4 198.829 1254.34 198.78C1254.28 198.732 1254.28 198.645 1254.34 198.586C1254.39 198.528 1254.47 198.528 1254.53 198.577Z"
                    fill="#E1E1E1" />
                <path
                    d="M1251.7 198.12C1251.72 198.188 1251.7 198.266 1251.63 198.305C1251.56 198.334 1251.47 198.305 1251.44 198.247C1251.41 198.179 1251.44 198.101 1251.51 198.062C1251.58 198.033 1251.67 198.062 1251.7 198.12Z"
                    fill="#E1E1E1" />
                <path
                    d="M1253.21 197.703C1253.24 197.771 1253.21 197.859 1253.12 197.888C1253.04 197.927 1252.94 197.907 1252.92 197.839C1252.89 197.771 1252.92 197.684 1253 197.655C1253.08 197.616 1253.18 197.645 1253.21 197.703Z"
                    fill="#E1E1E1" />
                <path
                    d="M1254.33 197.849C1254.36 197.917 1254.33 197.985 1254.28 198.004C1254.23 198.024 1254.16 197.985 1254.15 197.917C1254.12 197.849 1254.15 197.781 1254.19 197.762C1254.24 197.742 1254.31 197.781 1254.33 197.849Z"
                    fill="#E1E1E1" />
                <path
                    d="M1252.25 197.218C1252.28 197.286 1252.2 197.383 1252.07 197.451C1251.95 197.51 1251.82 197.51 1251.78 197.451C1251.75 197.383 1251.83 197.286 1251.96 197.218C1252.08 197.16 1252.21 197.16 1252.25 197.218Z"
                    fill="#E1E1E1" />
                <path
                    d="M1250.56 197.859C1250.58 197.927 1250.54 198.004 1250.47 198.024C1250.39 198.043 1250.31 198.014 1250.29 197.936C1250.27 197.868 1250.31 197.791 1250.39 197.771C1250.47 197.752 1250.54 197.781 1250.56 197.859Z"
                    fill="#E1E1E1" />
                <path
                    d="M1250.65 198.78C1250.69 198.848 1250.66 198.926 1250.59 198.965C1250.52 199.003 1250.45 198.984 1250.41 198.916C1250.37 198.848 1250.4 198.77 1250.47 198.732C1250.53 198.693 1250.61 198.712 1250.65 198.78Z"
                    fill="#E1E1E1" />
                <path
                    d="M1252.06 199.411C1252.09 199.479 1252.04 199.566 1251.96 199.605C1251.87 199.644 1251.77 199.624 1251.73 199.566C1251.7 199.498 1251.75 199.411 1251.84 199.372C1251.93 199.333 1252.02 199.353 1252.06 199.411Z"
                    fill="#E1E1E1" />
                <path
                    d="M1252.78 198.635C1252.81 198.703 1252.71 198.8 1252.58 198.858C1252.43 198.916 1252.3 198.906 1252.28 198.839C1252.26 198.771 1252.34 198.674 1252.48 198.615C1252.62 198.557 1252.76 198.567 1252.78 198.635Z"
                    fill="#E1E1E1" />
                <path
                    d="M1251.37 198.916C1251.4 198.984 1251.39 199.062 1251.33 199.091C1251.27 199.12 1251.19 199.091 1251.16 199.033C1251.12 198.965 1251.14 198.887 1251.2 198.858C1251.26 198.829 1251.34 198.858 1251.37 198.916Z"
                    fill="#E1E1E1" />
                <path
                    d="M1253.46 197.228C1253.48 197.296 1253.45 197.373 1253.39 197.393C1253.33 197.412 1253.26 197.373 1253.24 197.296C1253.23 197.228 1253.25 197.15 1253.31 197.131C1253.37 197.112 1253.44 197.15 1253.46 197.228Z"
                    fill="#E1E1E1" />
                <path
                    d="M1290.98 198.208C1292.5 198.208 1293.74 197.439 1293.74 196.491C1293.74 195.542 1292.5 194.773 1290.98 194.773C1289.45 194.773 1288.22 195.542 1288.22 196.491C1288.22 197.439 1289.45 198.208 1290.98 198.208Z"
                    fill="#FB5607" />
                <path
                    d="M1290.98 198.208C1292.5 198.208 1293.74 197.439 1293.74 196.491C1293.74 195.542 1292.5 194.773 1290.98 194.773C1289.45 194.773 1288.22 195.542 1288.22 196.491C1288.22 197.439 1289.45 198.208 1290.98 198.208Z"
                    fill="#FB5607" />
                <path
                    d="M1291.88 197.403C1291.91 197.471 1291.86 197.558 1291.76 197.597C1291.67 197.636 1291.57 197.616 1291.54 197.548C1291.51 197.48 1291.56 197.393 1291.66 197.354C1291.75 197.315 1291.85 197.335 1291.88 197.403Z"
                    fill="#E1E1E1" />
                <path
                    d="M1292.04 196.617C1292.08 196.675 1292.05 196.762 1291.99 196.811C1291.92 196.85 1291.83 196.84 1291.79 196.772C1291.75 196.704 1291.78 196.626 1291.85 196.578C1291.92 196.539 1292.01 196.549 1292.04 196.617Z"
                    fill="#E1E1E1" />
                <path
                    d="M1292.94 196.655C1293 196.704 1293 196.791 1292.94 196.849C1292.9 196.908 1292.81 196.908 1292.75 196.859C1292.69 196.811 1292.69 196.723 1292.75 196.665C1292.8 196.607 1292.89 196.607 1292.94 196.655Z"
                    fill="#E1E1E1" />
                <path
                    d="M1290.12 196.19C1290.15 196.258 1290.12 196.335 1290.05 196.374C1289.98 196.403 1289.89 196.374 1289.86 196.316C1289.84 196.248 1289.86 196.17 1289.93 196.132C1290 196.102 1290.09 196.132 1290.12 196.19Z"
                    fill="#E1E1E1" />
                <path
                    d="M1291.62 195.783C1291.65 195.851 1291.62 195.938 1291.53 195.967C1291.45 196.006 1291.36 195.986 1291.33 195.918C1291.3 195.851 1291.33 195.763 1291.41 195.734C1291.49 195.695 1291.59 195.715 1291.62 195.783Z"
                    fill="#E1E1E1" />
                <path
                    d="M1292.74 195.918C1292.77 195.986 1292.74 196.054 1292.69 196.074C1292.64 196.093 1292.58 196.054 1292.56 195.986C1292.53 195.918 1292.56 195.851 1292.61 195.831C1292.65 195.812 1292.72 195.851 1292.74 195.918Z"
                    fill="#E1E1E1" />
                <path
                    d="M1290.66 195.298C1290.69 195.365 1290.61 195.462 1290.48 195.53C1290.36 195.589 1290.23 195.589 1290.19 195.53C1290.16 195.462 1290.24 195.365 1290.37 195.298C1290.49 195.239 1290.62 195.239 1290.66 195.298Z"
                    fill="#E1E1E1" />
                <path
                    d="M1288.98 195.938C1289 196.006 1288.96 196.083 1288.89 196.103C1288.81 196.122 1288.73 196.093 1288.71 196.015C1288.69 195.948 1288.73 195.87 1288.81 195.851C1288.89 195.831 1288.96 195.86 1288.98 195.938Z"
                    fill="#E1E1E1" />
                <path
                    d="M1289.06 196.85C1289.1 196.917 1289.07 196.995 1289 197.034C1288.93 197.073 1288.86 197.053 1288.82 196.985C1288.78 196.917 1288.81 196.84 1288.88 196.801C1288.94 196.762 1289.02 196.782 1289.06 196.85Z"
                    fill="#E1E1E1" />
                <path
                    d="M1290.47 197.48C1290.5 197.548 1290.46 197.636 1290.37 197.674C1290.28 197.713 1290.18 197.694 1290.15 197.636C1290.12 197.568 1290.17 197.48 1290.25 197.442C1290.34 197.403 1290.44 197.422 1290.47 197.48Z"
                    fill="#E1E1E1" />
                <path
                    d="M1291.19 196.704C1291.22 196.772 1291.12 196.869 1290.99 196.927C1290.84 196.985 1290.71 196.976 1290.69 196.908C1290.66 196.84 1290.76 196.743 1290.89 196.685C1291.04 196.626 1291.17 196.636 1291.19 196.704Z"
                    fill="#E1E1E1" />
                <path
                    d="M1289.78 196.995C1289.82 197.063 1289.8 197.141 1289.74 197.17C1289.68 197.199 1289.6 197.17 1289.57 197.112C1289.54 197.044 1289.55 196.966 1289.61 196.937C1289.67 196.908 1289.75 196.937 1289.78 196.995Z"
                    fill="#E1E1E1" />
                <path
                    d="M1291.88 195.297C1291.9 195.365 1291.87 195.443 1291.81 195.462C1291.75 195.482 1291.69 195.443 1291.67 195.365C1291.65 195.297 1291.68 195.22 1291.73 195.2C1291.79 195.181 1291.86 195.22 1291.88 195.297Z"
                    fill="#E1E1E1" />
                <path
                    d="M1259.05 196.704C1260.41 196.704 1261.52 196.144 1261.52 195.453C1261.52 194.762 1260.41 194.201 1259.05 194.201C1257.68 194.201 1256.58 194.762 1256.58 195.453C1256.58 196.144 1257.68 196.704 1259.05 196.704Z"
                    fill="#FB5607" />
                <path
                    d="M1259.05 196.704C1260.41 196.704 1261.52 196.144 1261.52 195.453C1261.52 194.762 1260.41 194.201 1259.05 194.201C1257.68 194.201 1256.58 194.762 1256.58 195.453C1256.58 196.144 1257.68 196.704 1259.05 196.704Z"
                    fill="#FB5607" />
                <path
                    d="M1259.85 196.112C1259.88 196.18 1259.83 196.258 1259.74 196.297C1259.66 196.326 1259.57 196.297 1259.55 196.229C1259.52 196.161 1259.57 196.083 1259.66 196.044C1259.74 196.015 1259.83 196.044 1259.85 196.112Z"
                    fill="#E1E1E1" />
                <path
                    d="M1260.01 195.54C1260.03 195.608 1260.01 195.686 1259.95 195.715C1259.88 195.744 1259.81 195.715 1259.77 195.647C1259.73 195.579 1259.77 195.501 1259.83 195.472C1259.9 195.443 1259.97 195.472 1260.01 195.54Z"
                    fill="#E1E1E1" />
                <path
                    d="M1260.81 195.569C1260.86 195.627 1260.86 195.705 1260.81 195.744C1260.76 195.782 1260.68 195.773 1260.63 195.715C1260.59 195.656 1260.59 195.579 1260.63 195.54C1260.68 195.501 1260.76 195.511 1260.81 195.569Z"
                    fill="#E1E1E1" />
                <path
                    d="M1258.27 195.23C1258.3 195.297 1258.27 195.375 1258.2 195.394C1258.14 195.414 1258.07 195.385 1258.04 195.317C1258.01 195.249 1258.04 195.171 1258.11 195.152C1258.17 195.132 1258.24 195.162 1258.27 195.23Z"
                    fill="#E1E1E1" />
                <path
                    d="M1259.62 194.938C1259.65 195.006 1259.61 195.084 1259.54 195.113C1259.47 195.142 1259.39 195.113 1259.37 195.035C1259.34 194.967 1259.38 194.89 1259.44 194.861C1259.51 194.832 1259.6 194.861 1259.62 194.938Z"
                    fill="#E1E1E1" />
                <path
                    d="M1260.62 195.035C1260.64 195.103 1260.62 195.171 1260.58 195.191C1260.53 195.2 1260.48 195.162 1260.45 195.084C1260.43 195.016 1260.45 194.948 1260.5 194.929C1260.55 194.919 1260.6 194.958 1260.62 195.035Z"
                    fill="#E1E1E1" />
                <path
                    d="M1258.77 194.579C1258.79 194.647 1258.72 194.735 1258.61 194.783C1258.49 194.832 1258.39 194.812 1258.36 194.744C1258.33 194.676 1258.41 194.589 1258.51 194.541C1258.63 194.492 1258.74 194.512 1258.77 194.579Z"
                    fill="#E1E1E1" />
                <path
                    d="M1257.26 195.045C1257.28 195.113 1257.24 195.191 1257.18 195.2C1257.11 195.22 1257.04 195.171 1257.02 195.103C1257 195.035 1257.04 194.958 1257.11 194.948C1257.18 194.929 1257.24 194.977 1257.26 195.045Z"
                    fill="#E1E1E1" />
                <path
                    d="M1257.33 195.715C1257.36 195.783 1257.33 195.86 1257.28 195.88C1257.23 195.909 1257.15 195.88 1257.12 195.812C1257.09 195.744 1257.12 195.666 1257.17 195.647C1257.23 195.618 1257.3 195.647 1257.33 195.715Z"
                    fill="#E1E1E1" />
                <path
                    d="M1258.6 196.171C1258.63 196.238 1258.58 196.316 1258.5 196.355C1258.43 196.384 1258.34 196.355 1258.31 196.287C1258.28 196.219 1258.33 196.141 1258.41 196.112C1258.48 196.083 1258.57 196.112 1258.6 196.18V196.171Z"
                    fill="#E1E1E1" />
                <path
                    d="M1259.24 195.608C1259.26 195.676 1259.18 195.763 1259.06 195.812C1258.93 195.85 1258.81 195.831 1258.78 195.763C1258.77 195.695 1258.84 195.608 1258.97 195.559C1259.09 195.521 1259.21 195.54 1259.24 195.608Z"
                    fill="#E1E1E1" />
                <path
                    d="M1257.98 195.821C1258.01 195.889 1258 195.957 1257.94 195.986C1257.89 196.006 1257.83 195.977 1257.8 195.909C1257.77 195.841 1257.78 195.773 1257.84 195.744C1257.88 195.724 1257.95 195.753 1257.98 195.821Z"
                    fill="#E1E1E1" />
                <path
                    d="M1259.85 194.589C1259.87 194.657 1259.84 194.725 1259.78 194.744C1259.72 194.754 1259.67 194.715 1259.65 194.638C1259.63 194.57 1259.66 194.502 1259.71 194.482C1259.77 194.473 1259.83 194.512 1259.85 194.589Z"
                    fill="#E1E1E1" />
                <path
                    d="M1270.26 193.813C1270.26 194.502 1269.16 195.065 1267.79 195.065C1266.43 195.065 1265.32 194.502 1265.32 193.813C1265.32 193.124 1266.43 192.562 1267.79 192.562C1269.16 192.562 1270.26 193.124 1270.26 193.813Z"
                    fill="#FB5607" />
                <path
                    d="M1270.26 193.813C1270.26 194.502 1269.16 195.065 1267.79 195.065C1266.43 195.065 1265.32 194.502 1265.32 193.813C1265.32 193.124 1266.43 192.562 1267.79 192.562C1269.16 192.562 1270.26 193.124 1270.26 193.813Z"
                    fill="#FB5607" />
                <path
                    d="M1268.6 194.482C1268.63 194.55 1268.58 194.628 1268.49 194.667C1268.4 194.696 1268.32 194.667 1268.3 194.599C1268.27 194.531 1268.32 194.453 1268.4 194.415C1268.49 194.385 1268.58 194.415 1268.6 194.482Z"
                    fill="#E1E1E1" />
                <path
                    d="M1268.75 193.91C1268.78 193.978 1268.75 194.056 1268.69 194.085C1268.62 194.114 1268.56 194.085 1268.52 194.017C1268.48 193.949 1268.52 193.871 1268.58 193.842C1268.64 193.813 1268.71 193.842 1268.75 193.91Z"
                    fill="#E1E1E1" />
                <path
                    d="M1269.55 193.929C1269.6 193.988 1269.6 194.065 1269.55 194.104C1269.51 194.143 1269.43 194.133 1269.38 194.075C1269.33 194.017 1269.33 193.939 1269.38 193.9C1269.43 193.861 1269.51 193.871 1269.55 193.929Z"
                    fill="#E1E1E1" />
                <path
                    d="M1267.02 193.6C1267.05 193.668 1267.02 193.745 1266.95 193.765C1266.88 193.784 1266.81 193.755 1266.78 193.687C1266.76 193.619 1266.78 193.541 1266.85 193.522C1266.92 193.503 1266.99 193.532 1267.02 193.6Z"
                    fill="#E1E1E1" />
                <path
                    d="M1268.36 193.299C1268.39 193.367 1268.35 193.444 1268.29 193.473C1268.22 193.502 1268.13 193.473 1268.11 193.396C1268.08 193.328 1268.12 193.25 1268.19 193.221C1268.26 193.192 1268.34 193.221 1268.36 193.299Z"
                    fill="#E1E1E1" />
                <path
                    d="M1269.37 193.396C1269.39 193.464 1269.37 193.532 1269.32 193.551C1269.27 193.561 1269.23 193.522 1269.2 193.444C1269.18 193.376 1269.2 193.308 1269.24 193.289C1269.29 193.279 1269.34 193.318 1269.37 193.396Z"
                    fill="#E1E1E1" />
                <path
                    d="M1267.51 192.94C1267.54 193.008 1267.46 193.095 1267.36 193.144C1267.24 193.192 1267.13 193.173 1267.1 193.105C1267.08 193.037 1267.15 192.949 1267.26 192.901C1267.38 192.852 1267.48 192.872 1267.51 192.94Z"
                    fill="#E1E1E1" />
                <path
                    d="M1266.01 193.406C1266.03 193.473 1265.99 193.551 1265.92 193.561C1265.86 193.58 1265.79 193.532 1265.77 193.464C1265.75 193.396 1265.79 193.318 1265.85 193.309C1265.92 193.289 1265.99 193.338 1266.01 193.406Z"
                    fill="#E1E1E1" />
                <path
                    d="M1266.08 194.075C1266.11 194.143 1266.08 194.221 1266.03 194.24C1265.97 194.269 1265.89 194.24 1265.86 194.172C1265.84 194.104 1265.86 194.027 1265.91 194.007C1265.97 193.978 1266.05 194.007 1266.08 194.075Z"
                    fill="#E1E1E1" />
                <path
                    d="M1267.35 194.531C1267.38 194.599 1267.33 194.676 1267.25 194.715C1267.17 194.744 1267.09 194.715 1267.06 194.647C1267.03 194.579 1267.08 194.502 1267.15 194.473C1267.23 194.444 1267.32 194.473 1267.35 194.541V194.531Z"
                    fill="#E1E1E1" />
                <path
                    d="M1267.99 193.968C1268.01 194.036 1267.93 194.123 1267.8 194.172C1267.68 194.211 1267.56 194.191 1267.53 194.123C1267.51 194.056 1267.59 193.968 1267.71 193.92C1267.84 193.881 1267.96 193.9 1267.99 193.968Z"
                    fill="#E1E1E1" />
                <path
                    d="M1266.73 194.182C1266.76 194.25 1266.75 194.317 1266.69 194.347C1266.63 194.376 1266.57 194.337 1266.54 194.269C1266.51 194.201 1266.52 194.133 1266.58 194.104C1266.63 194.085 1266.7 194.114 1266.73 194.182Z"
                    fill="#E1E1E1" />
                <path
                    d="M1268.6 192.949C1268.62 193.017 1268.59 193.085 1268.53 193.105C1268.47 193.114 1268.41 193.076 1268.39 192.998C1268.37 192.93 1268.4 192.862 1268.46 192.843C1268.52 192.833 1268.58 192.872 1268.6 192.949Z"
                    fill="#E1E1E1" />
                <path
                    d="M1266.06 197.907C1266.06 198.596 1264.95 199.158 1263.59 199.158C1262.22 199.158 1261.12 198.596 1261.12 197.907C1261.12 197.218 1262.22 196.655 1263.59 196.655C1264.95 196.655 1266.06 197.218 1266.06 197.907Z"
                    fill="#FB5607" />
                <path
                    d="M1266.06 197.907C1266.06 198.596 1264.95 199.158 1263.59 199.158C1262.22 199.158 1261.12 198.596 1261.12 197.907C1261.12 197.218 1262.22 196.655 1263.59 196.655C1264.95 196.655 1266.06 197.218 1266.06 197.907Z"
                    fill="#FB5607" />
                <path
                    d="M1264.39 198.566C1264.42 198.634 1264.37 198.712 1264.29 198.751C1264.2 198.78 1264.11 198.751 1264.09 198.683C1264.06 198.615 1264.11 198.537 1264.2 198.499C1264.29 198.469 1264.37 198.499 1264.39 198.566Z"
                    fill="#E1E1E1" />
                <path
                    d="M1264.55 197.994C1264.58 198.062 1264.55 198.14 1264.49 198.169C1264.42 198.198 1264.35 198.169 1264.32 198.101C1264.28 198.033 1264.32 197.955 1264.37 197.926C1264.44 197.897 1264.51 197.926 1264.55 197.994Z"
                    fill="#E1E1E1" />
                <path
                    d="M1265.36 198.023C1265.41 198.081 1265.41 198.159 1265.36 198.198C1265.31 198.237 1265.24 198.227 1265.19 198.169C1265.14 198.11 1265.14 198.033 1265.19 197.994C1265.24 197.955 1265.31 197.965 1265.36 198.023Z"
                    fill="#E1E1E1" />
                <path
                    d="M1262.82 197.684C1262.85 197.752 1262.82 197.829 1262.76 197.849C1262.69 197.868 1262.62 197.839 1262.59 197.771C1262.56 197.703 1262.59 197.625 1262.66 197.606C1262.73 197.587 1262.79 197.616 1262.82 197.684Z"
                    fill="#E1E1E1" />
                <path
                    d="M1264.17 197.392C1264.2 197.46 1264.16 197.538 1264.09 197.567C1264.02 197.596 1263.94 197.567 1263.92 197.489C1263.9 197.412 1263.93 197.344 1264 197.315C1264.06 197.286 1264.15 197.315 1264.17 197.392Z"
                    fill="#E1E1E1" />
                <path
                    d="M1265.18 197.49C1265.2 197.557 1265.18 197.625 1265.13 197.645C1265.08 197.654 1265.03 197.616 1265 197.538C1264.98 197.47 1265 197.402 1265.05 197.383C1265.1 197.373 1265.15 197.412 1265.18 197.49Z"
                    fill="#E1E1E1" />
                <path
                    d="M1263.32 197.034C1263.35 197.101 1263.27 197.189 1263.16 197.237C1263.05 197.286 1262.94 197.266 1262.91 197.198C1262.88 197.131 1262.96 197.043 1263.07 196.995C1263.18 196.946 1263.29 196.966 1263.32 197.034Z"
                    fill="#E1E1E1" />
                <path
                    d="M1261.81 197.499C1261.83 197.567 1261.79 197.645 1261.72 197.655C1261.65 197.674 1261.58 197.625 1261.56 197.557C1261.55 197.49 1261.58 197.412 1261.65 197.402C1261.72 197.383 1261.79 197.431 1261.81 197.499Z"
                    fill="#E1E1E1" />
                <path
                    d="M1261.88 198.169C1261.91 198.237 1261.88 198.315 1261.84 198.334C1261.78 198.363 1261.7 198.334 1261.67 198.266C1261.64 198.198 1261.67 198.12 1261.72 198.101C1261.78 198.072 1261.85 198.101 1261.88 198.169Z"
                    fill="#E1E1E1" />
                <path
                    d="M1263.14 198.625C1263.17 198.692 1263.12 198.77 1263.05 198.809C1262.97 198.838 1262.88 198.809 1262.85 198.741C1262.82 198.673 1262.87 198.595 1262.95 198.557C1263.03 198.528 1263.11 198.557 1263.14 198.625Z"
                    fill="#E1E1E1" />
                <path
                    d="M1263.79 198.062C1263.81 198.13 1263.73 198.217 1263.61 198.266C1263.48 198.304 1263.37 198.285 1263.34 198.217C1263.32 198.149 1263.39 198.062 1263.52 198.013C1263.65 197.975 1263.76 197.994 1263.79 198.062Z"
                    fill="#E1E1E1" />
                <path
                    d="M1262.52 198.275C1262.55 198.343 1262.54 198.411 1262.48 198.44C1262.44 198.46 1262.37 198.431 1262.34 198.363C1262.31 198.295 1262.32 198.227 1262.38 198.198C1262.44 198.169 1262.49 198.207 1262.52 198.275Z"
                    fill="#E1E1E1" />
                <path
                    d="M1264.39 197.043C1264.41 197.111 1264.38 197.179 1264.32 197.198C1264.27 197.208 1264.21 197.169 1264.19 197.092C1264.17 197.024 1264.2 196.956 1264.26 196.937C1264.32 196.927 1264.37 196.966 1264.39 197.043Z"
                    fill="#E1E1E1" />
                <path
                    d="M1279.66 198.266C1281.02 198.266 1282.13 197.705 1282.13 197.014C1282.13 196.323 1281.02 195.763 1279.66 195.763C1278.29 195.763 1277.19 196.323 1277.19 197.014C1277.19 197.705 1278.29 198.266 1279.66 198.266Z"
                    fill="#FB5607" />
                <path
                    d="M1279.66 198.266C1281.02 198.266 1282.13 197.705 1282.13 197.014C1282.13 196.323 1281.02 195.763 1279.66 195.763C1278.29 195.763 1277.19 196.323 1277.19 197.014C1277.19 197.705 1278.29 198.266 1279.66 198.266Z"
                    fill="#FB5607" />
                <path
                    d="M1280.46 197.674C1280.49 197.742 1280.44 197.819 1280.35 197.858C1280.27 197.887 1280.18 197.858 1280.16 197.79C1280.13 197.722 1280.18 197.645 1280.27 197.606C1280.35 197.577 1280.44 197.606 1280.46 197.674Z"
                    fill="#E1E1E1" />
                <path
                    d="M1280.62 197.102C1280.64 197.17 1280.62 197.247 1280.56 197.276C1280.49 197.305 1280.42 197.276 1280.38 197.208C1280.35 197.14 1280.38 197.063 1280.44 197.034C1280.51 197.005 1280.58 197.034 1280.62 197.102Z"
                    fill="#E1E1E1" />
                <path
                    d="M1281.42 197.131C1281.47 197.189 1281.47 197.266 1281.42 197.305C1281.37 197.344 1281.29 197.334 1281.24 197.276C1281.2 197.218 1281.2 197.14 1281.24 197.101C1281.29 197.063 1281.37 197.072 1281.42 197.131Z"
                    fill="#E1E1E1" />
                <path
                    d="M1278.89 196.791C1278.92 196.859 1278.89 196.937 1278.82 196.956C1278.76 196.975 1278.69 196.946 1278.66 196.878C1278.63 196.81 1278.66 196.733 1278.73 196.713C1278.79 196.694 1278.86 196.723 1278.89 196.791Z"
                    fill="#E1E1E1" />
                <path
                    d="M1280.24 196.491C1280.27 196.558 1280.23 196.636 1280.16 196.665C1280.09 196.694 1280.01 196.665 1279.99 196.588C1279.96 196.52 1280 196.442 1280.06 196.413C1280.13 196.384 1280.22 196.413 1280.24 196.491Z"
                    fill="#E1E1E1" />
                <path
                    d="M1281.24 196.597C1281.26 196.665 1281.24 196.733 1281.2 196.752C1281.15 196.762 1281.1 196.723 1281.07 196.645C1281.04 196.568 1281.07 196.51 1281.12 196.49C1281.17 196.481 1281.22 196.519 1281.24 196.597Z"
                    fill="#E1E1E1" />
                <path
                    d="M1279.38 196.141C1279.4 196.209 1279.33 196.296 1279.22 196.345C1279.1 196.393 1279 196.374 1278.97 196.306C1278.94 196.238 1279.02 196.151 1279.12 196.102C1279.24 196.054 1279.35 196.073 1279.38 196.141Z"
                    fill="#E1E1E1" />
                <path
                    d="M1277.87 196.607C1277.89 196.675 1277.86 196.752 1277.79 196.762C1277.72 196.781 1277.65 196.733 1277.63 196.665C1277.61 196.597 1277.65 196.519 1277.72 196.51C1277.79 196.49 1277.86 196.539 1277.87 196.607Z"
                    fill="#E1E1E1" />
                <path
                    d="M1277.95 197.276C1277.98 197.344 1277.95 197.422 1277.9 197.441C1277.86 197.461 1277.77 197.441 1277.74 197.373C1277.71 197.306 1277.74 197.228 1277.79 197.209C1277.85 197.179 1277.92 197.208 1277.95 197.276Z"
                    fill="#E1E1E1" />
                <path
                    d="M1279.21 197.732C1279.24 197.8 1279.19 197.878 1279.11 197.916C1279.04 197.945 1278.95 197.916 1278.92 197.848C1278.89 197.78 1278.94 197.703 1279.02 197.664C1279.09 197.635 1279.18 197.664 1279.21 197.732Z"
                    fill="#E1E1E1" />
                <path
                    d="M1279.85 197.169C1279.87 197.237 1279.79 197.325 1279.67 197.373C1279.54 197.412 1279.42 197.393 1279.4 197.325C1279.38 197.257 1279.45 197.169 1279.58 197.121C1279.7 197.082 1279.82 197.101 1279.85 197.169Z"
                    fill="#E1E1E1" />
                <path
                    d="M1278.59 197.373C1278.62 197.441 1278.61 197.509 1278.55 197.538C1278.5 197.557 1278.44 197.528 1278.41 197.46C1278.38 197.392 1278.39 197.325 1278.45 197.295C1278.49 197.276 1278.56 197.305 1278.59 197.373Z"
                    fill="#E1E1E1" />
                <path
                    d="M1280.46 196.141C1280.48 196.209 1280.45 196.277 1280.39 196.296C1280.33 196.306 1280.28 196.267 1280.26 196.189C1280.24 196.122 1280.27 196.054 1280.32 196.034C1280.38 196.024 1280.44 196.063 1280.46 196.141Z"
                    fill="#E1E1E1" />
                <path
                    d="M1276.13 204.922C1276.13 205.756 1274.79 206.435 1273.14 206.435C1271.48 206.435 1270.15 205.756 1270.15 204.922C1270.15 204.087 1271.48 203.408 1273.14 203.408C1274.79 203.408 1276.13 204.087 1276.13 204.922Z"
                    fill="#FB5607" />
                <path
                    d="M1276.13 204.922C1276.13 205.756 1274.79 206.435 1273.14 206.435C1271.48 206.435 1270.15 205.756 1270.15 204.922C1270.15 204.087 1271.48 203.408 1273.14 203.408C1274.79 203.408 1276.13 204.087 1276.13 204.922Z"
                    fill="#FB5607" />
                <path
                    d="M1274.12 205.717C1274.15 205.785 1274.08 205.872 1273.98 205.911C1273.87 205.95 1273.78 205.921 1273.75 205.853C1273.72 205.785 1273.79 205.698 1273.88 205.659C1273.99 205.62 1274.09 205.649 1274.12 205.717Z"
                    fill="#E1E1E1" />
                <path
                    d="M1274.3 205.029C1274.33 205.096 1274.3 205.174 1274.22 205.213C1274.15 205.252 1274.06 205.223 1274.03 205.164C1274 205.096 1274.03 205.019 1274.11 204.98C1274.18 204.941 1274.27 204.97 1274.3 205.029Z"
                    fill="#E1E1E1" />
                <path
                    d="M1275.28 205.057C1275.33 205.116 1275.32 205.193 1275.27 205.251C1275.21 205.3 1275.12 205.3 1275.08 205.251C1275.03 205.193 1275.04 205.116 1275.08 205.057C1275.14 205.009 1275.23 205.009 1275.28 205.057Z"
                    fill="#E1E1E1" />
                <path
                    d="M1272.2 204.65C1272.23 204.718 1272.18 204.795 1272.11 204.825C1272.03 204.854 1271.96 204.825 1271.93 204.757C1271.9 204.689 1271.95 204.611 1272.01 204.582C1272.09 204.553 1272.17 204.582 1272.2 204.65Z"
                    fill="#E1E1E1" />
                <path
                    d="M1273.84 204.291C1273.86 204.359 1273.82 204.446 1273.73 204.475C1273.64 204.505 1273.55 204.475 1273.53 204.407C1273.5 204.34 1273.55 204.252 1273.63 204.223C1273.72 204.194 1273.81 204.223 1273.84 204.291Z"
                    fill="#E1E1E1" />
                <path
                    d="M1275.06 204.407C1275.08 204.475 1275.06 204.543 1274.99 204.563C1274.93 204.582 1274.87 204.534 1274.85 204.466C1274.83 204.398 1274.85 204.33 1274.92 204.31C1274.98 204.291 1275.04 204.34 1275.06 204.407Z"
                    fill="#E1E1E1" />
                <path
                    d="M1272.8 203.864C1272.83 203.932 1272.73 204.029 1272.6 204.087C1272.46 204.146 1272.32 204.126 1272.3 204.058C1272.27 203.99 1272.36 203.893 1272.5 203.835C1272.63 203.777 1272.77 203.796 1272.8 203.864Z"
                    fill="#E1E1E1" />
                <path
                    d="M1270.97 204.427C1270.99 204.495 1270.94 204.572 1270.85 204.592C1270.78 204.611 1270.69 204.572 1270.67 204.504C1270.65 204.436 1270.7 204.359 1270.78 204.339C1270.86 204.32 1270.95 204.359 1270.97 204.427Z"
                    fill="#E1E1E1" />
                <path
                    d="M1271.07 205.232C1271.09 205.3 1271.07 205.378 1270.99 205.417C1270.92 205.446 1270.83 205.417 1270.8 205.358C1270.78 205.29 1270.8 205.213 1270.88 205.174C1270.95 205.145 1271.04 205.174 1271.07 205.232Z"
                    fill="#E1E1E1" />
                <path
                    d="M1272.6 205.785C1272.62 205.853 1272.57 205.94 1272.47 205.979C1272.37 206.018 1272.28 205.989 1272.25 205.921C1272.22 205.853 1272.28 205.766 1272.37 205.727C1272.47 205.688 1272.57 205.717 1272.6 205.785Z"
                    fill="#E1E1E1" />
                <path
                    d="M1273.37 205.106C1273.39 205.174 1273.29 205.271 1273.14 205.319C1272.98 205.368 1272.85 205.358 1272.82 205.29C1272.8 205.222 1272.9 205.125 1273.05 205.077C1273.21 205.028 1273.34 205.038 1273.37 205.106Z"
                    fill="#E1E1E1" />
                <path
                    d="M1271.84 205.358C1271.87 205.426 1271.84 205.504 1271.78 205.533C1271.72 205.562 1271.65 205.533 1271.62 205.465C1271.59 205.397 1271.62 205.32 1271.68 205.291C1271.73 205.261 1271.81 205.291 1271.84 205.358Z"
                    fill="#E1E1E1" />
                <path
                    d="M1274.12 203.864C1274.14 203.932 1274.1 204.01 1274.03 204.019C1273.96 204.039 1273.89 203.99 1273.87 203.922C1273.86 203.854 1273.89 203.777 1273.96 203.767C1274.03 203.748 1274.1 203.796 1274.12 203.864Z"
                    fill="#E1E1E1" />
                <path
                    d="M1283.92 195.53C1285.28 195.53 1286.39 194.97 1286.39 194.279C1286.39 193.588 1285.28 193.027 1283.92 193.027C1282.55 193.027 1281.45 193.588 1281.45 194.279C1281.45 194.97 1282.55 195.53 1283.92 195.53Z"
                    fill="#FB5607" />
                <path
                    d="M1283.92 195.53C1285.28 195.53 1286.39 194.97 1286.39 194.279C1286.39 193.588 1285.28 193.027 1283.92 193.027C1282.55 193.027 1281.45 193.588 1281.45 194.279C1281.45 194.97 1282.55 195.53 1283.92 195.53Z"
                    fill="#FB5607" />
                <path
                    d="M1284.72 194.939C1284.75 195.006 1284.7 195.084 1284.62 195.123C1284.53 195.152 1284.44 195.123 1284.42 195.055C1284.39 194.987 1284.44 194.909 1284.53 194.871C1284.62 194.842 1284.7 194.871 1284.72 194.939Z"
                    fill="#E1E1E1" />
                <path
                    d="M1284.87 194.366C1284.9 194.434 1284.87 194.512 1284.81 194.541C1284.74 194.57 1284.67 194.541 1284.63 194.473C1284.61 194.405 1284.63 194.327 1284.69 194.298C1284.75 194.269 1284.83 194.298 1284.87 194.366Z"
                    fill="#E1E1E1" />
                <path
                    d="M1285.68 194.395C1285.73 194.453 1285.73 194.531 1285.68 194.57C1285.63 194.609 1285.55 194.599 1285.51 194.541C1285.46 194.482 1285.46 194.405 1285.51 194.366C1285.55 194.327 1285.63 194.337 1285.68 194.395Z"
                    fill="#E1E1E1" />
                <path
                    d="M1283.14 194.056C1283.17 194.124 1283.14 194.201 1283.08 194.221C1283.01 194.24 1282.94 194.211 1282.91 194.143C1282.88 194.075 1282.91 193.997 1282.98 193.978C1283.05 193.959 1283.11 193.988 1283.14 194.056Z"
                    fill="#E1E1E1" />
                <path
                    d="M1284.49 193.755C1284.52 193.823 1284.48 193.901 1284.41 193.93C1284.34 193.959 1284.26 193.93 1284.24 193.852C1284.21 193.784 1284.25 193.707 1284.31 193.678C1284.38 193.648 1284.47 193.678 1284.49 193.755Z"
                    fill="#E1E1E1" />
                <path
                    d="M1285.5 193.862C1285.52 193.93 1285.5 193.997 1285.45 194.017C1285.4 194.036 1285.35 193.988 1285.32 193.91C1285.3 193.842 1285.32 193.774 1285.37 193.755C1285.42 193.745 1285.47 193.784 1285.5 193.862Z"
                    fill="#E1E1E1" />
                <path
                    d="M1283.64 193.406C1283.67 193.474 1283.59 193.561 1283.48 193.609C1283.37 193.658 1283.26 193.638 1283.23 193.571C1283.2 193.503 1283.28 193.415 1283.39 193.367C1283.5 193.318 1283.61 193.338 1283.64 193.406Z"
                    fill="#E1E1E1" />
                <path
                    d="M1282.13 193.871C1282.15 193.939 1282.11 194.017 1282.04 194.027C1281.97 194.046 1281.9 193.997 1281.88 193.93C1281.86 193.862 1281.9 193.784 1281.97 193.774C1282.04 193.755 1282.11 193.803 1282.13 193.871Z"
                    fill="#E1E1E1" />
                <path
                    d="M1282.2 194.541C1282.23 194.609 1282.2 194.687 1282.16 194.706C1282.1 194.735 1282.02 194.706 1281.99 194.638C1281.96 194.57 1281.99 194.493 1282.04 194.473C1282.1 194.444 1282.17 194.473 1282.2 194.541Z"
                    fill="#E1E1E1" />
                <path
                    d="M1283.47 194.997C1283.5 195.065 1283.45 195.142 1283.38 195.181C1283.3 195.21 1283.21 195.181 1283.18 195.113C1283.15 195.045 1283.2 194.968 1283.28 194.929C1283.36 194.9 1283.44 194.929 1283.47 194.997Z"
                    fill="#E1E1E1" />
                <path
                    d="M1284.11 194.434C1284.13 194.502 1284.05 194.589 1283.93 194.638C1283.8 194.677 1283.69 194.657 1283.66 194.589C1283.64 194.521 1283.71 194.434 1283.84 194.386C1283.97 194.347 1284.08 194.366 1284.11 194.434Z"
                    fill="#E1E1E1" />
                <path
                    d="M1282.84 194.638C1282.87 194.706 1282.86 194.774 1282.8 194.803C1282.75 194.832 1282.69 194.793 1282.66 194.725C1282.63 194.657 1282.64 194.589 1282.7 194.56C1282.75 194.541 1282.81 194.57 1282.84 194.638Z"
                    fill="#E1E1E1" />
                <path
                    d="M1284.72 193.406C1284.74 193.473 1284.71 193.541 1284.65 193.561C1284.6 193.57 1284.54 193.532 1284.52 193.454C1284.5 193.376 1284.53 193.318 1284.59 193.299C1284.64 193.289 1284.7 193.328 1284.72 193.406Z"
                    fill="#E1E1E1" />
                <path
                    d="M1273.66 197.025C1275.03 197.025 1276.13 196.464 1276.13 195.773C1276.13 195.082 1275.03 194.521 1273.66 194.521C1272.3 194.521 1271.19 195.082 1271.19 195.773C1271.19 196.464 1272.3 197.025 1273.66 197.025Z"
                    fill="#FB5607" />
                <path
                    d="M1273.66 197.025C1275.03 197.025 1276.13 196.464 1276.13 195.773C1276.13 195.082 1275.03 194.521 1273.66 194.521C1272.3 194.521 1271.19 195.082 1271.19 195.773C1271.19 196.464 1272.3 197.025 1273.66 197.025Z"
                    fill="#FB5607" />
                <path
                    d="M1274.47 196.433C1274.49 196.501 1274.45 196.578 1274.36 196.617C1274.27 196.646 1274.18 196.617 1274.17 196.549C1274.14 196.481 1274.18 196.404 1274.27 196.365C1274.36 196.336 1274.45 196.365 1274.47 196.433Z"
                    fill="#E1E1E1" />
                <path
                    d="M1274.62 195.86C1274.65 195.928 1274.62 196.006 1274.56 196.035C1274.49 196.064 1274.43 196.035 1274.39 195.967C1274.36 195.899 1274.39 195.822 1274.45 195.792C1274.51 195.763 1274.58 195.792 1274.62 195.86Z"
                    fill="#E1E1E1" />
                <path
                    d="M1275.42 195.889C1275.47 195.948 1275.47 196.025 1275.42 196.064C1275.38 196.103 1275.3 196.093 1275.25 196.035C1275.2 195.977 1275.2 195.899 1275.25 195.86C1275.3 195.821 1275.38 195.831 1275.42 195.889Z"
                    fill="#E1E1E1" />
                <path
                    d="M1272.89 195.55C1272.92 195.618 1272.89 195.695 1272.82 195.715C1272.75 195.734 1272.68 195.705 1272.65 195.637C1272.62 195.569 1272.65 195.492 1272.72 195.472C1272.79 195.453 1272.86 195.482 1272.89 195.55Z"
                    fill="#E1E1E1" />
                <path
                    d="M1274.24 195.249C1274.27 195.317 1274.23 195.395 1274.16 195.424C1274.1 195.453 1274.01 195.424 1273.99 195.346C1273.96 195.278 1274 195.201 1274.07 195.172C1274.14 195.143 1274.22 195.172 1274.24 195.249Z"
                    fill="#E1E1E1" />
                <path
                    d="M1275.24 195.356C1275.26 195.424 1275.24 195.492 1275.19 195.511C1275.14 195.521 1275.09 195.482 1275.07 195.404C1275.05 195.336 1275.07 195.268 1275.11 195.249C1275.16 195.239 1275.21 195.278 1275.24 195.356Z"
                    fill="#E1E1E1" />
                <path
                    d="M1273.38 194.9C1273.41 194.968 1273.33 195.055 1273.23 195.103C1273.11 195.152 1273 195.133 1272.97 195.065C1272.94 194.997 1273.02 194.909 1273.13 194.861C1273.24 194.812 1273.35 194.832 1273.38 194.9Z"
                    fill="#E1E1E1" />
                <path
                    d="M1271.88 195.365C1271.9 195.433 1271.86 195.511 1271.79 195.521C1271.72 195.54 1271.66 195.492 1271.64 195.424C1271.62 195.356 1271.66 195.278 1271.72 195.268C1271.79 195.249 1271.86 195.298 1271.88 195.365Z"
                    fill="#E1E1E1" />
                <path
                    d="M1271.96 196.035C1271.99 196.103 1271.96 196.181 1271.91 196.2C1271.85 196.229 1271.77 196.2 1271.74 196.132C1271.71 196.064 1271.74 195.987 1271.79 195.967C1271.85 195.938 1271.93 195.967 1271.96 196.035Z"
                    fill="#E1E1E1" />
                <path
                    d="M1273.22 196.491C1273.24 196.559 1273.2 196.636 1273.12 196.675C1273.04 196.704 1272.95 196.675 1272.93 196.607C1272.9 196.539 1272.94 196.462 1273.02 196.423C1273.1 196.394 1273.19 196.423 1273.22 196.491Z"
                    fill="#E1E1E1" />
                <path
                    d="M1273.85 195.928C1273.87 195.996 1273.8 196.083 1273.67 196.132C1273.55 196.171 1273.43 196.151 1273.4 196.083C1273.38 196.015 1273.46 195.928 1273.58 195.88C1273.71 195.841 1273.83 195.86 1273.85 195.928Z"
                    fill="#E1E1E1" />
                <path
                    d="M1272.6 196.132C1272.62 196.2 1272.62 196.268 1272.56 196.297C1272.5 196.326 1272.44 196.287 1272.41 196.219C1272.38 196.151 1272.39 196.083 1272.45 196.054C1272.5 196.035 1272.57 196.064 1272.6 196.132Z"
                    fill="#E1E1E1" />
                <path
                    d="M1274.47 194.9C1274.48 194.968 1274.46 195.036 1274.4 195.055C1274.34 195.065 1274.28 195.026 1274.26 194.948C1274.24 194.88 1274.27 194.812 1274.33 194.793C1274.39 194.783 1274.45 194.822 1274.47 194.9Z"
                    fill="#E1E1E1" />
                <path
                    d="M1436.18 179.579C1436.18 179.656 1367.66 179.715 1283.14 179.715C1198.63 179.715 1130.1 179.656 1130.1 179.579C1130.1 179.501 1198.61 179.443 1283.14 179.443C1367.68 179.443 1436.18 179.501 1436.18 179.579Z"
                    fill="#1A2E35" />
                <path
                    d="M1332.74 145.351C1332.67 145.326 1325.14 179.964 1325.14 179.964H1339.51C1339.51 179.964 1344.32 154.715 1344.65 154.607L1332.74 145.351Z"
                    fill="#FFBF9D" />
                <path
                    d="M1365.09 67.4121C1369.6 66.736 1374.26 68.5556 1377.64 71.6271C1381.01 74.6986 1383.19 78.922 1384.46 83.3039C1385.72 87.6942 1386.14 92.2765 1386.45 96.8337C1386.95 104.396 1387.18 111.974 1387.1 119.553C1387.1 120.505 1387.07 121.489 1386.65 122.341C1386.03 123.551 1384.68 124.252 1383.33 124.419C1381.98 124.594 1380.62 124.319 1379.29 124.052"
                    fill="#1A2E35" />
                <path
                    d="M1359.1 68.9061C1355.66 68.397 1351.38 69.4236 1349.22 72.1529C1347.53 74.2729 1347.63 78.1708 1346.93 80.7833C1345.79 84.9649 1344.65 89.1715 1344.24 93.4867C1343.79 98.2276 1344.24 103.01 1344.69 107.751C1345.18 112.993 1345.67 118.234 1346.16 123.484C1346.38 125.813 1346.61 128.2 1347.56 130.337C1348.51 132.482 1350.32 134.376 1352.62 134.81C1354.73 135.203 1356.93 134.285 1358.46 132.791C1359.99 131.297 1360.94 129.293 1361.57 127.24"
                    fill="#1A2E35" />
                <path
                    d="M1346.34 117.675C1346.45 117.625 1346.33 117.007 1346.01 115.922C1345.7 114.837 1345.19 113.301 1344.64 111.39C1344.1 109.479 1343.52 107.192 1343.23 104.629C1342.93 102.067 1343.01 99.2541 1343.77 96.3828C1344.51 93.5033 1345.64 90.8324 1346.59 88.3451C1347.56 85.8578 1348.31 83.5208 1348.69 81.4926C1349.08 79.4644 1349.11 77.77 1348.98 76.6266C1348.86 75.4747 1348.63 74.8738 1348.52 74.8905C1348.23 74.9239 1348.52 77.4111 1347.44 81.2005C1346.93 83.0951 1346.09 85.2903 1345.04 87.7191C1344.02 90.1563 1342.8 92.8606 1342.01 95.9321C1341.81 96.7 1341.66 97.4762 1341.54 98.2441C1341.49 98.6281 1341.43 99.012 1341.4 99.396C1341.38 99.7799 1341.33 100.155 1341.33 100.531C1341.27 102.033 1341.36 103.486 1341.57 104.838C1341.97 107.551 1342.71 109.888 1343.43 111.791C1344.14 113.694 1344.84 115.179 1345.35 116.189C1345.87 117.199 1346.22 117.725 1346.34 117.675Z"
                    fill="#1A2E35" />
                <path
                    d="M1378.01 84.3805C1378.08 76.2092 1371.3 69.557 1362.9 69.7573C1354.98 69.9493 1348.69 76.5014 1348.43 84.297C1348.18 91.1245 1348.1 98.0021 1348.43 100.456C1349.39 107.859 1354.14 110.23 1356.03 110.881C1356.47 111.031 1357.62 111.123 1358.08 111.131C1358.08 111.131 1358.13 111.156 1358.13 111.181L1357.45 119.895C1357.35 125.562 1361.1 130.161 1366.86 130.303C1372.63 130.445 1376.57 125.638 1376.78 119.953L1378.02 84.3721L1378.01 84.3805Z"
                    fill="#FFBF9D" />
                <path
                    d="M1350.44 88.704C1350.58 88.8626 1351.52 88.2199 1352.82 88.2533C1354.12 88.27 1355.05 88.9544 1355.19 88.7959C1355.27 88.7291 1355.12 88.4453 1354.72 88.1365C1354.32 87.8277 1353.63 87.5272 1352.83 87.5105C1352.02 87.4938 1351.33 87.7692 1350.93 88.0614C1350.52 88.3535 1350.38 88.6289 1350.44 88.704Z"
                    fill="#1A2E35" />
                <path
                    d="M1362.47 89.1547C1362.62 89.3133 1363.56 88.6706 1364.85 88.704C1366.15 88.7207 1367.08 89.4051 1367.22 89.2465C1367.3 89.1798 1367.15 88.896 1366.75 88.5872C1366.35 88.2783 1365.67 87.9779 1364.86 87.9612C1364.05 87.9445 1363.36 88.2199 1362.96 88.512C1362.55 88.8042 1362.41 89.0796 1362.47 89.1547Z"
                    fill="#1A2E35" />
                <path
                    d="M1358.15 96.0158C1358.15 95.9406 1357.36 95.7821 1356.05 95.5901C1355.72 95.5483 1355.41 95.4732 1355.36 95.2479C1355.28 95.0142 1355.43 94.6636 1355.61 94.288C1355.94 93.5034 1356.29 92.6855 1356.67 91.8258C1358.13 88.3202 1359.21 85.4407 1359.07 85.3822C1358.93 85.3238 1357.62 88.1199 1356.15 91.6171C1355.8 92.4768 1355.46 93.3031 1355.13 94.096C1355 94.4633 1354.77 94.8806 1354.93 95.3731C1355.01 95.6151 1355.24 95.7987 1355.46 95.8655C1355.67 95.9323 1355.86 95.9406 1356.02 95.9573C1357.33 96.0575 1358.15 96.0825 1358.15 96.0158Z"
                    fill="#1A2E35" />
                <path
                    d="M1358.12 111.131C1358.12 111.131 1363.12 111.657 1369.49 108.11C1369.49 108.11 1367.32 114.578 1357.93 113.477L1358.12 111.131Z"
                    fill="#FF9A6C" />
                <path
                    d="M1358.61 99.1041C1359.09 98.5115 1359.92 98.1943 1360.73 98.3028C1361.29 98.3779 1361.86 98.6617 1362.18 99.1208C1362.51 99.5798 1362.57 100.223 1362.24 100.648C1361.87 101.124 1361.14 101.216 1360.52 101.032C1359.91 100.84 1359.39 100.431 1358.89 100.014C1358.76 99.897 1358.62 99.7801 1358.53 99.6299C1358.45 99.4797 1358.44 99.2793 1358.55 99.1541"
                    fill="#FF9A6C" />
                <path
                    d="M1361.94 96.9923C1361.73 96.9756 1361.68 98.3612 1360.45 99.3127C1359.22 100.273 1357.72 100.081 1357.7 100.273C1357.68 100.356 1358.03 100.548 1358.66 100.581C1359.28 100.615 1360.19 100.448 1360.95 99.8635C1361.7 99.2793 1362.04 98.478 1362.11 97.9105C1362.18 97.3345 1362.03 96.984 1361.93 96.9923H1361.94Z"
                    fill="#1A2E35" />
                <path
                    d="M1362.62 84.4062C1362.74 84.7567 1364.04 84.6232 1365.56 84.8402C1367.08 85.0322 1368.29 85.4996 1368.51 85.1908C1368.6 85.0405 1368.4 84.715 1367.91 84.3644C1367.42 84.0139 1366.65 83.68 1365.74 83.5548C1364.83 83.4296 1363.99 83.5548 1363.42 83.7635C1362.86 83.9722 1362.57 84.2392 1362.62 84.4062H1362.62Z"
                    fill="#1A2E35" />
                <path
                    d="M1350.95 82.8035C1351.17 83.0956 1352.08 82.8202 1353.15 82.8369C1354.23 82.8119 1355.13 83.0789 1355.35 82.7868C1355.45 82.6449 1355.31 82.3444 1354.93 82.0607C1354.54 81.7769 1353.89 81.5348 1353.15 81.5432C1352.41 81.5432 1351.76 81.7936 1351.38 82.0857C1350.99 82.3778 1350.86 82.67 1350.96 82.8119L1350.95 82.8035Z"
                    fill="#1A2E35" />
                <path
                    d="M1345.21 118.927C1344.52 119.103 1338.99 119.795 1335.2 127.399C1331.4 135.003 1325.89 151.429 1325.89 151.429L1344.06 159.967L1345.21 118.936V118.927Z"
                    fill="#FB5607" />
                <path
                    d="M1345.21 118.927C1344.52 119.103 1338.99 119.795 1335.2 127.399C1331.4 135.003 1325.89 151.429 1325.89 151.429L1344.06 159.967L1345.21 118.936V118.927Z"
                    fill="#FB5607" />
                <path
                    d="M1357.56 116.448L1345.21 119.353L1339.52 151.679L1343.52 159.992L1341.32 180.4H1392.34L1394 120.254L1381.96 116.765L1378.57 120.346C1372.29 126.99 1361.27 125.045 1357.64 116.649L1357.56 116.457V116.448Z"
                    fill="#FB5607" />
                <path
                    d="M1357.56 116.448L1345.21 119.353L1339.52 151.679L1343.52 159.992L1341.32 180.4H1392.34L1394 120.254L1381.96 116.765L1378.57 120.346C1372.29 126.99 1361.27 125.045 1357.64 116.649L1357.56 116.457V116.448Z"
                    fill="#FB5607" />
                <path
                    d="M1393.84 120.196C1393.84 120.196 1401.11 123.585 1401.99 135.32C1402.78 145.937 1403.91 150.043 1403.91 150.043H1384.46C1384.46 150.043 1383.47 131.973 1388.12 126.147C1388.5 125.663 1393.84 120.188 1393.84 120.188V120.196Z"
                    fill="#FB5607" />
                <path
                    d="M1393.84 120.196C1393.84 120.196 1401.11 123.585 1401.99 135.32C1402.78 145.937 1403.91 150.043 1403.91 150.043H1384.46C1384.46 150.043 1383.47 131.973 1388.12 126.147C1388.5 125.663 1393.84 120.188 1393.84 120.188V120.196Z"
                    fill="#FB5607" />
                <path
                    d="M1351.11 140.712C1351.11 140.712 1351.15 140.712 1351.24 140.703L1351.63 140.687C1351.98 140.678 1352.48 140.653 1353.13 140.637C1354.44 140.595 1356.37 140.545 1358.8 140.47C1363.69 140.336 1370.64 140.153 1378.95 139.936H1379.06L1379.05 140.044C1378.64 143.633 1378.21 147.514 1377.75 151.604C1377.51 153.649 1377.28 155.744 1377.04 157.889C1376.91 158.957 1376.8 160.042 1376.67 161.127C1376.61 161.67 1376.55 162.221 1376.49 162.772C1376.43 163.323 1376.36 163.882 1376.17 164.424C1376.06 164.75 1375.91 165.067 1375.68 165.334C1375.46 165.601 1375.15 165.81 1374.81 165.91C1374.14 166.119 1373.46 166.002 1372.82 165.968C1371.52 165.877 1370.22 165.785 1368.95 165.693C1366.4 165.509 1363.91 165.334 1361.5 165.159C1356.68 164.808 1352.15 164.483 1348.04 164.182H1347.94L1347.96 164.074C1348.9 157.038 1349.68 151.195 1350.23 147.114C1350.51 145.077 1350.73 143.483 1350.88 142.389L1351.06 141.146C1351.1 140.862 1351.13 140.72 1351.13 140.72C1351.13 140.72 1351.12 140.87 1351.08 141.146C1351.05 141.438 1351 141.855 1350.93 142.389C1350.79 143.491 1350.59 145.085 1350.33 147.122C1349.81 151.212 1349.05 157.054 1348.14 164.099L1348.06 163.99C1352.17 164.282 1356.69 164.6 1361.52 164.942C1363.94 165.117 1366.42 165.292 1368.97 165.468C1370.25 165.559 1371.54 165.651 1372.84 165.743C1373.49 165.785 1374.16 165.885 1374.76 165.693C1375.36 165.509 1375.77 164.959 1375.96 164.349C1376.14 163.832 1376.21 163.289 1376.26 162.738C1376.32 162.187 1376.39 161.645 1376.45 161.094C1376.57 160.001 1376.7 158.924 1376.81 157.856C1377.06 155.719 1377.3 153.616 1377.53 151.571C1378 147.481 1378.44 143.608 1378.86 140.019L1378.96 140.128C1370.66 140.311 1363.7 140.47 1358.81 140.578C1356.38 140.628 1354.45 140.662 1353.13 140.687C1352.48 140.695 1351.98 140.703 1351.63 140.712H1351.25C1351.17 140.712 1351.12 140.712 1351.12 140.712H1351.11Z"
                    fill="#FB5607" />
                <path
                    d="M1351.11 140.712C1351.11 140.712 1351.15 140.712 1351.24 140.703L1351.63 140.687C1351.98 140.678 1352.48 140.653 1353.13 140.637C1354.44 140.595 1356.37 140.545 1358.8 140.47C1363.69 140.336 1370.64 140.153 1378.95 139.936H1379.06L1379.05 140.044C1378.64 143.633 1378.21 147.514 1377.75 151.604C1377.51 153.649 1377.28 155.744 1377.04 157.889C1376.91 158.957 1376.8 160.042 1376.67 161.127C1376.61 161.67 1376.55 162.221 1376.49 162.772C1376.43 163.323 1376.36 163.882 1376.17 164.424C1376.06 164.75 1375.91 165.067 1375.68 165.334C1375.46 165.601 1375.15 165.81 1374.81 165.91C1374.14 166.119 1373.46 166.002 1372.82 165.968C1371.52 165.877 1370.22 165.785 1368.95 165.693C1366.4 165.509 1363.91 165.334 1361.5 165.159C1356.68 164.808 1352.15 164.483 1348.04 164.182H1347.94L1347.96 164.074C1348.9 157.038 1349.68 151.195 1350.23 147.114C1350.51 145.077 1350.73 143.483 1350.88 142.389L1351.06 141.146C1351.1 140.862 1351.13 140.72 1351.13 140.72C1351.13 140.72 1351.12 140.87 1351.08 141.146C1351.05 141.438 1351 141.855 1350.93 142.389C1350.79 143.491 1350.59 145.085 1350.33 147.122C1349.81 151.212 1349.05 157.054 1348.14 164.099L1348.06 163.99C1352.17 164.282 1356.69 164.6 1361.52 164.942C1363.94 165.117 1366.42 165.292 1368.97 165.468C1370.25 165.559 1371.54 165.651 1372.84 165.743C1373.49 165.785 1374.16 165.885 1374.76 165.693C1375.36 165.509 1375.77 164.959 1375.96 164.349C1376.14 163.832 1376.21 163.289 1376.26 162.738C1376.32 162.187 1376.39 161.645 1376.45 161.094C1376.57 160.001 1376.7 158.924 1376.81 157.856C1377.06 155.719 1377.3 153.616 1377.53 151.571C1378 147.481 1378.44 143.608 1378.86 140.019L1378.96 140.128C1370.66 140.311 1363.7 140.47 1358.81 140.578C1356.38 140.628 1354.45 140.662 1353.13 140.687C1352.48 140.695 1351.98 140.703 1351.63 140.712H1351.25C1351.17 140.712 1351.12 140.712 1351.12 140.712H1351.11Z"
                    fill="#FB5607" />
                <path
                    d="M1354.27 140.695C1354.33 140.695 1353.79 146.037 1353.06 152.605C1352.33 159.174 1351.68 164.499 1351.63 164.491C1351.57 164.491 1352.1 159.149 1352.83 152.58C1353.57 146.012 1354.21 140.686 1354.27 140.695Z"
                    fill="#FB5607" />
                <path
                    d="M1354.27 140.695C1354.33 140.695 1353.79 146.037 1353.06 152.605C1352.33 159.174 1351.68 164.499 1351.63 164.491C1351.57 164.491 1352.1 159.149 1352.83 152.58C1353.57 146.012 1354.21 140.686 1354.27 140.695Z"
                    fill="#FB5607" />
                <path
                    d="M1357.73 140.403C1357.78 140.403 1357.25 145.745 1356.52 152.313C1355.78 158.882 1355.14 164.207 1355.08 164.199C1355.03 164.199 1355.56 158.857 1356.29 152.288C1357.03 145.72 1357.67 140.394 1357.73 140.403Z"
                    fill="#FB5607" />
                <path
                    d="M1357.73 140.403C1357.78 140.403 1357.25 145.745 1356.52 152.313C1355.78 158.882 1355.14 164.207 1355.08 164.199C1355.03 164.199 1355.56 158.857 1356.29 152.288C1357.03 145.72 1357.67 140.394 1357.73 140.403Z"
                    fill="#FB5607" />
                <path
                    d="M1361.17 140.695C1361.23 140.695 1360.7 146.037 1359.97 152.605C1359.23 159.174 1358.59 164.499 1358.53 164.491C1358.48 164.491 1359.01 159.149 1359.74 152.58C1360.48 146.012 1361.12 140.686 1361.17 140.695Z"
                    fill="#FB5607" />
                <path
                    d="M1361.17 140.695C1361.23 140.695 1360.7 146.037 1359.97 152.605C1359.23 159.174 1358.59 164.499 1358.53 164.491C1358.48 164.491 1359.01 159.149 1359.74 152.58C1360.48 146.012 1361.12 140.686 1361.17 140.695Z"
                    fill="#FB5607" />
                <path
                    d="M1364.63 140.695C1364.69 140.695 1364.16 146.037 1363.42 152.605C1362.69 159.174 1362.05 164.499 1361.99 164.491C1361.93 164.491 1362.47 159.149 1363.2 152.58C1363.93 146.012 1364.57 140.686 1364.63 140.695Z"
                    fill="#FB5607" />
                <path
                    d="M1364.63 140.695C1364.69 140.695 1364.16 146.037 1363.42 152.605C1362.69 159.174 1362.05 164.499 1361.99 164.491C1361.93 164.491 1362.47 159.149 1363.2 152.58C1363.93 146.012 1364.57 140.686 1364.63 140.695Z"
                    fill="#FB5607" />
                <path
                    d="M1368.4 140.403C1368.46 140.403 1367.92 145.745 1367.19 152.313C1366.46 158.882 1365.82 164.207 1365.76 164.199C1365.7 164.191 1366.23 158.857 1366.97 152.288C1367.7 145.72 1368.34 140.394 1368.4 140.403Z"
                    fill="#FB5607" />
                <path
                    d="M1368.4 140.403C1368.46 140.403 1367.92 145.745 1367.19 152.313C1366.46 158.882 1365.82 164.207 1365.76 164.199C1365.7 164.191 1366.23 158.857 1366.97 152.288C1367.7 145.72 1368.34 140.394 1368.4 140.403Z"
                    fill="#FB5607" />
                <path
                    d="M1371.88 140.403C1371.94 140.403 1371.41 145.745 1370.67 152.313C1369.94 158.882 1369.3 164.207 1369.24 164.199C1369.18 164.199 1369.72 158.857 1370.45 152.288C1371.18 145.72 1371.82 140.394 1371.88 140.403Z"
                    fill="#FB5607" />
                <path
                    d="M1371.88 140.403C1371.94 140.403 1371.41 145.745 1370.67 152.313C1369.94 158.882 1369.3 164.207 1369.24 164.199C1369.18 164.199 1369.72 158.857 1370.45 152.288C1371.18 145.72 1371.82 140.394 1371.88 140.403Z"
                    fill="#FB5607" />
                <path
                    d="M1374.77 140.878C1374.83 140.878 1374.3 146.22 1373.56 152.789C1372.83 159.358 1372.19 164.683 1372.13 164.674C1372.07 164.674 1372.61 159.333 1373.34 152.764C1374.07 146.195 1374.71 140.87 1374.77 140.878Z"
                    fill="#FB5607" />
                <path
                    d="M1374.77 140.878C1374.83 140.878 1374.3 146.22 1373.56 152.789C1372.83 159.358 1372.19 164.683 1372.13 164.674C1372.07 164.674 1372.61 159.333 1373.34 152.764C1374.07 146.195 1374.71 140.87 1374.77 140.878Z"
                    fill="#FB5607" />
                <path
                    d="M1344.01 160.293C1344.01 160.293 1343.85 160.109 1343.59 159.759C1343.47 159.583 1343.31 159.366 1343.15 159.099C1342.99 158.841 1342.79 158.54 1342.6 158.198C1342.21 157.522 1341.79 156.696 1341.38 155.752C1340.98 154.801 1340.59 153.732 1340.28 152.581C1339.97 151.429 1339.76 150.31 1339.63 149.292C1339.5 148.266 1339.44 147.339 1339.44 146.563C1339.43 146.171 1339.45 145.82 1339.46 145.511C1339.46 145.202 1339.49 144.935 1339.51 144.718C1339.55 144.284 1339.58 144.042 1339.59 144.051C1339.61 144.051 1339.61 144.293 1339.59 144.727C1339.59 144.944 1339.58 145.211 1339.59 145.519C1339.59 145.828 1339.59 146.179 1339.6 146.563C1339.62 147.339 1339.69 148.257 1339.83 149.275C1339.98 150.285 1340.19 151.395 1340.49 152.539C1340.8 153.674 1341.18 154.734 1341.56 155.686C1341.96 156.629 1342.36 157.463 1342.74 158.139C1342.91 158.482 1343.09 158.782 1343.25 159.049C1343.4 159.316 1343.54 159.542 1343.66 159.725C1343.89 160.093 1344.01 160.301 1344 160.31L1344.01 160.293Z"
                    fill="#1A2E35" />
                <path
                    d="M1392 121.323C1392 121.323 1391.9 121.373 1391.71 121.456C1391.52 121.54 1391.23 121.648 1390.88 121.832C1390.17 122.182 1389.18 122.792 1388.16 123.776C1387.65 124.269 1387.15 124.862 1386.68 125.554C1386.21 126.239 1385.77 127.023 1385.43 127.891C1385.09 128.759 1384.82 129.711 1384.69 130.721C1384.56 131.731 1384.53 132.799 1384.5 133.884C1384.38 138.241 1384.44 142.181 1384.45 145.043C1384.45 146.454 1384.46 147.598 1384.46 148.424C1384.46 148.808 1384.46 149.108 1384.46 149.342C1384.46 149.551 1384.46 149.659 1384.45 149.659C1384.45 149.659 1384.43 149.551 1384.42 149.342L1384.39 148.424C1384.36 147.598 1384.34 146.454 1384.3 145.043C1384.25 142.189 1384.16 138.241 1384.28 133.876C1384.31 132.782 1384.36 131.722 1384.48 130.696C1384.61 129.669 1384.89 128.701 1385.25 127.816C1385.6 126.931 1386.05 126.147 1386.54 125.446C1387.01 124.745 1387.55 124.16 1388.06 123.66C1389.1 122.666 1390.13 122.074 1390.85 121.748C1391.21 121.573 1391.51 121.473 1391.71 121.406C1391.91 121.339 1392.02 121.306 1392.02 121.314L1392 121.323Z"
                    fill="#1A2E35" />
                <path
                    d="M1369 79.4813C1371.62 85.4741 1371.51 92.2933 1370.83 98.7952C1370.17 105.306 1368.98 111.833 1369.62 118.343C1369.87 120.905 1370.4 123.509 1369.82 126.022C1369.49 127.499 1368.79 128.868 1368.38 130.32C1367.97 131.781 1367.91 133.442 1368.75 134.702C1369.6 135.962 1371.26 136.53 1372.76 136.355C1374.27 136.171 1375.65 135.353 1376.77 134.326C1379.23 132.081 1380.66 128.885 1381.32 125.629C1381.99 122.374 1381.98 119.011 1381.96 115.68C1381.91 107.025 1381.86 98.3612 1381.82 89.7058C1381.8 85.9582 1381.76 82.1272 1380.49 78.6133C1379.16 74.9408 1376.51 71.8192 1373.3 69.6073C1369.45 66.9531 1364.33 65.576 1360.06 67.4623C1358.63 68.0966 1357.22 69.3903 1357.44 70.9344C1357.62 72.153 1358.74 72.9793 1359.77 73.6554C1363.17 75.9006 1366.56 78.1459 1369.94 80.3827"
                    fill="#1A2E35" />
                <path
                    d="M1371.24 126.381C1371.36 126.331 1371.18 125.646 1370.81 124.444C1370.44 123.242 1369.87 121.515 1369.32 119.37C1368.77 117.224 1368.26 114.629 1368.21 111.749C1368.13 108.87 1368.72 105.723 1369.54 102.418C1370.37 99.1124 1371.27 95.9241 1371.67 92.8859C1372.08 89.8561 1371.99 87.0517 1371.48 84.7731C1370.97 82.4861 1370.09 80.7667 1369.31 79.7317C1369.11 79.473 1368.92 79.256 1368.77 79.064C1368.6 78.8804 1368.44 78.7385 1368.32 78.6217C1368.06 78.3963 1367.91 78.2961 1367.86 78.3379C1367.81 78.3796 1367.87 78.5549 1368.03 78.847C1368.12 78.9889 1368.22 79.1642 1368.33 79.3728C1368.44 79.5899 1368.57 79.8319 1368.72 80.099C1369.27 81.184 1369.92 82.8534 1370.23 84.9984C1370.55 87.1518 1370.51 89.7726 1370.03 92.6355C1369.57 95.4984 1368.62 98.62 1367.79 101.975C1366.96 105.331 1366.37 108.694 1366.55 111.791C1366.7 114.871 1367.38 117.558 1368.1 119.72C1368.83 121.89 1369.59 123.568 1370.17 124.703C1370.74 125.838 1371.13 126.422 1371.25 126.372L1371.24 126.381Z"
                    fill="#1A2E35" />
                <path
                    d="M1384.74 83.9799C1384.74 83.9799 1384.65 83.9298 1384.47 83.8547C1384.28 83.7796 1384.01 83.6711 1383.68 83.5375C1383.34 83.404 1382.91 83.2371 1382.44 83.0367C1381.96 82.8364 1381.41 82.6111 1380.81 82.344C1379.6 81.8181 1378.18 81.1504 1376.63 80.3575C1375.09 79.5562 1373.41 78.6298 1371.7 77.5781C1369.99 76.5181 1368.41 75.4414 1367 74.4231C1365.6 73.3965 1364.36 72.4283 1363.35 71.5853C1362.83 71.1763 1362.39 70.7757 1361.99 70.4334C1361.59 70.0996 1361.26 69.7908 1360.98 69.5487C1360.72 69.315 1360.51 69.123 1360.35 68.9895C1360.2 68.8643 1360.12 68.7975 1360.12 68.8059C1360.12 68.8059 1360.18 68.881 1360.32 69.0229C1360.47 69.1648 1360.68 69.3651 1360.94 69.6071C1361.21 69.8659 1361.53 70.1747 1361.93 70.5169C1362.32 70.8675 1362.77 71.2681 1363.27 71.6854C1364.27 72.5451 1365.51 73.5217 1366.91 74.565C1368.32 75.5916 1369.9 76.6767 1371.61 77.745C1373.32 78.7967 1375.01 79.7232 1376.56 80.5244C1378.11 81.309 1379.54 81.9684 1380.76 82.4775C1381.36 82.7446 1381.91 82.9533 1382.41 83.1536C1382.89 83.3539 1383.31 83.5042 1383.66 83.6293L1384.46 83.9131C1384.65 83.9799 1384.75 84.0049 1384.75 83.9966L1384.74 83.9799Z"
                    fill="#FB5607" />
                <path
                    d="M1384.74 83.9799C1384.74 83.9799 1384.65 83.9298 1384.47 83.8547C1384.28 83.7796 1384.01 83.6711 1383.68 83.5375C1383.34 83.404 1382.91 83.2371 1382.44 83.0367C1381.96 82.8364 1381.41 82.6111 1380.81 82.344C1379.6 81.8181 1378.18 81.1504 1376.63 80.3575C1375.09 79.5562 1373.41 78.6298 1371.7 77.5781C1369.99 76.5181 1368.41 75.4414 1367 74.4231C1365.6 73.3965 1364.36 72.4283 1363.35 71.5853C1362.83 71.1763 1362.39 70.7757 1361.99 70.4334C1361.59 70.0996 1361.26 69.7908 1360.98 69.5487C1360.72 69.315 1360.51 69.123 1360.35 68.9895C1360.2 68.8643 1360.12 68.7975 1360.12 68.8059C1360.12 68.8059 1360.18 68.881 1360.32 69.0229C1360.47 69.1648 1360.68 69.3651 1360.94 69.6071C1361.21 69.8659 1361.53 70.1747 1361.93 70.5169C1362.32 70.8675 1362.77 71.2681 1363.27 71.6854C1364.27 72.5451 1365.51 73.5217 1366.91 74.565C1368.32 75.5916 1369.9 76.6767 1371.61 77.745C1373.32 78.7967 1375.01 79.7232 1376.56 80.5244C1378.11 81.309 1379.54 81.9684 1380.76 82.4775C1381.36 82.7446 1381.91 82.9533 1382.41 83.1536C1382.89 83.3539 1383.31 83.5042 1383.66 83.6293L1384.46 83.9131C1384.65 83.9799 1384.75 84.0049 1384.75 83.9966L1384.74 83.9799Z"
                    fill="#FB5607" />
                <path
                    d="M1384.72 85.2737C1384.72 85.2737 1384.62 85.2403 1384.43 85.1986C1384.22 85.1568 1383.94 85.0901 1383.59 85.0149C1383.41 84.9732 1383.2 84.9315 1382.98 84.8897C1382.76 84.8313 1382.51 84.7729 1382.26 84.7061C1381.75 84.5726 1381.16 84.439 1380.51 84.2387L1379.51 83.9382C1379.16 83.8297 1378.8 83.6962 1378.42 83.571C1377.67 83.3289 1376.89 83.0034 1376.06 82.6862C1374.43 82.0018 1372.66 81.1588 1370.89 80.1405C1369.12 79.1056 1367.51 78.0038 1366.1 76.9271C1365.41 76.3762 1364.74 75.8588 1364.15 75.3329C1363.85 75.0742 1363.56 74.8321 1363.29 74.5817L1362.52 73.8556C1362.02 73.4049 1361.62 72.9542 1361.24 72.5786L1360.72 72.0444L1360.31 71.577L1359.72 70.9343C1359.59 70.7924 1359.52 70.7173 1359.51 70.7173C1359.51 70.7173 1359.57 70.8008 1359.69 70.9593L1360.25 71.6271L1360.66 72.1028C1360.81 72.2781 1360.98 72.4534 1361.17 72.6453C1361.53 73.0293 1361.94 73.4883 1362.43 73.9474C1362.67 74.1811 1362.93 74.4232 1363.19 74.6819C1363.46 74.9323 1363.75 75.1827 1364.05 75.4498C1364.63 75.984 1365.3 76.5098 1365.99 77.069C1367.41 78.1541 1369.02 79.2725 1370.79 80.3075C1372.57 81.3258 1374.35 82.1688 1375.99 82.8532C1376.82 83.1703 1377.61 83.4875 1378.36 83.7296C1378.73 83.8548 1379.09 83.9883 1379.45 84.0885C1379.8 84.1886 1380.14 84.2888 1380.46 84.3806C1381.11 84.5809 1381.71 84.6978 1382.22 84.8313C1382.48 84.8897 1382.72 84.9482 1382.95 84.9982L1383.56 85.1151C1383.92 85.1819 1384.21 85.2319 1384.41 85.2653C1384.61 85.2987 1384.71 85.3154 1384.71 85.3071L1384.72 85.2737Z"
                    fill="#FB5607" />
                <path
                    d="M1384.72 85.2737C1384.72 85.2737 1384.62 85.2403 1384.43 85.1986C1384.22 85.1568 1383.94 85.0901 1383.59 85.0149C1383.41 84.9732 1383.2 84.9315 1382.98 84.8897C1382.76 84.8313 1382.51 84.7729 1382.26 84.7061C1381.75 84.5726 1381.16 84.439 1380.51 84.2387L1379.51 83.9382C1379.16 83.8297 1378.8 83.6962 1378.42 83.571C1377.67 83.3289 1376.89 83.0034 1376.06 82.6862C1374.43 82.0018 1372.66 81.1588 1370.89 80.1405C1369.12 79.1056 1367.51 78.0038 1366.1 76.9271C1365.41 76.3762 1364.74 75.8588 1364.15 75.3329C1363.85 75.0742 1363.56 74.8321 1363.29 74.5817L1362.52 73.8556C1362.02 73.4049 1361.62 72.9542 1361.24 72.5786L1360.72 72.0444L1360.31 71.577L1359.72 70.9343C1359.59 70.7924 1359.52 70.7173 1359.51 70.7173C1359.51 70.7173 1359.57 70.8008 1359.69 70.9593L1360.25 71.6271L1360.66 72.1028C1360.81 72.2781 1360.98 72.4534 1361.17 72.6453C1361.53 73.0293 1361.94 73.4883 1362.43 73.9474C1362.67 74.1811 1362.93 74.4232 1363.19 74.6819C1363.46 74.9323 1363.75 75.1827 1364.05 75.4498C1364.63 75.984 1365.3 76.5098 1365.99 77.069C1367.41 78.1541 1369.02 79.2725 1370.79 80.3075C1372.57 81.3258 1374.35 82.1688 1375.99 82.8532C1376.82 83.1703 1377.61 83.4875 1378.36 83.7296C1378.73 83.8548 1379.09 83.9883 1379.45 84.0885C1379.8 84.1886 1380.14 84.2888 1380.46 84.3806C1381.11 84.5809 1381.71 84.6978 1382.22 84.8313C1382.48 84.8897 1382.72 84.9482 1382.95 84.9982L1383.56 85.1151C1383.92 85.1819 1384.21 85.2319 1384.41 85.2653C1384.61 85.2987 1384.71 85.3154 1384.71 85.3071L1384.72 85.2737Z"
                    fill="#FB5607" />
                <path
                    d="M1376.61 130.395C1376.61 130.395 1376.63 130.354 1376.65 130.278L1376.72 129.936C1376.79 129.636 1376.89 129.185 1376.99 128.601C1377.2 127.441 1377.44 125.738 1377.58 123.626C1377.73 121.515 1377.76 118.994 1377.69 116.198C1377.61 113.402 1377.45 110.33 1377.3 107.108C1376.97 100.665 1376.68 94.839 1376.47 90.6073C1376.36 88.5039 1376.26 86.8012 1376.21 85.6077L1376.12 84.2472L1376.1 83.8966C1376.1 83.8132 1376.09 83.7798 1376.08 83.7798C1376.08 83.7798 1376.08 83.8215 1376.08 83.8966V84.2472C1376.1 84.5727 1376.11 85.0234 1376.14 85.6077C1376.19 86.8012 1376.26 88.5039 1376.36 90.6073C1376.56 94.839 1376.82 100.673 1377.13 107.108C1377.28 110.33 1377.46 113.402 1377.54 116.189C1377.62 118.986 1377.6 121.498 1377.46 123.61C1377.34 125.721 1377.11 127.416 1376.93 128.584C1376.85 129.168 1376.76 129.619 1376.7 129.928L1376.64 130.278C1376.62 130.354 1376.62 130.395 1376.62 130.395H1376.61Z"
                    fill="#FB5607" />
                <path
                    d="M1376.61 130.395C1376.61 130.395 1376.63 130.354 1376.65 130.278L1376.72 129.936C1376.79 129.636 1376.89 129.185 1376.99 128.601C1377.2 127.441 1377.44 125.738 1377.58 123.626C1377.73 121.515 1377.76 118.994 1377.69 116.198C1377.61 113.402 1377.45 110.33 1377.3 107.108C1376.97 100.665 1376.68 94.839 1376.47 90.6073C1376.36 88.5039 1376.26 86.8012 1376.21 85.6077L1376.12 84.2472L1376.1 83.8966C1376.1 83.8132 1376.09 83.7798 1376.08 83.7798C1376.08 83.7798 1376.08 83.8215 1376.08 83.8966V84.2472C1376.1 84.5727 1376.11 85.0234 1376.14 85.6077C1376.19 86.8012 1376.26 88.5039 1376.36 90.6073C1376.56 94.839 1376.82 100.673 1377.13 107.108C1377.28 110.33 1377.46 113.402 1377.54 116.189C1377.62 118.986 1377.6 121.498 1377.46 123.61C1377.34 125.721 1377.11 127.416 1376.93 128.584C1376.85 129.168 1376.76 129.619 1376.7 129.928L1376.64 130.278C1376.62 130.354 1376.62 130.395 1376.62 130.395H1376.61Z"
                    fill="#FB5607" />
                <path
                    d="M1373.36 110.831C1373.36 110.831 1373.39 110.731 1373.41 110.539C1373.44 110.33 1373.48 110.055 1373.52 109.704C1373.61 108.978 1373.73 107.935 1373.86 106.633C1374.13 104.037 1374.44 100.448 1374.65 96.475C1374.86 92.502 1374.93 88.8963 1374.93 86.2922C1374.93 84.9901 1374.93 83.9301 1374.91 83.204L1374.89 82.361C1374.89 82.169 1374.87 82.0688 1374.87 82.0688C1374.87 82.0688 1374.86 82.169 1374.86 82.361C1374.86 82.5696 1374.86 82.8451 1374.84 83.204C1374.83 83.9468 1374.81 84.9985 1374.81 86.2922C1374.76 88.8963 1374.67 92.4937 1374.46 96.4666C1374.26 100.44 1373.97 104.02 1373.73 106.616C1373.61 107.901 1373.51 108.945 1373.45 109.688C1373.41 110.038 1373.39 110.314 1373.37 110.522C1373.36 110.714 1373.36 110.814 1373.36 110.814L1373.36 110.831Z"
                    fill="#FB5607" />
                <path
                    d="M1373.36 110.831C1373.36 110.831 1373.39 110.731 1373.41 110.539C1373.44 110.33 1373.48 110.055 1373.52 109.704C1373.61 108.978 1373.73 107.935 1373.86 106.633C1374.13 104.037 1374.44 100.448 1374.65 96.475C1374.86 92.502 1374.93 88.8963 1374.93 86.2922C1374.93 84.9901 1374.93 83.9301 1374.91 83.204L1374.89 82.361C1374.89 82.169 1374.87 82.0688 1374.87 82.0688C1374.87 82.0688 1374.86 82.169 1374.86 82.361C1374.86 82.5696 1374.86 82.8451 1374.84 83.204C1374.83 83.9468 1374.81 84.9985 1374.81 86.2922C1374.76 88.8963 1374.67 92.4937 1374.46 96.4666C1374.26 100.44 1373.97 104.02 1373.73 106.616C1373.61 107.901 1373.51 108.945 1373.45 109.688C1373.41 110.038 1373.39 110.314 1373.37 110.522C1373.36 110.714 1373.36 110.814 1373.36 110.814L1373.36 110.831Z"
                    fill="#FB5607" />
                <path
                    d="M1346.58 129.443C1346.58 129.443 1347.58 127.24 1349.93 126.53C1352.29 125.821 1351.4 124.995 1352.47 123.693C1353.53 122.391 1354.84 121.013 1354.84 121.013L1357.31 119.736C1357.31 119.736 1359.8 121.389 1360.56 122.566C1361.32 123.743 1362.39 126.172 1363.42 126.939C1364.44 127.707 1368.31 129.368 1368.27 131.104L1356.8 132.073L1346.59 129.435L1346.58 129.443Z"
                    fill="#FB5607" />
                <path
                    d="M1346.58 129.443C1346.58 129.443 1347.58 127.24 1349.93 126.53C1352.29 125.821 1351.4 124.995 1352.47 123.693C1353.53 122.391 1354.84 121.013 1354.84 121.013L1357.31 119.736C1357.31 119.736 1359.8 121.389 1360.56 122.566C1361.32 123.743 1362.39 126.172 1363.42 126.939C1364.44 127.707 1368.31 129.368 1368.27 131.104L1356.8 132.073L1346.59 129.435L1346.58 129.443Z"
                    fill="#FB5607" />
                <g opacity="0.3">
                    <path
                        d="M1346.58 129.443C1346.58 129.443 1347.58 127.239 1349.93 126.53C1352.29 125.82 1351.4 124.994 1352.47 123.692C1353.53 122.39 1354.84 121.013 1354.84 121.013L1357.31 119.736C1357.31 119.736 1359.8 121.388 1360.56 122.565C1361.32 123.742 1362.39 126.171 1363.42 126.939C1364.44 127.707 1368.31 129.368 1368.27 131.104L1356.8 132.072L1346.59 129.435L1346.58 129.443Z"
                        fill="black" fill-opacity="0.46" />
                </g>
                <path
                    d="M1346.68 132.531C1345.62 132.631 1344.45 132.331 1343.77 131.504C1343.09 130.678 1343.09 129.267 1343.95 128.633C1344.69 128.091 1345.73 128.249 1346.58 128.566C1347.44 128.883 1348.29 129.343 1349.21 129.326C1350.13 129.309 1350.98 128.808 1351.88 128.725C1354 128.541 1355.88 130.594 1357.98 130.261C1358.88 130.11 1359.73 129.518 1360.65 129.626C1361.57 129.735 1362.27 130.528 1363.17 130.811C1363.99 131.07 1364.88 130.87 1365.7 130.611C1366.52 130.352 1367.34 130.027 1368.21 130.035C1369.07 130.052 1370 130.503 1370.25 131.329C1370.52 132.247 1369.83 133.232 1368.96 133.624C1368.08 134.017 1367.08 133.958 1366.12 133.9C1359.67 133.491 1353.2 133.082 1346.74 132.673"
                    fill="#FB5607" />
                <path
                    d="M1346.68 132.531C1345.62 132.631 1344.45 132.331 1343.77 131.504C1343.09 130.678 1343.09 129.267 1343.95 128.633C1344.69 128.091 1345.73 128.249 1346.58 128.566C1347.44 128.883 1348.29 129.343 1349.21 129.326C1350.13 129.309 1350.98 128.808 1351.88 128.725C1354 128.541 1355.88 130.594 1357.98 130.261C1358.88 130.11 1359.73 129.518 1360.65 129.626C1361.57 129.735 1362.27 130.528 1363.17 130.811C1363.99 131.07 1364.88 130.87 1365.7 130.611C1366.52 130.352 1367.34 130.027 1368.21 130.035C1369.07 130.052 1370 130.503 1370.25 131.329C1370.52 132.247 1369.83 133.232 1368.96 133.624C1368.08 134.017 1367.08 133.958 1366.12 133.9C1359.67 133.491 1353.2 133.082 1346.74 132.673"
                    fill="#FB5607" />
                <path
                    d="M1362.81 127.056C1362.65 126.922 1362.45 126.847 1362.25 126.78C1361.49 126.521 1360.72 126.304 1359.94 126.154C1359.8 126.129 1359.66 126.096 1359.54 126.012C1359.43 125.929 1359.36 125.77 1359.42 125.637C1359.47 125.52 1359.6 125.47 1359.72 125.436L1360.91 125.044C1361.01 125.011 1361.12 124.961 1361.14 124.852C1361.17 124.71 1360.99 124.627 1360.85 124.593C1360.09 124.401 1359.33 124.201 1358.57 124.009C1358.85 123.517 1359.77 123.625 1359.93 123.083C1360.05 122.69 1359.63 122.34 1359.24 122.206C1358.51 121.964 1357.68 122.064 1357.02 122.457C1356.83 122.34 1356.89 122.039 1357.02 121.856C1357.14 121.672 1357.31 121.472 1357.27 121.255C1357.23 121.054 1357.02 120.913 1356.82 120.913C1356.61 120.913 1356.43 121.021 1356.27 121.155C1355.78 121.58 1355.58 122.315 1355.78 122.932C1354.71 123.149 1353.69 123.659 1352.87 124.393C1352.68 124.56 1352.49 124.819 1352.61 125.036C1352.72 125.236 1352.99 125.244 1353.23 125.228L1355.25 125.061C1354.83 125.678 1354.07 125.971 1353.33 126.121C1352.6 126.271 1351.83 126.338 1351.16 126.663C1350.99 126.747 1350.81 126.872 1350.8 127.064C1350.79 127.231 1350.93 127.381 1351.08 127.44C1351.24 127.498 1351.42 127.49 1351.58 127.473C1353.01 127.373 1354.43 127.264 1355.86 127.164C1355.98 127.156 1356.13 127.156 1356.21 127.248C1356.3 127.348 1356.28 127.498 1356.21 127.615C1356.14 127.732 1356.04 127.824 1355.98 127.94C1355.78 128.291 1355.97 128.783 1356.31 129C1356.65 129.226 1357.1 129.226 1357.49 129.117C1357.88 129.009 1358.25 128.808 1358.62 128.642C1359.62 128.199 1360.72 128.007 1361.82 128.082C1362.06 128.099 1362.31 128.132 1362.54 128.074C1362.77 128.016 1363.01 127.84 1363.05 127.598C1363.08 127.39 1362.97 127.181 1362.81 127.047V127.056Z"
                    fill="#FB5607" />
                <path
                    d="M1362.81 127.056C1362.65 126.922 1362.45 126.847 1362.25 126.78C1361.49 126.521 1360.72 126.304 1359.94 126.154C1359.8 126.129 1359.66 126.096 1359.54 126.012C1359.43 125.929 1359.36 125.77 1359.42 125.637C1359.47 125.52 1359.6 125.47 1359.72 125.436L1360.91 125.044C1361.01 125.011 1361.12 124.961 1361.14 124.852C1361.17 124.71 1360.99 124.627 1360.85 124.593C1360.09 124.401 1359.33 124.201 1358.57 124.009C1358.85 123.517 1359.77 123.625 1359.93 123.083C1360.05 122.69 1359.63 122.34 1359.24 122.206C1358.51 121.964 1357.68 122.064 1357.02 122.457C1356.83 122.34 1356.89 122.039 1357.02 121.856C1357.14 121.672 1357.31 121.472 1357.27 121.255C1357.23 121.054 1357.02 120.913 1356.82 120.913C1356.61 120.913 1356.43 121.021 1356.27 121.155C1355.78 121.58 1355.58 122.315 1355.78 122.932C1354.71 123.149 1353.69 123.659 1352.87 124.393C1352.68 124.56 1352.49 124.819 1352.61 125.036C1352.72 125.236 1352.99 125.244 1353.23 125.228L1355.25 125.061C1354.83 125.678 1354.07 125.971 1353.33 126.121C1352.6 126.271 1351.83 126.338 1351.16 126.663C1350.99 126.747 1350.81 126.872 1350.8 127.064C1350.79 127.231 1350.93 127.381 1351.08 127.44C1351.24 127.498 1351.42 127.49 1351.58 127.473C1353.01 127.373 1354.43 127.264 1355.86 127.164C1355.98 127.156 1356.13 127.156 1356.21 127.248C1356.3 127.348 1356.28 127.498 1356.21 127.615C1356.14 127.732 1356.04 127.824 1355.98 127.94C1355.78 128.291 1355.97 128.783 1356.31 129C1356.65 129.226 1357.1 129.226 1357.49 129.117C1357.88 129.009 1358.25 128.808 1358.62 128.642C1359.62 128.199 1360.72 128.007 1361.82 128.082C1362.06 128.099 1362.31 128.132 1362.54 128.074C1362.77 128.016 1363.01 127.84 1363.05 127.598C1363.08 127.39 1362.97 127.181 1362.81 127.047V127.056Z"
                    fill="#FB5607" />
                <g opacity="0.5">
                    <path
                        d="M1362.81 127.056C1362.65 126.923 1362.45 126.847 1362.25 126.781C1361.49 126.522 1360.72 126.305 1359.94 126.155C1359.8 126.13 1359.66 126.096 1359.54 126.013C1359.43 125.929 1359.36 125.771 1359.42 125.637C1359.47 125.52 1359.6 125.47 1359.72 125.437L1360.91 125.045C1361.01 125.011 1361.12 124.961 1361.14 124.853C1361.17 124.711 1360.99 124.627 1360.85 124.594C1360.09 124.402 1359.33 124.202 1358.57 124.01C1358.85 123.517 1359.77 123.626 1359.93 123.083C1360.05 122.691 1359.63 122.34 1359.24 122.207C1358.51 121.965 1357.68 122.065 1357.02 122.457C1356.83 122.34 1356.89 122.04 1357.02 121.856C1357.14 121.673 1357.31 121.472 1357.27 121.255C1357.23 121.055 1357.02 120.913 1356.82 120.913C1356.61 120.913 1356.43 121.022 1356.27 121.155C1355.78 121.581 1355.58 122.315 1355.78 122.933C1354.71 123.15 1353.69 123.659 1352.87 124.394C1352.68 124.561 1352.49 124.819 1352.61 125.036C1352.72 125.237 1352.99 125.245 1353.23 125.228L1355.25 125.061C1354.83 125.679 1354.07 125.971 1353.33 126.121C1352.6 126.272 1351.83 126.338 1351.16 126.664C1350.99 126.747 1350.81 126.873 1350.8 127.064C1350.79 127.231 1350.93 127.382 1351.08 127.44C1351.24 127.499 1351.42 127.49 1351.58 127.473C1353.01 127.373 1354.43 127.265 1355.86 127.165C1355.98 127.156 1356.13 127.156 1356.21 127.248C1356.3 127.348 1356.28 127.499 1356.21 127.615C1356.14 127.732 1356.04 127.824 1355.98 127.941C1355.78 128.291 1355.97 128.784 1356.31 129.001C1356.65 129.226 1357.1 129.226 1357.49 129.118C1357.88 129.009 1358.25 128.809 1358.62 128.642C1359.62 128.2 1360.72 128.008 1361.82 128.083C1362.06 128.099 1362.31 128.133 1362.54 128.074C1362.77 128.016 1363.01 127.841 1363.05 127.599C1363.08 127.39 1362.97 127.181 1362.81 127.048V127.056Z"
                        fill="white" />
                </g>
                <path
                    d="M1359.42 123.075C1359.42 123.859 1358.4 124.494 1357.14 124.494C1355.88 124.494 1354.86 123.859 1354.86 123.075C1354.86 122.29 1355.88 121.656 1357.14 121.656C1358.4 121.656 1359.42 122.29 1359.42 123.075Z"
                    fill="#FB5607" />
                <path
                    d="M1359.42 123.075C1359.42 123.859 1358.4 124.494 1357.14 124.494C1355.88 124.494 1354.86 123.859 1354.86 123.075C1354.86 122.29 1355.88 121.656 1357.14 121.656C1358.4 121.656 1359.42 122.29 1359.42 123.075Z"
                    fill="#FB5607" />
                <path
                    d="M1357.89 123.826C1357.92 123.884 1357.88 123.959 1357.8 123.993C1357.73 124.026 1357.64 124.009 1357.61 123.951C1357.58 123.893 1357.63 123.817 1357.7 123.784C1357.78 123.751 1357.86 123.767 1357.89 123.826Z"
                    fill="#E1E1E1" />
                <path
                    d="M1358.03 123.175C1358.06 123.225 1358.03 123.3 1357.98 123.333C1357.92 123.367 1357.84 123.35 1357.81 123.3C1357.78 123.25 1357.8 123.175 1357.86 123.141C1357.92 123.108 1357.99 123.125 1358.03 123.175Z"
                    fill="#E1E1E1" />
                <path
                    d="M1358.77 123.2C1358.82 123.241 1358.82 123.316 1358.77 123.358C1358.72 123.4 1358.66 123.408 1358.62 123.358C1358.57 123.316 1358.57 123.241 1358.62 123.2C1358.67 123.158 1358.73 123.149 1358.77 123.2Z"
                    fill="#E1E1E1" />
                <path
                    d="M1356.43 122.824C1356.46 122.882 1356.43 122.949 1356.38 122.974C1356.32 122.999 1356.25 122.974 1356.23 122.924C1356.2 122.866 1356.23 122.799 1356.28 122.774C1356.34 122.749 1356.41 122.774 1356.43 122.824Z"
                    fill="#E1E1E1" />
                <path
                    d="M1357.68 122.482C1357.7 122.54 1357.68 122.607 1357.6 122.641C1357.53 122.674 1357.46 122.649 1357.43 122.591C1357.41 122.532 1357.43 122.465 1357.51 122.432C1357.58 122.399 1357.65 122.424 1357.68 122.482Z"
                    fill="#E1E1E1" />
                <path
                    d="M1358.61 122.599C1358.63 122.657 1358.61 122.716 1358.57 122.732C1358.53 122.749 1358.48 122.716 1358.45 122.657C1358.43 122.599 1358.45 122.541 1358.49 122.524C1358.53 122.507 1358.58 122.541 1358.61 122.599Z"
                    fill="#E1E1E1" />
                <path
                    d="M1356.88 122.082C1356.91 122.14 1356.85 122.223 1356.74 122.274C1356.63 122.324 1356.53 122.315 1356.5 122.265C1356.48 122.207 1356.53 122.123 1356.64 122.073C1356.75 122.023 1356.85 122.031 1356.88 122.082Z"
                    fill="#E1E1E1" />
                <path
                    d="M1355.49 122.607C1355.51 122.666 1355.48 122.732 1355.42 122.749C1355.36 122.766 1355.29 122.732 1355.27 122.674C1355.25 122.616 1355.28 122.549 1355.34 122.532C1355.4 122.515 1355.47 122.549 1355.49 122.607Z"
                    fill="#E1E1E1" />
                <path
                    d="M1355.56 123.367C1355.59 123.425 1355.57 123.492 1355.52 123.525C1355.46 123.558 1355.39 123.533 1355.36 123.483C1355.33 123.425 1355.35 123.358 1355.4 123.325C1355.46 123.291 1355.53 123.316 1355.56 123.367Z"
                    fill="#E1E1E1" />
                <path
                    d="M1356.73 123.884C1356.76 123.943 1356.73 124.018 1356.65 124.051C1356.58 124.085 1356.49 124.068 1356.47 124.01C1356.44 123.951 1356.48 123.876 1356.55 123.843C1356.63 123.809 1356.71 123.826 1356.73 123.884Z"
                    fill="#E1E1E1" />
                <path
                    d="M1357.33 123.241C1357.35 123.3 1357.28 123.383 1357.16 123.433C1357.04 123.484 1356.93 123.475 1356.91 123.417C1356.89 123.358 1356.96 123.275 1357.08 123.225C1357.19 123.175 1357.31 123.183 1357.33 123.241Z"
                    fill="#E1E1E1" />
                <path
                    d="M1356.16 123.484C1356.19 123.542 1356.18 123.601 1356.13 123.634C1356.09 123.667 1356.03 123.634 1355.99 123.584C1355.96 123.525 1355.98 123.467 1356.02 123.434C1356.07 123.409 1356.13 123.434 1356.16 123.484Z"
                    fill="#E1E1E1" />
                <path
                    d="M1357.88 122.081C1357.9 122.14 1357.88 122.207 1357.83 122.215C1357.78 122.232 1357.72 122.198 1357.7 122.131C1357.68 122.073 1357.7 122.006 1357.76 121.998C1357.82 121.99 1357.87 122.023 1357.88 122.081Z"
                    fill="#E1E1E1" />
                <path
                    d="M1363.48 128.024C1363.48 128.65 1362.67 129.159 1361.66 129.159C1360.65 129.159 1359.83 128.65 1359.83 128.024C1359.83 127.398 1360.65 126.889 1361.66 126.889C1362.67 126.889 1363.48 127.398 1363.48 128.024Z"
                    fill="#FB5607" />
                <path
                    d="M1363.48 128.024C1363.48 128.65 1362.67 129.159 1361.66 129.159C1360.65 129.159 1359.83 128.65 1359.83 128.024C1359.83 127.398 1360.65 126.889 1361.66 126.889C1362.67 126.889 1363.48 127.398 1363.48 128.024Z"
                    fill="#FB5607" />
                <path
                    d="M1362.26 128.634C1362.28 128.692 1362.26 128.759 1362.19 128.792C1362.13 128.817 1362.06 128.792 1362.03 128.742C1362.01 128.684 1362.03 128.617 1362.1 128.584C1362.16 128.559 1362.23 128.584 1362.26 128.634Z"
                    fill="#E1E1E1" />
                <path
                    d="M1362.37 128.108C1362.4 128.158 1362.38 128.225 1362.34 128.258C1362.29 128.283 1362.23 128.258 1362.2 128.208C1362.17 128.158 1362.18 128.091 1362.22 128.058C1362.27 128.033 1362.33 128.058 1362.37 128.108Z"
                    fill="#E1E1E1" />
                <path
                    d="M1362.97 128.133C1363.02 128.174 1363.02 128.241 1362.99 128.274C1362.96 128.307 1362.89 128.307 1362.84 128.266C1362.79 128.224 1362.78 128.158 1362.82 128.125C1362.85 128.091 1362.92 128.091 1362.96 128.133H1362.97Z"
                    fill="#E1E1E1" />
                <path
                    d="M1361.09 127.824C1361.12 127.882 1361.1 127.941 1361.06 127.966C1361.01 127.991 1360.95 127.966 1360.92 127.899C1360.9 127.841 1360.92 127.782 1360.96 127.757C1361.01 127.732 1361.07 127.757 1361.09 127.824Z"
                    fill="#E1E1E1" />
                <path
                    d="M1362.08 127.557C1362.11 127.615 1362.08 127.682 1362.03 127.707C1361.98 127.732 1361.92 127.707 1361.89 127.649C1361.87 127.59 1361.89 127.523 1361.94 127.498C1361.99 127.473 1362.06 127.498 1362.08 127.557Z"
                    fill="#E1E1E1" />
                <path
                    d="M1362.83 127.649C1362.86 127.707 1362.84 127.766 1362.81 127.782C1362.77 127.791 1362.72 127.757 1362.71 127.699C1362.68 127.64 1362.7 127.582 1362.73 127.565C1362.77 127.557 1362.82 127.59 1362.83 127.649Z"
                    fill="#E1E1E1" />
                <path
                    d="M1361.45 127.231C1361.47 127.29 1361.43 127.365 1361.35 127.407C1361.27 127.448 1361.17 127.432 1361.15 127.373C1361.12 127.315 1361.17 127.24 1361.25 127.198C1361.33 127.156 1361.42 127.173 1361.45 127.231Z"
                    fill="#E1E1E1" />
                <path
                    d="M1360.34 127.657C1360.36 127.716 1360.34 127.782 1360.28 127.791C1360.22 127.799 1360.17 127.774 1360.16 127.707C1360.14 127.649 1360.16 127.582 1360.22 127.574C1360.27 127.565 1360.32 127.591 1360.34 127.657Z"
                    fill="#E1E1E1" />
                <path
                    d="M1360.39 128.266C1360.42 128.325 1360.41 128.383 1360.37 128.408C1360.32 128.433 1360.26 128.408 1360.23 128.35C1360.2 128.292 1360.22 128.233 1360.26 128.208C1360.3 128.183 1360.37 128.208 1360.39 128.258V128.266Z"
                    fill="#E1E1E1" />
                <path
                    d="M1361.33 128.684C1361.36 128.742 1361.33 128.809 1361.27 128.834C1361.22 128.859 1361.15 128.834 1361.12 128.784C1361.09 128.726 1361.12 128.659 1361.17 128.634C1361.23 128.609 1361.3 128.634 1361.33 128.684Z"
                    fill="#E1E1E1" />
                <path
                    d="M1361.81 128.166C1361.83 128.225 1361.77 128.3 1361.68 128.342C1361.59 128.383 1361.49 128.367 1361.47 128.308C1361.45 128.25 1361.51 128.175 1361.6 128.133C1361.69 128.091 1361.79 128.108 1361.81 128.166Z"
                    fill="#E1E1E1" />
                <path
                    d="M1360.87 128.358C1360.9 128.417 1360.89 128.475 1360.86 128.5C1360.82 128.525 1360.77 128.5 1360.73 128.442C1360.7 128.383 1360.71 128.325 1360.74 128.3C1360.77 128.275 1360.83 128.3 1360.87 128.358Z"
                    fill="#E1E1E1" />
                <path
                    d="M1362.26 127.24C1362.27 127.298 1362.26 127.357 1362.22 127.374C1362.17 127.382 1362.12 127.349 1362.11 127.29C1362.09 127.232 1362.11 127.173 1362.15 127.157C1362.19 127.148 1362.24 127.182 1362.26 127.24Z"
                    fill="#E1E1E1" />
                <path
                    d="M1356.68 126.93C1356.68 127.69 1355.69 128.308 1354.48 128.308C1353.26 128.308 1352.27 127.69 1352.27 126.93C1352.27 126.171 1353.26 125.553 1354.48 125.553C1355.69 125.553 1356.68 126.171 1356.68 126.93Z"
                    fill="#FB5607" />
                <path
                    d="M1356.68 126.93C1356.68 127.69 1355.69 128.308 1354.48 128.308C1353.26 128.308 1352.27 127.69 1352.27 126.93C1352.27 126.171 1353.26 125.553 1354.48 125.553C1355.69 125.553 1356.68 126.171 1356.68 126.93Z"
                    fill="#FB5607" />
                <path
                    d="M1355.19 127.656C1355.22 127.715 1355.18 127.79 1355.1 127.823C1355.03 127.857 1354.94 127.84 1354.92 127.782C1354.89 127.723 1354.93 127.648 1355.01 127.615C1355.08 127.581 1355.17 127.598 1355.19 127.656Z"
                    fill="#E1E1E1" />
                <path
                    d="M1355.33 127.031C1355.36 127.081 1355.34 127.156 1355.28 127.189C1355.23 127.223 1355.16 127.206 1355.13 127.156C1355.09 127.106 1355.11 127.031 1355.17 126.997C1355.23 126.964 1355.29 126.981 1355.33 127.031Z"
                    fill="#E1E1E1" />
                <path
                    d="M1356.05 127.056C1356.1 127.098 1356.1 127.173 1356.06 127.215C1356.02 127.256 1355.94 127.265 1355.9 127.215C1355.85 127.173 1355.85 127.098 1355.89 127.056C1355.93 127.014 1356.01 127.006 1356.05 127.056Z"
                    fill="#E1E1E1" />
                <path
                    d="M1353.78 126.688C1353.8 126.747 1353.78 126.813 1353.72 126.838C1353.66 126.863 1353.59 126.838 1353.57 126.78C1353.54 126.722 1353.57 126.655 1353.63 126.63C1353.68 126.605 1353.75 126.63 1353.78 126.688Z"
                    fill="#E1E1E1" />
                <path
                    d="M1354.98 126.363C1355.01 126.421 1354.98 126.488 1354.92 126.521C1354.85 126.555 1354.78 126.53 1354.75 126.471C1354.73 126.413 1354.75 126.346 1354.82 126.313C1354.88 126.279 1354.96 126.304 1354.98 126.363Z"
                    fill="#E1E1E1" />
                <path
                    d="M1355.88 126.472C1355.91 126.53 1355.88 126.588 1355.85 126.605C1355.81 126.622 1355.76 126.588 1355.73 126.522C1355.71 126.463 1355.73 126.405 1355.77 126.388C1355.81 126.371 1355.86 126.405 1355.88 126.472Z"
                    fill="#E1E1E1" />
                <path
                    d="M1354.22 125.97C1354.24 126.029 1354.18 126.112 1354.08 126.162C1353.98 126.213 1353.88 126.204 1353.85 126.146C1353.83 126.087 1353.88 126.004 1353.98 125.954C1354.08 125.904 1354.19 125.912 1354.22 125.97Z"
                    fill="#E1E1E1" />
                <path
                    d="M1352.88 126.48C1352.89 126.538 1352.86 126.605 1352.8 126.622C1352.74 126.638 1352.68 126.605 1352.66 126.547C1352.64 126.488 1352.68 126.421 1352.73 126.405C1352.79 126.388 1352.86 126.421 1352.88 126.48Z"
                    fill="#E1E1E1" />
                <path
                    d="M1352.94 127.223C1352.98 127.281 1352.96 127.348 1352.9 127.373C1352.85 127.407 1352.78 127.382 1352.75 127.331C1352.72 127.281 1352.73 127.206 1352.79 127.181C1352.84 127.148 1352.91 127.173 1352.94 127.223Z"
                    fill="#E1E1E1" />
                <path
                    d="M1354.08 127.723C1354.1 127.782 1354.07 127.857 1353.99 127.89C1353.92 127.924 1353.84 127.907 1353.82 127.849C1353.79 127.79 1353.83 127.715 1353.9 127.682C1353.98 127.648 1354.05 127.665 1354.08 127.723Z"
                    fill="#E1E1E1" />
                <path
                    d="M1354.65 127.097C1354.68 127.156 1354.6 127.239 1354.49 127.289C1354.38 127.339 1354.27 127.323 1354.24 127.264C1354.22 127.206 1354.29 127.122 1354.4 127.072C1354.52 127.022 1354.63 127.039 1354.65 127.097Z"
                    fill="#E1E1E1" />
                <path
                    d="M1353.52 127.331C1353.55 127.389 1353.53 127.448 1353.49 127.481C1353.45 127.506 1353.38 127.481 1353.35 127.431C1353.32 127.373 1353.33 127.314 1353.38 127.281C1353.42 127.256 1353.48 127.281 1353.52 127.331Z"
                    fill="#E1E1E1" />
                <path
                    d="M1355.19 125.979C1355.21 126.038 1355.19 126.104 1355.13 126.113C1355.08 126.13 1355.03 126.088 1355.01 126.029C1354.99 125.971 1355.01 125.904 1355.07 125.896C1355.12 125.879 1355.17 125.921 1355.19 125.979Z"
                    fill="#E1E1E1" />
                <path
                    d="M1347.73 132.289L1353.24 141.37L1357.95 144.6C1357.95 144.6 1360.42 146.345 1362.44 147.422C1364.46 148.498 1367.54 150.042 1367.54 150.042L1375.66 142.781C1375.66 142.781 1370.43 135.586 1369.62 134.643C1368.82 133.7 1359.89 129.668 1359.89 129.668C1359.89 129.668 1358.82 130.136 1359.82 131.688C1360.83 133.232 1363.05 135.519 1363.05 135.519L1365 136.329L1362.04 135.72L1357.96 132.423C1357.96 132.423 1356 129.869 1354.93 130.537C1353.85 131.204 1353.78 132.014 1354.32 133.024C1354.85 134.034 1356.67 135.912 1356.67 135.912L1360.55 139.359L1358.68 138.741C1358.68 138.741 1352.78 132.281 1351.77 132.081C1350.76 131.88 1350.35 132.147 1350.35 132.147C1350.35 132.147 1348.88 130.194 1347.73 132.281V132.289Z"
                    fill="#FFBF9D" />
                <path
                    d="M1362.33 143.54C1362.32 143.59 1361.42 143.323 1359.97 142.814C1359.26 142.564 1358.41 142.255 1357.46 141.896C1356.98 141.712 1356.49 141.52 1355.98 141.32C1355.73 141.22 1355.47 141.111 1355.21 140.994C1355.08 140.944 1354.95 140.878 1354.82 140.811C1354.64 140.719 1354.57 140.594 1354.47 140.485C1353.06 138.624 1351.94 136.83 1351.14 135.536C1350.75 134.885 1350.44 134.342 1350.24 133.967C1350.04 133.591 1349.94 133.374 1349.96 133.366C1349.98 133.366 1350.1 133.558 1350.32 133.925C1350.57 134.317 1350.89 134.835 1351.28 135.452C1352.11 136.721 1353.24 138.507 1354.64 140.343C1354.73 140.452 1354.83 140.577 1354.92 140.611C1355.04 140.669 1355.17 140.736 1355.3 140.786C1355.56 140.894 1355.82 141.003 1356.07 141.111L1357.53 141.696C1358.46 142.054 1359.3 142.38 1360.02 142.655C1360.71 142.914 1361.27 143.131 1361.71 143.298C1362.11 143.457 1362.32 143.523 1362.32 143.54H1362.33Z"
                    fill="#FF9A6C" />
                <path
                    d="M1365.32 140.469C1365.32 140.527 1364.17 140.469 1362.83 140.118C1361.49 139.768 1360.44 139.384 1360.46 139.326C1360.47 139.259 1361.56 139.551 1362.89 139.893C1364.22 140.235 1365.32 140.402 1365.32 140.461V140.469Z"
                    fill="#FF9A6C" />
                <path
                    d="M1369.71 137.072C1369.71 137.072 1369.35 137.097 1368.77 137.038C1368.2 136.98 1367.41 136.871 1366.54 136.704C1365.67 136.537 1364.9 136.362 1364.34 136.229C1363.78 136.095 1363.43 136.003 1363.44 135.97C1363.45 135.903 1364.87 136.137 1366.58 136.479C1367.44 136.646 1368.22 136.78 1368.79 136.871C1369.36 136.963 1369.71 137.03 1369.71 137.063V137.072Z"
                    fill="#FF9A6C" />
                <path
                    d="M1366.06 149.182C1366.06 149.182 1380.48 176.784 1382.4 179.422C1384.46 182.268 1386.35 184.021 1391.35 183.587C1396.29 183.161 1401.09 181.066 1401.68 173.037C1401.97 168.997 1402.27 150.042 1402.27 150.042H1387.56L1387.55 156.869L1375 141.854L1366.06 149.182Z"
                    fill="#FFBF9D" />
                <path
                    d="M1397.13 173.83C1397.13 173.83 1397.09 173.554 1397.04 173.053C1396.98 172.553 1396.87 171.835 1396.66 170.958C1396.26 169.206 1395.35 166.869 1393.89 164.54C1392.44 162.203 1390.69 160.408 1389.48 159.073C1388.87 158.405 1388.37 157.871 1388.05 157.487L1387.67 157.045C1387.59 156.944 1387.55 156.886 1387.55 156.878C1387.56 156.869 1387.76 157.061 1388.11 157.429C1388.49 157.821 1389 158.338 1389.6 158.964C1390.85 160.266 1392.62 162.061 1394.09 164.423C1395.55 166.768 1396.46 169.147 1396.83 170.925C1397.02 171.81 1397.1 172.544 1397.13 173.053C1397.15 173.304 1397.15 173.504 1397.15 173.638C1397.15 173.771 1397.15 173.838 1397.14 173.838L1397.13 173.83Z"
                    fill="#FF9A6C" />
                <path
                    d="M1277.47 88.9129C1267.77 85.578 1265.8 96.7858 1264.26 100.722C1262.73 104.659 1263.5 105.698 1262.73 109.439C1261.97 113.179 1258.52 115.474 1258.24 118.829C1257.94 122.183 1258.75 123.602 1258.75 123.602C1259.61 125.211 1260.74 128.363 1260.46 130.174C1260.27 131.41 1259.55 132.489 1259.06 133.633C1257.8 136.536 1258 140.028 1259.59 142.768C1260.36 144.108 1261.48 145.364 1261.58 146.907C1261.65 148.078 1261.11 149.189 1260.91 150.34C1260.61 151.955 1261 153.675 1261.94 155.015C1262.89 156.349 1264.39 157.285 1266 157.54C1264.76 155.682 1264.65 153.139 1265.7 151.177C1266.34 149.987 1267.36 149.052 1268.19 147.986C1269.03 146.927 1269.72 145.626 1269.56 144.285C1269.38 142.879 1268.29 141.722 1268.05 140.322C1267.83 138.988 1268.42 137.635 1269.21 136.53C1270 135.425 1270.98 134.477 1271.74 133.345C1273.22 131.083 1275 129.664 1274.61 125.054L1277.49 88.9194L1277.47 88.9129Z"
                    fill="#1A2E35" />
                <path
                    d="M1271.74 142.238C1271.74 142.238 1271.74 142.291 1271.7 142.33C1271.69 142.349 1271.67 142.369 1271.65 142.395C1271.64 142.421 1271.62 142.454 1271.59 142.48C1271.51 142.604 1271.45 142.814 1271.5 143.082C1271.54 143.337 1271.74 143.683 1272.02 143.755C1272.3 143.847 1272.72 143.703 1273 143.343C1273.14 143.167 1273.24 142.944 1273.26 142.729C1273.28 142.487 1273.26 142.225 1273.15 141.957C1273.05 141.689 1272.9 141.421 1272.7 141.172C1272.49 140.924 1272.24 140.682 1271.96 140.44C1271.4 139.956 1270.66 139.485 1270.03 138.74C1269.71 138.367 1269.43 137.923 1269.27 137.386C1269.1 136.85 1269.12 136.249 1269.25 135.725C1269.54 134.666 1270.19 133.875 1270.75 133.228C1271.03 132.901 1271.3 132.593 1271.53 132.286C1271.76 131.979 1271.94 131.678 1272.1 131.357C1272.4 130.71 1272.56 130.023 1272.65 129.37C1272.7 129.036 1272.7 128.735 1272.73 128.376C1272.77 128.036 1272.81 127.728 1272.85 127.427C1273.21 125.041 1273.58 123.602 1273.74 123.622C1273.92 123.641 1273.85 125.132 1273.72 127.512C1273.71 127.807 1273.69 128.121 1273.69 128.434C1273.69 128.729 1273.69 129.101 1273.67 129.468C1273.62 130.213 1273.48 131.017 1273.15 131.822C1272.98 132.221 1272.75 132.626 1272.49 132.986C1272.24 133.352 1271.95 133.685 1271.68 134.012C1271.42 134.339 1271.15 134.666 1270.94 134.993C1270.72 135.327 1270.55 135.68 1270.46 136.039C1270.37 136.399 1270.36 136.732 1270.46 137.046C1270.55 137.367 1270.74 137.681 1270.97 137.975C1271.44 138.557 1272.1 139.028 1272.71 139.59C1273.02 139.871 1273.32 140.172 1273.57 140.525C1273.82 140.872 1274.01 141.251 1274.14 141.65C1274.26 142.049 1274.29 142.487 1274.22 142.886C1274.13 143.311 1273.92 143.664 1273.67 143.938C1273.41 144.207 1273.09 144.403 1272.75 144.488C1272.41 144.579 1272.06 144.547 1271.76 144.409C1271.45 144.265 1271.27 144.017 1271.17 143.788C1271.06 143.559 1271.03 143.33 1271.04 143.128C1271.05 142.722 1271.25 142.428 1271.44 142.317C1271.48 142.291 1271.52 142.271 1271.56 142.251C1271.6 142.238 1271.63 142.238 1271.66 142.232C1271.71 142.232 1271.74 142.232 1271.75 142.258L1271.74 142.238Z"
                    fill="#1A2E35" />
                <path
                    d="M1292.96 102.671C1292.96 102.671 1294.62 110.224 1297.05 115.579C1299.48 120.928 1300.24 122.151 1298.87 126.558C1297.51 130.965 1303.43 130.514 1303.88 139.937C1304.34 149.366 1294.72 150.432 1296.42 156.663C1296.42 156.663 1292.99 155.748 1291.76 151.798C1290.52 147.842 1290.56 148.15 1291.76 143.893C1292.95 139.636 1292.41 139.597 1290.35 135.346C1288.28 131.103 1285.36 132.528 1286.38 125.047C1287.4 117.567 1285.62 101.004 1285.8 100.703C1285.97 100.402 1292.97 102.671 1292.97 102.671H1292.96Z"
                    fill="#1A2E35" />
                <path
                    d="M1276.66 89.5425C1277.42 88.4439 1278.74 87.8096 1280.07 87.6854C1281.4 87.5611 1282.74 87.9077 1283.96 88.4635C1286.97 89.8367 1289.29 92.4588 1290.82 95.3948C1292.35 98.3309 1293.17 101.587 1293.81 104.837C1294.63 108.996 1295.2 113.201 1295.5 117.425C1295.59 118.7 1296.26 127.959 1296.41 129.842"
                    fill="#1A2E35" />
                <path
                    d="M1301.48 127.383C1301.48 127.383 1301.56 127.226 1301.84 127.135C1302.12 127.05 1302.6 127.063 1303.08 127.396C1303.3 127.566 1303.54 127.815 1303.67 128.168C1303.79 128.521 1303.79 128.946 1303.65 129.345C1303.51 129.744 1303.24 130.123 1302.85 130.404C1302.65 130.542 1302.42 130.659 1302.17 130.725C1301.92 130.79 1301.66 130.823 1301.39 130.81C1300.86 130.784 1300.33 130.6 1299.86 130.274C1299.38 129.947 1299 129.482 1298.73 128.953C1298.47 128.423 1298.29 127.841 1298.23 127.233L1298.18 126.775C1298.18 126.625 1298.18 126.468 1298.18 126.317V126.082L1298.19 125.853L1298.23 125.389C1298.38 124.153 1298.76 122.937 1299.11 121.721C1299.29 121.112 1299.46 120.504 1299.57 119.89C1299.68 119.275 1299.76 118.654 1299.72 118.046C1299.67 116.829 1299.13 115.724 1298.43 114.73C1297.73 113.736 1296.89 112.834 1296.14 111.899C1294.62 110.009 1293.68 107.995 1293.16 106.249C1292.64 104.497 1292.53 103.012 1292.56 102.005C1292.59 100.992 1292.72 100.449 1292.8 100.449C1292.89 100.449 1292.92 101.005 1293.04 101.979C1293.17 102.947 1293.4 104.346 1294 105.975C1294.58 107.596 1295.55 109.44 1297.02 111.173C1297.76 112.049 1298.63 112.939 1299.42 114.024C1299.81 114.567 1300.18 115.162 1300.46 115.829L1300.56 116.077L1300.65 116.339C1300.71 116.509 1300.76 116.692 1300.8 116.869C1300.85 117.045 1300.87 117.235 1300.9 117.418C1300.92 117.601 1300.95 117.791 1300.95 117.974C1301.01 118.719 1300.91 119.438 1300.78 120.118C1300.65 120.805 1300.46 121.446 1300.28 122.061C1299.9 123.296 1299.52 124.434 1299.36 125.533C1299.35 125.67 1299.34 125.801 1299.32 125.938L1299.3 126.141V126.337L1299.28 126.729C1299.3 126.86 1299.3 126.984 1299.32 127.109C1299.35 127.612 1299.47 128.083 1299.66 128.495C1299.85 128.9 1300.11 129.253 1300.43 129.495C1300.74 129.737 1301.11 129.894 1301.46 129.927C1301.82 129.966 1302.15 129.901 1302.42 129.737C1302.69 129.574 1302.9 129.332 1303.02 129.077C1303.14 128.822 1303.16 128.554 1303.11 128.325C1303.07 128.103 1302.93 127.906 1302.78 127.756C1302.48 127.462 1302.12 127.37 1301.89 127.37C1301.65 127.37 1301.52 127.409 1301.5 127.37L1301.48 127.383Z"
                    fill="#1A2E35" />
                <path
                    d="M1286.97 95.3355L1278.15 91.7783L1275.85 92.0333C1270.66 92.0333 1267.06 97.7419 1267 101.953C1266.94 106.628 1267.06 112.337 1267.78 115.789C1269.24 122.727 1274.63 123.349 1274.63 123.349C1274.63 123.335 1274.57 125.245 1274.52 127.573C1274.42 131.758 1277.72 143.672 1281.89 143.587L1281.14 143.142C1285.12 143.064 1289.16 131.758 1289.18 127.775L1289.29 97.7223C1289.25 96.4472 1288.24 95.4075 1286.97 95.3355Z"
                    fill="#FFBF9D" />
                <path
                    d="M1269.5 106.673C1269.51 107.15 1269.91 107.53 1270.41 107.536C1270.91 107.536 1271.3 107.157 1271.29 106.68C1271.29 106.202 1270.88 105.816 1270.38 105.816C1269.89 105.816 1269.5 106.196 1269.5 106.673Z"
                    fill="#1A2E35" />
                <path
                    d="M1268.39 104.338C1268.5 104.45 1269.16 103.913 1270.12 103.868C1271.08 103.809 1271.81 104.266 1271.92 104.149C1271.96 104.096 1271.85 103.887 1271.53 103.678C1271.21 103.469 1270.68 103.279 1270.08 103.312C1269.48 103.344 1268.99 103.593 1268.71 103.835C1268.43 104.077 1268.34 104.293 1268.39 104.345L1268.39 104.338Z"
                    fill="#1A2E35" />
                <path
                    d="M1274.73 111.891C1274.73 111.839 1274.12 111.76 1273.15 111.688C1272.9 111.675 1272.66 111.636 1272.61 111.473C1272.55 111.296 1272.63 111.028 1272.74 110.734C1272.94 110.126 1273.15 109.491 1273.37 108.818C1274.25 106.098 1274.87 103.861 1274.76 103.828C1274.65 103.796 1273.86 105.973 1272.98 108.693C1272.77 109.367 1272.56 110.001 1272.38 110.616C1272.3 110.904 1272.15 111.224 1272.3 111.59C1272.38 111.773 1272.56 111.898 1272.72 111.93C1272.88 111.97 1273.02 111.963 1273.14 111.97C1274.12 111.97 1274.73 111.95 1274.73 111.891Z"
                    fill="#1A2E35" />
                <path
                    d="M1274.63 123.347C1274.63 123.347 1279.35 123.413 1283.86 120.378C1283.86 120.378 1281.61 125.348 1274.59 125.047L1274.63 123.347Z"
                    fill="#FFC3BD" />
                <path
                    d="M1268.45 100.624C1268.63 100.834 1269.29 100.572 1270.08 100.526C1270.88 100.448 1271.57 100.598 1271.71 100.363C1271.77 100.245 1271.66 100.036 1271.35 99.8398C1271.05 99.6502 1270.55 99.5063 1270.01 99.5455C1269.46 99.5913 1268.99 99.8136 1268.73 100.049C1268.46 100.291 1268.37 100.52 1268.45 100.624Z"
                    fill="#1A2E35" />
                <path
                    d="M1280.7 106.621C1280.72 107.098 1280.35 107.503 1279.85 107.536C1279.36 107.569 1278.94 107.209 1278.92 106.738C1278.9 106.268 1279.28 105.856 1279.76 105.823C1280.26 105.79 1280.68 106.15 1280.7 106.621H1280.7Z"
                    fill="#1A2E35" />
                <path
                    d="M1281.7 104.229C1281.59 104.347 1280.91 103.85 1279.94 103.869C1278.98 103.869 1278.28 104.379 1278.17 104.262C1278.12 104.209 1278.23 104 1278.54 103.771C1278.84 103.542 1279.35 103.32 1279.95 103.313C1280.55 103.313 1281.06 103.523 1281.36 103.745C1281.66 103.967 1281.76 104.177 1281.7 104.235V104.229Z"
                    fill="#1A2E35" />
                <path
                    d="M1281.28 101.161C1281.11 101.383 1280.44 101.161 1279.65 101.161C1278.85 101.135 1278.17 101.324 1278.02 101.102C1277.94 100.991 1278.05 100.768 1278.34 100.559C1278.63 100.35 1279.12 100.173 1279.67 100.18C1280.22 100.193 1280.69 100.383 1280.97 100.605C1281.26 100.827 1281.35 101.05 1281.28 101.161Z"
                    fill="#1A2E35" />
                <path
                    d="M1278.69 91.4174C1282.18 96.1713 1285.89 101.546 1289.5 106.202C1290.13 103.874 1290.71 100.363 1290.27 97.9956C1289.84 95.6285 1288.64 93.3464 1286.72 91.8882C1284.81 90.43 1281.4 90.1292 1279.16 91.0251"
                    fill="#1A2E35" />
                <path
                    d="M1277.47 88.9146C1265.23 87.1883 1266.99 102.673 1266.99 102.673L1266.91 102.862C1272.24 99.0435 1277.08 91.7525 1277.08 91.7525L1279.01 91.4256L1277.47 88.9211L1277.47 88.9146Z"
                    fill="#1A2E35" />
                <path
                    d="M1287.9 109.538C1287.87 109.015 1288.41 107.76 1288.92 107.655C1290.28 107.374 1292.76 107.361 1292.96 110.846C1293.23 115.613 1288.39 114.9 1288.38 114.763C1288.36 114.659 1287.98 111.337 1287.9 109.538Z"
                    fill="#FFBF9D" />
                <path
                    d="M1289.73 112.873C1289.73 112.873 1289.81 112.926 1289.95 112.985C1290.1 113.037 1290.33 113.07 1290.57 112.965C1291.06 112.749 1291.44 111.925 1291.42 111.069C1291.4 110.637 1291.29 110.225 1291.12 109.892C1290.95 109.552 1290.71 109.323 1290.46 109.29C1290.2 109.244 1290.03 109.408 1289.98 109.545C1289.92 109.682 1289.96 109.774 1289.94 109.787C1289.92 109.8 1289.83 109.715 1289.86 109.512C1289.87 109.414 1289.92 109.303 1290.03 109.205C1290.14 109.107 1290.3 109.048 1290.48 109.055C1290.84 109.055 1291.19 109.382 1291.38 109.748C1291.59 110.114 1291.73 110.572 1291.75 111.062C1291.78 112.023 1291.33 112.952 1290.66 113.187C1290.33 113.292 1290.05 113.207 1289.9 113.102C1289.74 112.991 1289.71 112.887 1289.73 112.88V112.873Z"
                    fill="#FFC3BD" />
                <path
                    d="M1275.85 91.7966C1275.83 91.692 1275.99 91.522 1276.4 91.4239C1276.81 91.3258 1277.44 91.3651 1278.15 91.607C1278.5 91.7247 1278.88 91.8882 1279.27 92.0778L1279.56 92.2282C1279.65 92.274 1279.8 92.359 1279.9 92.4309C1280.14 92.5813 1280.35 92.7579 1280.55 92.9475C1280.97 93.3202 1281.33 93.7387 1281.69 94.1703C1281.86 94.373 1282.04 94.5888 1282.22 94.8046C1282.3 94.9092 1282.4 95.0073 1282.48 95.0988C1282.58 95.2034 1282.68 95.3081 1282.77 95.4192C1283.58 96.2889 1284.48 97.2371 1285.45 98.3225C1286.41 99.408 1287.43 100.657 1288.31 102.161C1288.75 102.913 1289.15 103.73 1289.47 104.6C1289.8 105.489 1290.03 106.346 1290.25 107.242C1290.66 109.04 1290.9 110.936 1290.95 112.878C1290.99 114.631 1290.89 116.337 1290.67 117.972C1290.45 119.62 1290.1 121.15 1289.82 122.556C1289.52 123.962 1289.81 125.427 1289.73 126.63C1289.65 127.833 1289.2 128.775 1289.47 129.742C1289.69 130.73 1290.1 131.462 1290.55 131.783C1290.99 132.123 1291.7 132.181 1292.3 132.064C1292.91 131.953 1293.46 131.704 1293.91 131.501C1294.36 131.299 1294.73 131.135 1294.98 131.063L1295.18 131.541C1294.86 131.495 1294.73 131.416 1294.72 131.331C1294.71 131.24 1294.81 131.135 1295.11 131.011L1295.74 130.743L1295.31 131.488C1295.18 131.717 1294.94 132.031 1294.55 132.417C1294.17 132.796 1293.64 133.267 1292.81 133.633C1292.39 133.81 1291.91 133.953 1291.35 133.993C1290.8 134.032 1290.14 133.953 1289.52 133.646C1288.89 133.345 1288.36 132.848 1287.97 132.299C1287.57 131.75 1287.27 131.135 1287.05 130.521C1286.57 129.278 1286.36 127.853 1286.34 126.401C1286.33 124.949 1286.51 123.471 1286.74 122C1286.96 120.522 1287.25 119.058 1287.4 117.573C1287.57 116.082 1287.64 114.533 1287.6 112.97C1287.57 111.231 1287.37 109.543 1287.05 107.954C1286.88 107.163 1286.68 106.372 1286.46 105.679C1286.23 104.973 1285.93 104.306 1285.61 103.658C1284.96 102.37 1284.13 101.193 1283.31 100.082C1282.49 98.9699 1281.66 97.9237 1280.95 96.9167L1280.69 96.5374C1280.59 96.4001 1280.5 96.2693 1280.42 96.1385C1280.25 95.8835 1280.11 95.6416 1279.97 95.4127C1279.7 94.955 1279.45 94.5561 1279.2 94.2291C1279.08 94.0657 1278.96 93.9218 1278.84 93.7976C1278.78 93.7322 1278.75 93.6929 1278.66 93.621L1278.42 93.4248C1278.11 93.1698 1277.85 92.954 1277.59 92.7775C1277.09 92.4178 1276.68 92.2151 1276.38 92.0974C1276.08 91.9732 1275.89 91.9143 1275.86 91.7901L1275.85 91.7966Z"
                    fill="#1A2E35" />
                <path
                    d="M1276.96 116.233C1277.19 116.272 1277.42 116.305 1277.62 116.194C1277.83 116.083 1277.98 115.893 1278.09 115.69C1278.34 115.239 1278.42 114.703 1278.32 114.2C1278.26 113.905 1278.13 113.611 1277.88 113.441C1277.61 113.251 1277.25 113.258 1276.92 113.317C1276.27 113.428 1275.65 113.703 1275.14 114.115C1275.14 114.115 1276.14 116.096 1276.96 116.24L1276.96 116.233Z"
                    fill="#FFC3BD" />
                <path
                    d="M1276.96 116.233C1276.96 116.233 1277.06 116.24 1277.22 116.227C1277.38 116.214 1277.59 116.129 1277.77 115.919C1277.94 115.71 1278.09 115.383 1278.16 115.017C1278.22 114.651 1278.2 114.206 1278 113.853C1277.82 113.493 1277.42 113.428 1277.04 113.474C1276.66 113.52 1276.32 113.618 1276.04 113.722C1275.48 113.938 1275.17 114.16 1275.14 114.115C1275.1 114.082 1275.37 113.775 1275.93 113.48C1276.21 113.336 1276.58 113.206 1277 113.134C1277.21 113.101 1277.45 113.088 1277.7 113.16C1277.96 113.225 1278.2 113.428 1278.33 113.67C1278.58 114.154 1278.58 114.657 1278.5 115.082C1278.4 115.514 1278.2 115.867 1277.96 116.102C1277.72 116.344 1277.41 116.41 1277.22 116.377C1277.03 116.344 1276.95 116.259 1276.96 116.24L1276.96 116.233Z"
                    fill="#1A2E35" />
                <path
                    d="M1283.57 88.9052C1282.53 87.2508 1281.7 85.191 1282.42 83.3797C1282.94 82.0719 1284.29 81.1434 1285.69 81.0845C1287.1 81.0257 1288.5 81.8365 1289.18 83.0724C1289.86 84.3083 1289.79 85.9103 1289.05 87.1004C1287.96 88.8267 1285.65 89.6637 1285.03 91.5992"
                    fill="#1A2E35" />
                <path
                    d="M1263.34 128.042C1263.34 128.042 1256.71 129.304 1255.48 134.673C1254.25 140.041 1252.9 145.468 1252.9 145.468L1266.72 148.751L1263.34 128.042Z"
                    fill="#E1E1E1" />
                <path
                    d="M1262.49 143.84C1262.47 143.886 1261.72 143.513 1260.78 143.101C1259.84 142.683 1259.07 142.382 1259.08 142.329C1259.1 142.284 1259.91 142.513 1260.85 142.938C1261.8 143.356 1262.51 143.801 1262.49 143.84Z"
                    fill="#FB5607" />
                <path
                    d="M1262.49 143.84C1262.47 143.886 1261.72 143.513 1260.78 143.101C1259.84 142.683 1259.07 142.382 1259.08 142.329C1259.1 142.284 1259.91 142.513 1260.85 142.938C1261.8 143.356 1262.51 143.801 1262.49 143.84Z"
                    fill="#FB5607" />
                <path
                    d="M1259.82 135.281C1260.17 134.306 1260.49 133.528 1260.53 133.548C1260.58 133.567 1260.34 134.365 1259.99 135.339"
                    fill="#FB5607" />
                <path
                    d="M1259.82 135.281C1260.17 134.306 1260.49 133.528 1260.53 133.548C1260.58 133.567 1260.34 134.365 1259.99 135.339"
                    fill="#FB5607" />
                <path
                    d="M1299.58 128.042C1299.58 128.042 1304.52 128.264 1307.5 136.183C1309.62 141.807 1310.39 146.874 1310.39 146.874L1298.25 147.927L1299.58 128.042Z"
                    fill="#E1E1E1" />
                <path
                    d="M1262.99 180.033H1301.22L1298.88 172.429L1300.49 147.927L1299.58 128.042L1285.29 126.028L1281.53 143.284L1274.08 125.773L1262.83 128.075L1265.99 148.574L1264.89 176.012L1262.99 180.033Z"
                    fill="#E1E1E1" />
                <path
                    d="M1299.9 129.5C1299.9 129.5 1299.85 129.716 1299.73 130.089C1299.62 130.461 1299.45 131.004 1299.26 131.678C1298.87 133.025 1298.4 134.901 1298.06 137.007C1297.71 139.112 1297.56 141.048 1297.5 142.441C1297.47 143.14 1297.46 143.709 1297.45 144.095C1297.44 144.488 1297.43 144.703 1297.42 144.703C1297.41 144.703 1297.4 144.488 1297.38 144.095C1297.36 143.703 1297.36 143.134 1297.38 142.434C1297.41 141.028 1297.55 139.093 1297.89 136.974C1298.24 134.856 1298.73 132.979 1299.15 131.638C1299.36 130.971 1299.54 130.429 1299.69 130.063C1299.82 129.696 1299.91 129.494 1299.92 129.5H1299.9Z"
                    fill="#1A2E35" />
                <path
                    d="M1266.08 148.333C1266.08 148.333 1266.07 148.117 1266.08 147.724C1266.08 147.332 1266.08 146.763 1266.08 146.063C1266.05 144.664 1265.93 142.729 1265.6 140.616C1265.26 138.504 1264.77 136.628 1264.36 135.294C1264.15 134.627 1263.97 134.084 1263.84 133.718C1263.71 133.345 1263.65 133.142 1263.66 133.136C1263.67 133.129 1263.76 133.332 1263.91 133.692C1264.06 134.058 1264.25 134.588 1264.48 135.255C1264.92 136.588 1265.44 138.465 1265.78 140.59C1266.12 142.709 1266.21 144.658 1266.21 146.063C1266.21 146.763 1266.18 147.332 1266.15 147.724C1266.13 148.117 1266.11 148.333 1266.1 148.333H1266.08Z"
                    fill="#1A2E35" />
                <path
                    d="M1281.4 154.656C1281.4 154.656 1281.39 154.806 1281.34 155.074C1281.31 155.205 1281.28 155.369 1281.22 155.558C1281.17 155.741 1281.12 155.957 1281.02 156.186C1280.87 156.65 1280.63 157.18 1280.31 157.742C1279.99 158.298 1279.59 158.887 1279.11 159.449C1278.62 160.005 1278.09 160.482 1277.58 160.881C1277.06 161.267 1276.57 161.574 1276.14 161.79C1275.93 161.908 1275.72 161.993 1275.54 162.071C1275.37 162.15 1275.21 162.208 1275.08 162.248C1274.82 162.333 1274.68 162.378 1274.67 162.365C1274.66 162.333 1275.23 162.143 1276.07 161.679C1276.49 161.45 1276.97 161.136 1277.47 160.75C1277.97 160.351 1278.49 159.88 1278.97 159.331C1279.44 158.775 1279.84 158.2 1280.17 157.657C1280.48 157.108 1280.73 156.591 1280.9 156.14C1281.25 155.244 1281.36 154.649 1281.39 154.656H1281.4Z"
                    fill="#1A2E35" />
                <path
                    d="M1277.67 156.062C1277.62 156.062 1277.53 154.989 1277.3 153.675C1277.08 152.361 1276.81 151.314 1276.86 151.301C1276.88 151.301 1276.98 151.55 1277.1 151.968C1277.22 152.393 1277.36 152.982 1277.47 153.642C1277.58 154.303 1277.65 154.904 1277.68 155.342C1277.7 155.78 1277.7 156.055 1277.68 156.055L1277.67 156.062Z"
                    fill="#FB5607" />
                <path
                    d="M1277.67 156.062C1277.62 156.062 1277.53 154.989 1277.3 153.675C1277.08 152.361 1276.81 151.314 1276.86 151.301C1276.88 151.301 1276.98 151.55 1277.1 151.968C1277.22 152.393 1277.36 152.982 1277.47 153.642C1277.58 154.303 1277.65 154.904 1277.68 155.342C1277.7 155.78 1277.7 156.055 1277.68 156.055L1277.67 156.062Z"
                    fill="#FB5607" />
                <path
                    d="M1284.86 151.203C1284.82 151.236 1284.21 150.484 1283.39 149.634C1282.57 148.777 1281.84 148.143 1281.87 148.103C1281.9 148.064 1282.68 148.646 1283.52 149.509C1284.35 150.372 1284.9 151.177 1284.86 151.203H1284.86Z"
                    fill="#FB5607" />
                <path
                    d="M1284.86 151.203C1284.82 151.236 1284.21 150.484 1283.39 149.634C1282.57 148.777 1281.84 148.143 1281.87 148.103C1281.9 148.064 1282.68 148.646 1283.52 149.509C1284.35 150.372 1284.9 151.177 1284.86 151.203H1284.86Z"
                    fill="#FB5607" />
                <path
                    d="M1285.82 161.293C1285.85 161.338 1285.09 161.803 1284.13 162.332C1283.17 162.862 1282.38 163.261 1282.36 163.222C1282.33 163.176 1283.09 162.712 1284.05 162.182C1285.01 161.652 1285.8 161.253 1285.82 161.293Z"
                    fill="#FB5607" />
                <path
                    d="M1285.82 161.293C1285.85 161.338 1285.09 161.803 1284.13 162.332C1283.17 162.862 1282.38 163.261 1282.36 163.222C1282.33 163.176 1283.09 162.712 1284.05 162.182C1285.01 161.652 1285.8 161.253 1285.82 161.293Z"
                    fill="#FB5607" />
                <path
                    d="M1275.25 171.042C1275.2 171.029 1275.38 170.081 1275.66 168.917C1275.93 167.753 1276.19 166.818 1276.25 166.831C1276.29 166.844 1276.11 167.792 1275.84 168.956C1275.56 170.12 1275.3 171.055 1275.25 171.042Z"
                    fill="#FB5607" />
                <path
                    d="M1275.25 171.042C1275.2 171.029 1275.38 170.081 1275.66 168.917C1275.93 167.753 1276.19 166.818 1276.25 166.831C1276.29 166.844 1276.11 167.792 1275.84 168.956C1275.56 170.12 1275.3 171.055 1275.25 171.042Z"
                    fill="#FB5607" />
                <path
                    d="M1288.17 173.043C1288.13 173.07 1287.62 172.448 1287.04 171.651C1286.46 170.853 1286.03 170.186 1286.06 170.153C1286.1 170.127 1286.61 170.748 1287.19 171.546C1287.77 172.344 1288.21 173.011 1288.17 173.043Z"
                    fill="#FB5607" />
                <path
                    d="M1288.17 173.043C1288.13 173.07 1287.62 172.448 1287.04 171.651C1286.46 170.853 1286.03 170.186 1286.06 170.153C1286.1 170.127 1286.61 170.748 1287.19 171.546C1287.77 172.344 1288.21 173.011 1288.17 173.043Z"
                    fill="#FB5607" />
                <path
                    d="M1281.43 175.581C1281.38 175.581 1281.27 174.887 1281.34 174.018C1281.4 173.148 1281.61 172.468 1281.65 172.481C1281.7 172.494 1281.57 173.181 1281.51 174.031C1281.45 174.881 1281.48 175.581 1281.43 175.581Z"
                    fill="#FB5607" />
                <path
                    d="M1281.43 175.581C1281.38 175.581 1281.27 174.887 1281.34 174.018C1281.4 173.148 1281.61 172.468 1281.65 172.481C1281.7 172.494 1281.57 173.181 1281.51 174.031C1281.45 174.881 1281.48 175.581 1281.43 175.581Z"
                    fill="#FB5607" />
                <path
                    d="M1274.56 179.249C1274.53 179.288 1273.83 178.719 1273.01 177.987C1272.18 177.255 1271.54 176.627 1271.57 176.594C1271.61 176.555 1272.3 177.124 1273.13 177.856C1273.95 178.589 1274.59 179.216 1274.56 179.249Z"
                    fill="#FB5607" />
                <path
                    d="M1274.56 179.249C1274.53 179.288 1273.83 178.719 1273.01 177.987C1272.18 177.255 1271.54 176.627 1271.57 176.594C1271.61 176.555 1272.3 177.124 1273.13 177.856C1273.95 178.589 1274.59 179.216 1274.56 179.249Z"
                    fill="#FB5607" />
                <path
                    d="M1292.05 177.32C1292.05 177.372 1291.28 177.411 1290.33 177.411C1289.39 177.411 1288.62 177.372 1288.62 177.326C1288.62 177.274 1289.39 177.235 1290.33 177.235C1291.28 177.235 1292.05 177.274 1292.05 177.32Z"
                    fill="#FB5607" />
                <path
                    d="M1292.05 177.32C1292.05 177.372 1291.28 177.411 1290.33 177.411C1289.39 177.411 1288.62 177.372 1288.62 177.326C1288.62 177.274 1289.39 177.235 1290.33 177.235C1291.28 177.235 1292.05 177.274 1292.05 177.32Z"
                    fill="#FB5607" />
                <path
                    d="M1293.92 134.581C1293.87 134.568 1294.06 133.79 1294.34 132.842C1294.62 131.894 1294.89 131.135 1294.94 131.155C1294.98 131.168 1294.79 131.946 1294.51 132.894C1294.23 133.842 1293.96 134.594 1293.92 134.581Z"
                    fill="#FB5607" />
                <path
                    d="M1293.92 134.581C1293.87 134.568 1294.06 133.79 1294.34 132.842C1294.62 131.894 1294.89 131.135 1294.94 131.155C1294.98 131.168 1294.79 131.946 1294.51 132.894C1294.23 133.842 1293.96 134.594 1293.92 134.581Z"
                    fill="#FB5607" />
                <path
                    d="M1296.14 140.015C1296.1 140.034 1295.84 139.453 1295.56 138.714C1295.29 137.981 1295.1 137.373 1295.15 137.354C1295.2 137.334 1295.46 137.916 1295.73 138.655C1296.01 139.387 1296.2 139.995 1296.14 140.015Z"
                    fill="#FB5607" />
                <path
                    d="M1296.14 140.015C1296.1 140.034 1295.84 139.453 1295.56 138.714C1295.29 137.981 1295.1 137.373 1295.15 137.354C1295.2 137.334 1295.46 137.916 1295.73 138.655C1296.01 139.387 1296.2 139.995 1296.14 140.015Z"
                    fill="#FB5607" />
                <path
                    d="M1295.93 128.67C1295.92 128.715 1294.95 128.604 1293.76 128.421C1292.57 128.232 1291.61 128.042 1291.62 127.996C1291.63 127.95 1292.6 128.062 1293.79 128.245C1294.97 128.434 1295.93 128.624 1295.93 128.67Z"
                    fill="#FB5607" />
                <path
                    d="M1295.93 128.67C1295.92 128.715 1294.95 128.604 1293.76 128.421C1292.57 128.232 1291.61 128.042 1291.62 127.996C1291.63 127.95 1292.6 128.062 1293.79 128.245C1294.97 128.434 1295.93 128.624 1295.93 128.67Z"
                    fill="#FB5607" />
                <path
                    d="M1302.95 138.491C1302.9 138.517 1302.46 137.765 1301.97 136.824C1301.48 135.875 1301.11 135.091 1301.16 135.071C1301.2 135.052 1301.64 135.797 1302.13 136.739C1302.63 137.687 1302.99 138.471 1302.95 138.491Z"
                    fill="#FB5607" />
                <path
                    d="M1302.95 138.491C1302.9 138.517 1302.46 137.765 1301.97 136.824C1301.48 135.875 1301.11 135.091 1301.16 135.071C1301.2 135.052 1301.64 135.797 1302.13 136.739C1302.63 137.687 1302.99 138.471 1302.95 138.491Z"
                    fill="#FB5607" />
                <path
                    d="M1305.08 141.669C1305.03 141.656 1305.27 140.773 1305.6 139.701C1305.93 138.628 1306.25 137.772 1306.29 137.785C1306.34 137.798 1306.1 138.681 1305.77 139.753C1305.44 140.825 1305.13 141.682 1305.08 141.669Z"
                    fill="#FB5607" />
                <path
                    d="M1305.08 141.669C1305.03 141.656 1305.27 140.773 1305.6 139.701C1305.93 138.628 1306.25 137.772 1306.29 137.785C1306.34 137.798 1306.1 138.681 1305.77 139.753C1305.44 140.825 1305.13 141.682 1305.08 141.669Z"
                    fill="#FB5607" />
                <path
                    d="M1301.67 146.109C1301.63 146.129 1301.22 145.338 1300.6 144.422C1299.99 143.507 1299.42 142.82 1299.46 142.787C1299.49 142.755 1300.14 143.395 1300.75 144.324C1301.37 145.253 1301.71 146.09 1301.67 146.109Z"
                    fill="#FB5607" />
                <path
                    d="M1301.67 146.109C1301.63 146.129 1301.22 145.338 1300.6 144.422C1299.99 143.507 1299.42 142.82 1299.46 142.787C1299.49 142.755 1300.14 143.395 1300.75 144.324C1301.37 145.253 1301.71 146.09 1301.67 146.109Z"
                    fill="#FB5607" />
                <path
                    d="M1267.05 132.92C1267 132.92 1267.04 132.292 1267.13 131.527C1267.22 130.762 1267.33 130.147 1267.38 130.154C1267.43 130.154 1267.39 130.782 1267.3 131.547C1267.21 132.312 1267.1 132.926 1267.05 132.92Z"
                    fill="#FB5607" />
                <path
                    d="M1267.05 132.92C1267 132.92 1267.04 132.292 1267.13 131.527C1267.22 130.762 1267.33 130.147 1267.38 130.154C1267.43 130.154 1267.39 130.782 1267.3 131.547C1267.21 132.312 1267.1 132.926 1267.05 132.92Z"
                    fill="#FB5607" />
                <path
                    d="M1274.35 130.592C1274.31 130.605 1274.16 130.167 1274.05 129.611C1273.92 129.062 1273.86 128.604 1273.91 128.598C1273.96 128.585 1274.1 129.023 1274.22 129.579C1274.34 130.128 1274.4 130.586 1274.35 130.592Z"
                    fill="#FB5607" />
                <path
                    d="M1274.35 130.592C1274.31 130.605 1274.16 130.167 1274.05 129.611C1273.92 129.062 1273.86 128.604 1273.91 128.598C1273.96 128.585 1274.1 129.023 1274.22 129.579C1274.34 130.128 1274.4 130.586 1274.35 130.592Z"
                    fill="#FB5607" />
                <path
                    d="M1289.45 126.945L1283.86 124.336L1280.63 126.455C1280.63 126.455 1281.76 127.403 1283.26 126.997C1284.75 126.598 1285.04 126.428 1285.04 126.428L1287.39 128.639L1290.33 128.658L1289.45 126.945Z"
                    fill="#FFBF9D" />
                <path
                    d="M1286.57 127.141C1286.57 127.141 1289.11 126.664 1289.5 127.141C1289.88 127.619 1292.08 132.392 1292.13 133.438C1292.18 134.485 1292.42 134.884 1292.42 134.884L1294.61 141.082L1286.84 146.477C1286.84 146.477 1286.34 142.547 1285.38 141.73C1284.42 140.912 1282.11 137.983 1282.11 137.983C1282.11 137.983 1280.61 132.634 1281.04 131.026C1281.46 129.423 1283.8 127.952 1283.8 127.952L1286.58 127.135L1286.57 127.141Z"
                    fill="#FFBF9D" />
                <path
                    d="M1285.29 134.929C1285.26 134.968 1284.82 134.713 1284.43 134.223C1284.04 133.739 1283.88 133.249 1283.93 133.235C1283.98 133.216 1284.2 133.654 1284.57 134.112C1284.94 134.576 1285.32 134.883 1285.29 134.929Z"
                    fill="#FFBF9D" />
                <path
                    d="M1287.54 132.503C1287.53 132.548 1286.97 132.424 1286.37 132.077C1285.76 131.737 1285.38 131.319 1285.41 131.286C1285.44 131.247 1285.87 131.594 1286.46 131.921C1287.04 132.254 1287.55 132.45 1287.54 132.496V132.503Z"
                    fill="#FFBF9D" />
                <path
                    d="M1289.7 130.188C1289.67 130.227 1289.18 129.828 1288.53 129.423C1287.89 129.011 1287.31 128.756 1287.33 128.71C1287.34 128.664 1287.96 128.854 1288.62 129.272C1289.29 129.691 1289.73 130.155 1289.69 130.188H1289.7Z"
                    fill="#FFBF9D" />
                <path
                    d="M1268.6 125.958C1268.6 125.958 1269.27 129.999 1269.13 130.973C1268.99 131.947 1269.03 133.706 1269.15 135.367C1269.27 137.028 1269.15 140.101 1269.15 140.101C1269.15 140.101 1277.22 145.032 1277.27 144.836C1277.32 144.639 1280.24 141.468 1281.46 139.467C1282.68 137.466 1283.22 137.172 1282.78 136.145C1282.34 135.119 1282.01 135.557 1282.93 134.046C1283.5 133.111 1285.22 130.927 1286.44 129.384C1287.01 128.678 1286.55 127.625 1285.65 127.553C1285.65 127.553 1285.99 126.232 1284.92 126.33C1283.85 126.428 1283.56 126.867 1282.43 128.233C1281.31 129.6 1280.05 131.117 1280.05 131.117L1275.76 132.091C1275.76 132.091 1273.03 132.385 1272.59 131.313C1272.15 130.241 1272.45 129.24 1272.1 128.03C1271.76 126.821 1271.13 125.408 1270.1 125.062C1269.08 124.722 1268.6 125.062 1268.6 125.062V125.951V125.958Z"
                    fill="#FFBF9D" />
                <path
                    d="M1285.65 127.559C1285.65 127.559 1285.61 127.722 1285.5 128.003C1285.4 128.285 1285.24 128.69 1285.01 129.174C1284.54 130.135 1283.81 131.456 1282.65 132.633C1281.49 133.817 1280.15 134.536 1279.15 134.915C1278.65 135.105 1278.22 135.216 1277.93 135.281C1277.64 135.347 1277.47 135.366 1277.47 135.353C1277.46 135.321 1278.11 135.203 1279.1 134.797C1280.08 134.392 1281.38 133.666 1282.52 132.509C1283.66 131.351 1284.4 130.057 1284.89 129.115C1285.13 128.638 1285.31 128.245 1285.44 127.977C1285.56 127.703 1285.63 127.552 1285.64 127.559H1285.65Z"
                    fill="#FFBF9D" />
                <path
                    d="M1279.61 138.303C1279.58 138.257 1280.25 137.937 1280.65 137.165C1281.06 136.4 1280.95 135.668 1281.01 135.668C1281.03 135.668 1281.09 135.838 1281.1 136.139C1281.1 136.433 1281.02 136.852 1280.81 137.25C1280.59 137.656 1280.29 137.95 1280.05 138.107C1279.8 138.27 1279.62 138.316 1279.61 138.303Z"
                    fill="#FFBF9D" />
                <path
                    d="M1269.14 140.108C1269.14 140.108 1269.14 140.023 1269.14 139.846C1269.14 139.67 1269.14 139.415 1269.16 139.094C1269.16 138.434 1269.18 137.466 1269.14 136.23C1269.09 135.001 1268.92 133.49 1268.99 131.751C1269 131.535 1269.02 131.313 1269.05 131.091C1269.08 130.868 1269.09 130.652 1269.08 130.424C1269.06 129.966 1269.01 129.495 1268.96 129.011C1268.85 128.043 1268.7 127.03 1268.52 125.977V125.964C1268.52 125.689 1268.52 125.389 1268.52 125.075V125.029L1268.56 125.009C1269 124.767 1269.49 124.826 1269.94 124.937C1270.4 125.048 1270.82 125.356 1271.12 125.742C1271.43 126.121 1271.66 126.559 1271.85 127.017C1272.03 127.474 1272.19 127.952 1272.29 128.455C1272.38 128.959 1272.38 129.475 1272.41 129.985C1272.43 130.24 1272.46 130.495 1272.51 130.744C1272.57 130.986 1272.64 131.261 1272.77 131.444C1272.92 131.633 1273.15 131.751 1273.39 131.836C1273.63 131.921 1273.89 131.967 1274.15 131.999C1274.67 132.058 1275.21 132.058 1275.75 132.006H1275.74C1276.86 131.751 1278.05 131.483 1279.26 131.208C1279.52 131.149 1279.78 131.091 1280.03 131.032L1279.98 131.064C1280.64 130.267 1281.3 129.475 1281.94 128.697L1282.9 127.54C1283.22 127.167 1283.54 126.762 1283.99 126.507C1284.21 126.382 1284.46 126.311 1284.71 126.278C1284.94 126.245 1285.23 126.206 1285.46 126.363C1285.71 126.52 1285.78 126.814 1285.78 127.056C1285.78 127.18 1285.78 127.304 1285.76 127.429L1285.74 127.52L1285.73 127.566V127.579C1285.58 127.37 1285.69 127.52 1285.67 127.474H1285.69C1285.75 127.488 1285.82 127.494 1285.87 127.514C1286.37 127.638 1286.74 128.102 1286.76 128.599C1286.78 128.848 1286.72 129.096 1286.6 129.305C1286.46 129.515 1286.32 129.665 1286.18 129.848C1285.07 131.254 1284.01 132.581 1283.11 133.896C1282.9 134.229 1282.7 134.563 1282.52 134.896C1282.43 135.066 1282.36 135.236 1282.43 135.38C1282.51 135.53 1282.62 135.694 1282.71 135.864C1282.87 136.191 1283.04 136.557 1282.98 136.936C1282.92 137.309 1282.72 137.616 1282.55 137.898C1282.17 138.466 1281.81 138.996 1281.5 139.513C1281.18 140.036 1280.84 140.494 1280.52 140.925C1279.86 141.782 1279.27 142.488 1278.79 143.063C1278.3 143.632 1277.92 144.07 1277.66 144.378C1277.4 144.679 1277.27 144.842 1277.27 144.842C1277.26 144.842 1277.38 144.659 1277.62 144.352C1277.88 144.038 1278.25 143.593 1278.73 143.018C1279.2 142.436 1279.79 141.723 1280.43 140.866C1281.09 140.023 1281.68 138.957 1282.44 137.832C1282.62 137.551 1282.81 137.25 1282.85 136.917C1282.9 136.583 1282.75 136.243 1282.59 135.923C1282.51 135.759 1282.4 135.622 1282.31 135.432C1282.26 135.334 1282.26 135.21 1282.29 135.112C1282.32 135.014 1282.36 134.922 1282.4 134.831C1282.58 134.484 1282.79 134.151 1283 133.811C1283.89 132.483 1284.95 131.156 1286.06 129.743C1286.19 129.567 1286.35 129.39 1286.46 129.214C1286.57 129.031 1286.62 128.815 1286.6 128.606C1286.57 128.181 1286.25 127.782 1285.83 127.671C1285.78 127.651 1285.72 127.651 1285.67 127.638H1285.65C1285.61 127.586 1285.71 127.743 1285.56 127.527V127.474L1285.59 127.389C1285.6 127.278 1285.61 127.161 1285.61 127.049C1285.6 126.827 1285.54 126.598 1285.36 126.494C1285.19 126.376 1284.95 126.402 1284.72 126.435C1284.48 126.467 1284.26 126.533 1284.06 126.651C1283.66 126.879 1283.34 127.272 1283.02 127.644C1282.71 128.03 1282.39 128.416 1282.07 128.802C1281.42 129.58 1280.77 130.371 1280.11 131.169L1280.09 131.195H1280.06C1279.82 131.254 1279.56 131.319 1279.29 131.378C1278.09 131.653 1276.9 131.921 1275.77 132.183H1275.76C1275.2 132.235 1274.66 132.235 1274.12 132.176C1273.85 132.143 1273.58 132.098 1273.32 131.999C1273.06 131.908 1272.8 131.777 1272.62 131.548L1272.51 131.359C1272.48 131.293 1272.46 131.234 1272.43 131.169C1272.39 131.038 1272.36 130.914 1272.33 130.783C1272.27 130.522 1272.24 130.26 1272.23 129.998C1272.2 129.482 1272.2 128.972 1272.11 128.481C1272.02 127.998 1271.86 127.527 1271.68 127.076C1271.5 126.631 1271.28 126.199 1270.98 125.84C1270.7 125.474 1270.33 125.192 1269.89 125.088C1269.46 124.97 1268.98 124.937 1268.63 125.133L1268.67 125.068C1268.67 125.375 1268.67 125.683 1268.67 125.957V125.944C1268.84 127.004 1268.98 128.024 1269.09 128.991C1269.14 129.475 1269.19 129.953 1269.2 130.417C1269.2 130.535 1269.2 130.652 1269.2 130.764C1269.19 130.881 1269.18 130.999 1269.17 131.104C1269.14 131.326 1269.12 131.542 1269.11 131.757C1269.03 133.484 1269.19 134.988 1269.23 136.224C1269.26 137.466 1269.22 138.434 1269.2 139.094C1269.18 139.415 1269.17 139.67 1269.16 139.846C1269.16 140.016 1269.14 140.101 1269.14 140.101V140.108Z"
                    fill="#FFBF9D" />
                <path
                    d="M1309.45 146.967C1309.45 147.405 1308.92 160.411 1307.5 164.799C1306.08 169.187 1303.79 178.152 1299.97 178.021C1296.17 177.89 1293.85 175.7 1292.44 170.991C1291.02 166.283 1286.78 146.104 1286.78 146.104L1294.15 139.644L1299.26 155.703L1299.02 147.935L1309.45 146.967Z"
                    fill="#FFBF9D" />
                <path
                    d="M1299.26 155.703C1299.26 155.703 1299.34 155.88 1299.45 156.194C1299.58 156.514 1299.77 156.965 1300.06 157.495C1300.35 158.024 1300.76 158.626 1301.24 159.267C1301.72 159.914 1302.27 160.607 1302.79 161.386C1303.85 162.922 1304.54 164.518 1304.71 165.747C1304.8 166.355 1304.79 166.859 1304.75 167.199C1304.73 167.369 1304.7 167.499 1304.68 167.591C1304.66 167.683 1304.65 167.722 1304.64 167.722C1304.6 167.722 1304.79 166.963 1304.58 165.767C1304.39 164.57 1303.7 163.014 1302.64 161.484C1302.12 160.719 1301.58 160.019 1301.11 159.365C1300.63 158.711 1300.24 158.096 1299.96 157.554C1299.67 157.011 1299.49 156.547 1299.39 156.22C1299.34 156.056 1299.31 155.925 1299.29 155.84C1299.27 155.755 1299.26 155.703 1299.26 155.703H1299.26Z"
                    fill="#FFBF9D" />
                <path
                    d="M1254.74 145.908C1254.74 145.908 1254.23 158.365 1254.74 164.178C1255.25 169.991 1255.57 175.49 1257.07 177.008C1258.59 178.525 1261.61 180.303 1264.31 178.021C1267.02 175.732 1269.56 170.554 1270.91 166.414C1272.26 162.269 1274.47 154.729 1274.47 154.729C1274.61 153.925 1277.26 144.855 1277.26 144.855L1269.14 140.121L1265.85 151.296L1265.98 148.589L1254.72 145.915L1254.74 145.908Z"
                    fill="#FFBF9D" />
                <path
                    d="M1266.66 149.047C1266.66 149.047 1266.65 149.125 1266.6 149.262C1266.55 149.419 1266.49 149.622 1266.41 149.87L1266.27 150.309C1266.21 150.466 1266.13 150.636 1266.06 150.812C1265.9 151.172 1265.74 151.59 1265.51 152.028L1265.16 152.721C1265.04 152.963 1264.89 153.199 1264.75 153.454C1264.47 153.964 1264.14 154.487 1263.8 155.043C1263.09 156.141 1262.28 157.325 1261.42 158.561C1260.57 159.797 1259.77 160.987 1259.1 162.098C1258.78 162.661 1258.45 163.19 1258.2 163.714C1258.07 163.969 1257.94 164.217 1257.82 164.459L1257.51 165.165C1257.3 165.61 1257.17 166.035 1257.03 166.401C1256.96 166.584 1256.9 166.754 1256.85 166.911C1256.8 167.068 1256.76 167.218 1256.72 167.349L1256.55 167.957C1256.51 168.095 1256.48 168.167 1256.47 168.167C1256.47 168.167 1256.48 168.088 1256.51 167.951C1256.55 167.794 1256.6 167.585 1256.66 167.33L1256.76 166.885C1256.81 166.721 1256.87 166.551 1256.93 166.362C1257.05 165.989 1257.19 165.558 1257.39 165.106L1257.69 164.394C1257.8 164.145 1257.93 163.897 1258.06 163.642C1258.31 163.112 1258.63 162.582 1258.95 162.013C1259.62 160.895 1260.41 159.692 1261.27 158.456C1262.13 157.22 1262.95 156.043 1263.65 154.951C1264 154.402 1264.34 153.879 1264.62 153.375C1264.76 153.127 1264.91 152.885 1265.04 152.65L1265.39 151.963C1265.63 151.531 1265.8 151.119 1265.96 150.766C1266.04 150.59 1266.12 150.426 1266.18 150.269L1266.34 149.838L1266.57 149.243C1266.62 149.105 1266.65 149.04 1266.66 149.04L1266.66 149.047Z"
                    fill="#FFBF9D" />
                <path
                    d="M1268.65 123.12C1268.65 123.12 1269.42 121.393 1271.27 120.838C1273.12 120.282 1272.42 119.635 1273.26 118.614C1274.09 117.594 1275.12 116.522 1275.12 116.522L1277.05 115.521C1277.05 115.521 1279 116.816 1279.6 117.738C1280.19 118.66 1281.03 120.563 1281.83 121.165C1282.64 121.766 1285.67 123.067 1285.63 124.428L1276.65 125.186L1268.65 123.12H1268.65Z"
                    fill="#FB5607" />
                <path
                    d="M1268.65 123.12C1268.65 123.12 1269.42 121.393 1271.27 120.838C1273.12 120.282 1272.42 119.635 1273.26 118.614C1274.09 117.594 1275.12 116.522 1275.12 116.522L1277.05 115.521C1277.05 115.521 1279 116.816 1279.6 117.738C1280.19 118.66 1281.03 120.563 1281.83 121.165C1282.64 121.766 1285.67 123.067 1285.63 124.428L1276.65 125.186L1268.65 123.12H1268.65Z"
                    fill="#FB5607" />
                <g opacity="0.3">
                    <path
                        d="M1268.65 123.12C1268.65 123.12 1269.42 121.393 1271.27 120.838C1273.12 120.282 1272.42 119.635 1273.26 118.614C1274.09 117.594 1275.12 116.522 1275.12 116.522L1277.05 115.521C1277.05 115.521 1279 116.816 1279.6 117.738C1280.19 118.66 1281.03 120.563 1281.83 121.165C1282.64 121.766 1285.67 123.067 1285.63 124.428L1276.65 125.186L1268.65 123.12H1268.65Z"
                        fill="black" fill-opacity="0.46" />
                </g>
                <path
                    d="M1268.72 125.539C1267.88 125.618 1266.97 125.382 1266.44 124.735C1265.9 124.088 1265.91 122.982 1266.58 122.485C1267.16 122.06 1267.97 122.185 1268.64 122.433C1269.31 122.682 1269.98 123.041 1270.7 123.028C1271.42 123.015 1272.08 122.623 1272.79 122.557C1274.45 122.414 1275.92 124.022 1277.56 123.761C1278.28 123.643 1278.94 123.179 1279.66 123.264C1280.38 123.349 1280.93 123.97 1281.63 124.192C1282.28 124.395 1282.98 124.238 1283.62 124.035C1284.26 123.833 1284.9 123.578 1285.58 123.584C1286.26 123.591 1286.98 123.95 1287.18 124.598C1287.4 125.317 1286.85 126.088 1286.17 126.396C1285.48 126.703 1284.7 126.657 1283.95 126.612C1278.89 126.291 1273.82 125.971 1268.77 125.65"
                    fill="#FB5607" />
                <path
                    d="M1268.72 125.539C1267.88 125.618 1266.97 125.382 1266.44 124.735C1265.9 124.088 1265.91 122.982 1266.58 122.485C1267.16 122.06 1267.97 122.185 1268.64 122.433C1269.31 122.682 1269.98 123.041 1270.7 123.028C1271.42 123.015 1272.08 122.623 1272.79 122.557C1274.45 122.414 1275.92 124.022 1277.56 123.761C1278.28 123.643 1278.94 123.179 1279.66 123.264C1280.38 123.349 1280.93 123.97 1281.63 124.192C1282.28 124.395 1282.98 124.238 1283.62 124.035C1284.26 123.833 1284.9 123.578 1285.58 123.584C1286.26 123.591 1286.98 123.95 1287.18 124.598C1287.4 125.317 1286.85 126.088 1286.17 126.396C1285.48 126.703 1284.7 126.657 1283.95 126.612C1278.89 126.291 1273.82 125.971 1268.77 125.65"
                    fill="#FB5607" />
                <path
                    d="M1281.36 121.243C1281.23 121.139 1281.08 121.08 1280.92 121.028C1280.33 120.825 1279.73 120.655 1279.11 120.537C1279 120.518 1278.89 120.491 1278.8 120.426C1278.71 120.361 1278.65 120.236 1278.7 120.132C1278.74 120.04 1278.84 120.001 1278.94 119.975C1279.25 119.87 1279.56 119.772 1279.87 119.667C1279.95 119.641 1280.04 119.602 1280.05 119.517C1280.07 119.406 1279.93 119.341 1279.82 119.314L1278.03 118.857C1278.26 118.471 1278.98 118.556 1279.11 118.131C1279.2 117.823 1278.87 117.549 1278.56 117.444C1277.99 117.255 1277.34 117.333 1276.82 117.64C1276.67 117.549 1276.72 117.313 1276.82 117.17C1276.92 117.026 1277.05 116.869 1277.02 116.699C1276.99 116.542 1276.82 116.431 1276.66 116.431C1276.5 116.431 1276.36 116.516 1276.23 116.62C1275.85 116.954 1275.7 117.529 1275.85 118.013C1275.01 118.183 1274.22 118.582 1273.57 119.157C1273.43 119.288 1273.28 119.491 1273.37 119.661C1273.45 119.818 1273.67 119.824 1273.85 119.811L1275.44 119.681C1275.11 120.164 1274.51 120.393 1273.94 120.511C1273.36 120.629 1272.76 120.681 1272.23 120.936C1272.1 121.001 1271.96 121.099 1271.95 121.25C1271.94 121.381 1272.05 121.498 1272.17 121.544C1272.3 121.59 1272.43 121.583 1272.56 121.57C1273.68 121.492 1274.8 121.407 1275.91 121.328C1276.01 121.322 1276.12 121.322 1276.19 121.394C1276.26 121.472 1276.24 121.59 1276.19 121.681C1276.14 121.773 1276.06 121.845 1276.01 121.936C1275.85 122.211 1276 122.597 1276.27 122.767C1276.53 122.943 1276.89 122.943 1277.19 122.858C1277.5 122.773 1277.79 122.617 1278.07 122.486C1278.86 122.139 1279.73 121.989 1280.58 122.048C1280.77 122.061 1280.97 122.087 1281.15 122.041C1281.33 121.995 1281.51 121.858 1281.55 121.668C1281.57 121.505 1281.49 121.341 1281.36 121.237V121.243Z"
                    fill="#FB5607" />
                <path
                    d="M1281.36 121.243C1281.23 121.139 1281.08 121.08 1280.92 121.028C1280.33 120.825 1279.73 120.655 1279.11 120.537C1279 120.518 1278.89 120.491 1278.8 120.426C1278.71 120.361 1278.65 120.236 1278.7 120.132C1278.74 120.04 1278.84 120.001 1278.94 119.975C1279.25 119.87 1279.56 119.772 1279.87 119.667C1279.95 119.641 1280.04 119.602 1280.05 119.517C1280.07 119.406 1279.93 119.341 1279.82 119.314L1278.03 118.857C1278.26 118.471 1278.98 118.556 1279.11 118.131C1279.2 117.823 1278.87 117.549 1278.56 117.444C1277.99 117.255 1277.34 117.333 1276.82 117.64C1276.67 117.549 1276.72 117.313 1276.82 117.17C1276.92 117.026 1277.05 116.869 1277.02 116.699C1276.99 116.542 1276.82 116.431 1276.66 116.431C1276.5 116.431 1276.36 116.516 1276.23 116.62C1275.85 116.954 1275.7 117.529 1275.85 118.013C1275.01 118.183 1274.22 118.582 1273.57 119.157C1273.43 119.288 1273.28 119.491 1273.37 119.661C1273.45 119.818 1273.67 119.824 1273.85 119.811L1275.44 119.681C1275.11 120.164 1274.51 120.393 1273.94 120.511C1273.36 120.629 1272.76 120.681 1272.23 120.936C1272.1 121.001 1271.96 121.099 1271.95 121.25C1271.94 121.381 1272.05 121.498 1272.17 121.544C1272.3 121.59 1272.43 121.583 1272.56 121.57C1273.68 121.492 1274.8 121.407 1275.91 121.328C1276.01 121.322 1276.12 121.322 1276.19 121.394C1276.26 121.472 1276.24 121.59 1276.19 121.681C1276.14 121.773 1276.06 121.845 1276.01 121.936C1275.85 122.211 1276 122.597 1276.27 122.767C1276.53 122.943 1276.89 122.943 1277.19 122.858C1277.5 122.773 1277.79 122.617 1278.07 122.486C1278.86 122.139 1279.73 121.989 1280.58 122.048C1280.77 122.061 1280.97 122.087 1281.15 122.041C1281.33 121.995 1281.51 121.858 1281.55 121.668C1281.57 121.505 1281.49 121.341 1281.36 121.237V121.243Z"
                    fill="#FB5607" />
                <g opacity="0.5">
                    <path
                        d="M1281.36 121.243C1281.23 121.139 1281.08 121.08 1280.92 121.028C1280.33 120.825 1279.73 120.655 1279.11 120.537C1279 120.518 1278.89 120.491 1278.8 120.426C1278.71 120.361 1278.65 120.236 1278.7 120.132C1278.74 120.04 1278.84 120.001 1278.94 119.975C1279.25 119.87 1279.56 119.772 1279.87 119.667C1279.95 119.641 1280.04 119.602 1280.05 119.517C1280.07 119.406 1279.93 119.341 1279.82 119.314L1278.03 118.857C1278.26 118.471 1278.98 118.556 1279.11 118.131C1279.2 117.823 1278.87 117.549 1278.56 117.444C1277.99 117.255 1277.34 117.333 1276.82 117.64C1276.67 117.549 1276.72 117.313 1276.82 117.17C1276.92 117.026 1277.05 116.869 1277.02 116.699C1276.99 116.542 1276.82 116.431 1276.66 116.431C1276.5 116.431 1276.36 116.516 1276.23 116.62C1275.85 116.954 1275.7 117.529 1275.85 118.013C1275.01 118.183 1274.22 118.582 1273.57 119.157C1273.43 119.288 1273.28 119.491 1273.37 119.661C1273.45 119.818 1273.67 119.824 1273.85 119.811L1275.44 119.681C1275.11 120.164 1274.51 120.393 1273.94 120.511C1273.36 120.629 1272.76 120.681 1272.23 120.936C1272.1 121.001 1271.96 121.099 1271.95 121.25C1271.94 121.381 1272.05 121.498 1272.17 121.544C1272.3 121.59 1272.43 121.583 1272.56 121.57C1273.68 121.492 1274.8 121.407 1275.91 121.328C1276.01 121.322 1276.12 121.322 1276.19 121.394C1276.26 121.472 1276.24 121.59 1276.19 121.681C1276.14 121.773 1276.06 121.845 1276.01 121.936C1275.85 122.211 1276 122.597 1276.27 122.767C1276.53 122.943 1276.89 122.943 1277.19 122.858C1277.5 122.773 1277.79 122.617 1278.07 122.486C1278.86 122.139 1279.73 121.989 1280.58 122.048C1280.77 122.061 1280.97 122.087 1281.15 122.041C1281.33 121.995 1281.51 121.858 1281.55 121.668C1281.57 121.505 1281.49 121.341 1281.36 121.237V121.243Z"
                        fill="white" />
                </g>
                <path
                    d="M1278.71 118.124C1278.71 118.739 1277.9 119.236 1276.92 119.236C1275.93 119.236 1275.13 118.739 1275.13 118.124C1275.13 117.51 1275.93 117.013 1276.92 117.013C1277.9 117.013 1278.71 117.51 1278.71 118.124Z"
                    fill="#FB5607" />
                <path
                    d="M1278.71 118.124C1278.71 118.739 1277.9 119.236 1276.92 119.236C1275.93 119.236 1275.13 118.739 1275.13 118.124C1275.13 117.51 1275.93 117.013 1276.92 117.013C1277.9 117.013 1278.71 117.51 1278.71 118.124Z"
                    fill="#FB5607" />
                <path
                    d="M1277.5 118.713C1277.52 118.758 1277.49 118.817 1277.43 118.843C1277.37 118.869 1277.3 118.856 1277.28 118.811C1277.25 118.765 1277.29 118.706 1277.35 118.68C1277.41 118.654 1277.47 118.667 1277.5 118.713Z"
                    fill="#E1E1E1" />
                <path
                    d="M1277.61 118.203C1277.64 118.242 1277.62 118.301 1277.57 118.327C1277.53 118.353 1277.47 118.34 1277.44 118.301C1277.41 118.262 1277.43 118.203 1277.48 118.177C1277.53 118.151 1277.58 118.164 1277.61 118.203Z"
                    fill="#E1E1E1" />
                <path
                    d="M1278.2 118.222C1278.24 118.255 1278.24 118.314 1278.2 118.347C1278.17 118.386 1278.11 118.386 1278.07 118.347C1278.04 118.314 1278.04 118.255 1278.07 118.222C1278.11 118.183 1278.17 118.183 1278.2 118.222Z"
                    fill="#E1E1E1" />
                <path
                    d="M1276.36 117.928C1276.38 117.974 1276.36 118.026 1276.31 118.046C1276.27 118.066 1276.21 118.046 1276.19 118.007C1276.17 117.961 1276.19 117.909 1276.24 117.889C1276.29 117.869 1276.34 117.889 1276.36 117.928Z"
                    fill="#E1E1E1" />
                <path
                    d="M1277.34 117.66C1277.36 117.706 1277.34 117.758 1277.28 117.784C1277.22 117.81 1277.17 117.791 1277.15 117.745C1277.13 117.699 1277.15 117.647 1277.21 117.621C1277.26 117.594 1277.32 117.614 1277.34 117.66Z"
                    fill="#E1E1E1" />
                <path
                    d="M1278.06 117.751C1278.08 117.797 1278.06 117.843 1278.03 117.856C1278 117.869 1277.96 117.843 1277.94 117.797C1277.92 117.751 1277.94 117.705 1277.97 117.692C1278 117.679 1278.04 117.705 1278.06 117.751Z"
                    fill="#E1E1E1" />
                <path
                    d="M1276.72 117.346C1276.74 117.392 1276.69 117.457 1276.61 117.496C1276.52 117.536 1276.44 117.529 1276.42 117.49C1276.4 117.444 1276.44 117.379 1276.53 117.339C1276.61 117.3 1276.69 117.307 1276.72 117.346Z"
                    fill="#E1E1E1" />
                <path
                    d="M1275.63 117.758C1275.64 117.804 1275.61 117.856 1275.57 117.869C1275.52 117.882 1275.47 117.856 1275.45 117.81C1275.44 117.765 1275.46 117.712 1275.51 117.699C1275.55 117.686 1275.61 117.712 1275.63 117.758Z"
                    fill="#E1E1E1" />
                <path
                    d="M1275.68 118.353C1275.7 118.398 1275.68 118.451 1275.65 118.477C1275.6 118.503 1275.55 118.483 1275.52 118.444C1275.5 118.398 1275.52 118.346 1275.55 118.32C1275.6 118.294 1275.65 118.313 1275.68 118.353Z"
                    fill="#E1E1E1" />
                <path
                    d="M1276.59 118.758C1276.61 118.804 1276.59 118.863 1276.53 118.889C1276.47 118.915 1276.4 118.902 1276.38 118.857C1276.36 118.811 1276.39 118.752 1276.45 118.726C1276.51 118.7 1276.57 118.713 1276.59 118.758Z"
                    fill="#E1E1E1" />
                <path
                    d="M1277.06 118.261C1277.08 118.307 1277.02 118.373 1276.93 118.412C1276.84 118.451 1276.75 118.445 1276.74 118.399C1276.72 118.353 1276.78 118.288 1276.87 118.248C1276.96 118.209 1277.05 118.216 1277.06 118.261Z"
                    fill="#E1E1E1" />
                <path
                    d="M1276.14 118.445C1276.17 118.491 1276.16 118.536 1276.12 118.563C1276.08 118.582 1276.04 118.563 1276.01 118.523C1275.99 118.484 1276 118.432 1276.03 118.406C1276.07 118.386 1276.12 118.406 1276.14 118.445Z"
                    fill="#E1E1E1" />
                <path
                    d="M1277.5 117.353C1277.51 117.399 1277.5 117.451 1277.45 117.458C1277.41 117.464 1277.37 117.444 1277.36 117.392C1277.34 117.346 1277.36 117.294 1277.4 117.288C1277.44 117.274 1277.49 117.301 1277.5 117.353Z"
                    fill="#E1E1E1" />
                <path
                    d="M1281.89 122.008C1281.89 122.499 1281.25 122.898 1280.46 122.898C1279.67 122.898 1279.03 122.499 1279.03 122.008C1279.03 121.518 1279.67 121.119 1280.46 121.119C1281.25 121.119 1281.89 121.518 1281.89 122.008Z"
                    fill="#FB5607" />
                <path
                    d="M1281.89 122.008C1281.89 122.499 1281.25 122.898 1280.46 122.898C1279.67 122.898 1279.03 122.499 1279.03 122.008C1279.03 121.518 1279.67 121.119 1280.46 121.119C1281.25 121.119 1281.89 121.518 1281.89 122.008Z"
                    fill="#FB5607" />
                <path
                    d="M1280.92 122.48C1280.94 122.525 1280.92 122.578 1280.87 122.604C1280.82 122.63 1280.76 122.604 1280.74 122.565C1280.72 122.525 1280.74 122.466 1280.8 122.44C1280.84 122.421 1280.9 122.44 1280.92 122.48Z"
                    fill="#E1E1E1" />
                <path
                    d="M1281.01 122.067C1281.04 122.107 1281.02 122.159 1280.99 122.185C1280.95 122.205 1280.91 122.185 1280.88 122.146C1280.85 122.107 1280.87 122.054 1280.9 122.028C1280.94 122.009 1280.99 122.028 1281.01 122.067Z"
                    fill="#E1E1E1" />
                <path
                    d="M1281.48 122.087C1281.52 122.119 1281.53 122.171 1281.5 122.197C1281.47 122.223 1281.42 122.223 1281.38 122.191C1281.34 122.158 1281.34 122.106 1281.36 122.08C1281.39 122.054 1281.44 122.054 1281.48 122.087Z"
                    fill="#E1E1E1" />
                <path
                    d="M1280.01 121.852C1280.03 121.898 1280.01 121.943 1279.98 121.963C1279.94 121.983 1279.9 121.963 1279.88 121.911C1279.86 121.865 1279.87 121.819 1279.9 121.799C1279.94 121.78 1279.99 121.799 1280.01 121.852Z"
                    fill="#E1E1E1" />
                <path
                    d="M1280.79 121.636C1280.81 121.682 1280.79 121.734 1280.75 121.754C1280.71 121.773 1280.66 121.754 1280.64 121.708C1280.62 121.662 1280.64 121.61 1280.68 121.59C1280.72 121.57 1280.77 121.59 1280.79 121.636Z"
                    fill="#E1E1E1" />
                <path
                    d="M1281.37 121.708C1281.39 121.754 1281.38 121.8 1281.35 121.813C1281.32 121.819 1281.29 121.793 1281.27 121.747C1281.25 121.701 1281.27 121.656 1281.29 121.643C1281.32 121.636 1281.36 121.662 1281.37 121.708Z"
                    fill="#E1E1E1" />
                <path
                    d="M1280.29 121.388C1280.31 121.433 1280.28 121.492 1280.22 121.525C1280.15 121.558 1280.08 121.545 1280.06 121.499C1280.04 121.453 1280.07 121.394 1280.14 121.361C1280.2 121.329 1280.27 121.342 1280.29 121.388Z"
                    fill="#E1E1E1" />
                <path
                    d="M1279.42 121.715C1279.43 121.76 1279.42 121.813 1279.37 121.819C1279.33 121.832 1279.29 121.806 1279.28 121.754C1279.26 121.708 1279.28 121.656 1279.32 121.649C1279.37 121.643 1279.41 121.662 1279.42 121.715Z"
                    fill="#E1E1E1" />
                <path
                    d="M1279.46 122.192C1279.49 122.237 1279.48 122.283 1279.44 122.303C1279.41 122.322 1279.36 122.303 1279.34 122.257C1279.31 122.211 1279.33 122.165 1279.36 122.146C1279.39 122.126 1279.44 122.146 1279.46 122.185V122.192Z"
                    fill="#E1E1E1" />
                <path
                    d="M1280.2 122.519C1280.22 122.564 1280.2 122.617 1280.15 122.636C1280.1 122.656 1280.05 122.636 1280.03 122.597C1280.01 122.551 1280.03 122.499 1280.07 122.479C1280.12 122.46 1280.17 122.479 1280.2 122.519Z"
                    fill="#E1E1E1" />
                <path
                    d="M1280.57 122.113C1280.59 122.159 1280.54 122.218 1280.47 122.25C1280.4 122.283 1280.32 122.27 1280.31 122.224C1280.29 122.179 1280.33 122.12 1280.4 122.087C1280.48 122.054 1280.55 122.067 1280.57 122.113Z"
                    fill="#E1E1E1" />
                <path
                    d="M1279.84 122.263C1279.86 122.309 1279.86 122.355 1279.83 122.374C1279.8 122.394 1279.76 122.374 1279.73 122.329C1279.71 122.283 1279.71 122.237 1279.74 122.218C1279.76 122.198 1279.81 122.218 1279.84 122.263Z"
                    fill="#E1E1E1" />
                <path
                    d="M1280.92 121.388C1280.93 121.433 1280.92 121.479 1280.89 121.492C1280.85 121.499 1280.82 121.473 1280.8 121.427C1280.79 121.381 1280.8 121.335 1280.84 121.322C1280.87 121.316 1280.91 121.342 1280.92 121.388Z"
                    fill="#E1E1E1" />
                <path
                    d="M1276.55 121.145C1276.55 121.74 1275.78 122.224 1274.82 122.224C1273.87 122.224 1273.09 121.74 1273.09 121.145C1273.09 120.55 1273.87 120.066 1274.82 120.066C1275.78 120.066 1276.55 120.55 1276.55 121.145Z"
                    fill="#FB5607" />
                <path
                    d="M1276.55 121.145C1276.55 121.74 1275.78 122.224 1274.82 122.224C1273.87 122.224 1273.09 121.74 1273.09 121.145C1273.09 120.55 1273.87 120.066 1274.82 120.066C1275.78 120.066 1276.55 120.55 1276.55 121.145Z"
                    fill="#FB5607" />
                <path
                    d="M1275.39 121.714C1275.41 121.76 1275.38 121.819 1275.32 121.845C1275.26 121.871 1275.2 121.858 1275.18 121.812C1275.16 121.766 1275.19 121.707 1275.25 121.681C1275.31 121.655 1275.37 121.668 1275.39 121.714Z"
                    fill="#E1E1E1" />
                <path
                    d="M1275.5 121.224C1275.52 121.263 1275.51 121.322 1275.46 121.348C1275.42 121.374 1275.36 121.361 1275.34 121.322C1275.31 121.283 1275.33 121.224 1275.37 121.198C1275.42 121.172 1275.47 121.185 1275.5 121.224Z"
                    fill="#E1E1E1" />
                <path
                    d="M1276.06 121.243C1276.1 121.276 1276.1 121.335 1276.07 121.368C1276.04 121.4 1275.98 121.407 1275.95 121.368C1275.91 121.335 1275.91 121.276 1275.94 121.243C1275.97 121.211 1276.03 121.204 1276.06 121.243Z"
                    fill="#E1E1E1" />
                <path
                    d="M1274.28 120.955C1274.3 121.001 1274.28 121.053 1274.24 121.073C1274.19 121.093 1274.14 121.073 1274.12 121.027C1274.1 120.981 1274.12 120.929 1274.16 120.909C1274.21 120.89 1274.26 120.909 1274.28 120.955Z"
                    fill="#E1E1E1" />
                <path
                    d="M1275.23 120.7C1275.25 120.746 1275.23 120.798 1275.18 120.825C1275.12 120.851 1275.06 120.831 1275.05 120.785C1275.03 120.74 1275.05 120.687 1275.1 120.661C1275.15 120.635 1275.21 120.655 1275.23 120.7Z"
                    fill="#E1E1E1" />
                <path
                    d="M1275.93 120.786C1275.95 120.831 1275.93 120.877 1275.91 120.89C1275.87 120.903 1275.84 120.877 1275.82 120.825C1275.8 120.779 1275.82 120.733 1275.84 120.72C1275.87 120.707 1275.91 120.733 1275.93 120.786Z"
                    fill="#E1E1E1" />
                <path
                    d="M1274.63 120.393C1274.65 120.439 1274.6 120.504 1274.52 120.544C1274.44 120.583 1274.36 120.576 1274.34 120.531C1274.32 120.485 1274.37 120.419 1274.44 120.38C1274.52 120.341 1274.61 120.348 1274.63 120.393Z"
                    fill="#E1E1E1" />
                <path
                    d="M1273.57 120.799C1273.58 120.844 1273.56 120.897 1273.51 120.91C1273.47 120.923 1273.41 120.897 1273.4 120.851C1273.39 120.805 1273.41 120.753 1273.46 120.74C1273.5 120.727 1273.56 120.753 1273.57 120.799Z"
                    fill="#E1E1E1" />
                <path
                    d="M1273.62 121.374C1273.65 121.42 1273.64 121.472 1273.59 121.492C1273.55 121.518 1273.5 121.498 1273.47 121.459C1273.45 121.413 1273.46 121.361 1273.5 121.341C1273.54 121.315 1273.6 121.335 1273.62 121.374Z"
                    fill="#E1E1E1" />
                <path
                    d="M1274.51 121.766C1274.53 121.812 1274.5 121.871 1274.44 121.897C1274.39 121.923 1274.33 121.91 1274.31 121.864C1274.29 121.819 1274.31 121.76 1274.37 121.734C1274.43 121.707 1274.49 121.72 1274.51 121.766Z"
                    fill="#E1E1E1" />
                <path
                    d="M1274.96 121.276C1274.98 121.322 1274.92 121.387 1274.84 121.426C1274.74 121.465 1274.66 121.452 1274.64 121.407C1274.62 121.361 1274.68 121.295 1274.76 121.256C1274.86 121.217 1274.94 121.23 1274.96 121.276Z"
                    fill="#E1E1E1" />
                <path
                    d="M1274.07 121.459C1274.1 121.505 1274.09 121.551 1274.05 121.577C1274.02 121.596 1273.97 121.577 1273.94 121.538C1273.92 121.492 1273.93 121.446 1273.96 121.42C1273.99 121.4 1274.05 121.42 1274.07 121.459Z"
                    fill="#E1E1E1" />
                <path
                    d="M1275.39 120.4C1275.4 120.446 1275.39 120.498 1275.35 120.505C1275.31 120.518 1275.27 120.485 1275.25 120.439C1275.23 120.393 1275.25 120.341 1275.29 120.334C1275.34 120.328 1275.37 120.354 1275.39 120.4Z"
                    fill="#E1E1E1" />
                <path
                    d="M815.379 23.9875C815.379 23.9875 814.727 23.158 813.5 21.2871C812.273 19.4162 807.579 21.9315 802 26.2871C802 26.2871 814.785 14.2202 818.254 18.0313C821.128 21.1891 816.311 25.297 816.5 25.2871L815.379 23.9875Z"
                    fill="#FB5607" />
                <path
                    d="M815.379 23.9875C815.379 23.9875 814.727 23.158 813.5 21.2871C812.273 19.4162 807.579 21.9315 802 26.2871C802 26.2871 814.785 14.2202 818.254 18.0313C821.128 21.1891 816.311 25.297 816.5 25.2871L815.379 23.9875Z"
                    fill="#FB5607" />
                <path
                    d="M799 23.7927C799.022 26.2202 799.544 27.9556 799.544 27.9556L812.181 19.0101C812.181 19.0101 811.56 17.8428 810.325 16.8202C809.683 16.2831 808.886 15.7872 807.919 15.5187C807.122 15.2914 806.219 15.2088 805.203 15.374C800.581 16.1384 798.972 21.3549 799 23.7824V23.7927Z"
                    fill="#FB5607" />
                <path
                    d="M799 23.7927C799.022 26.2202 799.544 27.9556 799.544 27.9556L812.181 19.0101C812.181 19.0101 811.56 17.8428 810.325 16.8202C809.683 16.2831 808.886 15.7872 807.919 15.5187C807.122 15.2914 806.219 15.2088 805.203 15.374C800.581 16.1384 798.972 21.3549 799 23.7824V23.7927Z"
                    fill="#FB5607" />
                <path opacity="0.2"
                    d="M814.308 24.8058C814.308 24.8058 817.095 22.0891 815.86 20.1367C815.316 19.269 813.687 19.4756 811.478 20.3743C810.243 20.8805 808.804 21.5312 807.322 22.4816C805.389 23.7108 803.328 25.2913 801.501 26.4482C801.501 26.4482 814.371 13.8563 817.864 17.8332C820.757 21.1284 814.745 25.4049 814.533 25.6838L814.427 25.1363L814.3 24.7954L814.308 24.8058Z"
                    fill="black" fill-opacity="0.46" />
                <path opacity="0.3"
                    d="M804.871 17.4605L805.894 19.671L810.325 16.8304C809.683 16.2932 808.886 15.7974 807.919 15.5288L804.878 17.4605H804.871Z"
                    fill="white" />
                <path
                    d="M1215.37 110.414C1215.44 110.414 1215.37 112.017 1215.24 113.978C1215.1 115.94 1214.94 117.534 1214.88 117.525C1214.81 117.525 1214.88 115.923 1215.01 113.961C1215.14 112 1215.31 110.406 1215.37 110.414Z"
                    fill="#1A2E35" />
                <path
                    d="M1166.8 101.082L1161.52 107.592L1150.14 111.866C1150.14 111.866 1148.52 124.886 1151.36 128.551C1154.2 132.215 1171.73 180.032 1171.73 180.032L1214.73 179.932L1216.37 107.793C1216.37 107.793 1201.53 103.027 1196.61 102.451C1187.67 101.408 1166.8 101.074 1166.8 101.074V101.082Z"
                    fill="#FB5607" />
                <path
                    d="M1166.8 101.082L1161.52 107.592L1150.14 111.866C1150.14 111.866 1148.52 124.886 1151.36 128.551C1154.2 132.215 1171.73 180.032 1171.73 180.032L1214.73 179.932L1216.37 107.793C1216.37 107.793 1201.53 103.027 1196.61 102.451C1187.67 101.408 1166.8 101.074 1166.8 101.074V101.082Z"
                    fill="#FB5607" />
                <path
                    d="M1187.05 125.888C1187.05 125.888 1186.99 125.871 1186.89 125.829L1186.44 125.638C1186.03 125.462 1185.46 125.203 1184.73 124.886C1183.24 124.219 1181.12 123.275 1178.55 122.124L1178.67 122.04C1178.59 124.536 1178.5 127.482 1178.4 130.679V131.038L1178.19 130.729C1177.31 129.335 1176.38 127.883 1175.4 126.397C1171.9 121.072 1168.51 116.39 1165.99 113.059C1164.73 111.39 1163.7 110.055 1162.98 109.128C1162.63 108.677 1162.36 108.318 1162.16 108.068L1161.95 107.784C1161.9 107.717 1161.88 107.684 1161.88 107.684C1161.88 107.684 1161.92 107.709 1161.97 107.768L1162.19 108.035C1162.4 108.285 1162.68 108.636 1163.05 109.07C1163.78 109.979 1164.84 111.298 1166.12 112.959C1168.67 116.273 1172.07 120.938 1175.58 126.272C1176.56 127.758 1177.49 129.218 1178.36 130.612L1178.16 130.67C1178.27 127.474 1178.38 124.527 1178.47 122.04V121.907L1178.6 121.965C1181.16 123.142 1183.26 124.118 1184.75 124.803L1186.44 125.596L1186.88 125.813C1186.98 125.863 1187.03 125.888 1187.03 125.896L1187.05 125.888Z"
                    fill="#1A2E35" />
                <path
                    d="M1192.86 107.926C1192.86 107.926 1192.91 108.026 1192.98 108.21L1193.26 109.045C1193.5 109.804 1193.85 110.848 1194.27 112.141C1195.1 114.779 1196.25 118.393 1197.5 122.374C1197.57 122.583 1197.63 122.783 1197.7 122.992L1197.79 123.284L1197.53 123.125C1195.6 121.949 1194 120.488 1192.82 119.044H1192.98C1191.43 120.947 1190.13 122.549 1189.19 123.701C1188.74 124.244 1188.37 124.686 1188.11 125.003L1187.81 125.346C1187.75 125.421 1187.71 125.462 1187.71 125.454C1187.71 125.454 1187.73 125.404 1187.79 125.321L1188.06 124.962C1188.31 124.628 1188.66 124.185 1189.1 123.618C1190.01 122.458 1191.3 120.83 1192.82 118.91L1192.9 118.81L1192.98 118.902C1194.16 120.321 1195.74 121.757 1197.65 122.917L1197.49 123.05C1197.42 122.85 1197.36 122.641 1197.3 122.433C1196.06 118.443 1194.95 114.829 1194.12 112.183C1193.73 110.889 1193.41 109.829 1193.19 109.07C1193.09 108.719 1193 108.435 1192.95 108.218C1192.9 108.026 1192.87 107.918 1192.88 107.918L1192.86 107.926Z"
                    fill="#1A2E35" />
                <path
                    d="M1206.08 170.067L1216.38 165.602C1216.77 164.967 1217.44 164.408 1218.53 163.957L1214.99 151.579L1216.38 107.802C1216.38 107.802 1224.12 111.933 1225.75 119.412C1227.38 126.89 1231.89 142.866 1231.89 142.866C1231.89 142.866 1241.69 160.928 1239.59 169.107C1237.49 177.287 1235.69 180.041 1235.69 180.041L1209.11 180.659L1206.08 170.067Z"
                    fill="#FB5607" />
                <path
                    d="M1206.08 170.067L1216.38 165.602C1216.77 164.967 1217.44 164.408 1218.53 163.957L1214.99 151.579L1216.38 107.802C1216.38 107.802 1224.12 111.933 1225.75 119.412C1227.38 126.89 1231.89 142.866 1231.89 142.866C1231.89 142.866 1241.69 160.928 1239.59 169.107C1237.49 177.287 1235.69 180.041 1235.69 180.041L1209.11 180.659L1206.08 170.067Z"
                    fill="#FB5607" />
                <path
                    d="M1191.79 176.486C1191.81 176.31 1192.39 172.888 1192.39 172.888L1194.72 170.802C1195.26 170.326 1195.95 170.059 1196.67 170.059H1198.16C1198.16 170.059 1198.95 168.314 1199.73 168.014C1200.51 167.713 1203.12 167.104 1203.64 167.797C1204.16 168.49 1204.24 169.366 1204.24 169.366C1204.24 169.366 1206.64 169.717 1207.07 170.368C1207.5 171.019 1207.59 172.605 1207.59 172.605C1207.59 172.605 1208.59 173.197 1209.07 174.332C1209.54 175.467 1209.81 176.811 1209.81 176.811C1209.81 176.811 1211.5 178.03 1211.38 179.641C1211.24 181.252 1209.77 181.919 1208.99 182.103C1208.2 182.295 1201.95 183.639 1201.34 183.288C1200.73 182.938 1200.69 182.595 1200.69 182.595C1200.69 182.595 1199.95 182.612 1199.3 182.103C1198.65 181.594 1198.43 180.659 1198.43 180.659C1198.43 180.659 1196.86 181.986 1195.91 181.853C1194.95 181.719 1193.83 181.026 1194.3 179.282L1194.7 178.931C1194.7 178.931 1193.35 179.541 1193 178.756C1192.65 177.971 1192.38 177.521 1192.38 177.521C1192.38 177.521 1191.63 177.638 1191.79 176.477V176.486Z"
                    fill="#FFBF9D" />
                <path
                    d="M1198.16 170.051C1198.16 170.051 1198.14 170.184 1198.06 170.418C1197.98 170.652 1197.87 170.986 1197.66 171.386C1197.55 171.586 1197.43 171.795 1197.25 171.995C1197.09 172.204 1196.86 172.388 1196.65 172.571C1196.22 172.955 1195.76 173.389 1195.3 173.865C1194.38 174.825 1193.64 175.776 1193.13 176.486C1192.62 177.195 1192.33 177.654 1192.3 177.638C1192.29 177.638 1192.35 177.504 1192.46 177.287C1192.58 177.07 1192.76 176.761 1193 176.394C1193.47 175.66 1194.2 174.675 1195.14 173.707C1195.6 173.222 1196.07 172.788 1196.52 172.413C1196.98 172.054 1197.31 171.687 1197.53 171.303C1197.95 170.543 1198.13 170.026 1198.17 170.042L1198.16 170.051Z"
                    fill="#FFBF9D" />
                <path
                    d="M1204.24 169.358C1204.24 169.358 1204.26 169.408 1204.28 169.5C1204.29 169.592 1204.3 169.734 1204.31 169.917C1204.31 170.276 1204.22 170.81 1203.92 171.386C1203.62 171.97 1203.15 172.571 1202.6 173.214C1202.04 173.848 1201.33 174.458 1200.55 175.05C1199.01 176.244 1197.56 177.237 1196.48 177.913C1195.94 178.255 1195.5 178.514 1195.18 178.681C1194.87 178.856 1194.69 178.94 1194.68 178.923C1194.68 178.906 1194.84 178.798 1195.13 178.606L1196.39 177.78C1197.45 177.07 1198.88 176.06 1200.4 174.867C1201.17 174.274 1201.87 173.681 1202.44 173.064C1202.99 172.446 1203.47 171.845 1203.77 171.303C1204.08 170.752 1204.19 170.251 1204.22 169.9C1204.24 169.55 1204.22 169.35 1204.24 169.35V169.358Z"
                    fill="#FFBF9D" />
                <path
                    d="M1206.44 174.399C1206.44 174.399 1206.36 174.524 1206.19 174.716C1206.03 174.917 1205.77 175.192 1205.45 175.526C1204.81 176.194 1203.89 177.078 1202.78 177.963C1201.67 178.848 1200.59 179.541 1199.78 179.991C1199.37 180.217 1199.05 180.392 1198.8 180.5C1198.57 180.609 1198.44 180.667 1198.43 180.651C1198.41 180.617 1198.91 180.342 1199.7 179.849C1200.48 179.365 1201.54 178.656 1202.64 177.779C1203.74 176.903 1204.67 176.043 1205.34 175.401C1206.01 174.766 1206.42 174.366 1206.44 174.391L1206.44 174.399Z"
                    fill="#FFBF9D" />
                <path
                    d="M1208.04 177.821C1208.04 177.821 1207.73 178.222 1207.13 178.773C1206.53 179.324 1205.65 180.033 1204.61 180.709C1203.57 181.385 1202.56 181.894 1201.81 182.22C1201.06 182.545 1200.59 182.696 1200.57 182.662C1200.55 182.629 1201.02 182.428 1201.74 182.07C1202.46 181.711 1203.45 181.185 1204.48 180.517C1205.51 179.849 1206.39 179.165 1207.02 178.647C1207.64 178.13 1208.01 177.796 1208.04 177.821H1208.04Z"
                    fill="#FFBF9D" />
                <path
                    d="M1215.54 119.846C1215.54 119.846 1215.54 119.887 1215.55 119.971V120.33C1215.57 120.664 1215.57 121.114 1215.58 121.699C1215.59 122.884 1215.58 124.603 1215.55 126.732C1215.5 130.98 1215.33 136.848 1215.07 143.325C1214.82 149.802 1214.61 155.669 1214.52 159.918C1214.48 162.029 1214.44 163.74 1214.43 164.951C1214.42 165.535 1214.41 165.985 1214.4 166.319L1214.39 166.678C1214.39 166.762 1214.39 166.803 1214.38 166.803C1214.37 166.803 1214.38 166.762 1214.37 166.678V166.319C1214.35 165.985 1214.35 165.535 1214.34 164.951C1214.34 163.765 1214.34 162.046 1214.37 159.918C1214.42 155.669 1214.59 149.802 1214.85 143.316C1215.1 136.839 1215.31 130.972 1215.4 126.723C1215.44 124.612 1215.48 122.901 1215.49 121.69L1215.52 120.322L1215.54 119.963C1215.54 119.879 1215.54 119.837 1215.54 119.837V119.846Z"
                    fill="#1A2E35" />
                <path
                    d="M1229.82 165.735C1229.82 165.735 1229.73 165.735 1229.57 165.718L1228.84 165.618C1228.18 165.518 1227.28 165.376 1226.19 165.201C1225.07 165.017 1223.73 164.792 1222.26 164.55C1221.52 164.425 1220.74 164.291 1219.94 164.158C1219.53 164.099 1219.13 163.991 1218.74 164.041C1218.34 164.083 1217.95 164.233 1217.63 164.492C1217.41 164.65 1217.23 164.875 1217.03 165.076L1216.47 165.677L1216.45 165.693H1216.43C1213.62 166.904 1211.14 167.964 1209.32 168.74L1207.2 169.616C1206.97 169.708 1206.78 169.783 1206.63 169.842C1206.49 169.892 1206.43 169.917 1206.42 169.908C1206.42 169.908 1206.48 169.867 1206.61 169.8L1207.17 169.533C1207.69 169.299 1208.39 168.982 1209.26 168.59C1211.07 167.797 1213.54 166.712 1216.33 165.476L1216.3 165.501L1216.87 164.9C1217.06 164.7 1217.24 164.475 1217.49 164.291C1217.85 164.016 1218.28 163.849 1218.73 163.799C1218.94 163.774 1219.17 163.782 1219.38 163.815L1219.99 163.924C1220.79 164.066 1221.57 164.199 1222.31 164.325C1223.78 164.583 1225.11 164.825 1226.23 165.026C1227.33 165.226 1228.22 165.393 1228.87 165.518C1229.17 165.577 1229.4 165.627 1229.59 165.66C1229.76 165.693 1229.84 165.718 1229.84 165.727L1229.82 165.735Z"
                    fill="#1A2E35" />
                <path
                    d="M1228.89 160.844C1228.91 160.902 1226.6 161.637 1223.73 162.48C1220.87 163.323 1218.53 163.957 1218.51 163.899C1218.49 163.84 1220.8 163.106 1223.67 162.263C1226.53 161.42 1228.87 160.786 1228.89 160.844Z"
                    fill="#1A2E35" />
                <path
                    d="M1199.31 168.205C1199.25 168.222 1196.55 158.89 1193.28 147.364C1190.01 135.829 1187.41 126.472 1187.46 126.456C1187.52 126.439 1190.22 135.77 1193.5 147.305C1196.76 158.832 1199.37 168.197 1199.3 168.213L1199.31 168.205Z"
                    fill="#1A2E35" />
                <path
                    d="M1204.49 131.881C1204.49 131.881 1208.45 128.492 1210.64 127.908C1212.84 127.324 1227.18 126.255 1230.28 125.012C1233.38 123.768 1234.54 123.484 1234.54 123.484C1234.54 123.484 1235.09 125.154 1231.72 126.564C1228.34 127.975 1225.67 130.228 1221.56 130.921C1217.45 131.622 1213.95 135.745 1213.95 135.745L1206 139.785C1204.7 140.445 1203.12 140.011 1202.35 138.775C1200.84 136.38 1198.67 132.791 1198.86 132.315C1199.15 131.597 1202.68 129.043 1204.48 131.873L1204.49 131.881Z"
                    fill="#FB5607" />
                <path
                    d="M1204.49 131.881C1204.49 131.881 1208.45 128.492 1210.64 127.908C1212.84 127.324 1227.18 126.255 1230.28 125.012C1233.38 123.768 1234.54 123.484 1234.54 123.484C1234.54 123.484 1235.09 125.154 1231.72 126.564C1228.34 127.975 1225.67 130.228 1221.56 130.921C1217.45 131.622 1213.95 135.745 1213.95 135.745L1206 139.785C1204.7 140.445 1203.12 140.011 1202.35 138.775C1200.84 136.38 1198.67 132.791 1198.86 132.315C1199.15 131.597 1202.68 129.043 1204.48 131.873L1204.49 131.881Z"
                    fill="#FB5607" />
                <g opacity="0.3">
                    <path
                        d="M1204.49 131.881C1204.49 131.839 1208.45 128.492 1210.64 127.908C1212.84 127.324 1227.18 126.255 1230.28 125.012C1233.38 123.768 1234.54 123.484 1234.54 123.484C1234.54 123.484 1229.37 126.815 1228.51 126.873C1227.65 126.923 1225.08 127.29 1224.41 127.633C1223.74 127.975 1222.85 129.419 1221.97 129.502C1221.08 129.577 1216.47 130.128 1215.68 130.445C1214.88 130.763 1212.97 134.118 1209.64 134.218C1206.32 134.318 1204.92 134.318 1204.49 131.889V131.881Z"
                        fill="black" fill-opacity="0.46" />
                </g>
                <path
                    d="M1204.6 131.848C1206.34 132.891 1208.79 132.533 1210.17 131.039C1210.69 130.479 1211.11 129.745 1211.84 129.536C1212.41 129.378 1213 129.57 1213.59 129.636C1214.38 129.72 1215.18 129.57 1215.87 129.194C1216.42 128.893 1216.9 128.459 1217.5 128.251C1218.45 127.925 1219.48 128.234 1220.48 128.159C1221.76 128.059 1222.95 127.274 1223.55 126.147C1223.55 126.147 1211.46 127.5 1209.95 128.017C1208.39 128.551 1204.6 131.84 1204.6 131.84V131.848Z"
                    fill="#FB5607" />
                <path
                    d="M1204.6 131.848C1206.34 132.891 1208.79 132.533 1210.17 131.039C1210.69 130.479 1211.11 129.745 1211.84 129.536C1212.41 129.378 1213 129.57 1213.59 129.636C1214.38 129.72 1215.18 129.57 1215.87 129.194C1216.42 128.893 1216.9 128.459 1217.5 128.251C1218.45 127.925 1219.48 128.234 1220.48 128.159C1221.76 128.059 1222.95 127.274 1223.55 126.147C1223.55 126.147 1211.46 127.5 1209.95 128.017C1208.39 128.551 1204.6 131.84 1204.6 131.84V131.848Z"
                    fill="#FB5607" />
                <g opacity="0.5">
                    <path
                        d="M1204.6 131.848C1206.34 132.891 1208.79 132.533 1210.17 131.039C1210.69 130.479 1211.11 129.745 1211.84 129.536C1212.41 129.378 1213 129.57 1213.59 129.636C1214.38 129.72 1215.18 129.57 1215.87 129.194C1216.42 128.893 1216.9 128.459 1217.5 128.251C1218.45 127.925 1219.48 128.234 1220.48 128.159C1221.76 128.059 1222.95 127.274 1223.55 126.147C1223.55 126.147 1211.46 127.5 1209.95 128.017C1208.39 128.551 1204.6 131.84 1204.6 131.84V131.848Z"
                        fill="white" />
                </g>
                <path
                    d="M1212.38 130.278C1212.51 131.021 1211.65 131.806 1210.45 132.031C1209.25 132.257 1208.17 131.831 1208.03 131.08C1207.89 130.337 1208.75 129.552 1209.95 129.327C1211.15 129.102 1212.24 129.527 1212.38 130.278Z"
                    fill="#FB5607" />
                <path
                    d="M1212.38 130.278C1212.51 131.021 1211.65 131.806 1210.45 132.031C1209.25 132.257 1208.17 131.831 1208.03 131.08C1207.89 130.337 1208.75 129.552 1209.95 129.327C1211.15 129.102 1212.24 129.527 1212.38 130.278Z"
                    fill="#FB5607" />
                <path
                    d="M1211.04 131.271C1211.08 131.322 1211.05 131.405 1210.99 131.447C1210.92 131.497 1210.84 131.489 1210.79 131.438C1210.76 131.388 1210.79 131.305 1210.85 131.263C1210.92 131.213 1211 131.221 1211.04 131.271Z"
                    fill="#E1E1E1" />
                <path
                    d="M1211.07 130.629C1211.11 130.679 1211.1 130.746 1211.05 130.796C1211 130.838 1210.93 130.838 1210.89 130.796C1210.84 130.746 1210.85 130.679 1210.9 130.629C1210.95 130.587 1211.03 130.587 1211.07 130.629Z"
                    fill="#E1E1E1" />
                <path
                    d="M1211.79 130.52C1211.84 130.554 1211.85 130.62 1211.82 130.679C1211.79 130.729 1211.72 130.746 1211.66 130.712C1211.61 130.679 1211.59 130.612 1211.63 130.554C1211.66 130.504 1211.73 130.487 1211.79 130.52Z"
                    fill="#E1E1E1" />
                <path
                    d="M1209.49 130.57C1209.52 130.621 1209.51 130.696 1209.46 130.729C1209.41 130.762 1209.34 130.754 1209.3 130.704C1209.27 130.654 1209.28 130.579 1209.33 130.545C1209.38 130.512 1209.45 130.52 1209.49 130.57Z"
                    fill="#E1E1E1" />
                <path
                    d="M1210.61 130.028C1210.64 130.078 1210.63 130.153 1210.57 130.195C1210.51 130.237 1210.44 130.229 1210.4 130.179C1210.37 130.128 1210.39 130.053 1210.44 130.012C1210.5 129.97 1210.58 129.978 1210.61 130.028Z"
                    fill="#E1E1E1" />
                <path
                    d="M1211.52 129.969C1211.55 130.028 1211.54 130.086 1211.51 130.111C1211.47 130.136 1211.42 130.111 1211.39 130.053C1211.35 129.995 1211.36 129.936 1211.39 129.911C1211.44 129.886 1211.49 129.911 1211.52 129.969Z"
                    fill="#E1E1E1" />
                <path
                    d="M1209.79 129.786C1209.82 129.836 1209.79 129.936 1209.69 129.995C1209.59 130.062 1209.49 130.078 1209.45 130.02C1209.42 129.97 1209.45 129.87 1209.55 129.811C1209.64 129.744 1209.74 129.728 1209.79 129.786Z"
                    fill="#E1E1E1" />
                <path
                    d="M1208.55 130.529C1208.59 130.587 1208.55 130.654 1208.5 130.679C1208.44 130.712 1208.38 130.679 1208.34 130.629C1208.31 130.57 1208.34 130.504 1208.39 130.479C1208.44 130.454 1208.52 130.479 1208.55 130.529Z"
                    fill="#E1E1E1" />
                <path
                    d="M1208.75 131.247C1208.79 131.297 1208.79 131.363 1208.74 131.405C1208.69 131.447 1208.63 131.439 1208.59 131.388C1208.54 131.338 1208.55 131.272 1208.59 131.23C1208.64 131.188 1208.71 131.196 1208.75 131.247Z"
                    fill="#E1E1E1" />
                <path
                    d="M1209.95 131.53C1209.99 131.58 1209.97 131.664 1209.9 131.706C1209.84 131.756 1209.75 131.747 1209.72 131.697C1209.69 131.647 1209.7 131.564 1209.77 131.522C1209.84 131.48 1209.92 131.48 1209.95 131.53Z"
                    fill="#E1E1E1" />
                <path
                    d="M1210.41 130.821C1210.44 130.871 1210.39 130.971 1210.29 131.038C1210.19 131.105 1210.07 131.113 1210.04 131.063C1210 131.013 1210.06 130.913 1210.16 130.846C1210.26 130.779 1210.38 130.771 1210.41 130.821Z"
                    fill="#E1E1E1" />
                <path
                    d="M1209.34 131.247C1209.38 131.297 1209.38 131.364 1209.34 131.397C1209.29 131.43 1209.23 131.422 1209.19 131.372C1209.14 131.322 1209.14 131.255 1209.19 131.222C1209.23 131.188 1209.29 131.197 1209.34 131.247Z"
                    fill="#E1E1E1" />
                <path
                    d="M1210.74 129.611C1210.77 129.669 1210.76 129.727 1210.71 129.752C1210.67 129.778 1210.6 129.752 1210.58 129.694C1210.55 129.636 1210.56 129.577 1210.61 129.552C1210.65 129.527 1210.72 129.552 1210.74 129.611Z"
                    fill="#E1E1E1" />
                <path
                    d="M1198.68 131.739L1191.55 135.044C1191.55 135.044 1186.28 141.338 1185.32 142.773C1184.36 144.209 1181.39 148.023 1181.39 148.023L1192.37 154.5L1194.69 149.86C1194.69 149.86 1197.64 151.295 1198.67 151.053C1198.67 151.053 1202.5 151.854 1203.69 150.494C1204.89 149.133 1206.49 148.257 1206.49 148.257L1210.25 144.476L1211.99 139.076L1213.82 137.081C1213.82 137.081 1213.44 136.689 1212.37 136.68C1211.99 136.68 1211.04 136.939 1211.04 136.939C1210.4 136.722 1209.64 136.447 1208.54 136.622C1205.12 137.181 1204.01 139.627 1201.15 141.947L1198.6 142.106L1194.53 139.552C1194.53 139.552 1194.21 139.076 1195.17 138.592C1196.13 138.108 1198.36 137.315 1199.15 135.796C1199.95 134.277 1200.59 131.564 1198.68 131.722V131.739Z"
                    fill="#FFBF9D" />
                <path
                    d="M1211.05 136.948C1211.05 136.948 1210.9 137.165 1210.59 137.515C1210.26 137.899 1209.82 138.4 1209.29 139.009C1208.18 140.261 1206.63 141.981 1204.88 143.85C1204 144.785 1203.17 145.67 1202.36 146.438C1202.25 146.529 1202.17 146.63 1202.05 146.721C1201.99 146.763 1201.93 146.813 1201.86 146.847L1201.67 146.922C1201.55 146.972 1201.42 147.022 1201.3 147.047C1201.17 147.08 1201.05 147.122 1200.93 147.139C1200.44 147.247 1199.97 147.272 1199.55 147.272C1198.71 147.272 1198.04 147.155 1197.57 147.064C1197.11 146.963 1196.86 146.88 1196.87 146.863C1196.87 146.847 1197.13 146.905 1197.59 146.972C1198.05 147.039 1198.72 147.13 1199.55 147.105C1199.97 147.105 1200.42 147.055 1200.9 146.947C1201.01 146.922 1201.13 146.888 1201.25 146.855C1201.37 146.822 1201.5 146.78 1201.61 146.73L1201.79 146.655C1201.85 146.621 1201.88 146.58 1201.93 146.546C1202.02 146.479 1202.12 146.371 1202.22 146.279C1203.01 145.511 1203.84 144.618 1204.71 143.692C1206.44 141.83 1207.99 140.153 1209.16 138.892C1209.71 138.3 1210.17 137.816 1210.52 137.448C1210.84 137.106 1211.03 136.931 1211.04 136.939L1211.05 136.948Z"
                    fill="#FFBF9D" />
                <path
                    d="M1201.6 150.436C1201.58 150.394 1202.35 149.985 1203.41 149.075C1204.48 148.174 1205.83 146.788 1207.21 145.169C1208.6 143.55 1209.78 142.006 1210.62 140.887C1211.02 140.353 1211.35 139.911 1211.61 139.56C1211.84 139.243 1211.98 139.076 1211.99 139.084C1212.01 139.093 1211.9 139.285 1211.69 139.61C1211.47 139.936 1211.16 140.411 1210.75 140.987C1209.94 142.131 1208.79 143.692 1207.39 145.319C1205.99 146.947 1204.62 148.332 1203.51 149.209C1203.24 149.434 1202.97 149.609 1202.75 149.776C1202.53 149.943 1202.32 150.068 1202.15 150.16C1201.8 150.352 1201.61 150.452 1201.6 150.444V150.436Z"
                    fill="#FFBF9D" />
                <path
                    d="M1149.96 111.657C1149.96 111.657 1142.14 119.043 1142 127.273C1141.87 135.494 1146.65 154.141 1148.71 158.256C1150.76 162.37 1160.07 178.78 1164.86 180.449C1169.65 182.11 1177.31 183.07 1180.32 179.097C1183.33 175.124 1193.19 154.833 1193.19 154.833L1180.87 147.572L1172.12 154.149L1149.97 111.665L1149.96 111.657Z"
                    fill="#FB5607" />
                <path
                    d="M1149.96 111.657C1149.96 111.657 1142.14 119.043 1142 127.273C1141.87 135.494 1146.65 154.141 1148.71 158.256C1150.76 162.37 1160.07 178.78 1164.86 180.449C1169.65 182.11 1177.31 183.07 1180.32 179.097C1183.33 175.124 1193.19 154.833 1193.19 154.833L1180.87 147.572L1172.12 154.149L1149.97 111.665L1149.96 111.657Z"
                    fill="#FB5607" />
                <path
                    d="M1171.92 154.09C1171.92 154.09 1171.87 153.999 1171.8 153.815L1171.47 153.005C1171.18 152.279 1170.77 151.261 1170.27 150.017C1169.23 147.48 1167.82 144.016 1166.25 140.193C1164.67 136.354 1163.27 132.882 1162.28 130.344C1161.79 129.076 1161.41 128.049 1161.15 127.331C1161.03 126.989 1160.93 126.714 1160.86 126.505C1160.79 126.313 1160.77 126.213 1160.78 126.213C1160.78 126.213 1160.83 126.305 1160.9 126.488C1160.98 126.697 1161.09 126.964 1161.23 127.298L1162.43 130.286C1163.47 132.823 1164.88 136.287 1166.45 140.11C1168.02 143.941 1169.43 147.421 1170.42 149.959C1170.91 151.228 1171.29 152.254 1171.55 152.972C1171.67 153.314 1171.77 153.59 1171.84 153.798C1171.91 153.99 1171.93 154.09 1171.92 154.09Z"
                    fill="#1A2E35" />
                <path
                    d="M1179.41 180.032C1179.41 180.032 1179.44 179.99 1179.5 179.907L1179.75 179.564C1179.98 179.272 1180.28 178.805 1180.66 178.204C1181.42 176.994 1182.49 175.216 1183.74 172.971C1186.25 168.472 1189.6 162.145 1193.26 154.984L1193.3 155.134C1192.49 154.65 1191.61 154.133 1190.74 153.615C1187.21 151.528 1183.85 149.534 1180.78 147.722H1180.9C1176.12 151.119 1172.26 154.325 1169.59 156.662C1168.26 157.83 1167.22 158.773 1166.52 159.424C1166.17 159.741 1165.9 159.992 1165.71 160.167L1165.5 160.359C1165.45 160.401 1165.42 160.417 1165.42 160.417C1165.42 160.417 1165.44 160.392 1165.49 160.342L1165.69 160.142C1165.88 159.958 1166.14 159.7 1166.47 159.374C1167.17 158.706 1168.19 157.747 1169.52 156.561C1172.16 154.199 1176 150.969 1180.78 147.547L1180.84 147.505L1180.9 147.539C1183.96 149.35 1187.34 151.336 1190.86 153.423C1191.75 153.941 1192.61 154.458 1193.43 154.942L1193.52 155.001L1193.47 155.092C1189.8 162.262 1186.42 168.572 1183.88 173.054C1182.61 175.299 1181.53 177.069 1180.74 178.262C1180.34 178.855 1180.03 179.314 1179.78 179.598C1179.67 179.74 1179.58 179.848 1179.51 179.932C1179.46 180.007 1179.42 180.04 1179.41 180.04V180.032Z"
                    fill="#1A2E35" />
                <path
                    d="M1172.36 154.182C1172.36 154.182 1172.19 154.249 1171.88 154.341C1171.52 154.441 1171.09 154.566 1170.57 154.708C1169.47 155.025 1167.97 155.509 1166.35 156.152C1164.72 156.795 1163.3 157.479 1162.28 157.997C1161.81 158.247 1161.41 158.456 1161.08 158.623C1160.8 158.773 1160.64 158.848 1160.63 158.831C1160.63 158.815 1160.78 158.715 1161.04 158.539C1161.31 158.364 1161.71 158.13 1162.22 157.847C1163.22 157.287 1164.64 156.578 1166.27 155.927C1167.91 155.284 1169.43 154.817 1170.54 154.541C1171.1 154.399 1171.55 154.299 1171.87 154.241C1172.18 154.182 1172.36 154.157 1172.36 154.174V154.182Z"
                    fill="#1A2E35" />
                <path
                    d="M1160.13 122.031C1160.13 122.031 1159.65 121.58 1158.88 120.862C1158.11 120.144 1157 119.201 1155.68 118.292C1154.35 117.382 1153.08 116.681 1152.13 116.222C1151.18 115.763 1150.58 115.512 1150.59 115.479C1150.59 115.462 1150.75 115.512 1151.03 115.612C1151.32 115.704 1151.71 115.871 1152.2 116.08C1153.17 116.505 1154.48 117.19 1155.81 118.108C1157.14 119.026 1158.24 120.003 1158.99 120.754C1159.37 121.129 1159.66 121.447 1159.85 121.672C1160.04 121.897 1160.14 122.031 1160.13 122.039L1160.13 122.031Z"
                    fill="#1A2E35" />
                <path
                    d="M1163.87 134.268C1163.87 134.268 1163.8 134.301 1163.67 134.352C1163.51 134.402 1163.31 134.468 1163.07 134.544C1162.55 134.702 1161.8 134.944 1160.88 135.253C1159.03 135.862 1156.51 136.789 1153.79 137.974C1151.08 139.168 1148.69 140.403 1146.99 141.354C1146.14 141.822 1145.46 142.214 1144.99 142.489L1144.45 142.798C1144.33 142.865 1144.26 142.898 1144.25 142.89C1144.25 142.89 1144.31 142.84 1144.43 142.757C1144.57 142.665 1144.74 142.548 1144.95 142.414C1145.41 142.114 1146.08 141.705 1146.92 141.212C1148.6 140.228 1150.99 138.967 1153.7 137.765C1156.43 136.572 1158.97 135.67 1160.83 135.094C1161.76 134.802 1162.52 134.594 1163.04 134.452L1163.65 134.302C1163.79 134.268 1163.87 134.26 1163.87 134.26V134.268Z"
                    fill="white" />
                <path
                    d="M1164.35 135.795C1164.35 135.795 1164.28 135.829 1164.15 135.879L1163.55 136.071C1163.03 136.229 1162.28 136.472 1161.36 136.78C1159.52 137.39 1156.99 138.316 1154.28 139.501C1151.56 140.695 1149.18 141.93 1147.48 142.882C1146.63 143.349 1145.94 143.741 1145.48 144.017C1145.26 144.142 1145.08 144.242 1144.94 144.326C1144.81 144.392 1144.74 144.426 1144.74 144.417C1144.74 144.417 1144.79 144.367 1144.91 144.284L1145.44 143.942C1145.89 143.641 1146.56 143.232 1147.4 142.74C1149.09 141.755 1151.47 140.495 1154.18 139.293C1156.91 138.099 1159.45 137.198 1161.31 136.622C1162.24 136.33 1163 136.121 1163.53 135.979L1164.13 135.829C1164.27 135.795 1164.35 135.787 1164.35 135.787V135.795Z"
                    fill="white" />
                <path
                    d="M1164.56 180.283C1164.56 180.283 1164.52 180.191 1164.49 180.024C1164.46 179.849 1164.41 179.598 1164.36 179.273C1164.26 178.613 1164.15 177.662 1164.11 176.468C1164.07 175.275 1164.12 173.856 1164.32 172.295C1164.53 170.734 1164.9 169.04 1165.41 167.295C1166.41 163.798 1167.82 160.802 1168.97 158.732C1169.54 157.688 1170.05 156.871 1170.41 156.311C1170.58 156.028 1170.73 155.819 1170.83 155.677C1170.93 155.535 1170.99 155.46 1170.99 155.46C1170.99 155.46 1170.96 155.543 1170.87 155.694C1170.77 155.869 1170.64 156.086 1170.48 156.353C1170.15 156.929 1169.67 157.755 1169.11 158.799C1167.99 160.885 1166.62 163.873 1165.62 167.354C1165.12 169.09 1164.75 170.768 1164.53 172.32C1164.32 173.872 1164.24 175.275 1164.27 176.46C1164.28 177.645 1164.37 178.597 1164.44 179.256C1164.47 179.59 1164.52 179.84 1164.53 180.016C1164.55 180.191 1164.56 180.283 1164.55 180.283H1164.56Z"
                    fill="white" />
                <path
                    d="M1172.57 154.717C1172.57 154.717 1172.54 154.809 1172.47 154.984C1172.38 155.176 1172.28 155.418 1172.15 155.727C1171.86 156.395 1171.46 157.313 1170.96 158.439C1169.97 160.735 1168.6 163.915 1167.55 167.587C1166.49 171.251 1166.09 174.707 1166.13 177.202C1166.14 178.454 1166.23 179.456 1166.32 180.149C1166.35 180.499 1166.4 180.766 1166.42 180.95C1166.44 181.134 1166.45 181.234 1166.44 181.234C1166.43 181.234 1166.41 181.142 1166.37 180.958C1166.34 180.775 1166.27 180.508 1166.23 180.166C1166.12 179.473 1166.01 178.463 1165.97 177.202C1165.89 174.69 1166.27 171.201 1167.33 167.52C1168.39 163.84 1169.78 160.651 1170.82 158.373C1171.33 157.229 1171.77 156.319 1172.07 155.685L1172.42 154.959C1172.51 154.792 1172.56 154.709 1172.57 154.717Z"
                    fill="white" />
                <path
                    d="M1189.99 134.468C1189.99 134.468 1189.92 134.518 1189.78 134.602C1189.61 134.694 1189.41 134.802 1189.16 134.936C1188.62 135.219 1187.83 135.62 1186.85 136.104C1184.88 137.072 1182.14 138.341 1179.06 139.618C1175.97 140.895 1173.13 141.938 1171.06 142.648C1170.02 142.998 1169.18 143.274 1168.6 143.458L1167.92 143.658C1167.77 143.7 1167.68 143.725 1167.68 143.716C1167.68 143.708 1167.76 143.675 1167.91 143.616C1168.08 143.549 1168.3 143.474 1168.57 143.374C1169.17 143.157 1170 142.857 1171 142.498C1173.06 141.755 1175.88 140.686 1178.96 139.409C1182.05 138.132 1184.8 136.889 1186.77 135.962C1187.74 135.503 1188.53 135.136 1189.11 134.861L1189.76 134.568C1189.91 134.502 1189.98 134.468 1189.99 134.477V134.468Z"
                    fill="white" />
                <path
                    d="M1189.35 133.408C1189.35 133.408 1189.28 133.458 1189.14 133.542L1188.53 133.876C1188 134.159 1187.22 134.56 1186.25 135.027C1184.31 135.971 1181.58 137.198 1178.51 138.374C1175.42 139.551 1172.58 140.461 1170.51 141.054C1169.47 141.354 1168.62 141.579 1168.04 141.721L1167.37 141.88C1167.21 141.913 1167.12 141.93 1167.12 141.922C1167.12 141.922 1167.2 141.888 1167.35 141.838L1168.02 141.638C1168.62 141.454 1169.45 141.204 1170.47 140.903C1172.52 140.269 1175.36 139.343 1178.43 138.166C1181.51 136.989 1184.23 135.787 1186.19 134.886C1187.14 134.435 1187.92 134.068 1188.5 133.8C1188.76 133.684 1188.96 133.583 1189.13 133.508C1189.27 133.442 1189.36 133.417 1189.36 133.417L1189.35 133.408Z"
                    fill="white" />
                <path
                    d="M1165.6 113.101C1165.6 113.101 1165.06 113.31 1164.19 113.677C1163.33 114.036 1162.18 114.62 1161.01 115.438C1159.84 116.256 1158.9 117.149 1158.27 117.842C1157.63 118.526 1157.28 118.994 1157.25 118.969C1157.23 118.96 1157.32 118.835 1157.46 118.618C1157.61 118.401 1157.84 118.092 1158.14 117.733C1158.75 117.016 1159.69 116.089 1160.88 115.255C1162.06 114.428 1163.25 113.852 1164.13 113.527C1164.57 113.36 1164.94 113.243 1165.2 113.185C1165.46 113.118 1165.6 113.093 1165.6 113.101Z"
                    fill="white" />
                <path
                    d="M1165.39 112.075C1165.39 112.075 1164.77 112.308 1163.79 112.701C1162.81 113.093 1161.48 113.694 1160.08 114.503C1158.68 115.321 1157.51 116.198 1156.68 116.865C1155.86 117.533 1155.38 117.984 1155.36 117.959C1155.35 117.95 1155.46 117.825 1155.67 117.608C1155.88 117.391 1156.18 117.091 1156.58 116.74C1157.38 116.031 1158.56 115.129 1159.97 114.303C1161.38 113.477 1162.73 112.892 1163.74 112.542C1164.24 112.367 1164.66 112.233 1164.94 112.166C1165.23 112.091 1165.39 112.058 1165.39 112.075Z"
                    fill="white" />
                <path
                    d="M1195.54 115.38C1195.54 115.438 1194.65 115.355 1193.61 115.021C1192.58 114.687 1191.81 114.245 1191.85 114.186C1191.88 114.128 1192.67 114.478 1193.69 114.804C1194.7 115.129 1195.55 115.313 1195.54 115.38Z"
                    fill="white" />
                <path
                    d="M1194.55 114.203C1194.54 114.261 1193.86 114.094 1193.05 113.819C1192.25 113.543 1191.6 113.276 1191.63 113.218C1191.65 113.159 1192.32 113.326 1193.13 113.602C1193.94 113.877 1194.58 114.144 1194.55 114.203Z"
                    fill="white" />
                <path
                    d="M1173.19 117.333C1173.25 117.366 1172.87 118.034 1172.52 118.894C1172.16 119.762 1171.96 120.496 1171.89 120.48C1171.83 120.471 1171.93 119.695 1172.31 118.802C1172.67 117.917 1173.15 117.291 1173.2 117.325L1173.19 117.333Z"
                    fill="white" />
                <path
                    d="M1172.22 115.814C1172.27 115.856 1171.8 116.49 1171.32 117.325C1170.85 118.159 1170.54 118.885 1170.48 118.86C1170.42 118.844 1170.64 118.068 1171.13 117.216C1171.62 116.356 1172.17 115.781 1172.22 115.822L1172.22 115.814Z"
                    fill="white" />
                <path
                    d="M1214.18 120.513C1214.19 120.571 1208.45 122.566 1201.35 124.962C1194.25 127.357 1188.48 129.26 1188.46 129.193C1188.44 129.135 1194.17 127.14 1201.28 124.745C1208.38 122.349 1214.15 120.446 1214.17 120.513H1214.18Z"
                    fill="white" />
                <path
                    d="M1215.6 123.075C1215.62 123.134 1209.73 124.97 1202.45 127.173C1195.15 129.377 1189.24 131.113 1189.22 131.054C1189.21 130.996 1195.1 129.16 1202.38 126.956C1209.66 124.753 1215.59 123.017 1215.6 123.075Z"
                    fill="white" />
                <path
                    d="M1198.04 164.716C1198.04 164.716 1197.88 164.825 1197.59 164.975C1197.29 165.125 1196.85 165.342 1196.31 165.593C1195.23 166.093 1193.72 166.753 1192.02 167.412C1190.32 168.072 1188.76 168.606 1187.62 168.956C1187.06 169.132 1186.59 169.274 1186.27 169.357C1185.95 169.44 1185.77 169.482 1185.76 169.474C1185.76 169.457 1185.93 169.39 1186.25 169.274C1186.61 169.148 1187.05 168.99 1187.58 168.806C1188.71 168.414 1190.25 167.855 1191.95 167.204C1193.64 166.544 1195.15 165.918 1196.25 165.451C1196.77 165.234 1197.2 165.05 1197.55 164.9C1197.86 164.775 1198.04 164.708 1198.05 164.725L1198.04 164.716Z"
                    fill="white" />
                <path
                    d="M1198.59 166.703C1198.61 166.761 1195.45 167.955 1191.52 169.357C1187.6 170.768 1184.4 171.861 1184.37 171.803C1184.35 171.744 1187.51 170.551 1191.44 169.148C1195.36 167.738 1198.56 166.644 1198.59 166.703Z"
                    fill="white" />
                <path
                    d="M1214.15 153.866C1214.15 153.866 1213.94 153.999 1213.54 154.2C1213.14 154.4 1212.54 154.675 1211.8 155.009C1210.33 155.669 1208.25 156.503 1205.91 157.279C1203.57 158.056 1201.41 158.623 1199.84 158.982C1199.05 159.157 1198.41 159.291 1197.96 159.374C1197.52 159.458 1197.27 159.491 1197.27 159.475C1197.27 159.458 1197.51 159.391 1197.95 159.283L1199.8 158.824C1201.35 158.431 1203.5 157.839 1205.84 157.062C1208.17 156.286 1210.24 155.477 1211.74 154.859C1212.45 154.558 1213.04 154.308 1213.49 154.116C1213.91 153.941 1214.14 153.849 1214.15 153.866Z"
                    fill="white" />
                <path
                    d="M1214.2 151.787C1214.2 151.787 1213.98 151.921 1213.54 152.121C1213.12 152.321 1212.49 152.597 1211.71 152.931C1210.15 153.59 1207.98 154.45 1205.53 155.284C1203.08 156.119 1200.84 156.77 1199.2 157.196C1198.38 157.413 1197.71 157.571 1197.25 157.671C1196.79 157.772 1196.53 157.822 1196.52 157.805C1196.51 157.788 1196.77 157.713 1197.22 157.58L1199.15 157.029C1200.77 156.561 1203 155.894 1205.44 155.059C1207.89 154.224 1210.07 153.398 1211.64 152.772C1212.39 152.472 1213.02 152.221 1213.49 152.029C1213.94 151.854 1214.18 151.762 1214.19 151.779L1214.2 151.787Z"
                    fill="white" />
                <path
                    d="M1234.65 148.115C1234.65 148.115 1234.57 148.132 1234.44 148.148L1233.85 148.207C1233.59 148.223 1233.27 148.257 1232.92 148.315C1232.55 148.374 1232.13 148.415 1231.68 148.507C1231.22 148.591 1230.73 148.682 1230.21 148.824C1229.67 148.941 1229.12 149.116 1228.54 149.292C1227.38 149.676 1226.13 150.176 1224.88 150.811C1223.63 151.462 1222.48 152.188 1221.49 152.906C1221.01 153.281 1220.54 153.624 1220.13 153.982C1219.71 154.325 1219.34 154.675 1219.01 154.992C1218.67 155.301 1218.38 155.618 1218.13 155.877C1217.87 156.136 1217.66 156.378 1217.49 156.578L1217.09 157.029C1217 157.129 1216.95 157.179 1216.94 157.179C1216.93 157.179 1216.98 157.112 1217.06 157.004L1217.43 156.528C1217.58 156.32 1217.78 156.069 1218.03 155.802C1218.28 155.527 1218.56 155.201 1218.89 154.884C1219.23 154.55 1219.58 154.199 1220.01 153.841C1220.41 153.465 1220.88 153.114 1221.37 152.73C1222.36 151.996 1223.5 151.261 1224.77 150.602C1226.04 149.959 1227.3 149.467 1228.48 149.083C1229.07 148.908 1229.62 148.741 1230.17 148.632C1230.7 148.499 1231.2 148.415 1231.66 148.34C1232.12 148.248 1232.53 148.223 1232.91 148.182C1233.27 148.132 1233.59 148.115 1233.85 148.115C1234.09 148.115 1234.28 148.098 1234.45 148.098C1234.58 148.098 1234.66 148.098 1234.66 148.106L1234.65 148.115Z"
                    fill="white" />
                <path
                    d="M1233.97 146.245C1233.97 146.245 1233.9 146.27 1233.77 146.287C1233.61 146.312 1233.42 146.337 1233.18 146.37C1232.92 146.404 1232.62 146.445 1232.26 146.512C1231.9 146.579 1231.49 146.629 1231.04 146.738C1230.59 146.829 1230.1 146.938 1229.58 147.08C1229.06 147.205 1228.52 147.389 1227.94 147.564C1226.8 147.956 1225.56 148.449 1224.31 149.066C1223.07 149.701 1221.93 150.393 1220.93 151.078C1220.44 151.428 1219.98 151.762 1219.56 152.104C1219.13 152.43 1218.75 152.764 1218.41 153.064C1218.06 153.356 1217.77 153.657 1217.5 153.899C1217.23 154.149 1217.02 154.366 1216.83 154.558C1216.67 154.725 1216.53 154.867 1216.42 154.976C1216.32 155.067 1216.27 155.118 1216.26 155.109C1216.26 155.109 1216.29 155.051 1216.38 154.942C1216.49 154.817 1216.62 154.667 1216.77 154.492C1216.93 154.3 1217.14 154.058 1217.41 153.807C1217.67 153.548 1217.95 153.24 1218.3 152.939C1218.64 152.63 1219.02 152.288 1219.44 151.954C1219.85 151.604 1220.33 151.261 1220.82 150.903C1221.82 150.201 1222.96 149.5 1224.22 148.858C1225.48 148.232 1226.73 147.739 1227.88 147.355C1228.47 147.18 1229.02 147.005 1229.55 146.888C1230.07 146.746 1230.57 146.654 1231.02 146.571C1231.47 146.471 1231.89 146.429 1232.25 146.379C1232.61 146.32 1232.92 146.295 1233.18 146.279C1233.42 146.262 1233.62 146.254 1233.77 146.237C1233.91 146.237 1233.98 146.237 1233.98 146.237L1233.97 146.245Z"
                    fill="white" />
                <path
                    d="M1218.73 180.391C1218.68 180.391 1218.85 179.556 1218.9 178.196C1218.93 177.52 1218.91 176.71 1218.83 175.817C1218.74 174.924 1218.58 173.956 1218.32 172.954C1218.04 171.961 1217.7 171.035 1217.33 170.217C1216.96 169.407 1216.57 168.698 1216.2 168.122C1215.48 166.978 1214.92 166.344 1214.95 166.31C1214.96 166.302 1215.11 166.452 1215.36 166.744C1215.48 166.886 1215.64 167.062 1215.8 167.287C1215.96 167.504 1216.16 167.746 1216.34 168.038C1216.73 168.606 1217.13 169.315 1217.53 170.133C1217.91 170.959 1218.27 171.886 1218.54 172.904C1218.81 173.914 1218.97 174.907 1219.05 175.809C1219.12 176.71 1219.13 177.528 1219.08 178.213C1219.07 178.555 1219.02 178.864 1218.98 179.131C1218.96 179.398 1218.92 179.631 1218.88 179.815C1218.8 180.191 1218.75 180.399 1218.73 180.391H1218.73Z"
                    fill="white" />
                <path
                    d="M1220.49 180.282C1220.49 180.282 1220.49 180.057 1220.55 179.656C1220.61 179.256 1220.66 178.68 1220.69 177.962C1220.76 176.535 1220.68 174.532 1220.1 172.428C1219.81 171.377 1219.43 170.409 1219.03 169.549C1218.59 168.714 1218.17 167.971 1217.73 167.404C1216.89 166.244 1216.23 165.643 1216.26 165.609C1216.27 165.601 1216.43 165.743 1216.73 166.027C1216.88 166.16 1217.05 166.335 1217.23 166.561C1217.43 166.778 1217.64 167.02 1217.86 167.312C1218.32 167.88 1218.76 168.614 1219.21 169.465C1219.63 170.325 1220.02 171.31 1220.32 172.378C1220.9 174.515 1220.95 176.543 1220.85 177.987C1220.79 178.705 1220.72 179.289 1220.63 179.682C1220.56 180.074 1220.51 180.291 1220.49 180.291V180.282Z"
                    fill="white" />
                <path
                    d="M1168.86 106.106L1177.01 117.198L1187.55 125.67L1192.3 117.39L1191.49 109.653L1190.81 103.168C1190.81 103.168 1199.28 101.048 1198.6 92.4341C1198.28 88.2775 1196.91 79.764 1195.58 72.0769C1194.15 63.8054 1186.63 58.0213 1178.28 58.7808L1177.46 58.8559C1168.57 60.1914 1164.73 68.5045 1166.32 77.3686L1168.86 106.106Z"
                    fill="#FFBF9D" />
                <path
                    d="M1190.81 103.168C1190.81 103.168 1185.42 104.103 1179.32 100.998C1179.32 100.998 1182.53 106.949 1191.03 105.397L1190.8 103.168H1190.81Z"
                    fill="#81392D" />
                <path
                    d="M1194.15 78.3451C1194.23 78.9878 1193.75 79.5971 1193.08 79.6889C1192.4 79.7891 1191.8 79.3467 1191.71 78.6957C1191.63 78.053 1192.11 77.4437 1192.78 77.3435C1193.45 77.2434 1194.06 77.6941 1194.15 78.3368V78.3451Z"
                    fill="#1A2E35" />
                <path
                    d="M1194.2 75.9915C1194.07 76.1668 1193.07 75.5575 1191.75 75.6827C1190.44 75.7912 1189.53 76.5591 1189.37 76.4089C1189.3 76.3421 1189.42 76.0416 1189.81 75.6911C1190.2 75.3488 1190.88 74.9816 1191.7 74.9148C1192.53 74.8481 1193.25 75.0818 1193.67 75.3572C1194.1 75.6326 1194.27 75.9081 1194.2 75.9915Z"
                    fill="#1A2E35" />
                <path
                    d="M1181.32 79.5307C1181.41 80.1817 1180.92 80.7826 1180.26 80.8745C1179.58 80.9746 1178.97 80.5323 1178.89 79.8812C1178.81 79.2385 1179.29 78.6292 1179.96 78.5291C1180.63 78.4289 1181.24 78.8796 1181.32 79.5223V79.5307Z"
                    fill="#1A2E35" />
                <path
                    d="M1181.01 76.818C1180.9 77.01 1179.85 76.5175 1178.55 76.7763C1177.25 77.0267 1176.43 77.8864 1176.26 77.7528C1176.17 77.6944 1176.27 77.3772 1176.62 76.9933C1176.97 76.6094 1177.61 76.1753 1178.41 76.0167C1179.22 75.8582 1179.96 76.0168 1180.42 76.2421C1180.88 76.4675 1181.07 76.7262 1181.01 76.8097V76.818Z"
                    fill="#1A2E35" />
                <path
                    d="M1186.85 87.2512C1186.83 87.1761 1187.64 86.9591 1188.96 86.6669C1189.29 86.6002 1189.6 86.5084 1189.64 86.2663C1189.7 86.0159 1189.52 85.6654 1189.32 85.2898C1188.93 84.5052 1188.52 83.6789 1188.09 82.8108C1186.37 79.2802 1185.1 76.359 1185.24 76.2922C1185.38 76.2254 1186.89 79.0299 1188.61 82.5688C1189.02 83.4452 1189.41 84.2715 1189.8 85.0644C1189.95 85.44 1190.22 85.849 1190.09 86.3748C1190.02 86.6336 1189.79 86.8422 1189.58 86.9173C1189.37 87.0008 1189.18 87.0258 1189.01 87.0509C1187.68 87.2429 1186.86 87.3263 1186.84 87.2512H1186.85Z"
                    fill="#1A2E35" />
                <path
                    d="M1180.68 71.0921C1180.58 71.4593 1179.25 71.4093 1177.71 71.7431C1176.17 72.0436 1174.97 72.6112 1174.73 72.3023C1174.62 72.1521 1174.82 71.8015 1175.29 71.4009C1175.76 71.0086 1176.53 70.608 1177.45 70.416C1178.36 70.2324 1179.23 70.2992 1179.81 70.4744C1180.41 70.6497 1180.71 70.9085 1180.67 71.0837L1180.68 71.0921Z"
                    fill="#1A2E35" />
                <path
                    d="M1193.68 73.4126C1193.47 73.7381 1192.54 73.5044 1191.44 73.5879C1190.34 73.638 1189.44 73.9718 1189.2 73.6797C1189.09 73.5378 1189.21 73.2206 1189.59 72.9035C1189.96 72.5863 1190.6 72.2942 1191.36 72.2441C1192.11 72.2024 1192.8 72.411 1193.2 72.6865C1193.62 72.9619 1193.77 73.254 1193.69 73.4126H1193.68Z"
                    fill="#1A2E35" />
                <path
                    d="M1167.6 83.6789C1167.45 83.6289 1161.54 82.4687 1162.26 88.3363C1162.98 94.2039 1168.71 92.2675 1168.7 92.0923C1168.69 91.9253 1167.6 83.6789 1167.6 83.6789Z"
                    fill="#FFBF9D" />
                <path
                    d="M1166.63 90.0891C1166.63 90.0891 1166.54 90.1726 1166.37 90.2727C1166.22 90.3729 1165.93 90.4563 1165.62 90.3812C1164.97 90.231 1164.32 89.3129 1164.17 88.2612C1164.08 87.727 1164.13 87.2095 1164.27 86.7672C1164.4 86.3164 1164.64 85.9826 1164.94 85.8908C1165.24 85.7823 1165.48 85.9409 1165.57 86.0994C1165.67 86.2497 1165.65 86.3749 1165.68 86.3832C1165.7 86.3999 1165.8 86.2664 1165.72 86.0327C1165.67 85.9158 1165.59 85.7906 1165.44 85.6905C1165.28 85.5903 1165.07 85.5569 1164.86 85.607C1164.41 85.6905 1164.06 86.1579 1163.91 86.6503C1163.73 87.1428 1163.67 87.7354 1163.76 88.328C1163.94 89.5048 1164.68 90.5398 1165.56 90.6733C1165.98 90.7318 1166.31 90.5648 1166.47 90.4063C1166.64 90.2393 1166.65 90.1058 1166.63 90.0974V90.0891Z"
                    fill="#FFBF9D" />
                <path
                    d="M1195.62 61.9527C1195.26 60.8343 1194.32 59.8243 1193.15 59.7576C1193.53 58.6141 1193.03 57.2369 1192 56.6109C1190.98 55.9849 1189.52 56.1602 1188.69 57.0282C1188.6 55.2254 1186.26 53.9818 1184.72 54.9082C1184.69 53.8649 1183.87 52.8967 1182.85 52.688C1181.82 52.4877 1180.7 53.072 1180.27 54.0318C1178.86 52.037 1175.39 52.062 1174.01 54.0903C1171.59 53.4643 1168.82 55.0084 1168.07 57.3955C1166.16 57.6709 1164.5 59.2317 1164.1 61.1181C1162.88 61.3351 1161.8 62.2365 1161.38 63.405C1160.95 64.5735 1161.19 65.9591 1161.98 66.9106C1160.56 67.7619 1160.47 70.149 1161.82 71.1089C1160.98 71.618 1160.48 72.628 1160.59 73.5961C1160.69 74.5644 1161.39 75.4491 1162.31 75.7746C1161.45 75.9582 1161.21 77.1351 1161.54 77.9447C1161.88 78.7543 1162.56 79.3636 1162.98 80.1398C1163.32 80.7742 1163.47 81.5003 1163.77 82.1514C1164.33 83.3867 1165.47 84.3298 1166.78 84.672C1166.74 84.7388 1166.69 84.7972 1166.65 84.864C1166.57 85.6319 1167.66 86.0576 1168.34 85.6903C1169.02 85.3231 1169.36 84.5552 1169.71 83.8708C1170.11 83.0778 1170.59 82.3099 1170.72 81.4336C1170.86 80.5572 1170.52 79.5306 1169.71 79.1967C1170.69 78.771 1171.25 77.6693 1171.35 76.6009C1171.45 75.5326 1171.16 74.4642 1170.87 73.4292C1170.46 71.9018 1170.04 70.366 1169.62 68.8386C1171.75 68.5966 1173.67 67.0608 1174.39 65.0409C1176.02 66.0759 1178.51 65.2246 1179.16 63.405C1180.03 65.4499 1182.69 66.5099 1184.72 65.6335C1184.6 66.8688 1186.88 67.8036 1188.11 68.0207C1189.33 68.2293 1190.75 67.2528 1190.75 67.2528C1190.75 67.2528 1192.92 68.2877 1194 67.7285C1195.07 67.186 1196.43 65.6335 1195.6 64.5318C1195.6 64.5318 1195.97 63.0711 1195.6 61.9527H1195.62Z"
                    fill="#1A2E35" />
                <path
                    d="M1161.52 71.1174C1161.58 71.0924 1161.64 71.518 1162.17 71.8269C1162.42 71.9688 1162.78 72.0606 1163.14 71.9103C1163.49 71.7768 1163.83 71.4095 1163.88 70.9672L1163.93 70.6083L1164.22 70.8253C1164.64 71.1341 1165.32 71.2176 1165.85 70.9338C1166.45 70.6083 1166.74 69.8654 1166.62 69.2895L1166.55 68.9473L1166.88 69.0475C1167.3 69.181 1167.75 69.1059 1168.07 68.9306C1168.41 68.7553 1168.62 68.4799 1168.74 68.2295C1168.98 67.712 1168.91 67.3448 1168.97 67.3448C1168.99 67.3281 1169.17 67.7037 1168.97 68.3297C1168.86 68.6301 1168.64 68.989 1168.24 69.2311C1167.86 69.4731 1167.32 69.5983 1166.77 69.4398L1167.02 69.1977C1167.2 69.9405 1166.87 70.8837 1166.07 71.3177C1165.36 71.6933 1164.52 71.5681 1163.98 71.1508L1164.31 71.0089C1164.22 71.6432 1163.74 72.0856 1163.28 72.2358C1162.78 72.4028 1162.32 72.2358 1162.04 72.0355C1161.47 71.5932 1161.5 71.0924 1161.53 71.1174H1161.52Z"
                    fill="#FB5607" />
                <path
                    d="M1161.52 71.1174C1161.58 71.0924 1161.64 71.518 1162.17 71.8269C1162.42 71.9688 1162.78 72.0606 1163.14 71.9103C1163.49 71.7768 1163.83 71.4095 1163.88 70.9672L1163.93 70.6083L1164.22 70.8253C1164.64 71.1341 1165.32 71.2176 1165.85 70.9338C1166.45 70.6083 1166.74 69.8654 1166.62 69.2895L1166.55 68.9473L1166.88 69.0475C1167.3 69.181 1167.75 69.1059 1168.07 68.9306C1168.41 68.7553 1168.62 68.4799 1168.74 68.2295C1168.98 67.712 1168.91 67.3448 1168.97 67.3448C1168.99 67.3281 1169.17 67.7037 1168.97 68.3297C1168.86 68.6301 1168.64 68.989 1168.24 69.2311C1167.86 69.4731 1167.32 69.5983 1166.77 69.4398L1167.02 69.1977C1167.2 69.9405 1166.87 70.8837 1166.07 71.3177C1165.36 71.6933 1164.52 71.5681 1163.98 71.1508L1164.31 71.0089C1164.22 71.6432 1163.74 72.0856 1163.28 72.2358C1162.78 72.4028 1162.32 72.2358 1162.04 72.0355C1161.47 71.5932 1161.5 71.0924 1161.53 71.1174H1161.52Z"
                    fill="#FB5607" />
                <path
                    d="M1161.14 76.8348C1161.14 76.8348 1161.37 76.985 1161.79 77.0267C1162.18 77.0768 1162.92 76.9182 1163.21 76.2672L1163.31 76.0502L1163.48 76.2088C1163.84 76.526 1164.46 76.6929 1165.02 76.4926C1165.57 76.3089 1166.02 75.6829 1165.99 75.0152L1165.97 74.6229L1166.32 74.8066C1166.41 74.8483 1166.5 74.8817 1166.61 74.9067C1167.07 74.9985 1167.57 74.7815 1167.76 74.4059C1167.97 74.0303 1167.92 73.5379 1167.7 73.2291L1167.45 72.8869L1167.87 72.9119C1168.38 72.9453 1168.87 72.745 1169.19 72.4612C1169.52 72.1774 1169.69 71.8101 1169.77 71.5013C1169.92 70.867 1169.76 70.4747 1169.82 70.4664C1169.83 70.4497 1170.1 70.8253 1170.01 71.5514C1169.96 71.902 1169.79 72.3443 1169.42 72.7032C1169.05 73.0621 1168.49 73.3292 1167.85 73.3125L1168.02 72.9954C1168.35 73.4294 1168.42 74.0721 1168.13 74.6146C1167.84 75.1738 1167.16 75.4826 1166.52 75.3491C1166.37 75.324 1166.23 75.2656 1166.11 75.2072L1166.43 74.9985C1166.47 75.8749 1165.88 76.6428 1165.15 76.8849C1164.42 77.1269 1163.67 76.8849 1163.24 76.4592L1163.52 76.4008C1163.32 76.8181 1162.95 77.0601 1162.63 77.1686C1162.29 77.2855 1161.98 77.2688 1161.75 77.2187C1161.27 77.1019 1161.11 76.8431 1161.13 76.8348H1161.14Z"
                    fill="#FB5607" />
                <path
                    d="M1161.14 76.8348C1161.14 76.8348 1161.37 76.985 1161.79 77.0267C1162.18 77.0768 1162.92 76.9182 1163.21 76.2672L1163.31 76.0502L1163.48 76.2088C1163.84 76.526 1164.46 76.6929 1165.02 76.4926C1165.57 76.3089 1166.02 75.6829 1165.99 75.0152L1165.97 74.6229L1166.32 74.8066C1166.41 74.8483 1166.5 74.8817 1166.61 74.9067C1167.07 74.9985 1167.57 74.7815 1167.76 74.4059C1167.97 74.0303 1167.92 73.5379 1167.7 73.2291L1167.45 72.8869L1167.87 72.9119C1168.38 72.9453 1168.87 72.745 1169.19 72.4612C1169.52 72.1774 1169.69 71.8101 1169.77 71.5013C1169.92 70.867 1169.76 70.4747 1169.82 70.4664C1169.83 70.4497 1170.1 70.8253 1170.01 71.5514C1169.96 71.902 1169.79 72.3443 1169.42 72.7032C1169.05 73.0621 1168.49 73.3292 1167.85 73.3125L1168.02 72.9954C1168.35 73.4294 1168.42 74.0721 1168.13 74.6146C1167.84 75.1738 1167.16 75.4826 1166.52 75.3491C1166.37 75.324 1166.23 75.2656 1166.11 75.2072L1166.43 74.9985C1166.47 75.8749 1165.88 76.6428 1165.15 76.8849C1164.42 77.1269 1163.67 76.8849 1163.24 76.4592L1163.52 76.4008C1163.32 76.8181 1162.95 77.0601 1162.63 77.1686C1162.29 77.2855 1161.98 77.2688 1161.75 77.2187C1161.27 77.1019 1161.11 76.8431 1161.13 76.8348H1161.14Z"
                    fill="#FB5607" />
                <path
                    d="M1183.94 54.7995C1183.94 54.7995 1183.73 54.5825 1183.24 54.474C1183 54.4239 1182.68 54.4322 1182.39 54.5992C1182.1 54.7578 1181.81 55.0916 1181.76 55.5173L1181.71 55.8595L1181.51 55.5757C1181.14 55.0666 1180.41 54.6492 1179.61 54.7244C1178.81 54.7828 1177.98 55.4505 1177.8 56.377L1177.72 56.7776L1177.45 56.4771C1176.95 55.9346 1176.14 55.6091 1175.33 55.6842C1174.52 55.7426 1173.76 56.2768 1173.36 57.0447C1173.19 57.3535 1173.1 57.6957 1173.07 58.0296L1173.06 58.2716L1172.82 58.2383C1171.67 58.0546 1170.48 58.8142 1170.14 59.8074C1169.77 60.809 1170.14 61.9274 1170.81 62.52L1171.06 62.7454L1170.74 62.8289C1169.97 63.0375 1169.4 63.5634 1169.08 64.1142C1168.76 64.6735 1168.69 65.2577 1168.73 65.7168C1168.82 66.6599 1169.22 67.094 1169.17 67.119C1169.16 67.1273 1169.05 67.0355 1168.91 66.8102C1168.77 66.5932 1168.6 66.2343 1168.52 65.7418C1168.45 65.2577 1168.48 64.6067 1168.82 63.9723C1169.15 63.3464 1169.77 62.7371 1170.64 62.4783L1170.57 62.7871C1169.79 62.1111 1169.35 60.8591 1169.76 59.6655C1170.17 58.472 1171.51 57.5956 1172.9 57.8042L1172.64 58.0129C1172.67 57.6123 1172.78 57.2116 1172.97 56.8527C1173.43 55.9597 1174.35 55.3337 1175.31 55.2669C1176.26 55.1918 1177.18 55.5674 1177.76 56.2184L1177.41 56.3186C1177.66 55.1918 1178.64 54.4406 1179.6 54.3905C1180.56 54.3321 1181.36 54.8412 1181.76 55.4422L1181.51 55.5006C1181.61 54.9748 1181.96 54.6075 1182.31 54.4322C1182.68 54.257 1183.05 54.2737 1183.31 54.3571C1183.57 54.4322 1183.74 54.5574 1183.84 54.6576C1183.94 54.7578 1183.97 54.8162 1183.96 54.8245L1183.94 54.7995Z"
                    fill="#FB5607" />
                <path
                    d="M1183.94 54.7995C1183.94 54.7995 1183.73 54.5825 1183.24 54.474C1183 54.4239 1182.68 54.4322 1182.39 54.5992C1182.1 54.7578 1181.81 55.0916 1181.76 55.5173L1181.71 55.8595L1181.51 55.5757C1181.14 55.0666 1180.41 54.6492 1179.61 54.7244C1178.81 54.7828 1177.98 55.4505 1177.8 56.377L1177.72 56.7776L1177.45 56.4771C1176.95 55.9346 1176.14 55.6091 1175.33 55.6842C1174.52 55.7426 1173.76 56.2768 1173.36 57.0447C1173.19 57.3535 1173.1 57.6957 1173.07 58.0296L1173.06 58.2716L1172.82 58.2383C1171.67 58.0546 1170.48 58.8142 1170.14 59.8074C1169.77 60.809 1170.14 61.9274 1170.81 62.52L1171.06 62.7454L1170.74 62.8289C1169.97 63.0375 1169.4 63.5634 1169.08 64.1142C1168.76 64.6735 1168.69 65.2577 1168.73 65.7168C1168.82 66.6599 1169.22 67.094 1169.17 67.119C1169.16 67.1273 1169.05 67.0355 1168.91 66.8102C1168.77 66.5932 1168.6 66.2343 1168.52 65.7418C1168.45 65.2577 1168.48 64.6067 1168.82 63.9723C1169.15 63.3464 1169.77 62.7371 1170.64 62.4783L1170.57 62.7871C1169.79 62.1111 1169.35 60.8591 1169.76 59.6655C1170.17 58.472 1171.51 57.5956 1172.9 57.8042L1172.64 58.0129C1172.67 57.6123 1172.78 57.2116 1172.97 56.8527C1173.43 55.9597 1174.35 55.3337 1175.31 55.2669C1176.26 55.1918 1177.18 55.5674 1177.76 56.2184L1177.41 56.3186C1177.66 55.1918 1178.64 54.4406 1179.6 54.3905C1180.56 54.3321 1181.36 54.8412 1181.76 55.4422L1181.51 55.5006C1181.61 54.9748 1181.96 54.6075 1182.31 54.4322C1182.68 54.257 1183.05 54.2737 1183.31 54.3571C1183.57 54.4322 1183.74 54.5574 1183.84 54.6576C1183.94 54.7578 1183.97 54.8162 1183.96 54.8245L1183.94 54.7995Z"
                    fill="#FB5607" />
                <path
                    d="M1198.07 87.7429C1197.13 87.1419 1195.67 87.7262 1195.4 88.8112C1194.86 88.1435 1193.93 87.8263 1193.1 88.0267C1192.26 88.227 1191.57 88.9281 1191.39 89.7711C1190.92 88.5441 1188.93 88.3271 1188.22 89.4372C1187.87 88.9281 1187.17 88.7027 1186.59 88.8947C1186.62 88.3188 1186.27 87.7345 1185.75 87.4841C1185.22 87.2421 1184.56 87.3506 1184.13 87.7429C1183.4 86.5911 1181.55 86.3991 1180.6 87.3756C1180.4 86.8414 1179.81 86.4742 1179.24 86.5326C1178.67 86.5911 1178.16 87.0585 1178.07 87.626C1177.47 86.9416 1176.39 86.7246 1175.57 87.1419C1175.53 86.2822 1174.52 85.6312 1173.72 85.9484C1173.88 85.2055 1172.8 84.9468 1172.22 84.4627C1171.96 84.2457 1171.78 83.9368 1171.51 83.7365C1171.23 83.5446 1170.77 83.5195 1170.62 83.8283C1170.72 83.2357 1170.32 82.6014 1169.74 82.4428C1169.17 82.2842 1168.49 82.6181 1168.27 83.1773C1168.15 83.5112 1168.17 83.8701 1168.14 84.229C1168.05 85.3725 1167.5 86.7496 1168.37 87.4925C1168.52 87.626 1168.72 87.7262 1168.78 87.9182C1168.91 88.2353 1168.61 88.5692 1168.61 88.9114C1168.61 89.312 1168.99 89.5958 1169.17 89.9464C1169.45 90.4722 1169.27 91.1065 1169.26 91.6991C1169.26 92.2917 1169.63 93.0179 1170.22 92.9261C1169.83 93.8108 1170.2 94.9626 1171.02 95.4551C1170.63 96.4817 1171.31 97.7754 1172.37 98.0425C1172 98.3847 1172.07 99.0191 1172.38 99.4114C1172.7 99.8036 1173.18 100.012 1173.64 100.213C1173.25 100.455 1173.23 101.064 1173.51 101.431C1173.78 101.798 1174.26 101.965 1174.71 102.066C1174.9 102.107 1175.12 102.149 1175.24 102.308C1175.47 102.6 1175.22 103.034 1175.29 103.401C1175.42 103.96 1176.21 104.069 1176.48 104.57C1176.72 105.02 1176.48 105.68 1176.87 106.005C1177.12 106.214 1177.5 106.147 1177.81 106.239C1178.38 106.397 1178.66 107.007 1179.04 107.449C1179.76 108.292 1180.91 108.609 1181.99 108.81C1182.54 108.91 1183.1 109.002 1183.66 109.068C1184.77 109.202 1185.89 109.269 1187.01 109.335C1187.56 109.369 1188.24 109.335 1188.5 108.843C1189.33 109.744 1191.06 109.427 1191.53 108.292C1192.54 108.501 1193.55 108.017 1194.46 107.541C1194.78 107.382 1195.1 107.215 1195.41 107.057C1196.35 106.573 1197.4 105.963 1197.63 104.92C1198.89 104.661 1199.63 103.009 1198.98 101.89C1199.43 101.99 1199.83 101.515 1199.87 101.056C1199.91 100.597 1199.72 100.154 1199.61 99.7035C1199.16 97.8756 1200.02 95.9392 1199.65 94.0946C1199.4 92.8009 1198.54 91.5656 1198.84 90.2802C1198.9 90.0131 1199 89.7544 1198.97 89.4873C1198.94 89.2202 1198.67 88.9531 1198.42 89.0533C1198.7 88.2854 1197.9 87.3589 1197.11 87.5342"
                    fill="#1A2E35" />
                <path
                    d="M1183.04 88.5191C1183.26 88.4857 1183.39 89.9213 1184.71 90.8311C1186.02 91.7409 1187.54 91.4404 1187.56 91.6407C1187.59 91.7325 1187.25 91.9496 1186.61 92.0247C1185.97 92.1081 1185.03 91.9829 1184.22 91.4321C1183.41 90.8729 1183.02 90.0716 1182.91 89.4873C1182.81 88.8947 1182.93 88.5191 1183.03 88.5191H1183.04Z"
                    fill="white" />
                <path
                    d="M1175.27 99.1694C1175.35 99.1444 1174.67 97.8757 1174.53 96.1563C1174.38 94.4369 1174.84 93.0764 1174.77 93.0597C1174.74 93.0514 1174.59 93.3769 1174.46 93.9361C1174.32 94.4953 1174.22 95.2966 1174.3 96.173C1174.37 97.0494 1174.6 97.8256 1174.82 98.3514C1175.05 98.8856 1175.25 99.1777 1175.27 99.1611V99.1694Z"
                    fill="#FB5607" />
                <path
                    d="M1175.27 99.1694C1175.35 99.1444 1174.67 97.8757 1174.53 96.1563C1174.38 94.4369 1174.84 93.0764 1174.77 93.0597C1174.74 93.0514 1174.59 93.3769 1174.46 93.9361C1174.32 94.4953 1174.22 95.2966 1174.3 96.173C1174.37 97.0494 1174.6 97.8256 1174.82 98.3514C1175.05 98.8856 1175.25 99.1777 1175.27 99.1611V99.1694Z"
                    fill="#FB5607" />
                <path
                    d="M1173.79 97.1751C1173.79 97.1751 1173.6 96.9581 1173.42 96.5408C1173.24 96.1318 1173.15 95.5058 1173.17 94.8131C1173.19 93.4109 1173.51 92.3091 1173.44 92.2924C1173.39 92.2674 1172.96 93.3691 1172.94 94.8131C1172.92 95.5309 1173.04 96.1986 1173.27 96.6159C1173.51 97.0416 1173.78 97.2002 1173.79 97.1751Z"
                    fill="#FB5607" />
                <path
                    d="M1173.79 97.1751C1173.79 97.1751 1173.6 96.9581 1173.42 96.5408C1173.24 96.1318 1173.15 95.5058 1173.17 94.8131C1173.19 93.4109 1173.51 92.3091 1173.44 92.2924C1173.39 92.2674 1172.96 93.3691 1172.94 94.8131C1172.92 95.5309 1173.04 96.1986 1173.27 96.6159C1173.51 97.0416 1173.78 97.2002 1173.79 97.1751Z"
                    fill="#FB5607" />
                <path
                    d="M1172.27 96.0651C1172.34 96.0318 1171.63 95.0051 1171.5 93.5361C1171.33 92.0671 1171.82 90.9237 1171.74 90.8986C1171.72 90.8903 1171.57 91.1574 1171.42 91.6331C1171.28 92.1089 1171.19 92.8016 1171.27 93.5612C1171.35 94.3207 1171.58 94.9801 1171.82 95.4141C1172.05 95.8565 1172.26 96.0818 1172.27 96.0651Z"
                    fill="#FB5607" />
                <path
                    d="M1172.27 96.0651C1172.34 96.0318 1171.63 95.0051 1171.5 93.5361C1171.33 92.0671 1171.82 90.9237 1171.74 90.8986C1171.72 90.8903 1171.57 91.1574 1171.42 91.6331C1171.28 92.1089 1171.19 92.8016 1171.27 93.5612C1171.35 94.3207 1171.58 94.9801 1171.82 95.4141C1172.05 95.8565 1172.26 96.0818 1172.27 96.0651Z"
                    fill="#FB5607" />
                <path
                    d="M1196.76 103.393C1196.76 103.393 1197.15 103.293 1197.55 102.817C1197.95 102.35 1198.28 101.548 1198.45 100.647C1198.61 99.7372 1198.59 98.8942 1198.5 98.3016C1198.4 97.709 1198.28 97.3584 1198.25 97.3584C1198.17 97.3584 1198.55 98.8274 1198.21 100.597C1198.05 101.482 1197.76 102.241 1197.41 102.709C1197.07 103.176 1196.73 103.351 1196.75 103.385L1196.76 103.393Z"
                    fill="#FB5607" />
                <path
                    d="M1196.76 103.393C1196.76 103.393 1197.15 103.293 1197.55 102.817C1197.95 102.35 1198.28 101.548 1198.45 100.647C1198.61 99.7372 1198.59 98.8942 1198.5 98.3016C1198.4 97.709 1198.28 97.3584 1198.25 97.3584C1198.17 97.3584 1198.55 98.8274 1198.21 100.597C1198.05 101.482 1197.76 102.241 1197.41 102.709C1197.07 103.176 1196.73 103.351 1196.75 103.385L1196.76 103.393Z"
                    fill="#FB5607" />
                <path
                    d="M1195.49 103.159C1195.49 103.159 1195.77 103.017 1196.12 102.65C1196.47 102.283 1196.87 101.69 1197.1 100.956C1197.34 100.213 1197.36 99.5033 1197.3 99.0025C1197.23 98.5017 1197.1 98.2096 1197.08 98.2179C1197.05 98.2263 1197.11 98.5268 1197.13 99.0109C1197.15 99.495 1197.1 100.171 1196.88 100.88C1196.65 101.582 1196.3 102.166 1195.99 102.541C1195.69 102.925 1195.45 103.126 1195.48 103.159H1195.49Z"
                    fill="#FB5607" />
                <path
                    d="M1195.49 103.159C1195.49 103.159 1195.77 103.017 1196.12 102.65C1196.47 102.283 1196.87 101.69 1197.1 100.956C1197.34 100.213 1197.36 99.5033 1197.3 99.0025C1197.23 98.5017 1197.1 98.2096 1197.08 98.2179C1197.05 98.2263 1197.11 98.5268 1197.13 99.0109C1197.15 99.495 1197.1 100.171 1196.88 100.88C1196.65 101.582 1196.3 102.166 1195.99 102.541C1195.69 102.925 1195.45 103.126 1195.48 103.159H1195.49Z"
                    fill="#FB5607" />
                <path
                    d="M1189.46 91.8495C1189.51 91.8662 1189.67 91.3487 1189.5 90.7311C1189.33 90.1051 1188.94 89.7378 1188.9 89.7796C1188.85 89.8213 1189.12 90.2219 1189.27 90.7895C1189.43 91.3571 1189.38 91.8412 1189.45 91.8495H1189.46Z"
                    fill="#FB5607" />
                <path
                    d="M1189.46 91.8495C1189.51 91.8662 1189.67 91.3487 1189.5 90.7311C1189.33 90.1051 1188.94 89.7378 1188.9 89.7796C1188.85 89.8213 1189.12 90.2219 1189.27 90.7895C1189.43 91.3571 1189.38 91.8412 1189.45 91.8495H1189.46Z"
                    fill="#FB5607" />
                <path
                    d="M1187.94 91.5828C1187.98 91.6245 1188.33 91.274 1188.38 90.6981C1188.44 90.1221 1188.16 89.7048 1188.11 89.7382C1188.06 89.7632 1188.21 90.1722 1188.15 90.673C1188.11 91.1822 1187.88 91.5411 1187.93 91.5828H1187.94Z"
                    fill="#FB5607" />
                <path
                    d="M1187.94 91.5828C1187.98 91.6245 1188.33 91.274 1188.38 90.6981C1188.44 90.1221 1188.16 89.7048 1188.11 89.7382C1188.06 89.7632 1188.21 90.1722 1188.15 90.673C1188.11 91.1822 1187.88 91.5411 1187.93 91.5828H1187.94Z"
                    fill="#FB5607" />
                <path
                    d="M1186.42 91.2157C1186.46 91.2574 1186.78 90.9319 1186.9 90.3977C1187.01 89.8636 1186.86 89.4379 1186.8 89.4546C1186.73 89.4713 1186.77 89.8719 1186.67 90.3477C1186.57 90.8234 1186.37 91.174 1186.43 91.2157H1186.42Z"
                    fill="#FB5607" />
                <path
                    d="M1186.42 91.2157C1186.46 91.2574 1186.78 90.9319 1186.9 90.3977C1187.01 89.8636 1186.86 89.4379 1186.8 89.4546C1186.73 89.4713 1186.77 89.8719 1186.67 90.3477C1186.57 90.8234 1186.37 91.174 1186.43 91.2157H1186.42Z"
                    fill="#FB5607" />
                <path
                    d="M1185.27 90.0637C1185.33 90.0887 1185.5 89.8717 1185.58 89.5545C1185.67 89.2373 1185.64 88.9619 1185.58 88.9619C1185.51 88.9619 1185.44 89.204 1185.36 89.4961C1185.28 89.7882 1185.22 90.0386 1185.28 90.0637H1185.27Z"
                    fill="#FB5607" />
                <path
                    d="M1185.27 90.0637C1185.33 90.0887 1185.5 89.8717 1185.58 89.5545C1185.67 89.2373 1185.64 88.9619 1185.58 88.9619C1185.51 88.9619 1185.44 89.204 1185.36 89.4961C1185.28 89.7882 1185.22 90.0386 1185.28 90.0637H1185.27Z"
                    fill="#FB5607" />
                <path
                    d="M1184.31 89.6375C1184.37 89.6626 1184.56 89.3621 1184.87 89.0867C1185.18 88.8029 1185.5 88.6526 1185.48 88.5942C1185.46 88.5358 1185.07 88.5942 1184.71 88.9197C1184.36 89.2369 1184.26 89.6292 1184.31 89.6459V89.6375Z"
                    fill="#FB5607" />
                <path
                    d="M1184.31 89.6375C1184.37 89.6626 1184.56 89.3621 1184.87 89.0867C1185.18 88.8029 1185.5 88.6526 1185.48 88.5942C1185.46 88.5358 1185.07 88.5942 1184.71 88.9197C1184.36 89.2369 1184.26 89.6292 1184.31 89.6459V89.6375Z"
                    fill="#FB5607" />
                <path
                    d="M1182.86 88.653C1182.91 88.7031 1183.29 88.3525 1183.86 88.1689C1184.44 87.9769 1184.94 88.027 1184.96 87.9602C1184.98 87.9018 1184.43 87.7349 1183.8 87.9519C1183.16 88.1606 1182.82 88.6196 1182.87 88.653H1182.86Z"
                    fill="#FB5607" />
                <path
                    d="M1182.86 88.653C1182.91 88.7031 1183.29 88.3525 1183.86 88.1689C1184.44 87.9769 1184.94 88.027 1184.96 87.9602C1184.98 87.9018 1184.43 87.7349 1183.8 87.9519C1183.16 88.1606 1182.82 88.6196 1182.87 88.653H1182.86Z"
                    fill="#FB5607" />
                <path
                    d="M1189.33 105.104C1189.33 105.104 1189.61 104.829 1189.9 104.278C1190.2 103.727 1190.5 102.901 1190.59 101.941C1190.68 100.981 1190.54 100.113 1190.35 99.5203C1190.17 98.9193 1189.97 98.5855 1189.95 98.6022C1189.91 98.6189 1190.05 98.9694 1190.2 99.562C1190.34 100.155 1190.45 100.998 1190.35 101.916C1190.26 102.842 1190 103.643 1189.75 104.203C1189.5 104.762 1189.3 105.079 1189.33 105.104Z"
                    fill="#FB5607" />
                <path
                    d="M1189.33 105.104C1189.33 105.104 1189.61 104.829 1189.9 104.278C1190.2 103.727 1190.5 102.901 1190.59 101.941C1190.68 100.981 1190.54 100.113 1190.35 99.5203C1190.17 98.9193 1189.97 98.5855 1189.95 98.6022C1189.91 98.6189 1190.05 98.9694 1190.2 99.562C1190.34 100.155 1190.45 100.998 1190.35 101.916C1190.26 102.842 1190 103.643 1189.75 104.203C1189.5 104.762 1189.3 105.079 1189.33 105.104Z"
                    fill="#FB5607" />
                <path
                    d="M1187.81 105.104C1187.85 105.146 1188.64 104.27 1188.94 102.876C1189.26 101.49 1188.91 100.355 1188.86 100.38C1188.78 100.389 1189.01 101.499 1188.71 102.826C1188.43 104.153 1187.76 105.063 1187.81 105.104Z"
                    fill="#FB5607" />
                <path
                    d="M1187.81 105.104C1187.85 105.146 1188.64 104.27 1188.94 102.876C1189.26 101.49 1188.91 100.355 1188.86 100.38C1188.78 100.389 1189.01 101.499 1188.71 102.826C1188.43 104.153 1187.76 105.063 1187.81 105.104Z"
                    fill="#FB5607" />
                <path
                    d="M1185.12 104.746C1185.12 104.746 1185.38 104.671 1185.71 104.412C1186.05 104.153 1186.46 103.719 1186.76 103.151C1187.07 102.576 1187.21 102 1187.23 101.582C1187.26 101.165 1187.21 100.906 1187.18 100.906C1187.11 100.906 1187.16 101.95 1186.56 103.043C1185.97 104.145 1185.07 104.687 1185.12 104.746Z"
                    fill="#FB5607" />
                <path
                    d="M1185.12 104.746C1185.12 104.746 1185.38 104.671 1185.71 104.412C1186.05 104.153 1186.46 103.719 1186.76 103.151C1187.07 102.576 1187.21 102 1187.23 101.582C1187.26 101.165 1187.21 100.906 1187.18 100.906C1187.11 100.906 1187.16 101.95 1186.56 103.043C1185.97 104.145 1185.07 104.687 1185.12 104.746Z"
                    fill="#FB5607" />
                <path
                    d="M801 56.7842L790 62.7842C788 59.2842 785.7 49.8842 786.5 48.2842C787.3 46.6842 793.833 45.9508 796.5 45.7842L801 56.7842Z"
                    fill="#FB5607" />
                <path
                    d="M801 56.7842L790 62.7842C788 59.2842 785.7 49.8842 786.5 48.2842C787.3 46.6842 793.833 45.9508 796.5 45.7842L801 56.7842Z"
                    fill="#FB5607" />
                <path
                    d="M816 55.2842L827 61.2842C829 57.7842 831.3 48.3842 830.5 46.7842C829.7 45.1842 823.167 44.4508 820.5 44.2842L816 55.2842Z"
                    fill="#FB5607" />
                <path
                    d="M816 55.2842L827 61.2842C829 57.7842 831.3 48.3842 830.5 46.7842C829.7 45.1842 823.167 44.4508 820.5 44.2842L816 55.2842Z"
                    fill="#FB5607" />
                <path d="M511 119.284L514 139.284" stroke="black" stroke-linecap="round" />
            </svg>
        </div>
        <!-- Lets Start SVG Ends -->
    </section>
    <!-- ======= Lets Start Section ======= -->

    <!-- ======= CTA Section ======= -->
    <section class="cta-section overflow-hidden">
        <div class="container">
            <div class="row align-items-end justify-content-end">
                <div class="col-md-6">
                    <div class="cta-content wow fadeInUp">
                        <div class="section-header ms-0">
                            <h2 class="title">
                                {{ isset($landing_page_text['join_us_sub_title']) ? $landing_page_text['join_us_sub_title'] : '' }}
                            </h2>
                        </div>
                        <div class="cta-btn-container d-flex flex-wrap">
                            @if ($toggle_restaurant_registration)
                            <a href="{{ route('restaurant.create') }}" class="btn-base">
                                <span> {{ translate('messages.be_a_restaubant_owner') }}</span>
                                <svg width="14" height="15" viewBox="0 0 14 15" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M0.875 7.67487C0.875 7.55884 0.921094 7.44756 1.00314 7.36551C1.08519 7.28346 1.19647 7.23737 1.3125 7.23737H11.6314L8.87775 4.48462C8.7956 4.40247 8.74945 4.29105 8.74945 4.17487C8.74945 4.05869 8.7956 3.94727 8.87775 3.86512C8.9599 3.78297 9.07132 3.73682 9.1875 3.73682C9.30368 3.73682 9.4151 3.78297 9.49725 3.86512L12.9973 7.36512C13.038 7.40576 13.0703 7.45404 13.0924 7.50719C13.1144 7.56034 13.1258 7.61732 13.1258 7.67487C13.1258 7.73242 13.1144 7.7894 13.0924 7.84255C13.0703 7.8957 13.038 7.94398 12.9973 7.98462L9.49725 11.4846C9.4151 11.5668 9.30368 11.6129 9.1875 11.6129C9.07132 11.6129 8.9599 11.5668 8.87775 11.4846C8.7956 11.4025 8.74945 11.291 8.74945 11.1749C8.74945 11.0587 8.7956 10.9473 8.87775 10.8651L11.6314 8.11237H1.3125C1.19647 8.11237 1.08519 8.06628 1.00314 7.98423C0.921094 7.90218 0.875 7.7909 0.875 7.67487V7.67487Z"
                                        fill="white" />
                                </svg>
                            </a>
                            @endif
                            @if ($toggle_dm_registration)
                            <a href="{{ route('deliveryman.create') }}" class="btn-base">
                                <span>{{ translate('messages.be_a_deliveryman') }}</span>
                                <svg width="14" height="15" viewBox="0 0 14 15" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M0.875 7.67487C0.875 7.55884 0.921094 7.44756 1.00314 7.36551C1.08519 7.28346 1.19647 7.23737 1.3125 7.23737H11.6314L8.87775 4.48462C8.7956 4.40247 8.74945 4.29105 8.74945 4.17487C8.74945 4.05869 8.7956 3.94727 8.87775 3.86512C8.9599 3.78297 9.07132 3.73682 9.1875 3.73682C9.30368 3.73682 9.4151 3.78297 9.49725 3.86512L12.9973 7.36512C13.038 7.40576 13.0703 7.45404 13.0924 7.50719C13.1144 7.56034 13.1258 7.61732 13.1258 7.67487C13.1258 7.73242 13.1144 7.7894 13.0924 7.84255C13.0703 7.8957 13.038 7.94398 12.9973 7.98462L9.49725 11.4846C9.4151 11.5668 9.30368 11.6129 9.1875 11.6129C9.07132 11.6129 8.9599 11.5668 8.87775 11.4846C8.7956 11.4025 8.74945 11.291 8.74945 11.1749C8.74945 11.0587 8.7956 10.9473 8.87775 10.8651L11.6314 8.11237H1.3125C1.19647 8.11237 1.08519 8.06628 1.00314 7.98423C0.921094 7.90218 0.875 7.7909 0.875 7.67487V7.67487Z"
                                        fill="white" />
                                </svg>
                            </a>
                            @endif
                        </div>
                    </div>
                </div>
                <div class="col-md-5 text-center">
                    <img class="cta-img wow fadeInUp"
                    src="{{ asset('public/assets/landing') }}/image/{{ isset($landing_page_images['mobile_app_section_image']) ? $landing_page_images['mobile_app_section_image'] : 'join_us_image.png' }}"
                    {{-- src="{{asset('/public/assets/landing/assets_new/img/cta/cta.png')}}"  --}}
                    alt="">
                </div>
            </div>
        </div>
    </section>
    <!-- ======= CTA Section ======= -->
    @endif
    <!-- ======= Testimonial Section ======= -->
    <section class="client-section pt-80 pb-80">
        <div class="container">
            <div class="section-header mw-100 text-center wow fadeInUp">
                <h2 class="title mb-lg-5">
                    <span class="text-base"> {{ isset($landing_page_text) ? $landing_page_text['testimonial_title'] : '' }}
                    </span>
                    </h2>
            </div>
            <div class="testimonial-slider wow fadeInUp">
                <div class="testimonial-item">
                    <div class="position-relative">
                        <!-- Owl Nav Start -->
                        <a href="#0" class="client-nav client-prev">
                            <svg width="31" height="31" viewBox="0 0 31 31" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <circle r="15.175" transform="matrix(-1 0 0 1 15.8248 15.5246)"
                                    fill="url(#paint0_radial_3_2525)" />
                                <path
                                    d="M18.3286 7.93701L20.1117 9.72007L14.3199 15.5245L20.1117 21.3289L18.3286 23.112L10.7411 15.5245L18.3286 7.93701Z"
                                    fill="white" />
                                <defs>
                                    <radialGradient id="paint0_radial_3_2525" cx="0" cy="0" r="1"
                                        gradientUnits="userSpaceOnUse"
                                        gradientTransform="translate(15.175 15.175) rotate(90) scale(15.175)">
                                        <stop stop-color="#FFBE0B" />
                                        <stop offset="1" stop-color="#FB5607" />
                                    </radialGradient>
                                </defs>
                            </svg>
                        </a>
                        <a href="#0" class="client-nav client-next">
                            <svg width="31" height="31" viewBox="0 0 31 31" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <circle cx="15.175" cy="15.5246" r="15.175" fill="url(#paint0_radial_3_2528)" />
                                <path
                                    d="M12.6711 7.93701L10.8881 9.72007L16.6799 15.5245L10.8881 21.3289L12.6711 23.112L20.2586 15.5245L12.6711 7.93701Z"
                                    fill="white" />
                                <defs>
                                    <radialGradient id="paint0_radial_3_2528" cx="0" cy="0" r="1"
                                        gradientUnits="userSpaceOnUse"
                                        gradientTransform="translate(15.175 15.5246) rotate(90) scale(15.175)">
                                        <stop stop-color="#FFBE0B" />
                                        <stop offset="1" stop-color="#FB5607" />
                                    </radialGradient>
                                </defs>
                            </svg>

                        </a><!-- Owl Nav End -->
                        @php($testimonial = \App\Models\BusinessSetting::where(['key' => 'testimonial'])->first())
                        @php($testimonial = isset($testimonial->value) ? json_decode($testimonial->value, true) : null)
                        <div id="sync2" class="owl-theme owl-carousel mb-4 mb-md-5">
                            @foreach ($testimonial as $data)
                            <div class="img">
                                <img src="{{ asset('public/assets/landing') }}/image/{{ $data['img'] }}" alt="">
                            </div>
                            @endforeach
                        </div>
                    </div>
                    <div id="sync1" class="owl-theme owl-carousel">
                        @foreach ($testimonial as $data)
                        <div class="slide-item">
                            <blockquote class="quote">
                                “{{ $data['detail'] }}”
                            </blockquote>
                            <h4 class="name">
                                {{ $data['name'] }}
                            </h4>
                            <span class="designation">{{ $data['position'] }}</span>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ======= Testimonial Section ======= -->
    @endsection
    @push('script_2')
    @endpush
