UPDATE `settings` SET `payload` = '6.9' WHERE `settings`.`name` = 'current_version';

SELECT @coverd_country_id:= id FROM countries WHERE covered = 1 LIMIT 1;

SET @dbname = DATABASE();
SET @tablename = "areas";
SET @columnname = "country_id";
SET @preparedStatement = (SELECT IF(
  (
    SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS
    WHERE
      (table_name = @tablename)
      AND (table_schema = @dbname)
      AND (column_name = @columnname)
  ) > 0,
  "SELECT 1",
  CONCAT("ALTER TABLE ", @tablename, " ADD `", @columnname, "` INT(11) DEFAULT ",@coverd_country_id,";")
));

PREPARE alterIfNotExists FROM @preparedStatement;
EXECUTE alterIfNotExists;
DEALLOCATE PREPARE alterIfNotExists;

ALTER TABLE costs ALTER from_area_id SET DEFAULT 0;
ALTER TABLE costs ALTER to_area_id SET DEFAULT 0;

ALTER TABLE clients ALTER def_mile_cost SET DEFAULT NULL;
ALTER TABLE clients ALTER def_shipping_cost SET DEFAULT NULL;
ALTER TABLE clients ALTER def_tax SET DEFAULT NULL;
ALTER TABLE clients ALTER def_insurance SET DEFAULT NULL;
ALTER TABLE clients ALTER def_return_mile_cost SET DEFAULT NULL;
ALTER TABLE clients ALTER def_return_cost SET DEFAULT NULL;

ALTER TABLE shipments ADD UNIQUE INDEX (order_id)

COMMIT;