<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Lookups\V2;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
abstract class PhoneNumberOptions {
    /**
     * @param string $fields Fields to return
     * @param string $countryCode Country code for national phone number lookups
     * @return FetchPhoneNumberOptions Options builder
     */
    public static function fetch(string $fields = Values::NONE, string $countryCode = Values::NONE): FetchPhoneNumberOptions {
        return new FetchPhoneNumberOptions($fields, $countryCode);
    }
}

class FetchPhoneNumberOptions extends Options {
    /**
     * @param string $fields Fields to return
     * @param string $countryCode Country code for national phone number lookups
     */
    public function __construct(string $fields = Values::NONE, string $countryCode = Values::NONE) {
        $this->options['fields'] = $fields;
        $this->options['countryCode'] = $countryCode;
    }

    /**
     * A comma-separated list of fields to return. Possible values are caller_name, sim_swap, call_forwarding, live_activity, enhanced_line_type or line_type_intelligence.
     *
     * @param string $fields Fields to return
     * @return $this Fluent Builder
     */
    public function setFields(string $fields): self {
        $this->options['fields'] = $fields;
        return $this;
    }

    /**
     * The [country code](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) used if the phone number provided is in national format.
     *
     * @param string $countryCode Country code for national phone number lookups
     * @return $this Fluent Builder
     */
    public function setCountryCode(string $countryCode): self {
        $this->options['countryCode'] = $countryCode;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Lookups.V2.FetchPhoneNumberOptions ' . $options . ']';
    }
}