<?php

$user_role = auth()->user()->role;

$admin = 1;
$auth_staff = 0;
$auth_branch = 3;
$auth_client = 4;
$auth_dilver = 5;
?>


<!-- Navbar -->
<nav class="main-header navbar navbar-expand navbar-white navbar-light">

    <!-- Left navbar links -->
    <ul class="navbar-nav">
        <li class="nav-item">
            <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
        </li>
        <li class="nav-item d-sm-inline-block mobile_section">
            <a href="<?php echo e(fr_route('/')); ?>" target="_blank"
                class="nav-link <?php echo e(active_route('/')); ?>"><?php echo app('translator')->get('view.website'); ?></a>
        </li>

        <?php if(check_module('Cargo')): ?>
            <?php if($user_role == $auth_branch || $user_role == $auth_client || auth()->user()->can('create-shipments')): ?>
            <li class="nav-item d-sm-inline-block mobile_section">
                <a href="<?php echo e(LaravelLocalization::localizeUrl(route('shipments.create'))); ?>"
                    class="nav-link <?php echo e(active_route('shipments.create')); ?>"><?php echo e(__('cargo::view.create_new_shipment')); ?></a>
            </li>
            <?php endif; ?>
        <?php endif; ?>
    </ul>

    <!-- Right navbar links -->
    <ul class="navbar-nav ml-auto">

        <!-- Navbar Search -->
        <!-- <li class="nav-item">
            <a class="nav-link" data-widget="navbar-search" href="#" role="button">
                <i class="fas fa-search"></i>
            </a>
            <div class="navbar-search-block">
                <form class="form-inline">
                    <div class="input-group input-group-sm">
                        <input class="form-control form-control-navbar" type="search" placeholder="Search" aria-label="Search">
                        <div class="input-group-append">
                        <button class="btn btn-navbar" type="submit">
                            <i class="fas fa-search"></i>
                        </button>
                        <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                            <i class="fas fa-times"></i>
                        </button>
                        </div>
                    </div>
                </form>
            </div>
        </li> -->

        <!-- Notifications Dropdown Menu -->
        <li class="nav-item dropdown">
            <a class="nav-link" data-toggle="dropdown" href="#">
                <i class="far fa-bell"></i>
                <span
                    class="badge badge-warning navbar-badge"><?php echo e(\Auth::user()->unreadNotifications->count()); ?></span>
            </a>
            <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
                <?php if(\Auth::user()->unreadNotifications->count() > 0): ?>
                    <span class="dropdown-item dropdown-header"><?php echo e(\Auth::user()->unreadNotifications->count()); ?>

                        <?php echo app('translator')->get('view.notifications'); ?></span>
                    <div class="dropdown-divider"></div>
                    <?php $__currentLoopData = \Auth::user()->unreadNotifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a href="<?php echo e(route('notification.view', ['id' => $item->id])); ?>" class="dropdown-item">
                            <i
                                class="<?php if($item->icon): ?> <?php echo e($item->icon); ?> <?php else: ?> fas fa-bell <?php endif; ?> mr-2"></i>
                            <?php echo e($item->data['message']['subject']); ?>

                            <span
                                class="float-right text-muted text-sm ml-2"><?php echo e($item->created_at->diffForHumans(null, null, true)); ?></span>
                        </a>
                        <div class="dropdown-divider"></div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <a href="#" class="dropdown-item dropdown-footer"><?php echo app('translator')->get('view.see_all_notifications'); ?></a>
                <?php else: ?>
                    <!--begin::Nav-->
                    <span class="dropdown-item dropdown-header"><?php echo app('translator')->get('view.no_new_notifications'); ?></span>
                    <div class="dropdown-divider"></div>
                    <!--end::Nav-->
                <?php endif; ?>
            </div>
        </li>

        <!-- User Dropdown Menu -->
        <li class="nav-item dropdown">
            <a class="nav-link" data-toggle="dropdown" href="#">
                <i class="fas fa-user"></i>
            </a>
            <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
                <span class="dropdown-item dropdown-header"><?php echo e(auth()->user()->name); ?></span>
                <div class="dropdown-divider"></div>
                <?php if (\Illuminate\Support\Facades\Blade::check('checkModule', 'users')): ?>

                
                <?php if($user_role == $admin): ?>
                    <a href="<?php echo e(fr_route('users.show', ['id' => auth()->id()])); ?>" class="dropdown-item">
                        <?php echo app('translator')->get('users::view.my_profile'); ?>
                    </a>
                    <div class="dropdown-divider"></div>
                    <a href="<?php echo e(fr_route('users.edit', ['id' => auth()->id()])); ?>" class="dropdown-item">
                        <?php echo app('translator')->get('users::view.account_settings'); ?>
                    </a>
                    <div class="dropdown-divider"></div>
                <?php endif; ?>

                
                <?php if($user_role == $auth_client): ?>
                    <?php
                        $item_id = Modules\Cargo\Entities\Client::where('user_id', auth()->user()->id)
                            ->pluck('id')
                            ->first();
                    ?>

                    <a href="<?php echo e(fr_route('clients.show', ['client' => $item_id])); ?>" class="dropdown-item">
                        <?php echo app('translator')->get('users::view.my_profile'); ?>
                    </a>
                    <div class="dropdown-divider"></div>
                    <a href="<?php echo e(fr_route('clients.profile', ['id' => $item_id])); ?>" class="dropdown-item">
                        <?php echo app('translator')->get('users::view.account_settings'); ?>
                    </a>
                    <div class="dropdown-divider"></div>
                    <a href="<?php echo e(fr_route('clients.manage-address')); ?>" class="dropdown-item">
                        <?php echo app('translator')->get('cargo::view.manage_address'); ?>
                    </a>
                    <div class="dropdown-divider"></div>
                <?php endif; ?>

                
                <?php if($user_role == $auth_branch): ?>
                    <?php
                        $item_id = Modules\Cargo\Entities\Branch::where('user_id', auth()->user()->id)
                            ->pluck('id')
                            ->first();
                    ?>
                    <a href="<?php echo e(fr_route('branches.show', ['branch' => $item_id])); ?>" class="dropdown-item">
                        <?php echo app('translator')->get('users::view.my_profile'); ?>
                    </a>
                    <div class="dropdown-divider"></div>
                    <a href="<?php echo e(fr_route('branches.profile', ['id' => $item_id])); ?>" class="dropdown-item">
                        <?php echo app('translator')->get('users::view.account_settings'); ?>
                    </a>
                    <div class="dropdown-divider"></div>
                <?php endif; ?>


                
                <?php if($user_role == $auth_dilver): ?>
                    <?php
                        $item_id = Modules\Cargo\Entities\Driver::where('user_id', auth()->user()->id)
                            ->pluck('id')
                            ->first();
                    ?>
                    <a href="<?php echo e(fr_route('drivers.show', ['driver' => $item_id])); ?>" class="dropdown-item">
                        <?php echo app('translator')->get('users::view.my_profile'); ?>
                    </a>
                    <div class="dropdown-divider"></div>
                    <a href="<?php echo e(fr_route('drivers.profile', ['id' => $item_id])); ?>" class="dropdown-item">
                        <?php echo app('translator')->get('users::view.account_settings'); ?>
                    </a>
                    <div class="dropdown-divider"></div>
                <?php endif; ?>


                
                <?php if($user_role == $auth_staff): ?>
                    <?php
                        $item_id = Modules\Cargo\Entities\Staff::where('user_id', auth()->user()->id)
                            ->pluck('id')
                            ->first();
                    ?>
                    <a href="<?php echo e(fr_route('staffs.show', ['staff' => $item_id])); ?>" class="dropdown-item">
                        <?php echo app('translator')->get('users::view.my_profile'); ?>
                    </a>
                    <div class="dropdown-divider"></div>
                    <a href="<?php echo e(fr_route('staffs.profile', ['id' => $item_id])); ?>" class="dropdown-item">
                        <?php echo app('translator')->get('users::view.account_settings'); ?>
                    </a>
                    <div class="dropdown-divider"></div>
                <?php endif; ?>



                <?php endif; ?>
                <form id="formLogout" method="POST" action="<?php echo e(fr_route('logout')); ?>">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="dropdown-item"><?php echo app('translator')->get('view.sign_out'); ?></button>
                </form>
                <div class="dropdown-divider"></div>
            </div>
        </li>

        <!-- Language Dropdown Menu -->
        <li class="nav-item dropdown">
            <?php if(check_module('Localization')): ?>
                <a class="nav-link" data-toggle="dropdown" href="#">
                    <?php if(Config::get('current_lang_image')): ?>
                        <img src="<?php echo e(Config::get('current_lang_image')); ?>" alt="" class="flag-icon mx-1" />
                    <?php endif; ?><?php echo e(LaravelLocalization::getCurrentLocaleName()); ?>

                </a>
                <div class="dropdown-menu dropdown-menu-right p-0">
                    <?php $__currentLoopData = Modules\Localization\Entities\Language::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    
                        <a href="<?php echo e(LaravelLocalization::getLocalizedURL($language->code)); ?>" class="dropdown-item">
                            <?php if($language->imageUrl): ?>
                                <img class="flag-icon mr-2" src="<?php echo e($language->imageUrl); ?>" alt="" />
                            <?php endif; ?> <?php echo e($language->name); ?>

                        </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>
        </li>

        <li class="nav-item">
            <a class="nav-link" data-widget="fullscreen" href="#" role="button">
                <i class="fas fa-expand-arrows-alt"></i>
            </a>
        </li>
        <!-- <li class="nav-item">
            <a class="nav-link" data-widget="control-sidebar" data-controlsidebar-slide="true" href="#" role="button">
                <i class="fas fa-th-large"></i>
            </a>
        </li> -->
    </ul>
</nav>
<!-- /.navbar -->

<style>
    @media  only screen and (max-width: 600px) {
        .mobile_section {
            display: none !important;
        }
    }

</style>
<?php /**PATH C:\laragon\www\cargo\resources\views/adminLte/components/header.blade.php ENDPATH**/ ?>