<?php

namespace Tests\Browser\Modules\Product;

use App\Models\User;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\DatabaseTransactions;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Support\Facades\File;
use Laravel\Dusk\Browser;
use Modules\Product\Entities\Attribute;
use Modules\Product\Entities\AttributeValue;
use Modules\Product\Entities\Brand;
use Modules\Product\Entities\Category;
use Modules\Product\Entities\DigitalFile;
use Modules\Product\Entities\Product;
use Modules\Product\Entities\ProductCrossSale;
use Modules\Product\Entities\ProductRelatedSale;
use Modules\Product\Entities\ProductTag;
use Modules\Product\Entities\ProductUpSale;
use Modules\Product\Entities\ProductVariations;
use Modules\Product\Entities\UnitType;
use Modules\Shipping\Entities\ProductShipping;
use Modules\Shipping\Entities\ShippingMethod;
use Tests\DuskTestCase;

use function PHPSTORM_META\type;

class ProductTest extends DuskTestCase
{
    use WithFaker;

    public function setUp(): void
    {
        parent::setUp();


    }

    public function tearDown(): void
    {
        $categories = Category::all();
        foreach($categories as $category){
            if(File::exists(public_path($category->categoryImage->image))){
                File::delete(public_path($category->categoryImage->image));
                $category->categoryImage->delete();
            }
            $category->delete();
        }

        $brands = Brand::all();
        foreach($brands as $brand){
            if(File::exists(public_path($brand->logo))){
                File::delete(public_path($brand->logo));
            }
            $brand->delete();
        }

        $atrributes = Attribute::where('name', '!=', 'Color')->get();

        foreach($atrributes as $attribute){
            $values = $attribute->values->pluck('id');
            AttributeValue::destroy($values);
            $attribute->delete();
        }

        $units = UnitType::pluck('id');
        UnitType::destroy($units);

        $shipping_methods = ShippingMethod::where('id', '!=', 1)->where('id', '!=', 2)->latest()->get();
        if(count($shipping_methods) > 0){
            foreach($shipping_methods as $shipping_method){
                if(File::exists(public_path($shipping_method->logo))){
                    File::delete(public_path($shipping_method->logo));
                }
                $shipping_method->delete();
            }
        }
        

        $products = Product::all();
        foreach($products as $product){
            
            ProductVariations::destroy($product->variations->pluck('id'));
            foreach($product->skus as $sku){
                if(File::exists(public_path($sku->variant_image))){
                    File::delete(public_path($sku->variant_image));
                }
                if(isset($sku->digital_file)){
                    if($sku->digital_file->file_source != null){
                        if(File::exists(public_path($sku->digital_file->file_source))){
                            File::delete(public_path($sku->digital_file->file_source));
                        }
                    }
                    $sku->digital_file->delete();
                }
                $sku->delete();
            }
            ProductTag::destroy($product->tags->pluck('id'));

            foreach($product->gallary_images as $image){
                if(File::exists(public_path($image->images_source))){
                    File::delete(public_path($image->images_source));
                }
                
                $image->delete();
            }
            if(File::exists(public_path($product->thumbnail_image_source))){
                File::delete(public_path($product->thumbnail_image_source));
            }

            if($product->meta_image != null){
                if(File::exists(public_path($product->meta_image))){
                    File::delete(public_path($product->meta_image));
                }
            }

            if($product->pdf != null){
                if(File::exists(public_path($product->pdf))){
                    File::delete(public_path($product->pdf));
                }
            }
            

            ProductRelatedSale::destroy($product->relatedProducts->pluck('id'));
            ProductUpSale::destroy($product->upSales->pluck('id'));
            ProductCrossSale::destroy($product->crossSales->pluck('id'));
            ProductShipping::destroy($product->shippingMethods->pluck('id'));
            $product->delete();
        }

        parent::tearDown(); // TODO: Change the autogenerated stub
    }

    /**
     * A Dusk test example.
     *
     * @return void
     */
    public function test_for_visit_product_list_page()
    {
        $this->browse(function (Browser $browser) {
            $browser->loginAs(1)
                    ->visit('/product')
                    ->assertSee('Product List');
        });
    }

    public function test_for_create_single_product(){
        $this->test_for_visit_product_list_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#order_processing_data > div.box_header.common_table_header > div > ul > li > a')
                ->assertPathIs('/product/create')
                ->assertSee('Add New Product')
                ->type('#product_name', $this->faker->name)
                ->type('#sku_single', $this->faker->slug)
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(5) > div > input',$this->faker->name)
                ->click('#add_new_category')
                ->whenAvailable('#add_category_form',function($modal){
                    $modal->type('#category_name', $this->faker->name)
                        ->type('#category_commission_rate', 5)
                        ->click('#icon')
                        ->pause(2000)
                        ->click('div:nth-child(1) > div:nth-child(5) > div > div > div.popover-content > div > div > a:nth-child(1)')
                        ->click('div:nth-child(1) > div:nth-child(3) > div > label')
                        ->attach('#image', __DIR__.'/files/default_category.png')
                        ->click('#create_btn');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Created successfully!')
                ->pause(5000)
                ->click('#category_select_div > div > div.nice-select.primary_select.mb-15.category')
                ->click('#category_select_div > div > div.nice-select.primary_select.mb-15.category.open > ul > li:nth-child(2)')
                ->click('#add_new_brand')
                ->whenAvailable('#create_brand_form', function($modal){
                    $modal->type('div > div.col-lg-8 > div > div > div:nth-child(2) > div > input', $this->faker->name)
                        ->attach('#Brand_logo', __DIR__.'/files/mi.png')
                        ->click('div > div.col-lg-4 > div > div > div.col-12 > button');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Created successfully!')
                ->pause(5000)
                ->click('#brand_select_div > div > div.nice-select.primary_select.mb-15.brand')
                ->click('#brand_select_div > div > div.nice-select.primary_select.mb-15.brand.open > ul > li:nth-child(2)')
                ->click('#add_new_unit')
                ->whenAvailable('#create_unit_form', function($modal){
                    $modal->type('#name', $this->faker->name)
                        ->click('div > div.col-lg-12.text-center > button');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Created successfully!')
                ->pause(5000)
                ->click('#unit_select_div > div > div.nice-select.primary_select.mb-15.unit')
                ->click('#unit_select_div > div > div.nice-select.primary_select.mb-15.unit.open > ul > li:nth-child(2)')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(9) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(9) > div > div > ul > li:nth-child(3)')
                ->type('#minimum_order_qty', 2)
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(11) > div > input', '10')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(1) > div.tagInput_field.mb_26 > div > input[type=text]', 'product 1')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(2) > div > div > div.note-editing-area > div.note-editable', $this->faker->paragraph)
                ->type('#selling_price', '200')
                ->type('#tax', '10')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(6) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(6) > div > div > ul > li:nth-child(2)')
                ->type('#discount', '5')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(8) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(8) > div > div > ul > li:nth-child(2)')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(10) > div > div > div.note-editing-area > div.note-editable', $this->faker->paragraph)
                ->type('#phisical_shipping_div > div > div > div > input', '0')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(16) > div > input', $this->faker->title)
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(17) > div > textarea', $this->faker->paragraph)
                ->attach('#meta_image',__DIR__.'/files/mi.png')
                ->attach('#thumbnail_image', __DIR__.'/files/product_details.png')
                ->attach('#galary_image', __DIR__.'/files/product_details_2.png')
                ->click('#add_new_shipping')
                ->whenAvailable('#create_shipping_form', function($modal){
                    $modal->type('#method_name', 'Primium Shipping')
                        ->type('#phone', $this->faker->phoneNumber)
                        ->type('#shipment_time', '3-5 days')
                        ->type('#cost', '40')
                        ->attach('#thumbnail_logo', __DIR__.'/files/mi.png')
                        ->click('div > div.col-lg-12.text-center > button');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Created successfully!')
                ->pause(5000)
                ->click('#shipping_method_div > div > div.nice-select.primary_select.mb-25.has-multiple')
                ->click('#shipping_method_div > div > div.nice-select.primary_select.mb-25.has-multiple.open > ul > li:nth-child(1)')
                ->click('#choice_form > div:nth-child(5) > div.col-12.text-center > button')
                ->assertPathIs('/product')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Product added Successfully!');
        });

    }

    public function test_for_create_digital_single_product(){
        $this->test_for_visit_product_list_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#order_processing_data > div.box_header.common_table_header > div > ul > li > a')
                ->assertPathIs('/product/create')
                ->assertSee('Add New Product')
                ->type('#product_name', $this->faker->name)
                ->type('#sku_single', $this->faker->slug)
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(5) > div > input',$this->faker->name)
                ->click('#add_new_category')
                ->whenAvailable('#add_category_form',function($modal){
                    $modal->type('#category_name', $this->faker->name)
                        ->type('#category_commission_rate', 5)
                        ->click('#icon')
                        ->pause(2000)
                        ->click('div:nth-child(1) > div:nth-child(5) > div > div > div.popover-content > div > div > a:nth-child(1)')
                        ->click('div:nth-child(1) > div:nth-child(3) > div > label')
                        ->attach('#image', __DIR__.'/files/default_category.png')
                        ->click('#create_btn');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Created successfully!')
                ->pause(5000)
                ->click('#category_select_div > div > div.nice-select.primary_select.mb-15.category')
                ->click('#category_select_div > div > div.nice-select.primary_select.mb-15.category.open > ul > li:nth-child(2)')
                ->click('#add_new_brand')
                ->whenAvailable('#create_brand_form', function($modal){
                    $modal->type('div > div.col-lg-8 > div > div > div:nth-child(2) > div > input', $this->faker->name)
                        ->attach('#Brand_logo', __DIR__.'/files/mi.png')
                        ->click('div > div.col-lg-4 > div > div > div.col-12 > button');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Created successfully!')
                ->pause(5000)
                ->click('#brand_select_div > div > div.nice-select.primary_select.mb-15.brand')
                ->click('#brand_select_div > div > div.nice-select.primary_select.mb-15.brand.open > ul > li:nth-child(2)')
                ->click('#add_new_unit')
                ->whenAvailable('#create_unit_form', function($modal){
                    $modal->type('#name', $this->faker->name)
                        ->click('div > div.col-lg-12.text-center > button');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Created successfully!')
                ->pause(5000)
                ->click('#unit_select_div > div > div.nice-select.primary_select.mb-15.unit')
                ->click('#unit_select_div > div > div.nice-select.primary_select.mb-15.unit.open > ul > li:nth-child(2)')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(9) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(9) > div > div > ul > li:nth-child(3)')
                ->type('#minimum_order_qty', 2)
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(11) > div > input', '10')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(1) > div.tagInput_field.mb_26 > div > input[type=text]', 'product 1')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(2) > div > div > div.note-editing-area > div.note-editable', $this->faker->paragraph)
                ->type('#selling_price', '200')
                ->type('#tax', '10')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(6) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(6) > div > div > ul > li:nth-child(2)')
                ->type('#discount', '5')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(8) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(8) > div > div > ul > li:nth-child(2)')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(10) > div > div > div.note-editing-area > div.note-editable', $this->faker->paragraph)
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div.col-xl-12 > div > ul > li > label > span')
                ->pause(1000)
                ->attach('#digital_file', __DIR__.'/files/digital_file.pdf')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(16) > div > input', $this->faker->title)
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(17) > div > textarea', $this->faker->paragraph)
                ->attach('#meta_image',__DIR__.'/files/mi.png')
                ->attach('#thumbnail_image', __DIR__.'/files/product_details.png')
                ->attach('#galary_image', __DIR__.'/files/product_details_2.png')
                ->click('#choice_form > div:nth-child(5) > div.col-12.text-center > button')
                ->assertPathIs('/product')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Product added Successfully!');
        });

    }

    public function test_for_edit_single_product(){
        $this->test_for_create_single_product();
        $this->browse(function (Browser $browser) {
            $product = Product::latest()->first();
            $browser->waitFor('#mainProductTable > tbody > tr:nth-child(1) > td:nth-child(8) > div > button', 25)
                ->click('#mainProductTable > tbody > tr:nth-child(1) > td:nth-child(8) > div > button')
                ->click('#mainProductTable > tbody > tr:nth-child(1) > td:nth-child(8) > div > div > a:nth-child(2)')
                ->assertPathIs('/product'.'/'.$product->id.'/edit')
                ->assertSee('Edit Product')
                ->type('#product_name', $this->faker->name)
                ->type('#sku_single', $this->faker->slug)
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(7) > div > input', $this->faker->name)
                ->click('#add_new_category')
                ->whenAvailable('#add_category_form',function($modal){
                    $modal->type('#category_name', $this->faker->name)
                        ->type('#category_commission_rate', 5)
                        ->click('#icon')
                        ->pause(2000)
                        ->click('div:nth-child(1) > div:nth-child(5) > div > div > div.popover-content > div > div > a:nth-child(1)')
                        ->click('div:nth-child(1) > div:nth-child(3) > div > label')
                        ->attach('#image', __DIR__.'/files/default_category.png')
                        ->click('#create_btn');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Created successfully!')
                ->pause(5000)
                ->click('#category_select_div > div > div.nice-select.primary_select.mb-15.category')
                ->click('#category_select_div > div > div.nice-select.primary_select.mb-15.category.open > ul > li:nth-child(2)')
                ->click('#add_new_brand')
                ->whenAvailable('#create_brand_form', function($modal){
                    $modal->type('div > div.col-lg-8 > div > div > div:nth-child(2) > div > input', $this->faker->name)
                        ->attach('#Brand_logo', __DIR__.'/files/mi.png')
                        ->click('div > div.col-lg-4 > div > div > div.col-12 > button');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Created successfully!')
                ->pause(5000)
                ->click('#brand_select_div > div > div.nice-select.primary_select.mb-15.brand')
                ->click('#brand_select_div > div > div.nice-select.primary_select.mb-15.brand.open > ul > li:nth-child(2)')
                ->click('#add_new_unit')
                ->whenAvailable('#create_unit_form', function($modal){
                    $modal->type('#name', $this->faker->name)
                        ->click('div > div.col-lg-12.text-center > button');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Created successfully!')
                ->pause(5000)
                ->click('#unit_select_div > div > div.nice-select.primary_select.mb-15.unit')
                ->click('#unit_select_div > div > div.nice-select.primary_select.mb-15.unit.open > ul > li:nth-child(2)')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(11) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(11) > div > div > ul > li:nth-child(1)')
                ->type('#minimum_order_qty', '2')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(13) > div > input', '20')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(1) > div > div > div > input[type=text]', $this->faker->title)
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(2) > div > div > div.note-editing-area > div.note-editable', $this->faker->paragraph)
                ->type('#selling_price', '201')
                ->type('#tax', '10')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(6) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(6) > div > div > ul > li:nth-child(2)')
                ->type('#discount', '20')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(8) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(8) > div > div > ul > li:nth-child(1)')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(10) > div > div > div.note-editing-area > div.note-editable', $this->faker->paragraph)
                ->type('#phisical_shipping_div > div > div > div > input', '0')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(15) > div > input', $this->faker->title)
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(16) > div > textarea', $this->faker->paragraph)
                ->attach('#meta_image',__DIR__.'/files/mi.png')
                ->attach('#thumbnail_image', __DIR__.'/files/product_details.png')
                ->attach('#galary_image', __DIR__.'/files/product_details_2.png')
                ->click('#add_new_shipping')
                ->whenAvailable('#create_shipping_form', function($modal){
                    $modal->type('#method_name', 'Primium Shipping 2')
                        ->type('#phone', $this->faker->phoneNumber)
                        ->type('#shipment_time', '3-5 days')
                        ->type('#cost', '40')
                        ->attach('#thumbnail_logo', __DIR__.'/files/mi.png')
                        ->click('div > div.col-lg-12.text-center > button');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Created successfully!')
                ->pause(5000)
                ->click('#shipping_method_div > div > div.nice-select.primary_select.mb-25.has-multiple')
                ->click('#shipping_method_div > div > div.nice-select.primary_select.mb-25.has-multiple.open > ul > li:nth-child(1)')
                ->click('#GenaralInfo > div > div.col-lg-4 > div > div > div:nth-child(11) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-4 > div > div > div:nth-child(11) > div > div > ul > li:nth-child(2)')
                ->type('#GenaralInfo > div > div.col-lg-4 > div > div > div:nth-child(12) > div > input', '/test/link')
                ->click('#GenaralInfo > div > div.col-lg-4 > div > div > div:nth-child(14) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-4 > div > div > div:nth-child(14) > div > div > ul > li:nth-child(2)')
                ->click('#GenaralInfo > div > div.col-lg-4 > div > div > div:nth-child(15) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-4 > div > div > div:nth-child(15) > div > div > ul > li:nth-child(1)')
                ->click('#choice_form > div:nth-child(5) > div > button')
                ->assertPathIs('/product')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Product updated Successfully!');
        });
    }

    public function test_for_edit_digital_single_product(){
        $this->test_for_create_digital_single_product();
        $this->browse(function (Browser $browser) {
            $product = Product::latest()->first();
            $browser->waitFor('#mainProductTable > tbody > tr:nth-child(1) > td:nth-child(8) > div > button', 20000)
                ->click('#mainProductTable > tbody > tr:nth-child(1) > td:nth-child(8) > div > button')
                ->click('#mainProductTable > tbody > tr:nth-child(1) > td:nth-child(8) > div > div > a:nth-child(2)')
                ->assertPathIs('/product'.'/'.$product->id.'/edit')
                ->assertSee('Edit Product')
                ->type('#product_name', $this->faker->name)
                ->type('#sku_single', $this->faker->slug)
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(7) > div > input', $this->faker->name)
                ->click('#add_new_category')
                ->whenAvailable('#add_category_form',function($modal){
                    $modal->type('#category_name', $this->faker->name)
                        ->type('#category_commission_rate', 5)
                        ->click('#icon')
                        ->pause(2000)
                        ->click('div:nth-child(1) > div:nth-child(5) > div > div > div.popover-content > div > div > a:nth-child(1)')
                        ->click('div:nth-child(1) > div:nth-child(3) > div > label')
                        ->attach('#image', __DIR__.'/files/default_category.png')
                        ->click('#create_btn');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Created successfully!')
                ->pause(5000)
                ->click('#category_select_div > div > div.nice-select.primary_select.mb-15.category')
                ->click('#category_select_div > div > div.nice-select.primary_select.mb-15.category.open > ul > li:nth-child(2)')
                ->click('#add_new_brand')
                ->whenAvailable('#create_brand_form', function($modal){
                    $modal->type('div > div.col-lg-8 > div > div > div:nth-child(2) > div > input', $this->faker->name)
                        ->attach('#Brand_logo', __DIR__.'/files/mi.png')
                        ->click('div > div.col-lg-4 > div > div > div.col-12 > button');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Created successfully!')
                ->pause(5000)
                ->click('#brand_select_div > div > div.nice-select.primary_select.mb-15.brand')
                ->click('#brand_select_div > div > div.nice-select.primary_select.mb-15.brand.open > ul > li:nth-child(2)')
                ->click('#add_new_unit')
                ->whenAvailable('#create_unit_form', function($modal){
                    $modal->type('#name', $this->faker->name)
                        ->click('div > div.col-lg-12.text-center > button');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Created successfully!')
                ->pause(5000)
                ->click('#unit_select_div > div > div.nice-select.primary_select.mb-15.unit')
                ->click('#unit_select_div > div > div.nice-select.primary_select.mb-15.unit.open > ul > li:nth-child(2)')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(11) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(11) > div > div > ul > li:nth-child(1)')
                ->type('#minimum_order_qty', '2')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(13) > div > input', '20')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(1) > div > div > div > input[type=text]', $this->faker->title)
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(2) > div > div > div.note-editing-area > div.note-editable', $this->faker->paragraph)
                ->type('#selling_price', '201')
                ->type('#tax', '10')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(6) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(6) > div > div > ul > li:nth-child(2)')
                ->type('#discount', '20')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(8) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(8) > div > div > ul > li:nth-child(1)')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(10) > div > div > div.note-editing-area > div.note-editable', $this->faker->paragraph)
                ->attach('#pdf',__DIR__.'/files/digital_file.pdf')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(15) > div > input', $this->faker->title)
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(16) > div > textarea', $this->faker->paragraph)
                ->attach('#meta_image',__DIR__.'/files/mi.png')
                ->attach('#thumbnail_image', __DIR__.'/files/product_details.png')
                ->attach('#galary_image', __DIR__.'/files/product_details_2.png')
                ->attach('#pdf_file', __DIR__.'/files/digital_file.pdf')

                ->click('#GenaralInfo > div > div.col-lg-4 > div > div > div:nth-child(9) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-4 > div > div > div:nth-child(9) > div > div > ul > li:nth-child(2)')
                ->type('#GenaralInfo > div > div.col-lg-4 > div > div > div:nth-child(10) > div > input', '/test/link')
                ->click('#GenaralInfo > div > div.col-lg-4 > div > div > div:nth-child(12) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-4 > div > div > div:nth-child(12) > div > div > ul > li:nth-child(2)')
                ->click('#GenaralInfo > div > div.col-lg-4 > div > div > div:nth-child(13) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-4 > div > div > div:nth-child(13) > div > div > ul > li:nth-child(2)')
                ->click('#choice_form > div:nth-child(5) > div > button')
                ->assertPathIs('/product')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Product updated Successfully!');

        });
    }

    public function test_for_clone_single_product(){
        $this->test_for_create_single_product();
        $this->browse(function (Browser $browser) {
            $product = Product::latest()->first();
            $browser->waitFor('#mainProductTable > tbody > tr:nth-child(1) > td:nth-child(8) > div > button', 30)
                ->click('#mainProductTable > tbody > tr:nth-child(1) > td:nth-child(8) > div > button')
                ->click('#mainProductTable > tbody > tr > td:nth-child(8) > div > div > a:nth-child(3)')
                ->assertPathIs('/product'.'/'.$product->id.'/clone')
                ->assertSee('Clone Product')
                ->type('#product_name', $this->faker->name)
                ->type('#sku_single', $this->faker->slug)
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(7) > div > input', $this->faker->name)
                ->click('#add_new_category')
                ->whenAvailable('#add_category_form',function($modal){
                    $modal->type('#category_name', $this->faker->name)
                        ->type('#category_commission_rate', 5)
                        ->click('#icon')
                        ->pause(2000)
                        ->click('div:nth-child(1) > div:nth-child(5) > div > div > div.popover-content > div > div > a:nth-child(1)')
                        ->click('div:nth-child(1) > div:nth-child(3) > div > label')
                        ->attach('#image', __DIR__.'/files/default_category.png')
                        ->click('#create_btn');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Created successfully!')
                ->pause(5000)
                ->click('#category_select_div > div > div.nice-select.primary_select.mb-15.category')
                ->click('#category_select_div > div > div.nice-select.primary_select.mb-15.category.open > ul > li:nth-child(2)')
                ->click('#add_new_brand')
                ->whenAvailable('#create_brand_form', function($modal){
                    $modal->type('div > div.col-lg-8 > div > div > div:nth-child(2) > div > input', $this->faker->name)
                        ->attach('#Brand_logo', __DIR__.'/files/mi.png')
                        ->click('div > div.col-lg-4 > div > div > div.col-12 > button');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Created successfully!')
                ->pause(5000)
                ->click('#brand_select_div > div > div.nice-select.primary_select.mb-15.brand')
                ->click('#brand_select_div > div > div.nice-select.primary_select.mb-15.brand.open > ul > li:nth-child(2)')
                ->click('#add_new_unit')
                ->whenAvailable('#create_unit_form', function($modal){
                    $modal->type('#name', $this->faker->name)
                        ->click('div > div.col-lg-12.text-center > button');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Created successfully!')
                ->pause(5000)
                ->click('#unit_select_div > div > div.nice-select.primary_select.mb-15.unit')
                ->click('#unit_select_div > div > div.nice-select.primary_select.mb-15.unit.open > ul > li:nth-child(2)')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(11) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(11) > div > div > ul > li:nth-child(1)')

                ->type('#minimum_order_qty', '2')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(13) > div > input', '20')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(1) > div > div > div > input[type=text]', $this->faker->title)
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(2) > div > div > div.note-editing-area > div.note-editable', $this->faker->paragraph)
                ->type('#selling_price', '201')
                ->type('#tax', '10')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(6) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(6) > div > div > ul > li:nth-child(2)')
                ->type('#discount', '20')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(8) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(8) > div > div > ul > li:nth-child(1)')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(10) > div > div > div.note-editing-area > div.note-editable', $this->faker->paragraph)
                ->type('#phisical_shipping_div > div > div > div > input', '0')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(15) > div > input', $this->faker->title)
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(16) > div > textarea', $this->faker->paragraph)
                ->attach('#meta_image',__DIR__.'/files/mi.png')
                ->attach('#thumbnail_image', __DIR__.'/files/product_details.png')
                ->attach('#galary_image', __DIR__.'/files/product_details_2.png')
                ->click('#add_new_shipping')
                ->whenAvailable('#create_shipping_form', function($modal){
                    $modal->type('#method_name', 'Primium Shipping 4565645')
                        ->type('#phone', $this->faker->phoneNumber)
                        ->type('#shipment_time', '3-5 days')
                        ->type('#cost', '40')
                        ->attach('#thumbnail_logo', __DIR__.'/files/mi.png')
                        ->click('div > div.col-lg-12.text-center > button');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Created successfully!')
                ->pause(5000)
                ->click('#shipping_method_div > div > div.nice-select.primary_select.mb-25.has-multiple')
                ->click('#shipping_method_div > div > div.nice-select.primary_select.mb-25.has-multiple.open > ul > li:nth-child(1)')
                ->click('#GenaralInfo > div > div.col-lg-4 > div > div > div:nth-child(11) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-4 > div > div > div:nth-child(11) > div > div > ul > li:nth-child(2)')
                ->type('#GenaralInfo > div > div.col-lg-4 > div > div > div:nth-child(12) > div > input', '/test/link')
                ->click('#GenaralInfo > div > div.col-lg-4 > div > div > div:nth-child(14) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-4 > div > div > div:nth-child(14) > div > div > ul > li:nth-child(2)')
                ->click('#GenaralInfo > div > div.col-lg-4 > div > div > div:nth-child(15) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-4 > div > div > div:nth-child(15) > div > div > ul > li:nth-child(1)')
                ->click('#choice_form > div:nth-child(5) > div > button')
                ->assertPathIs('/product')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Product added Successfully!');
        });
    }


    public function test_for_create_variant_product(){
        $this->browse(function (Browser $browser) {
            $browser->loginAs(1)
                ->visit('/product/create')
                ->assertSee('Add New Product')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(2) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(2) > div > div > ul > li:nth-child(2)')
                ->pause(1000)
                ->type('#product_name', $this->faker->name)
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(5) > div > input', $this->faker->slug)
                ->click('#add_new_category')
                ->whenAvailable('#add_category_form',function($modal){
                    $modal->type('#category_name', $this->faker->name)
                        ->type('#category_commission_rate', 5)
                        ->click('#icon')
                        ->pause(2000)
                        ->click('div:nth-child(1) > div:nth-child(5) > div > div > div.popover-content > div > div > a:nth-child(1)')
                        ->click('div:nth-child(1) > div:nth-child(3) > div > label')
                        ->attach('#image', __DIR__.'/files/default_category.png')
                        ->click('#create_btn');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Created successfully!')
                ->pause(5000)
                ->click('#category_select_div > div > div.nice-select.primary_select.mb-15.category')
                ->click('#category_select_div > div > div.nice-select.primary_select.mb-15.category.open > ul > li:nth-child(2)')
                ->click('#add_new_brand')
                ->whenAvailable('#create_brand_form', function($modal){
                    $modal->type('div > div.col-lg-8 > div > div > div:nth-child(2) > div > input', $this->faker->name)
                        ->attach('#Brand_logo', __DIR__.'/files/mi.png')
                        ->click('div > div.col-lg-4 > div > div > div.col-12 > button');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Created successfully!')
                ->pause(5000)
                ->click('#brand_select_div > div > div.nice-select.primary_select.mb-15.brand')
                ->click('#brand_select_div > div > div.nice-select.primary_select.mb-15.brand.open > ul > li:nth-child(2)')
                ->click('#add_new_unit')
                ->whenAvailable('#create_unit_form', function($modal){
                    $modal->type('#name', $this->faker->name)
                        ->click('div > div.col-lg-12.text-center > button');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Created successfully!')
                ->pause(5000)
                ->click('#unit_select_div > div > div.nice-select.primary_select.mb-15.unit')
                ->click('#unit_select_div > div > div.nice-select.primary_select.mb-15.unit.open > ul > li:nth-child(2)')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(9) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(9) > div > div > ul > li:nth-child(4)')
                ->type('#minimum_order_qty', 1)
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(11) > div > input', 10)
                ->click('#add_new_attribute')
                ->pause(1500)
                ->whenAvailable('#create_attribute_form', function($modal){
                    $modal->type('div > div > div > div:nth-child(1) > div > input', $this->faker->name)
                        ->type('div > div > div > div:nth-child(2) > div > textarea', $this->faker->paragraph)
                        ->click('div > div > div > div:nth-child(3) > div > div')
                        ->click('div > div > div > div:nth-child(3) > div > div > ul > li:nth-child(3)')
                        ->type('div > div > div > div:nth-child(5) > div > div > div > table > tbody > tr > td:nth-child(1) > input', $this->faker->name)
                        ->click('div > div > div > div:nth-child(5) > div > div > div > table > tbody > tr > td.pl-0.pb-0.pr-0 > div > button')
                        ->pause(1000)
                        ->click('div > div > div > div:nth-child(5) > div > div > div > table > tbody > tr:nth-child(2) > td.pl-0.pb-0.pr-0.remove > div > i')
                        ->pause(1000)
                        ->click('div > div > div > div:nth-child(5) > div > div > div > table > tbody > tr > td.pl-0.pb-0.pr-0 > div > button')
                        ->pause(1000)
                        ->type('div > div > div > div:nth-child(5) > div > div > div > table > tbody > tr:nth-child(2) > td:nth-child(1) > input', $this->faker->name)
                        ->click('div > div > div > div:nth-child(5) > div > div > div > table > tbody > tr:nth-child(1) > td.pl-0.pb-0.pr-0 > div > button')
                        ->pause(1000)
                        ->type('div > div > div > div:nth-child(5) > div > div > div > table > tbody > tr:nth-child(3) > td:nth-child(1) > input', $this->faker->name)
                        ->click('div > div > div > div.col-lg-12.text-center > button');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Created successfully!')
                ->pause(5000)
                ->click('#attribute_select_div > div > div.nice-select.primary_select.mb-15.choice_attribute.has-multiple')
                ->click('#attribute_select_div > div > div.nice-select.primary_select.mb-15.choice_attribute.has-multiple.open > ul > li:nth-child(1)')
                ->waitFor('#customer_choice_options > div > div.col-lg-4 > div > input', 25)
                ->click('#customer_choice_options > div > div.col-lg-8 > div > div')
                ->click('#customer_choice_options > div > div.col-lg-8 > div > div > ul > li:nth-child(1)')
                ->click('#customer_choice_options > div > div.col-lg-8 > div > div')
                ->click('#customer_choice_options > div > div.col-lg-8 > div > div > ul > li:nth-child(2)')
                ->waitFor('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div.col-lg-12.sku_combination > table > tbody > tr:nth-child(1)', 25)
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(1) > div.tagInput_field.mb_26 > div > input[type=text]', 'variant-product')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(2) > div > div > div.note-editing-area > div.note-editable', $this->faker->paragraph)
                ->type('#tax', '10')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(6) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(6) > div > div > ul > li:nth-child(2)')
                ->click('#discount', '8')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(8) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(8) > div > div > ul > li:nth-child(2)')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(10) > div > div > div.note-editing-area > div.note-editable', $this->faker->paragraph)
                ->type('#phisical_shipping_div > div > div > div > input', '10')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div.col-lg-12.sku_combination > table > tbody > tr:nth-child(1) > td:nth-child(2) > input', '200')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div.col-lg-12.sku_combination > table > tbody > tr:nth-child(1) > td:nth-child(3) > input', $this->faker->slug)
                ->attach('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div.col-lg-12.sku_combination > table > tbody > tr:nth-child(1) > td.variant_physical_div.text-center.pt_2 > div > div > button > input', __DIR__.'/files/product_details.png')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div.col-lg-12.sku_combination > table > tbody > tr:nth-child(2) > td:nth-child(2) > input', '210')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div.col-lg-12.sku_combination > table > tbody > tr:nth-child(2) > td:nth-child(3) > input', $this->faker->slug)
                ->attach('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div.col-lg-12.sku_combination > table > tbody > tr:nth-child(2) > td.variant_physical_div.text-center.pt_2 > div > div > button > input', __DIR__.'/files/product_details_2.png')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(16) > div > input', $this->faker->title)
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(17) > div > textarea', $this->faker->paragraph)
                ->attach('#meta_image',__DIR__.'/files/mi.png')
                ->attach('#thumbnail_image', __DIR__.'/files/product_details.png')
                ->attach('#galary_image', __DIR__.'/files/product_details_2.png')
                ->click('#add_new_shipping')
                ->whenAvailable('#create_shipping_form', function($modal){
                    $modal->type('#method_name', 'Primium Shipping 1')
                        ->type('#phone', $this->faker->phoneNumber)
                        ->type('#shipment_time', '3-5 days')
                        ->type('#cost', '40')
                        ->attach('#thumbnail_logo', __DIR__.'/files/mi.png')
                        ->click('div > div.col-lg-12.text-center > button');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Created successfully!')
                ->pause(5000)
                ->click('#shipping_method_div > div > div.nice-select.primary_select.mb-25.has-multiple')
                ->click('#shipping_method_div > div > div.nice-select.primary_select.mb-25.has-multiple.open > ul > li:nth-child(1)')
                ->type('#GenaralInfo > div > div.col-lg-4 > div > div > div:nth-child(12) > div > input', '/jwlekfkdjslkfksdfjksjfj')
                ->click('#GenaralInfo > div > div.col-lg-4 > div > div > div:nth-child(15) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-4 > div > div > div:nth-child(15) > div > div > ul > li:nth-child(2)')
                ->click('#choice_form > div:nth-child(5) > div.col-12.text-center > button')
                ->assertPathIs('/product')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Product added Successfully!');
                

        });
    }


    public function test_for_edit_variant_product(){
        $this->test_for_create_variant_product();
        $this->browse(function (Browser $browser) {
            $product = Product::latest()->first();
            $browser->waitFor('#mainProductTable > tbody > tr:nth-child(1) > td:nth-child(8) > div > button', 30)
                ->click('#mainProductTable > tbody > tr:nth-child(1) > td:nth-child(8) > div > button')
                ->click('#mainProductTable > tbody > tr:nth-child(1) > td:nth-child(8) > div > div > a:nth-child(2)')
                ->assertPathIs('/product'.'/'.$product->id.'/edit')
                ->assertSee('Edit Product')
                ->type('#product_name', $this->faker->name)
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(7) > div > input', $this->faker->name)
                ->click('#category_select_div > div > div.nice-select.primary_select.mb-15.category')
                ->click('#category_select_div > div > div.nice-select.primary_select.mb-15.category.open > ul > li.option.selected.focus')
                ->click('#brand_select_div > div > div.nice-select.primary_select.mb-15.brand')
                ->click('#brand_select_div > div > div.nice-select.primary_select.mb-15.brand.open > ul > li.option.selected.focus')
                ->click('#unit_select_div > div > div.nice-select.primary_select.mb-15.unit')
                ->click('#unit_select_div > div > div.nice-select.primary_select.mb-15.unit.open > ul > li.option.selected.focus')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(11) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(11) > div > div > ul > li:nth-child(2)')
                ->type('#minimum_order_qty', '2')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(13) > div > input', '10')
                ->click('#customer_choice_options > div > div.col-lg-8 > div > div')
                ->click('#customer_choice_options > div > div.col-lg-8 > div > div > ul > li:nth-child(3)')
                ->waitFor('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div.col-lg-12.sku_combination > table > tbody > tr:nth-child(3) > td.p-10.pt-36 > label', 25)
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(1) > div > div > div > input[type=text]', 'tag 333')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(2) > div > div > div.note-editing-area > div.note-editable', $this->faker->paragraph)
                ->type('#tax', '20')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(6) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(6) > div > div > ul > li:nth-child(1)')
                ->type('#discount', '20')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(8) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(8) > div > div > ul > li:nth-child(1)')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(10) > div > div > div.note-editing-area > div.note-editable', $this->faker->paragraph)
                ->type('#phisical_shipping_div > div > div > div > input', '0')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div.col-lg-12.sku_combination > table > tbody > tr:nth-child(3) > td:nth-child(2) > input', '220')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div.col-lg-12.sku_combination > table > tbody > tr:nth-child(3) > td:nth-child(3) > input', $this->faker->slug)
                ->attach('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div.col-lg-12.sku_combination > table > tbody > tr:nth-child(3) > td.variant_physical_div.text-center.pt_2 > div > div > button > input', __DIR__.'/files/product_details_2.png')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(15) > div > input', $this->faker->title)
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(16) > div > textarea', $this->faker->paragraph)
                ->attach('#meta_image',__DIR__.'/files/mi.png')
                ->attach('#thumbnail_image', __DIR__.'/files/product_details.png')
                ->attach('#galary_image', __DIR__.'/files/product_details_2.png')
                ->click('#choice_form > div:nth-child(5) > div > button')
                ->assertPathIs('/product')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Product updated Successfully!');
        });
    }

    public function test_for_delete_meta_image_on_edit_product(){
        $this->test_for_create_variant_product();
        $this->browse(function (Browser $browser) {
            $product = Product::latest()->first();
            $browser->waitFor('#mainProductTable > tbody > tr:nth-child(1) > td:nth-child(8) > div > button', 30)
                ->click('#mainProductTable > tbody > tr:nth-child(1) > td:nth-child(8) > div > button')
                ->click('#mainProductTable > tbody > tr:nth-child(1) > td:nth-child(8) > div > div > a:nth-child(2)')
                ->assertPathIs('/product'.'/'.$product->id.'/edit')
                ->assertSee('Edit Product')
                ->click('#metaImgDelete > i')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Deleted successfully!');
        });    
    }

    public function test_for_clone_variant_product(){
        $this->test_for_create_variant_product();
        $this->browse(function (Browser $browser) {
            $product = Product::latest()->first();
            $browser->waitFor('#mainProductTable > tbody > tr:nth-child(1) > td:nth-child(8) > div > button', 30)
                ->click('#mainProductTable > tbody > tr:nth-child(1) > td:nth-child(8) > div > button')
                ->click('#mainProductTable > tbody > tr > td:nth-child(8) > div > div > a:nth-child(3)')
                ->assertPathIs('/product'.'/'.$product->id.'/clone')
                ->assertSee('Clone Product')

                ->type('#product_name', $this->faker->name)
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(7) > div > input', $this->faker->name)
                ->click('#add_new_category')
                ->whenAvailable('#add_category_form',function($modal){
                    $modal->type('#category_name', $this->faker->name)
                        ->type('#category_commission_rate', 5)
                        ->click('#icon')
                        ->pause(2000)
                        ->click('div:nth-child(1) > div:nth-child(5) > div > div > div.popover-content > div > div > a:nth-child(1)')
                        ->click('div:nth-child(1) > div:nth-child(3) > div > label')
                        ->attach('#image', __DIR__.'/files/default_category.png')
                        ->click('#create_btn');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Created successfully!')
                ->pause(5000)
                ->click('#category_select_div > div > div.nice-select.primary_select.mb-15.category')
                ->click('#category_select_div > div > div.nice-select.primary_select.mb-15.category.open > ul > li:nth-child(2)')
                ->click('#add_new_brand')
                ->whenAvailable('#create_brand_form', function($modal){
                    $modal->type('div > div.col-lg-8 > div > div > div:nth-child(2) > div > input', $this->faker->name)
                        ->attach('#Brand_logo', __DIR__.'/files/mi.png')
                        ->click('div > div.col-lg-4 > div > div > div.col-12 > button');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Created successfully!')
                ->pause(5000)
                ->click('#brand_select_div > div > div.nice-select.primary_select.mb-15.brand')
                ->click('#brand_select_div > div > div.nice-select.primary_select.mb-15.brand.open > ul > li:nth-child(2)')
                ->click('#add_new_unit')
                ->whenAvailable('#create_unit_form', function($modal){
                    $modal->type('#name', $this->faker->name)
                        ->click('div > div.col-lg-12.text-center > button');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Created successfully!')
                ->pause(5000)
                ->click('#unit_select_div > div > div.nice-select.primary_select.mb-15.unit')
                ->click('#unit_select_div > div > div.nice-select.primary_select.mb-15.unit.open > ul > li:nth-child(2)')

                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(11) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(11) > div > div > ul > li:nth-child(2)')
                ->type('#minimum_order_qty', '2')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(1) > div:nth-child(13) > div > input', '10')
                ->click('#customer_choice_options > div > div.col-lg-8 > div > div')
                ->click('#customer_choice_options > div > div.col-lg-8 > div > div > ul > li:nth-child(3)')
                ->waitFor('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div.col-lg-12.sku_combination > table > tbody > tr:nth-child(3) > td.p-10.pt-36 > label', 25)
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(1) > div > div > div > input[type=text]', 'tag 333')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(2) > div > div > div.note-editing-area > div.note-editable', $this->faker->paragraph)
                ->type('#tax', '20')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(6) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(6) > div > div > ul > li:nth-child(1)')
                ->type('#discount', '20')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(8) > div > div')
                ->click('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(8) > div > div > ul > li:nth-child(2)')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(10) > div > div > div.note-editing-area > div.note-editable', $this->faker->paragraph)
                ->type('#phisical_shipping_div > div > div > div > input', '0')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div.col-lg-12.sku_combination > table > tbody > tr:nth-child(3) > td:nth-child(2) > input', '220')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div.col-lg-12.sku_combination > table > tbody > tr:nth-child(3) > td:nth-child(3) > input', $this->faker->slug)
                ->attach('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div.col-lg-12.sku_combination > table > tbody > tr:nth-child(3) > td.variant_physical_div.text-center.pt_2 > div > div > button > input', __DIR__.'/files/product_details_2.png')
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(15) > div > input', $this->faker->title)
                ->type('#GenaralInfo > div > div.col-lg-8 > div > div:nth-child(3) > div:nth-child(16) > div > textarea', $this->faker->paragraph)
                ->attach('#meta_image',__DIR__.'/files/mi.png')
                ->attach('#thumbnail_image', __DIR__.'/files/product_details.png')
                ->attach('#galary_image', __DIR__.'/files/product_details_2.png')
                ->click('#choice_form > div:nth-child(5) > div > button')
                ->assertPathIs('/product')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Product added Successfully!');
            });        
    }



    public function test_create_product_validate_check(){
        $this->browse(function (Browser $browser) {
            $browser->loginAs(1)
                ->visit('/product/create')
                ->assertSee('Add New Product')
                ->click('#choice_form > div:nth-child(5) > div.col-12.text-center > button')
                ->waitFor('#toast-container',25)
                ->assertSeeAnythingIn('#toast-container');
        });        
    }

    public function test_for_delete_product(){
        $this->test_for_create_single_product();
        $this->browse(function (Browser $browser) {
            $product = Product::latest()->first();
            $browser->waitFor('#mainProductTable > tbody > tr:nth-child(1) > td:nth-child(8) > div > button', 30)
                ->click('#mainProductTable > tbody > tr:nth-child(1) > td:nth-child(8) > div > button')
                ->click('#mainProductTable > tbody > tr:nth-child(1) > td:nth-child(8) > div > div > a.dropdown-item.delete_product')
                ->whenAvailable('#product_delete_modal > div > div > div.modal-body', function($modal){
                    $modal->click('div.mt-40.d-flex.justify-content-between > form > input.primary-btn.fix-gr-bg');
                })
                ->pause(5000)
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Deleted successfully!');

        });        
    }

    public function test_for_show_product(){
        $this->test_for_create_variant_product();
        $this->browse(function (Browser $browser) {
            $product = Product::latest()->first();
            $browser->waitFor('#mainProductTable > tbody > tr:nth-child(1) > td:nth-child(8) > div > button', 30)
                ->click('#mainProductTable > tbody > tr:nth-child(1) > td:nth-child(8) > div > button')
                ->click('#mainProductTable > tbody > tr:nth-child(1) > td:nth-child(8) > div > div > a.dropdown-item.product_detail')
                ->pause(15000)
                ->whenAvailable('#productDetails > div > div', function($modal){
                    $modal->assertSeeAnythingIn('div.modal-header > h4')
                        ->click('div.modal-body > form > div > div.col-12.mb-40 > div > div.QA_table.QA_table4 > div > table > tbody > tr:nth-child(1) > td:nth-child(5) > label > div');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });
    }


    public function test_for_product_status_change(){
        $this->test_for_create_single_product();
        $this->browse(function (Browser $browser) {
            $browser->waitFor('#mainProductTable > tbody > tr:nth-child(1) > td:nth-child(7) > label > div', 30)
                ->click('#mainProductTable > tbody > tr:nth-child(1) > td:nth-child(7) > label > div')
                ->pause(5000)
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });
    }

    
    public function test_for_status_change_for_sku(){
        $this->test_for_create_single_product();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > section > div > div > div.col-md-12.mb-20 > div > div > ul > li:nth-child(3)')
                ->waitForText('Product By SKU', 4)
                ->assertSee('Product By SKU')
                ->waitFor('#SKUTable > tbody > tr.odd > td:nth-child(8) > label > div', 25)
                ->click('#SKUTable > tbody > tr.odd > td:nth-child(8) > label > div')
                ->pause(5000)
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });
    }


    public function test_for_edit_product_sku(){
        $this->test_for_create_variant_product();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > section > div > div > div.col-md-12.mb-20 > div > div > ul > li:nth-child(3)')
                ->waitForText('Product By SKU', 4)
                ->assertSee('Product By SKU')
                ->waitFor('#SKUTable > tbody > tr.odd > td:nth-child(9) > div > button', 25)
                ->click('#SKUTable > tbody > tr.odd > td:nth-child(9) > div > button')
                ->click('#SKUTable > tbody > tr.odd > td:nth-child(9) > div > div > a.dropdown-item.edit_sku')
                ->whenAvailable('#sku_edit_form', function($modal){
                    $modal->type('#selling_price', '205')
                        ->attach('#variant_img', __DIR__.'/files/product_details.png')
                        ->click('#editSKUBtn');
                })
                ->pause(5000)
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });
    }

    public function test_for_delete_peoduct_sku(){
        $this->test_for_create_variant_product();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > section > div > div > div.col-md-12.mb-20 > div > div > ul > li:nth-child(3)')
                ->waitForText('Product By SKU', 4)
                ->assertSee('Product By SKU')
                ->waitFor('#SKUTable > tbody > tr.odd > td:nth-child(9) > div > button', 30)
                ->click('#SKUTable > tbody > tr.odd > td:nth-child(9) > div > button')
                ->click('#SKUTable > tbody > tr.odd > td:nth-child(9) > div > div > a.dropdown-item.delete_sku')
                ->whenAvailable('#sku_delete_form', function($modal){
                    $modal->click('input.primary-btn.fix-gr-bg');
                })
                ->pause(5000)
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Deleted successfully!');
        });
    }


    
    

}
