<?php

namespace Tests\Browser\Modules\Appearance;

use App\Models\User;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Laravel\Dusk\Browser;
use Modules\Appearance\Entities\Theme;
use Tests\DuskTestCase;

class ThemePageTest extends DuskTestCase
{

    public function setUp(): void
    {
        parent::setUp();


    }

    public function tearDown(): void
    {
        $theme = Theme::where('folder_path','!=' ,'default')->orderBy('id','desc')->first();
        if($theme){
            File::deleteDirectory(public_path('frontend/'.$theme->folder_path));
            File::deleteDirectory(base_path('resources/views/frontend/'.$theme->folder_path));
            $theme->delete();
        }

        parent::tearDown(); // TODO: Change the autogenerated stub
    }

    /**
     * A Dusk test example.
     *
     * @return void
     */
    public function test_for_theme_page()
    {
        $this->browse(function (Browser $browser) {
            $browser->loginAs(User::find(1))
                ->visit('/appearance/themes')
                ->assertSee('Themes');
        });
    }


    public function test_for_add_new(){
        $this->test_for_theme_page();
        $this->browse(function (Browser $browser) {
            $browser->press('@Add New')
                ->assertPathIs('/appearance/themes/create')
                ->assertSee('Upload Theme')
                ->attach('#document_file_1', public_path('/premium.zip'))
                ->click('#submitBtn')
                ->assertPathIs('/appearance/themes')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'New Theme Upload Successfully.');
        });
    }


    public function test_for_theme_details_page(){
        $this->test_for_add_new();

        $this->browse(function(Browser $browser){
            $theme = Theme::latest()->first();
            $browser->visit('/appearance/themes/'.$theme->id)
                ->assertSee('Theme details');
        });
    }

    public function test_for_active_theme(){
        $this->test_for_add_new();
        $this->browse(function(Browser $browser){
            $browser->click('#main-content > section > div > div > div:nth-child(2) > div > div:nth-child(2) > div > div.card-footer > div > div.col-5 > h4')
                ->click('#main-content > section > div > div > div:nth-child(2) > div > div:nth-child(2) > div > div.card-footer > div > div.col-7.footer_div > div > div.col-md-5.col-sm-12 > form > button')
                ->assertPathIs('/appearance/themes')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Theme Change Successfully.')
                ->click('#main-content > section > div > div > div:nth-child(2) > div > div:nth-child(2) > div > div.card-footer > div > div.col-5 > h4')
                ->click('#main-content > section > div > div > div:nth-child(2) > div > div:nth-child(2) > div > div.card-footer > div > div.col-7.footer_div > div > div.col-md-5.col-sm-12 > form > button')
                ->assertPathIs('/appearance/themes')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Theme Change Successfully.');
        });
    }


    public function test_for_delete_theme(){
        $this->test_for_add_new();
        $this->browse(function(Browser $browser){
            $theme = Theme::latest()->first();

            $browser->visit('/appearance/themes/'.$theme->id)
                ->assertSee('Theme details')
                ->click('#delete_btn')
                ->whenAvailable('#item_delete_form', function($modal){
                    $modal->click('#theme_delete_btn')
                    ->assertPathIs('/appearance/themes');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Theme Deleted Successfully.');

        });
    }



}
