<?php

namespace Tests\Browser\Modules\Giftcard;

use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Support\Facades\File;
use Laravel\Dusk\Browser;
use Modules\GiftCard\Entities\GiftCard;
use Tests\DuskTestCase;

class GiftcardTest extends DuskTestCase
{
    use WithFaker;

    public function setUp(): void
    {
        parent::setUp();


    }

    public function tearDown(): void
    {
        $giftcards = GiftCard::all();
        foreach($giftcards as $giftcard){
            if(File::exists(public_path($giftcard->thumbnail_image))){
                File::delete(public_path($giftcard->thumbnail_image));
            }

            if(count($giftcard->galaryImages) > 0){
                foreach($giftcard->galaryImages as $image){
                    if(File::exists(public_path($image->image_name))){
                        File::delete(public_path($image->image_name));
                    }
                    $image->delete();
                }
            }

            $giftcard->delete();
        }

        parent::tearDown(); // TODO: Change the autogenerated stub
    }
    /**
     * A Dusk test example.
     *
     * @return void
     */

    public function test_for_visit_index_page()
    {
        $this->browse(function (Browser $browser) {
            $browser->loginAs(1)
                ->visit('/admin/giftcard')
                ->assertSee('Gift Card List');
        });
    }

    public function test_for_create_giftcard(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > section > div.container-fluid.p-0 > div > div.col-12 > div > div > ul > li:nth-child(1) > a')
                ->assertPathIs('/admin/giftcard/create')
                ->assertSee('Create Gift Card')
                ->type('#name', $this->faker->name)
                ->type('#sku', substr($this->faker->slug, 0, 14))
                ->attach('#thumbnail_image', __DIR__.'/files/product_details.png')
                ->type('#selling_price', '500')
                ->click('#add_form > div > div:nth-child(1) > div.col-lg-8 > div > div:nth-child(4) > div > div')
                ->click('#add_form > div > div:nth-child(1) > div.col-lg-8 > div > div:nth-child(4) > div > div > ul > li.option.selected.focus')
                ->attach('#galary_image', __DIR__.'/files/product_details.png')
                ->type('#discount', '10')
                ->click('#add_form > div > div:nth-child(1) > div.col-lg-8 > div > div:nth-child(6) > div > div')
                ->click('#add_form > div > div:nth-child(1) > div.col-lg-8 > div > div:nth-child(6) > div > div > ul > li:nth-child(2)')

                ->click('#date')
                ->pause(1000)
                ->click('div.daterangepicker.ltr.show-calendar.opensright > div.drp-calendar.left > div.calendar-table > table > tbody > tr:nth-child(3) > td:nth-child(3)')
                ->click('div.daterangepicker.ltr.show-calendar.opensright > div.drp-calendar.right > div.calendar-table > table > tbody > tr:nth-child(4) > td:nth-child(5)')
                ->click('div.daterangepicker.ltr.show-calendar.opensright > div.drp-buttons > button.applyBtn.btn.btn-sm.btn-primary')
                ->click('#add_form > div > div:nth-child(1) > div.col-lg-4 > div > div:nth-child(5) > div > ul > li:nth-child(2) > label > span')
                ->type('#add_form > div > div:nth-child(1) > div.col-lg-12 > div > div > div.note-editing-area > div.note-editable', $this->faker->paragraph)
                ->click('#submit_btn')
                ->assertPathIs('/admin/giftcard')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Created successfully!');
        });
    }

    public function test_for_create_validate_check(){
        $this->browse(function (Browser $browser) {
            $browser->loginAs(1)
                ->visit('/admin/giftcard/create')
                ->assertSee('Create Gift Card')
                ->click('#submit_btn')
                ->assertPathIs('/admin/giftcard/create')
                ->assertSeeIn('#error_name', 'The name field is required.')
                ->assertSeeIn('#error_sku', 'The sku field is required.')
                ->assertSeeIn('#error_selling_price', 'The selling price must be a number.')
                ->assertSeeIn('#add_form > div > div:nth-child(1) > div.col-lg-4 > div > div.col-lg-10 > div > span', 'The thumbnail image field is required.');
        });        
    }

    public function test_for_edit_giftcard(){
        $this->test_for_create_giftcard();
        $this->browse(function (Browser $browser) {
            $giftcard = GiftCard::latest()->first();
            $browser->waitFor('#cardTable > tbody > tr > td:nth-child(8) > div > button', 25)
                ->click('#cardTable > tbody > tr > td:nth-child(8) > div > button')
                ->click('#cardTable > tbody > tr > td:nth-child(8) > div > div > a:nth-child(2)')
                ->assertPathIs('/admin/giftcard/edit/'.$giftcard->id)
                ->assertSee('Edit Gift Card')
                ->type('#name', $this->faker->name)
                ->type('#sku', substr($this->faker->slug, 0, 14))
                ->type('#selling_price', '200')
                ->type('#discount', '10')
                ->click('#edit_form > div > div:nth-child(1) > div.col-lg-8 > div > div:nth-child(6) > div > div')
                ->click('#edit_form > div > div:nth-child(1) > div.col-lg-8 > div > div:nth-child(6) > div > div > ul > li:nth-child(2)')
                ->click('#date')
                ->click('div.daterangepicker.ltr.show-calendar.opensright > div.drp-calendar.left > div.calendar-table > table > tbody > tr:nth-child(1) > td:nth-child(5)')
                ->click('div.daterangepicker.ltr.show-calendar.opensright > div.drp-calendar.right > div.calendar-table > table > tbody > tr:nth-child(5) > td:nth-child(4)')
                ->click('div.daterangepicker.ltr.show-calendar.opensright > div.drp-buttons > button.applyBtn.btn.btn-sm.btn-primary')
                ->type('#edit_form > div > div:nth-child(1) > div.col-lg-12 > div > div > div.note-editing-area > div.note-editable', $this->faker->paragraph)
                ->attach('#thumbnail_image', __DIR__.'/files/product_details.png')
                ->attach('#galary_image', __DIR__.'/files/product_details.png')
                ->click('#edit_form > div > div:nth-child(1) > div.col-lg-4 > div > div:nth-child(5) > div > ul > li:nth-child(2) > label > span')
                ->click('#submit_btn')
                ->assertPathIs('/admin/giftcard')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });
    }

    public function test_for_edit_validation_check(){
        $this->test_for_create_giftcard();
        $this->browse(function (Browser $browser) {
            $giftcard = GiftCard::latest()->first();
            $browser->waitFor('#cardTable > tbody > tr > td:nth-child(8) > div > button', 25)
                ->click('#cardTable > tbody > tr > td:nth-child(8) > div > button')
                ->click('#cardTable > tbody > tr > td:nth-child(8) > div > div > a:nth-child(2)')
                ->assertPathIs('/admin/giftcard/edit/'.$giftcard->id)
                ->assertSee('Edit Gift Card')
                ->type('#name', '')
                ->type('#selling_price', '')
                ->type('#discount', '')
                ->click('#edit_form > div > div:nth-child(1) > div.col-lg-8 > div > div:nth-child(6) > div > div')
                ->click('#edit_form > div > div:nth-child(1) > div.col-lg-8 > div > div:nth-child(6) > div > div > ul > li:nth-child(2)')
                ->click('#submit_btn')
                ->assertPathIs('/admin/giftcard/edit/'.$giftcard->id)
                ->assertSeeIn('#error_name', 'The name field is required.')
                ->assertSeeIn('#error_selling_price', 'The selling price must be a number.');

        });
    }

    public function test_for_delete_giftcard(){
        $this->test_for_create_giftcard();
        $this->browse(function (Browser $browser) {
            $browser->waitFor('#cardTable > tbody > tr.odd > td:nth-child(8) > div', 25)
                ->click('#cardTable > tbody > tr.odd > td:nth-child(8) > div > button')
                ->click('#cardTable > tbody > tr.odd > td:nth-child(8) > div > div > a.dropdown-item.delete_card')
                ->whenAvailable('#item_delete_form', function($modal){
                    $modal->click('#dataDeleteBtn');
                })
                ->pause(4000)
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Deleted successfully!');
                
        });
    }

    public function test_for_show_giftcard(){
        $this->test_for_create_giftcard();
        $this->browse(function (Browser $browser) {
            $giftcard = GiftCard::latest()->first();
            $browser->waitFor('#cardTable > tbody > tr.odd > td:nth-child(8) > div', 25)
                ->click('#cardTable > tbody > tr.odd > td:nth-child(8) > div > button')
                ->click('#cardTable > tbody > tr.odd > td:nth-child(8) > div > div > a:nth-child(1)')
                ->assertPathIs('/admin/giftcard/view/'. $giftcard->id)
                ->assertSee('Name: '.$giftcard->name);
        });        
    }

    public function test_for_status_change(){
        $this->test_for_create_giftcard();
        $this->browse(function (Browser $browser) {
            $browser->waitFor('#cardTable > tbody > tr.odd > td:nth-child(7) > label > div', 25)
                ->click('#cardTable > tbody > tr.odd > td:nth-child(7) > label > div')
                ->pause(5000)
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });
    }

    public function test_for_bulk_upload(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > section > div.container-fluid.p-0 > div > div.col-12 > div > div > ul > li:nth-child(2) > a')
                ->assertPathIs('/admin/giftcard/bulk-gift-card-upload')
                ->assertSee('Bulk Gift Card Upload')
                ->click('#add_product > section > div > div > div > div > form > small > small > div > div > button')
                ->assertPathIs('/admin/giftcard/bulk-gift-card-upload')
                ->assertSeeIn('#add_product > section > div > div > div > div > form > div > div > div > small > small > span', 'The file field is required.')
                ->attach('#document_file_1', __DIR__.'/files/gift_card.xlsx')
                ->click('#add_product > section > div > div > div > div > form > small > small > div > div > button')
                ->assertPathIs('/admin/giftcard/bulk-gift-card-upload')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Successfully Uploaded !!!');
                
        });
    }
}
