<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Insights\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Options;
use Twilio\Serialize;
use Twilio\Values;
use Twilio\Version;

class AnnotationContext extends InstanceContext {
    /**
     * Initialize the AnnotationContext
     *
     * @param Version $version Version that contains the resource
     * @param string $callSid The call_sid
     */
    public function __construct(Version $version, $callSid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['callSid' => $callSid, ];

        $this->uri = '/Voice/' . \rawurlencode($callSid) . '/Annotation';
    }

    /**
     * Update the AnnotationInstance
     *
     * @param array|Options $options Optional Arguments
     * @return AnnotationInstance Updated AnnotationInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(array $options = []): AnnotationInstance {
        $options = new Values($options);

        $data = Values::of([
            'AnsweredBy' => $options['answeredBy'],
            'ConnectivityIssue' => $options['connectivityIssue'],
            'QualityIssues' => $options['qualityIssues'],
            'Spam' => Serialize::booleanToString($options['spam']),
            'CallScore' => $options['callScore'],
            'Comment' => $options['comment'],
            'Incident' => $options['incident'],
        ]);

        $payload = $this->version->update('POST', $this->uri, [], $data);

        return new AnnotationInstance($this->version, $payload, $this->solution['callSid']);
    }

    /**
     * Fetch the AnnotationInstance
     *
     * @return AnnotationInstance Fetched AnnotationInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): AnnotationInstance {
        $payload = $this->version->fetch('GET', $this->uri);

        return new AnnotationInstance($this->version, $payload, $this->solution['callSid']);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Insights.V1.AnnotationContext ' . \implode(' ', $context) . ']';
    }
}