

<?php $__env->startSection('content'); ?>

<div class="aiz-titlebar text-left mt-2 mb-3">
	<div class="align-items-center">
		<h1 class="h3"><?php echo e(translate('Attribute Detail')); ?></h1>
	</div>
</div>

<div class="row">
    <!-- Small table -->
    <div class="<?php if(auth()->user()->can('add_product_attribute_values')): ?> col-lg-7 <?php else: ?> col-lg-12 <?php endif; ?>">
        <div class="card">
            <div class="card-header">
                <strong class="card-title">
                    <?php echo e($attribute->getTranslation('name')); ?>

                </strong>
            </div>

            <div class="card-body">
                <table class="table aiz-table mb-0">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th><?php echo e(translate('Value')); ?></th>
                            <th class="text-right"><?php echo e(translate('Action')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $all_attribute_values; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $attribute_value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($key+1); ?></td>
                            <td>
                                <?php echo e($attribute_value->value); ?>

                            </td>

                            <td class="text-right">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit_product_attribute_value')): ?>
                                    <a class="btn btn-soft-primary btn-icon btn-circle btn-sm" href="<?php echo e(route('edit-attribute-value', ['id'=>$attribute_value->id] )); ?>" title="<?php echo e(translate('Edit')); ?>">
                                        <i class="las la-edit"></i>
                                    </a>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete_product_attribute_value')): ?>
                                    <a href="#" class="btn btn-soft-danger btn-icon btn-circle btn-sm confirm-delete" data-href="<?php echo e(route('destroy-attribute-value', $attribute_value->id)); ?>" title="<?php echo e(translate('Delete')); ?>">
                                        <i class="las la-trash"></i>
                                    </a>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>

    </div>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('add_product_attribute_values')): ?>
        <div class="col-md-5">
            <div class="card">
                <div class="card-header">
                        <h5 class="mb-0 h6"><?php echo e(translate('Add New Attribute Value')); ?></h5>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(route('store-attribute-value')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="form-group mb-3">
                            <label for="name"><?php echo e(translate('Attribute Name')); ?></label>
                            <input type="hidden" name="attribute_id" value="<?php echo e($attribute->id); ?>">
                            <input type="text" placeholder="<?php echo e(translate('Name')); ?>" name="name" value="<?php echo e($attribute->name); ?>"class="form-control" readonly>
                        </div>
                        <div class="form-group mb-3">
                            <label for="name"><?php echo e(translate('Attribute Value')); ?></label>
                            <input type="text" placeholder="<?php echo e(translate('Name')); ?>" id="value" name="value" class="form-control" required>
                        </div>
                        <div class="form-group mb-3 text-right">
                            <button type="submit" class="btn btn-primary"><?php echo e(translate('Save')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
    <?php echo $__env->make('modals.delete_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/smartch/www/resources/views/backend/product/attribute/attribute_value/index.blade.php ENDPATH**/ ?>